=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Mai - Package for language Maithili

=cut

package Locale::CLDR::Locales::Mai;
# This file auto generated from Data\common\main\mai.xml
#	on Sun 25 Feb 10:41:40 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.44.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'ab' => 'अबखाजियान',
 				'ace' => 'ऐचिनीज',
 				'ada' => 'अदेंग',
 				'ady' => 'अदिगे',
 				'af' => 'अफ्रीकांस',
 				'agq' => 'अगेम',
 				'ain' => 'आयू',
 				'ak' => 'अकेन',
 				'ale' => 'अल्यूट',
 				'alt' => 'दक्षिणी अलटाई',
 				'am' => 'अम्हरिक',
 				'an' => 'अरगोनीज',
 				'ann' => 'ओबोलो',
 				'anp' => 'अंगिका',
 				'ar' => 'अरबी',
 				'ar_001' => 'आधुनिक मानक अरबी',
 				'arn' => 'मापुचे',
 				'arp' => 'अरापहो',
 				'ars' => 'नजदी अरबी',
 				'as' => 'असमी',
 				'asa' => 'असु',
 				'ast' => 'अस्तुरियाई',
 				'atj' => 'अतिकामेक',
 				'av' => 'अवरिक',
 				'awa' => 'अवधी',
 				'ay' => 'आयमरा',
 				'az' => 'अजरबैजानी',
 				'az@alt=short' => 'अजेरी',
 				'ba' => 'बशकीर',
 				'ban' => 'बाली',
 				'bas' => 'बासा',
 				'be' => 'बेलारूसी',
 				'bem' => 'बेम्बा',
 				'bez' => 'बेना',
 				'bg' => 'बुलगेरियाई',
 				'bho' => 'भोजपुरी',
 				'bi' => 'बिसलामा',
 				'bin' => 'बिनी',
 				'bla' => 'सिकसिका',
 				'bm' => 'बमबारा',
 				'bn' => 'बंगाली',
 				'bo' => 'तिब्बती',
 				'br' => 'ब्रेटन',
 				'brx' => 'बोडो',
 				'bs' => 'बोसनियाई',
 				'bug' => 'बगिनीज',
 				'byn' => 'बलिन',
 				'ca' => 'केटालान',
 				'cay' => 'केयुगा',
 				'ccp' => 'चकमा',
 				'ce' => 'चेचेन',
 				'ceb' => 'सेबुयानो',
 				'cgg' => 'चिजिया',
 				'ch' => 'चमोरो',
 				'chk' => 'चुकीज',
 				'chm' => 'मारी',
 				'cho' => 'चोकटाउ',
 				'chp' => 'चिपवायन',
 				'chr' => 'चेरोकी',
 				'chy' => 'शयेन',
 				'ckb' => 'सेंट्रल कुर्दी',
 				'ckb@alt=menu' => 'कुर्दी, सेंट्रल',
 				'ckb@alt=variant' => 'कुर्दी, सोरानी',
 				'clc' => 'चोकोटिन',
 				'co' => 'कोर्शियाई',
 				'crg' => 'मिचिफ',
 				'crj' => 'दक्षिण-पुरबी क्री',
 				'crk' => 'प्लेंस क्री',
 				'crl' => 'उत्तर-पूरबी क्री',
 				'crm' => 'मूज क्री',
 				'crr' => 'केरोलिना अलगोनकुइन',
 				'cs' => 'चेक',
 				'csw' => 'स्वम्पी क्री',
 				'cv' => 'शुवास',
 				'cy' => 'बेल्श',
 				'da' => 'डेनिश',
 				'dak' => 'डकोटा',
 				'dar' => 'डर्गबा',
 				'dav' => 'टैटा',
 				'de' => 'जर्मन',
 				'de_AT' => 'ऑस्ट्रियाई जर्मन',
 				'de_CH' => 'स्विस उच्च जर्मन',
 				'dgr' => 'डोग्रीब',
 				'dje' => 'जरमा',
 				'doi' => 'डोगरी',
 				'dsb' => 'लोअर सोर्बियाई',
 				'dua' => 'डुआला',
 				'dv' => 'डिबेही',
 				'dyo' => 'जोला-फोनी',
 				'dz' => 'जोनखा',
 				'dzg' => 'दजागा',
 				'ebu' => 'एमबु',
 				'ee' => 'इयु',
 				'efi' => 'एफिक',
 				'eka' => 'एकाजुक',
 				'el' => 'यूनानी',
 				'en' => 'अंगरेजी',
 				'en_AU' => 'आस्ट्रेलियाई अंंगरेजी',
 				'en_CA' => 'कनाडाई अंग्रेज़ी',
 				'en_GB' => 'ब्रिटिश अंग्रेज़ी',
 				'en_GB@alt=short' => 'यू॰के॰ अंग्रेज़ी',
 				'en_US' => 'अमेरिकी अंग्रेज़ी',
 				'eo' => 'एसपेरेंटो',
 				'es' => 'स्पेनिश',
 				'es_419' => 'लैटिन अमेरिकी स्पेनिश',
 				'es_ES' => 'यूरोपीय स्पेनिश',
 				'es_MX' => 'मैक्सिकन स्पेनिश',
 				'et' => 'एसटोनियाई',
 				'eu' => 'बास्क',
 				'ewo' => 'इवोनडो',
 				'fa' => 'परसियन',
 				'fa_AF' => 'परसियन डारी',
 				'ff' => 'फुलाह',
 				'fi' => 'फिनिश',
 				'fil' => 'फिलिपीनो',
 				'fj' => 'फिजी',
 				'fo' => 'फेरोइज',
 				'fon' => 'फोन',
 				'fr' => 'फ़्रेंच',
 				'fr_CA' => 'कनाडाई फ़्रेंच',
 				'fr_CH' => 'स्विस फ़्रेंच',
 				'frc' => 'केजन फ्रांसीसी',
 				'fur' => 'फ्रियूयन',
 				'fy' => 'पश्चिमी फ्रीजन',
 				'ga' => 'आइरिश',
 				'gaa' => 'गा',
 				'gd' => 'स्काउटिस गेलिक',
 				'gez' => 'गीज',
 				'gil' => 'गिलबर्टीज',
 				'gl' => 'गेलिशियन',
 				'gn' => 'गुआरानी',
 				'gor' => 'गोरोंटेलो',
 				'gsw' => 'स्वीस जर्मन',
 				'gu' => 'गुजराती',
 				'guz' => 'गुसी',
 				'gv' => 'मेंक्स',
 				'gwi' => 'गुअचीन',
 				'ha' => 'हउसा',
 				'hai' => 'हैदा',
 				'haw' => 'हवाईयन',
 				'hax' => 'दक्षिणी हैदा',
 				'he' => 'हीब्रू',
 				'hi' => 'हिन्दी',
 				'hil' => 'हिलिगेनन',
 				'hmn' => 'मौंग',
 				'hr' => 'क्रोशियाई',
 				'hsb' => 'उच्च सोर्बियाई',
 				'ht' => 'हैतियाई क्रियोल',
 				'hu' => 'हंगेरियन',
 				'hup' => 'हुपा',
 				'hur' => 'हलकोमैलेम',
 				'hy' => 'अर्मेनियाई',
 				'hz' => 'हैरेरो',
 				'ia' => 'इंटरलिंगुआ',
 				'iba' => 'इबन',
 				'ibb' => 'इबिबियो',
 				'id' => 'इंडोनेशियाई',
 				'ig' => 'इगबो',
 				'ii' => 'सिचुआन यी',
 				'ikt' => 'पश्चिमी कनाडाई इनुकतुत',
 				'ilo' => 'इलोको',
 				'inh' => 'इंगुश',
 				'io' => 'ईडो',
 				'is' => 'आइसलैंडी',
 				'it' => 'इतालवी',
 				'iu' => 'इनुकतितुत',
 				'ja' => 'जापानी',
 				'jbo' => 'लोजबन',
 				'jgo' => 'नेगोमबा',
 				'jmc' => 'मैकेम',
 				'jv' => 'जावानी',
 				'ka' => 'जार्जियाई',
 				'kab' => 'कबाइल',
 				'kac' => 'कचिन',
 				'kaj' => 'जू',
 				'kam' => 'कामबा',
 				'kbd' => 'कबर्दियन',
 				'kcg' => 'टियाप',
 				'kde' => 'मकोंडे',
 				'kea' => 'काबुबरदियानु',
 				'kfo' => 'कोरो',
 				'kgp' => 'कैनगैंग',
 				'kha' => 'खासी',
 				'khq' => 'कोयरा चीनी',
 				'ki' => 'किकुयू',
 				'kj' => 'कुअनयामा',
 				'kk' => 'कजाक',
 				'kkj' => 'काको',
 				'kl' => 'कलालिसुत',
 				'kln' => 'केलैंजिन',
 				'km' => 'खमेर',
 				'kmb' => 'किमबुंडू',
 				'kn' => 'कन्नड़',
 				'ko' => 'कोरियाई',
 				'kok' => 'कोंकणी',
 				'kpe' => 'कपैले',
 				'kr' => 'कनुरी',
 				'krc' => 'करचय-बालकर',
 				'krl' => 'केरैलियन',
 				'kru' => 'कुरूक',
 				'ks' => 'कशमीरी',
 				'ksb' => 'शमबाला',
 				'ksf' => 'बाफिया',
 				'ksh' => 'कोलोनियन',
 				'ku' => 'कुर्दी',
 				'kum' => 'कुमिक',
 				'kv' => 'कोमी',
 				'kw' => 'कोर्निश',
 				'kwk' => 'कुअकवाला',
 				'ky' => 'किर्गिज',
 				'la' => 'लातिन',
 				'lad' => 'लडीनो',
 				'lag' => 'लंगी',
 				'lb' => 'लगजमबर्गी',
 				'lez' => 'लजगियान',
 				'lg' => 'गंडा',
 				'li' => 'लिमबर्गिश',
 				'lil' => 'लिलुइट',
 				'lkt' => 'लकोटा',
 				'ln' => 'लिंगाला',
 				'lo' => 'लाओ',
 				'lou' => 'लुइसियाना क्रियोल',
 				'loz' => 'लोजी',
 				'lrc' => 'उत्तरी लूरी',
 				'lsm' => 'सामिया',
 				'lt' => 'लिथुआनियाई',
 				'lu' => 'लुबा-कटांगा',
 				'lua' => 'लुबा-लुलुआ',
 				'lun' => 'लुंडा',
 				'luo' => 'लुओ',
 				'lus' => 'मिजो',
 				'luy' => 'लुुइया',
 				'lv' => 'लातवियाई',
 				'mad' => 'मदुरीज',
 				'mag' => 'मगही',
 				'mai' => 'मैथिली',
 				'mak' => 'मकसर',
 				'mas' => 'मसाई',
 				'mdf' => 'मोकशा',
 				'men' => 'मेंडे',
 				'mer' => 'मेरू',
 				'mfe' => 'मोरीसेन',
 				'mg' => 'मलगासी',
 				'mgh' => 'मखुआ-मेटो',
 				'mgo' => 'मेटा',
 				'mh' => 'मार्शेलीज',
 				'mi' => 'माओरी',
 				'mic' => 'मिकमक',
 				'min' => 'मिननकबाऊ',
 				'mk' => 'मेसिडोनियाई',
 				'ml' => 'मलयालम',
 				'mn' => 'मोंगोलियाई',
 				'mni' => 'मणिपुरी',
 				'moe' => 'इनु-ऐमन',
 				'moh' => 'मोहौक',
 				'mos' => 'मोसी',
 				'mr' => 'मराठी',
 				'ms' => 'मलय',
 				'mt' => 'मलटीज',
 				'mua' => 'मुंडांग',
 				'mul' => 'एक सं बेसी भाषा',
 				'mus' => 'मसकोगी',
 				'mwl' => 'मिरंडीज',
 				'my' => 'बर्मी',
 				'myv' => 'अरजाया',
 				'mzn' => 'मजनदेरानी',
 				'na' => 'नउरू',
 				'nap' => 'नेपोलिटन',
 				'naq' => 'नामा',
 				'nb' => 'नार्वेजियन बोकमाल',
 				'nd' => 'उत्तरी डेबले',
 				'nds' => 'लो जर्मन',
 				'ne' => 'नेपाली',
 				'new' => 'नेबारी',
 				'ng' => 'एनडोंगा',
 				'nia' => 'नियास',
 				'niu' => 'नियुएन',
 				'nl' => 'डच',
 				'nl_BE' => 'फ्लेमिश',
 				'nmg' => 'कवासियो',
 				'nn' => 'नार्वेजियन निनोरेस्क',
 				'nnh' => 'जियमबून',
 				'no' => 'नार्वेजियन',
 				'nog' => 'नोगई',
 				'nqo' => 'एनको',
 				'nr' => 'दक्षिणी एनडेबेले',
 				'nso' => 'उत्तरी सोथो',
 				'nus' => 'नूअर',
 				'nv' => 'नवाजो',
 				'ny' => 'नींजा',
 				'nyn' => 'नीयनकोले',
 				'oc' => 'औकसीटान',
 				'ojb' => 'उत्तरी-पश्चिम ओजिवा',
 				'ojc' => 'सेंट्रल ओजिबा',
 				'ojs' => 'ओजि-क्री',
 				'ojw' => 'पश्चिमी ओजिबा',
 				'oka' => 'ओकंगान',
 				'om' => 'ओरोमो',
 				'or' => 'उड़िया',
 				'os' => 'ओसेटिक',
 				'pa' => 'पंजाबी',
 				'pag' => 'पैंगासिनान',
 				'pam' => 'पैमपंगा',
 				'pap' => 'पैपियामेंटो',
 				'pau' => 'पलौआन',
 				'pcm' => 'नाइजीरियाई पिजिन',
 				'pis' => 'पिजिन',
 				'pl' => 'पोलिश',
 				'pqm' => 'मलिसीट-पैसमाकोडी',
 				'ps' => 'पश्तो',
 				'pt' => 'पुर्तगाली',
 				'pt_BR' => 'ब्राज़ीली पुर्तगाली',
 				'pt_PT' => 'यूरोपीय पुर्तगाली',
 				'qu' => 'कुएचुआ',
 				'rap' => 'रपानुई',
 				'rar' => 'रेरोटोंगन',
 				'rhg' => 'रोहिंग्या',
 				'rm' => 'रोमांश',
 				'rn' => 'रूंडी',
 				'ro' => 'रोमानियाई',
 				'rof' => 'रोमबो',
 				'ru' => 'रूसी',
 				'rup' => 'अरोमानियाई',
 				'rw' => 'किनयरवांडा',
 				'rwk' => 'रूवा',
 				'sa' => 'संस्कृत',
 				'sad' => 'संदाउ',
 				'sah' => 'सखा',
 				'saq' => 'समबुरू',
 				'sat' => 'संथाली',
 				'sba' => 'नामबे',
 				'sbp' => 'सांगू',
 				'sc' => 'सार्डिनियाई',
 				'scn' => 'सिसिलियाई',
 				'sco' => 'स्काउट्स',
 				'sd' => 'सिंधी',
 				'se' => 'उत्तरी सामी',
 				'seh' => 'सेना',
 				'ses' => 'कोयराबोरो सैनी',
 				'sg' => 'सांगो',
 				'shi' => 'टेचलहिट',
 				'shn' => 'शान',
 				'si' => 'सिंहला',
 				'sk' => 'स्लोबाक',
 				'sl' => 'स्लोबेनियाई',
 				'slh' => 'दक्षिणी लसूटसीड',
 				'sm' => 'समोअन',
 				'smn' => 'इनारी सामी',
 				'sms' => 'स्कोल्ट समी',
 				'sn' => 'शोना',
 				'snk' => 'सोनिनके',
 				'so' => 'सोमाली',
 				'sq' => 'अलबानिया',
 				'sr' => 'सर्बियाई',
 				'srn' => 'श्रेनन टोंगो',
 				'ss' => 'स्वाती',
 				'st' => 'दक्षिणी सोथो',
 				'str' => 'स्ट्रेट्स सैलिस',
 				'su' => 'सुंदनेजे',
 				'suk' => 'सुकुमा',
 				'sv' => 'स्वीडिश',
 				'sw' => 'स्वाहिलि',
 				'swb' => 'कोमोरायन',
 				'syr' => 'सीरियक',
 				'ta' => 'तमिल',
 				'tce' => 'दक्षिणी टोचेन',
 				'te' => 'तेलगू',
 				'tem' => 'टिमने',
 				'teo' => 'टेसो',
 				'tet' => 'टैटम',
 				'tg' => 'ताजिक',
 				'tgx' => 'टेगिश',
 				'th' => 'थाई',
 				'tht' => 'टालटन',
 				'ti' => 'टिगरिनया',
 				'tig' => 'टिगरे',
 				'tk' => 'तुर्कमैन',
 				'tlh' => 'किलिंगौन',
 				'tli' => 'टिलिंगिट',
 				'tn' => 'टुआना',
 				'to' => 'टोंगन',
 				'tok' => 'टोकी पोना',
 				'tpi' => 'टोक पिसिन',
 				'tr' => 'टर्किश',
 				'trv' => 'टरोको',
 				'ts' => 'शोंगा',
 				'tt' => 'ततार',
 				'ttm' => 'उत्तरी टचोन',
 				'tum' => 'टुमबुका',
 				'tvl' => 'टुवालू',
 				'twq' => 'टासावाक',
 				'ty' => 'ताहितियन',
 				'tyv' => 'टुविनियन',
 				'tzm' => 'सेंट्रल एटलस टेमेजिघ',
 				'udm' => 'उदमुर्त',
 				'ug' => 'उइगर',
 				'uk' => 'यूक्रेनी',
 				'umb' => 'उमबुंदू',
 				'und' => 'अज्ञात भाषा',
 				'ur' => 'उर्दू',
 				'uz' => 'उजबेक',
 				'vai' => 'बाई',
 				've' => 'बेंदा',
 				'vi' => 'बियतनामी',
 				'vun' => 'बुंजो',
 				'wa' => 'बलून',
 				'wae' => 'बालसर',
 				'wal' => 'बोलेटा',
 				'war' => 'बरय',
 				'wo' => 'बोलोफ',
 				'wuu' => 'ऊ चीनी',
 				'xal' => 'कलमिक',
 				'xh' => 'खोसा',
 				'xog' => 'सोगा',
 				'yav' => 'यंगबैन',
 				'ybb' => 'येमबा',
 				'yi' => 'ईडिश',
 				'yo' => 'योरूबा',
 				'yrl' => 'एनहींगाटु',
 				'yue' => 'केंटोनी',
 				'yue@alt=menu' => 'चीनी, केंटोनी',
 				'zgh' => 'मानक मोरोक्कन टेमेजिग्थ',
 				'zh' => 'चीनी',
 				'zh@alt=menu' => 'चीनी, मैंडेरिन',
 				'zh_Hans' => 'सरलीकृत चीनी',
 				'zh_Hans@alt=long' => 'सरलीकृत मैंडेरिन चीनी',
 				'zh_Hant' => 'पारंपरिक चीनी',
 				'zh_Hant@alt=long' => 'पारंपरिक मैंडेरिन चीनी',
 				'zu' => 'जुलू',
 				'zun' => 'जूनी',
 				'zxx' => 'कुनु भाषाई सामग्री नहि',
 				'zza' => 'जाजा',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Adlm' => 'अदलाम',
 			'Arab' => 'अरबी',
 			'Aran' => 'नास्तलिक',
 			'Armn' => 'आर्मेनियाई',
 			'Beng' => 'बंगाली',
 			'Bopo' => 'बोपोमोफो',
 			'Brai' => 'ब्रेल',
 			'Cakm' => 'चकमा',
 			'Cans' => 'यूनिफाइड कनाडियम एबोरिजनल सिलेबिक्स',
 			'Cher' => 'चेरोकी',
 			'Cyrl' => 'सिरिलिक',
 			'Deva' => 'देवनागरी',
 			'Ethi' => 'इथोपिक',
 			'Geor' => 'जार्जियन',
 			'Grek' => 'यूनानी',
 			'Gujr' => 'गुजराती',
 			'Guru' => 'गुरमुखी',
 			'Hanb' => 'बोपोमोफो कें संग हान',
 			'Hang' => 'हंगुल',
 			'Hani' => 'हान',
 			'Hans' => 'सरलीकृत',
 			'Hans@alt=stand-alone' => 'सरलीकृत हान',
 			'Hant' => 'पारंपरिक',
 			'Hant@alt=stand-alone' => 'पारंपरिक हान',
 			'Hebr' => 'हीब्रू',
 			'Hira' => 'हीरागना',
 			'Hrkt' => 'जापानी शब्दांश',
 			'Jamo' => 'जमो',
 			'Jpan' => 'जापानी',
 			'Kana' => 'कटाकाना',
 			'Khmr' => 'कुमेर',
 			'Knda' => 'कन्नड़',
 			'Kore' => 'कोरियाई',
 			'Laoo' => 'लाओ',
 			'Latn' => 'लातिन',
 			'Mlym' => 'मलयालम',
 			'Mong' => 'मंंगोलियन',
 			'Mtei' => 'मैती मायेक',
 			'Mymr' => 'मयनमार',
 			'Nkoo' => 'एनको',
 			'Olck' => 'ओल चिकी',
 			'Orya' => 'उड़िया',
 			'Rohg' => 'हनिफी',
 			'Sinh' => 'सिंहला',
 			'Sund' => 'सुंडानीज',
 			'Syrc' => 'सीरियक',
 			'Taml' => 'तमिल',
 			'Telu' => 'तेलुगू',
 			'Tfng' => 'टिफिनघ',
 			'Thaa' => 'थाना',
 			'Thai' => 'थाई',
 			'Tibt' => 'तिब्बती',
 			'Vaii' => 'बाई',
 			'Yiii' => 'यी',
 			'Zmth' => 'गणितीय संकेतन',
 			'Zsye' => 'इमोजी',
 			'Zsym' => 'संकेत',
 			'Zxxx' => 'अलिखित',
 			'Zyyy' => 'सामान्य',
 			'Zzzz' => 'अज्ञात लिपि',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'विश्व',
 			'002' => 'अफ्रीका',
 			'003' => 'उत्तरी अमेरिका',
 			'005' => 'दक्षिण अमेरिका',
 			'009' => 'ओसेनिया',
 			'011' => 'पश्चिमी अफ्रीका',
 			'013' => 'मध्य अमेरिका',
 			'014' => 'पूरबी अफ्रीका',
 			'015' => 'उत्तरी अफ्रीका',
 			'017' => 'मध्य अफ्रीका',
 			'018' => 'दक्षिणी अफ्रीका',
 			'019' => 'अमेरिका',
 			'021' => 'उत्तर अमेरिका',
 			'029' => 'कैरिबियाई',
 			'030' => 'पूरबी एशिया',
 			'034' => 'दक्षिणी एशिया',
 			'035' => 'दक्षिण-पूरबी एशिया',
 			'039' => 'दक्षिणी यूरोप',
 			'053' => 'आस्ट्रेलेशिया',
 			'054' => 'मेलानेशिया',
 			'057' => 'माइक्रोनेशियाई क्षेत्र',
 			'061' => 'पोलिनेशिया',
 			'142' => 'एशिया',
 			'143' => 'मध्य एशिया',
 			'145' => 'पश्चिमी एशिया',
 			'150' => 'यूरोप',
 			'151' => 'पूरबी यूरोप',
 			'154' => 'उत्तरी यूरोप',
 			'155' => 'पश्चिमी यूरोप',
 			'202' => 'उप सहारा अफ्रीका',
 			'419' => 'लातिन अमेरिका',
 			'AC' => 'असेंशन द्वीप',
 			'AD' => 'एंडोरा',
 			'AE' => 'संयुक्त अरब अमीरात',
 			'AF' => 'अफगानिस्तान',
 			'AG' => 'एंटिगुआ आ बारबुडा',
 			'AI' => 'एंग्विला',
 			'AL' => 'अलबानिया',
 			'AM' => 'आरमेनिया',
 			'AO' => 'अंगोला',
 			'AQ' => 'अंटार्टिका',
 			'AR' => 'अर्जेंटिना',
 			'AS' => 'अमेरिकी समोआ',
 			'AT' => 'आस्ट्रिया',
 			'AU' => 'आस्ट्रेलिया',
 			'AW' => 'अरूबा',
 			'AX' => 'अलैंड द्वीपसमूह',
 			'AZ' => 'अजरबैजान',
 			'BA' => 'बोस्निया आ हर्जेगोबिना',
 			'BB' => 'बारबाडोस',
 			'BD' => 'बंगलादेश',
 			'BE' => 'बेल्जियम',
 			'BF' => 'बुरकिना फासो',
 			'BG' => 'बुल्गारिया',
 			'BH' => 'बहरीन',
 			'BI' => 'बुरूंडी',
 			'BJ' => 'बेनिन',
 			'BL' => 'सेंट बार्थेलेमी',
 			'BM' => 'बरमुडा',
 			'BN' => 'ब्रूनेई',
 			'BO' => 'बोलिबिया',
 			'BQ' => 'कैरिबियाई नीदरलैंड',
 			'BR' => 'ब्राज़ील',
 			'BS' => 'बहामास',
 			'BT' => 'भूटान',
 			'BV' => 'बोबेत द्वीप',
 			'BW' => 'बोत्सबाना',
 			'BY' => 'बेलारूस',
 			'BZ' => 'बेलीज',
 			'CA' => 'कनाडा',
 			'CC' => 'कोकेज (कीलिंग) द्वीपसमूह',
 			'CD' => 'कांगो-किंशासा',
 			'CD@alt=variant' => 'कांगो(डीआरसी)',
 			'CF' => 'मध्य अफ्रीकी रिपब्लिक',
 			'CG' => 'कांगो-ब्राजाबिले',
 			'CG@alt=variant' => 'कांगो (रिपब्लिक)',
 			'CH' => 'स्विट्जरलैंड',
 			'CI' => 'कोट डी आइवर',
 			'CI@alt=variant' => 'आइवरी कोस्ट',
 			'CK' => 'कुक द्वीपसमूह',
 			'CL' => 'चिली',
 			'CM' => 'कैमरून',
 			'CN' => 'चीन',
 			'CO' => 'कोलंबिया',
 			'CP' => 'क्लिपर्टन द्वीप',
 			'CR' => 'कोस्टारिका',
 			'CU' => 'क्यूबा',
 			'CV' => 'कैप बर्डे',
 			'CW' => 'कुरासाओ',
 			'CX' => 'क्रिसमस द्वीप',
 			'CY' => 'साइप्रस',
 			'CZ' => 'चेकिया',
 			'CZ@alt=variant' => 'चेक रिपब्लिक',
 			'DE' => 'जर्मनी',
 			'DG' => 'डियागो गार्सिया',
 			'DJ' => 'जिबूति',
 			'DK' => 'डेनमार्क',
 			'DM' => 'डोमिनिका',
 			'DO' => 'डोमिनिकन रिपब्लिक',
 			'DZ' => 'अल्जीरिया',
 			'EA' => 'सेउटा आ मेलिला',
 			'EC' => 'इक्वाडोर',
 			'EE' => 'एस्टोनिया',
 			'EG' => 'मिस्र',
 			'EH' => 'पश्चिमी सहारा',
 			'ER' => 'एरिट्रिया',
 			'ES' => 'स्पेन',
 			'ET' => 'इथोपिया',
 			'EU' => 'यूरोपीय यूनियन',
 			'EZ' => 'यूरो जोन',
 			'FI' => 'फिनलैंड',
 			'FJ' => 'फिजी',
 			'FK' => 'फाकलैंड द्वीपसमूह',
 			'FK@alt=variant' => 'फाकलैंड द्वीपसमूह (इजलास माल्बिनास)',
 			'FM' => 'माइक्रोनेशिया',
 			'FO' => 'फेरो द्वीपसमूह',
 			'FR' => 'फ़्रांस',
 			'GA' => 'गैबन',
 			'GB' => 'यूनाइटेड किंगडम',
 			'GB@alt=short' => 'यू॰के॰',
 			'GD' => 'ग्रेनाडा',
 			'GE' => 'जार्जिया',
 			'GF' => 'फ्रेंच गुयाना',
 			'GG' => 'गर्नसी',
 			'GH' => 'घाना',
 			'GI' => 'जिब्राल्टर',
 			'GL' => 'ग्रीनलैंड',
 			'GM' => 'गाम्बिया',
 			'GN' => 'गिनी',
 			'GP' => 'ग्वाडेलूप',
 			'GQ' => 'इक्वेटोरियल गिनी',
 			'GR' => 'यूनान',
 			'GS' => 'दक्षिण जार्जिया आ दक्षिण सैंडविच द्वीपसमूह',
 			'GT' => 'ग्वाटेमाला',
 			'GU' => 'गुआम',
 			'GW' => 'गिनी-बिसाऊ',
 			'GY' => 'गुयाना',
 			'HK' => 'हांग कांग (विशेष प्रशासनिक क्षेत्र चीन)',
 			'HK@alt=short' => 'हांग कांग',
 			'HM' => 'हर्ड आ मैकडोनल्ड द्वीपसमूह',
 			'HN' => 'होंडुरास',
 			'HR' => 'क्रोएशिया',
 			'HT' => 'हैती',
 			'HU' => 'हंगरी',
 			'IC' => 'कैनरी द्वीपसमूह',
 			'ID' => 'इंडोनेशिया',
 			'IE' => 'आयरलैंड',
 			'IL' => 'इजरायल',
 			'IM' => 'आइल ऑफ मैन',
 			'IN' => 'भारत',
 			'IO' => 'ब्रिटिश हिंद महासागरीय क्षेत्र',
 			'IQ' => 'इराक',
 			'IR' => 'ईरान',
 			'IS' => 'आइसलैंड',
 			'IT' => 'इटली',
 			'JE' => 'जरसी',
 			'JM' => 'जमैका',
 			'JO' => 'जार्डन',
 			'JP' => 'जापान',
 			'KE' => 'केन्या',
 			'KG' => 'किर्गिजस्तान',
 			'KH' => 'कंबोडिया',
 			'KI' => 'किरिबाती',
 			'KM' => 'कोमोरोस',
 			'KN' => 'सेंट किट्स आ नेविस',
 			'KP' => 'उत्तर कोरिया',
 			'KR' => 'दक्षिण कोरिया',
 			'KW' => 'कुवैत',
 			'KY' => 'कैमेन द्वीपसमूह',
 			'KZ' => 'कजाखस्तान',
 			'LA' => 'लाओस',
 			'LB' => 'लेबनान',
 			'LC' => 'सेंट लूसिया',
 			'LI' => 'लिख्तेंस्ताइन',
 			'LK' => 'श्रीलंका',
 			'LR' => 'लाइबेरिया',
 			'LS' => 'लेसोथो',
 			'LT' => 'लिथुआनिया',
 			'LU' => 'लग्जमबर्ग',
 			'LV' => 'लातविया',
 			'LY' => 'लीबिया',
 			'MA' => 'मोरोक्को',
 			'MC' => 'मोनाको',
 			'MD' => 'मोलडोवा',
 			'ME' => 'मोंटेनीग्रो',
 			'MF' => 'सेंट मार्टिन',
 			'MG' => 'मेडागास्कर',
 			'MH' => 'मार्शल द्वीपसमूह',
 			'MK' => 'उत्तरी मकदूनिया',
 			'ML' => 'माली',
 			'MM' => 'मयनमार (बर्मा)',
 			'MN' => 'मंगोलिया',
 			'MO' => 'मकाउ (विशेष प्रशासनिक क्षेत्र चीन)',
 			'MO@alt=short' => 'मकाउ',
 			'MP' => 'उत्तर मरीना द्वीपसमूह',
 			'MQ' => 'मार्टिनिक',
 			'MR' => 'मारिटानिया',
 			'MS' => 'मोंटसेरात',
 			'MT' => 'माल्टा',
 			'MU' => 'मारीशस',
 			'MV' => 'मालदीब',
 			'MW' => 'मलाबी',
 			'MX' => 'मैक्सिको',
 			'MY' => 'मलेशिया',
 			'MZ' => 'मोजाम्बिक',
 			'NA' => 'नामीबिया',
 			'NC' => 'न्यू कैलेडोनिया',
 			'NE' => 'नाइजर',
 			'NF' => 'नौरफोक द्वीप',
 			'NG' => 'नाइजीरिया',
 			'NI' => 'निकारागुआ',
 			'NL' => 'नीदरलैंड',
 			'NO' => 'नार्वे',
 			'NP' => 'नेपाल',
 			'NR' => 'नौरू',
 			'NU' => 'नीयू',
 			'NZ' => 'न्यूजीलैंड',
 			'OM' => 'ओमान',
 			'PA' => 'पनामा',
 			'PE' => 'पेरू',
 			'PF' => 'फ्रेंच पोलिनेशिया',
 			'PG' => 'पापुआ न्यू गिनी',
 			'PH' => 'फिलिपींस',
 			'PK' => 'पाकिस्तान',
 			'PL' => 'पोलैंड',
 			'PM' => 'सेंट पियरे आ मिक्वेलान',
 			'PN' => 'पिटकेयर्न द्वीपसमूह',
 			'PR' => 'प्योर्टो रिको',
 			'PS' => 'फिलिस्तीनी क्षेत्र',
 			'PS@alt=short' => 'फिलिस्तीन',
 			'PT' => 'पुर्तगाल',
 			'PW' => 'पलाऊ',
 			'PY' => 'पराग्वे',
 			'QA' => 'कतर',
 			'QO' => 'आउटलाइंग ओसेनिया',
 			'RE' => 'रियूनियन',
 			'RO' => 'रोमानिया',
 			'RS' => 'सर्बिया',
 			'RU' => 'रूस',
 			'RW' => 'रवांडा',
 			'SA' => 'सऊदी अरब',
 			'SB' => 'सोलोमन द्वीपसमूह',
 			'SC' => 'सेशेल्स',
 			'SD' => 'सूडान',
 			'SE' => 'स्वीडन',
 			'SG' => 'सिंगापुर',
 			'SH' => 'सेंट हेलेना',
 			'SI' => 'स्लोबेनिया',
 			'SJ' => 'स्वालबार्ड आ जान मायेन',
 			'SK' => 'स्लोवाकिया',
 			'SL' => 'सियरा लियोन',
 			'SM' => 'सेन मरीनो',
 			'SN' => 'सेनेगल',
 			'SO' => 'सोमालिया',
 			'SR' => 'सुरीनाम',
 			'SS' => 'दक्षिण सुडान',
 			'ST' => 'साओ टोम आ प्रिंसिप',
 			'SV' => 'अल सल्वाडोर',
 			'SX' => 'सिंट मार्टेन',
 			'SY' => 'सीरिया',
 			'SZ' => 'एस्वाटिनी',
 			'SZ@alt=variant' => 'स्वाजीलैंड',
 			'TA' => 'ट्रिस्टन दा कुना',
 			'TC' => 'तुर्क आ कैकोज द्वीपसमूह',
 			'TD' => 'चाड',
 			'TF' => 'फ्रांसीसी दक्षिणी क्षेत्र',
 			'TG' => 'टोगो',
 			'TH' => 'थाईलैंड',
 			'TJ' => 'ताजिकिस्तान',
 			'TK' => 'टोकेलाऊ',
 			'TL' => 'तिमोर-लेस्त',
 			'TL@alt=variant' => 'पूरबी तिमोर',
 			'TM' => 'तुर्कमेनिस्तान',
 			'TN' => 'ट्यूनिशिया',
 			'TO' => 'टोंगा',
 			'TR' => 'तुर्की',
 			'TT' => 'ट्रिनिदाद आ टोबैगो',
 			'TV' => 'टुवालू',
 			'TW' => 'ताइबान',
 			'TZ' => 'तंजानिया',
 			'UA' => 'यूक्रेन',
 			'UG' => 'युगांडा',
 			'UM' => 'यू॰एस॰ आउटलाइंग द्वीपसमूह',
 			'UN' => 'संयुक्त राष्ट्र',
 			'US' => 'संयुक्त राज्य',
 			'UY' => 'उरुग्वे',
 			'UZ' => 'उजबेकिस्तान',
 			'VA' => 'वेटिकन सिटी',
 			'VC' => 'सेंट विंसेंट आ ग्रेनाडाइंस',
 			'VE' => 'बेनेजुएला',
 			'VG' => 'ब्रिटिश वर्जिन द्वीपसमूह',
 			'VI' => 'यू॰एस॰ वर्जिन द्वीपसमूह',
 			'VN' => 'बियतनाम',
 			'VU' => 'बनातू',
 			'WF' => 'बालिस आ फुटुना',
 			'WS' => 'समोआ',
 			'XA' => 'छद्म उच्चारण',
 			'XB' => 'छद्म बिडि',
 			'XK' => 'कोसोवो',
 			'YE' => 'यमन',
 			'YT' => 'मयोटे',
 			'ZA' => 'दक्षिण अफ्रीका',
 			'ZM' => 'जाम्बिया',
 			'ZW' => 'जिम्बाब्बे',
 			'ZZ' => 'अज्ञात क्षेत्र',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'कैलेंडर',
 			'cf' => 'मुद्रा प्रारूप',
 			'collation' => 'सॉर्ट क्रम',
 			'currency' => 'मुद्रा',
 			'hc' => 'घंटे का चक्र (12 बनाम 24)',
 			'lb' => 'लाइन ब्रेक का स्टाइल',
 			'ms' => 'माप प्रणाली',
 			'numbers' => 'संख्या',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{बौद्ध कैलेंडर},
 				'chinese' => q{चीनी कैलेंडर},
 				'coptic' => q{काप्टिक कैलेंडर},
 				'dangi' => q{डांगी कैलेंडर},
 				'ethiopic' => q{इथोपियाई कैलेंडर},
 				'ethiopic-amete-alem' => q{इथोपियाई एमटे अलेम कैलेंडर},
 				'gregorian' => q{ग्रेगोरियन कैलेंडर},
 				'hebrew' => q{हीब्रू कैलेंडर},
 				'indian' => q{भारतीय राष्ट्रीय कैलेंडर},
 				'islamic' => q{इस्लामिक कैलेंडर},
 				'islamic-civil' => q{इस्लामिक कैलेंडर (टैबुलर, सिविल एपेक)},
 				'islamic-umalqura' => q{इस्लामिक कैलेंडर (उम अल कुरा)},
 				'iso8601' => q{ISO-8601 कैलेंडर},
 				'japanese' => q{जापानी कैलेंडर},
 				'persian' => q{फारसी कैलेंडर},
 				'roc' => q{मिंगो कैलेंडर},
 			},
 			'cf' => {
 				'account' => q{लेखा मुद्रा प्रारूप},
 				'standard' => q{सामान्य मुद्रा प्रारूप},
 			},
 			'collation' => {
 				'ducet' => q{डिफाल्ट यूनिकोड सॉर्ट क्रम},
 				'search' => q{सामान्य प्रयोजन वाली खोज},
 				'standard' => q{मानक सॉर्ट क्रम},
 			},
 			'hc' => {
 				'h11' => q{12 घंटे वाला प्रारूप (0–11)},
 				'h12' => q{12 घंटे वाला प्रारूप (1–12)},
 				'h23' => q{24 घंटे वाला प्रारूप (0–23)},
 				'h24' => q{24 घंटे वाला प्रारूप (0–24)},
 			},
 			'lb' => {
 				'loose' => q{लाइन ब्रेक का लचीला स्टाइल},
 				'normal' => q{लाइन ब्रेक का सामान्य स्टाइल},
 				'strict' => q{लाइन ब्रेक का सख्त स्टाइल},
 			},
 			'ms' => {
 				'metric' => q{मीट्रिक प्रणाली},
 				'uksystem' => q{इम्पीरियल माप प्रणाली},
 				'ussystem' => q{अमेरिकी माप प्रणाली},
 			},
 			'numbers' => {
 				'arab' => q{अरबी-इंडिक अंक},
 				'arabext' => q{विस्तारित अरबी-इंडिक अंक},
 				'armn' => q{अर्मेनियाई संख्याएं},
 				'armnlow' => q{लोअरकेस वाले अर्मेनियाई संख्याएं},
 				'beng' => q{बंगाली अंक},
 				'cakm' => q{चकमा अंक},
 				'deva' => q{देवनागरी अंक},
 				'ethi' => q{इथोपियाई संख्याएं},
 				'fullwide' => q{पूर्ण-चौड़ाई वाले अंक},
 				'geor' => q{जार्जियाई संख्याएं},
 				'grek' => q{यूनानी संख्याएं},
 				'greklow' => q{लोअरकेस वाले यूनानी संख्याएं},
 				'gujr' => q{गूजराती अंक},
 				'guru' => q{गुरमुखी अंक},
 				'hanidec' => q{चीनी दशमलव संख्याएं},
 				'hans' => q{सरलीकृत चीनी संख्याएं},
 				'hansfin' => q{सरलीकृत चीनी बित्तीय संख्याएं},
 				'hant' => q{पारंपरिक चीनी संख्याएं},
 				'hantfin' => q{पारंपरिक चीनी बित्तीय संख्याएं},
 				'hebr' => q{हीब्रू संख्याएं},
 				'java' => q{जेवेनी अंक},
 				'jpan' => q{जापानी अंक},
 				'jpanfin' => q{जापानी बित्तीय संख्याएँ},
 				'khmr' => q{खमेर अंक},
 				'knda' => q{कन्नड़ अंक},
 				'laoo' => q{लाओ अंक},
 				'latn' => q{पश्चिमी अंक},
 				'mlym' => q{मलयाली अंक},
 				'mtei' => q{मितेई मायेक अंक},
 				'mymr' => q{मयनमार अंक},
 				'olck' => q{ओल चिकि अंक},
 				'orya' => q{उड़िया अंक},
 				'roman' => q{रोमन संख्याएँ},
 				'romanlow' => q{रोमन लोअरकेस संख्याएँ},
 				'taml' => q{पारंपरिक तमिल संख्याएँ},
 				'tamldec' => q{तमिल अंक},
 				'telu' => q{तेलुगू अंक},
 				'thai' => q{थाई अंक},
 				'tibt' => q{तिब्बती अंक},
 				'vaii' => q{बाय अंक},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{मीट्रिक},
 			'UK' => q{यूके},
 			'US' => q{यूएस},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'भाषा: {0}',
 			'script' => 'लिपि: {0}',
 			'region' => 'क्षेत्र: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[अ{अं}{अः} आ इ ई उ ऊ ऋ ऌ ॡ ए ऐ ओ औ]},
			index => ['़', 'अ{अं}{अः}', 'आ', 'इ', 'ई', 'उ', 'ऊ', 'ऋ', 'ऌ', 'ॡ', 'ए', 'ऐ', 'ओ', 'औ', 'क', '{क्ष}', 'ख', 'ग', 'घ', 'च', 'छ', 'ज', '{ज्ञ}', 'झ', 'ञ', 'ट', 'ठ', 'ड{डं}', 'ढ', 'ण', 'त', '{त्र}', 'थ', 'द', 'ध', 'न', 'प', 'फ', 'ब', 'भ', 'म', 'य', 'र', 'ल', 'व', 'श', '{श्र}', 'ष', 'स', 'ह'],
			main => qr{[़ ंः क {क्ष} ख ग घ च छ ज {ज्ञ} झ ञ ट ठ ड{डं} ढ ण त {त्र} थ द ध न प फ ब भ म य र ल व श {श्र} ष स ह ा ि ी ु ू े ै ो ौ]},
			punctuation => qr{[_ \- ‑ – — , ; \: ! ? . … '‘’ "“” ( ) \[ \] \{ \} § @ * / \\ \& # ′ ″ ` + | ~]},
		};
	},
EOT
: sub {
		return { index => ['़', 'अ{अं}{अः}', 'आ', 'इ', 'ई', 'उ', 'ऊ', 'ऋ', 'ऌ', 'ॡ', 'ए', 'ऐ', 'ओ', 'औ', 'क', '{क्ष}', 'ख', 'ग', 'घ', 'च', 'छ', 'ज', '{ज्ञ}', 'झ', 'ञ', 'ट', 'ठ', 'ड{डं}', 'ढ', 'ण', 'त', '{त्र}', 'थ', 'द', 'ध', 'न', 'प', 'फ', 'ब', 'भ', 'म', 'य', 'र', 'ल', 'व', 'श', '{श्र}', 'ष', 'स', 'ह'], };
},
);


has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:हं|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:नहि|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				end => q({0}, और {1}),
				2 => q({0} और {1}),
		} }
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'deva',
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '[#E0]',
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'BRL' => {
			display_name => {
				'currency' => q(ब्राज़ीली रियाल),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(चीनी युआन),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(यूरो),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(ब्रिटिश पाउंड स्टर्लिंग),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(भारतीय रुपया),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(जापानी येन),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(रूसी रूबल),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(यूएस डॉलर),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(अज्ञात मुद्रा),
				'other' => q(\(अज्ञात मुद्रा\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'जन॰',
							'फ़र॰',
							'मार्च',
							'अप्रैल',
							'मई',
							'जून',
							'जुल॰',
							'अग॰',
							'सित॰',
							'अक्तू॰',
							'नव॰',
							'दिस॰'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'जनवरी',
							'फरवरी',
							'मार्च',
							'अप्रैल',
							'मई',
							'जून',
							'जुलाई',
							'अगस्त',
							'सितंबर',
							'अक्तूबर',
							'नवंबर',
							'दिसंबर'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'जन॰',
							'फर॰',
							'मार्च',
							'अप्रैल',
							'मई',
							'जून',
							'जुल॰',
							'अग॰',
							'सित॰',
							'अक्तू॰',
							'नव॰',
							'दिस॰'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ज',
							'फ',
							'मा',
							'अ',
							'म',
							'जू',
							'जु',
							'अ',
							'सि',
							'अ',
							'न',
							'दि'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'जनवरी',
							'फरवरी',
							'मार्च',
							'अप्रैल',
							'मई',
							'जून',
							'जुलाई',
							'अगस्त',
							'सितंबर',
							'अक्टूबर',
							'नवंबर',
							'दिसंबर'
						],
						leap => [
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'चैत',
							'बैशाख',
							'जेठ',
							'अखाढ़',
							'सउन',
							'भादो',
							'आसिन',
							'कातिक',
							'अगहन',
							'पूस',
							'माघ',
							'फागुन'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'सोम',
						tue => 'मंगल',
						wed => 'बुध',
						thu => 'गुरु',
						fri => 'शुक्र',
						sat => 'शनि',
						sun => 'रवि'
					},
					short => {
						mon => 'सोम',
						tue => 'मंगल',
						wed => 'बुध',
						thu => 'बृहस्पति',
						fri => 'शुक्र',
						sat => 'शनि',
						sun => 'रवि'
					},
					wide => {
						mon => 'सोम दिन',
						tue => 'मंगल दिन',
						wed => 'बुध दिन',
						thu => 'बृहस्पति दिन',
						fri => 'शुक्र दिन',
						sat => 'शनि दिन',
						sun => 'रवि दिन'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'सो',
						tue => 'मं',
						wed => 'बु',
						thu => 'गु',
						fri => 'शु',
						sat => 'श',
						sun => 'र'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'ति1',
						1 => 'ति2',
						2 => 'ति3',
						3 => 'ति4'
					},
					wide => {0 => 'पहिल तिमाही',
						1 => 'दोसर तिमाही',
						2 => 'तेसर तिमाही',
						3 => 'चारिम तिमाही'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'am' => q{भोर},
					'pm' => q{सांझ},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'am' => q{पूर्वाह्न},
					'pm' => q{अपराह्न},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ईसा-पूर्व',
				'1' => 'ईसवी'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'शक'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{G EEEE, d MMMM y},
			'long' => q{G d MMMM y},
			'medium' => q{G d MMM y},
			'short' => q{G d/M/y},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM y},
			'long' => q{d MMMM y},
			'medium' => q{d MMM y},
			'short' => q{d/M/yy},
		},
		'indian' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'indian' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'indian' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			Bh => q{B h},
			Bhm => q{B h:mm},
			Bhms => q{B h:mm:ss},
			EBhm => q{E B h:mm},
			EBhms => q{E B h:mm:ss},
			Ed => q{E d},
			Gy => q{y G},
			GyMMM => q{MMM G y},
			GyMMMEd => q{E, MMM d, y G},
			GyMMMd => q{d MMM y G},
			GyMd => q{dd-MM-y G},
			MEd => q{E, d/M},
			MMMEd => q{E, d MMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			yM => q{M/y},
			yMEd => q{E, d/M/y},
			yMMM => q{MMM y},
			yMMMEd => q{E, d MMM y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		gmtFormat => q(जीएमटी{0}),
		gmtZeroFormat => q(जीएमटी),
		regionFormat => q({0} समय),
		regionFormat => q({0} डेलाइट समय),
		regionFormat => q({0} मानक समय),
		'Afghanistan' => {
			long => {
				'standard' => q#अफगानिस्तान टाइम#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#अबिजान#,
		},
		'Africa/Accra' => {
			exemplarCity => q#अकरा#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#अदिस अबाबा#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#अल्जीयर्स#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#असमारा#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#बमाको#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#बंगुई#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#बंजुल#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#बिसाऊ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ब्लेंटायर#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ब्रेजाविल#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#बुजुमबुरा#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#काहिरा#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#कासाब्लांका#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#सिउता#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#कोनाक्री#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#डकार#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#डारे सलाम#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#जिबूती#,
		},
		'Africa/Douala' => {
			exemplarCity => q#डाउला#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#एल ऐयून#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#फ्रीटाउन#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#गेबोरोन#,
		},
		'Africa/Harare' => {
			exemplarCity => q#हरारे#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#जोहानिसबर्ग#,
		},
		'Africa/Juba' => {
			exemplarCity => q#जुबा#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#कमपाला#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#खारतौम#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#किगाली#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#किंशासा#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#लागोस#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#लिब्रेविल#,
		},
		'Africa/Lome' => {
			exemplarCity => q#लोम#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#लुआंडा#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#लुबुमबाशी#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#लुसाका#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#मलाबो#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#मपूतो#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#मसैरू#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#मेंबाबाने#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#मोगादिशू#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#मोनरोविया#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#नैरोबी#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#नेजेमीना#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#नियामेय#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#नौकचोट#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#औगाडुगू#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#पोर्टो-नोवो#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#साओ टोम#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#त्रिपोली#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ट्यूनिस#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#बिंडोएक#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#मध्य अफ्रीका टाइम#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#पूरब अफ्रीका टाइम#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#दक्षिण अफ्रीका मानक टाइम#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#मध्य अफ्रीका समर टाइम#,
				'generic' => q#पश्चिम अफ्रीका टाइम#,
				'standard' => q#पश्चिम अफ्रीका मानक टाइम#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#अलास्का डेलाइट समय#,
				'generic' => q#अलास्का समय#,
				'standard' => q#अलास्का मानक समय#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#अमेजन समर टाइम#,
				'generic' => q#अमेजन टाइम#,
				'standard' => q#अमेजन मानक टाइम#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#अदक#,
		},
		'America/Anchorage' => {
			exemplarCity => q#एंकोरेज#,
		},
		'America/Anguilla' => {
			exemplarCity => q#एंग्विला#,
		},
		'America/Antigua' => {
			exemplarCity => q#एंटिगुआ#,
		},
		'America/Araguaina' => {
			exemplarCity => q#अरागुएना#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ला रियोजा#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#रियो गैलगस#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#सालटा#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#सन जुआन#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#सन लूईस#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#टुकुमान#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#उशुयाया#,
		},
		'America/Aruba' => {
			exemplarCity => q#अरूबा#,
		},
		'America/Asuncion' => {
			exemplarCity => q#असुनशियन#,
		},
		'America/Bahia' => {
			exemplarCity => q#बहिया#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#बहिया बंडेरास#,
		},
		'America/Barbados' => {
			exemplarCity => q#बारबडोस#,
		},
		'America/Belem' => {
			exemplarCity => q#बैलैम#,
		},
		'America/Belize' => {
			exemplarCity => q#बेलिज#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ब्लैंक-सबलोन#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#बोआ बिस्टा#,
		},
		'America/Bogota' => {
			exemplarCity => q#बोगोटा#,
		},
		'America/Boise' => {
			exemplarCity => q#बोयजी#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ब्यूनस आयर्स#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#कैम्ब्रीज बे#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#केम्पो ग्रेनडा#,
		},
		'America/Cancun' => {
			exemplarCity => q#कानकुन#,
		},
		'America/Caracas' => {
			exemplarCity => q#काराकास#,
		},
		'America/Catamarca' => {
			exemplarCity => q#काटामार्का#,
		},
		'America/Cayenne' => {
			exemplarCity => q#कायेन#,
		},
		'America/Cayman' => {
			exemplarCity => q#कैमेन#,
		},
		'America/Chicago' => {
			exemplarCity => q#शिकागो#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#चिहुआहुआ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#अटिकोकन#,
		},
		'America/Cordoba' => {
			exemplarCity => q#कोर्डोबा#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#कोस्टा रिका#,
		},
		'America/Creston' => {
			exemplarCity => q#क्रेस्टन#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#कुयाबा#,
		},
		'America/Curacao' => {
			exemplarCity => q#क्यूरासाओ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#दमर्कशन#,
		},
		'America/Dawson' => {
			exemplarCity => q#डाउसन#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#डाउसन क्रीक#,
		},
		'America/Denver' => {
			exemplarCity => q#डेनबर#,
		},
		'America/Detroit' => {
			exemplarCity => q#डेट्रायट#,
		},
		'America/Dominica' => {
			exemplarCity => q#डोमिनिका#,
		},
		'America/Edmonton' => {
			exemplarCity => q#एडमोंटोन#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ईरूनेपे#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#अल सल्वाडोर#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#फोर्ट नेलसन#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#फोर्टालेजा#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ग्लेस बे#,
		},
		'America/Godthab' => {
			exemplarCity => q#नुक#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#गूज बे#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ग्रांड टर्क#,
		},
		'America/Grenada' => {
			exemplarCity => q#ग्रेनाडा#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ग्वाडेलूप#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ग्वाटेमाला#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#गुआयाक्विल#,
		},
		'America/Guyana' => {
			exemplarCity => q#गुयाना#,
		},
		'America/Halifax' => {
			exemplarCity => q#हेलिफेक्स#,
		},
		'America/Havana' => {
			exemplarCity => q#हवाना#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#हरमोसिलो#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#नोक्स, इंडियाना#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#मेरैंगो, इंडियाना#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#पीटर्सबर्ग, इंडियाना#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#टेल सिटी, इंडियाना#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#बीबे, इंडियाना#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#विनसेंस, इंडियाना#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#बिनामैक, इंडियाना#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#इंडियानापोलिस#,
		},
		'America/Inuvik' => {
			exemplarCity => q#इनुबिक#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#इकालविट#,
		},
		'America/Jamaica' => {
			exemplarCity => q#जमैका#,
		},
		'America/Jujuy' => {
			exemplarCity => q#जुजुय#,
		},
		'America/Juneau' => {
			exemplarCity => q#जुनेउ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#मोंटीचेलो, केंटुकी#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#केलेंडिज्क#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ला पाज#,
		},
		'America/Lima' => {
			exemplarCity => q#लीमा#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#लास एंजिलिस#,
		},
		'America/Louisville' => {
			exemplarCity => q#लुइसविले#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#लोअर प्रिंसेस क्वाटर#,
		},
		'America/Maceio' => {
			exemplarCity => q#मसीयो#,
		},
		'America/Managua' => {
			exemplarCity => q#मनागुआ#,
		},
		'America/Manaus' => {
			exemplarCity => q#मनौस#,
		},
		'America/Marigot' => {
			exemplarCity => q#मारीगौट#,
		},
		'America/Martinique' => {
			exemplarCity => q#मार्टिनिक#,
		},
		'America/Matamoros' => {
			exemplarCity => q#माटामोरोस#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#मजाटलान#,
		},
		'America/Mendoza' => {
			exemplarCity => q#मेंडोजा#,
		},
		'America/Menominee' => {
			exemplarCity => q#मैनोमिनी#,
		},
		'America/Merida' => {
			exemplarCity => q#मैरिडा#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#मैटलाकाटला#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#मैक्सिको सिटी#,
		},
		'America/Miquelon' => {
			exemplarCity => q#मिक्वेलान#,
		},
		'America/Moncton' => {
			exemplarCity => q#मान्कटान#,
		},
		'America/Monterrey' => {
			exemplarCity => q#मानटेैरी#,
		},
		'America/Montevideo' => {
			exemplarCity => q#मोंटैविडियो#,
		},
		'America/Montserrat' => {
			exemplarCity => q#मोंटसेरात#,
		},
		'America/Nassau' => {
			exemplarCity => q#नसाउ#,
		},
		'America/New_York' => {
			exemplarCity => q#न्यूयार्क#,
		},
		'America/Nipigon' => {
			exemplarCity => q#निपिगान#,
		},
		'America/Nome' => {
			exemplarCity => q#नोम#,
		},
		'America/Noronha' => {
			exemplarCity => q#नोरोन्हा#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#बियूला, उत्तर डकोटा#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#सेंटर, उत्तर डकोटा#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#न्यू सलेम, उत्तर डकोटा#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ओजिनागा#,
		},
		'America/Panama' => {
			exemplarCity => q#पनामा#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#पैंगनिरटंग#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#पारामारिबो#,
		},
		'America/Phoenix' => {
			exemplarCity => q#फिनिक्स#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#पोर्ट आउ प्रिंस#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#पोर्ट आफ स्पेन#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#पोर्टो बेल्हो#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#पोर्टो रिको#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#पुंटा अरेनाज#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#रेनी रिवर#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#रेंकिन इनलेट#,
		},
		'America/Recife' => {
			exemplarCity => q#रिसीफ#,
		},
		'America/Regina' => {
			exemplarCity => q#रैगिना#,
		},
		'America/Resolute' => {
			exemplarCity => q#रेसालूत#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#रियो ब्रेंको#,
		},
		'America/Santarem' => {
			exemplarCity => q#सांतारेम#,
		},
		'America/Santiago' => {
			exemplarCity => q#सैंटियागो#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#सेंटो डोमिनगो#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#साओ पाउलो#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#इटोकोर्टूरमिट#,
		},
		'America/Sitka' => {
			exemplarCity => q#सितका#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#सेंट बर्थेलमी#,
		},
		'America/St_Johns' => {
			exemplarCity => q#सेंट जान्स#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#सेंट किट्स#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#सेंट लूशिया#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#सेंट थोमस#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#सेंट विंसेंट#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#स्विफ्ट करेंट#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#तेगुसिगाल्पा#,
		},
		'America/Thule' => {
			exemplarCity => q#तुले#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#थंडर बे#,
		},
		'America/Tijuana' => {
			exemplarCity => q#तिजुआना#,
		},
		'America/Toronto' => {
			exemplarCity => q#टोरंटो#,
		},
		'America/Tortola' => {
			exemplarCity => q#टोर्टोला#,
		},
		'America/Vancouver' => {
			exemplarCity => q#बैंकुबर#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#वाइटहार्स#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#बिनिपैग#,
		},
		'America/Yakutat' => {
			exemplarCity => q#यकुटाट#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#येलोनाइफ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#उत्तरी अमेरिकी केंद्रीय डेलाइट समय#,
				'generic' => q#उत्तरी अमेरिकी केंद्रीय समय#,
				'standard' => q#उत्तरी अमेरिकी केंद्रीय मानक समय#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#उत्तरी अमेरिकी पूर्वी डेलाइट समय#,
				'generic' => q#उत्तरी अमेरिकी पूर्वी समय#,
				'standard' => q#उत्तरी अमेरिकी पूर्वी मानक समय#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#उत्तरी अमेरिकी माउंटेन डेलाइट समय#,
				'generic' => q#उत्तरी अमेरिकी माउंटेन समय#,
				'standard' => q#उत्तरी अमेरिकी माउंटेन मानक समय#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#उत्तरी अमेरिकी प्रशांत डेलाइट समय#,
				'generic' => q#उत्तरी अमेरिकी प्रशांत समय#,
				'standard' => q#उत्तरी अमेरिकी प्रशांत मानक समय#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#केसी#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#मैक्वैरी#,
		},
		'Arabian' => {
			long => {
				'daylight' => q#अरेबियन डेलाइट टाइम#,
				'generic' => q#अरेबियन टाइम#,
				'standard' => q#अरेबियन मानक टाइम#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#लान्गियरबेन#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#अर्जेंटीना समर टाइम#,
				'generic' => q#अर्जेंटीना टाइम#,
				'standard' => q#अर्जेंटीना मानक टाइम#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#पश्चिमी अर्जेंटीना समर टाइम#,
				'generic' => q#पश्चिमी अर्जेंटीना टाइम#,
				'standard' => q#पश्चिमी अर्जेंटीना मानक टाइम#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#आर्मेनिया समर टाइम#,
				'generic' => q#आर्मेनिया टाइम#,
				'standard' => q#आर्मेनिया मानक टाइम#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#अदन#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#अल्माती#,
		},
		'Asia/Amman' => {
			exemplarCity => q#अम्मान#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#एनाडिर#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#अक्ताउ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#अक्तोब#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#अश्गाबात#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#अतिराउ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#बगदाद#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#बहरीन#,
		},
		'Asia/Baku' => {
			exemplarCity => q#बाकू#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#बैंकाक#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#बर्नोल#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#बेरूत#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#बिश्केक#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ब्रूनेई#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#कोलकाता#,
		},
		'Asia/Chita' => {
			exemplarCity => q#चिता#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#चोइबलसेन#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#कोलम्बो#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#दमिश्क#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ढाका#,
		},
		'Asia/Dili' => {
			exemplarCity => q#डिली#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#दुबई#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#दुशांबे#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#फामागुस्ता#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#गाजा#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#हैब्रान#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#हांग कांग#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#होब्द#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#इरकुस्क#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#जकार्ता#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#जयापुरा#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#जेरूसेलम#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#काबुल#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#कमचटका#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#कराची#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#काठमांडू#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#खांध्यगा#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#क्रेस्नोयार्स्क#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#कुआलालम्पुर#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#कुचिंग#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#कुवैत#,
		},
		'Asia/Macau' => {
			exemplarCity => q#मकाऊ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#मगादान#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#मकासार#,
		},
		'Asia/Manila' => {
			exemplarCity => q#मनीला#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#मस्कट#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#निकोशिया#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#कोबोकुजनेट्स#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#नोबोसिबिरस्क#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ओमस्क#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ओराल#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#नोम पेन्ह#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#पोंटियांक#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#प्योंगयांग#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#कतर#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#कोस्ताने#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#किजिलोर्डा#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#यांगुन#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#रियाद#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#हो ची मिन्ह सिटी#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#साकलिन#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#समरकंद#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#सियोल#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#शांघाई#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#सिंगापुर#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#श्रेडनेकोलिमिस्क#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#ताइपेई#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#ताशकंद#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#टबिलिसि#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#तेहरान#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#थिम्पू#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#टोक्यो#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#टोम्स#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#उलनबटोर#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#उरूमकी#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#उस्त-नेरा#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#बियंटियान#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ब्लाडिबोस्तोक#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#युकुत्स्क#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#यैकेटेरिनबर्ग#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#यैरेबन#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#अटलांटिक डेलाइट समय#,
				'generic' => q#अटलांटिक समय#,
				'standard' => q#अटलांटिक मानक समय#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#एजोर्स#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#बरमूडा#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#केनेरी#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#केप बर्ड#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#फराओ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#मदैरा#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#रिकजेविक#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#दक्षिण जार्जिया#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#सेंट हेलेना#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#स्टेनली#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#एडिलेड#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ब्रिसबेन#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ब्रोकेन हिल#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#डार्बिन#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#इयूकला#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#होबर्ट#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#लिंडमैन#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#लार्ड होबे#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#मेलबोर्न#,
		},
		'Australia/Perth' => {
			exemplarCity => q#पर्थ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#सिडनी#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#आस्ट्रेलियाई मध्य डेलाइट टाइम#,
				'generic' => q#मध्य आस्ट्रेलिया टाइम#,
				'standard' => q#आस्ट्रेलियाई मध्य मानक टाइम#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#आस्ट्रेलियाई मध्य पश्चिमी डेलाइट टाइम#,
				'generic' => q#आस्ट्रेलियाई मध्य पश्चिमी टाइम#,
				'standard' => q#आस्ट्रेलियाई मध्य पश्चिमी मानक टाइम#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#आस्ट्रेलियाई पूरबी डेलाइट टाइम#,
				'generic' => q#पूरबी आस्ट्रेलिया टाइम#,
				'standard' => q#आस्ट्रेलियाई पूरबी मानक टाइम#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#आस्ट्रेलियाई पश्चिमी डेलाइट टाइम#,
				'generic' => q#पश्चिमी आस्ट्रेलिया टाइम#,
				'standard' => q#आस्ट्रेलियाई पश्चिमी मानक टाइम#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#अजरबैजान समर टाइम#,
				'generic' => q#अजरबैजान टाइम#,
				'standard' => q#अजरबैजान मानक टाइम#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#एजोर्स समर टाइम#,
				'generic' => q#एजोर्स टाइम#,
				'standard' => q#एजोर्स मानक टाइम#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#बंगलादेश समर टाइम#,
				'generic' => q#बंगलादेश टाइम#,
				'standard' => q#बंगलादेश मानक टाइम#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#भूटान टाइम#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#बोलीबिया टाइम#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#ब्राजीलिया समर टाइम#,
				'generic' => q#ब्राजीलिया टाइम#,
				'standard' => q#ब्राजीलिया मानक टाइम#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#ब्रूनेई दारेसलाम टाइम#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#केप बर्ड समर टाइम#,
				'generic' => q#केप बर्डे टाइम#,
				'standard' => q#केप बर्ड मानक टाइम#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#चेथम डेलाइट टाइम#,
				'generic' => q#चेथम टाइम#,
				'standard' => q#चेथम मानक टाइम#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#चिली समर टाइम#,
				'generic' => q#चिली टाइम#,
				'standard' => q#चिली मानक टाइम#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#चीनी डेलाइट टाइम#,
				'generic' => q#चीनी टाइम#,
				'standard' => q#चीनी मानत टाइम#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#चोइबलसेन समर टाइम#,
				'generic' => q#चोइबलसेन टाइम#,
				'standard' => q#चोइबलसेन मानक टाइम#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#क्रिसमस द्वीप टाइम#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#कोकोस द्वीप टाइम#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#कोलंबिया समर टाइम#,
				'generic' => q#कोलंबिया टाइम#,
				'standard' => q#कोलंबिया मानक टाइम#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#क्यूबा डेलाइट टाइम#,
				'generic' => q#क्यूबा टाइम#,
				'standard' => q#क्यूबा मानक टाइम#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#पूरबी तिमोर टाइम#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ईस्टर आइलैंड समर टाइम#,
				'generic' => q#ईस्टर आइलैंड टाइम#,
				'standard' => q#ईस्टर आइलैंड मानक टाइम#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#इक्वाडोर टाइम#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#समन्वित वैश्विक समय#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#अज्ञात शहर#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#एम्सटर्डम#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#एंडोरा#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#अस्ट्राकान#,
		},
		'Europe/Athens' => {
			exemplarCity => q#एथेंस#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#बेलग्रेड#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#बर्लिन#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#बारितस्लावा#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ब्रसेल्स#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#बुखारेस्ट#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#बुडापेस्ट#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#बसिंगेन#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#चिसिनाऊ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#कोपेनहेगेन#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#डबलिन#,
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#जिब्राल्टर#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#गर्नजी#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#हैलसिंकी#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#आइजल आफ मैन#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#इस्ताम्बुल#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#जर्सी#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#कलिनिनग्रेड#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#कीव#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#किरोव#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#लिसबन#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#लुबलियाना#,
		},
		'Europe/London' => {
			exemplarCity => q#लंदन#,
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#लग्जमबर्ग#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#मेड्रिड#,
		},
		'Europe/Malta' => {
			exemplarCity => q#मालटा#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#मेरियेहम#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#मिन्सक#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#मोनेको#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#मास्को#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ओस्लो#,
		},
		'Europe/Paris' => {
			exemplarCity => q#पेरिस#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#पोडगोरिशा#,
		},
		'Europe/Prague' => {
			exemplarCity => q#प्राग#,
		},
		'Europe/Riga' => {
			exemplarCity => q#रिगा#,
		},
		'Europe/Rome' => {
			exemplarCity => q#रोम#,
		},
		'Europe/Samara' => {
			exemplarCity => q#समारा#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#सैन मरीनो#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#सराजेबो#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#सारातोब#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#सिम्फेरोपोल#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#स्कोपये#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#सोफिया#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#स्टाकहोम#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#टालिन#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#टिराने#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#उल्येनोबोस्क#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#उझोरोद#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#बेदुज#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#बेटिकन#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#बिएना#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#बिलनिउस#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#बोलगोग्राद#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#बारसा#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#जगरैब#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#जपोरोजाए#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ज्यूरिख#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#मध्‍य यूरोपीय ग्रीष्‍मकालीन समय#,
				'generic' => q#मध्य यूरोपीय समय#,
				'standard' => q#मध्य यूरोपीय मानक समय#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#पूर्वी यूरोपीय ग्रीष्मकालीन समय#,
				'generic' => q#पूर्वी यूरोपीय समय#,
				'standard' => q#पूर्वी यूरोपीय मानक समय#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#फरदर-ईस्टर्न यूरोपीयन टाइम#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#पश्चिमी यूरोपीय ग्रीष्‍मकालीन समय#,
				'generic' => q#पश्चिमी यूरोपीय समय#,
				'standard' => q#पश्चिमी यूरोपीय मानक समय#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#फाकलैंड आइलैंड समर टाइम#,
				'generic' => q#फाकलैंड आइलैंड टाइम#,
				'standard' => q#फाकलैंड आइलैंड मानक टाइम#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#फ्रेंच गुयाना टाइम#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#फ़्रांसीसी दक्षिणी क्षेत्र आ अंटार्कटिक टाइम#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#ग्रीनविच मीन टाइम#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#गैलापैगोस टाइम#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#जार्जिया समर टाइम#,
				'generic' => q#जार्जिया टाइम#,
				'standard' => q#जार्जिया मानक टाइम#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#पूरबी ग्रीनलैंड समर टाइम#,
				'generic' => q#पूरबी ग्रीनलैंड टाइम#,
				'standard' => q#पूरबी ग्रीनलैंड मानक टाइम#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#पश्चिमी ग्रीनलैंड समर टाइम#,
				'generic' => q#पश्चिमी ग्रीनलैंड टाइम#,
				'standard' => q#पश्चिमी ग्रीनलैंड मानक टाइम#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#गल्फ मानक समय#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#गुयाना टाइम#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#हवाई-एल्यूटियन डेलाइट टाइम#,
				'generic' => q#हवाई-एल्यूटियन टाइम#,
				'standard' => q#हवाई-एल्यूटियन मानक टाइम#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#हांग कांग समर टाइम#,
				'generic' => q#हांग कांग टाइम#,
				'standard' => q#हांग कांग मानक टाइम#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#होब्द समर टाइम#,
				'generic' => q#होब्द टाइम#,
				'standard' => q#होब्द मानक टाइम#,
			},
		},
		'India' => {
			long => {
				'standard' => q#भारतीय मानक समय#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#अंतानानेरिवो#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#चगोस#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#क्रिसमस#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#कोकोस#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#कोमोरो#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#कैरगुएलेन#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#माहे#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#मालदीव#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#मारीशस#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#मयोते#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#रियूनियन#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#हिंद महासागर टाइम#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#इंडोचाइना टाइम#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#मध्य इंडोनेशिया टाइम#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#पूरबी इंडोनेशिया टाइम#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#पश्चिमी इंडोनेशिया टाइम#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ईरान डेलाइट टाइम#,
				'generic' => q#ईरान टाइम#,
				'standard' => q#ईरानमानक टाइम#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#इरकूत्स्क समर टाइम#,
				'generic' => q#इरकूत्स्क टाइम#,
				'standard' => q#इरकूत्स्क मानक टाइम#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#इजरायल डेलाइट टाइम#,
				'generic' => q#इजरायल टाइम#,
				'standard' => q#इजरायल मानक टाइम#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#जापान डेलाइट टाइम#,
				'generic' => q#जापान टाइम#,
				'standard' => q#जापान मानक टाइम#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#पूरब कजाखस्तान टाइम#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#पश्चिम कजाखस्तान टाइम#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#कोरियन डेलाइट टाइम#,
				'generic' => q#कोरियन टाइम#,
				'standard' => q#कोरियन मानक टाइम#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#क्रेस्नोयार्स्क समर टाइम#,
				'generic' => q#क्रेस्नोयार्स्क#,
				'standard' => q#क्रेस्नोयार्स्क मानक टाइम#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#किर्गिस्तान#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#लार्ड होबे डेलाइट टाइम#,
				'generic' => q#लार्ड होबे टाइम#,
				'standard' => q#लार्ड होबे मानक टाइम#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#मेक्वैरी द्वीप टाइम#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#मगादान समर टाइम#,
				'generic' => q#मगादान टाइम#,
				'standard' => q#मगादान मानक टाइम#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#मलेशिया टाइम#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#मालदीव टाइम#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#मारीशस समर टाइम#,
				'generic' => q#मारीशस टाइम#,
				'standard' => q#मारीशस मानक टाइम#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#उत्तर-पश्चिमी मैक्सिको डेलाइट टाइम#,
				'generic' => q#उत्तर-पश्चिमी मैक्सिको टाइम#,
				'standard' => q#उत्तर-पश्चिमी मैक्सिको मानक टाइम#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#मैक्सिकन पेसिफिक डेलाइट टाइम#,
				'generic' => q#मैक्सिकन पेसिफिक टाइम#,
				'standard' => q#मैक्सिकन पेसिफिक मानक टाइम#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#उलनबटोर समर टाइम#,
				'generic' => q#उलनबटोर टाइम#,
				'standard' => q#उलनबटोर मानक टाइम#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#मास्को समर टाइम#,
				'generic' => q#मास्को टाइम#,
				'standard' => q#मास्को मानक टाइम#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#मयनमार टाइम#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#नेपाल टाइम#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#न्यू केलैडोनिया डेलाइट समय#,
				'generic' => q#न्यू केलैडोनिया समय#,
				'standard' => q#न्यू केलैडोनिया मानक समय#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#न्यूजीलैंड डेलाइट टाइम#,
				'generic' => q#न्यूजीलैंड टाइम#,
				'standard' => q#न्यूजीलैंड मानक टाइम#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#न्यूफाउंडलैंड डेलाइट टाइम#,
				'generic' => q#न्यूफाउंडलैंड टाइम#,
				'standard' => q#न्यूफाउंडलैंड मानक टाइम#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#फाकलैंड द्वीप डेलाइट टाइम#,
				'generic' => q#फाकलैंड द्वीप टाइम#,
				'standard' => q#फाकलैंड द्वीप मानक टाइम#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#फर्नेंडो डी नोरोन्हा समर टाइम#,
				'generic' => q#फर्नेंडो डी नोरोन्हा टाइम#,
				'standard' => q#फर्नेंडो डी नोरोन्हा मानक टाइम#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#नोबोसिबिर्स्क समर टाइम#,
				'generic' => q#नोबोसिबिर्स्क टाइप#,
				'standard' => q#नोबोसिबिर्स्क मानक टाइम#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#ओम्स्क समर टाइम#,
				'generic' => q#ओम्स्क टाइम#,
				'standard' => q#ओम्स्क मानक टाइम#,
			},
		},
		'Pacific/Auckland' => {
			exemplarCity => q#आकलैंड#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#चेथम#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ईस्टर#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#गैलापैगोस#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#नारफाक#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#पाकिस्तान समर टाइम#,
				'generic' => q#पाकिस्तान टाइम#,
				'standard' => q#पाकिस्तान मानक टाइम#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#पराग्वे समर टाइम#,
				'generic' => q#पराग्वे टाइम#,
				'standard' => q#पराग्वे मानक टाइम#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#पेरू समर टाइम#,
				'generic' => q#पेरू टाइम#,
				'standard' => q#पेरू मानक टाइम#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#फिलिपीन समर टाइम#,
				'generic' => q#फिलिपीन टाइम#,
				'standard' => q#फिलिपीन मानक टाइम#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#सेंट पिएरे आ मिक्वेलान डेलाइट टाइम#,
				'generic' => q#सेंट पिएरे आ मिक्वेलान टाइम#,
				'standard' => q#सेंट पिएरे आ मिक्वेलान मानक टाइम#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#प्योंगयांग टाइम#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#रियूनियन टाइम#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#सकालिन समर टाइम#,
				'generic' => q#सकालिन टाइम#,
				'standard' => q#सकालिन मानक टाइम#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#सामोआ समर समय#,
				'generic' => q#सामोआ समय#,
				'standard' => q#सामोआ मानक समय#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#सेशेल्स टाइम#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#सिंगापुर मानक टाइम#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#दक्षिण जार्जिया टाइम#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#सुरीनाम टाइम#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#ताइपेई डेलाइट टाइम#,
				'generic' => q#ताइपेई टाइम#,
				'standard' => q#ताइपेई मानक टाइम#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#ताजिकिस्तान#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#तुर्कमेनिस्तान समर टाइम#,
				'generic' => q#तुर्कमेनिस्तान टाइम#,
				'standard' => q#तुर्कमेनिस्तान मानक टाइम#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#उरुग्वे समर टाइम#,
				'generic' => q#उरुग्वे टाइम#,
				'standard' => q#उरुग्वे मानक टाइम#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#उजबेकिस्तान समर टाइम#,
				'generic' => q#उजबेकिस्तान टाइम#,
				'standard' => q#उजबेकिस्तान मानक टाइम#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#बेनेजुएला टाइम#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#ब्लादिबोस्तोक समर टाइम#,
				'generic' => q#ब्लादिबोस्तोक टाइम#,
				'standard' => q#ब्लादिबोस्तोक मानक टाइम#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#बोल्गोग्राद समर टाइम#,
				'generic' => q#बोल्गोग्राद टाइम#,
				'standard' => q#बोल्गोग्राद मानक टाइम#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#यकुत्स्क समर टाइम#,
				'generic' => q#यकुत्स्क टाइम#,
				'standard' => q#यकुत्स्क मानक टाइम#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#येकाटैरिनबर्ग समर टाइम#,
				'generic' => q#येकाटैरिनबर्ग टाइम#,
				'standard' => q#येकाटैरिनबर्ग मानक टाइम#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#यूकोन टाइम#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
