=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Ia - Package for language Interlingua

=cut

package Locale::CLDR::Locales::Ia;
# This file auto generated from Data\common\main\ia.xml
#	on Fri 28 Jun  8:55:56 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.45.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'afar',
 				'ab' => 'abkhazo',
 				'ace' => 'acehnese',
 				'ada' => 'adangme',
 				'ady' => 'adygeano',
 				'af' => 'afrikaans',
 				'agq' => 'aghem',
 				'ain' => 'ainu',
 				'ak' => 'akan',
 				'ale' => 'aleuto',
 				'alt' => 'altai del sud',
 				'am' => 'amharico',
 				'an' => 'aragonese',
 				'ann' => 'obolo',
 				'anp' => 'angika',
 				'ar' => 'arabe',
 				'ar_001' => 'arabe standard moderne',
 				'arn' => 'mapuche',
 				'arp' => 'arapaho',
 				'ars' => 'arabe najdi',
 				'as' => 'assamese',
 				'asa' => 'asu',
 				'ast' => 'asturiano',
 				'atj' => 'atikamekw',
 				'av' => 'avaro',
 				'awa' => 'awadhi',
 				'ay' => 'aymara',
 				'az' => 'azerbaidzhano',
 				'az@alt=short' => 'azeri',
 				'ba' => 'bashkir',
 				'ban' => 'balinese',
 				'bas' => 'basaa',
 				'be' => 'bielorusso',
 				'bem' => 'bemba',
 				'bez' => 'bena',
 				'bg' => 'bulgaro',
 				'bho' => 'bhojpuri',
 				'bi' => 'bislama',
 				'bin' => 'bini',
 				'bla' => 'siksika',
 				'bm' => 'bambara',
 				'bn' => 'bengalese',
 				'bo' => 'tibetano',
 				'br' => 'breton',
 				'brx' => 'bodo',
 				'bs' => 'bosniaco',
 				'bug' => 'buginese',
 				'byn' => 'blin',
 				'ca' => 'catalano',
 				'cay' => 'cayuga',
 				'ccp' => 'chakma',
 				'ce' => 'checheno',
 				'ceb' => 'cebuano',
 				'cgg' => 'chiga',
 				'ch' => 'chamorro',
 				'chk' => 'chuukese',
 				'chm' => 'mari',
 				'cho' => 'choctaw',
 				'chp' => 'chipewyan',
 				'chr' => 'cherokee',
 				'chy' => 'cheyenne',
 				'ckb' => 'kurdo central',
 				'ckb@alt=variant' => 'kurdo sorani',
 				'clc' => 'chilcotin',
 				'co' => 'corso',
 				'crg' => 'mitchif',
 				'crj' => 'cree del sud-est',
 				'crk' => 'cree del planas',
 				'crl' => 'cree del nord-est',
 				'crm' => 'cree moose',
 				'crr' => 'algonquino de Carolina',
 				'crs' => 'creolo seychellese',
 				'cs' => 'checo',
 				'csw' => 'cree del paludes',
 				'cu' => 'slavo ecclesiastic',
 				'cv' => 'chuvash',
 				'cy' => 'gallese',
 				'da' => 'danese',
 				'dak' => 'dakota',
 				'dar' => 'dargwa',
 				'dav' => 'taita',
 				'de' => 'germano',
 				'de_AT' => 'germano austriac',
 				'de_CH' => 'alte germano suisse',
 				'dgr' => 'dogrib',
 				'dje' => 'zarma',
 				'doi' => 'dogri',
 				'dsb' => 'basse sorabo',
 				'dua' => 'duala',
 				'dv' => 'divehi',
 				'dyo' => 'jola-fonyi',
 				'dz' => 'dzongkha',
 				'dzg' => 'dazaga',
 				'ebu' => 'embu',
 				'ee' => 'ewe',
 				'efi' => 'efik',
 				'eka' => 'ekajuk',
 				'el' => 'greco',
 				'en' => 'anglese',
 				'en_AU' => 'anglese australian',
 				'en_CA' => 'anglese canadian',
 				'en_GB' => 'anglese britannic',
 				'en_GB@alt=short' => 'anglese (GB)',
 				'en_US' => 'anglese american',
 				'en_US@alt=short' => 'anglese (SUA)',
 				'eo' => 'esperanto',
 				'es' => 'espaniol',
 				'es_419' => 'espaniol latinoamerican',
 				'es_ES' => 'espaniol europee',
 				'es_MX' => 'espaniol mexican',
 				'et' => 'estoniano',
 				'eu' => 'basco',
 				'ewo' => 'ewondo',
 				'fa' => 'persa',
 				'fa_AF' => 'dari',
 				'ff' => 'fula',
 				'fi' => 'finnese',
 				'fil' => 'filipino',
 				'fj' => 'fijiano',
 				'fo' => 'feroese',
 				'fon' => 'fon',
 				'fr' => 'francese',
 				'fr_CA' => 'francese canadian',
 				'fr_CH' => 'francese suisse',
 				'frc' => 'francese cajun',
 				'frr' => 'frison septentrional',
 				'fur' => 'friulano',
 				'fy' => 'frison occidental',
 				'ga' => 'irlandese',
 				'gaa' => 'ga',
 				'gd' => 'gaelico scotese',
 				'gez' => 'ge’ez',
 				'gil' => 'gilbertese',
 				'gl' => 'galleco',
 				'gn' => 'guarani',
 				'gor' => 'gorontalo',
 				'gsw' => 'germano suisse',
 				'gu' => 'gujarati',
 				'guz' => 'gusii',
 				'gv' => 'mannese',
 				'gwi' => 'gwich’in',
 				'ha' => 'hausa',
 				'hai' => 'haida',
 				'haw' => 'hawaiano',
 				'hax' => 'haida del sud',
 				'he' => 'hebreo',
 				'hi' => 'hindi',
 				'hi_Latn@alt=variant' => 'hinglish',
 				'hil' => 'hiligaynon',
 				'hmn' => 'hmong',
 				'hr' => 'croato',
 				'hsb' => 'alte sorabo',
 				'ht' => 'creolo haitian',
 				'hu' => 'hungaro',
 				'hup' => 'hupa',
 				'hur' => 'halkomelem',
 				'hy' => 'armenio',
 				'hz' => 'herero',
 				'ia' => 'interlingua',
 				'iba' => 'iban',
 				'ibb' => 'ibibio',
 				'id' => 'indonesiano',
 				'ie' => 'Interlingue',
 				'ig' => 'igbo',
 				'ii' => 'yi de Sichuan',
 				'ikt' => 'inuktitut del west canadian',
 				'ilo' => 'ilocano',
 				'inh' => 'ingush',
 				'io' => 'ido',
 				'is' => 'islandese',
 				'it' => 'italiano',
 				'iu' => 'inuktitut',
 				'ja' => 'japonese',
 				'jbo' => 'lojban',
 				'jgo' => 'ngomba',
 				'jmc' => 'machame',
 				'jv' => 'javanese',
 				'ka' => 'georgiano',
 				'kab' => 'kabylo',
 				'kac' => 'kachin',
 				'kaj' => 'jju',
 				'kam' => 'kamba',
 				'kbd' => 'cabardiano',
 				'kcg' => 'tyap',
 				'kde' => 'makonde',
 				'kea' => 'capoverdiano',
 				'kfo' => 'koro',
 				'kgp' => 'kaingang',
 				'kha' => 'khasi',
 				'khq' => 'koyra chiini',
 				'ki' => 'kikuyu',
 				'kj' => 'kuanyama',
 				'kk' => 'kazakh',
 				'kkj' => 'kako',
 				'kl' => 'groenlandese',
 				'kln' => 'kalenjin',
 				'km' => 'khmer',
 				'kmb' => 'kimbundu',
 				'kn' => 'kannada',
 				'ko' => 'coreano',
 				'kok' => 'konkani',
 				'kpe' => 'kpelle',
 				'kr' => 'kanuri',
 				'krc' => 'karachay-balkaro',
 				'krl' => 'careliano',
 				'kru' => 'kurukh',
 				'ks' => 'kashmiri',
 				'ksb' => 'shambala',
 				'ksf' => 'bafia',
 				'ksh' => 'coloniese',
 				'ku' => 'kurdo',
 				'kum' => 'kumyko',
 				'kv' => 'komi',
 				'kw' => 'cornico',
 				'kwk' => 'kwakwala',
 				'ky' => 'kirghizo',
 				'la' => 'latino',
 				'lad' => 'ladino',
 				'lag' => 'langi',
 				'lb' => 'luxemburgese',
 				'lez' => 'lezghiano',
 				'lg' => 'luganda',
 				'li' => 'limburgese',
 				'lil' => 'lillooet',
 				'lkt' => 'lakota',
 				'ln' => 'lingala',
 				'lo' => 'laotiano',
 				'lou' => 'creolo louisianese',
 				'loz' => 'lozi',
 				'lrc' => 'luri del nord',
 				'lsm' => 'samia',
 				'lt' => 'lithuano',
 				'lu' => 'luba-katanga',
 				'lua' => 'luba-lulua',
 				'lun' => 'lunda',
 				'luo' => 'luo',
 				'lus' => 'mizo',
 				'luy' => 'luyia',
 				'lv' => 'letton',
 				'mad' => 'madurese',
 				'mag' => 'magahi',
 				'mai' => 'maithili',
 				'mak' => 'macassarese',
 				'mas' => 'masai',
 				'mdf' => 'moksha',
 				'men' => 'mende',
 				'mer' => 'meri',
 				'mfe' => 'creolo mauritian',
 				'mg' => 'malgache',
 				'mgh' => 'makhuwa-meetto',
 				'mgo' => 'metaʼ',
 				'mh' => 'marshallese',
 				'mi' => 'maori',
 				'mic' => 'micmac',
 				'min' => 'minangkabau',
 				'mk' => 'macedone',
 				'ml' => 'malayalam',
 				'mn' => 'mongol',
 				'mni' => 'manipuri',
 				'moe' => 'innu-aimun',
 				'moh' => 'mohawk',
 				'mos' => 'mossi',
 				'mr' => 'marathi',
 				'ms' => 'malay',
 				'mt' => 'maltese',
 				'mua' => 'mundang',
 				'mul' => 'plure linguas',
 				'mus' => 'creek',
 				'mwl' => 'mirandese',
 				'my' => 'birmano',
 				'myv' => 'erzya',
 				'mzn' => 'mazanderani',
 				'na' => 'nauru',
 				'nap' => 'napolitano',
 				'naq' => 'nama',
 				'nb' => 'norvegiano bokmål',
 				'nd' => 'ndebele del nord',
 				'nds' => 'basse germano',
 				'ne' => 'nepalese',
 				'new' => 'newari',
 				'ng' => 'ndonga',
 				'nia' => 'nias',
 				'niu' => 'nieuano',
 				'nl' => 'nederlandese',
 				'nl_BE' => 'flamingo',
 				'nmg' => 'kwasio',
 				'nn' => 'norvegiano nynorsk',
 				'nnh' => 'ngiemboon',
 				'no' => 'norvegiano',
 				'nog' => 'nogai',
 				'nqo' => 'n’ko',
 				'nr' => 'ndebele del sud',
 				'nso' => 'sotho del nord',
 				'nus' => 'nuer',
 				'nv' => 'navajo',
 				'ny' => 'nyanja',
 				'nyn' => 'nyankole',
 				'oc' => 'occitano',
 				'ojb' => 'ojibwa del nord-west',
 				'ojc' => 'ojibwa central',
 				'ojs' => 'oji-cree',
 				'ojw' => 'ojibwa del west',
 				'oka' => 'okanagan',
 				'om' => 'oromo',
 				'or' => 'oriya',
 				'os' => 'osseto',
 				'pa' => 'punjabi',
 				'pag' => 'pangasinan',
 				'pam' => 'pampanga',
 				'pap' => 'papiamento',
 				'pau' => 'palauano',
 				'pcm' => 'pidgin nigerian',
 				'pis' => 'pijin',
 				'pl' => 'polonese',
 				'pqm' => 'malecite-passamaquoddy',
 				'prg' => 'prussiano',
 				'ps' => 'pashto',
 				'pt' => 'portugese',
 				'pt_BR' => 'portugese de Brasil',
 				'pt_PT' => 'portugese de Portugal',
 				'qu' => 'quechua',
 				'quc' => 'kʼicheʼ',
 				'rap' => 'rapanui',
 				'rar' => 'rarotongano',
 				'rhg' => 'rohingya',
 				'rm' => 'romanche',
 				'rn' => 'rundi',
 				'ro' => 'romaniano',
 				'ro_MD' => 'moldavo',
 				'rof' => 'rombo',
 				'ru' => 'russo',
 				'rup' => 'aromaniano',
 				'rw' => 'kinyarwanda',
 				'rwk' => 'rwa',
 				'sa' => 'sanscrito',
 				'sad' => 'sandawe',
 				'sah' => 'yakuto',
 				'saq' => 'samburu',
 				'sat' => 'santali',
 				'sba' => 'ngambay',
 				'sbp' => 'sangu',
 				'sc' => 'sardo',
 				'scn' => 'siciliano',
 				'sco' => 'scotese',
 				'sd' => 'sindhi',
 				'se' => 'sami del nord',
 				'seh' => 'sena',
 				'ses' => 'koyraboro senni',
 				'sg' => 'sango',
 				'sh' => 'serbocroate',
 				'shi' => 'tachelhit',
 				'shn' => 'shan',
 				'si' => 'cingalese',
 				'sk' => 'slovaco',
 				'sl' => 'sloveno',
 				'slh' => 'lushootseed del sud',
 				'sm' => 'samoano',
 				'sma' => 'sami del sud',
 				'smj' => 'sami de Lule',
 				'smn' => 'sami de Inari',
 				'sms' => 'sami skolt',
 				'sn' => 'shona',
 				'snk' => 'soninke',
 				'so' => 'somali',
 				'sq' => 'albanese',
 				'sr' => 'serbo',
 				'srn' => 'sranan tongo',
 				'ss' => 'swati',
 				'ssy' => 'saho',
 				'st' => 'sotho del sud',
 				'str' => 'salish del strictos',
 				'su' => 'sundanese',
 				'suk' => 'sukuma',
 				'sv' => 'svedese',
 				'sw' => 'swahili',
 				'sw_CD' => 'swahili del Congo',
 				'swb' => 'comoriano',
 				'syr' => 'syriaco',
 				'ta' => 'tamil',
 				'tce' => 'tutchone del sud',
 				'te' => 'telugu',
 				'tem' => 'temne',
 				'teo' => 'teso',
 				'tet' => 'tetum',
 				'tg' => 'tajiko',
 				'tgx' => 'tagish',
 				'th' => 'thai',
 				'tht' => 'tahltan',
 				'ti' => 'tigrinya',
 				'tig' => 'tigre',
 				'tk' => 'turkmeno',
 				'tlh' => 'klingon',
 				'tli' => 'tlingit',
 				'tn' => 'tswana',
 				'to' => 'tongano',
 				'tok' => 'toki pona',
 				'tpi' => 'tok pisin',
 				'tr' => 'turco',
 				'trv' => 'taroko',
 				'trw' => 'torwali',
 				'ts' => 'tsonga',
 				'tt' => 'tataro',
 				'ttm' => 'tutchone del nord',
 				'tum' => 'tumbuka',
 				'tvl' => 'tuvaluano',
 				'tw' => 'twi',
 				'twq' => 'tasawaq',
 				'ty' => 'tahitiano',
 				'tyv' => 'tuvano',
 				'tzm' => 'tamazight del Atlas Central',
 				'udm' => 'udmurto',
 				'ug' => 'uighur',
 				'uk' => 'ukrainiano',
 				'umb' => 'umbundu',
 				'und' => 'lingua incognite',
 				'ur' => 'urdu',
 				'uz' => 'uzbeko',
 				'vai' => 'vai',
 				've' => 'venda',
 				'vec' => 'venetiano',
 				'vi' => 'vietnamese',
 				'vo' => 'volapük',
 				'vun' => 'vunjo',
 				'wa' => 'wallon',
 				'wae' => 'walser',
 				'wal' => 'wolaytta',
 				'war' => 'waray',
 				'wbp' => 'warlpiri',
 				'wo' => 'wolof',
 				'wuu' => 'wu',
 				'xal' => 'calmuco',
 				'xh' => 'xhosa',
 				'xog' => 'soga',
 				'yav' => 'yangben',
 				'ybb' => 'yemba',
 				'yi' => 'yiddish',
 				'yo' => 'yoruba',
 				'yrl' => 'nheengatu',
 				'yue' => 'cantonese',
 				'yue@alt=menu' => 'chinese cantonese',
 				'zgh' => 'tamazight marocchin standard',
 				'zh' => 'chinese',
 				'zh@alt=menu' => 'chinese mandarin',
 				'zh_Hans' => 'chinese simplificate',
 				'zh_Hans@alt=long' => 'chinese mandarin simplificate',
 				'zh_Hant' => 'chinese traditional',
 				'zh_Hant@alt=long' => 'chinese mandarin traditional',
 				'zu' => 'zulu',
 				'zun' => 'zuni',
 				'zxx' => 'sin contento linguistic',
 				'zza' => 'zaza',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'arabe',
 			'Armn' => 'armenie',
 			'Beng' => 'bengalese',
 			'Bopo' => 'bopomofo',
 			'Brai' => 'braille',
 			'Cyrl' => 'cyrillic',
 			'Deva' => 'devanagari',
 			'Ethi' => 'ethiope',
 			'Geor' => 'georgian',
 			'Grek' => 'grec',
 			'Gujr' => 'gujarati',
 			'Guru' => 'gurmukhi',
 			'Hanb' => 'han con bopomofo',
 			'Hang' => 'hangul',
 			'Hani' => 'han',
 			'Hans' => 'simplificate',
 			'Hans@alt=stand-alone' => 'han simplificate',
 			'Hant' => 'traditional',
 			'Hant@alt=stand-alone' => 'han traditional',
 			'Hebr' => 'hebraic',
 			'Hira' => 'hiragana',
 			'Hrkt' => 'syllabarios japonese',
 			'Jamo' => 'jamo',
 			'Jpan' => 'japonese',
 			'Kana' => 'katakana',
 			'Khmr' => 'khmer',
 			'Knda' => 'kannada',
 			'Kore' => 'corean',
 			'Laoo' => 'lao',
 			'Latn' => 'latin',
 			'Mlym' => 'malayalam',
 			'Mong' => 'mongol',
 			'Mymr' => 'birman',
 			'Orya' => 'orya',
 			'Sinh' => 'cingalese',
 			'Taml' => 'tamil',
 			'Telu' => 'telugu',
 			'Thaa' => 'thaana',
 			'Thai' => 'thailandese',
 			'Tibt' => 'tibetan',
 			'Zmth' => 'notation mathematic',
 			'Zsye' => 'emoji',
 			'Zsym' => 'symbolos',
 			'Zxxx' => 'non scripte',
 			'Zyyy' => 'commun',
 			'Zzzz' => 'scriptura incognite',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'Mundo',
 			'002' => 'Africa',
 			'003' => 'America del Nord',
 			'005' => 'America del Sud',
 			'009' => 'Oceania',
 			'011' => 'Africa occidental',
 			'013' => 'America central',
 			'014' => 'Africa oriental',
 			'015' => 'Africa septentrional',
 			'017' => 'Africa central',
 			'018' => 'Africa meridional',
 			'019' => 'Americas',
 			'021' => 'America septentrional',
 			'029' => 'Caribes',
 			'030' => 'Asia oriental',
 			'034' => 'Asia meridional',
 			'035' => 'Asia del sud-est',
 			'039' => 'Europa meridional',
 			'053' => 'Australasia',
 			'054' => 'Melanesia',
 			'057' => 'Region micronesian',
 			'061' => 'Polynesia',
 			'142' => 'Asia',
 			'143' => 'Asia central',
 			'145' => 'Asia occidental',
 			'150' => 'Europa',
 			'151' => 'Europa oriental',
 			'154' => 'Europa septentrional',
 			'155' => 'Europa occidental',
 			'202' => 'Africa subsaharian',
 			'419' => 'America latin',
 			'AC' => 'Insula del Ascension',
 			'AD' => 'Andorra',
 			'AE' => 'Emiratos Arabe Unite',
 			'AF' => 'Afghanistan',
 			'AG' => 'Antigua e Barbuda',
 			'AI' => 'Anguilla',
 			'AL' => 'Albania',
 			'AM' => 'Armenia',
 			'AO' => 'Angola',
 			'AQ' => 'Antarctica',
 			'AR' => 'Argentina',
 			'AS' => 'Samoa american',
 			'AT' => 'Austria',
 			'AU' => 'Australia',
 			'AW' => 'Aruba',
 			'AX' => 'Insulas Åland',
 			'AZ' => 'Azerbaidzhan',
 			'BA' => 'Bosnia e Herzegovina',
 			'BB' => 'Barbados',
 			'BD' => 'Bangladesh',
 			'BE' => 'Belgica',
 			'BF' => 'Burkina Faso',
 			'BG' => 'Bulgaria',
 			'BH' => 'Bahrain',
 			'BI' => 'Burundi',
 			'BJ' => 'Benin',
 			'BL' => 'Sancte Bartholomeo',
 			'BM' => 'Bermuda',
 			'BN' => 'Brunei',
 			'BO' => 'Bolivia',
 			'BQ' => 'Paises Basse caribe',
 			'BR' => 'Brasil',
 			'BS' => 'Bahamas',
 			'BT' => 'Bhutan',
 			'BV' => 'Insula de Bouvet',
 			'BW' => 'Botswana',
 			'BY' => 'Bielorussia',
 			'BZ' => 'Belize',
 			'CA' => 'Canada',
 			'CC' => 'Insulas Cocos (Keeling)',
 			'CD' => 'Congo - Kinshasa',
 			'CD@alt=variant' => 'Congo (RDC)',
 			'CF' => 'Republica African Central',
 			'CG' => 'Congo - Brazzaville',
 			'CG@alt=variant' => 'Congo (Republica)',
 			'CH' => 'Suissa',
 			'CI' => 'Costa de Ebore',
 			'CI@alt=variant' => 'Republica de Côte d’Ivoire',
 			'CK' => 'Insulas Cook',
 			'CL' => 'Chile',
 			'CM' => 'Camerun',
 			'CN' => 'China',
 			'CO' => 'Colombia',
 			'CP' => 'Insula Clipperton',
 			'CR' => 'Costa Rica',
 			'CU' => 'Cuba',
 			'CV' => 'Capo Verde',
 			'CW' => 'Curaçao',
 			'CX' => 'Insula de Natal',
 			'CY' => 'Cypro',
 			'CZ' => 'Chechia',
 			'CZ@alt=variant' => 'Republica Chec',
 			'DE' => 'Germania',
 			'DG' => 'Diego Garcia',
 			'DJ' => 'Djibuti',
 			'DK' => 'Danmark',
 			'DM' => 'Dominica',
 			'DO' => 'Republica Dominican',
 			'DZ' => 'Algeria',
 			'EA' => 'Ceuta e Melilla',
 			'EC' => 'Ecuador',
 			'EE' => 'Estonia',
 			'EG' => 'Egypto',
 			'EH' => 'Sahara occidental',
 			'ER' => 'Eritrea',
 			'ES' => 'Espania',
 			'ET' => 'Ethiopia',
 			'EU' => 'Union Europee',
 			'EZ' => 'Zona euro',
 			'FI' => 'Finlandia',
 			'FJ' => 'Fiji',
 			'FK' => 'Insulas Falkland',
 			'FK@alt=variant' => 'Insulas Falkland (Malvinas)',
 			'FM' => 'Micronesia',
 			'FO' => 'Insulas Feroe',
 			'FR' => 'Francia',
 			'GA' => 'Gabon',
 			'GB' => 'Regno Unite',
 			'GB@alt=short' => 'RU',
 			'GD' => 'Grenada',
 			'GE' => 'Georgia',
 			'GF' => 'Guyana francese',
 			'GG' => 'Guernsey',
 			'GH' => 'Ghana',
 			'GI' => 'Gibraltar',
 			'GL' => 'Groenlandia',
 			'GM' => 'Gambia',
 			'GN' => 'Guinea',
 			'GP' => 'Guadeloupe',
 			'GQ' => 'Guinea equatorial',
 			'GR' => 'Grecia',
 			'GS' => 'Georgia del Sud e Insulas Sandwich Austral',
 			'GT' => 'Guatemala',
 			'GU' => 'Guam',
 			'GW' => 'Guinea-Bissau',
 			'GY' => 'Guyana',
 			'HK' => 'Hongkong, R.A.S. de China',
 			'HK@alt=short' => 'Hongkong',
 			'HM' => 'Insulas Heard e McDonald',
 			'HN' => 'Honduras',
 			'HR' => 'Croatia',
 			'HT' => 'Haiti',
 			'HU' => 'Hungaria',
 			'IC' => 'Insulas Canari',
 			'ID' => 'Indonesia',
 			'IE' => 'Irlanda',
 			'IL' => 'Israel',
 			'IM' => 'Insula de Man',
 			'IN' => 'India',
 			'IO' => 'Territorio oceanic britanno-indian',
 			'IO@alt=chagos' => 'Archipelago de Chagos',
 			'IQ' => 'Irak',
 			'IR' => 'Iran',
 			'IS' => 'Islanda',
 			'IT' => 'Italia',
 			'JE' => 'Jersey',
 			'JM' => 'Jamaica',
 			'JO' => 'Jordania',
 			'JP' => 'Japon',
 			'KE' => 'Kenya',
 			'KG' => 'Kirghizistan',
 			'KH' => 'Cambodgia',
 			'KI' => 'Kiribati',
 			'KM' => 'Comoros',
 			'KN' => 'Sancte Christophoro e Nevis',
 			'KP' => 'Corea del Nord',
 			'KR' => 'Corea del Sud',
 			'KW' => 'Kuwait',
 			'KY' => 'Insulas de Caiman',
 			'KZ' => 'Kazakhstan',
 			'LA' => 'Laos',
 			'LB' => 'Libano',
 			'LC' => 'Sancte Lucia',
 			'LI' => 'Liechtenstein',
 			'LK' => 'Sri Lanka',
 			'LR' => 'Liberia',
 			'LS' => 'Lesotho',
 			'LT' => 'Lituania',
 			'LU' => 'Luxemburg',
 			'LV' => 'Lettonia',
 			'LY' => 'Libya',
 			'MA' => 'Marocco',
 			'MC' => 'Monaco',
 			'MD' => 'Moldavia',
 			'ME' => 'Montenegro',
 			'MF' => 'Sancte Martino francese',
 			'MG' => 'Madagascar',
 			'MH' => 'Insulas Marshall',
 			'MK' => 'Macedonia del Nord',
 			'ML' => 'Mali',
 			'MM' => 'Myanmar (Birmania)',
 			'MN' => 'Mongolia',
 			'MO' => 'Macao, R.A.S. de China',
 			'MO@alt=short' => 'Macao',
 			'MP' => 'Insulas Marianna del Nord',
 			'MQ' => 'Martinica',
 			'MR' => 'Mauritania',
 			'MS' => 'Montserrat',
 			'MT' => 'Malta',
 			'MU' => 'Mauritio',
 			'MV' => 'Maldivas',
 			'MW' => 'Malawi',
 			'MX' => 'Mexico',
 			'MY' => 'Malaysia',
 			'MZ' => 'Mozambique',
 			'NA' => 'Namibia',
 			'NC' => 'Nove Caledonia',
 			'NE' => 'Niger',
 			'NF' => 'Insula Norfolk',
 			'NG' => 'Nigeria',
 			'NI' => 'Nicaragua',
 			'NL' => 'Nederlandia',
 			'NO' => 'Norvegia',
 			'NP' => 'Nepal',
 			'NR' => 'Nauru',
 			'NU' => 'Niue',
 			'NZ' => 'Nove Zelanda',
 			'NZ@alt=variant' => 'Aotearoa/Nove Zelanda',
 			'OM' => 'Oman',
 			'PA' => 'Panama',
 			'PE' => 'Peru',
 			'PF' => 'Polynesia francese',
 			'PG' => 'Papua Nove Guinea',
 			'PH' => 'Philippinas',
 			'PK' => 'Pakistan',
 			'PL' => 'Polonia',
 			'PM' => 'St. Pierre e Miquelon',
 			'PN' => 'Insulas Pitcairn',
 			'PR' => 'Porto Rico',
 			'PS' => 'Territorios palestin',
 			'PS@alt=short' => 'Palestina',
 			'PT' => 'Portugal',
 			'PW' => 'Palau',
 			'PY' => 'Paraguay',
 			'QA' => 'Qatar',
 			'QO' => 'Oceania remote',
 			'RE' => 'Reunion',
 			'RO' => 'Romania',
 			'RS' => 'Serbia',
 			'RU' => 'Russia',
 			'RW' => 'Ruanda',
 			'SA' => 'Arabia Saudita',
 			'SB' => 'Insulas Solomon',
 			'SC' => 'Seychelles',
 			'SD' => 'Sudan',
 			'SE' => 'Svedia',
 			'SG' => 'Singapur',
 			'SH' => 'Sancte Helena',
 			'SI' => 'Slovenia',
 			'SJ' => 'Svalbard e Jan Mayen',
 			'SK' => 'Slovachia',
 			'SL' => 'Sierra Leone',
 			'SM' => 'San Marino',
 			'SN' => 'Senegal',
 			'SO' => 'Somalia',
 			'SR' => 'Suriname',
 			'SS' => 'Sudan del Sud',
 			'ST' => 'São Tomé e Príncipe',
 			'SV' => 'El Salvador',
 			'SX' => 'Sancte Martino nederlandese',
 			'SY' => 'Syria',
 			'SZ' => 'Eswatini',
 			'SZ@alt=variant' => 'Swazilandia',
 			'TA' => 'Tristan da Cunha',
 			'TC' => 'Insulas Turcos e Caicos',
 			'TD' => 'Tchad',
 			'TF' => 'Territorios meridional francese',
 			'TG' => 'Togo',
 			'TH' => 'Thailandia',
 			'TJ' => 'Tadzhikistan',
 			'TK' => 'Tokelau',
 			'TL' => 'Timor del Est',
 			'TM' => 'Turkmenistan',
 			'TN' => 'Tunisia',
 			'TO' => 'Tonga',
 			'TR' => 'Turchia',
 			'TT' => 'Trinidad e Tobago',
 			'TV' => 'Tuvalu',
 			'TW' => 'Taiwan',
 			'TZ' => 'Tanzania',
 			'UA' => 'Ukraina',
 			'UG' => 'Uganda',
 			'UM' => 'Insulas peripheric del SUA',
 			'UN' => 'Nationes Unite',
 			'US' => 'Statos Unite',
 			'US@alt=short' => 'SUA',
 			'UY' => 'Uruguay',
 			'UZ' => 'Uzbekistan',
 			'VA' => 'Citate del Vaticano',
 			'VC' => 'Sancte Vincente e le Grenadinas',
 			'VE' => 'Venezuela',
 			'VG' => 'Insulas Virgine britannic',
 			'VI' => 'Insulas Virgine statounitese',
 			'VN' => 'Vietnam',
 			'VU' => 'Vanuatu',
 			'WF' => 'Wallis e Futuna',
 			'WS' => 'Samoa',
 			'XA' => 'Pseudo-accentos',
 			'XB' => 'Pseudo-bidi',
 			'XK' => 'Kosovo',
 			'YE' => 'Yemen',
 			'YT' => 'Mayotte',
 			'ZA' => 'Africa del Sud',
 			'ZM' => 'Zambia',
 			'ZW' => 'Zimbabwe',
 			'ZZ' => 'Region incognite',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'calendario',
 			'cf' => 'formato de moneta',
 			'collation' => 'ordinamento',
 			'currency' => 'moneta',
 			'hc' => 'cyclo horari (12 o 24)',
 			'lb' => 'stilo de salto de linea',
 			'ms' => 'systema de mesura',
 			'numbers' => 'numeros',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{calendario buddhista},
 				'chinese' => q{calendario chinese},
 				'coptic' => q{calendario copte},
 				'dangi' => q{calendario dangi},
 				'ethiopic' => q{calendario ethiope},
 				'ethiopic-amete-alem' => q{calendario ethiope Amete Alem},
 				'gregorian' => q{calendario gregorian},
 				'hebrew' => q{calendario hebraic},
 				'islamic' => q{calendario islamic},
 				'islamic-civil' => q{calendario islamic (tabular, epocha civil)},
 				'islamic-umalqura' => q{calendario islamic (Umm al-Qura)},
 				'iso8601' => q{calendario ISO-8601},
 				'japanese' => q{calendario japonese},
 				'persian' => q{calendario persa},
 				'roc' => q{calendario del Republica de China},
 			},
 			'cf' => {
 				'account' => q{formato de moneta pro contabilitate},
 				'standard' => q{formato de moneta standard},
 			},
 			'collation' => {
 				'ducet' => q{ordinamento Unicode predefinite},
 				'search' => q{recerca generic},
 				'standard' => q{ordinamento standard},
 			},
 			'hc' => {
 				'h11' => q{systema de 12 horas (0–11)},
 				'h12' => q{systema de 12 horas (1–12)},
 				'h23' => q{systema de 24 horas (0–23)},
 				'h24' => q{systema de 24 horas (1–24)},
 			},
 			'lb' => {
 				'loose' => q{stilo de salto de linea flexibile},
 				'normal' => q{stilo de salto de linea normal},
 				'strict' => q{stilo de salto de linea stricte},
 			},
 			'ms' => {
 				'metric' => q{systema metric},
 				'uksystem' => q{systema de mesura imperial},
 				'ussystem' => q{systema de mesura statounitese},
 			},
 			'numbers' => {
 				'arab' => q{cifras indo-arabe},
 				'arabext' => q{cifras indo-arabe extendite},
 				'armn' => q{cifras armenie},
 				'armnlow' => q{cifras armenie minuscule},
 				'beng' => q{cifras bengalese},
 				'cakm' => q{cifras chakma},
 				'deva' => q{cifras devanagari},
 				'ethi' => q{cifras ethiope},
 				'fullwide' => q{cifras in plen largor},
 				'geor' => q{cifras georgian},
 				'grek' => q{cifras grec},
 				'greklow' => q{cifras grec minuscule},
 				'gujr' => q{cifras gujarati},
 				'guru' => q{cifras gurmukhi},
 				'hanidec' => q{cifras decimal chinese},
 				'hans' => q{cifras chinese simplificate},
 				'hansfin' => q{cifras financiari chinese simplificate},
 				'hant' => q{cifras chinese traditional},
 				'hantfin' => q{cifras financiari chinese traditional},
 				'hebr' => q{cifras hebraic},
 				'java' => q{cifras javanese},
 				'jpan' => q{cifras japonese},
 				'jpanfin' => q{cifras financiari japonese},
 				'khmr' => q{cifras khmer},
 				'knda' => q{cifras kannada},
 				'laoo' => q{cifras lao},
 				'latn' => q{cifras occidental},
 				'mlym' => q{cifras malayalam},
 				'mtei' => q{cifras meetei mayek},
 				'mymr' => q{cifras birman},
 				'olck' => q{cifras ol chiki},
 				'orya' => q{cifras oriya},
 				'roman' => q{cifras roman},
 				'romanlow' => q{cifras roman minuscule},
 				'taml' => q{cifras tamil traditional},
 				'tamldec' => q{cifras tamil},
 				'telu' => q{cifras telugu},
 				'thai' => q{cifras thailandese},
 				'tibt' => q{cifras tibetan},
 				'vaii' => q{cifras vai},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{metric},
 			'UK' => q{britannic},
 			'US' => q{statounitese},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'Lingua: {0}',
 			'script' => 'Scriptura: {0}',
 			'region' => 'Region: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[áàăâåäãā æ ç éèĕêëē íìĭîïī ñ óòŏôöøō œ úùŭûüū ÿ]},
			index => ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'],
			main => qr{[a b c d e f g h i j k l m n o p q r s t u v w x y z]},
			punctuation => qr{[\- ‐‑ – — , ; \: ! ? . … '‘’ "“” ( ) \[ \] § @ * / \& # † ‡ ′ ″]},
		};
	},
EOT
: sub {
		return { index => ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'], };
},
);


has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{’},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'hh:mm',
				hms => 'hh:mm:ss',
				ms => 'mm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(direction cardinal),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(direction cardinal),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(deci{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(deci{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(pico{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(pico{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(centi{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(centi{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(milli{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(milli{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(micro{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(micro{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(nano{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(nano{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(tera{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(tera{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(peta{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(peta{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(hecto{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(hecto{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(kilo{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(kilo{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(mega{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(mega{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(giga{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(giga{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'one' => q({0} fortia g),
						'other' => q({0} fortia g),
					},
					# Core Unit Identifier
					'g-force' => {
						'one' => q({0} fortia g),
						'other' => q({0} fortia g),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(metros per secunda quadrate),
						'one' => q({0} metro per secunda quadrate),
						'other' => q({0} metros per secunda quadrate),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(metros per secunda quadrate),
						'one' => q({0} metro per secunda quadrate),
						'other' => q({0} metros per secunda quadrate),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(minutas de arco),
						'one' => q({0} minuta de arco),
						'other' => q({0} minutas de arco),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(minutas de arco),
						'one' => q({0} minuta de arco),
						'other' => q({0} minutas de arco),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(secundas de arco),
						'one' => q({0} secunda de arco),
						'other' => q({0} secundas de arco),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(secundas de arco),
						'one' => q({0} secunda de arco),
						'other' => q({0} secundas de arco),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(grados),
						'one' => q({0} grado),
						'other' => q({0} grados),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(grados),
						'one' => q({0} grado),
						'other' => q({0} grados),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(radianos),
						'one' => q({0} radiano),
						'other' => q({0} radianos),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(radianos),
						'one' => q({0} radiano),
						'other' => q({0} radianos),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(revolutiones),
						'one' => q({0} revolution),
						'other' => q({0} revolutiones),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(revolutiones),
						'one' => q({0} revolution),
						'other' => q({0} revolutiones),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(acres),
						'one' => q({0} acre),
						'other' => q({0} acres),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(acres),
						'one' => q({0} acre),
						'other' => q({0} acres),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(hectares),
						'one' => q({0} hectare),
						'other' => q({0} hectares),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(hectares),
						'one' => q({0} hectare),
						'other' => q({0} hectares),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(centimetros quadrate),
						'one' => q({0} centimetro quadrate),
						'other' => q({0} centimetros quadrate),
						'per' => q({0} per centimetro quadrate),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(centimetros quadrate),
						'one' => q({0} centimetro quadrate),
						'other' => q({0} centimetros quadrate),
						'per' => q({0} per centimetro quadrate),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(pedes quadrate),
						'one' => q({0} pede quadrate),
						'other' => q({0} pedes quadrate),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(pedes quadrate),
						'one' => q({0} pede quadrate),
						'other' => q({0} pedes quadrate),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(pollices quadrate),
						'one' => q({0} pollice quadrate),
						'other' => q({0} pollices quadrate),
						'per' => q({0} per pollice quadrate),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(pollices quadrate),
						'one' => q({0} pollice quadrate),
						'other' => q({0} pollices quadrate),
						'per' => q({0} per pollice quadrate),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(kilometros quadrate),
						'one' => q({0} kilometro quadrate),
						'other' => q({0} kilometros quadrate),
						'per' => q({0} per kilometro quadrate),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(kilometros quadrate),
						'one' => q({0} kilometro quadrate),
						'other' => q({0} kilometros quadrate),
						'per' => q({0} per kilometro quadrate),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(metros quadrate),
						'one' => q({0} metro quadrate),
						'other' => q({0} metros quadrate),
						'per' => q({0} per metro quadrate),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(metros quadrate),
						'one' => q({0} metro quadrate),
						'other' => q({0} metros quadrate),
						'per' => q({0} per metro quadrate),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(millias quadrate),
						'one' => q({0} millia quadrate),
						'other' => q({0} millias quadrate),
						'per' => q({0} per millia quadrate),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(millias quadrate),
						'one' => q({0} millia quadrate),
						'other' => q({0} millias quadrate),
						'per' => q({0} per millia quadrate),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(yards quadrate),
						'one' => q({0} yard quadrate),
						'other' => q({0} yards quadrate),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(yards quadrate),
						'one' => q({0} yard quadrate),
						'other' => q({0} yards quadrate),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(carates),
						'one' => q({0} carat),
						'other' => q({0} carates),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(carates),
						'one' => q({0} carat),
						'other' => q({0} carates),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(milligrammas per decilitro),
						'one' => q({0} milligramma per decilitro),
						'other' => q({0} milligrammas per decilitro),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(milligrammas per decilitro),
						'one' => q({0} milligramma per decilitro),
						'other' => q({0} milligrammas per decilitro),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(millimoles per litro),
						'one' => q({0} millimol per litro),
						'other' => q({0} millimoles per litro),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(millimoles per litro),
						'one' => q({0} millimol per litro),
						'other' => q({0} millimoles per litro),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(per cento),
						'one' => q({0} per cento),
						'other' => q({0} per cento),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(per cento),
						'one' => q({0} per cento),
						'other' => q({0} per cento),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(per mille),
						'one' => q({0} per mille),
						'other' => q({0} per mille),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(per mille),
						'one' => q({0} per mille),
						'other' => q({0} per mille),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(partes per million),
						'one' => q({0} parte per million),
						'other' => q({0} partes per million),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(partes per million),
						'one' => q({0} parte per million),
						'other' => q({0} partes per million),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(litros per 100 kilometros),
						'one' => q({0} litro per 100 kilometros),
						'other' => q({0} litros per 100 kilometros),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(litros per 100 kilometros),
						'one' => q({0} litro per 100 kilometros),
						'other' => q({0} litros per 100 kilometros),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(litros per kilometro),
						'one' => q({0} litro per kilometro),
						'other' => q({0} litros per kilometro),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(litros per kilometro),
						'one' => q({0} litro per kilometro),
						'other' => q({0} litros per kilometro),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(millias per gallon),
						'one' => q({0} millia per gallon),
						'other' => q({0} millias per gallon),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(millias per gallon),
						'one' => q({0} millia per gallon),
						'other' => q({0} millias per gallon),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(millias per gallon imperial),
						'one' => q({0} millia per gallon imperial),
						'other' => q({0} millias per gallon imperial),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(millias per gallon imperial),
						'one' => q({0} millia per gallon imperial),
						'other' => q({0} millias per gallon imperial),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} est),
						'north' => q({0} nord),
						'south' => q({0} sud),
						'west' => q({0} west),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} est),
						'north' => q({0} nord),
						'south' => q({0} sud),
						'west' => q({0} west),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(bits),
						'one' => q({0} bit),
						'other' => q({0} bits),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(bits),
						'one' => q({0} bit),
						'other' => q({0} bits),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(bytes),
						'one' => q({0} byte),
						'other' => q({0} bytes),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(bytes),
						'one' => q({0} byte),
						'other' => q({0} bytes),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(gigabits),
						'one' => q({0} gigabit),
						'other' => q({0} gigabits),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(gigabits),
						'one' => q({0} gigabit),
						'other' => q({0} gigabits),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(gigabytes),
						'one' => q({0} gigabyte),
						'other' => q({0} gigabytes),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(gigabytes),
						'one' => q({0} gigabyte),
						'other' => q({0} gigabytes),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(kilobits),
						'one' => q({0} kilobit),
						'other' => q({0} kilobits),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(kilobits),
						'one' => q({0} kilobit),
						'other' => q({0} kilobits),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(kilobytes),
						'one' => q({0} kilobyte),
						'other' => q({0} kilobytes),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(kilobytes),
						'one' => q({0} kilobyte),
						'other' => q({0} kilobytes),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(megabits),
						'one' => q({0} megabit),
						'other' => q({0} megabits),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(megabits),
						'one' => q({0} megabit),
						'other' => q({0} megabits),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(megabytes),
						'one' => q({0} megabyte),
						'other' => q({0} megabytes),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(megabytes),
						'one' => q({0} megabyte),
						'other' => q({0} megabytes),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(petabytes),
						'one' => q({0} petabyte),
						'other' => q({0} petabytes),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(petabytes),
						'one' => q({0} petabyte),
						'other' => q({0} petabytes),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(terabits),
						'one' => q({0} terabit),
						'other' => q({0} terabits),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(terabits),
						'one' => q({0} terabit),
						'other' => q({0} terabits),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(terabytes),
						'one' => q({0} terabyte),
						'other' => q({0} terabytes),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(terabytes),
						'one' => q({0} terabyte),
						'other' => q({0} terabytes),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(seculos),
						'one' => q({0} seculo),
						'other' => q({0} seculos),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(seculos),
						'one' => q({0} seculo),
						'other' => q({0} seculos),
					},
					# Long Unit Identifier
					'duration-day' => {
						'per' => q({0} per die),
					},
					# Core Unit Identifier
					'day' => {
						'per' => q({0} per die),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'one' => q({0} hora),
						'other' => q({0} horas),
						'per' => q({0} per hora),
					},
					# Core Unit Identifier
					'hour' => {
						'one' => q({0} hora),
						'other' => q({0} horas),
						'per' => q({0} per hora),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(microsecundas),
						'one' => q({0} microsecunda),
						'other' => q({0} microsecundas),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(microsecundas),
						'one' => q({0} microsecunda),
						'other' => q({0} microsecundas),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(millisecundas),
						'one' => q({0} millisecunda),
						'other' => q({0} millisecundas),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(millisecundas),
						'one' => q({0} millisecunda),
						'other' => q({0} millisecundas),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(minutas),
						'one' => q({0} minuta),
						'other' => q({0} minutas),
						'per' => q({0} per minuta),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(minutas),
						'one' => q({0} minuta),
						'other' => q({0} minutas),
						'per' => q({0} per minuta),
					},
					# Long Unit Identifier
					'duration-month' => {
						'per' => q({0} per mense),
					},
					# Core Unit Identifier
					'month' => {
						'per' => q({0} per mense),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(nanosecundas),
						'one' => q({0} nanosecunda),
						'other' => q({0} nanosecundas),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(nanosecundas),
						'one' => q({0} nanosecunda),
						'other' => q({0} nanosecundas),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(secundas),
						'one' => q({0} secunda),
						'other' => q({0} secundas),
						'per' => q({0} per secunda),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(secundas),
						'one' => q({0} secunda),
						'other' => q({0} secundas),
						'per' => q({0} per secunda),
					},
					# Long Unit Identifier
					'duration-week' => {
						'one' => q({0} septimana),
						'other' => q({0} septimanas),
						'per' => q({0} per septimana),
					},
					# Core Unit Identifier
					'week' => {
						'one' => q({0} septimana),
						'other' => q({0} septimanas),
						'per' => q({0} per septimana),
					},
					# Long Unit Identifier
					'duration-year' => {
						'one' => q({0} anno),
						'other' => q({0} annos),
						'per' => q({0} per anno),
					},
					# Core Unit Identifier
					'year' => {
						'one' => q({0} anno),
						'other' => q({0} annos),
						'per' => q({0} per anno),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(amperes),
						'one' => q({0} ampere),
						'other' => q({0} amperes),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(amperes),
						'one' => q({0} ampere),
						'other' => q({0} amperes),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(milliamperes),
						'one' => q({0} milliampere),
						'other' => q({0} milliamperes),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(milliamperes),
						'one' => q({0} milliampere),
						'other' => q({0} milliamperes),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(ohms),
						'one' => q({0} ohm),
						'other' => q({0} ohms),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(ohms),
						'one' => q({0} ohm),
						'other' => q({0} ohms),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(volts),
						'one' => q({0} volt),
						'other' => q({0} volts),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(volts),
						'one' => q({0} volt),
						'other' => q({0} volts),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(calorias),
						'one' => q({0} caloria),
						'other' => q({0} calorias),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(calorias),
						'one' => q({0} caloria),
						'other' => q({0} calorias),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(kilocalorias),
						'one' => q({0} kilocaloria),
						'other' => q({0} kilocalorias),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(kilocalorias),
						'one' => q({0} kilocaloria),
						'other' => q({0} kilocalorias),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(joules),
						'one' => q({0} joule),
						'other' => q({0} joules),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(joules),
						'one' => q({0} joule),
						'other' => q({0} joules),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(kilocalorias),
						'one' => q({0} kilocaloria),
						'other' => q({0} kilocalorias),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(kilocalorias),
						'one' => q({0} kilocaloria),
						'other' => q({0} kilocalorias),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(kilojoules),
						'one' => q({0} kilojoule),
						'other' => q({0} kilojoules),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(kilojoules),
						'one' => q({0} kilojoule),
						'other' => q({0} kilojoules),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(kilowatthoras),
						'one' => q({0} kilowatthora),
						'other' => q({0} kilowatthoras),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(kilowatthoras),
						'one' => q({0} kilowatthora),
						'other' => q({0} kilowatthoras),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(gigahertz),
						'one' => q({0} gigahertz),
						'other' => q({0} gigahertz),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(gigahertz),
						'one' => q({0} gigahertz),
						'other' => q({0} gigahertz),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(hertz),
						'one' => q({0} hertz),
						'other' => q({0} hertz),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(hertz),
						'one' => q({0} hertz),
						'other' => q({0} hertz),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(kilohertz),
						'one' => q({0} kilohertz),
						'other' => q({0} kilohertz),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(kilohertz),
						'one' => q({0} kilohertz),
						'other' => q({0} kilohertz),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(megahertz),
						'one' => q({0} megahertz),
						'other' => q({0} megahertz),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(megahertz),
						'one' => q({0} megahertz),
						'other' => q({0} megahertz),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(unitates astronomic),
						'one' => q({0} unitate astronomic),
						'other' => q({0} unitates astronomic),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(unitates astronomic),
						'one' => q({0} unitate astronomic),
						'other' => q({0} unitates astronomic),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(centimetros),
						'one' => q({0} centimetro),
						'other' => q({0} centimetros),
						'per' => q({0} per centimetro),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(centimetros),
						'one' => q({0} centimetro),
						'other' => q({0} centimetros),
						'per' => q({0} per centimetro),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(decimetros),
						'one' => q({0} decimetro),
						'other' => q({0} decimetros),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(decimetros),
						'one' => q({0} decimetro),
						'other' => q({0} decimetros),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(pedes),
						'one' => q({0} pede),
						'other' => q({0} pedes),
						'per' => q({0} per pede),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(pedes),
						'one' => q({0} pede),
						'other' => q({0} pedes),
						'per' => q({0} per pede),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(pollices),
						'one' => q({0} pollice),
						'other' => q({0} pollices),
						'per' => q({0} per pollice),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(pollices),
						'one' => q({0} pollice),
						'other' => q({0} pollices),
						'per' => q({0} per pollice),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(kilometros),
						'one' => q({0} kilometro),
						'other' => q({0} kilometros),
						'per' => q({0} per kilometro),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(kilometros),
						'one' => q({0} kilometro),
						'other' => q({0} kilometros),
						'per' => q({0} per kilometro),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(annos lumine),
						'one' => q({0} anno lumine),
						'other' => q({0} annos lumine),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(annos lumine),
						'one' => q({0} anno lumine),
						'other' => q({0} annos lumine),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(metros),
						'one' => q({0} metro),
						'other' => q({0} metros),
						'per' => q({0} per metro),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(metros),
						'one' => q({0} metro),
						'other' => q({0} metros),
						'per' => q({0} per metro),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(micrometros),
						'one' => q({0} micrometro),
						'other' => q({0} micrometros),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(micrometros),
						'one' => q({0} micrometro),
						'other' => q({0} micrometros),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(millias),
						'one' => q({0} millia),
						'other' => q({0} millias),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(millias),
						'one' => q({0} millia),
						'other' => q({0} millias),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(millias scandinave),
						'one' => q({0} millia scandinave),
						'other' => q({0} millias scandinave),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(millias scandinave),
						'one' => q({0} millia scandinave),
						'other' => q({0} millias scandinave),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(millimetros),
						'one' => q({0} millimetro),
						'other' => q({0} millimetros),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(millimetros),
						'one' => q({0} millimetro),
						'other' => q({0} millimetros),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(nanometros),
						'one' => q({0} nanometro),
						'other' => q({0} nanometros),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(nanometros),
						'one' => q({0} nanometro),
						'other' => q({0} nanometros),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(millias nautic),
						'one' => q({0} millia nautic),
						'other' => q({0} millias nautic),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(millias nautic),
						'one' => q({0} millia nautic),
						'other' => q({0} millias nautic),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(parsecs),
						'one' => q({0} parsec),
						'other' => q({0} parsecs),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(parsecs),
						'one' => q({0} parsec),
						'other' => q({0} parsecs),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(picometros),
						'one' => q({0} picometro),
						'other' => q({0} picometros),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(picometros),
						'one' => q({0} picometro),
						'other' => q({0} picometros),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(punctos),
						'one' => q({0} puncto),
						'other' => q({0} punctos),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(punctos),
						'one' => q({0} puncto),
						'other' => q({0} punctos),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(yards),
						'one' => q({0} yard),
						'other' => q({0} yards),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(yards),
						'one' => q({0} yard),
						'other' => q({0} yards),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(lux),
						'one' => q({0} lux),
						'other' => q({0} lux),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(lux),
						'one' => q({0} lux),
						'other' => q({0} lux),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(carates),
						'one' => q({0} carat),
						'other' => q({0} carates),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(carates),
						'one' => q({0} carat),
						'other' => q({0} carates),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(grammas),
						'one' => q({0} gramma),
						'other' => q({0} grammas),
						'per' => q({0} per gramma),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(grammas),
						'one' => q({0} gramma),
						'other' => q({0} grammas),
						'per' => q({0} per gramma),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(kilogrammas),
						'one' => q({0} kilogramma),
						'other' => q({0} kilogrammas),
						'per' => q({0} per kilogramma),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(kilogrammas),
						'one' => q({0} kilogramma),
						'other' => q({0} kilogrammas),
						'per' => q({0} per kilogramma),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(microgrammas),
						'one' => q({0} microgramma),
						'other' => q({0} microgrammas),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(microgrammas),
						'one' => q({0} microgramma),
						'other' => q({0} microgrammas),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(milligrammas),
						'one' => q({0} milligramma),
						'other' => q({0} milligrammas),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(milligrammas),
						'one' => q({0} milligramma),
						'other' => q({0} milligrammas),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(uncias),
						'one' => q({0} uncia),
						'other' => q({0} uncias),
						'per' => q({0} per uncia),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(uncias),
						'one' => q({0} uncia),
						'other' => q({0} uncias),
						'per' => q({0} per uncia),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(uncias troy),
						'one' => q({0} uncia troy),
						'other' => q({0} uncias troy),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(uncias troy),
						'one' => q({0} uncia troy),
						'other' => q({0} uncias troy),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(libras),
						'one' => q({0} libra),
						'other' => q({0} libras),
						'per' => q({0} per libra),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(libras),
						'one' => q({0} libra),
						'other' => q({0} libras),
						'per' => q({0} per libra),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(tonnas curte),
						'one' => q({0} tonna curte),
						'other' => q({0} tonnas curte),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(tonnas curte),
						'one' => q({0} tonna curte),
						'other' => q({0} tonnas curte),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'name' => q(tonnas),
						'one' => q({0} tonna),
						'other' => q({0} tonnas),
					},
					# Core Unit Identifier
					'tonne' => {
						'name' => q(tonnas),
						'one' => q({0} tonna),
						'other' => q({0} tonnas),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0} per {1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0} per {1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(gigawatts),
						'one' => q({0} gigawatt),
						'other' => q({0} gigawatts),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(gigawatts),
						'one' => q({0} gigawatt),
						'other' => q({0} gigawatts),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(cavallos-vapor),
						'one' => q({0} cavallo-vapor),
						'other' => q({0} cavallos-vapor),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(cavallos-vapor),
						'one' => q({0} cavallo-vapor),
						'other' => q({0} cavallos-vapor),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(kilowatts),
						'one' => q({0} kilowatt),
						'other' => q({0} kilowatts),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(kilowatts),
						'one' => q({0} kilowatt),
						'other' => q({0} kilowatts),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(megawatts),
						'one' => q({0} megawatt),
						'other' => q({0} megawatts),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(megawatts),
						'one' => q({0} megawatt),
						'other' => q({0} megawatts),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(milliwatts),
						'one' => q({0} milliwatt),
						'other' => q({0} milliwatts),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(milliwatts),
						'one' => q({0} milliwatt),
						'other' => q({0} milliwatts),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(watts),
						'one' => q({0} watt),
						'other' => q({0} watts),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(watts),
						'one' => q({0} watt),
						'other' => q({0} watts),
					},
					# Long Unit Identifier
					'power2' => {
						'one' => q({0} quadrate),
						'other' => q({0} quadrate),
					},
					# Core Unit Identifier
					'power2' => {
						'one' => q({0} quadrate),
						'other' => q({0} quadrate),
					},
					# Long Unit Identifier
					'power3' => {
						'one' => q({0} cubic),
						'other' => q({0} cubic),
					},
					# Core Unit Identifier
					'power3' => {
						'one' => q({0} cubic),
						'other' => q({0} cubic),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(atmospheras),
						'one' => q({0} atmosphera),
						'other' => q({0} atmospheras),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(atmospheras),
						'one' => q({0} atmosphera),
						'other' => q({0} atmospheras),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(hectopascales),
						'one' => q({0} hectopascal),
						'other' => q({0} hectopascales),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(hectopascales),
						'one' => q({0} hectopascal),
						'other' => q({0} hectopascales),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(pollices de mercurio),
						'one' => q({0} pollice de mercurio),
						'other' => q({0} pollices de mercurio),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(pollices de mercurio),
						'one' => q({0} pollice de mercurio),
						'other' => q({0} pollices de mercurio),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(millibares),
						'one' => q({0} millibar),
						'other' => q({0} millibares),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(millibares),
						'one' => q({0} millibar),
						'other' => q({0} millibares),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(milimetros de mercurio),
						'one' => q({0} millimetro de mercurio),
						'other' => q({0} millimetros de mercurio),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(milimetros de mercurio),
						'one' => q({0} millimetro de mercurio),
						'other' => q({0} millimetros de mercurio),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(libras-fortia per pollice quadrate),
						'one' => q({0} libra-fortia per pollice quadrate),
						'other' => q({0} libras-fortia per pollice quadrate),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(libras-fortia per pollice quadrate),
						'one' => q({0} libra-fortia per pollice quadrate),
						'other' => q({0} libras-fortia per pollice quadrate),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(kilometros per hora),
						'one' => q({0} kilometro per hora),
						'other' => q({0} kilometros per hora),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(kilometros per hora),
						'one' => q({0} kilometro per hora),
						'other' => q({0} kilometros per hora),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(nodos),
						'one' => q({0} nodo),
						'other' => q({0} nodos),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(nodos),
						'one' => q({0} nodo),
						'other' => q({0} nodos),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(metros per secunda),
						'one' => q({0} metro per secunda),
						'other' => q({0} metros per secunda),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(metros per secunda),
						'one' => q({0} metro per secunda),
						'other' => q({0} metros per secunda),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(millias per hora),
						'one' => q({0} millia per hora),
						'other' => q({0} millias per hora),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(millias per hora),
						'one' => q({0} millia per hora),
						'other' => q({0} millias per hora),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(grados Celcius),
						'one' => q({0} grado Celcius),
						'other' => q({0} grados Celcius),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(grados Celcius),
						'one' => q({0} grado Celcius),
						'other' => q({0} grados Celcius),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(grados Fahrenheit),
						'one' => q({0} grado Fahrenheit),
						'other' => q({0} grados Fahrenheit),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(grados Fahrenheit),
						'one' => q({0} grado Fahrenheit),
						'other' => q({0} grados Fahrenheit),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'name' => q(grados),
						'one' => q({0} grado),
						'other' => q({0} grados),
					},
					# Core Unit Identifier
					'generic' => {
						'name' => q(grados),
						'one' => q({0} grado),
						'other' => q({0} grados),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(kelvin),
						'one' => q({0} kelvin),
						'other' => q({0} kelvin),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(kelvin),
						'one' => q({0} kelvin),
						'other' => q({0} kelvin),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(acre-pedes),
						'one' => q({0} acre-pede),
						'other' => q({0} acre-pedes),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(acre-pedes),
						'one' => q({0} acre-pede),
						'other' => q({0} acre-pedes),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(barriles),
						'one' => q({0} barriles),
						'other' => q({0} barriles),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(barriles),
						'one' => q({0} barriles),
						'other' => q({0} barriles),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'one' => q({0} bushel),
						'other' => q({0} bushels),
					},
					# Core Unit Identifier
					'bushel' => {
						'one' => q({0} bushel),
						'other' => q({0} bushels),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(centilitros),
						'one' => q({0} centilitro),
						'other' => q({0} centilitros),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(centilitros),
						'one' => q({0} centilitro),
						'other' => q({0} centilitros),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(centimetros cubic),
						'one' => q({0} centimetro cubic),
						'other' => q({0} centimetros cubic),
						'per' => q({0} per centimetro cubic),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(centimetros cubic),
						'one' => q({0} centimetro cubic),
						'other' => q({0} centimetros cubic),
						'per' => q({0} per centimetro cubic),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(pedes cubic),
						'one' => q({0} pede cubic),
						'other' => q({0} pedes cubic),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(pedes cubic),
						'one' => q({0} pede cubic),
						'other' => q({0} pedes cubic),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(inches cubic),
						'one' => q({0} inch cubic),
						'other' => q({0} inches cubic),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(inches cubic),
						'one' => q({0} inch cubic),
						'other' => q({0} inches cubic),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(kilometros cubic),
						'one' => q({0} kilometro cubic),
						'other' => q({0} kilometros cubic),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(kilometros cubic),
						'one' => q({0} kilometro cubic),
						'other' => q({0} kilometros cubic),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(metros cubic),
						'one' => q({0} metro cubic),
						'other' => q({0} metros cubic),
						'per' => q({0} per metro cubic),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(metros cubic),
						'one' => q({0} metro cubic),
						'other' => q({0} metros cubic),
						'per' => q({0} per metro cubic),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(millias cubic),
						'one' => q({0} millia cubic),
						'other' => q({0} millias cubic),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(millias cubic),
						'one' => q({0} millia cubic),
						'other' => q({0} millias cubic),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(yards cubic),
						'one' => q({0} yard cubic),
						'other' => q({0} yards cubic),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(yards cubic),
						'one' => q({0} yard cubic),
						'other' => q({0} yards cubic),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(tassas),
						'one' => q({0} tassa),
						'other' => q({0} tassas),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(tassas),
						'one' => q({0} tassa),
						'other' => q({0} tassas),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(tassas metric),
						'one' => q({0} tassa metric),
						'other' => q({0} tassas metric),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(tassas metric),
						'one' => q({0} tassa metric),
						'other' => q({0} tassas metric),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(decilitros),
						'one' => q({0} decilitro),
						'other' => q({0} decilitros),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(decilitros),
						'one' => q({0} decilitro),
						'other' => q({0} decilitros),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(coclearatas a dessert),
						'one' => q({0} coclearata a dessert),
						'other' => q({0} coclearatas a dessert),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(coclearatas a dessert),
						'one' => q({0} coclearata a dessert),
						'other' => q({0} coclearatas a dessert),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(coclearatas a dessert imperial),
						'one' => q({0} coclearata a dessert imperial),
						'other' => q({0} coclearatas a dessert imperial),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(coclearatas a dessert imperial),
						'one' => q({0} coclearata a dessert imperial),
						'other' => q({0} coclearatas a dessert imperial),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(drachmas liquide),
						'one' => q({0} drachma liquide),
						'other' => q({0} drachmas liquide),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(drachmas liquide),
						'one' => q({0} drachma liquide),
						'other' => q({0} drachmas liquide),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(uncias liquide),
						'one' => q({0} uncia liquide),
						'other' => q({0} uncias liquide),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(uncias liquide),
						'one' => q({0} uncia liquide),
						'other' => q({0} uncias liquide),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(uncias liquide imperial),
						'one' => q({0} uncia liquide imperial),
						'other' => q({0} uncias liquide imperial),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(uncias liquide imperial),
						'one' => q({0} uncia liquide imperial),
						'other' => q({0} uncias liquide imperial),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(gallones),
						'one' => q({0} gallon),
						'other' => q({0} gallones),
						'per' => q({0} per gallon),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(gallones),
						'one' => q({0} gallon),
						'other' => q({0} gallones),
						'per' => q({0} per gallon),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(gallones imp.),
						'one' => q({0} gallon imp.),
						'other' => q({0} gallones imp.),
						'per' => q({0} per gallon imp.),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(gallones imp.),
						'one' => q({0} gallon imp.),
						'other' => q({0} gallones imp.),
						'per' => q({0} per gallon imp.),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(hectolitros),
						'one' => q({0} hectolitro),
						'other' => q({0} hectolitros),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(hectolitros),
						'one' => q({0} hectolitro),
						'other' => q({0} hectolitros),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'one' => q({0} litro),
						'other' => q({0} litros),
						'per' => q({0} per litro),
					},
					# Core Unit Identifier
					'liter' => {
						'one' => q({0} litro),
						'other' => q({0} litros),
						'per' => q({0} per litro),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(megalitros),
						'one' => q({0} megalitro),
						'other' => q({0} megalitros),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(megalitros),
						'one' => q({0} megalitro),
						'other' => q({0} megalitros),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(millilitros),
						'one' => q({0} millilitro),
						'other' => q({0} millilitros),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(millilitros),
						'one' => q({0} millilitro),
						'other' => q({0} millilitros),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(pinciatas),
						'one' => q({0} pinciata),
						'other' => q({0} pinciatas),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(pinciatas),
						'one' => q({0} pinciata),
						'other' => q({0} pinciatas),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'one' => q({0} pinta),
						'other' => q({0} pintas),
					},
					# Core Unit Identifier
					'pint' => {
						'one' => q({0} pinta),
						'other' => q({0} pintas),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(pintas metric),
						'one' => q({0} pinta metric),
						'other' => q({0} pintas metric),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(pintas metric),
						'one' => q({0} pinta metric),
						'other' => q({0} pintas metric),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(quartos),
						'one' => q({0} quarto),
						'other' => q({0} quartos),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(quartos),
						'one' => q({0} quarto),
						'other' => q({0} quartos),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(coclearatas a suppa),
						'one' => q({0} coclearata a suppa),
						'other' => q({0} coclearatas a suppa),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(coclearatas a suppa),
						'one' => q({0} coclearata a suppa),
						'other' => q({0} coclearatas a suppa),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(coclearatas a the),
						'one' => q({0} coclearata a the),
						'other' => q({0} coclearatas a the),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(coclearatas a the),
						'one' => q({0} coclearata a the),
						'other' => q({0} coclearatas a the),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'' => {
						'name' => q(dir.),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(dir.),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(die),
						'one' => q({0}d),
						'other' => q({0}d),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(die),
						'one' => q({0}d),
						'other' => q({0}d),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(hora),
						'one' => q({0}h),
						'other' => q({0}h),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(hora),
						'one' => q({0}h),
						'other' => q({0}h),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'one' => q({0} μs),
						'other' => q({0}μs),
					},
					# Core Unit Identifier
					'microsecond' => {
						'one' => q({0} μs),
						'other' => q({0}μs),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'one' => q({0}ms),
						'other' => q({0}ms),
					},
					# Core Unit Identifier
					'millisecond' => {
						'one' => q({0}ms),
						'other' => q({0}ms),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'one' => q({0}m),
						'other' => q({0}m),
					},
					# Core Unit Identifier
					'minute' => {
						'one' => q({0}m),
						'other' => q({0}m),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(mense),
						'one' => q({0}m),
						'other' => q({0}m),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(mense),
						'one' => q({0}m),
						'other' => q({0}m),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(s),
						'one' => q({0}s),
						'other' => q({0}s),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(s),
						'one' => q({0}s),
						'other' => q({0}s),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(sept.),
						'one' => q({0}sept),
						'other' => q({0}sept),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(sept.),
						'one' => q({0}sept),
						'other' => q({0}sept),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(an),
						'one' => q({0}an),
						'other' => q({0}an),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(an),
						'one' => q({0}an),
						'other' => q({0}an),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'one' => q({0}cm),
						'other' => q({0}cm),
					},
					# Core Unit Identifier
					'centimeter' => {
						'one' => q({0}cm),
						'other' => q({0}cm),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'one' => q({0}km),
						'other' => q({0}km),
					},
					# Core Unit Identifier
					'kilometer' => {
						'one' => q({0}km),
						'other' => q({0}km),
					},
					# Long Unit Identifier
					'length-meter' => {
						'one' => q({0}m),
						'other' => q({0}m),
					},
					# Core Unit Identifier
					'meter' => {
						'one' => q({0}m),
						'other' => q({0}m),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'one' => q({0}mm),
						'other' => q({0}mm),
					},
					# Core Unit Identifier
					'millimeter' => {
						'one' => q({0}mm),
						'other' => q({0}mm),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'one' => q({0}acpd),
						'other' => q({0}acpd),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'one' => q({0}acpd),
						'other' => q({0}acpd),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(bbl),
						'one' => q({0}bbl),
						'other' => q({0}bbl),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(bbl),
						'one' => q({0}bbl),
						'other' => q({0}bbl),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(bushel),
						'one' => q({0}bu),
						'other' => q({0}bu),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(bushel),
						'one' => q({0}bu),
						'other' => q({0}bu),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'one' => q({0}cl),
						'other' => q({0}cl),
					},
					# Core Unit Identifier
					'centiliter' => {
						'one' => q({0}cl),
						'other' => q({0}cl),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'one' => q({0}cm³),
						'other' => q({0}cm³),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'one' => q({0}cm³),
						'other' => q({0}cm³),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'one' => q({0}pd³),
						'other' => q({0}pd³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'one' => q({0}pd³),
						'other' => q({0}pd³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'one' => q({0}in³),
						'other' => q({0}in³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'one' => q({0}in³),
						'other' => q({0}in³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'one' => q({0}km³),
						'other' => q({0}km³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'one' => q({0}km³),
						'other' => q({0}km³),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'one' => q({0}m³),
						'other' => q({0}m³),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'one' => q({0}m³),
						'other' => q({0}m³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'one' => q({0}mi³),
						'other' => q({0}mi³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'one' => q({0}mi³),
						'other' => q({0}mi³),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'one' => q({0}yd³),
						'other' => q({0}yd³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'one' => q({0}yd³),
						'other' => q({0}yd³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'one' => q({0}t),
						'other' => q({0}t),
					},
					# Core Unit Identifier
					'cup' => {
						'one' => q({0}t),
						'other' => q({0}t),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'one' => q({0}tm),
						'other' => q({0}tm),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'one' => q({0}tm),
						'other' => q({0}tm),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'one' => q({0}dl),
						'other' => q({0}dl),
					},
					# Core Unit Identifier
					'deciliter' => {
						'one' => q({0}dl),
						'other' => q({0}dl),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(c. a dessert),
						'one' => q({0}CaD),
						'other' => q({0}CaD),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(c. a dessert),
						'one' => q({0}CaD),
						'other' => q({0}CaD),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(c. a dsrt imp.),
						'one' => q({0}CaDi),
						'other' => q({0}CaDi),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(c. a dsrt imp.),
						'one' => q({0}CaDi),
						'other' => q({0}CaDi),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(dr.liq.),
						'one' => q({0}drliq),
						'other' => q({0}drliq),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(dr.liq.),
						'one' => q({0}drliq),
						'other' => q({0}drliq),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(gutta),
						'one' => q({0}gt),
						'other' => q({0}gt),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(gutta),
						'one' => q({0}gt),
						'other' => q({0}gt),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'one' => q({0}ozliq),
						'other' => q({0}ozliq),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'one' => q({0}ozliq),
						'other' => q({0}ozliq),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(oz liq imp),
						'one' => q({0}ozli),
						'other' => q({0}ozli),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(oz liq imp),
						'one' => q({0}ozli),
						'other' => q({0}ozli),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'one' => q({0}gal),
						'other' => q({0}gal),
					},
					# Core Unit Identifier
					'gallon' => {
						'one' => q({0}gal),
						'other' => q({0}gal),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'one' => q({0}galim),
						'other' => q({0}galim),
						'per' => q({0}/galim),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'one' => q({0}galim),
						'other' => q({0}galim),
						'per' => q({0}/galim),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'one' => q({0}hl),
						'other' => q({0}hl),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'one' => q({0}hl),
						'other' => q({0}hl),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'one' => q({0}jigger),
						'other' => q({0}jigger),
					},
					# Core Unit Identifier
					'jigger' => {
						'one' => q({0}jigger),
						'other' => q({0}jigger),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'one' => q({0}Ml),
						'other' => q({0}Ml),
					},
					# Core Unit Identifier
					'megaliter' => {
						'one' => q({0}Ml),
						'other' => q({0}Ml),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'one' => q({0}ml),
						'other' => q({0}ml),
					},
					# Core Unit Identifier
					'milliliter' => {
						'one' => q({0}ml),
						'other' => q({0}ml),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'one' => q({0}pt),
						'other' => q({0}pt),
					},
					# Core Unit Identifier
					'pint' => {
						'one' => q({0}pt),
						'other' => q({0}pt),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(pt),
						'one' => q({0}pt),
						'other' => q({0}pt),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(pt),
						'one' => q({0}pt),
						'other' => q({0}pt),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'one' => q({0}qt),
						'other' => q({0}qt),
					},
					# Core Unit Identifier
					'quart' => {
						'one' => q({0}qt),
						'other' => q({0}qt),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(c. a suppa),
						'one' => q({0}CaS),
						'other' => q({0}CaS),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(c. a suppa),
						'one' => q({0}CaS),
						'other' => q({0}CaS),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(c. a the),
						'one' => q({0}CaT),
						'other' => q({0}CaT),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(c. a the),
						'one' => q({0}CaT),
						'other' => q({0}CaT),
					},
				},
				'short' => {
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(fortia g),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(fortia g),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(′),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(′),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(″),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(″),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(°),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(°),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(ac),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(ac),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(ha),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(ha),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(mi/gal),
						'one' => q({0} mi/gal),
						'other' => q({0} mi/gal),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(mi/gal),
						'one' => q({0} mi/gal),
						'other' => q({0} mi/gal),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(mi/gal imp.),
						'one' => q({0} mi/gal imp.),
						'other' => q({0} mi/gal imp.),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(mi/gal imp.),
						'one' => q({0} mi/gal imp.),
						'other' => q({0} mi/gal imp.),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} E),
						'north' => q({0} N),
						'south' => q({0} S),
						'west' => q({0} W),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} E),
						'north' => q({0} N),
						'south' => q({0} S),
						'west' => q({0} W),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(b),
						'one' => q({0} b),
						'other' => q({0} b),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(b),
						'one' => q({0} b),
						'other' => q({0} b),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(B),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(B),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(scl),
						'one' => q({0} scl),
						'other' => q({0} scl),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(scl),
						'one' => q({0} scl),
						'other' => q({0} scl),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(dies),
						'one' => q({0} die),
						'other' => q({0} dies),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(dies),
						'one' => q({0} die),
						'other' => q({0} dies),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(horas),
						'one' => q({0} hr),
						'other' => q({0} hr),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(horas),
						'one' => q({0} hr),
						'other' => q({0} hr),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(millisec),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(millisec),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(menses),
						'one' => q({0} mense),
						'other' => q({0} menses),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(menses),
						'one' => q({0} mense),
						'other' => q({0} menses),
					},
					# Long Unit Identifier
					'duration-second' => {
						'one' => q({0} sec),
						'other' => q({0} sec),
					},
					# Core Unit Identifier
					'second' => {
						'one' => q({0} sec),
						'other' => q({0} sec),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(septimanas),
						'one' => q({0} sept),
						'other' => q({0} sept),
						'per' => q({0}/sept),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(septimanas),
						'one' => q({0} sept),
						'other' => q({0} sept),
						'per' => q({0}/sept),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(annos),
						'one' => q({0} an),
						'other' => q({0} an),
						'per' => q({0}/an),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(annos),
						'one' => q({0} an),
						'other' => q({0} an),
						'per' => q({0}/an),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(A),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(A),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(Ω),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(Ω),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(V),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(V),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(J),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(J),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(ua),
						'one' => q({0} ua),
						'other' => q({0} ua),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(ua),
						'one' => q({0} ua),
						'other' => q({0} ua),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(al),
						'one' => q({0} al),
						'other' => q({0} al),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(al),
						'one' => q({0} al),
						'other' => q({0} al),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(m),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(m),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(ct),
						'one' => q({0} ct),
						'other' => q({0} ct),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(ct),
						'one' => q({0} ct),
						'other' => q({0} ct),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(g),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(g),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(cv),
						'one' => q({0} cv),
						'other' => q({0} cv),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(cv),
						'one' => q({0} cv),
						'other' => q({0} cv),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(W),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(W),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(acre pd),
						'one' => q({0} ac pd),
						'other' => q({0} ac pd),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(acre pd),
						'one' => q({0} ac pd),
						'other' => q({0} ac pd),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(barril),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(barril),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(bushels),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(bushels),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(cl),
						'one' => q({0} cl),
						'other' => q({0} cl),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(cl),
						'one' => q({0} cl),
						'other' => q({0} cl),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(pd³),
						'one' => q({0} pd³),
						'other' => q({0} pd³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(pd³),
						'one' => q({0} pd³),
						'other' => q({0} pd³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(tas),
						'one' => q({0} tas),
						'other' => q({0} tas),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(tas),
						'one' => q({0} tas),
						'other' => q({0} tas),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(tasm),
						'one' => q({0} tasm),
						'other' => q({0} tasm),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(tasm),
						'one' => q({0} tasm),
						'other' => q({0} tasm),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(dl),
						'one' => q({0} dl),
						'other' => q({0} dl),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(dl),
						'one' => q({0} dl),
						'other' => q({0} dl),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(cocl. a dessert),
						'one' => q({0} cocl. a dessert),
						'other' => q({0} cocl. a dessert),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(cocl. a dessert),
						'one' => q({0} cocl. a dessert),
						'other' => q({0} cocl. a dessert),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(cocl. a dessert imp.),
						'one' => q({0} cocl. a dessert imp.),
						'other' => q({0} cocl. a dessert imp.),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(cocl. a dessert imp.),
						'one' => q({0} cocl. a dessert imp.),
						'other' => q({0} cocl. a dessert imp.),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(drachma liq.),
						'one' => q({0} dr liq),
						'other' => q({0} dr liq),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(drachma liq.),
						'one' => q({0} dr liq),
						'other' => q({0} dr liq),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(guttas),
						'one' => q({0} gutta),
						'other' => q({0} guttas),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(guttas),
						'one' => q({0} gutta),
						'other' => q({0} guttas),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(oz liq),
						'one' => q({0} oz liq),
						'other' => q({0} oz liq),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(oz liq),
						'one' => q({0} oz liq),
						'other' => q({0} oz liq),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(oz liq imp.),
						'one' => q({0} oz liq imp.),
						'other' => q({0} oz liq imp.),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(oz liq imp.),
						'one' => q({0} oz liq imp.),
						'other' => q({0} oz liq imp.),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(gal imp),
						'one' => q({0} gal imp),
						'other' => q({0} gal imp),
						'per' => q({0}/gal imp),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(gal imp),
						'one' => q({0} gal imp),
						'other' => q({0} gal imp),
						'per' => q({0}/gal imp),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(hl),
						'one' => q({0} hl),
						'other' => q({0} hl),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(hl),
						'one' => q({0} hl),
						'other' => q({0} hl),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(litros),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(litros),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(Ml),
						'one' => q({0} Ml),
						'other' => q({0} Ml),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(Ml),
						'one' => q({0} Ml),
						'other' => q({0} Ml),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(ml),
						'one' => q({0} ml),
						'other' => q({0} ml),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(ml),
						'one' => q({0} ml),
						'other' => q({0} ml),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(pintas),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(pintas),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(ptm),
						'one' => q({0} ptm),
						'other' => q({0} ptm),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(ptm),
						'one' => q({0} ptm),
						'other' => q({0} ptm),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(cocl. a suppa),
						'one' => q({0} c. a suppa),
						'other' => q({0} c. a suppa),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(cocl. a suppa),
						'one' => q({0} c. a suppa),
						'other' => q({0} c. a suppa),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(cocl. a the),
						'one' => q({0} cocl. a the),
						'other' => q({0} cocl. a the),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(cocl. a the),
						'one' => q({0} cocl. a the),
						'other' => q({0} cocl. a the),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:si|s|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				end => q({0} e {1}),
				2 => q({0} e {1}),
		} }
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 2,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'group' => q(.),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'long' => {
				'1000' => {
					'one' => '0 mille',
					'other' => '0 milles',
				},
				'10000' => {
					'one' => '00 mille',
					'other' => '00 milles',
				},
				'100000' => {
					'one' => '000 mille',
					'other' => '000 milles',
				},
				'1000000' => {
					'one' => '0 million',
					'other' => '0 milliones',
				},
				'10000000' => {
					'one' => '00 million',
					'other' => '00 milliones',
				},
				'100000000' => {
					'one' => '000 million',
					'other' => '000 milliones',
				},
				'1000000000' => {
					'one' => '0 milliardo',
					'other' => '0 milliardos',
				},
				'10000000000' => {
					'one' => '00 milliardo',
					'other' => '00 milliardos',
				},
				'100000000000' => {
					'one' => '000 milliardo',
					'other' => '000 milliardos',
				},
				'1000000000000' => {
					'one' => '0 billion',
					'other' => '0 billiones',
				},
				'10000000000000' => {
					'one' => '00 billion',
					'other' => '00 billiones',
				},
				'100000000000000' => {
					'one' => '000 billion',
					'other' => '000 billiones',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 mil',
					'other' => '0 mil',
				},
				'10000' => {
					'one' => '00 mil',
					'other' => '00 mil',
				},
				'100000' => {
					'one' => '000 mil',
					'other' => '000 mil',
				},
				'1000000' => {
					'one' => '0 mln',
					'other' => '0 mln',
				},
				'10000000' => {
					'one' => '00 mln',
					'other' => '00 mln',
				},
				'100000000' => {
					'one' => '000 mln',
					'other' => '000 mln',
				},
				'1000000000' => {
					'one' => '0 mld',
					'other' => '0 mld',
				},
				'10000000000' => {
					'one' => '00 mld',
					'other' => '00 mld',
				},
				'100000000000' => {
					'one' => '000 mld',
					'other' => '000 mld',
				},
				'1000000000000' => {
					'one' => '0 bln',
					'other' => '0 bln',
				},
				'10000000000000' => {
					'one' => '00 bln',
					'other' => '00 bln',
				},
				'100000000000000' => {
					'one' => '000 bln',
					'other' => '000 bln',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤ #,##0.00)',
						'positive' => '¤ #,##0.00',
					},
					'standard' => {
						'positive' => '¤ 0 mil',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(dirham del Emiratos Arabe Unite),
				'one' => q(dirham del EAU),
				'other' => q(dirhams del EAU),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(afghani),
				'one' => q(afghani),
				'other' => q(afghanis),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(lek albanese),
				'one' => q(lek albanese),
				'other' => q(lekë albanese),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(dram armenie),
				'one' => q(dram armenie),
				'other' => q(drams armenie),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(florino antillan),
				'one' => q(florino antillan),
				'other' => q(florinos antillan),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(kwanza angolan),
				'one' => q(kwanza angolan),
				'other' => q(kwanzas angolan),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(peso argentin),
				'one' => q(peso argentin),
				'other' => q(pesos argentin),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(dollar australian),
				'one' => q(dollar australian),
				'other' => q(dollares australian),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(florino aruban),
				'one' => q(florino aruban),
				'other' => q(florinos aruban),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(manat azeri),
				'one' => q(manat azeri),
				'other' => q(manats azeri),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(marco convertibile de Bosnia-Herzegovina),
				'one' => q(marco convertibile de Bosnia-Herzegovina),
				'other' => q(marcos convertibile de Bosnia-Herzegovina),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(dollar barbadian),
				'one' => q(dollar barbadian),
				'other' => q(dollares barbadian),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(taka bengalese),
				'one' => q(taka bengalese),
				'other' => q(takas bengalese),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(lev bulgare),
				'one' => q(lev bulgare),
				'other' => q(leva bulgare),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(dinar bahreini),
				'one' => q(dinar bahreini),
				'other' => q(dinares bahreini),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(franco burundese),
				'one' => q(franco burundese),
				'other' => q(francos burundese),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(dollar bermudan),
				'one' => q(dollar bermudan),
				'other' => q(dollares bermudan),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(dollar de Brunei),
				'one' => q(dollar de Brunei),
				'other' => q(dollares de Brunei),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(boliviano bolivian),
				'one' => q(boliviano bolivian),
				'other' => q(bolivianos bolivian),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(real brasilian),
				'one' => q(real brasilian),
				'other' => q(reales brasilian),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(dollar bahamian),
				'one' => q(dollar bahamian),
				'other' => q(dollares bahamian),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(ngultrum bhutanese),
				'one' => q(ngultrum bhutanese),
				'other' => q(ngultrumes bhutanese),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(pula botswanese),
				'one' => q(pula botswanese),
				'other' => q(pulas botswanese),
			},
		},
		'BYN' => {
			display_name => {
				'currency' => q(rublo bielorusse),
				'one' => q(rublo bielorusse),
				'other' => q(rublos bielorusse),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(dollar belizan),
				'one' => q(dollar belizan),
				'other' => q(dollares belizan),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(dollar canadian),
				'one' => q(dollar canadian),
				'other' => q(dollares canadian),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(franco congolese),
				'one' => q(franco congolese),
				'other' => q(francos congolese),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(franco suisse),
				'one' => q(franco suisse),
				'other' => q(francos suisse),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(peso chilen),
				'one' => q(peso chilen),
				'other' => q(pesos chilen),
			},
		},
		'CNH' => {
			display_name => {
				'currency' => q(yuan chinese \(extracontinental\)),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(yuan chinese),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(peso colombian),
				'one' => q(peso colombian),
				'other' => q(pesos colombian),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(colon costarican),
				'one' => q(colon costarican),
				'other' => q(colones costarican),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(peso cuban convertibile),
				'one' => q(peso cuban convertibile),
				'other' => q(pesos cuban convertibile),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(peso cuban),
				'one' => q(peso cuban),
				'other' => q(pesos cuban),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(escudo capoverdian),
				'one' => q(escudo capoverdian),
				'other' => q(escudos capoverdian),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(corona chec),
				'one' => q(corona chec),
				'other' => q(coronas chec),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(Marco geman),
				'one' => q(marco german),
				'other' => q(marcos german),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(franco djibutian),
				'one' => q(franco djibutian),
				'other' => q(francos djibutian),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(corona danese),
				'one' => q(corona danese),
				'other' => q(coronas danese),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(peso dominican),
				'one' => q(peso dominican),
				'other' => q(pesos dominican),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(dinar algerin),
				'one' => q(dinar algerin),
				'other' => q(dinares algerin),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(Corona estonian),
				'one' => q(corona estonian),
				'other' => q(coronas estonian),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(libra egyptie),
				'one' => q(libra egyptie),
				'other' => q(libras egyptie),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(nakfa eritree),
				'one' => q(nakfa eritree),
				'other' => q(nakfas eritree),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(birr ethiope),
				'one' => q(birr ethiope),
				'other' => q(birres ethiope),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(euro),
				'one' => q(euro),
				'other' => q(euros),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(Marco finnese),
				'one' => q(marco finnese),
				'other' => q(marcos finnese),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(dollar fijian),
				'one' => q(dollar fijian),
				'other' => q(dollares fijian),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(libra falklandese),
				'one' => q(libra falklandese),
				'other' => q(libras falklandese),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(Franco francese),
				'one' => q(franco francese),
				'other' => q(francos francese),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(libra sterling),
				'one' => q(libra sterling),
				'other' => q(libras sterling),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(lari georgian),
				'one' => q(lari georgian),
				'other' => q(laris georgian),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(cedi ghanese),
				'one' => q(cedi ghanese),
				'other' => q(cedis ghanese),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(libra de Gibraltar),
				'one' => q(libra de Gibraltar),
				'other' => q(libras de Gibraltar),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(dalasi gambian),
				'one' => q(dalasi gambian),
				'other' => q(dalasis gambian),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(franco guinean),
				'one' => q(franco guinean),
				'other' => q(francos guinean),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(quetzal guatemaltec),
				'one' => q(quetzal guatemaltec),
				'other' => q(quetzales guatemaltec),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(dollar guyanese),
				'one' => q(dollar guyanese),
				'other' => q(dollares guyanese),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(dollar hongkongese),
				'one' => q(dollar hongkongese),
				'other' => q(dollares hongkongese),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(lempira hondurese),
				'one' => q(lempira hondurese),
				'other' => q(lempiras hondurese),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(kuna croate),
				'one' => q(kuna croate),
				'other' => q(kunas croate),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(gourde haitian),
				'one' => q(gourde haitian),
				'other' => q(gourdes haitian),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(forint hungare),
				'one' => q(forint hungare),
				'other' => q(forintes hungare),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(rupia indonesian),
				'one' => q(rupia indonesian),
				'other' => q(rupias indonesian),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(Libra irlandese),
				'one' => q(libra irlandese),
				'other' => q(libras irlandese),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(nove shekel israeli),
				'one' => q(nove shekel israeli),
				'other' => q(nove shekeles israeli),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(rupia indian),
				'one' => q(rupia indian),
				'other' => q(rupias indian),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(dinar iraqi),
				'one' => q(dinar iraqi),
				'other' => q(dinares iraqi),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(rial iranian),
				'one' => q(rial iranian),
				'other' => q(riales iranian),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(corona islandese),
				'one' => q(corona islandese),
				'other' => q(coronas islandese),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(dollar jamaican),
				'one' => q(dollar jamaican),
				'other' => q(dollares jamaican),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(dinar jordan),
				'one' => q(dinar jordan),
				'other' => q(dinares jordan),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(yen japonese),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(shilling kenyan),
				'one' => q(shilling kenyan),
				'other' => q(shillings kenyan),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(som kirghiz),
				'one' => q(som kirghiz),
				'other' => q(soms kirghiz),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(riel cambodgian),
				'one' => q(riel cambodgian),
				'other' => q(rieles cambodgian),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(franco comorian),
				'one' => q(franco comorian),
				'other' => q(francos comorian),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(won nordkorean),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(won sudkorean),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(dinar kuwaiti),
				'one' => q(dinar kuwaiti),
				'other' => q(dinares kuwaiti),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(dollar del Insulas Caiman),
				'one' => q(dollar del Insulas Caiman),
				'other' => q(dollares del Insulas Caiman),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(tenge kazakh),
				'one' => q(tenge kazakh),
				'other' => q(tenges kazakh),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(kip laotian),
				'one' => q(kip laotian),
				'other' => q(kipes laotian),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(libra libanese),
				'one' => q(libra libanese),
				'other' => q(libras libanese),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(rupia de Sri Lanka),
				'one' => q(rupia de Sri Lanka),
				'other' => q(rupias de Sri Lanka),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(dollar liberian),
				'one' => q(dollar liberian),
				'other' => q(dollares liberian),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(loti de Lesotho),
				'one' => q(loti de Lesotho),
				'other' => q(lotis de Lesotho),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(dinar libyc),
				'one' => q(dinar libyc),
				'other' => q(dinares libyc),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(dirham marocchin),
				'one' => q(dirham marocchin),
				'other' => q(dirhams marocchin),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(leu moldave),
				'one' => q(leu moldave),
				'other' => q(lei moldave),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(ariary malgache),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(denar macedonie),
				'one' => q(denar macedonie),
				'other' => q(denari macedonie),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(kyat de Myanmar),
				'one' => q(kyat de Myanmar),
				'other' => q(kyates de Myanmar),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(tugrik mongol),
				'one' => q(tugrik mongol),
				'other' => q(tugriks mongol),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(pataca de Macao),
				'one' => q(pataca de Macao),
				'other' => q(patacas de Macao),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(ouguiya mauritan \(1973–2017\)),
				'one' => q(ouguiya mauritan \(1973–2017\)),
				'other' => q(ouguiyas mauritan \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(ouguiya mauritan),
				'one' => q(ouguiya mauritan),
				'other' => q(ouguiyas mauritan),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(rupia mauritian),
				'one' => q(rupia mauritian),
				'other' => q(rupias mauritian),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(rufiyaa del Maldivas),
				'one' => q(rufiyaa del Maldivas),
				'other' => q(rufiyaas del Maldivas),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(kwacha malawian),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(peso mexican),
				'one' => q(peso mexican),
				'other' => q(pesos mexican),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(ringgit malay),
				'one' => q(ringgit malay),
				'other' => q(ringgites malay),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(metical mozambican),
				'one' => q(metical mozambican),
				'other' => q(meticales mozambican),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(dollar namibian),
				'one' => q(dollar namibian),
				'other' => q(dollares namibian),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(naira nigerian),
				'one' => q(naira nigerian),
				'other' => q(nairas nigerian),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(cordoba nicaraguan),
				'one' => q(cordoba nicaraguan),
				'other' => q(cordobas nicaraguan),
			},
		},
		'NLG' => {
			symbol => 'ƒ',
			display_name => {
				'currency' => q(Florino nederlandese),
				'one' => q(florino nederlandese),
				'other' => q(florinos nederlandese),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(corona norvegian),
				'one' => q(corona norvegian),
				'other' => q(coronas norvegian),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(rupia nepalese),
				'one' => q(rupia nepalese),
				'other' => q(rupias nepalese),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(dollar neozelandese),
				'one' => q(dollar neozelandese),
				'other' => q(dollares neozelandese),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(rial omani),
				'one' => q(rial omani),
				'other' => q(riales omani),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(balboa panamen),
				'one' => q(balboa panamen),
				'other' => q(balboas panamen),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(sol peruvian),
				'one' => q(sol peruvian),
				'other' => q(soles peruvian),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(kina papuan),
				'one' => q(kina papuan),
				'other' => q(kinas papuan),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(peso philippin),
				'one' => q(peso philippin),
				'other' => q(pesos philippin),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(rupia pakistani),
				'one' => q(rupia pakistani),
				'other' => q(rupias pakistani),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(zloty polonese),
				'one' => q(zloty polonese),
				'other' => q(zlotys polonese),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(guarani paraguayan),
				'one' => q(guarani paraguayan),
				'other' => q(guaranis paraguayan),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(rial qatari),
				'one' => q(rial qatari),
				'other' => q(riales qatari),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(leu romanian),
				'one' => q(leu romanian),
				'other' => q(lei romanian),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(dinar serbe),
				'one' => q(dinar serbe),
				'other' => q(dinares serbe),
			},
		},
		'RUB' => {
			symbol => '₽',
			display_name => {
				'currency' => q(rublo russe),
				'one' => q(rublo russe),
				'other' => q(rublos russe),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(franco ruandese),
				'one' => q(franco ruandese),
				'other' => q(francos ruandese),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(rial saudi),
				'one' => q(rial saudi),
				'other' => q(riales saudi),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(dollar del insulas Salomon),
				'one' => q(dollar del insulas Salomon),
				'other' => q(dollares del insulas Salomon),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(rupia seychellese),
				'one' => q(rupia seychellese),
				'other' => q(rupias seychellese),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(libra sudanese),
				'one' => q(libra sudanese),
				'other' => q(libras sudanese),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(corona svedese),
				'one' => q(corona svedese),
				'other' => q(coronas svedese),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(dollar singaporese),
				'one' => q(dollar singaporese),
				'other' => q(dollares singaporese),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(libra de St. Helena),
				'one' => q(libra de St. Helena),
				'other' => q(libras de St. Helena),
			},
		},
		'SLE' => {
			display_name => {
				'currency' => q(leone sierraleonese),
				'one' => q(leone sierraleonese),
				'other' => q(leones sierraleonese),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(leone sierraleonese \(1964—2022\)),
				'one' => q(leone sierraleonese \(1964—2022\)),
				'other' => q(leones sierraleonese \(1964—2022\)),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(shilling somali),
				'one' => q(shilling somali),
				'other' => q(shillings somali),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(dollar surinamese),
				'one' => q(dollar surinamese),
				'other' => q(dollares surinamese),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(libra sud-sudanese),
				'one' => q(libra sud-sudanese),
				'other' => q(libras sud-sudanese),
			},
		},
		'STN' => {
			display_name => {
				'currency' => q(dobra de São Tomé e Príncipe),
				'one' => q(dobra de São Tomé e Príncipe),
				'other' => q(dobras de São Tomé e Príncipe),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(libra syriac),
				'one' => q(libra syriac),
				'other' => q(libras syriac),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(lilangeni swazilandese),
				'one' => q(lilangeni swazilandese),
				'other' => q(emalangeni swazilandese),
			},
		},
		'THB' => {
			display_name => {
				'currency' => q(baht thailandese),
				'one' => q(baht thailandese),
				'other' => q(bahtes thailandese),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(somoni tajik),
				'one' => q(somoni tajik),
				'other' => q(somonis tajik),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(manat turkmen),
				'one' => q(manat turkmen),
				'other' => q(manats turkmen),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(dinar tunisian),
				'one' => q(dinar tunisian),
				'other' => q(dinares tunisian),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(paʻanga tongan),
				'one' => q(paʻanga tongan),
				'other' => q(paʻangas tongan),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(lira turc),
				'one' => q(lira turc),
				'other' => q(liras turc),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(dollar de Trinidad e Tobago),
				'one' => q(dollar de Trinidad e Tobago),
				'other' => q(dollares de Trinidad e Tobago),
			},
		},
		'TWD' => {
			display_name => {
				'currency' => q(nove dollar taiwanese),
				'one' => q(nove dollar taiwanese),
				'other' => q(nove dollares taiwanese),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(shilling tanzanian),
				'one' => q(shilling tanzanian),
				'other' => q(shillings tanzanian),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(hryvnia ukrainian),
				'one' => q(hryvnia ukrainian),
				'other' => q(hryvni ukrainian),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(shilling ugandese),
				'one' => q(shilling ugandese),
				'other' => q(shillings ugandese),
			},
		},
		'USD' => {
			display_name => {
				'currency' => q(dollar statounitese),
				'one' => q(dollar statounitese),
				'other' => q(dollares statounitese),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(peso uruguayan),
				'one' => q(peso uruguayan),
				'other' => q(pesos uruguayan),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(som uzbek),
				'one' => q(som uzbek),
				'other' => q(soms uzbek),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(bolivar venezuelan \(2008–2018\)),
				'one' => q(bolivar venezuelan \(2008–2018\)),
				'other' => q(bolivares venezuelan \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(bolivar venezuelan),
				'one' => q(bolivar venezuelan),
				'other' => q(bolivares venezuelan),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(dong vietnamese),
				'one' => q(dong vietnamese),
				'other' => q(donges vietnamese),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(vatu vanuatuan),
				'one' => q(vatu vanuatuan),
				'other' => q(vatus vanuatuan),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(tala samoan),
				'one' => q(tala samoan),
				'other' => q(talas samoan),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(franco CFA de Africa Central),
				'one' => q(franco CFA de Africa Central),
				'other' => q(francos CFA de Africa Central),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(dollar del Caribes Oriental),
				'one' => q(dollar del Caribes Oriental),
				'other' => q(dollares del Caribes Oriental),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(franco CFA de Africa Occidental),
				'one' => q(franco CFA de Africa Occidental),
				'other' => q(francos CFA de Africa Occidental),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(franco CFP),
				'one' => q(franco CFP),
				'other' => q(francos CFP),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(moneta incognite),
				'one' => q(\(moneta incognite\)),
				'other' => q(\(moneta incognite\)),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(rial yemeni),
				'one' => q(rial yemeni),
				'other' => q(riales yemeni),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(rand sudafrican),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(kwacha zambian),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'jan',
							'feb',
							'mar',
							'apr',
							'mai',
							'jun',
							'jul',
							'aug',
							'sep',
							'oct',
							'nov',
							'dec'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'j',
							'f',
							'm',
							'a',
							'm',
							'j',
							'j',
							'a',
							's',
							'o',
							'n',
							'd'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'januario',
							'februario',
							'martio',
							'april',
							'maio',
							'junio',
							'julio',
							'augusto',
							'septembre',
							'octobre',
							'novembre',
							'decembre'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'lun',
						tue => 'mar',
						wed => 'mer',
						thu => 'jov',
						fri => 'ven',
						sat => 'sab',
						sun => 'dom'
					},
					short => {
						mon => 'lu',
						tue => 'ma',
						wed => 'me',
						thu => 'jo',
						fri => 've',
						sat => 'sa',
						sun => 'do'
					},
					wide => {
						mon => 'lunedi',
						tue => 'martedi',
						wed => 'mercuridi',
						thu => 'jovedi',
						fri => 'venerdi',
						sat => 'sabbato',
						sun => 'dominica'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'l',
						tue => 'm',
						wed => 'm',
						thu => 'j',
						fri => 'v',
						sat => 's',
						sun => 'd'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'T1',
						1 => 'T2',
						2 => 'T3',
						3 => 'T4'
					},
					wide => {0 => '1me trimestre',
						1 => '2nde trimestre',
						2 => '3tie trimestre',
						3 => '4te trimestre'
					},
				},
			},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'a.Chr.',
				'1' => 'p.Chr.'
			},
			wide => {
				'0' => 'ante Christo',
				'1' => 'post Christo'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE 'le' d 'de' MMMM y G},
			'long' => q{d 'de' MMMM y G},
			'medium' => q{d MMM y G},
			'short' => q{dd-MM-y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE 'le' d 'de' MMMM y},
			'long' => q{d 'de' MMMM y},
			'medium' => q{d MMM y},
			'short' => q{dd-MM-y},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1}, {0}},
			'long' => q{{1}, {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Ed => q{E d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E d MMM y G},
			GyMMMd => q{d MMM y G},
			GyMd => q{dd-MM-y GGGGG},
			MEd => q{E dd-MM},
			MMMEd => q{E d MMM},
			MMMMd => q{d 'de' MMMM},
			MMMd => q{d MMM},
			Md => q{dd-MM},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{MM-y GGGGG},
			yyyyMEd => q{E dd-MM-y GGGGG},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E d MMM y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{d MMM y G},
			yyyyMd => q{dd-MM-y GGGGG},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ 'de' y G},
		},
		'gregorian' => {
			Ed => q{E d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E d MMM y G},
			GyMMMd => q{d MMM y G},
			GyMd => q{dd-MM-y G},
			MEd => q{E dd-MM},
			MMMEd => q{E d MMM},
			MMMMW => q{'septimana' W 'de' MMMM},
			MMMMd => q{d 'de' MMMM},
			MMMd => q{d MMM},
			Md => q{dd-MM},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			yM => q{MM-y},
			yMEd => q{E dd-MM-y},
			yMMM => q{MMM y},
			yMMMEd => q{E d MMM y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM y},
			yMd => q{dd-MM-y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ 'de' y},
			yw => q{'septimana' w 'de' Y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Gy => {
				G => q{y G – y G},
				y => q{y – y G},
			},
			GyM => {
				G => q{MM-y GGGGG – MM-y GGGGG},
				M => q{MM-y – MM-y GGGGG},
				y => q{MM-y – MM-y GGGGG},
			},
			GyMEd => {
				G => q{E dd-MM-y GGGGG – E dd-MM-y GGGGG},
				M => q{E dd-MM-y – E dd-MM-y GGGGG},
				d => q{E dd-MM-y – E dd-MM-y GGGGG},
				y => q{E dd-MM-y – E dd-MM-y GGGGG},
			},
			GyMMM => {
				G => q{MMM y G – MMM y G},
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			GyMMMEd => {
				G => q{E d MMM y G – E d MMM y G},
				M => q{E d MMM – E d MMM y G},
				d => q{E d MMM – E d MMM y G},
				y => q{E d MMM y – E d MMM y G},
			},
			GyMMMd => {
				G => q{d MMM y G – d MMM y G},
				M => q{d MMM – d MMM y G},
				d => q{d – d MMM y G},
				y => q{d MMM y – d MMM y G},
			},
			GyMd => {
				G => q{dd-MM-y GGGGG – dd-MM-y GGGGG},
				M => q{dd-MM-y – dd-MM-y GGGGG},
				d => q{dd-MM-y – dd-MM-y GGGGG},
				y => q{dd-MM-y – dd-MM-y GGGGG},
			},
			M => {
				M => q{MM – MM},
			},
			MEd => {
				M => q{E dd-MM – E dd-MM},
				d => q{E dd-MM – E dd-MM},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E d MMM – E d MMM},
				d => q{E d MMM – E d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d – d MMM},
			},
			Md => {
				M => q{dd-MM – dd-MM},
				d => q{dd-MM – dd-MM},
			},
			d => {
				d => q{d – d},
			},
			y => {
				y => q{y – y G},
			},
			yM => {
				M => q{MM-y – MM-y GGGGG},
				y => q{MM-y – MM-y GGGGG},
			},
			yMEd => {
				M => q{E dd-MM-y – E dd-MM-y GGGGG},
				d => q{E dd-MM-y – E dd-MM-y GGGGG},
				y => q{E dd-MM-y – E dd-MM-y GGGGG},
			},
			yMMM => {
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E d MMM – E d MMM y G},
				d => q{E d MMM – E d MMM y G},
				y => q{E d MMM y – E d MMM y G},
			},
			yMMMM => {
				M => q{MMMM – MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d MMM y G},
				d => q{d – d MMM y G},
				y => q{d MMM y – d MMM y G},
			},
			yMd => {
				M => q{dd-MM-y – dd-MM-y GGGGG},
				d => q{dd-MM-y – dd-MM-y GGGGG},
				y => q{dd-MM-y – dd-MM-y GGGGG},
			},
		},
		'gregorian' => {
			Gy => {
				G => q{y G – y G},
				y => q{y – y G},
			},
			GyM => {
				G => q{MM-y G – MM-y G},
				M => q{MM-y – MM-y G},
				y => q{MM-y – MM-y G},
			},
			GyMEd => {
				G => q{E dd-MM-y G – E dd-MM-y G},
				M => q{E dd-MM-y – E dd-MM-y G},
				d => q{E dd-MM-y – E dd-MM-y G},
				y => q{E dd-MM-y – E dd-MM-y G},
			},
			GyMMM => {
				G => q{MMM y G – MMM y G},
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			GyMMMEd => {
				G => q{E d MMM y G – E d MMM y G},
				M => q{E d MMM – E d MMM y G},
				d => q{E d MMM – E d MMM y G},
				y => q{E d MMM y – E d MMM y G},
			},
			GyMMMd => {
				G => q{d MMM y G – d MMM y G},
				M => q{d MMM – d MMM y G},
				d => q{d – d MMM y G},
				y => q{d MMM y – d MMM y G},
			},
			GyMd => {
				G => q{dd-MM-y G – dd-MM-y G},
				M => q{dd-MM-y – dd-MM-y G},
				d => q{dd-MM-y – dd-MM-y G},
				y => q{dd-MM-y – dd-MM-y G},
			},
			H => {
				H => q{HH – HH},
			},
			Hm => {
				H => q{HH:mm – HH:mm},
				m => q{HH:mm – HH:mm},
			},
			Hmv => {
				H => q{HH:mm – HH:mm v},
				m => q{HH:mm – HH:mm v},
			},
			Hv => {
				H => q{HH – HH v},
			},
			M => {
				M => q{MM – MM},
			},
			MEd => {
				M => q{E MM-dd – E MM-dd},
				d => q{E MM-dd – E MM-dd},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E d MMM – E d MMM},
				d => q{E d MMM – E d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d – d MMM},
			},
			Md => {
				M => q{MM-dd – MM-dd},
				d => q{MM-dd – MM-dd},
			},
			d => {
				d => q{d – d},
			},
			h => {
				a => q{h a – h a},
				h => q{h – h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm – h:mm a},
				m => q{h:mm – h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm – h:mm a v},
				m => q{h:mm – h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h – h a v},
			},
			y => {
				y => q{y – y},
			},
			yM => {
				M => q{MM-y – MM-y},
				y => q{MM-y – MM-y},
			},
			yMEd => {
				M => q{E dd-MM-y – E dd-MM-y},
				d => q{E dd-MM-y – E dd-MM-y},
				y => q{E dd-MM-y – E dd-MM-y},
			},
			yMMM => {
				M => q{MMM – MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E d MMM – E d MMM y},
				d => q{E d MMM – E d MMM y},
				y => q{E d MMM y – E d MMM y},
			},
			yMMMM => {
				M => q{MMMM – MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM y},
				d => q{d – d MMM y},
				y => q{d MMM y – d MMM y},
			},
			yMd => {
				M => q{dd-MM-y – dd-MM-y},
				d => q{dd-MM-y – dd-MM-y},
				y => q{dd-MM-y – dd-MM-y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		regionFormat => q(hora de {0}),
		regionFormat => q(hora estive de {0}),
		regionFormat => q(hora normal de {0}),
		'Afghanistan' => {
			long => {
				'standard' => q#hora de Afghanistan#,
			},
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Djibuti#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#São Tomé#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#hora de Africa Central#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#hora de Africa del Est#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#hora standard de Africa del Sud#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#hora estive de Africa del West#,
				'generic' => q#hora de Africa del West#,
				'standard' => q#hora standard de Africa del West#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#hora estive de Alaska#,
				'generic' => q#hora de Alaska#,
				'standard' => q#hora normal de Alaska#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#hora estive de Amazonia#,
				'generic' => q#hora de Amazonia#,
				'standard' => q#hora standard de Amazonia#,
			},
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Bahia de Banderas#,
		},
		'America/Cancun' => {
			exemplarCity => q#Cancun#,
		},
		'America/Cayman' => {
			exemplarCity => q#Caiman#,
		},
		'America/Curacao' => {
			exemplarCity => q#Curaçao#,
		},
		'America/Martinique' => {
			exemplarCity => q#Martinica#,
		},
		'America/Merida' => {
			exemplarCity => q#Merida#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Citate de Mexico#,
		},
		'America/New_York' => {
			exemplarCity => q#Nove York#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Beulah, Dakota del Nord#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Center, Dakota del Nord#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#New Salem, Dakota del Nord#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Porto Rico#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Sancte Bartholomeo#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Sancte Johannes de Terranova#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Sancte Christophoro#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Sancte Lucia#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Sancte Thomas#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Sancte Vincente#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#hora estive central#,
				'generic' => q#hora central#,
				'standard' => q#hora normal central#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#hora estive del est#,
				'generic' => q#hora del est#,
				'standard' => q#hora normal del est#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#hora estive del montanias#,
				'generic' => q#hora del montanias#,
				'standard' => q#hora normal del montanias#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#hora estive pacific#,
				'generic' => q#hora pacific#,
				'standard' => q#hora normal pacific#,
			},
		},
		'Apia' => {
			long => {
				'daylight' => q#hora estive de Apia#,
				'generic' => q#hora de Apia#,
				'standard' => q#hora standard de Apia#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#hora estive arabe#,
				'generic' => q#hora arabe#,
				'standard' => q#hora standard arabe#,
			},
		},
		'Argentina' => {
			long => {
				'daylight' => q#hora estive de Argentina#,
				'generic' => q#hora de Argentina#,
				'standard' => q#hora standard de Argentina#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#hora estive de Argentina occidental#,
				'generic' => q#hora de Argentina occidental#,
				'standard' => q#hora standard de Argentina occidental#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#hora estive de Armenia#,
				'generic' => q#hora de Armenia#,
				'standard' => q#hora standard de Armenia#,
			},
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Bahrein#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Calcutta#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Damasco#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Hongkong#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Chandyga#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Sachalin#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Ulan Bator#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Ekaterinburg#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#hora estive atlantic#,
				'generic' => q#hora atlantic#,
				'standard' => q#hora normal atlantic#,
			},
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Canarias#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Capo Verde#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Feroe#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#hora estive de Australia central#,
				'generic' => q#hora de Australia central#,
				'standard' => q#hora standard de Australia central#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#hora estive de Australia centro-occidental#,
				'generic' => q#hora de Australia centro-occidental#,
				'standard' => q#hora standard de Australia centro-occidental#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#hora estive de Australia oriental#,
				'generic' => q#hora de Australia oriental#,
				'standard' => q#hora standard de Australia oriental#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#hora estive de Australia occidental#,
				'generic' => q#hora de Australia occidental#,
				'standard' => q#hora standard de Australia occidental#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#hora estive de Azerbeidzhan#,
				'generic' => q#hora de Azerbeidzhan#,
				'standard' => q#hora standard de Azerbeidzhan#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#hora estive del Azores#,
				'generic' => q#hora del Azores#,
				'standard' => q#hora normal del Azores#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#hora estive de Bangladesh#,
				'generic' => q#hora de Bangladesh#,
				'standard' => q#hora standard de Bangladesh#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#hora de Bhutan#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#hora de Bolivia#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#hora estive de Brasilia#,
				'generic' => q#hora de Brasilia#,
				'standard' => q#hora standard de Brasilia#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#hora de Brunei Darussalam#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#hora estive de Capo Verde#,
				'generic' => q#hora de Capo Verde#,
				'standard' => q#hora standard de Capo Verde#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#hora standard de Chamorro#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#hora estive de Chatham#,
				'generic' => q#hora de Chatham#,
				'standard' => q#hora standard de Chatham#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#hora estive de Chile#,
				'generic' => q#hora de Chile#,
				'standard' => q#hora standard de Chile#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#hora estive de China#,
				'generic' => q#hora de China#,
				'standard' => q#hora standard de China#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#hora estive de Choibalsan#,
				'generic' => q#hora de Choibalsan#,
				'standard' => q#hora standard de Choibalsan#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#hora del Insula de Natal#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#hora del Insulas Cocos#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#hora estive de Colombia#,
				'generic' => q#hora de Colombia#,
				'standard' => q#hora standard de Colombia#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#hora estive del Insulas Cook#,
				'generic' => q#hora del Insulas Cook#,
				'standard' => q#hora standard del Insulas Cook#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#hora estive de Cuba#,
				'generic' => q#hora de Cuba#,
				'standard' => q#hora normal de Cuba#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#hora de Davis#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#hora de Dumont-d’Urville#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#hora de Timor del Est#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#hora estive del Insula de Pascha#,
				'generic' => q#hora del Insula de Pascha#,
				'standard' => q#hora standard del Insula de Pascha#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#hora de Ecuador#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#Universal Tempore Coordinate#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Citate incognite#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Athenas#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Belgrado#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Bruxelles#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Bucarest#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Büsingen#,
		},
		'Europe/Dublin' => {
			long => {
				'daylight' => q#Hora estive irlandese#,
			},
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Insula de Man#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Kiev#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Lisbona#,
		},
		'Europe/London' => {
			long => {
				'daylight' => q#Hora estive britannic#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Luxemburg#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Moscova#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Praga#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Roma#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Tirana#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Vaticano#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Varsovia#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#hora estive de Europa central#,
				'generic' => q#hora de Europa central#,
				'standard' => q#hora normal de Europa central#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#hora estive de Europa oriental#,
				'generic' => q#hora de Europa oriental#,
				'standard' => q#hora normal de Europa oriental#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#hora de Europa ultra-oriental#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#hora estive de Europa occidental#,
				'generic' => q#hora de Europa occidental#,
				'standard' => q#hora normal de Europa occidental#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#hora estive del Insulas Falkland#,
				'generic' => q#hora del Insulas Falkland#,
				'standard' => q#hora standard del Insulas Falkland#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#hora estive de Fiji#,
				'generic' => q#hora de Fiji#,
				'standard' => q#hora standard de Fiji#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#hora de Guiana Francese#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#hora francese meridional e antarctic#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#hora medie de Greenwich#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#hora del Galápagos#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#hora de Gambier#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#hora estive de Georgia#,
				'generic' => q#hora de Georgia#,
				'standard' => q#hora standard de Georgia#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#hora del Insulas Gilbert#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#hora estive de Groenlandia oriental#,
				'generic' => q#hora de Groenlandia oriental#,
				'standard' => q#hora normal de Groenlandia oriental#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#hora estive de Groenlandia occidental#,
				'generic' => q#hora de Groenlandia occidental#,
				'standard' => q#hora normal de Groenlandia occidental#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#hora standard del Golfo#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#hora de Guyana#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#hora estive de Hawaii-Aleutianas#,
				'generic' => q#hora de Hawaii-Aleutianas#,
				'standard' => q#hora normal de Hawaii-Aleutianas#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#hora estive de Hongkong#,
				'generic' => q#hora de Hongkong#,
				'standard' => q#hora standard de Hongkong#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#hora estive de Hovd#,
				'generic' => q#hora de Hovd#,
				'standard' => q#hora standard de Hovd#,
			},
		},
		'India' => {
			long => {
				'standard' => q#hora standard de India#,
			},
		},
		'Indian/Christmas' => {
			exemplarCity => q#Natal#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Maldivas#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Mauritio#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Mayotta#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Réunion#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#hora del Oceano Indian#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#hora de Indochina#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#hora de Indonesia Central#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#hora de Indonesia del Est#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#hora de Indonesia del West#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#hora estive de Iran#,
				'generic' => q#hora de Iran#,
				'standard' => q#hora standard de Iran#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#hora estive de Irkutsk#,
				'generic' => q#hora de Irkutsk#,
				'standard' => q#hora normal de Irkutsk#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#hora estive de Israel#,
				'generic' => q#hora de Israel#,
				'standard' => q#hora standard de Israel#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#hora estive de Japon#,
				'generic' => q#hora de Japon#,
				'standard' => q#hora standard de Japon#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#hora de Kazakhstan del Est#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#hora de Kazakhstan del West#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#hora estive de Corea#,
				'generic' => q#hora de Corea#,
				'standard' => q#hora standard de Corea#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#hora de Kosrae#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#hora estive de Krasnoyarsk#,
				'generic' => q#hora de Krasnoyarsk#,
				'standard' => q#hora normal de Krasnoyarsk#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#hora de Kirghizistan#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#hora del Insulas del Linea#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#hora estive de Lord Howe#,
				'generic' => q#hora de Lord Howe#,
				'standard' => q#hora standard de Lord Howe#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#hora estive de Magadan#,
				'generic' => q#hora de Magadan#,
				'standard' => q#hora normal de Magadan#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#hora de Malaysia#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#hora del Maldivas#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#hora de Marquesas#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#hora del Insulas Marshall#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#hora estive de Mauritio#,
				'generic' => q#hora de Mauritio#,
				'standard' => q#hora standard de Mauritio#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#hora de Mawson#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#hora estive del Pacifico mexican#,
				'generic' => q#hora del Pacifico mexican#,
				'standard' => q#hora normal del Pacifico mexican#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#hora estive de Ulan Bator#,
				'generic' => q#hora de Ulan Bator#,
				'standard' => q#hora standard de Ulan Bator#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#hora estive de Moscova#,
				'generic' => q#hora de Moscova#,
				'standard' => q#hora normal de Moscova#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#hora de Myanmar#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#hora de Nauru#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#hora de Nepal#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#hora estive de Nove Caledonia#,
				'generic' => q#hora de Nove Caledonia#,
				'standard' => q#hora standard de Nove Caledonia#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#hora estive de Nove Zelanda#,
				'generic' => q#hora de Nove Zelanda#,
				'standard' => q#hora standard de Nove Zelanda#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#hora estive de Terranova#,
				'generic' => q#hora de Terranova#,
				'standard' => q#hora normal de Terranova#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#hora de Niue#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#hora estive del Insula Norfolk#,
				'generic' => q#hora del Insula Norfolk#,
				'standard' => q#hora standard del Insula Norfolk#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#hora estive de Fernando de Noronha#,
				'generic' => q#hora de Fernando de Noronha#,
				'standard' => q#hora standard de Fernando de Noronha#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#hora estive de Novosibirsk#,
				'generic' => q#hora de Novosibirsk#,
				'standard' => q#hora normal de Novosibirsk#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#hora estive de Omsk#,
				'generic' => q#hora de Omsk#,
				'standard' => q#hora normal de Omsk#,
			},
		},
		'Pacific/Easter' => {
			exemplarCity => q#Pascha#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Galápagos#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#hora estive de Pakistan#,
				'generic' => q#hora de Pakistan#,
				'standard' => q#hora standard de Pakistan#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#hora de Palau#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#hora de Papua Nove Guinea#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#hora estive de Paraguay#,
				'generic' => q#hora de Paraguay#,
				'standard' => q#hora standard de Paraguay#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#hora estive de Peru#,
				'generic' => q#hora de Peru#,
				'standard' => q#hora standard de Peru#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#hora estive del Philippinas#,
				'generic' => q#hora del Philippinas#,
				'standard' => q#hora standard del Philippinas#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#hora del Insulas Phenice#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#hora estive de Saint-Pierre e Miquelon#,
				'generic' => q#hora de Saint-Pierre e Miquelon#,
				'standard' => q#hora normal de Saint-Pierre e Miquelon#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#hora de Pitcairn#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#hora de Ponape#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#hora de Pyongyang#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#hora de Réunion#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#hora de Rothera#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#hora estive de Sachalin#,
				'generic' => q#hora de Sachalin#,
				'standard' => q#hora normal de Sachalin#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#hora estive de Samoa#,
				'generic' => q#hora de Samoa#,
				'standard' => q#hora standard de Samoa#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#hora del Seychelles#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#hora standard de Singapore#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#hora del Insulas Solomon#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#hora de Georgia del Sud#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#hora de Suriname#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#hora de Syowa#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#hora de Tahiti#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#hora estive de Taipei#,
				'generic' => q#hora de Taipei#,
				'standard' => q#hora standard de Taipei#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#hora de Tajikistan#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#hora de Tokelau#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#hora estive de Tonga#,
				'generic' => q#hora de Tonga#,
				'standard' => q#hora standard de Tonga#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#hora de Chuuk#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#hora estive de Turkmenistan#,
				'generic' => q#hora de Turkmenistan#,
				'standard' => q#hora standard de Turkmenistan#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#hora de Tuvalu#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#hora estive de Uruguay#,
				'generic' => q#hora de Uruguay#,
				'standard' => q#hora standard de Uruguay#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#hora estive de Uzbekistan#,
				'generic' => q#hora de Uzbekistan#,
				'standard' => q#hora standard de Uzbekistan#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#hora estive de Vanuatu#,
				'generic' => q#hora de Vanuatu#,
				'standard' => q#hora standard de Vanuatu#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#hora de Venezuela#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#hora estive de Vladivostok#,
				'generic' => q#hora de Vladivostok#,
				'standard' => q#hora normal de Vladivostok#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#hora estive de Volgograd#,
				'generic' => q#hora de Volgograd#,
				'standard' => q#hora normal de Volgograd#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#hora de Vostok#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#hora del Insula Wake#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#hora de Wallis e Futuna#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#hora estive de Yakutsk#,
				'generic' => q#hora de Yakutsk#,
				'standard' => q#hora normal de Yakutsk#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#hora estive de Ekaterinburg#,
				'generic' => q#hora de Ekaterinburg#,
				'standard' => q#hora normal de Ekaterinburg#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#hora de Yukon#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
