#include <stdio.h>
#include <stdlib.h>
#include <utils/real.h>
#include <utils/matrix.h>

matrix::matrix() {
    rows = 0;
    cols = 0;
    size = 0;
    V    = 0;
    M    = 0;
}

/*
void matrix::add_element(real v) {
    real *tmp = V;

    V = new real[size+1];
    for(int i =0; i<size; i++) {
        V[i] = tmp[i];
    }
    V[size++] = v;
    if(rows==1) cols = size;
    if(tmp) delete tmp;
}
*/

void matrix::add_element(real v) {
    size++;
    V = (real *) realloc(V, (size)*(sizeof(real)));
    V[size-1] = v;
    if(rows==1) 
        cols = size;
}

int matrix::query_size() {
    return size;
}

int matrix::query_rows() {
    return rows;
}

int matrix::query_cols() {
    return cols;
}

void matrix::start_new_row() {
    rows++;
}

real *matrix::query_matrix_as_vector() {
    return V;
}

real **matrix::query_matrix_as_matrix() {
    int pos;
    if(M) delete M;
    M = new real*[rows];

    for(int r=0; r<rows; r++) {
        M[r] = new real[cols];
        for(int c=0; c<cols; c++) {
            pos = (r*cols) + c;
            M[r][c] = V[pos];
        }
    }
    return M;
}

void matrix::show_matrix_graphically() {
    int pos;

    for(int r=0; r<rows; r++) {
        for(int c=0; c<cols; c++) {
            pos = (r*cols) + c;
            printf("%c", (V[pos]) ? '#' : ' ');
        }
        printf("\n");
    }
}
