#include <arch/neuron.h>
#include <arch/hidden_layers.h>
#include <arch/layer.h>

class backprop {
    private:
        int num_outputs;
        real error;
        int error_counter;
        real alpha;
        layer *input;
        layer *output;
        hidden_layers *hidden;

        void    backpropagate_for(layer *l);
        void    perform_weight_change(neuron *n);
        void    perform_weight_change(layer *l);
        void    backpropagate_based_on(real *targets);
        void    change_weights();

    public:
                backprop(real _alpha, int inputs, int outputs,
                                                  int num_hidden_layers, ...);
        void  set_transfer_function_for_output(int type);
        void  set_transfer_function_for_hidden(int type);
        void    set_input(real *inputs);
        real *query_output();
        void    train_on(real *targets);
        void    test_for(real *targets);
        real  query_nmse();
        void  reset_nmse();

        void    save_net(char *filename);
        void restore_net(char *filename);
};
