#ifndef TYPES_H
#define TYPES_H

#if USE_STRICT_OVERFLOW_CHECKING
// Use real class
#else
#define USE_TYPEDEF
#endif

#ifdef USE_TYPEDEF
typedef double real;
#else

class real {
    private:
        double rval;
        real add(double);
        real mul(double);

        real sub(double);
        real sbi(double);
        real div(double);
        real dvi(double);

    public:
        real(double);
        real();

              operator   double();
        int   operator  <(double);
        int   operator  <(real  );
        int   operator  >(double);
        int   operator  >(real  );
        int   operator <=(double);
        int   operator <=(real  );
        int   operator >=(double);
        int   operator >=(real  );
        int   operator ==(double);
        int   operator ==(real  );
        void  operator +=(double);
        void  operator +=(real  );
        void  operator -=(double);
        void  operator -=(real  );
        void  operator  =(double);
        void  operator  =(real  );
        void  operator ++();
        void  operator --();

        friend real operator +(real,   real  );
        friend real operator +(double, real  );
        friend real operator +(real,   double);

        friend real operator *(real,   real  );
        friend real operator *(double, real  );
        friend real operator *(real,   double);

        friend real operator -(real,   real  );
        friend real operator -(double, real  );
        friend real operator -(real,   double);

        friend real operator /(real,   real  );
        friend real operator /(double, real  );
        friend real operator /(real,   double);

};
#endif
#endif
