#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>

#include "io.h"

char in_file_name[255];
FILE * in_file;

void jerror_show(int line, const char *to_match) {
    int i;
    char buffer[255];
    int token_pos;

    rewind(in_file);

    for(i=0; i<line; i++) fgets(buffer, 255, in_file);
    token_pos = (strstr(buffer, to_match) - buffer);

    fprintf(stderr,"while processing file: %s\n", in_file_name);
    fprintf(stderr, "%4i:%s%5s", line, buffer, "");

    if(token_pos < 100) {
        for(i=0; i<token_pos; i++)
            fprintf(stderr, " ");
        for(i=0; i<(int)strlen(to_match); i++)
            fprintf(stderr, "^");
        fprintf(stderr, "\n");
    }
}

void jclose() {
    fclose(in_file);
}

void jnuke() {
    jclose();
}

int jopen(char *filen) {
     strcpy(in_file_name, filen);
     in_file = freopen(in_file_name, "r", stdin);

    if(in_file == NULL ) {
        printf("unable to open %s\n", in_file_name);
        jnuke();
        return 0;
    }
    return 1;
}
