package CDN::Edgecast::Client::auto::RealTime::Type::RealTimeStreams;
BEGIN {
  $CDN::Edgecast::Client::auto::RealTime::Type::RealTimeStreams::VERSION = '0.01.00';
}
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'EC:WebServices' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %StreamName_of :ATTR(:get<StreamName>);
my %StreamType_of :ATTR(:get<StreamType>);
my %Bandwidth_of :ATTR(:get<Bandwidth>);
my %BitsPerSecond_of :ATTR(:get<BitsPerSecond>);
my %Connections_of :ATTR(:get<Connections>);

__PACKAGE__->_factory(
    [ qw(        StreamName
        StreamType
        Bandwidth
        BitsPerSecond
        Connections

    ) ],
    {
        'StreamName' => \%StreamName_of,
        'StreamType' => \%StreamType_of,
        'Bandwidth' => \%Bandwidth_of,
        'BitsPerSecond' => \%BitsPerSecond_of,
        'Connections' => \%Connections_of,
    },
    {
        'StreamName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'StreamType' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Bandwidth' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'BitsPerSecond' => 'SOAP::WSDL::XSD::Typelib::Builtin::double',
        'Connections' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
    },
    {

        'StreamName' => 'StreamName',
        'StreamType' => 'StreamType',
        'Bandwidth' => 'Bandwidth',
        'BitsPerSecond' => 'BitsPerSecond',
        'Connections' => 'Connections',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

CDN::Edgecast::Client::auto::RealTime::Type::RealTimeStreams

=head1 VERSION

version 0.01.00

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
RealTimeStreams from the namespace EC:WebServices.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * StreamName


=item * StreamType


=item * Bandwidth


=item * BitsPerSecond


=item * Connections




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # CDN::Edgecast::Client::auto::RealTime::Type::RealTimeStreams
   StreamName =>  $some_value, # string
   StreamType =>  $some_value, # string
   Bandwidth =>  $some_value, # string
   BitsPerSecond =>  $some_value, # double
   Connections =>  $some_value, # long
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut