package perl;
use warnings;
use strict;

use Readonly;
use Perl6::Say;
use base 'Exporter';
use Time::HiRes 'time';

our $VERSION = '0.0017';
our @EXPORT  = qw'say time';

our $version = sprintf "%vd", $^V;
$VERSION = $version;

sub import {
	my $package = caller;
	strict::import(@_);

	perl->export_to_level( 1, $package, @perl::EXPORT );
}

Readonly::Scalar $version => $version;
Readonly::Scalar $VERSION => $version;

sub unimport { strict::unimport(@_) }

1;
__END__

=head1 NAME

perl - L<Perl|perl>

=head1 SYNOPSIS

	use perl;

similar to

	use strict;
	use Perl6::Say;
	our $perl::version = sprintf "%vd", $^V;
	say $perl::version;
	say Time::HiRes;

=head1 EXPORTS

=head2 say

from L<Perl6::Say>

=head2 time

from L<Time::HiRes>

=head1 COPYRIGHT

This is free software; you can redistribute it and/or modify it
under the same terms as L<Perl|perl> itself.

=cut
