/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.Route;
import org.openqa.selenium.grid.web.UrlTemplate;
import org.openqa.selenium.injector.Injector;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;

public class SpecificRoute
extends Route<SpecificRoute> {
    private final Map<String, Function<String, ?>> mappers = new HashMap();
    private final HttpMethod method;
    private final UrlTemplate template;
    private Function<Injector, CommandHandler> handlerFunc;

    SpecificRoute(HttpMethod method, String template) {
        this.method = Objects.requireNonNull(method);
        this.template = new UrlTemplate(Objects.requireNonNull(template));
    }

    public <T> SpecificRoute map(String parameterName, Function<String, T> mapper) {
        Objects.requireNonNull(parameterName);
        Objects.requireNonNull(mapper);
        this.mappers.put(parameterName, mapper);
        return this;
    }

    public SpecificRoute using(Class<? extends CommandHandler> handlerClass) {
        Objects.requireNonNull(handlerClass);
        this.handlerFunc = inj -> (CommandHandler)inj.newInstance(handlerClass);
        return this;
    }

    public SpecificRoute using(CommandHandler handlerInstance) {
        Objects.requireNonNull(handlerInstance);
        this.handlerFunc = inj -> handlerInstance;
        return this;
    }

    @Override
    protected void validate() {
        if (this.handlerFunc == null) {
            throw new IllegalStateException("Handler for route is required");
        }
    }

    @Override
    protected CommandHandler newHandler(Injector injector, HttpRequest request) {
        if (request.getMethod() != this.method) {
            return this.getFallback(injector);
        }
        UrlTemplate.Match match = this.template.match(request.getUri());
        if (match == null) {
            return this.getFallback(injector);
        }
        if (!match.getParameters().isEmpty()) {
            Injector.Builder builder = Injector.builder().parent(injector);
            this.mappers.forEach((name, mapper) -> {
                String value = match.getParameters().get(name);
                if (value != null) {
                    builder.register(mapper.apply(value));
                }
            });
            injector = builder.build();
        }
        return this.handlerFunc.apply(injector);
    }
}

