/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.util.concurrent.Executor;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrame;
import org.webbitserver.WebSocketConnection;
import org.webbitserver.WebSocketHandler;
import org.webbitserver.netty.ConnectionHelper;
import org.webbitserver.netty.DecodingHybiFrame;
import org.webbitserver.netty.NettyWebSocketConnection;

public class WebSocketConnectionHandler
extends SimpleChannelUpstreamHandler {
    private final Executor executor;
    private final NettyWebSocketConnection webSocketConnection;
    private final WebSocketHandler webSocketHandler;
    private final ConnectionHelper connectionHelper;

    public WebSocketConnectionHandler(Executor executor, Thread.UncaughtExceptionHandler exceptionHandler, Thread.UncaughtExceptionHandler ioExceptionHandler, final NettyWebSocketConnection webSocketConnection, final WebSocketHandler webSocketHandler) {
        this.executor = executor;
        this.webSocketConnection = webSocketConnection;
        this.webSocketHandler = webSocketHandler;
        this.connectionHelper = new ConnectionHelper(executor, exceptionHandler, ioExceptionHandler){

            @Override
            protected void fireOnClose() throws Throwable {
                webSocketHandler.onClose(webSocketConnection);
            }
        };
    }

    @Override
    public void channelUnbound(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.connectionHelper.fireOnClose(e);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.connectionHelper.fireConnectionException(e);
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        final Thread.UncaughtExceptionHandler exceptionHandlerWithContext = this.connectionHelper.webbitExceptionWrappingExceptionHandler(e.getChannel());
        Object message = e.getMessage();
        if (message instanceof DecodingHybiFrame) {
            DecodingHybiFrame frame = (DecodingHybiFrame)message;
            frame.dispatchMessage(this.webSocketHandler, this.webSocketConnection, this.executor, exceptionHandlerWithContext);
        } else {
            final WebSocketFrame frame = (WebSocketFrame)message;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        WebSocketConnectionHandler.this.webSocketHandler.onMessage((WebSocketConnection)WebSocketConnectionHandler.this.webSocketConnection, frame.getTextData());
                    }
                    catch (Throwable t) {
                        exceptionHandlerWithContext.uncaughtException(Thread.currentThread(), t);
                    }
                }
            });
        }
    }
}

