/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.util.List;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.webbitserver.HttpHandler;
import org.webbitserver.WebbitException;
import org.webbitserver.netty.ConnectionHelper;
import org.webbitserver.netty.NettyHttpControl;
import org.webbitserver.netty.NettyHttpRequest;
import org.webbitserver.netty.NettyHttpResponse;

public class NettyHttpChannelHandler
extends SimpleChannelUpstreamHandler {
    private final Executor executor;
    private final List<HttpHandler> httpHandlers;
    private final Object id;
    private final long timestamp;
    private final Thread.UncaughtExceptionHandler exceptionHandler;
    private final Thread.UncaughtExceptionHandler ioExceptionHandler;
    private final ConnectionHelper connectionHelper;

    public NettyHttpChannelHandler(Executor executor, List<HttpHandler> httpHandlers, Object id, long timestamp, Thread.UncaughtExceptionHandler exceptionHandler, Thread.UncaughtExceptionHandler ioExceptionHandler) {
        this.executor = executor;
        this.httpHandlers = httpHandlers;
        this.id = id;
        this.timestamp = timestamp;
        this.exceptionHandler = exceptionHandler;
        this.ioExceptionHandler = ioExceptionHandler;
        this.connectionHelper = new ConnectionHelper(executor, exceptionHandler, ioExceptionHandler){

            @Override
            protected void fireOnClose() throws Exception {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        if (messageEvent.getMessage() instanceof HttpRequest) {
            this.handleHttpRequest(ctx, messageEvent, (HttpRequest)messageEvent.getMessage());
        } else {
            super.messageReceived(ctx, messageEvent);
        }
    }

    private void handleHttpRequest(final ChannelHandlerContext ctx, MessageEvent messageEvent, HttpRequest httpRequest) {
        final NettyHttpRequest nettyHttpRequest = new NettyHttpRequest(messageEvent, httpRequest, this.id, this.timestamp);
        final NettyHttpResponse nettyHttpResponse = new NettyHttpResponse(ctx, new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK), HttpHeaders.isKeepAlive(httpRequest), this.exceptionHandler);
        final NettyHttpControl control = new NettyHttpControl(this.httpHandlers.iterator(), this.executor, ctx, nettyHttpRequest, nettyHttpResponse, httpRequest, new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK), this.exceptionHandler, this.ioExceptionHandler);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    control.nextHandler(nettyHttpRequest, nettyHttpResponse);
                }
                catch (Exception exception) {
                    NettyHttpChannelHandler.this.exceptionHandler.uncaughtException(Thread.currentThread(), WebbitException.fromException(exception, ctx.getChannel()));
                }
            }
        });
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        this.connectionHelper.fireConnectionException(e);
    }
}

