/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.util.concurrent.Executor;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.util.CharsetUtil;
import org.webbitserver.netty.ConnectionHelper;

public class FlashPolicyFileHandler
extends SimpleChannelUpstreamHandler {
    private final int publicPort;
    private final ConnectionHelper connectionHelper;

    public FlashPolicyFileHandler(Executor executor, Thread.UncaughtExceptionHandler exceptionHandler, Thread.UncaughtExceptionHandler ioExceptionHandler, int publicPort) {
        this.publicPort = publicPort;
        this.connectionHelper = new ConnectionHelper(executor, exceptionHandler, ioExceptionHandler){

            @Override
            protected void fireOnClose() throws Exception {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Channel ch = e.getChannel();
        ChannelBuffer response = this.getPolicyFileContents();
        ChannelFuture future = ch.write(response);
        future.addListener(ChannelFutureListener.CLOSE);
        ctx.getPipeline().remove(this);
    }

    private ChannelBuffer getPolicyFileContents() throws Exception {
        return ChannelBuffers.copiedBuffer((CharSequence)("<?xml version=\"1.0\"?>\r\n<!DOCTYPE cross-domain-policy SYSTEM \"/xml/dtds/cross-domain-policy.dtd\">\r\n<cross-domain-policy>\r\n  <site-control permitted-cross-domain-policies=\"master-only\"/>\r\n  <allow-access-from domain=\"*\" to-ports=\"" + this.publicPort + "\" />\r\n" + "</cross-domain-policy>\r\n"), CharsetUtil.US_ASCII);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.connectionHelper.fireConnectionException(e);
    }
}

