/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.logging;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.LoggingHandler;

class HandlerBasedLocalLogs
extends LocalLogs {
    final LoggingHandler loggingHandler;
    final Set<String> logTypesToInclude;

    protected HandlerBasedLocalLogs(LoggingHandler loggingHandler, Set<String> logTypesToInclude) {
        this.loggingHandler = loggingHandler;
        this.logTypesToInclude = logTypesToInclude;
    }

    @Override
    public LogEntries get(String logType) {
        if ("client".equals(logType) && this.logTypesToInclude.contains(logType)) {
            List<LogEntry> entries = this.loggingHandler.getRecords();
            this.loggingHandler.flush();
            return new LogEntries(entries);
        }
        return new LogEntries(Lists.<LogEntry>newArrayList());
    }

    @Override
    public Set<String> getAvailableLogTypes() {
        return ImmutableSet.of("client");
    }

    @Override
    public void addEntry(String logType, LogEntry entry) {
        throw new RuntimeException("Log to this instance of LocalLogs using standard Java logging.");
    }
}

