/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.internal.BuildInfo;

public class WebDriverException
extends RuntimeException {
    public static final String SESSION_ID = "Session ID";
    public static final String DRIVER_INFO = "Driver info";
    private Map<String, String> extraInfo = new HashMap<String, String>();
    private String sessionId;

    public WebDriverException() {
    }

    public WebDriverException(String message) {
        super(message);
    }

    public WebDriverException(Throwable cause) {
        super(cause);
    }

    public WebDriverException(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public String getMessage() {
        return this.createMessage(super.getMessage());
    }

    private String createMessage(String originalMessageString) {
        String supportMessage = this.getSupportUrl() == null ? "" : "For documentation on this error, please visit: " + this.getSupportUrl() + "\n";
        return String.valueOf(originalMessageString == null ? "" : String.valueOf(originalMessageString) + "\n") + supportMessage + this.getBuildInformation() + "\n" + this.getSystemInformation() + this.getAdditionalInformation();
    }

    public String getSystemInformation() {
        return String.format("System info: os.name: '%s', os.arch: '%s', os.version: '%s', java.version: '%s'", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), System.getProperty("java.version"));
    }

    public String getSupportUrl() {
        return null;
    }

    public BuildInfo getBuildInformation() {
        return new BuildInfo();
    }

    @Deprecated
    public String getDriverInformation() {
        String driverInformation = "driver.version: " + WebDriverException.getDriverName(this.getStackTrace());
        if (this.sessionId != null) {
            driverInformation = String.valueOf(driverInformation) + "\nSession ID: " + this.sessionId;
        }
        return driverInformation;
    }

    @Deprecated
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public static String getDriverName(StackTraceElement[] stackTraceElements) {
        String driverName = "unknown";
        StackTraceElement[] stackTraceElementArray = stackTraceElements;
        int n = stackTraceElements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            if (e.getClassName().endsWith("Driver")) {
                String[] bits = e.getClassName().split("\\.");
                driverName = bits[bits.length - 1];
            }
            ++n2;
        }
        return driverName;
    }

    public void addInfo(String key, String value) {
        this.extraInfo.put(key, value);
    }

    private String getAdditionalInformation() {
        if (!this.extraInfo.containsKey(DRIVER_INFO)) {
            this.extraInfo.put(DRIVER_INFO, "driver.version: " + WebDriverException.getDriverName(this.getStackTrace()));
        }
        String result = "";
        for (Map.Entry<String, String> entry : this.extraInfo.entrySet()) {
            result = entry.getValue().startsWith(entry.getKey()) ? String.valueOf(result) + "\n" + entry.getValue() : String.valueOf(result) + "\n" + entry.getKey() + ": " + entry.getValue();
        }
        return result;
    }
}

