/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.common;

import java.util.ArrayList;
import java.util.List;
import org.openqa.grid.common.exception.GridConfigurationException;

public enum GridRole {
    NOT_GRID,
    HUB,
    NODE;


    public static GridRole find(String[] args) {
        if (args == null) {
            return NOT_GRID;
        }
        int i = 0;
        while (i < args.length) {
            if ("-role".equals(args[i])) {
                if (i == args.length) {
                    throw new GridConfigurationException("-role needs to be followed by the role of this component in the grid.");
                }
                String role = args[i + 1].toLowerCase();
                if (GridRole.NodeAliases().contains(role)) {
                    return NODE;
                }
                if ("hub".equals(role)) {
                    return HUB;
                }
                throw new GridConfigurationException("The role specified :" + role + " doesn't match a recognized role for grid.");
            }
            ++i;
        }
        return NOT_GRID;
    }

    private static List<String> NodeAliases() {
        ArrayList<String> res = new ArrayList<String>();
        res.add("node");
        res.addAll(GridRole.RCAliases());
        res.addAll(GridRole.WDAliases());
        return res;
    }

    public static List<String> RCAliases() {
        ArrayList<String> res = new ArrayList<String>();
        res.add("rc");
        res.add("remotecontrol");
        res.add("remote-control");
        return res;
    }

    public static List<String> WDAliases() {
        ArrayList<String> res = new ArrayList<String>();
        res.add("wd");
        res.add("webdriver");
        return res;
    }
}

