/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services.desktop;

import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.ScopeServices;
import com.opera.core.systems.scope.protos.SystemInputProtos;
import com.opera.core.systems.scope.services.desktop.SystemInput;
import com.opera.core.systems.scope.stp.services.desktop.ClickDelayer;
import com.opera.core.systems.scope.stp.services.messages.desktop.SystemInputMessage;
import java.awt.Point;
import java.util.List;
import java.util.logging.Logger;

public class ScopeSystemInputManager
extends AbstractService
implements SystemInput {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected final ClickDelayer clickDelayer = new ClickDelayer();

    public ScopeSystemInputManager(ScopeServices services) {
        super(services, "system-input", "1.1");
        services.setSystemInputManager(this);
    }

    @Override
    public void init() {
    }

    @Override
    public void click(Point location, SystemInputProtos.MouseInfo.MouseButton button, int numClicks, List<SystemInputProtos.ModifierPressed> modifiers) {
        this.clickDelayer.delayClickIfNeeded(location, button, numClicks);
        SystemInputProtos.MouseInfo.Builder actionBuilder = SystemInputProtos.MouseInfo.newBuilder();
        actionBuilder.setX(location.x);
        actionBuilder.setY(location.y);
        actionBuilder.setButton(button);
        actionBuilder.setNumClicks(numClicks);
        int modifier = SystemInputProtos.ModifierPressed.NONE.getNumber();
        for (SystemInputProtos.ModifierPressed mod : modifiers) {
            modifier |= mod.getNumber();
        }
        actionBuilder.setModifier(modifier);
        this.executeMessage(SystemInputMessage.CLICK, actionBuilder.clone());
    }

    @Override
    public void mouseMove(Point location, SystemInputProtos.MouseInfo.MouseButton button, List<SystemInputProtos.ModifierPressed> modifiers) {
        SystemInputProtos.MouseInfo.Builder actionBuilder = SystemInputProtos.MouseInfo.newBuilder();
        actionBuilder.setX(location.x);
        actionBuilder.setY(location.y);
        actionBuilder.setButton(button);
        actionBuilder.setNumClicks(1);
        int modifier = SystemInputProtos.ModifierPressed.NONE.getNumber();
        for (SystemInputProtos.ModifierPressed mod : modifiers) {
            modifier |= mod.getNumber();
        }
        actionBuilder.setModifier(modifier);
        this.executeMessage(SystemInputMessage.MOUSEMOVE, actionBuilder.clone());
    }

    @Override
    public void mouseUp(Point location, SystemInputProtos.MouseInfo.MouseButton button, List<SystemInputProtos.ModifierPressed> modifiers) {
        SystemInputProtos.MouseInfo.Builder actionBuilder = SystemInputProtos.MouseInfo.newBuilder();
        actionBuilder.setX(location.x);
        actionBuilder.setY(location.y);
        actionBuilder.setButton(button);
        actionBuilder.setNumClicks(1);
        int modifier = SystemInputProtos.ModifierPressed.NONE.getNumber();
        for (SystemInputProtos.ModifierPressed mod : modifiers) {
            modifier |= mod.getNumber();
        }
        actionBuilder.setModifier(modifier);
        this.executeMessage(SystemInputMessage.MOUSEUP, actionBuilder.clone());
    }

    @Override
    public void mouseDown(Point location, SystemInputProtos.MouseInfo.MouseButton button, List<SystemInputProtos.ModifierPressed> modifiers) {
        SystemInputProtos.MouseInfo.Builder actionBuilder = SystemInputProtos.MouseInfo.newBuilder();
        actionBuilder.setX(location.x);
        actionBuilder.setY(location.y);
        actionBuilder.setButton(button);
        actionBuilder.setNumClicks(1);
        int modifier = SystemInputProtos.ModifierPressed.NONE.getNumber();
        for (SystemInputProtos.ModifierPressed mod : modifiers) {
            modifier |= mod.getNumber();
        }
        actionBuilder.setModifier(modifier);
        this.executeMessage(SystemInputMessage.MOUSEDOWN, actionBuilder.clone());
    }

    @Override
    public void keyPress(String key, List<SystemInputProtos.ModifierPressed> modifiers) {
        SystemInputProtos.KeyPressInfo.Builder actionBuilder = SystemInputProtos.KeyPressInfo.newBuilder();
        actionBuilder.setKey(key);
        int modifier = SystemInputProtos.ModifierPressed.NONE.getNumber();
        for (SystemInputProtos.ModifierPressed mod : modifiers) {
            modifier |= mod.getNumber();
        }
        actionBuilder.setModifier(modifier);
        this.executeMessage(SystemInputMessage.KEYPRESS, actionBuilder.clone());
    }

    @Override
    public void keyDown(String key, List<SystemInputProtos.ModifierPressed> modifiers) {
        SystemInputProtos.KeyPressInfo.Builder actionBuilder = SystemInputProtos.KeyPressInfo.newBuilder();
        actionBuilder.setKey(key);
        int modifier = SystemInputProtos.ModifierPressed.NONE.getNumber();
        for (SystemInputProtos.ModifierPressed mod : modifiers) {
            modifier |= mod.getNumber();
        }
        actionBuilder.setModifier(modifier);
        this.executeMessage(SystemInputMessage.KEYDOWN, actionBuilder.clone());
    }

    @Override
    public void keyUp(String key, List<SystemInputProtos.ModifierPressed> modifiers) {
        SystemInputProtos.KeyPressInfo.Builder actionBuilder = SystemInputProtos.KeyPressInfo.newBuilder();
        actionBuilder.setKey(key);
        int modifier = SystemInputProtos.ModifierPressed.NONE.getNumber();
        for (SystemInputProtos.ModifierPressed mod : modifiers) {
            modifier |= mod.getNumber();
        }
        actionBuilder.setModifier(modifier);
        this.executeMessage(SystemInputMessage.KEYUP, actionBuilder.clone());
    }
}

