/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services;

import com.google.common.collect.Lists;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.ScopeServices;
import com.opera.core.systems.scope.internal.ServiceCallback;
import com.opera.core.systems.scope.protos.ConsoleLoggerProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.ConsoleLogger;
import com.opera.core.systems.scope.stp.services.messages.ConsoleLoggerMessage;
import java.util.List;

public class ScopeConsoleLogger
extends AbstractService
implements ConsoleLogger {
    private final List<ConsoleLoggerProtos.ConsoleMessage> messages = Lists.newArrayList();
    private ServiceCallback<ConsoleLoggerProtos.ConsoleMessage> callback = null;

    public ScopeConsoleLogger(ScopeServices services) {
        super(services, "console-logger");
        services.setConsoleLogger(this);
    }

    @Override
    public void init() {
    }

    @Override
    public void addMessage(ConsoleLoggerProtos.ConsoleMessage message) {
        this.messages.add(message);
        if (this.callback != null) {
            this.callback.call(message);
        }
    }

    @Override
    public void clear() {
        this.executeMessage(ConsoleLoggerMessage.CLEAR);
    }

    @Override
    public List<ConsoleLoggerProtos.ConsoleMessage> listMessages() {
        UmsProtos.Response response = this.executeMessage(ConsoleLoggerMessage.LIST_MESSAGES);
        ConsoleLoggerProtos.ConsoleMessageList.Builder builder = ConsoleLoggerProtos.ConsoleMessageList.newBuilder();
        ScopeConsoleLogger.buildPayload(response, builder);
        return builder.build().getConsoleMessageListList();
    }

    @Override
    public void onConsoleMessage(ServiceCallback<ConsoleLoggerProtos.ConsoleMessage> callback) {
        this.callback = callback;
    }
}

