/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.opera.core.systems.scope.exceptions.ScopeException;
import com.opera.core.systems.scope.handlers.EventHandler;
import com.opera.core.systems.scope.protos.ConsoleLoggerProtos;
import com.opera.core.systems.scope.protos.DesktopWmProtos;
import com.opera.core.systems.scope.protos.EcmascriptProtos;
import com.opera.core.systems.scope.protos.EsdbgProtos;
import com.opera.core.systems.scope.protos.HttpLoggerProtos;
import com.opera.core.systems.scope.protos.SelftestProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.protos.WmProtos;
import com.opera.core.systems.scope.stp.services.messages.CoreMessage;
import com.opera.core.systems.scope.stp.services.messages.EcmascriptDebuggerMessage;
import com.opera.core.systems.scope.stp.services.messages.SelftestMessage;
import com.opera.core.systems.scope.stp.services.messages.WindowManagerMessage;
import com.opera.core.systems.scope.stp.services.messages.desktop.DesktopWindowManagerMessage;

public class UmsEventParser {
    private EventHandler eventHandler;

    public UmsEventParser(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void handleEvent(UmsProtos.Event event) {
        String service = event.getService();
        int eventId = event.getCommandID();
        if (service.equals("ecmascript-debugger")) {
            switch (EcmascriptDebuggerMessage.get(eventId)) {
                case RUNTIME_STARTED: {
                    EsdbgProtos.RuntimeInfo.Builder infoBuilder = EsdbgProtos.RuntimeInfo.newBuilder();
                    this.buildPayload(event, infoBuilder);
                    this.eventHandler.onRuntimeStarted(infoBuilder.build());
                    break;
                }
                case RUNTIME_STOPPED: {
                    EsdbgProtos.RuntimeID.Builder idBuilder = EsdbgProtos.RuntimeID.newBuilder();
                    this.buildPayload(event, idBuilder);
                    Integer id = idBuilder.build().getRuntimeID();
                    this.eventHandler.onRuntimeStopped(id);
                    break;
                }
            }
        } else if (service.equals("window-manager")) {
            switch (WindowManagerMessage.get(eventId)) {
                case WINDOW_ACTIVATED: {
                    WmProtos.WindowID.Builder activeWindowIdBuilder = WmProtos.WindowID.newBuilder();
                    this.buildPayload(event, activeWindowIdBuilder);
                    Integer activeWindowID = activeWindowIdBuilder.build().getWindowID();
                    this.eventHandler.onWindowActivated(activeWindowID);
                    break;
                }
                case WINDOW_CLOSED: {
                    WmProtos.WindowID.Builder closedWindowBuilder = WmProtos.WindowID.newBuilder();
                    this.buildPayload(event, closedWindowBuilder);
                    Integer closedWindowID = closedWindowBuilder.build().getWindowID();
                    this.eventHandler.onWindowClosed(closedWindowID);
                    break;
                }
                case WINDOW_UPDATED: {
                    WmProtos.WindowInfo.Builder windowInfoBuilder = WmProtos.WindowInfo.newBuilder();
                    this.buildPayload(event, windowInfoBuilder);
                    WmProtos.WindowInfo info = windowInfoBuilder.build();
                    this.eventHandler.onWindowUpdated(info);
                    break;
                }
                case WINDOW_LOADED: {
                    WmProtos.WindowID.Builder loadedWindowBuilder = WmProtos.WindowID.newBuilder();
                    this.buildPayload(event, loadedWindowBuilder);
                    Integer loadedWindowID = loadedWindowBuilder.build().getWindowID();
                    this.eventHandler.onWindowLoaded(loadedWindowID);
                    break;
                }
            }
        } else if (service.equals("desktop-window-manager")) {
            switch (DesktopWindowManagerMessage.get(eventId)) {
                case WINDOW_SHOWN: {
                    DesktopWmProtos.DesktopWindowInfo.Builder shownDWBuilder = DesktopWmProtos.DesktopWindowInfo.newBuilder();
                    this.buildPayload(event, shownDWBuilder);
                    DesktopWmProtos.DesktopWindowInfo info_shown = shownDWBuilder.build();
                    this.eventHandler.onDesktopWindowShown(info_shown);
                    break;
                }
                case WINDOW_UPDATED: {
                    DesktopWmProtos.DesktopWindowInfo.Builder updatedDWBuilder = DesktopWmProtos.DesktopWindowInfo.newBuilder();
                    this.buildPayload(event, updatedDWBuilder);
                    DesktopWmProtos.DesktopWindowInfo info_updated = updatedDWBuilder.build();
                    this.eventHandler.onDesktopWindowUpdated(info_updated);
                    break;
                }
                case WINDOW_ACTIVATED: {
                    DesktopWmProtos.DesktopWindowInfo.Builder activatedDWBuilder = DesktopWmProtos.DesktopWindowInfo.newBuilder();
                    this.buildPayload(event, activatedDWBuilder);
                    DesktopWmProtos.DesktopWindowInfo info_activated = activatedDWBuilder.build();
                    this.eventHandler.onDesktopWindowActivated(info_activated);
                    break;
                }
                case WINDOW_CLOSED: {
                    DesktopWmProtos.DesktopWindowInfo.Builder closedDWBuilder = DesktopWmProtos.DesktopWindowInfo.newBuilder();
                    this.buildPayload(event, closedDWBuilder);
                    DesktopWmProtos.DesktopWindowInfo info_closed = closedDWBuilder.build();
                    this.eventHandler.onDesktopWindowClosed(info_closed);
                    break;
                }
                case WINDOW_PAGE_CHANGED: {
                    DesktopWmProtos.DesktopWindowInfo.Builder pageChangedDWBuilder = DesktopWmProtos.DesktopWindowInfo.newBuilder();
                    this.buildPayload(event, pageChangedDWBuilder);
                    DesktopWmProtos.DesktopWindowInfo changedInfoPage = pageChangedDWBuilder.build();
                    this.eventHandler.onDesktopWindowPageChanged(changedInfoPage);
                    break;
                }
                case WINDOW_LOADED: {
                    DesktopWmProtos.DesktopWindowInfo.Builder loadedDWBuilder = DesktopWmProtos.DesktopWindowInfo.newBuilder();
                    this.buildPayload(event, loadedDWBuilder);
                    DesktopWmProtos.DesktopWindowInfo info_loaded = loadedDWBuilder.build();
                    this.eventHandler.onDesktopWindowLoaded(info_loaded);
                    break;
                }
                case MENU_SHOWN: {
                    DesktopWmProtos.QuickMenuInfo.Builder shownQMBuilder = DesktopWmProtos.QuickMenuInfo.newBuilder();
                    this.buildPayload(event, shownQMBuilder);
                    DesktopWmProtos.QuickMenuInfo menuInfoShown = shownQMBuilder.build();
                    this.eventHandler.onQuickMenuShown(menuInfoShown);
                    break;
                }
                case MENU_CLOSED: {
                    DesktopWmProtos.QuickMenuID.Builder closedQMBuilder = DesktopWmProtos.QuickMenuID.newBuilder();
                    this.buildPayload(event, closedQMBuilder);
                    DesktopWmProtos.QuickMenuID menuId = closedQMBuilder.build();
                    this.eventHandler.onQuickMenuClosed(menuId);
                    break;
                }
                case MENU_PRESSED: {
                    DesktopWmProtos.QuickMenuItemID.Builder pressedQMIBuilder = DesktopWmProtos.QuickMenuItemID.newBuilder();
                    this.buildPayload(event, pressedQMIBuilder);
                    DesktopWmProtos.QuickMenuItemID menuItemID = pressedQMIBuilder.build();
                    this.eventHandler.onQuickMenuItemPressed(menuItemID);
                    break;
                }
            }
        } else if (service.equals("console-logger")) {
            ConsoleLoggerProtos.ConsoleMessage.Builder messageBuilder = ConsoleLoggerProtos.ConsoleMessage.newBuilder();
            this.buildPayload(event, messageBuilder);
            this.eventHandler.onConsoleMessage(messageBuilder.build());
        } else if (service.equals("ecmascript")) {
            EcmascriptProtos.ReadyStateChange.Builder builder = EcmascriptProtos.ReadyStateChange.newBuilder();
            this.buildPayload(event, builder);
            this.eventHandler.onReadyStateChange(builder.build());
        } else if (service.equals("http-logger") && eventId == 1) {
            HttpLoggerProtos.Header header;
            try {
                header = HttpLoggerProtos.Header.parseFrom(event.getPayload());
            }
            catch (InvalidProtocolBufferException e) {
                throw new ScopeException("Exception while parsing event", e);
            }
            this.eventHandler.onRequest(header.getWindowID());
        } else if (service.equals("core")) {
            switch (CoreMessage.get(eventId)) {
                case ON_ACTIVE: {
                    break;
                }
                case ON_IDLE: {
                    this.eventHandler.onOperaIdle();
                }
            }
        } else if (service.equals("selftest")) {
            switch (SelftestMessage.get(eventId)) {
                case RESULT: {
                    SelftestProtos.SelftestResult.Builder builder = SelftestProtos.SelftestResult.newBuilder();
                    this.buildPayload(event, builder);
                    this.eventHandler.onSelftestResult(builder.build());
                    break;
                }
                case FINISHED: {
                    this.eventHandler.onSelftestDone();
                }
            }
        }
    }

    private GeneratedMessage.Builder<?> buildPayload(UmsProtos.Event event, GeneratedMessage.Builder<?> builder) {
        return this.buildMessage(builder, event.getPayload().toByteArray());
    }

    private GeneratedMessage.Builder<?> buildMessage(GeneratedMessage.Builder<?> builder, byte[] message) {
        try {
            return (GeneratedMessage.Builder)builder.mergeFrom(message);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ScopeException(String.format("Could not build %s: %s", builder.getDescriptorForType().getFullName(), e.getMessage()), e);
        }
    }
}

