/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.runner.inprocess;

import com.google.common.collect.Iterables;
import com.opera.core.systems.OperaSettings;
import com.opera.core.systems.internal.ImplicitWait;
import com.opera.core.systems.model.ScreenCaptureReply;
import com.opera.core.systems.runner.AbstractOperaRunner;
import com.opera.core.systems.runner.OperaRunner;
import com.opera.core.systems.runner.OperaRunnerException;
import com.opera.core.systems.runner.inprocess.ScreenCapture;
import com.opera.core.systems.scope.internal.OperaIntervals;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.support.ui.Duration;

public class OperaInProcessRunner
extends AbstractOperaRunner
implements OperaRunner {
    private final ReentrantLock lock = new ReentrantLock();
    private CommandLine process = null;
    private boolean shutdown = false;

    public OperaInProcessRunner() {
        this(new OperaSettings());
    }

    public OperaInProcessRunner(OperaSettings settings) {
        super(settings);
    }

    @Override
    public void startOpera() throws OperaRunnerException {
        this.lock.lock();
        try {
            if (this.isOperaRunning()) {
                return;
            }
            this.process = new CommandLine(this.settings.getBinary().getCanonicalPath(), Iterables.toArray(this.settings.arguments().getArgumentsAsStringList(), String.class));
            this.logger.config(String.format("runner arguments: %s", this.process));
            this.process.copyOutputTo(System.out);
            this.process.executeAsync();
            boolean startedProperly = new ImplicitWait(OperaIntervals.PROCESS_START_TIMEOUT.getValue()).until(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    try {
                        OperaInProcessRunner.this.process.getExitCode();
                        return false;
                    }
                    catch (IllegalStateException illegalStateException) {
                        return true;
                    }
                }
            });
            if (!startedProperly) {
                throw new IOException("Opera exited immediately; possibly incorrect arguments?  Command: " + this.process);
            }
        }
        catch (IOException e) {
            throw new OperaRunnerException("Could not start Opera: " + e.getMessage());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopOpera() throws OperaRunnerException {
        this.lock.lock();
        try {
            if (!this.isOperaRunning()) {
                return;
            }
            this.process.destroy();
        }
        finally {
            this.lock.unlock();
            this.process = null;
        }
    }

    @Override
    public boolean isOperaRunning() {
        return this.process != null;
    }

    @Override
    public boolean hasOperaCrashed() {
        this.assertNotShutdown();
        throw new UnsupportedOperationException();
    }

    @Override
    public String getOperaCrashlog() {
        this.assertNotShutdown();
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
    }

    @Override
    public ScreenCaptureReply captureScreen() {
        return this.captureScreen(OperaIntervals.RUNNER_SCREEN_CAPTURE_TIMEOUT.getMs());
    }

    @Override
    public ScreenCaptureReply captureScreen(long timeout) {
        return this.captureScreen(timeout, new ArrayList<String>());
    }

    @Override
    public ScreenCaptureReply captureScreen(long timeout, List<String> knownMD5s) {
        this.assertNotShutdown();
        ScreenCapture capture = new ImplicitWait(new Duration(timeout, TimeUnit.MILLISECONDS)).until(new Callable<ScreenCapture>(){

            @Override
            public ScreenCapture call() throws Exception {
                return ScreenCapture.of();
            }
        });
        try {
            return new ScreenCaptureReply(capture.getMd5(), capture.getData());
        }
        catch (IOException e) {
            throw new OperaRunnerException("Unable to do screen capture: " + e.getMessage());
        }
    }

    private void assertNotShutdown() {
        if (this.shutdown) {
            throw new OperaRunnerException("Opera was shutdown");
        }
    }
}

