/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlApplet;
import com.gargoylesoftware.htmlunit.html.HtmlBreak;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlListItem;
import com.gargoylesoftware.htmlunit.html.HtmlNoFrames;
import com.gargoylesoftware.htmlunit.html.HtmlNoScript;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlOrderedList;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableFooter;
import com.gargoylesoftware.htmlunit.html.HtmlTableHeader;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTitle;
import com.gargoylesoftware.htmlunit.html.HtmlUnorderedList;
import com.gargoylesoftware.htmlunit.html.TableRowGroup;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

class HtmlSerializer {
    private final StringBuilder buffer_ = new StringBuilder();
    protected static final String AS_TEXT_BLOCK_SEPARATOR = "\u00a7bs\u00a7";
    protected static final String AS_TEXT_NEW_LINE = "\u00a7nl\u00a7";
    protected static final String AS_TEXT_BLANK = "\u00a7blank\u00a7";
    protected static final String AS_TEXT_TAB = "\u00a7tab\u00a7";
    private static final Pattern CLEAN_UP_PATTERN = Pattern.compile("(?:\u00a7bs\u00a7)+");
    private static final Pattern REDUCE_WHITESPACE_PATTERN = Pattern.compile("\\s*\u00a7bs\u00a7\\s*");
    private static final Pattern TEXT_AREA_PATTERN = Pattern.compile("\r?\n");
    private boolean appletEnabled_;
    private boolean ignoreMaskedElements_ = true;

    HtmlSerializer() {
    }

    public String asText(DomNode node) {
        this.appletEnabled_ = node.getPage().getWebClient().getOptions().isAppletEnabled();
        this.buffer_.setLength(0);
        this.appendNode(node);
        String response = this.buffer_.toString();
        this.buffer_.setLength(0);
        return this.cleanUp(response);
    }

    private String cleanUp(String text) {
        text = StringUtils.replace(text, "\u00a7nl\u00a7\u00a7bs\u00a7", AS_TEXT_BLOCK_SEPARATOR);
        text = this.reduceWhitespace(text);
        text = StringUtils.replace(text, AS_TEXT_BLANK, " ");
        String ls = System.getProperty("line.separator");
        text = StringUtils.replace(text, AS_TEXT_NEW_LINE, ls);
        text = CLEAN_UP_PATTERN.matcher(text).replaceAll(ls);
        text = StringUtils.replace(text, AS_TEXT_TAB, "\t");
        return text;
    }

    protected String reduceWhitespace(String text) {
        text = text.trim();
        text = REDUCE_WHITESPACE_PATTERN.matcher(text).replaceAll(AS_TEXT_BLOCK_SEPARATOR);
        while (text.startsWith(AS_TEXT_BLOCK_SEPARATOR)) {
            text = text.substring(AS_TEXT_BLOCK_SEPARATOR.length());
        }
        while (text.endsWith(AS_TEXT_BLOCK_SEPARATOR)) {
            text = text.substring(0, text.length() - AS_TEXT_BLOCK_SEPARATOR.length());
        }
        text = text.trim();
        StringBuilder buffer = new StringBuilder(text.length());
        boolean whitespace = false;
        for (char ch : text.toCharArray()) {
            if (ch == '\u00a0') {
                buffer.append(' ');
                whitespace = false;
                continue;
            }
            if (whitespace) {
                if (Character.isWhitespace(ch)) continue;
                buffer.append(ch);
                whitespace = false;
                continue;
            }
            if (Character.isWhitespace(ch)) {
                whitespace = true;
                buffer.append(' ');
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    protected void appendNode(DomNode node) {
        if (node instanceof DomText) {
            this.appendText((DomText)node);
        } else if (!(node instanceof DomComment || node instanceof HtmlApplet && this.appletEnabled_)) {
            if (node instanceof HtmlBreak) {
                this.doAppendNewLine();
            } else if (!(node instanceof HtmlHiddenInput || node instanceof HtmlScript || node instanceof HtmlStyle || node instanceof HtmlNoFrames)) {
                if (node instanceof HtmlTextArea) {
                    this.appendHtmlTextArea((HtmlTextArea)node);
                } else if (node instanceof HtmlTitle) {
                    this.appendHtmlTitle((HtmlTitle)node);
                } else if (node instanceof HtmlTableRow) {
                    this.appendHtmlTableRow((HtmlTableRow)node);
                } else if (node instanceof HtmlSelect) {
                    this.appendHtmlSelect((HtmlSelect)node);
                } else if (node instanceof HtmlSubmitInput) {
                    this.appendHtmlSubmitInput((HtmlSubmitInput)node);
                } else if (node instanceof HtmlCheckBoxInput) {
                    String str = ((HtmlCheckBoxInput)node).isChecked() ? "checked" : "unchecked";
                    this.doAppend(str);
                } else if (node instanceof HtmlRadioButtonInput) {
                    String str = ((HtmlRadioButtonInput)node).isChecked() ? "checked" : "unchecked";
                    this.doAppend(str);
                } else if (node instanceof HtmlInput) {
                    this.doAppend(((HtmlInput)node).getValueAttribute());
                } else if (node instanceof HtmlTable) {
                    this.appendHtmlTable((HtmlTable)node);
                } else if (node instanceof HtmlOrderedList) {
                    this.appendHtmlOrderedList((HtmlOrderedList)node);
                } else if (node instanceof HtmlUnorderedList) {
                    this.appendHtmlUnorderedList((HtmlUnorderedList)node);
                } else {
                    if (node instanceof HtmlNoScript && node.getPage().getWebClient().getOptions().isJavaScriptEnabled()) {
                        return;
                    }
                    boolean block = node.isBlock();
                    if (block) {
                        this.doAppendBlockSeparator();
                    }
                    this.appendChildren(node);
                    if (block) {
                        this.doAppendBlockSeparator();
                    }
                }
            }
        }
    }

    private void doAppendBlockSeparator() {
        this.buffer_.append(AS_TEXT_BLOCK_SEPARATOR);
    }

    private void doAppend(String str) {
        this.buffer_.append(str);
    }

    private void doAppendNewLine() {
        this.buffer_.append(AS_TEXT_NEW_LINE);
    }

    private void doAppendTab() {
        this.buffer_.append(AS_TEXT_TAB);
    }

    private void appendHtmlUnorderedList(HtmlUnorderedList htmlUnorderedList) {
        this.doAppendBlockSeparator();
        boolean first = true;
        for (DomNode item : htmlUnorderedList.getChildren()) {
            if (!first) {
                this.doAppendBlockSeparator();
            }
            first = false;
            this.appendNode(item);
        }
        this.doAppendBlockSeparator();
    }

    private void appendHtmlTitle(HtmlTitle htmlTitle) {
        DomNode child = htmlTitle.getFirstChild();
        if (child instanceof DomText) {
            this.doAppend(((DomText)child).getData());
            this.doAppendBlockSeparator();
            return;
        }
    }

    private void appendChildren(DomNode node) {
        for (DomNode child : node.getChildren()) {
            this.appendNode(child);
        }
    }

    private void appendHtmlTableRow(HtmlTableRow htmlTableRow) {
        boolean first = true;
        for (HtmlTableCell cell : htmlTableRow.getCells()) {
            if (!first) {
                this.doAppendTab();
            } else {
                first = false;
            }
            this.appendChildren(cell);
        }
    }

    private void appendHtmlTextArea(HtmlTextArea htmlTextArea) {
        if (this.isVisible(htmlTextArea)) {
            String text = htmlTextArea.getText();
            text = StringUtils.replace(text, " ", AS_TEXT_BLANK);
            text = TEXT_AREA_PATTERN.matcher(text).replaceAll(AS_TEXT_NEW_LINE);
            text = StringUtils.replace(text, "\r", AS_TEXT_NEW_LINE);
            this.doAppend(text);
        }
    }

    private void appendHtmlTable(HtmlTable htmlTable) {
        this.doAppendBlockSeparator();
        String caption = htmlTable.getCaptionText();
        if (caption != null) {
            this.doAppend(caption);
            this.doAppendBlockSeparator();
        }
        boolean first = true;
        HtmlTableHeader tableHeader = htmlTable.getHeader();
        if (tableHeader != null) {
            first = this.appendHtmlTableRows(tableHeader.getRows(), true, null, null);
        }
        HtmlTableFooter tableFooter = htmlTable.getFooter();
        first = this.appendHtmlTableRows(htmlTable.getRows(), first, tableHeader, tableFooter);
        if (tableFooter != null) {
            first = this.appendHtmlTableRows(tableFooter.getRows(), first, null, null);
        }
        this.doAppendBlockSeparator();
    }

    private boolean appendHtmlTableRows(List<HtmlTableRow> rows, boolean first, TableRowGroup skipParent1, TableRowGroup skipParent2) {
        for (HtmlTableRow row : rows) {
            if (row.getParentNode() == skipParent1 || row.getParentNode() == skipParent2) continue;
            if (!first) {
                this.doAppendBlockSeparator();
            }
            first = false;
            this.appendHtmlTableRow(row);
        }
        return first;
    }

    private void appendHtmlSubmitInput(HtmlSubmitInput htmlSubmitInput) {
        String value = htmlSubmitInput.getValueAttribute();
        if (value == DomElement.ATTRIBUTE_NOT_DEFINED) {
            value = "Submit Query";
        }
        this.doAppend(value);
    }

    private void appendHtmlSelect(HtmlSelect htmlSelect) {
        List<HtmlOption> options = htmlSelect.isMultipleSelectEnabled() ? htmlSelect.getOptions() : htmlSelect.getSelectedOptions();
        Iterator<HtmlOption> i = options.iterator();
        while (i.hasNext()) {
            HtmlOption currentOption = i.next();
            this.appendNode(currentOption);
            if (!i.hasNext()) continue;
            this.doAppendBlockSeparator();
        }
    }

    private void appendHtmlOrderedList(HtmlOrderedList htmlOrderedList) {
        this.doAppendBlockSeparator();
        boolean first = true;
        int i = 1;
        for (DomNode item : htmlOrderedList.getChildren()) {
            if (!(item instanceof HtmlListItem)) continue;
            if (!first) {
                this.doAppendBlockSeparator();
            }
            first = false;
            this.doAppend(Integer.toString(i++));
            this.doAppend(". ");
            this.appendChildren(item);
        }
        this.doAppendBlockSeparator();
    }

    private void appendText(DomText domText) {
        if (this.isVisible(domText.getParentNode())) {
            this.append(domText.getData());
        }
    }

    private boolean isVisible(DomNode node) {
        return !this.ignoreMaskedElements_ || node.isDisplayed();
    }

    public void setIgnoreMaskedElements(boolean ignore) {
        this.ignoreMaskedElements_ = ignore;
    }

    private void append(String text) {
        this.doAppend(text);
    }
}

