#!perl

use strict;
use utf8;
use Test::More 0.82;
BEGIN { use_ok('Map::Tube::Lyon') || print "Bail out!\n"; }

SKIP: {
  eval 'use XML::LibXML';
  if ($@) {
    diag( 'XML::LibXML required for this test' );
    skip( 'XML::LibXML required for this test', 1 );
  }

  my $map = new_ok( 'Map::Tube::Lyon' );
  my $dom = XML::LibXML->load_xml( location => $map->xml() );
  my(%lines, %stations);

  for my $line( $dom->findnodes('/tube/lines/line') ) {
    my $id    = $line->getAttribute('id');
    ok( !exists( $lines{$id} ), "Line id $id defined more than once" );
    $lines{$id} = 0;
  }

  for my $station( $dom->findnodes('/tube/stations/station') ) {
    my $id    = $station->getAttribute('id');
    my @lines = split( /,/, $station->getAttribute('line') );
    my @links = split( /,/, $station->getAttribute('link') );

    isnt( scalar(@lines), 0, "Station $id should have at least one line" );
    isnt( scalar(@links), 0, "Station $id should have at least one link" );

    ok( !exists( $stations{$id} ), "Station id $id defined more than once" );

    $stations{$id}->{lines}->{$_}++ for @lines;
    $stations{$id}->{links}->{$_}++ for @links;

    ok( exists( $lines{$_} ), "Station $id connected by undefined line $_" ) for @lines;

    $lines{$_}++ for @lines;
  }

  # Links should be symmetric: (not necessarily, but in our tube!)
  for my $id( keys %stations ) {
    ok( exists $stations{$_}->{links}->{$id}, "Station $id linked to $_ but not vice versa" ) for keys %{ $stations{$id}->{links} };
  }

  # Every line should have at least one station:
  isnt( $lines{$_}, 0, "Line $_ has no stations" ) for keys %lines;

}
done_testing();
