use strict;
use ExtUtils::MakeMaker;
use File::ShareDir::Install;

install_share dist => 'share';

WriteMakefile(
    NAME               => 'Map::Tube::Glasgow',
    AUTHOR             => q{Gisbert W. Selke <gws@cpan.org>},
    VERSION_FROM       => 'lib/Map/Tube/Glasgow.pm',
    ABSTRACT_FROM      => 'lib/Map/Tube/Glasgow.pm',
    LICENSE            => 'artistic_2',
    PL_FILES           => { },
    MIN_PERL_VERSION   => 5.006,
    CONFIGURE_REQUIRES => {
                           'ExtUtils::MakeMaker' => 0,
                           'File::ShareDir::Install' => 0,
                          },
    BUILD_REQUIRES     => {
                           'Test::More' => 0,
                          },
    PREREQ_PM          => {
                           'Moo'              => 0,
                           'namespace::clean' => 0,
                           'File::Share'      => 0,
                           'Map::Tube'        => '2.40',
                          },
    dist               => {
                            COMPRESS => 'gzip -9f', SUFFIX => 'gz',
                          },
    clean              => {
                            FILES => 'Map-Tube-Glasgow-*',
                          },
    (eval { ExtUtils::MakeMaker->VERSION(6.46) } ? (META_MERGE => {
            'meta-spec' => { version => 2 },
            'provides'  => {
                             'Map::Tube::Glasgow' => { file => 'lib/Map/Tube/Glasgow.pm', version => '0.01' },
                           },
          })
     : ()
    ),
);

package MY;
use File::ShareDir::Install 'postamble';
