package App::Manoc::Controller::NICType;
#ABSTRACT: MngUrlFormat controller

use Moose;

our $VERSION = '2.99.3'; ##TRIAL VERSION

use namespace::autoclean;

use App::Manoc::Form::NICType;

BEGIN { extends 'App::Manoc::ControllerBase::CRUD'; }

__PACKAGE__->config(
    # define PathPart
    action => {
        setup => {
            PathPart => 'nictype',
        }
    },
    class            => 'ManocDB::NICType',
    form_class       => 'App::Manoc::Form::NICType',
    view_object_perm => undef,
);


sub view : Chained('object') : PathPart('') : Args(0) {
    my ( $self, $c ) = @_;

    my $object = $c->stash->{object};
    $c->response->redirect( $c->uri_for_action( $c->namespace . "/edit", [ $object->id ] ) );
}


sub delete_object {
    my ( $self, $c ) = @_;

    my $object = $c->stash->{object};
    if ( $object->server_hw_nics->count > 0 ) {
        $c->flash( error_msg => 'NIC type is in use. Cannot be deleted.' );
        return;
    }

    return $c->stash->{'object'}->delete;
}


sub get_delete_failure_url {
    my ( $self, $c ) = @_;

    my $action = $c->namespace . "/list";
    return $c->uri_for_action($action);
}


sub get_form_success_url {
    my ( $self, $c ) = @_;

    my $action = $c->namespace . "/list";
    return $c->uri_for_action($action);
}

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Controller::NICType - MngUrlFormat controller

=head1 VERSION

version 2.99.3

=head1 ACTIONS

=head2 view

Redirect to edit

=head2 get_form_success_url

=head1 METHODS

=head2 delete_object

=head2 get_delete_failure_url

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
