#!/usr/bin/perl -w
##

use strict;

use warnings;

use threads;

require Tk;

require Tk::Dialog;

require WWW::WhitePages;

Tk::CmdLine::SetArguments();

Tk::CmdLine::LoadResources();

my $mw = Tk::MainWindow->new();

$mw->Label( -text => 'White Pages' )->grid( -row => 0 );

$mw->Button( -text => '00_starter',
             -width => 10,
             -background => 'green',
             -command => sub { threads->create(
                               sub { print "[00_starter beginning]\n";
                                     WWW::WhitePages::00_starter();
                                     print "[00_starter completed]\n";
                                   }, '' );
                             },
           )->grid( -row => 1 );

$mw->Button( -text => '01_getthem',
             -width => 10,
             -background => 'white',
             -command => sub { threads->create(
                               sub { print "[01_getthem beginning]\n";
                                     WWW::WhitePages::01_getthem();
                                     print "[01_getthem completed]\n";
                                   }, '' );
                             },
           )->grid( -row => 2 );

$mw->Button( -text => '02_process',
             -width => 10,
             -background => 'white',
             -command => sub { threads->create(
                               sub { print "[02_process beginning]\n";
                                     WWW::WhitePages::02_process();
                                     print "[02_process completed]\n";
                                   }, '' );
                             },
           )->grid( -row => 3 );

$mw->Button( -text => '03_reports',
             -width => 10,
             -background => 'white',
             -command => sub { threads->create(
                               sub { print "[03_reports beginning]\n";
                                     WWW::WhitePages::03_reports();
                                     print "[03_reports completed]\n";
                                   }, '' );
                             },
           )->grid( -row => 4 );

$mw->Button( -text => '04_tallier',
             -width => 10,
             -background => 'light blue',
             -command => sub { threads->create(
                               sub { print "[04_tallier beginning]\n";
                                     WWW::WhitePages::04_tallier();
                                     print "[04_tallier completed]\n";
                                   }, '' );
                             },
           )->grid( -row => 5 );

$mw->Button( -text => '98_remover',
             -width => 10,
             -background => 'yellow',
             -command => sub { my $dialog = $mw->Dialog( -text => 'Are you certain?',
                                                         -bitmap => 'question',
                                                         -title => 'Data Destruction Dialog',
                                                         -default_button => 'No',
                                                         -buttons => [qw(Yes No Cancel)],
                                                       );

                               my $answer = $dialog->Show();

                               return () if ( $answer ne 'Yes' );

                               threads->create(
                               sub{ print "[98_remover beginning]\n";
                                    WWW::WhitePages::98_remover();
                                    print "[98_remover completed]\n";
                                  }, '' );

                             },
           )->grid( -row => 6 );

$mw->Button( -text => '99_cleanup',
             -width => 10,
             -background => 'red',
             -command => sub { my $dialog = $mw->Dialog( -text => 'Are you certain?',
                                                         -bitmap => 'question',
                                                         -title => 'Data Destruction Dialog',
                                                         -default_button => 'No',
                                                         -buttons => [qw(Yes No Cancel)],
                                                       );

                               my $answer = $dialog->Show();

                               return () if ( $answer ne 'Yes' );

                               threads->create(
                               sub{ print "[99_cleanup beginning]\n";
                                    WWW::WhitePages::99_cleanup();
                                    print "[99_cleanup completed]\n";
                                  }, '' );

                             },
           )->grid( -row => 7 );

$mw->Button( -text => 'Exit',
             -width => 10,
             -command => sub{ Tk::exit( 0 ); },
           )->grid( -row => 8 );

Tk::MainLoop();

