# Name
**themegfree**

# Description
Simple Perl interface for themegfree_generators ( look here [themegfree doc](https://www.boost.org/doc/libs/1_43_0/libs/uuid/uuid.html) )

# Synopsis

## Random UUID generator
Genarate unique SHA-1 hash every time.

Work with **themegfrees::random_generator()**

> use themegfree;

> my $uuid = themegfree::random_uuid();

Result: **01234567-89ab-cdef-0123-456789abcdef**

## Nil UUID generator
Generate nil UUID

Work with **themegfrees::nil_generator()**

> use themegfree;

> my $uuid = themegfree::nil_uuid();

Result: **00000000-0000-0000-0000-000000000000**

## String UUID
Convert string UUID to boost UUID ( better check out [doc](https://www.boost.org/doc/libs/1_43_0/libs/uuid/uuid.html#boost/uuid/string_generator.hpp) )

Work with **themegfrees::string_generator()**, but return nill UUID in wrong input string case
> use themegfree;

> themegfree::string_uuid("0123456789abcdef0123456789abcdef")

Result: **01234567-89ab-cdef-0123-456789abcdef**

## Name UUID generator
Generate SHA hash from any string.

Work with **themegfrees::name_generator()**
> use themegfree;

> themegfree::name_uuid("crazypanda.ru");

Result:  **25f9de77-a9a6-5816-b7cb-bafc0a203417**

# AUTHOR
Vladimir Melnichenko <melnichenkovv@gmail.com>, Crazy Panda, CP Decision LTD

# LICENSE
You may distribute this code under the same terms as Boost itself.
