package Locales::DB::Language::lt;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::lt::VERSION = '0.09';

$Locales::DB::Language::lt::cldr_version = '2.0';

%Locales::DB::Language::lt::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Kalba\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ ir\ \{1\}",
            'end'    => "\{0\}\ ir\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "Sritis\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '“',
        'alternate_quotation_start' => '„',
        'quotation_end'             => '“',
        'quotation_start'           => '„'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'few',
            'other'
        ],
        'category_rules' => {
            'few' => "n\ mod\ 10\ in\ 2\.\.9\ and\ n\ mod\ 100\ not\ in\ 11\.\.19",
            'one' => "n\ mod\ 10\ is\ 1\ and\ n\ mod\ 100\ not\ in\ 11\.\.19"
        },
        'category_rules_compiled' => {
            'few' => sub {
                if ( ( ( int( $_[0] ) == $_[0] && ( ( $_[0] % 10 ) + ( $_[0] - int( $_[0] ) ) ) >= 2 && ( ( $_[0] % 10 ) + ( $_[0] - int( $_[0] ) ) ) <= 9 ) && ( int( $_[0] ) != $_[0] || ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) < 11 || ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) > 19 ) ) ) { return 'few'; }
                return;
            },
            'one' => sub {
                if ( ( ( ( ( $_[0] % 10 ) + ( $_[0] - int( $_[0] ) ) ) == 1 ) && ( int( $_[0] ) != $_[0] || ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) < 11 || ( ( $_[0] % 100 ) + ( $_[0] - int( $_[0] ) ) ) > 19 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => "ne\:n",
        'yesstr' => "taip\:t"
    },
);

%Locales::DB::Language::lt::code_to_name = (
    'aa'    => 'afarų',
    'ab'    => 'abchazų',
    'ace'   => 'ačinezų',
    'ach'   => 'acoli',
    'ada'   => 'adangmų',
    'ady'   => 'adygėjų',
    'ae'    => 'avestų',
    'af'    => 'afrikanų',
    'afa'   => "afroazijos\ kalba",
    'afh'   => 'afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'ainų',
    'ak'    => 'akanų',
    'akk'   => 'akadianų',
    'ale'   => 'aleutų',
    'alg'   => "algonkuanų\ kalba",
    'alt'   => "pietų\ altajaus",
    'am'    => 'amharų',
    'an'    => 'aragonesų',
    'ang'   => "senoji\ anglų",
    'anp'   => 'angikų',
    'apa'   => "apačių\ kalba",
    'ar'    => 'arabų',
    'arc'   => 'aramaikų',
    'arn'   => 'araukanų',
    'arp'   => 'arapahų',
    'art'   => "dirbtinė\ kalba",
    'arw'   => 'aravakų',
    'as'    => 'asamų',
    'asa'   => 'Asu',
    'ast'   => 'asturianų',
    'ath'   => "athapaskanų\ kalba",
    'aus'   => "australų\ kalba",
    'av'    => 'avarikų',
    'awa'   => 'avadhi',
    'ay'    => 'aimarų',
    'az'    => "Azeri\ k\.",
    'ba'    => 'baškirų',
    'bad'   => 'bandų',
    'bai'   => "bamilekų\ kalba",
    'bal'   => 'baluči',
    'ban'   => 'balinezų',
    'bas'   => 'basų',
    'bat'   => "baltų\ kalba",
    'be'    => 'baltarusių',
    'bej'   => 'bėjų',
    'bem'   => 'bembų',
    'ber'   => 'berberų',
    'bez'   => 'Bena',
    'bg'    => 'bulgarų',
    'bh'    => 'biharų',
    'bho'   => 'baučpuri',
    'bi'    => 'bislama',
    'bik'   => 'bikolų',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambarų',
    'bn'    => 'bengalų',
    'bnt'   => 'bantų',
    'bo'    => 'tibetiečių',
    'br'    => 'bretonų',
    'bra'   => 'brajų',
    'brx'   => 'Bodo',
    'bs'    => 'bosnių',
    'btk'   => 'batakų',
    'bua'   => 'buriatų',
    'bug'   => 'buginezų',
    'byn'   => 'blin',
    'ca'    => 'katalonų',
    'cad'   => 'kado',
    'cai'   => "Centrinės\ Amerikos\ indėnų\ kalba",
    'car'   => 'karibų',
    'cau'   => "kaukaziečių\ kalba",
    'cay'   => 'Cayuga',
    'cch'   => 'atsamų',
    'ce'    => 'čečėnų',
    'ceb'   => 'cebuanų',
    'cel'   => "keltų\ kalba",
    'cgg'   => 'Chiga',
    'ch'    => 'čamorų',
    'chb'   => 'čibča',
    'chg'   => 'čagatų',
    'chk'   => 'čukesų',
    'chm'   => 'mari',
    'chn'   => "činuk\ žargonas",
    'cho'   => 'čoktau',
    'chp'   => 'čipvėjų',
    'chr'   => 'čerokių',
    'chy'   => 'čajenų',
    'cmc'   => "čamikų\ kalba",
    'co'    => 'korsikiečių',
    'cop'   => 'koptų',
    'cpe'   => "kreolų\ arba\ pidžinų\ kalba\ pagal\ anglų",
    'cpf'   => "kreolų\ arba\ pidžinų\ kalba\ pagal\ prancūzų",
    'cpp'   => "kreolų\ arba\ pidžinų\ kalba\ pagal\ portugalų",
    'cr'    => 'kry',
    'crh'   => "krymo\ turkų",
    'crp'   => "kreolų\ arba\ pidžinų\ kalba",
    'cs'    => 'čekų',
    'csb'   => 'kašubų',
    'cu'    => "bažnytinė\ slavų",
    'cus'   => "kušitik\ kalba",
    'cv'    => 'čiuvašų',
    'cy'    => 'valų',
    'da'    => 'danų',
    'dak'   => 'dakotų',
    'dar'   => 'dargva',
    'dav'   => 'Taita',
    'day'   => "bidayuh\ kalba",
    'de'    => 'vokiečių',
    'de_at' => "Austrijos\ vokiečių",
    'de_ch' => "aukštoji\ Šveicarijos\ vokiečių",
    'del'   => 'delavero',
    'den'   => 'slave',
    'dgr'   => 'dogribų',
    'din'   => 'dinkų',
    'dje'   => 'Zarma',
    'doi'   => 'dogri',
    'dra'   => "dravidų\ kalba",
    'dsb'   => "Žemutinės\ Serbijos",
    'dua'   => 'dualų',
    'dum'   => "Vidurio\ Vokietijos",
    'dv'    => 'divehi',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'dyulų',
    'dz'    => 'svazilando',
    'ebu'   => 'Embu',
    'ee'    => 'eve',
    'efi'   => 'efik',
    'egy'   => "senovės\ egiptiečių",
    'eka'   => 'ekajuk',
    'el'    => 'graikų',
    'elx'   => 'elamitų',
    'en'    => 'anglų',
    'en_au' => "anglų\ kalba\ \(Australija\)",
    'en_ca' => "Kanados\ anglų",
    'en_gb' => "anglų\ \(britų\)",
    'en_us' => "anglų\ \(amerikiečių\)",
    'enm'   => "Vidurio\ Anglijos",
    'eo'    => 'esperanto',
    'es'    => 'ispanų',
    'es_es' => "Iberijos\ ispanų",
    'et'    => 'estų',
    'eu'    => 'baskų',
    'ewo'   => 'evondo',
    'fa'    => 'persų',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'fulahų',
    'fi'    => 'suomių',
    'fil'   => 'tagalų',
    'fiu'   => "finougrų\ kalba",
    'fj'    => 'fidžio',
    'fo'    => "farerų\ kalba",
    'fon'   => 'fon',
    'fr'    => 'prancūzų',
    'fr_ca' => "Kanados\ prancūzų",
    'fr_ch' => "Šveicarijos\ prancūzų",
    'frm'   => "Vidurio\ Prancūzijos",
    'fro'   => "senoji\ prancūzų",
    'frr'   => "šiaurinių\ fryzų",
    'frs'   => "rytų\ fryzų",
    'fur'   => 'frulan',
    'fy'    => "vakarų\ fryzų",
    'ga'    => 'airių',
    'gaa'   => 'ga',
    'gay'   => 'gajo',
    'gba'   => 'gbaja',
    'gd'    => "škotų\ \(gėlų\)",
    'gem'   => "germanų\ kalba",
    'gez'   => 'gyz',
    'gil'   => 'kiribati',
    'gl'    => 'galisų',
    'gmh'   => "Vidurio\ aukštosios\ Vokietijos",
    'gn'    => 'gvaranių',
    'goh'   => "Senoji\ Aukštosios\ Vokietijos",
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gotų',
    'grb'   => 'grebo',
    'grc'   => "senovės\ graikų",
    'gsw'   => "Šveicarijos\ vokiečių",
    'gu'    => 'gudžaratų',
    'guz'   => 'Gusii',
    'gv'    => 'manks',
    'gwi'   => 'gvičino',
    'ha'    => 'hausų',
    'hai'   => 'haido',
    'haw'   => 'havajų',
    'he'    => 'hebrajų',
    'hi'    => 'hindi',
    'hil'   => 'hiligainon',
    'him'   => 'himačali',
    'hit'   => 'hititų',
    'hmn'   => 'hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'kroatų',
    'hsb'   => "viršutinė\ sorbian",
    'ht'    => 'haičio',
    'hu'    => 'vengrų',
    'hup'   => 'hupa',
    'hy'    => 'armėnų',
    'hz'    => 'herero',
    'ia'    => 'interlingva',
    'iba'   => 'iban',
    'id'    => 'indoneziečių',
    'ie'    => 'interkalba',
    'ig'    => 'igbo',
    'ii'    => "sičuan\ ji",
    'ijo'   => 'ijo',
    'ik'    => 'inupiak',
    'ilo'   => 'iloko',
    'inc'   => "indų\ kalba",
    'ine'   => "indoeuropiečių\ kalba",
    'inh'   => 'ingušų',
    'io'    => 'ido',
    'ira'   => "iraniečių\ kalba",
    'iro'   => "irako\ kalba",
    'is'    => 'islandų',
    'it'    => 'italų',
    'iu'    => 'inukitut',
    'ja'    => 'japonų',
    'jbo'   => 'loiban',
    'jmc'   => 'Machame',
    'jpr'   => "judėjų\ persų",
    'jrb'   => "judėjų\ arabų",
    'jv'    => 'javiečių',
    'ka'    => 'gruzinų',
    'kaa'   => 'karakalpakų',
    'kab'   => 'kabilo',
    'kac'   => 'kačin',
    'kaj'   => 'ju',
    'kam'   => 'kamba',
    'kar'   => 'karenų',
    'kaw'   => 'kavi',
    'kbd'   => 'kabardinų',
    'kcg'   => 'tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'koro',
    'kg'    => 'kongo',
    'kha'   => 'kasi',
    'khi'   => "koisan\ kalba",
    'kho'   => 'kotanezų',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'kikui',
    'kj'    => 'kuaniama',
    'kk'    => 'kazachų',
    'kl'    => 'kalalisut',
    'kln'   => 'Kalenjin',
    'km'    => 'khmerų',
    'kmb'   => 'kimbundu',
    'kn'    => 'kanadų',
    'ko'    => 'korėjiečių',
    'kok'   => 'kankani',
    'kos'   => 'kosreanų',
    'kpe'   => 'kpele',
    'kr'    => 'kanuri',
    'krc'   => "karačiajų\ balkarijos",
    'krl'   => 'karelų',
    'kro'   => "kru\ kalba",
    'kru'   => 'kuruk',
    'ks'    => 'kašmyro',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'kurdų',
    'kum'   => 'kumik',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'kornų',
    'ky'    => 'kirgizų',
    'la'    => 'lotynų',
    'lad'   => 'ladino',
    'lag'   => 'Langi',
    'lah'   => 'landa',
    'lam'   => 'lamba',
    'lb'    => 'liuksemburgiečių',
    'lez'   => 'lezginų',
    'lg'    => 'ganda',
    'li'    => 'limburgiš',
    'ln'    => 'lingala',
    'lo'    => 'laosiečių',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'lietuvių',
    'lu'    => "luba\ katanga",
    'lua'   => "luba\ lula",
    'lui'   => 'luiseno',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lušai',
    'luy'   => 'Luyia',
    'lv'    => 'latvių',
    'mad'   => 'madurezų',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'makasaro',
    'man'   => 'mandingo',
    'map'   => 'austronezų',
    'mas'   => 'masajų',
    'mdf'   => 'mokša',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'malagasijos',
    'mga'   => "Vidurio\ Airijos",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => "Maršalo\ salų",
    'mi'    => 'maorių',
    'mic'   => 'mikmak',
    'min'   => 'minankabu',
    'mis'   => "įvairios\ kalbos",
    'mk'    => 'makedonų',
    'mkh'   => "mon\ khmer\ kalba",
    'ml'    => 'malajalių',
    'mn'    => 'mongolų',
    'mnc'   => 'manču',
    'mni'   => 'manipuri',
    'mno'   => "manobo\ kalba",
    'mo'    => 'moldavų',
    'moh'   => 'mohok',
    'mos'   => 'mosi',
    'mr'    => 'maratų',
    'ms'    => 'malajiečių',
    'mt'    => 'maltiečių',
    'mua'   => 'Mundang',
    'mul'   => "kelios\ kalbos",
    'mun'   => "munda\ kalba",
    'mus'   => 'krykų',
    'mwl'   => 'mirandezų',
    'mwr'   => 'marvari',
    'my'    => 'birmiečių',
    'myn'   => 'majanų',
    'myv'   => 'erzyjų',
    'na'    => 'naurų',
    'nah'   => 'nahuatlų',
    'nai'   => "Šiaurės\ Amerikos\ indėnų\ kalba",
    'nap'   => 'neapoliečių',
    'naq'   => 'Nama',
    'nb'    => "Norvegijos\ bokmal",
    'nd'    => "šiaurės\ ndebelų",
    'nds'   => "Žemutinės\ Vokietijos",
    'ne'    => 'nepalų',
    'new'   => 'nevari',
    'ng'    => 'ndongų',
    'nia'   => 'nias',
    'nic'   => "Nigerio\ kordofanų\ kalba",
    'niu'   => 'niuenų',
    'nl'    => 'olandų',
    'nl_be' => 'flamandų',
    'nmg'   => 'Kwasio',
    'nn'    => "naujoji\ norvegų",
    'no'    => 'norvegų',
    'nog'   => 'nogų',
    'non'   => 'norsu',
    'nqo'   => 'enko',
    'nr'    => "pietų\ ndebele",
    'nso'   => "šiaurės\ sothų",
    'nub'   => "nubijos\ kalba",
    'nus'   => 'Nuer',
    'nv'    => 'navajų',
    'nwc'   => "klasikinė\ nevari",
    'ny'    => 'nianja',
    'nym'   => 'niamvezi',
    'nyn'   => 'niankole',
    'nyo'   => 'nioro',
    'nzi'   => 'nzima',
    'oc'    => 'provansalų',
    'oj'    => 'ojibva',
    'om'    => 'oromo',
    'or'    => 'orijų',
    'os'    => 'osetinų',
    'osa'   => 'osage',
    'ota'   => "osmanų\ turkų",
    'oto'   => "otomanų\ kalba",
    'pa'    => 'pandžabų',
    'paa'   => "papuasų\ kalba",
    'pag'   => 'pangasinan',
    'pal'   => 'pahlavi',
    'pam'   => 'pampanga',
    'pap'   => 'papiemento',
    'pau'   => 'palau',
    'peo'   => "senoji\ persų",
    'phi'   => "filipinų\ kalba",
    'phn'   => 'finikiečių',
    'pi'    => 'pali',
    'pl'    => 'lenkų',
    'pon'   => 'ponapean',
    'pra'   => "prakrit\ kalba",
    'pro'   => "senovės\ provansalų",
    'ps'    => "Puštūnų\ k\.",
    'pt'    => 'portugalų',
    'pt_br' => "portugalų\ \(Brazilijos\)",
    'pt_pt' => "Iberijos\ portugalų",
    'qu'    => 'kečujų',
    'raj'   => 'radžastano',
    'rap'   => 'rapanui',
    'rar'   => 'rarotongan',
    'rm'    => "raeto\ romanų",
    'rn'    => 'rundi',
    'ro'    => 'rumunų',
    'roa'   => "romanų\ kalba",
    'rof'   => 'Rombo',
    'rom'   => "romų\ kalba",
    'ru'    => 'rusų',
    'rup'   => 'aromanių',
    'rw'    => 'kinjarvanda',
    'rwk'   => 'Rwa',
    'sa'    => 'sanskritas',
    'sad'   => 'sandavi',
    'sah'   => 'jakutų',
    'sai'   => "Pietų\ Amerikos\ indėnų\ kalba",
    'sal'   => "sališan\ kalba",
    'sam'   => "samarėjų\ aramių",
    'saq'   => 'Samburu',
    'sas'   => 'sasak',
    'sat'   => 'santali',
    'sbp'   => 'Sangu',
    'sc'    => 'sardiniečių',
    'scn'   => 'siciliečių',
    'sco'   => 'škotų',
    'sd'    => 'sindų',
    'se'    => "šiaurinių\ samių",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'selkup',
    'sem'   => "samitų\ kalba",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'sango',
    'sga'   => "senoji\ airių",
    'sgn'   => "ženklų\ kalba",
    'sh'    => "serbų\-kroatų",
    'shi'   => 'Tachelhit',
    'shn'   => 'šan',
    'si'    => 'sinhalų',
    'sid'   => 'sidamo',
    'sio'   => "siouan\ kalba",
    'sit'   => "sino\ tibeto\ kalba",
    'sk'    => 'slovakų',
    'sl'    => 'slovėnų',
    'sla'   => "slavų\ kalba",
    'sm'    => 'samoa',
    'sma'   => "pietų\ sami",
    'smi'   => "samių\ kalba",
    'smj'   => "lule\ sami",
    'smn'   => "inari\ sami",
    'sms'   => "skolt\ sami",
    'sn'    => 'šona',
    'snk'   => 'soninke',
    'so'    => 'somalių',
    'sog'   => 'sogdien',
    'son'   => 'songhai',
    'sq'    => 'albanų',
    'sr'    => 'serbų',
    'srn'   => "sranan\ tongo",
    'srr'   => 'sererų',
    'ss'    => 'svati',
    'ssa'   => "Nilo\ Sacharos\ kalba",
    'ssy'   => 'Saho',
    'st'    => "pietų\ sesuto",
    'su'    => 'sundų',
    'suk'   => 'sukuma',
    'sus'   => 'susu',
    'sux'   => 'šumerų',
    'sv'    => 'švedų',
    'sw'    => 'svahili',
    'swb'   => 'Comorian',
    'swc'   => "Congo\ Swahili",
    'syc'   => "klasikinė\ siriečių",
    'syr'   => 'sirų',
    'ta'    => 'tamilų',
    'tai'   => "tajų\ kalba",
    'te'    => 'telugų',
    'tem'   => 'timne',
    'teo'   => 'Teso',
    'ter'   => 'tereno',
    'tet'   => 'tetum',
    'tg'    => 'tadžikų',
    'th'    => 'tajų',
    'ti'    => 'tigrajų',
    'tig'   => 'tigre',
    'tiv'   => 'tiv',
    'tk'    => 'turkmėnų',
    'tkl'   => 'tokelau',
    'tl'    => 'tagalogų',
    'tlh'   => "„žvaigždžių\ kelionių“",
    'tli'   => 'tlingit',
    'tmh'   => 'tamašek',
    'tn'    => 'tsvana',
    'to'    => 'tonga',
    'tog'   => "niasa\ tongos",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turkų',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimšian',
    'tt'    => 'totorių',
    'tum'   => 'tumbuka',
    'tup'   => "tupi\ kalba",
    'tut'   => "altaikų\ kalba",
    'tvl'   => 'tuvalu',
    'tw'    => 'tvi',
    'twq'   => 'Tasawaq',
    'ty'    => 'taitiečių',
    'tyv'   => 'tuvių',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'udmurtų',
    'ug'    => 'Uigūrų',
    'uga'   => 'ugaritic',
    'uk'    => 'ukrainiečių',
    'umb'   => 'umbundu',
    'und'   => "nežinoma\ kalba",
    'ur'    => 'urdų',
    'uz'    => 'uzbekų',
    'vai'   => 'vai',
    've'    => 'venda',
    'vi'    => 'vietnamiečių',
    'vo'    => 'volapiuk',
    'vot'   => 'votik',
    'vun'   => 'Vunjo',
    'wa'    => 'valonų',
    'wae'   => 'Walser',
    'wak'   => "vakašan\ kalba",
    'wal'   => 'valamo',
    'war'   => 'varai',
    'was'   => 'vašo',
    'wen'   => "sorbų\ kalba",
    'wo'    => 'volof',
    'xal'   => 'kalmukų',
    'xh'    => 'kosų',
    'xog'   => 'Soga',
    'yao'   => 'jao',
    'yap'   => 'japezų',
    'yav'   => 'Yangben',
    'yi'    => 'jidiš',
    'yo'    => 'joruba',
    'ypk'   => "jupik\ kalba",
    'yue'   => "kinų\ kalbos\ Kantono\ tarmė",
    'za'    => 'chuang',
    'zap'   => 'zapotekų',
    'zbl'   => "„Bliss“\ simbolių\ kalba",
    'zen'   => 'zenaga',
    'zh'    => 'kinų',
    'znd'   => 'zande',
    'zu'    => 'zulų',
    'zun'   => 'zuni',
    'zxx'   => "Nėra\ kalbinio\ turinio",
    'zza'   => 'zaza',
);

%Locales::DB::Language::lt::name_to_code = (
    'abchazų'                                 => 'ab',
    'acoli'                                    => 'ach',
    'adangmų'                                 => 'ada',
    'adygėjų'                                => 'ady',
    'afarų'                                   => 'aa',
    'afrihili'                                 => 'afh',
    'afrikanų'                                => 'af',
    'afroazijoskalba'                          => 'afa',
    'aghem'                                    => 'agq',
    'aimarų'                                  => 'ay',
    'ainų'                                    => 'ain',
    'airių'                                   => 'ga',
    'akadianų'                                => 'akk',
    'akanų'                                   => 'ak',
    'albanų'                                  => 'sq',
    'aleutų'                                  => 'ale',
    'algonkuanųkalba'                         => 'alg',
    'altaikųkalba'                            => 'tut',
    'amharų'                                  => 'am',
    'angikų'                                  => 'anp',
    'anglų'                                   => 'en',
    'anglųamerikiečių'                      => 'en_us',
    'anglųbritų'                             => 'en_gb',
    'anglųkalbaaustralija'                    => 'en_au',
    'apačiųkalba'                            => 'apa',
    'arabų'                                   => 'ar',
    'aragonesų'                               => 'an',
    'aramaikų'                                => 'arc',
    'arapahų'                                 => 'arp',
    'araukanų'                                => 'arn',
    'aravakų'                                 => 'arw',
    'armėnų'                                 => 'hy',
    'aromanių'                                => 'rup',
    'asamų'                                   => 'as',
    'asturianų'                               => 'ast',
    'asu'                                      => 'asa',
    'athapaskanųkalba'                        => 'ath',
    'atsamų'                                  => 'cch',
    'aukštojiŠveicarijosvokiečių'          => 'de_ch',
    'australųkalba'                           => 'aus',
    'austrijosvokiečių'                      => 'de_at',
    'austronezų'                              => 'map',
    'avadhi'                                   => 'awa',
    'avarikų'                                 => 'av',
    'avestų'                                  => 'ae',
    "azerik\."                                 => 'az',
    'ačinezų'                                => 'ace',
    'bafia'                                    => 'ksf',
    'balinezų'                                => 'ban',
    'baltarusių'                              => 'be',
    'baltųkalba'                              => 'bat',
    'baluči'                                  => 'bal',
    'bambarų'                                 => 'bm',
    'bamilekųkalba'                           => 'bai',
    'bandų'                                   => 'bad',
    'bantų'                                   => 'bnt',
    'baskų'                                   => 'eu',
    'basų'                                    => 'bas',
    'batakų'                                  => 'btk',
    'baučpuri'                                => 'bho',
    'baškirų'                                => 'ba',
    'bažnytinėslavų'                        => 'cu',
    'bembų'                                   => 'bem',
    'bena'                                     => 'bez',
    'bengalų'                                 => 'bn',
    'berberų'                                 => 'ber',
    'bidayuhkalba'                             => 'day',
    'biharų'                                  => 'bh',
    'bikolų'                                  => 'bik',
    'bini'                                     => 'bin',
    'birmiečių'                              => 'my',
    'bislama'                                  => 'bi',
    'blin'                                     => 'byn',
    'bodo'                                     => 'brx',
    'bosnių'                                  => 'bs',
    'brajų'                                   => 'bra',
    'bretonų'                                 => 'br',
    'buginezų'                                => 'bug',
    'bulgarų'                                 => 'bg',
    'buriatų'                                 => 'bua',
    'bėjų'                                   => 'bej',
    'cayuga'                                   => 'cay',
    'cebuanų'                                 => 'ceb',
    'centralmoroccotamazight'                  => 'tzm',
    'centrinėsamerikosindėnųkalba'          => 'cai',
    'chiga'                                    => 'cgg',
    'chuang'                                   => 'za',
    'colognian'                                => 'ksh',
    'comorian'                                 => 'swb',
    'congoswahili'                             => 'swc',
    'dakotų'                                  => 'dak',
    'danų'                                    => 'da',
    'dargva'                                   => 'dar',
    'delavero'                                 => 'del',
    'dinkų'                                   => 'din',
    'dirbtinėkalba'                           => 'art',
    'divehi'                                   => 'dv',
    'dogri'                                    => 'doi',
    'dogribų'                                 => 'dgr',
    'dravidųkalba'                            => 'dra',
    'dualų'                                   => 'dua',
    'dyulų'                                   => 'dyu',
    'efik'                                     => 'efi',
    'ekajuk'                                   => 'eka',
    'elamitų'                                 => 'elx',
    'embu'                                     => 'ebu',
    'enko'                                     => 'nqo',
    'erzyjų'                                  => 'myv',
    'esperanto'                                => 'eo',
    'estų'                                    => 'et',
    'eve'                                      => 'ee',
    'evondo'                                   => 'ewo',
    'fang'                                     => 'fan',
    'fanti'                                    => 'fat',
    'farerųkalba'                             => 'fo',
    'fidžio'                                  => 'fj',
    'filipinųkalba'                           => 'phi',
    'finikiečių'                             => 'phn',
    'finougrųkalba'                           => 'fiu',
    'flamandų'                                => 'nl_be',
    'fon'                                      => 'fon',
    'frulan'                                   => 'fur',
    'fulahų'                                  => 'ff',
    'ga'                                       => 'gaa',
    'gajo'                                     => 'gay',
    'galisų'                                  => 'gl',
    'ganda'                                    => 'lg',
    'gbaja'                                    => 'gba',
    'germanųkalba'                            => 'gem',
    'gondi'                                    => 'gon',
    'gorontalo'                                => 'gor',
    'gotų'                                    => 'got',
    'graikų'                                  => 'el',
    'grebo'                                    => 'grb',
    'gruzinų'                                 => 'ka',
    'gudžaratų'                              => 'gu',
    'gusii'                                    => 'guz',
    'gvaranių'                                => 'gn',
    'gvičino'                                 => 'gwi',
    'gyz'                                      => 'gez',
    'haido'                                    => 'hai',
    'haičio'                                  => 'ht',
    'hausų'                                   => 'ha',
    'havajų'                                  => 'haw',
    'hebrajų'                                 => 'he',
    'herero'                                   => 'hz',
    'hiligainon'                               => 'hil',
    'himačali'                                => 'him',
    'hindi'                                    => 'hi',
    'hirimotu'                                 => 'ho',
    'hititų'                                  => 'hit',
    'hmong'                                    => 'hmn',
    'hupa'                                     => 'hup',
    'iban'                                     => 'iba',
    'iberijosispanų'                          => 'es_es',
    'iberijosportugalų'                       => 'pt_pt',
    'ido'                                      => 'io',
    'igbo'                                     => 'ig',
    'ijo'                                      => 'ijo',
    'iloko'                                    => 'ilo',
    'inarisami'                                => 'smn',
    'indoeuropiečiųkalba'                    => 'ine',
    'indoneziečių'                           => 'id',
    'indųkalba'                               => 'inc',
    'ingušų'                                 => 'inh',
    'interkalba'                               => 'ie',
    'interlingva'                              => 'ia',
    'inukitut'                                 => 'iu',
    'inupiak'                                  => 'ik',
    'irakokalba'                               => 'iro',
    'iraniečiųkalba'                         => 'ira',
    'islandų'                                 => 'is',
    'ispanų'                                  => 'es',
    'italų'                                   => 'it',
    'jakutų'                                  => 'sah',
    'jao'                                      => 'yao',
    'japezų'                                  => 'yap',
    'japonų'                                  => 'ja',
    'javiečių'                               => 'jv',
    'jidiš'                                   => 'yi',
    'jolafonyi'                                => 'dyo',
    'joruba'                                   => 'yo',
    'ju'                                       => 'kaj',
    'judėjųarabų'                           => 'jrb',
    'judėjųpersų'                           => 'jpr',
    'jupikkalba'                               => 'ypk',
    'kabardinų'                               => 'kbd',
    'kabilo'                                   => 'kab',
    'kabuverdianu'                             => 'kea',
    'kado'                                     => 'cad',
    'kalalisut'                                => 'kl',
    'kalenjin'                                 => 'kln',
    'kalmukų'                                 => 'xal',
    'kamba'                                    => 'kam',
    'kanadosanglų'                            => 'en_ca',
    'kanadosprancūzų'                        => 'fr_ca',
    'kanadų'                                  => 'kn',
    'kankani'                                  => 'kok',
    'kanuri'                                   => 'kr',
    'karakalpakų'                             => 'kaa',
    'karačiajųbalkarijos'                    => 'krc',
    'karelų'                                  => 'krl',
    'karenų'                                  => 'kar',
    'karibų'                                  => 'car',
    'kasi'                                     => 'kha',
    'katalonų'                                => 'ca',
    'kaukaziečiųkalba'                       => 'cau',
    'kavi'                                     => 'kaw',
    'kazachų'                                 => 'kk',
    'kačin'                                   => 'kac',
    'kašmyro'                                 => 'ks',
    'kašubų'                                 => 'csb',
    'kelioskalbos'                             => 'mul',
    'keltųkalba'                              => 'cel',
    'kečujų'                                 => 'qu',
    'khmerų'                                  => 'km',
    'kikui'                                    => 'ki',
    'kimbundu'                                 => 'kmb',
    'kinjarvanda'                              => 'rw',
    'kinų'                                    => 'zh',
    'kinųkalboskantonotarmė'                 => 'yue',
    'kirgizų'                                 => 'ky',
    'kiribati'                                 => 'gil',
    'klasikinėnevari'                         => 'nwc',
    'klasikinėsiriečių'                     => 'syc',
    'koisankalba'                              => 'khi',
    'komi'                                     => 'kv',
    'kongo'                                    => 'kg',
    'koptų'                                   => 'cop',
    'kornų'                                   => 'kw',
    'koro'                                     => 'kfo',
    'korsikiečių'                            => 'co',
    'korėjiečių'                            => 'ko',
    'kosreanų'                                => 'kos',
    'kosų'                                    => 'xh',
    'kotanezų'                                => 'kho',
    'koyraborosenni'                           => 'ses',
    'koyrachiini'                              => 'khq',
    'kpele'                                    => 'kpe',
    'kreolųarbapidžinųkalba'                => 'crp',
    'kreolųarbapidžinųkalbapagalanglų'     => 'cpe',
    'kreolųarbapidžinųkalbapagalportugalų' => 'cpp',
    'kreolųarbapidžinųkalbapagalprancūzų' => 'cpf',
    'kroatų'                                  => 'hr',
    'krukalba'                                 => 'kro',
    'kry'                                      => 'cr',
    'krykų'                                   => 'mus',
    'krymoturkų'                              => 'crh',
    'kuaniama'                                 => 'kj',
    'kumik'                                    => 'kum',
    'kurdų'                                   => 'ku',
    'kuruk'                                    => 'kru',
    'kutenai'                                  => 'kut',
    'kušitikkalba'                            => 'cus',
    'kwasio'                                   => 'nmg',
    'ladino'                                   => 'lad',
    'lamba'                                    => 'lam',
    'landa'                                    => 'lah',
    'langi'                                    => 'lag',
    'laosiečių'                              => 'lo',
    'latvių'                                  => 'lv',
    'lenkų'                                   => 'pl',
    'lezginų'                                 => 'lez',
    'lietuvių'                                => 'lt',
    'limburgiš'                               => 'li',
    'lingala'                                  => 'ln',
    'liuksemburgiečių'                       => 'lb',
    'loiban'                                   => 'jbo',
    'lotynų'                                  => 'la',
    'lozi'                                     => 'loz',
    'lubakatanga'                              => 'lu',
    'lubalula'                                 => 'lua',
    'luiseno'                                  => 'lui',
    'lulesami'                                 => 'smj',
    'lunda'                                    => 'lun',
    'luo'                                      => 'luo',
    'luyia'                                    => 'luy',
    'lušai'                                   => 'lus',
    'machame'                                  => 'jmc',
    'madurezų'                                => 'mad',
    'magahi'                                   => 'mag',
    'maithili'                                 => 'mai',
    'majanų'                                  => 'myn',
    'makasaro'                                 => 'mak',
    'makedonų'                                => 'mk',
    'makhuwameetto'                            => 'mgh',
    'makonde'                                  => 'kde',
    'malagasijos'                              => 'mg',
    'malajalių'                               => 'ml',
    'malajiečių'                             => 'ms',
    'maltiečių'                              => 'mt',
    'mandar'                                   => 'mdr',
    'mandingo'                                 => 'man',
    'manipuri'                                 => 'mni',
    'manks'                                    => 'gv',
    'manobokalba'                              => 'mno',
    'manču'                                   => 'mnc',
    'maorių'                                  => 'mi',
    'maratų'                                  => 'mr',
    'mari'                                     => 'chm',
    'marvari'                                  => 'mwr',
    'maršalosalų'                            => 'mh',
    'masajų'                                  => 'mas',
    'mende'                                    => 'men',
    'meru'                                     => 'mer',
    'mikmak'                                   => 'mic',
    'minankabu'                                => 'min',
    'mirandezų'                               => 'mwl',
    'mohok'                                    => 'moh',
    'mokša'                                   => 'mdf',
    'moldavų'                                 => 'mo',
    'mongo'                                    => 'lol',
    'mongolų'                                 => 'mn',
    'monkhmerkalba'                            => 'mkh',
    'morisyen'                                 => 'mfe',
    'mosi'                                     => 'mos',
    'mundakalba'                               => 'mun',
    'mundang'                                  => 'mua',
    'nahuatlų'                                => 'nah',
    'nama'                                     => 'naq',
    'naujojinorvegų'                          => 'nn',
    'naurų'                                   => 'na',
    'navajų'                                  => 'nv',
    'ndongų'                                  => 'ng',
    'neapoliečių'                            => 'nap',
    'nepalų'                                  => 'ne',
    'nevari'                                   => 'new',
    'nežinomakalba'                           => 'und',
    'niamvezi'                                 => 'nym',
    'nianja'                                   => 'ny',
    'niankole'                                 => 'nyn',
    'nias'                                     => 'nia',
    'niasatongos'                              => 'tog',
    'nigeriokordofanųkalba'                   => 'nic',
    'nilosacharoskalba'                        => 'ssa',
    'nioro'                                    => 'nyo',
    'niuenų'                                  => 'niu',
    'nogų'                                    => 'nog',
    'norsu'                                    => 'non',
    'norvegijosbokmal'                         => 'nb',
    'norvegų'                                 => 'no',
    'nubijoskalba'                             => 'nub',
    'nuer'                                     => 'nus',
    'nzima'                                    => 'nzi',
    'nėrakalbinioturinio'                     => 'zxx',
    'ojibva'                                   => 'oj',
    'olandų'                                  => 'nl',
    'orijų'                                   => 'or',
    'oromo'                                    => 'om',
    'osage'                                    => 'osa',
    'osetinų'                                 => 'os',
    'osmanųturkų'                            => 'ota',
    'otomanųkalba'                            => 'oto',
    'pahlavi'                                  => 'pal',
    'palau'                                    => 'pau',
    'pali'                                     => 'pi',
    'pampanga'                                 => 'pam',
    'pandžabų'                               => 'pa',
    'pangasinan'                               => 'pag',
    'papiemento'                               => 'pap',
    'papuasųkalba'                            => 'paa',
    'persų'                                   => 'fa',
    'pietųaltajaus'                           => 'alt',
    'pietųamerikosindėnųkalba'              => 'sai',
    'pietųndebele'                            => 'nr',
    'pietųsami'                               => 'sma',
    'pietųsesuto'                             => 'st',
    'ponapean'                                 => 'pon',
    'portugalų'                               => 'pt',
    'portugalųbrazilijos'                     => 'pt_br',
    'prakritkalba'                             => 'pra',
    'prancūzų'                               => 'fr',
    'provansalų'                              => 'oc',
    "puštūnųk\."                            => 'ps',
    'radžastano'                              => 'raj',
    'raetoromanų'                             => 'rm',
    'rapanui'                                  => 'rap',
    'rarotongan'                               => 'rar',
    'romanųkalba'                             => 'roa',
    'rombo'                                    => 'rof',
    'romųkalba'                               => 'rom',
    'rumunų'                                  => 'ro',
    'rundi'                                    => 'rn',
    'rusų'                                    => 'ru',
    'rwa'                                      => 'rwk',
    'rytųfryzų'                              => 'frs',
    'saho'                                     => 'ssy',
    'sališankalba'                            => 'sal',
    'samarėjųaramių'                        => 'sam',
    'samburu'                                  => 'saq',
    'samitųkalba'                             => 'sem',
    'samiųkalba'                              => 'smi',
    'samoa'                                    => 'sm',
    'sandavi'                                  => 'sad',
    'sango'                                    => 'sg',
    'sangu'                                    => 'sbp',
    'sanskritas'                               => 'sa',
    'santali'                                  => 'sat',
    'sardiniečių'                            => 'sc',
    'sasak'                                    => 'sas',
    'selkup'                                   => 'sel',
    'sena'                                     => 'seh',
    'seneca'                                   => 'see',
    'senojiairių'                             => 'sga',
    'senojianglų'                             => 'ang',
    'senojiaukštosiosvokietijos'              => 'goh',
    'senojipersų'                             => 'peo',
    'senojiprancūzų'                         => 'fro',
    'senovėsegiptiečių'                     => 'egy',
    'senovėsgraikų'                          => 'grc',
    'senovėsprovansalų'                      => 'pro',
    'serbų'                                   => 'sr',
    'serbųkroatų'                            => 'sh',
    'sererų'                                  => 'srr',
    'shambala'                                 => 'ksb',
    'siciliečių'                             => 'scn',
    'sidamo'                                   => 'sid',
    'siksika'                                  => 'bla',
    'sindų'                                   => 'sd',
    'sinhalų'                                 => 'si',
    'sinotibetokalba'                          => 'sit',
    'siouankalba'                              => 'sio',
    'sirų'                                    => 'syr',
    'sičuanji'                                => 'ii',
    'skoltsami'                                => 'sms',
    'slave'                                    => 'den',
    'slavųkalba'                              => 'sla',
    'slovakų'                                 => 'sk',
    'slovėnų'                                => 'sl',
    'soga'                                     => 'xog',
    'sogdien'                                  => 'sog',
    'somalių'                                 => 'so',
    'songhai'                                  => 'son',
    'soninke'                                  => 'snk',
    'sorbųkalba'                              => 'wen',
    'sranantongo'                              => 'srn',
    'sukuma'                                   => 'suk',
    'sundų'                                   => 'su',
    'suomių'                                  => 'fi',
    'susu'                                     => 'sus',
    'svahili'                                  => 'sw',
    'svati'                                    => 'ss',
    'svazilando'                               => 'dz',
    'tachelhit'                                => 'shi',
    'tadžikų'                                => 'tg',
    'tagalogų'                                => 'tl',
    'tagalų'                                  => 'fil',
    'taita'                                    => 'dav',
    'taitiečių'                              => 'ty',
    'tajų'                                    => 'th',
    'tajųkalba'                               => 'tai',
    'tamašek'                                 => 'tmh',
    'tamilų'                                  => 'ta',
    'taroko'                                   => 'trv',
    'tasawaq'                                  => 'twq',
    'telugų'                                  => 'te',
    'tereno'                                   => 'ter',
    'teso'                                     => 'teo',
    'tetum'                                    => 'tet',
    'tibetiečių'                             => 'bo',
    'tigrajų'                                 => 'ti',
    'tigre'                                    => 'tig',
    'timne'                                    => 'tem',
    'tiv'                                      => 'tiv',
    'tlingit'                                  => 'tli',
    'tokelau'                                  => 'tkl',
    'tokpisin'                                 => 'tpi',
    'tonga'                                    => 'to',
    'totorių'                                 => 'tt',
    'tsimšian'                                => 'tsi',
    'tsonga'                                   => 'ts',
    'tsvana'                                   => 'tn',
    'tumbuka'                                  => 'tum',
    'tupikalba'                                => 'tup',
    'turkmėnų'                               => 'tk',
    'turkų'                                   => 'tr',
    'tuvalu'                                   => 'tvl',
    'tuvių'                                   => 'tyv',
    'tvi'                                      => 'tw',
    'tyap'                                     => 'kcg',
    'udmurtų'                                 => 'udm',
    'ugaritic'                                 => 'uga',
    'uigūrų'                                 => 'ug',
    'ukrainiečių'                            => 'uk',
    'umbundu'                                  => 'umb',
    'urdų'                                    => 'ur',
    'uzbekų'                                  => 'uz',
    'vai'                                      => 'vai',
    'vakarųfryzų'                            => 'fy',
    'vakašankalba'                            => 'wak',
    'valamo'                                   => 'wal',
    'valonų'                                  => 'wa',
    'valų'                                    => 'cy',
    'varai'                                    => 'war',
    'vašo'                                    => 'was',
    'venda'                                    => 've',
    'vengrų'                                  => 'hu',
    'vidurioairijos'                           => 'mga',
    'vidurioanglijos'                          => 'enm',
    'vidurioaukštosiosvokietijos'             => 'gmh',
    'vidurioprancūzijos'                      => 'frm',
    'viduriovokietijos'                        => 'dum',
    'vietnamiečių'                           => 'vi',
    'viršutinėsorbian'                       => 'hsb',
    'vokiečių'                               => 'de',
    'volapiuk'                                 => 'vo',
    'volof'                                    => 'wo',
    'votik'                                    => 'vot',
    'vunjo'                                    => 'vun',
    'walser'                                   => 'wae',
    'yangben'                                  => 'yav',
    'zande'                                    => 'znd',
    'zapotekų'                                => 'zap',
    'zarma'                                    => 'dje',
    'zaza'                                     => 'zza',
    'zenaga'                                   => 'zen',
    'zulų'                                    => 'zu',
    'zuni'                                     => 'zun',
    'čagatų'                                 => 'chg',
    'čajenų'                                 => 'chy',
    'čamikųkalba'                            => 'cmc',
    'čamorų'                                 => 'ch',
    'čekų'                                   => 'cs',
    'čerokių'                                => 'chr',
    'čečėnų'                               => 'ce',
    'čibča'                                  => 'chb',
    'činukžargonas'                          => 'chn',
    'čipvėjų'                               => 'chp',
    'čiuvašų'                               => 'cv',
    'čoktau'                                  => 'cho',
    'čukesų'                                 => 'chk',
    'įvairioskalbos'                          => 'mis',
    'Šiaurėsamerikosindėnųkalba'           => 'nai',
    'Šveicarijosprancūzų'                   => 'fr_ch',
    'Šveicarijosvokiečių'                   => 'gsw',
    'šan'                                     => 'shn',
    'šiauriniųfryzų'                        => 'frr',
    'šiauriniųsamių'                        => 'se',
    'šiaurėsndebelų'                        => 'nd',
    'šiaurėssothų'                          => 'nso',
    'škotų'                                  => 'sco',
    'škotųgėlų'                            => 'gd',
    'šona'                                    => 'sn',
    'šumerų'                                 => 'sux',
    'švedų'                                  => 'sv',
    'Žemutinėsserbijos'                      => 'dsb',
    'Žemutinėsvokietijos'                    => 'nds',
    'ženklųkalba'                            => 'sgn',
    '„bliss“simboliųkalba'                => 'zbl',
    '„žvaigždžiųkelionių“'            => 'tlh',
);

1;
