package Locales::DB::Language::fr_ca;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::fr_ca::VERSION = '0.09';

$Locales::DB::Language::fr_ca::cldr_version = '2.0';

%Locales::DB::Language::fr_ca::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => ' ',
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}\.\.\.",
            'initial' => "\.\.\.\{0\}",
            'medial'  => "\{0\}\.\.\.\{1\}"
        },
        'language' => "langue\ \:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ et\ \{1\}",
            'end'    => "\{0\}\ et\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "région\ \:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '”',
        'alternate_quotation_start' => '“',
        'quotation_end'             => '»',
        'quotation_start'           => '«'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ within\ 0\.\.2\ and\ n\ is\ not\ 2" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] >= 0 && $_[0] <= 2 ) && ( $_[0] != 2 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => "non\:n",
        'yesstr' => "oui\:o"
    },
);

%Locales::DB::Language::fr_ca::code_to_name = (
    'aa'    => 'afar',
    'ab'    => 'abkhaze',
    'ace'   => 'aceh',
    'ach'   => 'acoli',
    'ada'   => 'adangme',
    'ady'   => 'adyghéen',
    'ae'    => 'avestique',
    'af'    => 'afrikaans',
    'afa'   => "langue\ afro\-asiatique",
    'afh'   => 'afrihili',
    'agq'   => 'aghem',
    'ain'   => 'aïnou',
    'ak'    => 'akan',
    'akk'   => 'akkadien',
    'ale'   => 'aléoute',
    'alg'   => "langue\ algonquienne",
    'alt'   => "altaï\ du\ Sud",
    'am'    => 'amharique',
    'an'    => 'aragonais',
    'ang'   => "ancien\ anglais",
    'anp'   => 'angika',
    'apa'   => "langue\ apache",
    'ar'    => 'arabe',
    'arc'   => 'araméen',
    'arn'   => 'araukan',
    'arp'   => 'arapaho',
    'art'   => "langue\ artificielle",
    'arw'   => 'arawak',
    'as'    => 'assamais',
    'asa'   => "asou\ \(Tanzania\)",
    'ast'   => 'asturien',
    'ath'   => "langue\ athapascane",
    'aus'   => "langue\ australienne",
    'av'    => 'avar',
    'awa'   => 'awadhi',
    'ay'    => 'aymara',
    'az'    => 'azéri',
    'ba'    => 'bachkir',
    'bad'   => 'banda',
    'bai'   => "langue\ bamilékée",
    'bal'   => 'baloutchi',
    'ban'   => 'balinais',
    'bas'   => 'bassa',
    'bat'   => "langue\ balte",
    'be'    => 'biélorusse',
    'bej'   => 'bedja',
    'bem'   => 'bemba',
    'ber'   => 'berbère',
    'bez'   => "bena\ \(Tanzania\)",
    'bg'    => 'bulgare',
    'bh'    => 'bihari',
    'bho'   => 'bhojpuri',
    'bi'    => 'bichelamar',
    'bik'   => 'bikol',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengali',
    'bnt'   => 'bantou',
    'bo'    => 'tibétain',
    'br'    => 'breton',
    'bra'   => 'braj',
    'brx'   => 'bodo',
    'bs'    => 'bosniaque',
    'btk'   => 'batak',
    'bua'   => 'bouriate',
    'bug'   => 'bugi',
    'byn'   => 'blin',
    'ca'    => 'catalan',
    'cad'   => 'caddo',
    'cai'   => "langue\ amérindienne\ centrale",
    'car'   => 'caribe',
    'cau'   => "langue\ caucasienne",
    'cay'   => 'Cayuga',
    'cch'   => 'atsam',
    'ce'    => 'tchétchène',
    'ceb'   => 'cebuano',
    'cel'   => "langue\ celtique",
    'cgg'   => 'Chiga',
    'ch'    => 'chamorro',
    'chb'   => 'chibcha',
    'chg'   => 'tchaghataï',
    'chk'   => 'chuuk',
    'chm'   => 'mari',
    'chn'   => "jargon\ chinook",
    'cho'   => 'choctaw',
    'chp'   => 'chipewyan',
    'chr'   => 'cherokee',
    'chy'   => 'cheyenne',
    'cmc'   => "langue\ chame",
    'co'    => 'corse',
    'cop'   => 'copte',
    'cpe'   => "créole\ ou\ pidgin\ anglais",
    'cpf'   => "créole\ ou\ pidgin\ français",
    'cpp'   => "créole\ ou\ pidgin\ portugais",
    'cr'    => 'cree',
    'crh'   => "turc\ de\ Crimée",
    'crp'   => "créole\ ou\ pidgin",
    'cs'    => 'tchèque',
    'csb'   => 'kachoube',
    'cu'    => "slavon\ d’église",
    'cus'   => "langue\ couchitique",
    'cv'    => 'tchouvache',
    'cy'    => 'gallois',
    'da'    => 'danois',
    'dak'   => 'dakota',
    'dar'   => 'dargwa',
    'dav'   => 'Taita',
    'day'   => 'dayak',
    'de'    => 'allemand',
    'de_at' => "allemand\ autrichien",
    'de_ch' => "allemand\ suisse",
    'del'   => 'delaware',
    'den'   => 'slavey',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'dje'   => 'Zarma',
    'doi'   => 'dogri',
    'dra'   => "langue\ dravidienne",
    'dsb'   => "bas\-sorabe",
    'dua'   => 'douala',
    'dum'   => "moyen\ néerlandais",
    'dv'    => 'maldivien',
    'dyo'   => "jola\-foyi",
    'dyu'   => 'dioula',
    'dz'    => 'dzongkha',
    'ebu'   => 'embu',
    'ee'    => 'éwé',
    'efi'   => 'efik',
    'egy'   => "égyptien\ ancien",
    'eka'   => 'ekajuk',
    'el'    => 'grec',
    'elx'   => 'élamite',
    'en'    => 'anglais',
    'en_au' => "anglais\ australien",
    'en_ca' => "anglais\ canadien",
    'en_gb' => "anglais\ britannique",
    'en_us' => "anglais\ américain",
    'enm'   => "moyen\ anglais",
    'eo'    => 'espéranto',
    'es'    => 'espagnol',
    'es_es' => "espagnol\ ibérique",
    'et'    => 'estonien',
    'eu'    => 'basque',
    'ewo'   => 'éwondo',
    'fa'    => 'persan',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'peul',
    'fi'    => 'finnois',
    'fil'   => 'filipino',
    'fiu'   => "langue\ finno\-ougrienne",
    'fj'    => 'fidjien',
    'fo'    => 'féroïen',
    'fon'   => 'fon',
    'fr'    => 'français',
    'fr_ca' => "français\ canadien",
    'fr_ch' => "français\ suisse",
    'frm'   => "moyen\ français",
    'fro'   => "ancien\ français",
    'frr'   => "frison\ du\ Nord",
    'frs'   => "frison\ oriental",
    'fur'   => 'frioulan',
    'fy'    => 'frison',
    'ga'    => 'irlandais',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaya',
    'gd'    => "gaélique\ écossais",
    'gem'   => "langue\ germanique",
    'gez'   => 'guèze',
    'gil'   => 'gilbertais',
    'gl'    => 'galicien',
    'gmh'   => "moyen\ haut\-allemand",
    'gn'    => 'guarani',
    'goh'   => "ancien\ haut\ allemand",
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gotique',
    'grb'   => 'grebo',
    'grc'   => "grec\ ancien",
    'gsw'   => 'alémanique',
    'gu'    => 'goudjarâtî',
    'guz'   => 'Gusii',
    'gv'    => 'manx',
    'gwi'   => 'gwichʼin',
    'ha'    => 'haoussa',
    'hai'   => 'haida',
    'haw'   => 'hawaïen',
    'he'    => 'hébreu',
    'hi'    => 'hindi',
    'hil'   => 'hiligaynon',
    'him'   => 'himachali',
    'hit'   => 'hittite',
    'hmn'   => 'hmong',
    'ho'    => "hiri\ motu",
    'hr'    => 'croate',
    'hsb'   => "haut\-sorabe",
    'ht'    => 'haïtien',
    'hu'    => 'hongrois',
    'hup'   => 'hupa',
    'hy'    => 'arménien',
    'hz'    => 'héréro',
    'ia'    => 'interlingua',
    'iba'   => 'iban',
    'id'    => 'indonésien',
    'ie'    => 'interlingue',
    'ig'    => 'igbo',
    'ii'    => "yi\ de\ Sichuan",
    'ijo'   => 'ijo',
    'ik'    => 'inupiaq',
    'ilo'   => 'ilokano',
    'inc'   => "langue\ indo\-aryenne",
    'ine'   => "langue\ indo\-européenne",
    'inh'   => 'ingouche',
    'io'    => 'ido',
    'ira'   => "langue\ iranienne",
    'iro'   => "langue\ iroquoienne",
    'is'    => 'islandais',
    'it'    => 'italien',
    'iu'    => 'inuktitut',
    'ja'    => 'japonais',
    'jbo'   => 'lojban',
    'jmc'   => 'Machame',
    'jpr'   => "judéo\-persan",
    'jrb'   => "judéo\-arabe",
    'jv'    => 'javanais',
    'ka'    => 'géorgien',
    'kaa'   => 'karakalpak',
    'kab'   => 'kabyle',
    'kac'   => 'kachin',
    'kaj'   => 'jju',
    'kam'   => 'kamba',
    'kar'   => 'karen',
    'kaw'   => 'kawi',
    'kbd'   => 'kabardin',
    'kcg'   => 'tyap',
    'kde'   => 'Makonde',
    'kea'   => 'capverdien',
    'kfo'   => 'koro',
    'kg'    => 'kongo',
    'kha'   => 'khasi',
    'khi'   => "langue\ khoïsan",
    'kho'   => 'khotanais',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'kikuyu',
    'kj'    => 'kuanyama',
    'kk'    => 'kazakh',
    'kl'    => 'groenlandais',
    'kln'   => 'Kalenjin',
    'km'    => 'khmer',
    'kmb'   => 'kiMboundou',
    'kn'    => 'kannada',
    'ko'    => 'coréen',
    'kok'   => 'konkani',
    'kos'   => 'kusaien',
    'kpe'   => 'kpellé',
    'kr'    => 'kanouri',
    'krc'   => "karatchaï\ balkar",
    'krl'   => 'carélien',
    'kro'   => 'krou',
    'kru'   => 'kurukh',
    'ks'    => 'kâshmîrî',
    'ksb'   => 'Shambala',
    'ksf'   => 'bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'kurde',
    'kum'   => 'koumyk',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'cornique',
    'ky'    => 'kirghize',
    'la'    => 'latin',
    'lad'   => 'ladino',
    'lag'   => 'Langi',
    'lah'   => 'lahnda',
    'lam'   => 'lamba',
    'lb'    => 'luxembourgeois',
    'lez'   => 'lezghien',
    'lg'    => 'ganda',
    'li'    => 'limbourgeois',
    'ln'    => 'lingala',
    'lo'    => 'lao',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'lituanien',
    'lu'    => "luba\-katanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luiseno',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lushai',
    'luy'   => 'oloulouyia',
    'lv'    => 'letton',
    'mad'   => 'madurais',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'makassar',
    'man'   => 'mandingue',
    'map'   => "malayo\-polynésien",
    'mas'   => 'masai',
    'mdf'   => 'moksa',
    'mdr'   => 'mandar',
    'men'   => 'mendé',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'malgache',
    'mga'   => "moyen\ irlandais",
    'mgh'   => "makhuwa\-meetto",
    'mh'    => 'marshall',
    'mi'    => 'maori',
    'mic'   => 'micmac',
    'min'   => 'minangkabau',
    'mis'   => "langue\ diverse",
    'mk'    => 'macédonien',
    'mkh'   => "langue\ mon\-khmère",
    'ml'    => 'malayalam',
    'mn'    => 'mongol',
    'mnc'   => 'mandchou',
    'mni'   => 'manipuri',
    'mno'   => "langue\ manobo",
    'mo'    => 'moldave',
    'moh'   => 'mohawk',
    'mos'   => 'moré',
    'mr'    => 'marathe',
    'ms'    => 'malais',
    'mt'    => 'maltais',
    'mua'   => 'mundang',
    'mul'   => 'multilingue',
    'mun'   => "langue\ mounda",
    'mus'   => 'creek',
    'mwl'   => 'mirandais',
    'mwr'   => 'marwarî',
    'my'    => 'birman',
    'myn'   => "langue\ maya",
    'myv'   => 'erzya',
    'na'    => 'nauruan',
    'nah'   => 'nahuatl',
    'nai'   => "langue\ amérindienne\ du\ Nord",
    'nap'   => 'napolitain',
    'naq'   => 'Nama',
    'nb'    => "norvégien\ bokmål",
    'nd'    => "ndébélé\ du\ Nord",
    'nds'   => "bas\-allemand",
    'ne'    => 'népalais',
    'new'   => 'newari',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => "langue\ nigéro\-congolaise",
    'niu'   => 'niué',
    'nl'    => 'néerlandais',
    'nl_be' => "néerlandais\ belge",
    'nmg'   => 'kwasio',
    'nn'    => "norvégien\ nynorsk",
    'no'    => 'norvégien',
    'nog'   => 'nogaï',
    'non'   => "vieux\ norrois",
    'nqo'   => 'n’ko',
    'nr'    => "ndébélé\ du\ Sud",
    'nso'   => "sotho\ du\ Nord",
    'nub'   => "langue\ nubienne",
    'nus'   => 'nuer',
    'nv'    => 'navaho',
    'nwc'   => "newarî\ classique",
    'ny'    => 'nyanja',
    'nym'   => 'nyamwezi',
    'nyn'   => 'nyankolé',
    'nyo'   => 'nyoro',
    'nzi'   => 'nzema',
    'oc'    => 'occitan',
    'oj'    => 'ojibwa',
    'om'    => 'oromo',
    'or'    => 'oriya',
    'os'    => 'ossète',
    'osa'   => 'osage',
    'ota'   => "turc\ ottoman",
    'oto'   => "langue\ otomangue",
    'pa'    => 'pendjabi',
    'paa'   => "langue\ papoue",
    'pag'   => 'pangasinan',
    'pal'   => 'pahlavi',
    'pam'   => 'pampangan',
    'pap'   => 'papiamento',
    'pau'   => 'palau',
    'peo'   => "persan\ ancien",
    'phi'   => "langue\ philippine",
    'phn'   => 'phénicien',
    'pi'    => 'pali',
    'pl'    => 'polonais',
    'pon'   => 'pohnpei',
    'pra'   => "langues\ prâkrit",
    'pro'   => "provençal\ ancien",
    'ps'    => 'ps',
    'pt'    => 'portugais',
    'pt_br' => "portugais\ brésilien",
    'pt_pt' => "portugais\ ibérique",
    'qu'    => "langue\ quechua",
    'raj'   => 'rajasthani',
    'rap'   => 'rapanui',
    'rar'   => 'rarotongien',
    'rm'    => "rhéto\-roman",
    'rn'    => 'roundi',
    'ro'    => 'roumain',
    'roa'   => "langue\ romane",
    'rof'   => 'rombo',
    'rom'   => 'tzigane',
    'ru'    => 'russe',
    'rup'   => 'valaque',
    'rw'    => 'rwanda',
    'rwk'   => 'rwa',
    'sa'    => 'sanskrit',
    'sad'   => 'sandawe',
    'sah'   => 'iakoute',
    'sai'   => "langue\ amérindienne\ du\ Sud",
    'sal'   => "langue\ salishenne",
    'sam'   => "araméen\ samaritain",
    'saq'   => 'Samburu',
    'sas'   => 'sasak',
    'sat'   => 'santal',
    'sbp'   => 'sangu',
    'sc'    => 'sarde',
    'scn'   => 'sicilien',
    'sco'   => 'écossais',
    'sd'    => 'sindhî',
    'se'    => "sami\ du\ Nord",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'selkoupe',
    'sem'   => "langue\ sémitique",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'sangho',
    'sga'   => "ancien\ irlandais",
    'sgn'   => "langue\ des\ signes",
    'sh'    => "serbo\-croate",
    'shi'   => 'Tachelhit',
    'shn'   => 'shan',
    'si'    => 'singhalais',
    'sid'   => 'sidamo',
    'sio'   => "langue\ sioux",
    'sit'   => "langue\ sino\-tibétaine",
    'sk'    => 'slovaque',
    'sl'    => 'slovène',
    'sla'   => "langue\ slave",
    'sm'    => 'samoan',
    'sma'   => "sami\ du\ Sud",
    'smi'   => "langue\ samie",
    'smj'   => "sami\ de\ Lule",
    'smn'   => "sami\ d’Inari",
    'sms'   => "sami\ skolt",
    'sn'    => 'shona',
    'snk'   => 'soninké',
    'so'    => 'somali',
    'sog'   => 'sogdien',
    'son'   => 'songhai',
    'sq'    => 'albanais',
    'sr'    => 'serbe',
    'srn'   => "sranan\ tongo",
    'srr'   => 'sérère',
    'ss'    => 'swati',
    'ssa'   => "langue\ nilo\-saharienne",
    'ssy'   => 'Saho',
    'st'    => 'sesotho',
    'su'    => 'soundanais',
    'suk'   => 'sukuma',
    'sus'   => 'soussou',
    'sux'   => 'sumérien',
    'sv'    => 'suédois',
    'sw'    => 'swahili',
    'swb'   => 'comorien',
    'swc'   => "Congo\ Swahili",
    'syc'   => "syriaque\ classique",
    'syr'   => 'syriaque',
    'ta'    => 'tamoul',
    'tai'   => "langue\ taï",
    'te'    => 'télougou',
    'tem'   => 'temne',
    'teo'   => 'Teso',
    'ter'   => 'tereno',
    'tet'   => 'tetum',
    'tg'    => 'tadjik',
    'th'    => 'thaï',
    'ti'    => 'tigrigna',
    'tig'   => 'tigré',
    'tiv'   => 'tiv',
    'tk'    => 'turkmène',
    'tkl'   => 'tokelau',
    'tl'    => 'tagalog',
    'tlh'   => 'klingon',
    'tli'   => 'tlingit',
    'tmh'   => 'tamacheq',
    'tn'    => 'tswana',
    'to'    => 'tongan',
    'tog'   => "tonga\ nyasa",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turc',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimshian',
    'tt'    => 'tatar',
    'tum'   => 'tumbuka',
    'tup'   => "langue\ tupi",
    'tut'   => "langue\ altaïque",
    'tvl'   => 'tuvalu',
    'tw'    => 'twi',
    'twq'   => 'tasawaq',
    'ty'    => 'tahitien',
    'tyv'   => 'touva',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'oudmourte',
    'ug'    => 'ouïghour',
    'uga'   => 'ougaritique',
    'uk'    => 'ukrainien',
    'umb'   => 'umbundu',
    'und'   => 'indéterminé',
    'ur'    => 'ourdou',
    'uz'    => 'ouzbek',
    'vai'   => 'vaï',
    've'    => 'venda',
    'vi'    => 'vietnamien',
    'vo'    => 'volapuk',
    'vot'   => 'vote',
    'vun'   => 'Vunjo',
    'wa'    => 'wallon',
    'wae'   => 'Walser',
    'wak'   => "langues\ wakashennes",
    'wal'   => 'walamo',
    'war'   => 'waray',
    'was'   => 'washo',
    'wen'   => "langue\ sorabe",
    'wo'    => 'wolof',
    'xal'   => 'kalmouk',
    'xh'    => 'xhosa',
    'xog'   => 'Soga',
    'yao'   => 'yao',
    'yap'   => 'yapois',
    'yav'   => 'yangben',
    'yi'    => 'yiddish',
    'yo'    => 'yoruba',
    'ypk'   => "langues\ yupik",
    'yue'   => 'cantonais',
    'za'    => 'zhuang',
    'zap'   => 'zapotèque',
    'zbl'   => "symboles\ Bliss",
    'zen'   => 'zenaga',
    'zh'    => 'chinois',
    'znd'   => 'zandé',
    'zu'    => 'zoulou',
    'zun'   => 'zuni',
    'zxx'   => "sans\ contenu\ linguistique",
    'zza'   => 'zazaki',
);

%Locales::DB::Language::fr_ca::name_to_code = (
    'abkhaze'                     => 'ab',
    'aceh'                        => 'ace',
    'acoli'                       => 'ach',
    'adangme'                     => 'ada',
    'adyghéen'                   => 'ady',
    'afar'                        => 'aa',
    'afrihili'                    => 'afh',
    'afrikaans'                   => 'af',
    'aghem'                       => 'agq',
    'akan'                        => 'ak',
    'akkadien'                    => 'akk',
    'albanais'                    => 'sq',
    'allemand'                    => 'de',
    'allemandautrichien'          => 'de_at',
    'allemandsuisse'              => 'de_ch',
    'altaïdusud'                 => 'alt',
    'alémanique'                 => 'gsw',
    'aléoute'                    => 'ale',
    'amharique'                   => 'am',
    'ancienanglais'               => 'ang',
    'ancienfrançais'             => 'fro',
    'ancienhautallemand'          => 'goh',
    'ancienirlandais'             => 'sga',
    'angika'                      => 'anp',
    'anglais'                     => 'en',
    'anglaisaméricain'           => 'en_us',
    'anglaisaustralien'           => 'en_au',
    'anglaisbritannique'          => 'en_gb',
    'anglaiscanadien'             => 'en_ca',
    'arabe'                       => 'ar',
    'aragonais'                   => 'an',
    'araméen'                    => 'arc',
    'araméensamaritain'          => 'sam',
    'arapaho'                     => 'arp',
    'araukan'                     => 'arn',
    'arawak'                      => 'arw',
    'arménien'                   => 'hy',
    'asoutanzania'                => 'asa',
    'assamais'                    => 'as',
    'asturien'                    => 'ast',
    'atsam'                       => 'cch',
    'avar'                        => 'av',
    'avestique'                   => 'ae',
    'awadhi'                      => 'awa',
    'aymara'                      => 'ay',
    'azéri'                      => 'az',
    'aïnou'                      => 'ain',
    'bachkir'                     => 'ba',
    'bafia'                       => 'ksf',
    'balinais'                    => 'ban',
    'baloutchi'                   => 'bal',
    'bambara'                     => 'bm',
    'banda'                       => 'bad',
    'bantou'                      => 'bnt',
    'basallemand'                 => 'nds',
    'basque'                      => 'eu',
    'bassa'                       => 'bas',
    'bassorabe'                   => 'dsb',
    'batak'                       => 'btk',
    'bedja'                       => 'bej',
    'bemba'                       => 'bem',
    'benatanzania'                => 'bez',
    'bengali'                     => 'bn',
    'berbère'                    => 'ber',
    'bhojpuri'                    => 'bho',
    'bichelamar'                  => 'bi',
    'bihari'                      => 'bh',
    'bikol'                       => 'bik',
    'bini'                        => 'bin',
    'birman'                      => 'my',
    'biélorusse'                 => 'be',
    'blin'                        => 'byn',
    'bodo'                        => 'brx',
    'bosniaque'                   => 'bs',
    'bouriate'                    => 'bua',
    'braj'                        => 'bra',
    'breton'                      => 'br',
    'bugi'                        => 'bug',
    'bulgare'                     => 'bg',
    'caddo'                       => 'cad',
    'cantonais'                   => 'yue',
    'capverdien'                  => 'kea',
    'caribe'                      => 'car',
    'carélien'                   => 'krl',
    'catalan'                     => 'ca',
    'cayuga'                      => 'cay',
    'cebuano'                     => 'ceb',
    'centralmoroccotamazight'     => 'tzm',
    'chamorro'                    => 'ch',
    'cherokee'                    => 'chr',
    'cheyenne'                    => 'chy',
    'chibcha'                     => 'chb',
    'chiga'                       => 'cgg',
    'chinois'                     => 'zh',
    'chipewyan'                   => 'chp',
    'choctaw'                     => 'cho',
    'chuuk'                       => 'chk',
    'colognian'                   => 'ksh',
    'comorien'                    => 'swb',
    'congoswahili'                => 'swc',
    'copte'                       => 'cop',
    'cornique'                    => 'kw',
    'corse'                       => 'co',
    'coréen'                     => 'ko',
    'cree'                        => 'cr',
    'creek'                       => 'mus',
    'croate'                      => 'hr',
    'créoleoupidgin'             => 'crp',
    'créoleoupidginanglais'      => 'cpe',
    'créoleoupidginfrançais'    => 'cpf',
    'créoleoupidginportugais'    => 'cpp',
    'dakota'                      => 'dak',
    'danois'                      => 'da',
    'dargwa'                      => 'dar',
    'dayak'                       => 'day',
    'delaware'                    => 'del',
    'dinka'                       => 'din',
    'dioula'                      => 'dyu',
    'dogri'                       => 'doi',
    'dogrib'                      => 'dgr',
    'douala'                      => 'dua',
    'dzongkha'                    => 'dz',
    'efik'                        => 'efi',
    'ekajuk'                      => 'eka',
    'embu'                        => 'ebu',
    'erzya'                       => 'myv',
    'espagnol'                    => 'es',
    'espagnolibérique'           => 'es_es',
    'espéranto'                  => 'eo',
    'estonien'                    => 'et',
    'fang'                        => 'fan',
    'fanti'                       => 'fat',
    'fidjien'                     => 'fj',
    'filipino'                    => 'fil',
    'finnois'                     => 'fi',
    'fon'                         => 'fon',
    'français'                   => 'fr',
    'françaiscanadien'           => 'fr_ca',
    'françaissuisse'             => 'fr_ch',
    'frioulan'                    => 'fur',
    'frison'                      => 'fy',
    'frisondunord'                => 'frr',
    'frisonoriental'              => 'frs',
    'féroïen'                   => 'fo',
    'ga'                          => 'gaa',
    'galicien'                    => 'gl',
    'gallois'                     => 'cy',
    'ganda'                       => 'lg',
    'gayo'                        => 'gay',
    'gaéliqueécossais'          => 'gd',
    'gbaya'                       => 'gba',
    'gilbertais'                  => 'gil',
    'gondi'                       => 'gon',
    'gorontalo'                   => 'gor',
    'gotique'                     => 'got',
    'goudjarâtî'                => 'gu',
    'grebo'                       => 'grb',
    'grec'                        => 'el',
    'grecancien'                  => 'grc',
    'groenlandais'                => 'kl',
    'guarani'                     => 'gn',
    'gusii'                       => 'guz',
    'guèze'                      => 'gez',
    'gwichʼin'                   => 'gwi',
    'géorgien'                   => 'ka',
    'haida'                       => 'hai',
    'haoussa'                     => 'ha',
    'hautsorabe'                  => 'hsb',
    'hawaïen'                    => 'haw',
    'haïtien'                    => 'ht',
    'hiligaynon'                  => 'hil',
    'himachali'                   => 'him',
    'hindi'                       => 'hi',
    'hirimotu'                    => 'ho',
    'hittite'                     => 'hit',
    'hmong'                       => 'hmn',
    'hongrois'                    => 'hu',
    'hupa'                        => 'hup',
    'hébreu'                     => 'he',
    'héréro'                    => 'hz',
    'iakoute'                     => 'sah',
    'iban'                        => 'iba',
    'ido'                         => 'io',
    'igbo'                        => 'ig',
    'ijo'                         => 'ijo',
    'ilokano'                     => 'ilo',
    'indonésien'                 => 'id',
    'indéterminé'               => 'und',
    'ingouche'                    => 'inh',
    'interlingua'                 => 'ia',
    'interlingue'                 => 'ie',
    'inuktitut'                   => 'iu',
    'inupiaq'                     => 'ik',
    'irlandais'                   => 'ga',
    'islandais'                   => 'is',
    'italien'                     => 'it',
    'japonais'                    => 'ja',
    'jargonchinook'               => 'chn',
    'javanais'                    => 'jv',
    'jju'                         => 'kaj',
    'jolafoyi'                    => 'dyo',
    'judéoarabe'                 => 'jrb',
    'judéopersan'                => 'jpr',
    'kabardin'                    => 'kbd',
    'kabyle'                      => 'kab',
    'kachin'                      => 'kac',
    'kachoube'                    => 'csb',
    'kalenjin'                    => 'kln',
    'kalmouk'                     => 'xal',
    'kamba'                       => 'kam',
    'kannada'                     => 'kn',
    'kanouri'                     => 'kr',
    'karakalpak'                  => 'kaa',
    'karatchaïbalkar'            => 'krc',
    'karen'                       => 'kar',
    'kawi'                        => 'kaw',
    'kazakh'                      => 'kk',
    'khasi'                       => 'kha',
    'khmer'                       => 'km',
    'khotanais'                   => 'kho',
    'kikuyu'                      => 'ki',
    'kimboundou'                  => 'kmb',
    'kirghize'                    => 'ky',
    'klingon'                     => 'tlh',
    'komi'                        => 'kv',
    'kongo'                       => 'kg',
    'konkani'                     => 'kok',
    'koro'                        => 'kfo',
    'koumyk'                      => 'kum',
    'koyraborosenni'              => 'ses',
    'koyrachiini'                 => 'khq',
    'kpellé'                     => 'kpe',
    'krou'                        => 'kro',
    'kuanyama'                    => 'kj',
    'kurde'                       => 'ku',
    'kurukh'                      => 'kru',
    'kusaien'                     => 'kos',
    'kutenai'                     => 'kut',
    'kwasio'                      => 'nmg',
    'kâshmîrî'                 => 'ks',
    'ladino'                      => 'lad',
    'lahnda'                      => 'lah',
    'lamba'                       => 'lam',
    'langi'                       => 'lag',
    'langueafroasiatique'         => 'afa',
    'languealgonquienne'          => 'alg',
    'languealtaïque'             => 'tut',
    'langueamérindiennecentrale' => 'cai',
    'langueamérindiennedunord'   => 'nai',
    'langueamérindiennedusud'    => 'sai',
    'langueapache'                => 'apa',
    'langueartificielle'          => 'art',
    'langueathapascane'           => 'ath',
    'langueaustralienne'          => 'aus',
    'languebalte'                 => 'bat',
    'languebamilékée'           => 'bai',
    'languecaucasienne'           => 'cau',
    'langueceltique'              => 'cel',
    'languechame'                 => 'cmc',
    'languecouchitique'           => 'cus',
    'languedessignes'             => 'sgn',
    'languediverse'               => 'mis',
    'languedravidienne'           => 'dra',
    'languefinnoougrienne'        => 'fiu',
    'languegermanique'            => 'gem',
    'langueindoaryenne'           => 'inc',
    'langueindoeuropéenne'       => 'ine',
    'langueiranienne'             => 'ira',
    'langueiroquoienne'           => 'iro',
    'languekhoïsan'              => 'khi',
    'languemanobo'                => 'mno',
    'languemaya'                  => 'myn',
    'languemonkhmère'            => 'mkh',
    'languemounda'                => 'mun',
    'languenigérocongolaise'     => 'nic',
    'languenilosaharienne'        => 'ssa',
    'languenubienne'              => 'nub',
    'langueotomangue'             => 'oto',
    'languepapoue'                => 'paa',
    'languephilippine'            => 'phi',
    'languequechua'               => 'qu',
    'langueromane'                => 'roa',
    'languesalishenne'            => 'sal',
    'languesamie'                 => 'smi',
    'languesinotibétaine'        => 'sit',
    'languesioux'                 => 'sio',
    'langueslave'                 => 'sla',
    'languesorabe'                => 'wen',
    'languesprâkrit'             => 'pra',
    'langueswakashennes'          => 'wak',
    'languesyupik'                => 'ypk',
    'languesémitique'            => 'sem',
    'languetaï'                  => 'tai',
    'languetupi'                  => 'tup',
    'lao'                         => 'lo',
    'latin'                       => 'la',
    'letton'                      => 'lv',
    'lezghien'                    => 'lez',
    'limbourgeois'                => 'li',
    'lingala'                     => 'ln',
    'lituanien'                   => 'lt',
    'lojban'                      => 'jbo',
    'lozi'                        => 'loz',
    'lubakatanga'                 => 'lu',
    'lubalulua'                   => 'lua',
    'luiseno'                     => 'lui',
    'lunda'                       => 'lun',
    'luo'                         => 'luo',
    'lushai'                      => 'lus',
    'luxembourgeois'              => 'lb',
    'machame'                     => 'jmc',
    'macédonien'                 => 'mk',
    'madurais'                    => 'mad',
    'magahi'                      => 'mag',
    'maithili'                    => 'mai',
    'makassar'                    => 'mak',
    'makhuwameetto'               => 'mgh',
    'makonde'                     => 'kde',
    'malais'                      => 'ms',
    'malayalam'                   => 'ml',
    'malayopolynésien'           => 'map',
    'maldivien'                   => 'dv',
    'malgache'                    => 'mg',
    'maltais'                     => 'mt',
    'mandar'                      => 'mdr',
    'mandchou'                    => 'mnc',
    'mandingue'                   => 'man',
    'manipuri'                    => 'mni',
    'manx'                        => 'gv',
    'maori'                       => 'mi',
    'marathe'                     => 'mr',
    'mari'                        => 'chm',
    'marshall'                    => 'mh',
    'marwarî'                    => 'mwr',
    'masai'                       => 'mas',
    'mendé'                      => 'men',
    'meru'                        => 'mer',
    'micmac'                      => 'mic',
    'minangkabau'                 => 'min',
    'mirandais'                   => 'mwl',
    'mohawk'                      => 'moh',
    'moksa'                       => 'mdf',
    'moldave'                     => 'mo',
    'mongo'                       => 'lol',
    'mongol'                      => 'mn',
    'morisyen'                    => 'mfe',
    'moré'                       => 'mos',
    'moyenanglais'                => 'enm',
    'moyenfrançais'              => 'frm',
    'moyenhautallemand'           => 'gmh',
    'moyenirlandais'              => 'mga',
    'moyennéerlandais'           => 'dum',
    'multilingue'                 => 'mul',
    'mundang'                     => 'mua',
    'nahuatl'                     => 'nah',
    'nama'                        => 'naq',
    'napolitain'                  => 'nap',
    'nauruan'                     => 'na',
    'navaho'                      => 'nv',
    'ndonga'                      => 'ng',
    'ndébélédunord'            => 'nd',
    'ndébélédusud'             => 'nr',
    'newari'                      => 'new',
    'newarîclassique'            => 'nwc',
    'nias'                        => 'nia',
    'niué'                       => 'niu',
    'nogaï'                      => 'nog',
    'norvégien'                  => 'no',
    'norvégienbokmål'           => 'nb',
    'norvégiennynorsk'           => 'nn',
    'nuer'                        => 'nus',
    'nyamwezi'                    => 'nym',
    'nyanja'                      => 'ny',
    'nyankolé'                   => 'nyn',
    'nyoro'                       => 'nyo',
    'nzema'                       => 'nzi',
    'néerlandais'                => 'nl',
    'néerlandaisbelge'           => 'nl_be',
    'népalais'                   => 'ne',
    'n’ko'                      => 'nqo',
    'occitan'                     => 'oc',
    'ojibwa'                      => 'oj',
    'oloulouyia'                  => 'luy',
    'oriya'                       => 'or',
    'oromo'                       => 'om',
    'osage'                       => 'osa',
    'ossète'                     => 'os',
    'oudmourte'                   => 'udm',
    'ougaritique'                 => 'uga',
    'ourdou'                      => 'ur',
    'ouzbek'                      => 'uz',
    'ouïghour'                   => 'ug',
    'pahlavi'                     => 'pal',
    'palau'                       => 'pau',
    'pali'                        => 'pi',
    'pampangan'                   => 'pam',
    'pangasinan'                  => 'pag',
    'papiamento'                  => 'pap',
    'pendjabi'                    => 'pa',
    'persan'                      => 'fa',
    'persanancien'                => 'peo',
    'peul'                        => 'ff',
    'phénicien'                  => 'phn',
    'pohnpei'                     => 'pon',
    'polonais'                    => 'pl',
    'portugais'                   => 'pt',
    'portugaisbrésilien'         => 'pt_br',
    'portugaisibérique'          => 'pt_pt',
    'provençalancien'            => 'pro',
    'ps'                          => 'ps',
    'rajasthani'                  => 'raj',
    'rapanui'                     => 'rap',
    'rarotongien'                 => 'rar',
    'rhétoroman'                 => 'rm',
    'rombo'                       => 'rof',
    'roumain'                     => 'ro',
    'roundi'                      => 'rn',
    'russe'                       => 'ru',
    'rwa'                         => 'rwk',
    'rwanda'                      => 'rw',
    'saho'                        => 'ssy',
    'samburu'                     => 'saq',
    'samidelule'                  => 'smj',
    'samidunord'                  => 'se',
    'samidusud'                   => 'sma',
    'samid’inari'               => 'smn',
    'samiskolt'                   => 'sms',
    'samoan'                      => 'sm',
    'sandawe'                     => 'sad',
    'sangho'                      => 'sg',
    'sangu'                       => 'sbp',
    'sanscontenulinguistique'     => 'zxx',
    'sanskrit'                    => 'sa',
    'santal'                      => 'sat',
    'sarde'                       => 'sc',
    'sasak'                       => 'sas',
    'selkoupe'                    => 'sel',
    'sena'                        => 'seh',
    'seneca'                      => 'see',
    'serbe'                       => 'sr',
    'serbocroate'                 => 'sh',
    'sesotho'                     => 'st',
    'shambala'                    => 'ksb',
    'shan'                        => 'shn',
    'shona'                       => 'sn',
    'sicilien'                    => 'scn',
    'sidamo'                      => 'sid',
    'siksika'                     => 'bla',
    'sindhî'                     => 'sd',
    'singhalais'                  => 'si',
    'slavey'                      => 'den',
    'slavond’église'           => 'cu',
    'slovaque'                    => 'sk',
    'slovène'                    => 'sl',
    'soga'                        => 'xog',
    'sogdien'                     => 'sog',
    'somali'                      => 'so',
    'songhai'                     => 'son',
    'soninké'                    => 'snk',
    'sothodunord'                 => 'nso',
    'soundanais'                  => 'su',
    'soussou'                     => 'sus',
    'sranantongo'                 => 'srn',
    'sukuma'                      => 'suk',
    'sumérien'                   => 'sux',
    'suédois'                    => 'sv',
    'swahili'                     => 'sw',
    'swati'                       => 'ss',
    'symbolesbliss'               => 'zbl',
    'syriaque'                    => 'syr',
    'syriaqueclassique'           => 'syc',
    'sérère'                    => 'srr',
    'tachelhit'                   => 'shi',
    'tadjik'                      => 'tg',
    'tagalog'                     => 'tl',
    'tahitien'                    => 'ty',
    'taita'                       => 'dav',
    'tamacheq'                    => 'tmh',
    'tamoul'                      => 'ta',
    'taroko'                      => 'trv',
    'tasawaq'                     => 'twq',
    'tatar'                       => 'tt',
    'tchaghataï'                 => 'chg',
    'tchouvache'                  => 'cv',
    'tchèque'                    => 'cs',
    'tchétchène'                => 'ce',
    'temne'                       => 'tem',
    'tereno'                      => 'ter',
    'teso'                        => 'teo',
    'tetum'                       => 'tet',
    'thaï'                       => 'th',
    'tibétain'                   => 'bo',
    'tigrigna'                    => 'ti',
    'tigré'                      => 'tig',
    'tiv'                         => 'tiv',
    'tlingit'                     => 'tli',
    'tokelau'                     => 'tkl',
    'tokpisin'                    => 'tpi',
    'tongan'                      => 'to',
    'tonganyasa'                  => 'tog',
    'touva'                       => 'tyv',
    'tsimshian'                   => 'tsi',
    'tsonga'                      => 'ts',
    'tswana'                      => 'tn',
    'tumbuka'                     => 'tum',
    'turc'                        => 'tr',
    'turcdecrimée'               => 'crh',
    'turcottoman'                 => 'ota',
    'turkmène'                   => 'tk',
    'tuvalu'                      => 'tvl',
    'twi'                         => 'tw',
    'tyap'                        => 'kcg',
    'tzigane'                     => 'rom',
    'télougou'                   => 'te',
    'ukrainien'                   => 'uk',
    'umbundu'                     => 'umb',
    'valaque'                     => 'rup',
    'vaï'                        => 'vai',
    'venda'                       => 've',
    'vietnamien'                  => 'vi',
    'vieuxnorrois'                => 'non',
    'volapuk'                     => 'vo',
    'vote'                        => 'vot',
    'vunjo'                       => 'vun',
    'walamo'                      => 'wal',
    'wallon'                      => 'wa',
    'walser'                      => 'wae',
    'waray'                       => 'war',
    'washo'                       => 'was',
    'wolof'                       => 'wo',
    'xhosa'                       => 'xh',
    'yangben'                     => 'yav',
    'yao'                         => 'yao',
    'yapois'                      => 'yap',
    'yiddish'                     => 'yi',
    'yidesichuan'                 => 'ii',
    'yoruba'                      => 'yo',
    'zandé'                      => 'znd',
    'zapotèque'                  => 'zap',
    'zarma'                       => 'dje',
    'zazaki'                      => 'zza',
    'zenaga'                      => 'zen',
    'zhuang'                      => 'za',
    'zoulou'                      => 'zu',
    'zuni'                        => 'zun',
    'écossais'                   => 'sco',
    'égyptienancien'             => 'egy',
    'élamite'                    => 'elx',
    'éwondo'                     => 'ewo',
    'éwé'                       => 'ee',
);

1;
