package Locales::DB::Language::am;

# Auto generated from CLDR

$Locales::DB::Language::am::VERSION = '0.08';

$Locales::DB::Language::am::cldr_version = '2.0';

%Locales::DB::Language::am::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Language\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ እና\ \{1\}",
            'end'    => "\{0\}\,\ እና\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '›',
        'alternate_quotation_start' => '‹',
        'quotation_end'             => '»',
        'quotation_start'           => '«'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ in\ 0\.\.1" },
        'category_rules_compiled' => { 'one' => "sub\ \{\ return\ \'one\'\ if\ \(\ \(\(\ int\(\$_\[0\]\)\ \=\=\ \$_\[0\]\ \&\&\ \$_\[0\]\ \>\=\ 0\ \&\&\ \$_\[0\]\ \<\=\ 1\ \)\)\)\;\ return\;\}\;" }
    },
    'posix' => {
        'nostr'  => "አይ\:ይ",
        'yesstr' => "አዎን\:ዎ"
    },
);

%Locales::DB::Language::am::code_to_name = (
    'aa'    => 'አፋርኛ',
    'ab'    => 'አብሐዚኛ',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'አፍሪካንስ',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'Ainu',
    'ak'    => 'አካንኛ',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'አማርኛ',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'ዐርቢኛ',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'አሳሜዛዊ',
    'asa'   => 'Asu',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'አያማርኛ',
    'az'    => 'አዜሪ',
    'ba'    => 'ባስኪርኛ',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basaa',
    'bat'   => "Baltic\ Language",
    'be'    => 'ቤላራሻኛ',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bez'   => 'Bena',
    'bg'    => 'ቡልጋሪኛ',
    'bh'    => 'ቢሃሪ',
    'bho'   => 'Bhojpuri',
    'bi'    => 'ቢስላምኛ',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'በንጋሊኛ',
    'bnt'   => 'Bantu',
    'bo'    => 'ትበትንኛ',
    'br'    => 'ብሬቶንኛ',
    'bra'   => 'Braj',
    'brx'   => 'Bodo',
    'bs'    => 'ቦዝኒያንኛ',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'ብሊን',
    'ca'    => 'ካታላንኛ',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'cgg'   => 'Chiga',
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'ኮርሲካኛ',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'ቼክኛ',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'ወልሽ',
    'da'    => 'ዴኒሽ',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'dav'   => 'Taita',
    'day'   => 'Dayak',
    'de'    => 'ጀርመን',
    'de_at' => "የኦስትሪያ\ ጀርመን",
    'de_ch' => "የስዊዝ\ ከፍተኛ\ ጀርመንኛ",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'Zarma',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'ዲቬህ',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Dyula',
    'dz'    => 'ድዞንግኻኛ',
    'ebu'   => 'Embu',
    'ee'    => 'Ewe',
    'efi'   => 'ኤፊክ',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'ግሪክኛ',
    'elx'   => 'Elamite',
    'en'    => 'እንግሊዝኛ',
    'en_au' => "የአውስትራሊያ\ እንግሊዝኛ",
    'en_ca' => "የካናዳ\ እንግሊዝኛ",
    'en_gb' => "የብሪቲሽ\ እንግሊዝኛ",
    'en_us' => "የዩ\ ኤስ\ እንግሊዝኛ",
    'enm'   => "Middle\ English",
    'eo'    => 'ኤስፐራንቶ',
    'es'    => 'ስፓኒሽ',
    'es_es' => "የኢበርን\ ስፓንሽ",
    'et'    => 'ኤስቶኒአን',
    'eu'    => 'ባስክኛ',
    'ewo'   => 'Ewondo',
    'fa'    => 'ፐርሲያኛ',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'ፊኒሽ',
    'fil'   => 'ፊሊፒንኛ',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'ፊጂኛ',
    'fo'    => 'ፋሮኛ',
    'fon'   => 'Fon',
    'fr'    => 'ፈረንሳይኛ',
    'fr_ca' => "የካናዳ\ ፈረንሳይኛ",
    'fr_ch' => "የስዊዝ\ ፈረንሳይኛ",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'ፍሪስኛ',
    'ga'    => 'አይሪሽ',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "እስኮትስ\ ጌልክኛ",
    'gem'   => "Germanic\ Language",
    'gez'   => 'ግዕዝኛ',
    'gil'   => 'Gilbertese',
    'gl'    => 'ጋለጋኛ',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'ጓራኒኛ',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "የስዊዝ\ ጀርመን",
    'gu'    => 'ጉጃርቲኛ',
    'guz'   => 'Gusii',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'ሃውሳኛ',
    'hai'   => 'Haida',
    'haw'   => 'ሃዊያኛ',
    'he'    => 'ዕብራስጥ',
    'hi'    => 'ሐንድኛ',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'ክሮሽያንኛ',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'ሃይትኛ',
    'hu'    => 'ሀንጋሪኛ',
    'hup'   => 'Hupa',
    'hy'    => 'አርመናዊ',
    'hz'    => 'Herero',
    'ia'    => 'ኢንቴርሊንጓ',
    'iba'   => 'Iban',
    'id'    => 'እንዶኒሲኛ',
    'ie'    => 'እንተርሊንግወ',
    'ig'    => 'ኢግቦኛ',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'እኑፒያቅኛ',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'አይስላንድኛ',
    'it'    => 'ጣሊያንኛ',
    'iu'    => 'እኑክቲቱትኛ',
    'ja'    => 'ጃፓንኛ',
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'ጃቫንኛ',
    'ka'    => 'ጊዮርጊያን',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'ካዛክኛ',
    'kl'    => 'ካላሊሱትኛ',
    'kln'   => 'Kalenjin',
    'km'    => "ክመርኛ\ ማእከላዊ",
    'kmb'   => 'Kimbundu',
    'kn'    => 'ካናዳኛ',
    'ko'    => 'ኮሪያኛ',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'ካሽሚርኛ',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'ኩርድሽኛ',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'ኪርጊዝኛ',
    'la'    => 'ላቲንኛ',
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'ሉክዘምበርገርኛ',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'ሊንጋላኛ',
    'lo'    => 'ላውስኛ',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'ሊቱአኒያን',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'luy'   => 'Luyia',
    'lv'    => 'ላትቪያን',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'ማላጋስኛ',
    'mga'   => "Middle\ Irish",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'Marshallese',
    'mi'    => 'ማዮሪኛ',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'ማከዶኒኛ',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'ማላያላምኛ',
    'mn'    => 'ሞንጎላዊኛ',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'ሞልዳቫዊና',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'ማራዚኛ',
    'ms'    => 'ማላይኛ',
    'mt'    => 'ማልቲስኛ',
    'mua'   => 'Mundang',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'ቡርማኛ',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'ናኡሩ',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'naq'   => 'Nama',
    'nb'    => "የኖርዌይ\ ቦክማል",
    'nd'    => "ሰሜን\ ንዴብሌ",
    'nds'   => "Low\ German",
    'ne'    => 'ኔፓሊኛ',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'ደች',
    'nl_be' => 'ፍሌሚሽ',
    'nmg'   => 'Kwasio',
    'nn'    => "የኖርዌይ\ ናይኖርስክ",
    'no'    => 'ኖርዌጂያን',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "ሰሜናዊ\ ሶቶ",
    'nub'   => "Nubian\ Language",
    'nus'   => 'Nuer',
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'ንያንጃ',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'ኦኪታንኛ',
    'oj'    => 'Ojibwa',
    'om'    => 'ኦሮምኛ',
    'or'    => 'ኦሪያኛ',
    'os'    => 'ኦሴቲክ',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'ፓንጃቢኛ',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'ፖሊሽኛ',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'ፑሽቶ',
    'pt'    => 'ፖርቱጋሊኛ',
    'pt_br' => "የብራዚል\ ፖርቹጋልኛ",
    'pt_pt' => "ኢበሪያን\ ፖርቱጋልኝ",
    'qu'    => 'ኵቿኛ',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => 'ሮማንስ',
    'rn'    => 'ሩንዲኛ',
    'ro'    => 'ሮማኒያን',
    'roa'   => "Romance\ Language",
    'rof'   => 'Rombo',
    'rom'   => 'Romany',
    'ru'    => 'ራሽኛ',
    'rup'   => 'Aromanian',
    'rw'    => 'ኪንያርዋንድኛ',
    'rwk'   => 'Rwa',
    'sa'    => 'ሳንስክሪትኛ',
    'sad'   => 'Sandawe',
    'sah'   => 'Sakha',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'ሲንድሂኛ',
    'se'    => "ሰሜናዊ\ ሳሚ",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'ሳንጎኛ',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "ሰርቦ\-ክሮኤሽያኛ",
    'shi'   => 'Tachelhit',
    'shn'   => 'Shan',
    'si'    => 'ስንሃልኛ',
    'sid'   => 'ሲዳምኛ',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'ስሎቫክኛ',
    'sl'    => 'ስሎቪኛ',
    'sla'   => "Slavic\ Language",
    'sm'    => 'ሳሞአኛ',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'ሾናኛ',
    'snk'   => 'Soninke',
    'so'    => 'ሱማልኛ',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'ልቤኒኛ',
    'sr'    => 'ሰርቢኛ',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'ስዋቲኛ',
    'ssa'   => "Nilo\-Saharan\ Language",
    'ssy'   => 'Saho',
    'st'    => 'ሶዞኛ',
    'su'    => 'ሱዳንኛ',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'ስዊድንኛ',
    'sw'    => 'ስዋሂሊኛ',
    'swb'   => 'Comorian',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'ታሚልኛ',
    'tai'   => "Tai\ Language",
    'te'    => 'ተሉጉኛ',
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'ቴተም',
    'tg'    => 'ታጂኪኛ',
    'th'    => 'ታይኛ',
    'ti'    => 'ትግርኛ',
    'tig'   => 'ትግረ',
    'tiv'   => 'Tiv',
    'tk'    => 'ቱርክመንኛ',
    'tkl'   => 'Tokelau',
    'tl'    => 'ታጋሎገኛ',
    'tlh'   => 'ክሊንግኦንኛ',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'ጽዋናዊኛ',
    'to'    => 'ቶንጋ',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "ቶክ\ ፒሲን",
    'tr'    => 'ቱርክኛ',
    'trv'   => 'Taroko',
    'ts'    => 'ጾንጋኛ',
    'tsi'   => 'Tsimshian',
    'tt'    => 'ታታርኛ',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'ትዊኛ',
    'twq'   => 'Tasawaq',
    'ty'    => 'ታሂታንኛ',
    'tyv'   => 'Tuvinian',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurt',
    'ug'    => 'ኡይገር',
    'uga'   => 'Ugaritic',
    'uk'    => 'ዩክረኒኛ',
    'umb'   => 'Umbundu',
    'und'   => "ያልታወቀ\ ቋንቋ",
    'ur'    => 'ኡርዱኛ',
    'uz'    => 'ኡዝበክኛ',
    'vai'   => 'Vai',
    've'    => 'ቬንዳ',
    'vi'    => 'ቪትናምኛ',
    'vo'    => 'ቮላፑክኛ',
    'vot'   => 'Votic',
    'vun'   => 'Vunjo',
    'wa'    => 'Walloon',
    'wae'   => 'Walser',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'ዎሎፍኛ',
    'xal'   => 'Kalmyk',
    'xh'    => 'ዞሳኛ',
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yav'   => 'Yangben',
    'yi'    => 'ይዲሻዊኛ',
    'yo'    => 'ዮሩባዊኛ',
    'ypk'   => "Yupik\ Language",
    'yue'   => 'Cantonese',
    'za'    => 'ዡዋንግኛ',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'ቻይንኛ',
    'znd'   => 'Zande',
    'zu'    => 'ዙሉኛ',
    'zun'   => 'Zuni',
    'zxx'   => "ቋንቋዊ\ ይዘት\ አይደለም",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::am::name_to_code = (
    'achinese'                                   => 'ace',
    'acoli'                                      => 'ach',
    'adangme'                                    => 'ada',
    'adyghe'                                     => 'ady',
    'afrihili'                                   => 'afh',
    'afroasiaticlanguage'                        => 'afa',
    'aghem'                                      => 'agq',
    'ainu'                                       => 'ain',
    'akkadian'                                   => 'akk',
    'aleut'                                      => 'ale',
    'algonquianlanguage'                         => 'alg',
    'altaiclanguage'                             => 'tut',
    'ancientegyptian'                            => 'egy',
    'ancientgreek'                               => 'grc',
    'angika'                                     => 'anp',
    'apachelanguage'                             => 'apa',
    'aragonese'                                  => 'an',
    'aramaic'                                    => 'arc',
    'arapaho'                                    => 'arp',
    'araucanian'                                 => 'arn',
    'arawak'                                     => 'arw',
    'aromanian'                                  => 'rup',
    'artificiallanguage'                         => 'art',
    'asturian'                                   => 'ast',
    'asu'                                        => 'asa',
    'athapascanlanguage'                         => 'ath',
    'atsam'                                      => 'cch',
    'australianlanguage'                         => 'aus',
    'austronesianlanguage'                       => 'map',
    'avaric'                                     => 'av',
    'avestan'                                    => 'ae',
    'awadhi'                                     => 'awa',
    'bafia'                                      => 'ksf',
    'balinese'                                   => 'ban',
    'balticlanguage'                             => 'bat',
    'baluchi'                                    => 'bal',
    'bambara'                                    => 'bm',
    'bamilekelanguage'                           => 'bai',
    'banda'                                      => 'bad',
    'bantu'                                      => 'bnt',
    'basaa'                                      => 'bas',
    'batak'                                      => 'btk',
    'beja'                                       => 'bej',
    'bemba'                                      => 'bem',
    'bena'                                       => 'bez',
    'berber'                                     => 'ber',
    'bhojpuri'                                   => 'bho',
    'bikol'                                      => 'bik',
    'bini'                                       => 'bin',
    'blissymbols'                                => 'zbl',
    'bodo'                                       => 'brx',
    'braj'                                       => 'bra',
    'buginese'                                   => 'bug',
    'buriat'                                     => 'bua',
    'caddo'                                      => 'cad',
    'cantonese'                                  => 'yue',
    'carib'                                      => 'car',
    'caucasianlanguage'                          => 'cau',
    'cayuga'                                     => 'cay',
    'cebuano'                                    => 'ceb',
    'celticlanguage'                             => 'cel',
    'centralamericanindianlanguage'              => 'cai',
    'centralmoroccotamazight'                    => 'tzm',
    'chagatai'                                   => 'chg',
    'chamiclanguage'                             => 'cmc',
    'chamorro'                                   => 'ch',
    'chechen'                                    => 'ce',
    'cherokee'                                   => 'chr',
    'cheyenne'                                   => 'chy',
    'chibcha'                                    => 'chb',
    'chiga'                                      => 'cgg',
    'chinookjargon'                              => 'chn',
    'chipewyan'                                  => 'chp',
    'choctaw'                                    => 'cho',
    'churchslavic'                               => 'cu',
    'chuukese'                                   => 'chk',
    'chuvash'                                    => 'cv',
    'classicalnewari'                            => 'nwc',
    'classicalsyriac'                            => 'syc',
    'colognian'                                  => 'ksh',
    'comorian'                                   => 'swb',
    'congoswahili'                               => 'swc',
    'coptic'                                     => 'cop',
    'cornish'                                    => 'kw',
    'cree'                                       => 'cr',
    'creek'                                      => 'mus',
    'creoleorpidgin'                             => 'crp',
    'crimeanturkish'                             => 'crh',
    'cushiticlanguage'                           => 'cus',
    'dakota'                                     => 'dak',
    'dargwa'                                     => 'dar',
    'dayak'                                      => 'day',
    'delaware'                                   => 'del',
    'dinka'                                      => 'din',
    'dogri'                                      => 'doi',
    'dogrib'                                     => 'dgr',
    'dravidianlanguage'                          => 'dra',
    'duala'                                      => 'dua',
    'dyula'                                      => 'dyu',
    'easternfrisian'                             => 'frs',
    'ekajuk'                                     => 'eka',
    'elamite'                                    => 'elx',
    'embu'                                       => 'ebu',
    'englishbasedcreoleorpidgin'                 => 'cpe',
    'erzya'                                      => 'myv',
    'ewe'                                        => 'ee',
    'ewondo'                                     => 'ewo',
    'fang'                                       => 'fan',
    'fanti'                                      => 'fat',
    'finnougrianlanguage'                        => 'fiu',
    'fon'                                        => 'fon',
    'frenchbasedcreoleorpidgin'                  => 'cpf',
    'friulian'                                   => 'fur',
    'fulah'                                      => 'ff',
    'ga'                                         => 'gaa',
    'ganda'                                      => 'lg',
    'gayo'                                       => 'gay',
    'gbaya'                                      => 'gba',
    'germaniclanguage'                           => 'gem',
    'gilbertese'                                 => 'gil',
    'gondi'                                      => 'gon',
    'gorontalo'                                  => 'gor',
    'gothic'                                     => 'got',
    'grebo'                                      => 'grb',
    'gusii'                                      => 'guz',
    "gwich\Ê\¼in"                              => 'gwi',
    'haida'                                      => 'hai',
    'herero'                                     => 'hz',
    'hiligaynon'                                 => 'hil',
    'himachali'                                  => 'him',
    'hirimotu'                                   => 'ho',
    'hittite'                                    => 'hit',
    'hmong'                                      => 'hmn',
    'hupa'                                       => 'hup',
    'iban'                                       => 'iba',
    'ido'                                        => 'io',
    'ijo'                                        => 'ijo',
    'iloko'                                      => 'ilo',
    'inarisami'                                  => 'smn',
    'indiclanguage'                              => 'inc',
    'indoeuropeanlanguage'                       => 'ine',
    'ingush'                                     => 'inh',
    'iranianlanguage'                            => 'ira',
    'iroquoianlanguage'                          => 'iro',
    'jju'                                        => 'kaj',
    'jolafonyi'                                  => 'dyo',
    'judeoarabic'                                => 'jrb',
    'judeopersian'                               => 'jpr',
    'kabardian'                                  => 'kbd',
    'kabuverdianu'                               => 'kea',
    'kabyle'                                     => 'kab',
    'kachin'                                     => 'kac',
    'kalenjin'                                   => 'kln',
    'kalmyk'                                     => 'xal',
    'kamba'                                      => 'kam',
    'kanuri'                                     => 'kr',
    'karachaybalkar'                             => 'krc',
    'karakalpak'                                 => 'kaa',
    'karelian'                                   => 'krl',
    'karen'                                      => 'kar',
    'kashubian'                                  => 'csb',
    'kawi'                                       => 'kaw',
    'khasi'                                      => 'kha',
    'khoisanlanguage'                            => 'khi',
    'khotanese'                                  => 'kho',
    'kikuyu'                                     => 'ki',
    'kimbundu'                                   => 'kmb',
    'komi'                                       => 'kv',
    'kongo'                                      => 'kg',
    'konkani'                                    => 'kok',
    'koro'                                       => 'kfo',
    'kosraean'                                   => 'kos',
    'koyraborosenni'                             => 'ses',
    'koyrachiini'                                => 'khq',
    'kpelle'                                     => 'kpe',
    'kru'                                        => 'kro',
    'kuanyama'                                   => 'kj',
    'kumyk'                                      => 'kum',
    'kurukh'                                     => 'kru',
    'kutenai'                                    => 'kut',
    'kwasio'                                     => 'nmg',
    'ladino'                                     => 'lad',
    'lahnda'                                     => 'lah',
    'lamba'                                      => 'lam',
    'langi'                                      => 'lag',
    'lezghian'                                   => 'lez',
    'limburgish'                                 => 'li',
    'lojban'                                     => 'jbo',
    'lowersorbian'                               => 'dsb',
    'lowgerman'                                  => 'nds',
    'lozi'                                       => 'loz',
    'lubakatanga'                                => 'lu',
    'lubalulua'                                  => 'lua',
    'luiseno'                                    => 'lui',
    'lulesami'                                   => 'smj',
    'lunda'                                      => 'lun',
    'luo'                                        => 'luo',
    'lushai'                                     => 'lus',
    'luyia'                                      => 'luy',
    'machame'                                    => 'jmc',
    'madurese'                                   => 'mad',
    'magahi'                                     => 'mag',
    'maithili'                                   => 'mai',
    'makasar'                                    => 'mak',
    'makhuwameetto'                              => 'mgh',
    'makonde'                                    => 'kde',
    'manchu'                                     => 'mnc',
    'mandar'                                     => 'mdr',
    'mandingo'                                   => 'man',
    'manipuri'                                   => 'mni',
    'manobolanguage'                             => 'mno',
    'manx'                                       => 'gv',
    'mari'                                       => 'chm',
    'marshallese'                                => 'mh',
    'marwari'                                    => 'mwr',
    'masai'                                      => 'mas',
    'mayanlanguage'                              => 'myn',
    'mende'                                      => 'men',
    'meru'                                       => 'mer',
    'micmac'                                     => 'mic',
    'middledutch'                                => 'dum',
    'middleenglish'                              => 'enm',
    'middlefrench'                               => 'frm',
    'middlehighgerman'                           => 'gmh',
    'middleirish'                                => 'mga',
    'minangkabau'                                => 'min',
    'mirandese'                                  => 'mwl',
    'miscellaneouslanguage'                      => 'mis',
    'mohawk'                                     => 'moh',
    'moksha'                                     => 'mdf',
    'mongo'                                      => 'lol',
    'monkhmerlanguage'                           => 'mkh',
    'morisyen'                                   => 'mfe',
    'mossi'                                      => 'mos',
    'multiplelanguages'                          => 'mul',
    'mundalanguage'                              => 'mun',
    'mundang'                                    => 'mua',
    'nahuatl'                                    => 'nah',
    'nama'                                       => 'naq',
    'navajo'                                     => 'nv',
    'ndonga'                                     => 'ng',
    'neapolitan'                                 => 'nap',
    'newari'                                     => 'new',
    'nias'                                       => 'nia',
    'nigerkordofanianlanguage'                   => 'nic',
    'nilosaharanlanguage'                        => 'ssa',
    'niuean'                                     => 'niu',
    'nogai'                                      => 'nog',
    'northamericanindianlanguage'                => 'nai',
    'northernfrisian'                            => 'frr',
    'nubianlanguage'                             => 'nub',
    'nuer'                                       => 'nus',
    'nyamwezi'                                   => 'nym',
    'nyankole'                                   => 'nyn',
    'nyasatonga'                                 => 'tog',
    'nyoro'                                      => 'nyo',
    'nzima'                                      => 'nzi',
    "n\â\\ko"                               => 'nqo',
    'ojibwa'                                     => 'oj',
    'oldenglish'                                 => 'ang',
    'oldfrench'                                  => 'fro',
    'oldhighgerman'                              => 'goh',
    'oldirish'                                   => 'sga',
    'oldnorse'                                   => 'non',
    'oldpersian'                                 => 'peo',
    "oldproven\Ã\§al"                          => 'pro',
    'osage'                                      => 'osa',
    'otomianlanguage'                            => 'oto',
    'ottomanturkish'                             => 'ota',
    'pahlavi'                                    => 'pal',
    'palauan'                                    => 'pau',
    'pali'                                       => 'pi',
    'pampanga'                                   => 'pam',
    'pangasinan'                                 => 'pag',
    'papiamento'                                 => 'pap',
    'papuanlanguage'                             => 'paa',
    'philippinelanguage'                         => 'phi',
    'phoenician'                                 => 'phn',
    'pohnpeian'                                  => 'pon',
    'portuguesebasedcreoleorpidgin'              => 'cpp',
    'prakritlanguage'                            => 'pra',
    'rajasthani'                                 => 'raj',
    'rapanui'                                    => 'rap',
    'rarotongan'                                 => 'rar',
    'romancelanguage'                            => 'roa',
    'romany'                                     => 'rom',
    'rombo'                                      => 'rof',
    'rwa'                                        => 'rwk',
    'saho'                                       => 'ssy',
    'sakha'                                      => 'sah',
    'salishanlanguage'                           => 'sal',
    'samaritanaramaic'                           => 'sam',
    'samburu'                                    => 'saq',
    'samilanguage'                               => 'smi',
    'sandawe'                                    => 'sad',
    'sangu'                                      => 'sbp',
    'santali'                                    => 'sat',
    'sardinian'                                  => 'sc',
    'sasak'                                      => 'sas',
    'scots'                                      => 'sco',
    'selkup'                                     => 'sel',
    'semiticlanguage'                            => 'sem',
    'sena'                                       => 'seh',
    'seneca'                                     => 'see',
    'serer'                                      => 'srr',
    'shambala'                                   => 'ksb',
    'shan'                                       => 'shn',
    'sichuanyi'                                  => 'ii',
    'sicilian'                                   => 'scn',
    'signlanguage'                               => 'sgn',
    'siksika'                                    => 'bla',
    'sinotibetanlanguage'                        => 'sit',
    'siouanlanguage'                             => 'sio',
    'skoltsami'                                  => 'sms',
    'slave'                                      => 'den',
    'slaviclanguage'                             => 'sla',
    'soga'                                       => 'xog',
    'sogdien'                                    => 'sog',
    'songhai'                                    => 'son',
    'soninke'                                    => 'snk',
    'sorbianlanguage'                            => 'wen',
    'southamericanindianlanguage'                => 'sai',
    'southernaltai'                              => 'alt',
    'southernsami'                               => 'sma',
    'southndebele'                               => 'nr',
    'sranantongo'                                => 'srn',
    'sukuma'                                     => 'suk',
    'sumerian'                                   => 'sux',
    'susu'                                       => 'sus',
    'syriac'                                     => 'syr',
    'tachelhit'                                  => 'shi',
    'tailanguage'                                => 'tai',
    'taita'                                      => 'dav',
    'tamashek'                                   => 'tmh',
    'taroko'                                     => 'trv',
    'tasawaq'                                    => 'twq',
    'tereno'                                     => 'ter',
    'teso'                                       => 'teo',
    'timne'                                      => 'tem',
    'tiv'                                        => 'tiv',
    'tlingit'                                    => 'tli',
    'tokelau'                                    => 'tkl',
    'tsimshian'                                  => 'tsi',
    'tumbuka'                                    => 'tum',
    'tupilanguage'                               => 'tup',
    'tuvalu'                                     => 'tvl',
    'tuvinian'                                   => 'tyv',
    'tyap'                                       => 'kcg',
    'udmurt'                                     => 'udm',
    'ugaritic'                                   => 'uga',
    'umbundu'                                    => 'umb',
    'uppersorbian'                               => 'hsb',
    'vai'                                        => 'vai',
    'votic'                                      => 'vot',
    'vunjo'                                      => 'vun',
    'wakashanlanguage'                           => 'wak',
    'walamo'                                     => 'wal',
    'walloon'                                    => 'wa',
    'walser'                                     => 'wae',
    'waray'                                      => 'war',
    'washo'                                      => 'was',
    'yangben'                                    => 'yav',
    'yao'                                        => 'yao',
    'yapese'                                     => 'yap',
    'yupiklanguage'                              => 'ypk',
    'zande'                                      => 'znd',
    'zapotec'                                    => 'zap',
    'zarma'                                      => 'dje',
    'zaza'                                       => 'zza',
    'zenaga'                                     => 'zen',
    'zuni'                                       => 'zun',
    'ሀንጋሪኛ'                            => 'hu',
    'ሃዊያኛ'                               => 'haw',
    'ሃውሳኛ'                               => 'ha',
    'ሃይትኛ'                               => 'ht',
    'ሉክዘምበርገርኛ'                => 'lb',
    'ሊቱአኒያን'                         => 'lt',
    'ሊንጋላኛ'                            => 'ln',
    'ላቲንኛ'                               => 'la',
    'ላትቪያን'                            => 'lv',
    'ላውስኛ'                               => 'lo',
    'ልቤኒኛ'                               => 'sq',
    'ሐንድኛ'                               => 'hi',
    'ማላያላምኛ'                         => 'ml',
    'ማላይኛ'                               => 'ms',
    'ማላጋስኛ'                            => 'mg',
    'ማልቲስኛ'                            => 'mt',
    'ማራዚኛ'                               => 'mr',
    'ማከዶኒኛ'                            => 'mk',
    'ማዮሪኛ'                               => 'mi',
    'ሞልዳቫዊና'                         => 'mo',
    'ሞንጎላዊኛ'                         => 'mn',
    'ሩንዲኛ'                               => 'rn',
    'ራሽኛ'                                  => 'ru',
    'ሮማኒያን'                            => 'ro',
    'ሮማንስ'                               => 'rm',
    'ሰሜናዊሳሚ'                         => 'se',
    'ሰሜናዊሶቶ'                         => 'nso',
    'ሰሜንንዴብሌ'                      => 'nd',
    'ሰርቢኛ'                               => 'sr',
    'ሰርቦክሮኤሽያኛ'                => 'sh',
    'ሱማልኛ'                               => 'so',
    'ሱዳንኛ'                               => 'su',
    'ሲንድሂኛ'                            => 'sd',
    'ሲዳምኛ'                               => 'sid',
    'ሳሞአኛ'                               => 'sm',
    'ሳንስክሪትኛ'                      => 'sa',
    'ሳንጎኛ'                               => 'sg',
    'ስሎቪኛ'                               => 'sl',
    'ስሎቫክኛ'                            => 'sk',
    'ስንሃልኛ'                            => 'si',
    'ስዊድንኛ'                            => 'sv',
    'ስዋሂሊኛ'                            => 'sw',
    'ስዋቲኛ'                               => 'ss',
    'ስፓኒሽ'                               => 'es',
    'ሶዞኛ'                                  => 'st',
    'ሾናኛ'                                  => 'sn',
    'ቋንቋዊይዘትአይደለም'       => 'zxx',
    'በንጋሊኛ'                            => 'bn',
    'ቡልጋሪኛ'                            => 'bg',
    'ቡርማኛ'                               => 'my',
    'ቢሃሪ'                                  => 'bh',
    'ቢስላምኛ'                            => 'bi',
    'ባስኪርኛ'                            => 'ba',
    'ባስክኛ'                               => 'eu',
    'ቤላራሻኛ'                            => 'be',
    'ብሊን'                                  => 'byn',
    'ብሬቶንኛ'                            => 'br',
    'ቦዝኒያንኛ'                         => 'bs',
    'ቪትናምኛ'                            => 'vi',
    'ቬንዳ'                                  => 've',
    'ቮላፑክኛ'                            => 'vo',
    'ተሉጉኛ'                               => 'te',
    'ቱርክመንኛ'                         => 'tk',
    'ቱርክኛ'                               => 'tr',
    'ታሂታንኛ'                            => 'ty',
    'ታሚልኛ'                               => 'ta',
    'ታታርኛ'                               => 'tt',
    'ታይኛ'                                  => 'th',
    'ታጂኪኛ'                               => 'tg',
    'ታጋሎገኛ'                            => 'tl',
    'ቴተም'                                  => 'tet',
    'ትበትንኛ'                            => 'bo',
    'ትዊኛ'                                  => 'tw',
    'ትግረ'                                  => 'tig',
    'ትግርኛ'                               => 'ti',
    'ቶንጋ'                                  => 'to',
    'ቶክፒሲን'                            => 'tpi',
    'ቻይንኛ'                               => 'zh',
    'ቼክኛ'                                  => 'cs',
    'ናኡሩ'                                  => 'na',
    'ኔፓሊኛ'                               => 'ne',
    'ንያንጃ'                               => 'ny',
    'ኖርዌጂያን'                         => 'no',
    'አማርኛ'                               => 'am',
    'አርመናዊ'                            => 'hy',
    'አሳሜዛዊ'                            => 'as',
    'አብሐዚኛ'                            => 'ab',
    'አካንኛ'                               => 'ak',
    'አዜሪ'                                  => 'az',
    'አያማርኛ'                            => 'ay',
    'አይሪሽ'                               => 'ga',
    'አይስላንድኛ'                      => 'is',
    'አፋርኛ'                               => 'aa',
    'አፍሪካንስ'                         => 'af',
    'ኡርዱኛ'                               => 'ur',
    'ኡዝበክኛ'                            => 'uz',
    'ኡይገር'                               => 'ug',
    'ኢበሪያንፖርቱጋልኝ'          => 'pt_pt',
    'ኢንቴርሊንጓ'                      => 'ia',
    'ኢግቦኛ'                               => 'ig',
    'ኤስቶኒአን'                         => 'et',
    'ኤስፐራንቶ'                         => 'eo',
    'ኤፊክ'                                  => 'efi',
    'እስኮትስጌልክኛ'                => 'gd',
    'እኑክቲቱትኛ'                      => 'iu',
    'እኑፒያቅኛ'                         => 'ik',
    'እንተርሊንግወ'                   => 'ie',
    'እንዶኒሲኛ'                         => 'id',
    'እንግሊዝኛ'                         => 'en',
    'ኦሪያኛ'                               => 'or',
    'ኦሮምኛ'                               => 'om',
    'ኦሴቲክ'                               => 'os',
    'ኦኪታንኛ'                            => 'oc',
    'ኩርድሽኛ'                            => 'ku',
    'ኪርጊዝኛ'                            => 'ky',
    'ኪንያርዋንድኛ'                   => 'rw',
    'ካላሊሱትኛ'                         => 'kl',
    'ካሽሚርኛ'                            => 'ks',
    'ካታላንኛ'                            => 'ca',
    'ካናዳኛ'                               => 'kn',
    'ካዛክኛ'                               => 'kk',
    'ክሊንግኦንኛ'                      => 'tlh',
    'ክመርኛማእከላዊ'                => 'km',
    'ክሮሽያንኛ'                         => 'hr',
    'ኮሪያኛ'                               => 'ko',
    'ኮርሲካኛ'                            => 'co',
    'ኵቿኛ'                                  => 'qu',
    'ወልሽ'                                  => 'cy',
    'ዎሎፍኛ'                               => 'wo',
    'ዐርቢኛ'                               => 'ar',
    'ዕብራስጥ'                            => 'he',
    'ዙሉኛ'                                  => 'zu',
    'ዞሳኛ'                                  => 'xh',
    'ዡዋንግኛ'                            => 'za',
    'የስዊዝከፍተኛጀርመንኛ'    => 'de_ch',
    'የስዊዝጀርመን'                   => 'gsw',
    'የስዊዝፈረንሳይኛ'             => 'fr_ch',
    'የብሪቲሽእንግሊዝኛ'          => 'en_gb',
    'የብራዚልፖርቹጋልኛ'          => 'pt_br',
    'የኖርዌይቦክማል'                => 'nb',
    'የኖርዌይናይኖርስክ'          => 'nn',
    'የአውስትራሊያእንግሊዝኛ' => 'en_au',
    'የኢበርንስፓንሽ'                => 'es_es',
    'የኦስትሪያጀርመን'             => 'de_at',
    'የካናዳእንግሊዝኛ'             => 'en_ca',
    'የካናዳፈረንሳይኛ'             => 'fr_ca',
    'የዩኤስእንግሊዝኛ'             => 'en_us',
    'ዩክረኒኛ'                            => 'uk',
    'ያልታወቀቋንቋ'                   => 'und',
    'ይዲሻዊኛ'                            => 'yi',
    'ዮሩባዊኛ'                            => 'yo',
    'ደች'                                     => 'nl',
    'ዲቬህ'                                  => 'dv',
    'ዴኒሽ'                                  => 'da',
    'ድዞንግኻኛ'                         => 'dz',
    'ጀርመን'                               => 'de',
    'ጃቫንኛ'                               => 'jv',
    'ጃፓንኛ'                               => 'ja',
    'ጉጃርቲኛ'                            => 'gu',
    'ጊዮርጊያን'                         => 'ka',
    'ጋለጋኛ'                               => 'gl',
    'ግሪክኛ'                               => 'el',
    'ግዕዝኛ'                               => 'gez',
    'ጓራኒኛ'                               => 'gn',
    'ጣሊያንኛ'                            => 'it',
    'ጽዋናዊኛ'                            => 'tn',
    'ጾንጋኛ'                               => 'ts',
    'ፈረንሳይኛ'                         => 'fr',
    'ፊሊፒንኛ'                            => 'fil',
    'ፊኒሽ'                                  => 'fi',
    'ፊጂኛ'                                  => 'fj',
    'ፋሮኛ'                                  => 'fo',
    'ፍሌሚሽ'                               => 'nl_be',
    'ፍሪስኛ'                               => 'fy',
    'ፐርሲያኛ'                            => 'fa',
    'ፑሽቶ'                                  => 'ps',
    'ፓንጃቢኛ'                            => 'pa',
    'ፖሊሽኛ'                               => 'pl',
    'ፖርቱጋሊኛ'                         => 'pt',
);

1;
