package Locales::DB::Language::zh;

# Auto generated from CLDR

$Locales::DB::Language::zh::VERSION = '0.07';

$Locales::DB::Language::zh::cldr_version = '2.0';

%Locales::DB::Language::zh::misc_info = (
    'characters'   => { 'more_information' => '？' },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "语言：\{0\}",
        'list'     => {
            2        => "\{0\}和\{1\}",
            'end'    => "\{0\}和\{1\}",
            'middle' => "\{0\}、\{1\}",
            'start'  => "\{0\}、\{1\}"
        },
        'locale'    => "\{0\}（\{1\}）",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "区域：\{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '‘',
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list'  => ['other'],
        'category_rules' => {}
    },
    'posix' => {
        'nostr'  => "否\:否定",
        'yesstr' => "是\:确定"
    },
);

%Locales::DB::Language::zh::code_to_name = (
    'aa'    => '阿法文',
    'ab'    => '阿布哈西亚文',
    'ace'   => '亚齐文',
    'ach'   => '阿乔利文',
    'ada'   => '阿当梅文',
    'ady'   => '阿迪何文',
    'ae'    => '阿维斯塔文',
    'af'    => '南非荷兰文',
    'afa'   => '其他亚非语系',
    'afh'   => '阿弗里希利文',
    'agq'   => 'Aghem',
    'ain'   => '阿伊努文',
    'ak'    => '阿肯文',
    'akk'   => '阿卡德文',
    'ale'   => '阿留申文',
    'alg'   => '其他阿尔贡语系',
    'alt'   => '南阿尔泰文',
    'am'    => '阿姆哈拉文',
    'an'    => '阿拉贡文',
    'ang'   => '古英文',
    'anp'   => '昂加语',
    'apa'   => '阿帕切文',
    'ar'    => '阿拉伯文',
    'arc'   => '阿拉米文',
    'arn'   => '阿劳坎文',
    'arp'   => '阿拉帕霍文',
    'art'   => '其他人工语系',
    'arw'   => '阿拉瓦克文',
    'as'    => '阿萨姆文',
    'asa'   => 'Asu',
    'ast'   => '阿斯图里亚思特文',
    'ath'   => '阿萨帕斯坎语系',
    'aus'   => '澳大利亚语系',
    'av'    => '阿瓦尔文',
    'awa'   => '阿瓦乔文',
    'ay'    => '艾马拉文',
    'az'    => '阿塞拜疆文',
    'ba'    => '巴什客尔文',
    'bad'   => '班达文',
    'bai'   => '巴米累克语系',
    'bal'   => '俾路支文',
    'ban'   => '巴里文',
    'bas'   => '巴萨文',
    'bat'   => '其他波罗的语系',
    'be'    => '白俄罗斯文',
    'bej'   => '别札文',
    'bem'   => '别姆巴文',
    'ber'   => '柏柏尔文',
    'bez'   => 'Bena',
    'bg'    => '保加利亚文',
    'bh'    => '比哈尔文',
    'bho'   => '博杰普尔文',
    'bi'    => '比斯拉马文',
    'bik'   => '毕库尔文',
    'bin'   => '比尼文',
    'bla'   => '司克司卡文',
    'bm'    => '班巴拉文',
    'bn'    => '孟加拉文',
    'bnt'   => '班图文',
    'bo'    => '藏文',
    'br'    => '布里多尼文',
    'bra'   => '布拉杰文',
    'brx'   => 'Bodo',
    'bs'    => '波斯尼亚文',
    'btk'   => '巴塔克文',
    'bua'   => '布里亚特文',
    'bug'   => '布吉文',
    'byn'   => '布林文',
    'ca'    => '加泰罗尼亚文',
    'cad'   => '卡多文',
    'cai'   => '其他中美印第安语系',
    'car'   => '巴勒比文',
    'cau'   => '其他高加索语系',
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => '车臣文',
    'ceb'   => '宿务文',
    'cel'   => '其他凯尔特语系',
    'cgg'   => 'Chiga',
    'ch'    => '查莫罗文',
    'chb'   => '契布卡文',
    'chg'   => '查加文',
    'chk'   => '楚吾克文',
    'chm'   => '马里文',
    'chn'   => '契努克文',
    'cho'   => '乔克托文',
    'chp'   => '佩瓦扬文',
    'chr'   => '彻罗基文',
    'chy'   => '夏延文',
    'cmc'   => '查米克文',
    'co'    => '科西嘉文',
    'cop'   => '科普特文',
    'cpe'   => '其他以英文为基础的克里奥尔混合语系',
    'cpf'   => '其他以法文为基础的克里奥尔混合语系',
    'cpp'   => '其他以葡萄牙文为基础的克里奥尔混合语系',
    'cr'    => '克里族文',
    'crh'   => '克里米亚土耳其文；克里米亚塔塔文',
    'crp'   => '其他克里奥尔混合语系',
    'cs'    => '捷克文',
    'csb'   => '卡舒文',
    'cu'    => '宗教斯拉夫文',
    'cus'   => '其他库施特语系',
    'cv'    => '楚瓦什文',
    'cy'    => '威尔士文',
    'da'    => '丹麦文',
    'dak'   => '达科他文',
    'dar'   => '达尔格瓦文',
    'dav'   => 'Taita',
    'day'   => '达雅克文',
    'de'    => '德文',
    'de_at' => '奥地利德语',
    'de_ch' => '瑞士高地德文',
    'del'   => '特拉华文',
    'den'   => '司雷夫文',
    'dgr'   => '多格里布文',
    'din'   => '丁卡文',
    'dje'   => 'Zarma',
    'doi'   => '多格拉文',
    'dra'   => '其他德拉维语系',
    'dsb'   => '下索布文',
    'dua'   => '都阿拉文',
    'dum'   => '中古荷兰文',
    'dv'    => '迪维希文',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => '迪尤拉文',
    'dz'    => '不丹文',
    'ebu'   => 'Embu',
    'ee'    => '埃维文',
    'efi'   => '埃菲克文',
    'egy'   => '古埃及文',
    'eka'   => '埃克丘克文',
    'el'    => '希腊文',
    'elx'   => '艾拉米特文',
    'en'    => '英文',
    'en_au' => '英语（澳大利亚）',
    'en_ca' => '加拿大英语',
    'en_gb' => '英语（英国）',
    'en_us' => '英语（美国）',
    'enm'   => '中古英文',
    'eo'    => '世界文',
    'es'    => '西班牙文',
    'es_es' => '西班牙语（伊比利亚）',
    'et'    => '爱沙尼亚文',
    'eu'    => '巴斯克文',
    'ewo'   => '旺杜文',
    'fa'    => '波斯文',
    'fan'   => '芳格文',
    'fat'   => '芳蒂文',
    'ff'    => '夫拉文',
    'fi'    => '芬兰文',
    'fil'   => '菲律宾文',
    'fiu'   => '其他芬兰乌戈尔语系',
    'fj'    => '斐济文',
    'fo'    => '法罗文',
    'fon'   => '丰文',
    'fr'    => '法文',
    'fr_ca' => '加拿大法语',
    'fr_ch' => '瑞士法语',
    'frm'   => '中古法文',
    'fro'   => '古法文',
    'frr'   => '北弗里西亚语',
    'frs'   => '东弗里西亚文',
    'fur'   => '弗留利文',
    'fy'    => '西弗里西亚文',
    'ga'    => '爱尔兰文',
    'gaa'   => '加文',
    'gay'   => '迦约文',
    'gba'   => '葛巴亚文',
    'gd'    => '苏格兰盖尔文',
    'gem'   => '其他日尔曼语系',
    'gez'   => '吉兹文',
    'gil'   => '吉尔伯特斯文',
    'gl'    => '加利西亚文',
    'gmh'   => '中古高地德文',
    'gn'    => '瓜拉尼文',
    'goh'   => '古高地德文',
    'gon'   => '岗德文',
    'gor'   => '科洛涅达罗文',
    'got'   => '哥特文',
    'grb'   => '格列博文',
    'grc'   => '古希腊文',
    'gsw'   => '瑞士德文',
    'gu'    => '古加拉提文',
    'guz'   => 'Gusii',
    'gv'    => '马恩岛文',
    'gwi'   => '吉维克琴文',
    'ha'    => '豪撒文',
    'hai'   => '海达文',
    'haw'   => '夏威夷文',
    'he'    => '希伯来文',
    'hi'    => '印地文',
    'hil'   => '希利盖农文',
    'him'   => '赫马查利文',
    'hit'   => '赫梯文',
    'hmn'   => '赫蒙文',
    'ho'    => '希里莫图文',
    'hr'    => '克罗地亚文',
    'hsb'   => '上索布文',
    'ht'    => '海地文',
    'hu'    => '匈牙利文',
    'hup'   => '胡帕文',
    'hy'    => '亚美尼亚文',
    'hz'    => '赫雷罗文',
    'ia'    => '国际语',
    'iba'   => '伊班文',
    'id'    => '印度尼西亚文',
    'ie'    => '国际语（E）',
    'ig'    => '伊格博文',
    'ii'    => '四川彝文',
    'ijo'   => '伊乔文',
    'ik'    => '依奴皮维克文',
    'ilo'   => '伊洛干诺文',
    'inc'   => '其他印度语系',
    'ine'   => '其他印欧语系',
    'inh'   => '印古什文',
    'io'    => '伊多文',
    'ira'   => '伊朗文',
    'iro'   => '伊洛魁语系',
    'is'    => '冰岛文',
    'it'    => '意大利文',
    'iu'    => '伊努伊特文',
    'ja'    => '日文',
    'jbo'   => '逻辑文',
    'jmc'   => 'Machame',
    'jpr'   => '犹太波斯文',
    'jrb'   => '犹太阿拉伯文',
    'jv'    => '爪哇文',
    'ka'    => '格鲁吉亚文',
    'kaa'   => '卡拉卡尔帕克文',
    'kab'   => '卡比尔文',
    'kac'   => '卡琴文',
    'kaj'   => 'Jju',
    'kam'   => '卡姆巴文',
    'kar'   => '喀伦文',
    'kaw'   => '卡威文',
    'kbd'   => '卡巴尔达文',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => '科罗语',
    'kg'    => '刚果文',
    'kha'   => '卡西文',
    'khi'   => '其他科伊桑语系',
    'kho'   => '和田文',
    'khq'   => "Koyra\ Chiini",
    'ki'    => '吉库尤文',
    'kj'    => '宽亚玛文',
    'kk'    => '哈萨克文',
    'kl'    => '格陵兰文',
    'kln'   => 'Kalenjin',
    'km'    => '柬埔寨文',
    'kmb'   => '金邦杜文',
    'kn'    => '坎纳达文',
    'ko'    => '韩文',
    'kok'   => '刚卡尼文',
    'kos'   => '科斯拉伊文',
    'kpe'   => '克佩列文',
    'kr'    => '卡努里文',
    'krc'   => '卡拉恰伊巴尔卡尔文',
    'krl'   => '卡累利阿文',
    'kro'   => '克鲁文',
    'kru'   => '库鲁克文',
    'ks'    => '克什米尔文',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => '库尔德文',
    'kum'   => '库梅克文',
    'kut'   => '库特内文',
    'kv'    => '科米文',
    'kw'    => '凯尔特文',
    'ky'    => '吉尔吉斯文',
    'la'    => '拉丁文',
    'lad'   => '拉迪诺文',
    'lag'   => 'Langi',
    'lah'   => '拉亨达文',
    'lam'   => '兰巴文',
    'lb'    => '卢森堡文',
    'lez'   => '莱兹依昂文',
    'lg'    => '卢干达文',
    'li'    => '淋布尔吉文',
    'ln'    => '林加拉文',
    'lo'    => '老挝文',
    'lol'   => '芒戈文',
    'loz'   => '洛兹文',
    'lt'    => '立陶宛文',
    'lu'    => '鲁巴加丹加文',
    'lua'   => '鲁巴鲁瓦文',
    'lui'   => '路易塞诺文',
    'lun'   => '隆达文',
    'luo'   => '卢奥文',
    'lus'   => '卢晒文',
    'luy'   => 'Luyia',
    'lv'    => '拉脱维亚文',
    'mad'   => '马都拉文',
    'mag'   => '马加伊文',
    'mai'   => '迈蒂利文',
    'mak'   => '望加锡文',
    'man'   => '曼丁哥文',
    'map'   => '澳斯特罗尼西亚语系',
    'mas'   => '萨伊语',
    'mdf'   => '莫克沙文',
    'mdr'   => '曼达尔',
    'men'   => '门迪文',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => '马尔加什文',
    'mga'   => '中古爱尔兰文',
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => '马绍尔文',
    'mi'    => '毛利文',
    'mic'   => '米克马克文',
    'min'   => '米南卡保文',
    'mis'   => '各种不同语系',
    'mk'    => '马其顿文',
    'mkh'   => '其他孟高棉语系',
    'ml'    => '马来亚拉姆文',
    'mn'    => '蒙古文',
    'mnc'   => '满文',
    'mni'   => '曼尼普里文',
    'mno'   => '马诺博语系',
    'mo'    => '摩尔多瓦文',
    'moh'   => '摩霍克文',
    'mos'   => '莫西文',
    'mr'    => '马拉地文',
    'ms'    => '马来文',
    'mt'    => '马耳他文',
    'mua'   => 'Mundang',
    'mul'   => '多种语系',
    'mun'   => '蒙达语系',
    'mus'   => '克里克文',
    'mwl'   => '米兰德斯文',
    'mwr'   => '马尔瓦利文',
    'my'    => '缅甸文',
    'myn'   => '玛雅语系',
    'myv'   => '俄日亚文',
    'na'    => '瑙鲁文',
    'nah'   => '纳瓦特尔文',
    'nai'   => '其他北美印第安语系',
    'nap'   => '拿波里文',
    'naq'   => 'Nama',
    'nb'    => '挪威博克马尔文',
    'nd'    => '北恩德贝勒文',
    'nds'   => '低地德文；低地撒克逊文',
    'ne'    => '尼泊尔文',
    'new'   => '尼瓦尔文',
    'ng'    => '恩东加文',
    'nia'   => '尼亚斯文',
    'nic'   => '其他尼日尔科尔多凡语系',
    'niu'   => '纽埃文',
    'nl'    => '荷兰文',
    'nl_be' => '弗拉芒语',
    'nmg'   => 'Kwasio',
    'nn'    => '挪威尼诺斯克文',
    'no'    => '挪威文',
    'nog'   => '诺盖文',
    'non'   => '古诺尔斯文',
    'nqo'   => '西非书面语言',
    'nr'    => '南恩德贝勒文',
    'nso'   => '北索托文',
    'nub'   => '努比亚语系',
    'nus'   => 'Nuer',
    'nv'    => '纳瓦霍文',
    'nwc'   => "尼瓦尔文（Classical\ Newari）",
    'ny'    => '尼扬扎文',
    'nym'   => '尼亚姆韦齐文',
    'nyn'   => '尼昂科勒文',
    'nyo'   => '尼约罗文',
    'nzi'   => '恩济马文',
    'oc'    => '奥克西唐语',
    'oj'    => '奥吉布瓦文',
    'om'    => '奥洛莫文',
    'or'    => '欧里亚文',
    'os'    => '奥塞梯文',
    'osa'   => '奥萨格文',
    'ota'   => '奥托曼土耳其文',
    'oto'   => '奥托米语系',
    'pa'    => '旁遮普文',
    'paa'   => '其他巴布亚文',
    'pag'   => '邦阿西楠语',
    'pal'   => '帕拉维文',
    'pam'   => '邦板牙文',
    'pap'   => '帕皮亚门托文',
    'pau'   => '帕劳文',
    'peo'   => '古老波斯语',
    'phi'   => '其他菲律宾语系',
    'phn'   => '腓尼基文',
    'pi'    => '巴利文',
    'pl'    => '波兰文',
    'pon'   => '波纳佩文',
    'pra'   => '普拉克里特诸语言',
    'pro'   => '普罗文斯文',
    'ps'    => '普什图文',
    'pt'    => '葡萄牙文',
    'pt_br' => '葡萄牙语（巴西）',
    'pt_pt' => '依伯利亚葡萄牙文',
    'qu'    => '盖丘亚文',
    'raj'   => '拉贾斯坦文',
    'rap'   => '拉帕努伊文',
    'rar'   => '拉罗汤加文',
    'rm'    => '罗曼什文',
    'rn'    => '基隆迪文',
    'ro'    => '罗马尼亚文',
    'roa'   => '其他拉丁语系',
    'rof'   => 'Rombo',
    'rom'   => '吉普赛文',
    'ru'    => '俄文',
    'rup'   => '亚美尼亚语',
    'rw'    => '卢旺达文',
    'rwk'   => 'Rwa',
    'sa'    => '梵文',
    'sad'   => '散达维文',
    'sah'   => '雅库特文',
    'sai'   => '其他南美印第安文',
    'sal'   => '萨利什文',
    'sam'   => '萨玛利亚文',
    'saq'   => 'Samburu',
    'sas'   => '萨萨克文',
    'sat'   => '桑塔利文',
    'sbp'   => 'Sangu',
    'sc'    => '萨丁文',
    'scn'   => '西西里文',
    'sco'   => '苏格兰文',
    'sd'    => '信德文',
    'se'    => '北萨米文',
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => '塞尔库普文',
    'sem'   => '其他闪族语系',
    'ses'   => "Koyraboro\ Senni",
    'sg'    => '桑戈文',
    'sga'   => '古爱尔兰文',
    'sgn'   => '手语',
    'sh'    => "塞尔维亚\-克罗地亚文",
    'shi'   => 'Tachelhit',
    'shn'   => '掸文',
    'si'    => '僧伽罗文',
    'sid'   => '悉达摩文',
    'sio'   => '苏语诸语言',
    'sit'   => '其他汉藏语系',
    'sk'    => '斯洛伐克文',
    'sl'    => '斯洛文尼亚文',
    'sla'   => '其他斯拉夫语系',
    'sm'    => '萨摩亚文',
    'sma'   => '南萨米文',
    'smi'   => '其他萨米文',
    'smj'   => '律勒欧萨莫斯语',
    'smn'   => '伊纳里萨米语',
    'sms'   => '斯科特萨米文',
    'sn'    => '绍纳文',
    'snk'   => '索尼基文',
    'so'    => '索马里文',
    'sog'   => '古粟特语',
    'son'   => '桑海文',
    'sq'    => '阿尔巴尼亚文',
    'sr'    => '塞尔维亚文',
    'srn'   => '苏里南汤加语',
    'srr'   => '谢列尔文',
    'ss'    => '斯瓦特文',
    'ssa'   => '非洲撒哈拉沙漠边缘地带语言',
    'ssy'   => 'Saho',
    'st'    => '南索托文',
    'su'    => '巽他语',
    'suk'   => '苏库马文',
    'sus'   => '苏苏文',
    'sux'   => '苏马文',
    'sv'    => '瑞典文',
    'sw'    => '斯瓦希里文',
    'swb'   => '科摩罗语',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => '叙利亚文',
    'ta'    => '泰米尔文',
    'tai'   => '傣语诸语言（其他）',
    'te'    => '泰卢固文',
    'tem'   => '滕内语',
    'teo'   => 'Teso',
    'ter'   => '特列纳文',
    'tet'   => '特塔姆文',
    'tg'    => '塔吉克文',
    'th'    => '泰文',
    'ti'    => '提格里尼亚文',
    'tig'   => '提格雷文',
    'tiv'   => '蒂夫文',
    'tk'    => '土库曼文',
    'tkl'   => '托克劳文',
    'tl'    => '塔加洛语',
    'tlh'   => '克林贡文',
    'tli'   => '特林吉特文',
    'tmh'   => '塔马奇克文',
    'tn'    => '塞茨瓦纳文',
    'to'    => '汤加文',
    'tog'   => '汤加文（尼亚萨地区）',
    'tpi'   => '托克皮辛文',
    'tr'    => '土耳其文',
    'trv'   => 'Taroko',
    'ts'    => '宗加文',
    'tsi'   => '蒂姆西亚文',
    'tt'    => '塔塔尔文',
    'tum'   => '通布卡文',
    'tup'   => '图皮语系',
    'tut'   => '阿尔泰诸语言（其他）',
    'tvl'   => '图瓦卢文',
    'tw'    => '特威文',
    'twq'   => 'Tasawaq',
    'ty'    => '塔西提文',
    'tyv'   => '图瓦文',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => '乌德穆尔特文',
    'ug'    => '维吾尔文',
    'uga'   => '乌加里特文',
    'uk'    => '乌克兰文',
    'umb'   => '翁本杜文',
    'und'   => '未知语言',
    'ur'    => '乌尔都文',
    'uz'    => '乌兹别克文',
    'vai'   => '瓦伊文',
    've'    => '文达文',
    'vi'    => '越南文',
    'vo'    => '沃拉普克文',
    'vot'   => '沃提克文',
    'vun'   => 'Vunjo',
    'wa'    => '瓦隆文',
    'wae'   => 'Walser',
    'wak'   => '瓦卡什诸语言',
    'wal'   => '瓦拉莫文',
    'war'   => '瓦赖文',
    'was'   => '瓦绍文',
    'wen'   => '索布诸语言',
    'wo'    => '沃洛夫文',
    'xal'   => '卡尔梅克文',
    'xh'    => '科萨文',
    'xog'   => 'Soga',
    'yao'   => '瑶族文',
    'yap'   => '雅浦文',
    'yav'   => 'Yangben',
    'yi'    => '依地文',
    'yo'    => '约鲁巴文',
    'ypk'   => '尤皮克诸语言',
    'yue'   => '粤语',
    'za'    => '壮语',
    'zap'   => '萨波蒂克文',
    'zbl'   => 'Blissymbols',
    'zen'   => '泽纳加文',
    'zh'    => '中文',
    'znd'   => '赞德文',
    'zu'    => '祖鲁文',
    'zun'   => '祖尼语',
    'zxx'   => '无语言内容',
    'zza'   => '扎扎文',
);

%Locales::DB::Language::zh::name_to_code = (
    'aghem'                                                     => 'agq',
    'asu'                                                       => 'asa',
    'atsam'                                                     => 'cch',
    'bafia'                                                     => 'ksf',
    'bena'                                                      => 'bez',
    'blissymbols'                                               => 'zbl',
    'bodo'                                                      => 'brx',
    'cayuga'                                                    => 'cay',
    'centralmoroccotamazight'                                   => 'tzm',
    'chiga'                                                     => 'cgg',
    'classicalsyriac'                                           => 'syc',
    'colognian'                                                 => 'ksh',
    'congoswahili'                                              => 'swc',
    'embu'                                                      => 'ebu',
    'gusii'                                                     => 'guz',
    'jju'                                                       => 'kaj',
    'jolafonyi'                                                 => 'dyo',
    'kabuverdianu'                                              => 'kea',
    'kalenjin'                                                  => 'kln',
    'koyraborosenni'                                            => 'ses',
    'koyrachiini'                                               => 'khq',
    'kwasio'                                                    => 'nmg',
    'langi'                                                     => 'lag',
    'luyia'                                                     => 'luy',
    'machame'                                                   => 'jmc',
    'makhuwameetto'                                             => 'mgh',
    'makonde'                                                   => 'kde',
    'meru'                                                      => 'mer',
    'morisyen'                                                  => 'mfe',
    'mundang'                                                   => 'mua',
    'nama'                                                      => 'naq',
    'nuer'                                                      => 'nus',
    'rombo'                                                     => 'rof',
    'rwa'                                                       => 'rwk',
    'saho'                                                      => 'ssy',
    'samburu'                                                   => 'saq',
    'sangu'                                                     => 'sbp',
    'sena'                                                      => 'seh',
    'seneca'                                                    => 'see',
    'shambala'                                                  => 'ksb',
    'soga'                                                      => 'xog',
    'tachelhit'                                                 => 'shi',
    'taita'                                                     => 'dav',
    'taroko'                                                    => 'trv',
    'tasawaq'                                                   => 'twq',
    'teso'                                                      => 'teo',
    'tyap'                                                      => 'kcg',
    'vunjo'                                                     => 'vun',
    'walser'                                                    => 'wae',
    'yangben'                                                   => 'yav',
    'zarma'                                                     => 'dje',
    '丁卡文'                                                 => 'din',
    '上索布文'                                              => 'hsb',
    '下索布文'                                              => 'dsb',
    '不丹文'                                                 => 'dz',
    '世界文'                                                 => 'eo',
    '东弗里西亚文'                                        => 'frs',
    '中古法文'                                              => 'frm',
    '中古爱尔兰文'                                        => 'mga',
    '中古英文'                                              => 'enm',
    '中古荷兰文'                                           => 'dum',
    '中古高地德文'                                        => 'gmh',
    '中文'                                                    => 'zh',
    '丰文'                                                    => 'fon',
    '丹麦文'                                                 => 'da',
    '乌克兰文'                                              => 'uk',
    '乌兹别克文'                                           => 'uz',
    '乌加里特文'                                           => 'uga',
    '乌尔都文'                                              => 'ur',
    '乌德穆尔特文'                                        => 'udm',
    '乔克托文'                                              => 'cho',
    '亚美尼亚文'                                           => 'hy',
    '亚美尼亚语'                                           => 'rup',
    '亚齐文'                                                 => 'ace',
    '伊乔文'                                                 => 'ijo',
    '伊努伊特文'                                           => 'iu',
    '伊多文'                                                 => 'io',
    '伊朗文'                                                 => 'ira',
    '伊格博文'                                              => 'ig',
    '伊洛干诺文'                                           => 'ilo',
    '伊洛魁语系'                                           => 'iro',
    '伊班文'                                                 => 'iba',
    '伊纳里萨米语'                                        => 'smn',
    '低地德文；低地撒克逊文'                         => 'nds',
    '佩瓦扬文'                                              => 'chp',
    '依伯利亚葡萄牙文'                                  => 'pt_pt',
    '依地文'                                                 => 'yi',
    '依奴皮维克文'                                        => 'ik',
    '俄文'                                                    => 'ru',
    '俄日亚文'                                              => 'myv',
    '保加利亚文'                                           => 'bg',
    '信德文'                                                 => 'sd',
    '俾路支文'                                              => 'bal',
    '傣语诸语言（其他）'                               => 'tai',
    '僧伽罗文'                                              => 'si',
    '克什米尔文'                                           => 'ks',
    '克佩列文'                                              => 'kpe',
    '克林贡文'                                              => 'tlh',
    '克罗地亚文'                                           => 'hr',
    '克里克文'                                              => 'mus',
    '克里族文'                                              => 'cr',
    '克里米亚土耳其文；克里米亚塔塔文'          => 'crh',
    '克鲁文'                                                 => 'kro',
    '兰巴文'                                                 => 'lam',
    '其他中美印第安语系'                               => 'cai',
    '其他亚非语系'                                        => 'afa',
    '其他人工语系'                                        => 'art',
    '其他以法文为基础的克里奥尔混合语系'       => 'cpf',
    '其他以英文为基础的克里奥尔混合语系'       => 'cpe',
    '其他以葡萄牙文为基础的克里奥尔混合语系' => 'cpp',
    '其他克里奥尔混合语系'                            => 'crp',
    '其他凯尔特语系'                                     => 'cel',
    '其他北美印第安语系'                               => 'nai',
    '其他南美印第安文'                                  => 'sai',
    '其他印度语系'                                        => 'inc',
    '其他印欧语系'                                        => 'ine',
    '其他孟高棉语系'                                     => 'mkh',
    '其他尼日尔科尔多凡语系'                         => 'nic',
    '其他巴布亚文'                                        => 'paa',
    '其他库施特语系'                                     => 'cus',
    '其他德拉维语系'                                     => 'dra',
    '其他拉丁语系'                                        => 'roa',
    '其他斯拉夫语系'                                     => 'sla',
    '其他日尔曼语系'                                     => 'gem',
    '其他汉藏语系'                                        => 'sit',
    '其他波罗的语系'                                     => 'bat',
    '其他科伊桑语系'                                     => 'khi',
    '其他芬兰乌戈尔语系'                               => 'fiu',
    '其他菲律宾语系'                                     => 'phi',
    '其他萨米文'                                           => 'smi',
    '其他闪族语系'                                        => 'sem',
    '其他阿尔贡语系'                                     => 'alg',
    '其他高加索语系'                                     => 'cau',
    '冰岛文'                                                 => 'is',
    '凯尔特文'                                              => 'kw',
    '刚卡尼文'                                              => 'kok',
    '刚果文'                                                 => 'kg',
    '别姆巴文'                                              => 'bem',
    '别札文'                                                 => 'bej',
    '加利西亚文'                                           => 'gl',
    '加拿大法语'                                           => 'fr_ca',
    '加拿大英语'                                           => 'en_ca',
    '加文'                                                    => 'gaa',
    '加泰罗尼亚文'                                        => 'ca',
    '努比亚语系'                                           => 'nub',
    '匈牙利文'                                              => 'hu',
    '北弗里西亚语'                                        => 'frr',
    '北恩德贝勒文'                                        => 'nd',
    '北索托文'                                              => 'nso',
    '北萨米文'                                              => 'se',
    '南恩德贝勒文'                                        => 'nr',
    '南索托文'                                              => 'st',
    '南萨米文'                                              => 'sma',
    '南阿尔泰文'                                           => 'alt',
    '南非荷兰文'                                           => 'af',
    '博杰普尔文'                                           => 'bho',
    '卡努里文'                                              => 'kr',
    '卡多文'                                                 => 'cad',
    '卡姆巴文'                                              => 'kam',
    '卡威文'                                                 => 'kaw',
    '卡尔梅克文'                                           => 'xal',
    '卡巴尔达文'                                           => 'kbd',
    '卡拉卡尔帕克文'                                     => 'kaa',
    '卡拉恰伊巴尔卡尔文'                               => 'krc',
    '卡比尔文'                                              => 'kab',
    '卡琴文'                                                 => 'kac',
    '卡累利阿文'                                           => 'krl',
    '卡舒文'                                                 => 'csb',
    '卡西文'                                                 => 'kha',
    '卢奥文'                                                 => 'luo',
    '卢干达文'                                              => 'lg',
    '卢旺达文'                                              => 'rw',
    '卢晒文'                                                 => 'lus',
    '卢森堡文'                                              => 'lb',
    '印古什文'                                              => 'inh',
    '印地文'                                                 => 'hi',
    '印度尼西亚文'                                        => 'id',
    '叙利亚文'                                              => 'syr',
    '古加拉提文'                                           => 'gu',
    '古埃及文'                                              => 'egy',
    '古希腊文'                                              => 'grc',
    '古法文'                                                 => 'fro',
    '古爱尔兰文'                                           => 'sga',
    '古粟特语'                                              => 'sog',
    '古老波斯语'                                           => 'peo',
    '古英文'                                                 => 'ang',
    '古诺尔斯文'                                           => 'non',
    '古高地德文'                                           => 'goh',
    '司克司卡文'                                           => 'bla',
    '司雷夫文'                                              => 'den',
    '各种不同语系'                                        => 'mis',
    '吉兹文'                                                 => 'gez',
    '吉尔伯特斯文'                                        => 'gil',
    '吉尔吉斯文'                                           => 'ky',
    '吉库尤文'                                              => 'ki',
    '吉普赛文'                                              => 'rom',
    '吉维克琴文'                                           => 'gwi',
    '和田文'                                                 => 'kho',
    '哈萨克文'                                              => 'kk',
    '哥特文'                                                 => 'got',
    '喀伦文'                                                 => 'kar',
    '四川彝文'                                              => 'ii',
    '国际语'                                                 => 'ia',
    '国际语（e）'                                          => 'ie',
    '图瓦卢文'                                              => 'tvl',
    '图瓦文'                                                 => 'tyv',
    '图皮语系'                                              => 'tup',
    '土库曼文'                                              => 'tk',
    '土耳其文'                                              => 'tr',
    '坎纳达文'                                              => 'kn',
    '埃克丘克文'                                           => 'eka',
    '埃维文'                                                 => 'ee',
    '埃菲克文'                                              => 'efi',
    '基隆迪文'                                              => 'rn',
    '塔加洛语'                                              => 'tl',
    '塔吉克文'                                              => 'tg',
    '塔塔尔文'                                              => 'tt',
    '塔西提文'                                              => 'ty',
    '塔马奇克文'                                           => 'tmh',
    '塞尔库普文'                                           => 'sel',
    '塞尔维亚克罗地亚文'                               => 'sh',
    '塞尔维亚文'                                           => 'sr',
    '塞茨瓦纳文'                                           => 'tn',
    '壮语'                                                    => 'za',
    '夏威夷文'                                              => 'haw',
    '夏延文'                                                 => 'chy',
    '多格拉文'                                              => 'doi',
    '多格里布文'                                           => 'dgr',
    '多种语系'                                              => 'mul',
    '夫拉文'                                                 => 'ff',
    '契努克文'                                              => 'chn',
    '契布卡文'                                              => 'chb',
    '奥克西唐语'                                           => 'oc',
    '奥吉布瓦文'                                           => 'oj',
    '奥地利德语'                                           => 'de_at',
    '奥塞梯文'                                              => 'os',
    '奥托曼土耳其文'                                     => 'ota',
    '奥托米语系'                                           => 'oto',
    '奥洛莫文'                                              => 'om',
    '奥萨格文'                                              => 'osa',
    '威尔士文'                                              => 'cy',
    '孟加拉文'                                              => 'bn',
    '宗加文'                                                 => 'ts',
    '宗教斯拉夫文'                                        => 'cu',
    '宽亚玛文'                                              => 'kj',
    '宿务文'                                                 => 'ceb',
    '尤皮克诸语言'                                        => 'ypk',
    '尼亚姆韦齐文'                                        => 'nym',
    '尼亚斯文'                                              => 'nia',
    '尼扬扎文'                                              => 'ny',
    '尼昂科勒文'                                           => 'nyn',
    '尼泊尔文'                                              => 'ne',
    '尼瓦尔文'                                              => 'new',
    '尼瓦尔文（classicalnewari）'                         => 'nwc',
    '尼约罗文'                                              => 'nyo',
    '岗德文'                                                 => 'gon',
    '巴什客尔文'                                           => 'ba',
    '巴利文'                                                 => 'pi',
    '巴勒比文'                                              => 'car',
    '巴塔克文'                                              => 'btk',
    '巴斯克文'                                              => 'eu',
    '巴米累克语系'                                        => 'bai',
    '巴萨文'                                                 => 'bas',
    '巴里文'                                                 => 'ban',
    '巽他语'                                                 => 'su',
    '布吉文'                                                 => 'bug',
    '布拉杰文'                                              => 'bra',
    '布林文'                                                 => 'byn',
    '布里亚特文'                                           => 'bua',
    '布里多尼文'                                           => 'br',
    '希伯来文'                                              => 'he',
    '希利盖农文'                                           => 'hil',
    '希腊文'                                                 => 'el',
    '希里莫图文'                                           => 'ho',
    '帕劳文'                                                 => 'pau',
    '帕拉维文'                                              => 'pal',
    '帕皮亚门托文'                                        => 'pap',
    '库尔德文'                                              => 'ku',
    '库梅克文'                                              => 'kum',
    '库特内文'                                              => 'kut',
    '库鲁克文'                                              => 'kru',
    '弗拉芒语'                                              => 'nl_be',
    '弗留利文'                                              => 'fur',
    '彻罗基文'                                              => 'chr',
    '律勒欧萨莫斯语'                                     => 'smj',
    '德文'                                                    => 'de',
    '恩东加文'                                              => 'ng',
    '恩济马文'                                              => 'nzi',
    '悉达摩文'                                              => 'sid',
    '意大利文'                                              => 'it',
    '手语'                                                    => 'sgn',
    '扎扎文'                                                 => 'zza',
    '托克劳文'                                              => 'tkl',
    '托克皮辛文'                                           => 'tpi',
    '拉丁文'                                                 => 'la',
    '拉亨达文'                                              => 'lah',
    '拉帕努伊文'                                           => 'rap',
    '拉罗汤加文'                                           => 'rar',
    '拉脱维亚文'                                           => 'lv',
    '拉贾斯坦文'                                           => 'raj',
    '拉迪诺文'                                              => 'lad',
    '拿波里文'                                              => 'nap',
    '挪威博克马尔文'                                     => 'nb',
    '挪威尼诺斯克文'                                     => 'nn',
    '挪威文'                                                 => 'no',
    '捷克文'                                                 => 'cs',
    '掸文'                                                    => 'shn',
    '提格里尼亚文'                                        => 'ti',
    '提格雷文'                                              => 'tig',
    '摩尔多瓦文'                                           => 'mo',
    '摩霍克文'                                              => 'moh',
    '散达维文'                                              => 'sad',
    '文达文'                                                 => 've',
    '斐济文'                                                 => 'fj',
    '斯洛伐克文'                                           => 'sk',
    '斯洛文尼亚文'                                        => 'sl',
    '斯瓦希里文'                                           => 'sw',
    '斯瓦特文'                                              => 'ss',
    '斯科特萨米文'                                        => 'sms',
    '旁遮普文'                                              => 'pa',
    '无语言内容'                                           => 'zxx',
    '日文'                                                    => 'ja',
    '旺杜文'                                                 => 'ewo',
    '昂加语'                                                 => 'anp',
    '普什图文'                                              => 'ps',
    '普拉克里特诸语言'                                  => 'pra',
    '普罗文斯文'                                           => 'pro',
    '曼丁哥文'                                              => 'man',
    '曼尼普里文'                                           => 'mni',
    '曼达尔'                                                 => 'mdr',
    '望加锡文'                                              => 'mak',
    '未知语言'                                              => 'und',
    '林加拉文'                                              => 'ln',
    '柏柏尔文'                                              => 'ber',
    '查加文'                                                 => 'chg',
    '查米克文'                                              => 'cmc',
    '查莫罗文'                                              => 'ch',
    '柬埔寨文'                                              => 'km',
    '格列博文'                                              => 'grb',
    '格陵兰文'                                              => 'kl',
    '格鲁吉亚文'                                           => 'ka',
    '桑塔利文'                                              => 'sat',
    '桑戈文'                                                 => 'sg',
    '桑海文'                                                 => 'son',
    '梵文'                                                    => 'sa',
    '楚吾克文'                                              => 'chk',
    '楚瓦什文'                                              => 'cv',
    '欧里亚文'                                              => 'or',
    '比哈尔文'                                              => 'bh',
    '比尼文'                                                 => 'bin',
    '比斯拉马文'                                           => 'bi',
    '毕库尔文'                                              => 'bik',
    '毛利文'                                                 => 'mi',
    '汤加文'                                                 => 'to',
    '汤加文（尼亚萨地区）'                            => 'tog',
    '沃拉普克文'                                           => 'vo',
    '沃提克文'                                              => 'vot',
    '沃洛夫文'                                              => 'wo',
    '法文'                                                    => 'fr',
    '法罗文'                                                 => 'fo',
    '波兰文'                                                 => 'pl',
    '波斯尼亚文'                                           => 'bs',
    '波斯文'                                                 => 'fa',
    '波纳佩文'                                              => 'pon',
    '泰卢固文'                                              => 'te',
    '泰文'                                                    => 'th',
    '泰米尔文'                                              => 'ta',
    '泽纳加文'                                              => 'zen',
    '洛兹文'                                                 => 'loz',
    '海地文'                                                 => 'ht',
    '海达文'                                                 => 'hai',
    '淋布尔吉文'                                           => 'li',
    '滕内语'                                                 => 'tem',
    '满文'                                                    => 'mnc',
    '澳大利亚语系'                                        => 'aus',
    '澳斯特罗尼西亚语系'                               => 'map',
    '爪哇文'                                                 => 'jv',
    '爱尔兰文'                                              => 'ga',
    '爱沙尼亚文'                                           => 'et',
    '特列纳文'                                              => 'ter',
    '特塔姆文'                                              => 'tet',
    '特威文'                                                 => 'tw',
    '特拉华文'                                              => 'del',
    '特林吉特文'                                           => 'tli',
    '犹太波斯文'                                           => 'jpr',
    '犹太阿拉伯文'                                        => 'jrb',
    '玛雅语系'                                              => 'myn',
    '班图文'                                                 => 'bnt',
    '班巴拉文'                                              => 'bm',
    '班达文'                                                 => 'bad',
    '瑙鲁文'                                                 => 'na',
    '瑞典文'                                                 => 'sv',
    '瑞士德文'                                              => 'gsw',
    '瑞士法语'                                              => 'fr_ch',
    '瑞士高地德文'                                        => 'de_ch',
    '瑶族文'                                                 => 'yao',
    '瓜拉尼文'                                              => 'gn',
    '瓦伊文'                                                 => 'vai',
    '瓦卡什诸语言'                                        => 'wak',
    '瓦拉莫文'                                              => 'wal',
    '瓦绍文'                                                 => 'was',
    '瓦赖文'                                                 => 'war',
    '瓦隆文'                                                 => 'wa',
    '白俄罗斯文'                                           => 'be',
    '盖丘亚文'                                              => 'qu',
    '祖尼语'                                                 => 'zun',
    '祖鲁文'                                                 => 'zu',
    '科摩罗语'                                              => 'swb',
    '科斯拉伊文'                                           => 'kos',
    '科普特文'                                              => 'cop',
    '科洛涅达罗文'                                        => 'gor',
    '科米文'                                                 => 'kv',
    '科罗语'                                                 => 'kfo',
    '科萨文'                                                 => 'xh',
    '科西嘉文'                                              => 'co',
    '立陶宛文'                                              => 'lt',
    '米克马克文'                                           => 'mic',
    '米兰德斯文'                                           => 'mwl',
    '米南卡保文'                                           => 'min',
    '粤语'                                                    => 'yue',
    '索尼基文'                                              => 'snk',
    '索布诸语言'                                           => 'wen',
    '索马里文'                                              => 'so',
    '约鲁巴文'                                              => 'yo',
    '纳瓦特尔文'                                           => 'nah',
    '纳瓦霍文'                                              => 'nv',
    '纽埃文'                                                 => 'niu',
    '绍纳文'                                                 => 'sn',
    '维吾尔文'                                              => 'ug',
    '缅甸文'                                                 => 'my',
    '罗曼什文'                                              => 'rm',
    '罗马尼亚文'                                           => 'ro',
    '翁本杜文'                                              => 'umb',
    '老挝文'                                                 => 'lo',
    '胡帕文'                                                 => 'hup',
    '腓尼基文'                                              => 'phn',
    '艾拉米特文'                                           => 'elx',
    '艾马拉文'                                              => 'ay',
    '芒戈文'                                                 => 'lol',
    '芬兰文'                                                 => 'fi',
    '芳格文'                                                 => 'fan',
    '芳蒂文'                                                 => 'fat',
    '苏库马文'                                              => 'suk',
    '苏格兰文'                                              => 'sco',
    '苏格兰盖尔文'                                        => 'gd',
    '苏苏文'                                                 => 'sus',
    '苏语诸语言'                                           => 'sio',
    '苏里南汤加语'                                        => 'srn',
    '苏马文'                                                 => 'sux',
    '英文'                                                    => 'en',
    '英语（澳大利亚）'                                  => 'en_au',
    '英语（美国）'                                        => 'en_us',
    '英语（英国）'                                        => 'en_gb',
    '荷兰文'                                                 => 'nl',
    '莫克沙文'                                              => 'mdf',
    '莫西文'                                                 => 'mos',
    '莱兹依昂文'                                           => 'lez',
    '菲律宾文'                                              => 'fil',
    '萨丁文'                                                 => 'sc',
    '萨伊语'                                                 => 'mas',
    '萨利什文'                                              => 'sal',
    '萨摩亚文'                                              => 'sm',
    '萨波蒂克文'                                           => 'zap',
    '萨玛利亚文'                                           => 'sam',
    '萨萨克文'                                              => 'sas',
    '葛巴亚文'                                              => 'gba',
    '葡萄牙文'                                              => 'pt',
    '葡萄牙语（巴西）'                                  => 'pt_br',
    '蒂夫文'                                                 => 'tiv',
    '蒂姆西亚文'                                           => 'tsi',
    '蒙古文'                                                 => 'mn',
    '蒙达语系'                                              => 'mun',
    '藏文'                                                    => 'bo',
    '西弗里西亚文'                                        => 'fy',
    '西班牙文'                                              => 'es',
    '西班牙语（伊比利亚）'                            => 'es_es',
    '西西里文'                                              => 'scn',
    '西非书面语言'                                        => 'nqo',
    '诺盖文'                                                 => 'nog',
    '谢列尔文'                                              => 'srr',
    '豪撒文'                                                 => 'ha',
    '赞德文'                                                 => 'znd',
    '赫梯文'                                                 => 'hit',
    '赫蒙文'                                                 => 'hmn',
    '赫雷罗文'                                              => 'hz',
    '赫马查利文'                                           => 'him',
    '越南文'                                                 => 'vi',
    '路易塞诺文'                                           => 'lui',
    '车臣文'                                                 => 'ce',
    '达尔格瓦文'                                           => 'dar',
    '达科他文'                                              => 'dak',
    '达雅克文'                                              => 'day',
    '迈蒂利文'                                              => 'mai',
    '迦约文'                                                 => 'gay',
    '迪尤拉文'                                              => 'dyu',
    '迪维希文'                                              => 'dv',
    '通布卡文'                                              => 'tum',
    '逻辑文'                                                 => 'jbo',
    '邦板牙文'                                              => 'pam',
    '邦阿西楠语'                                           => 'pag',
    '都阿拉文'                                              => 'dua',
    '金邦杜文'                                              => 'kmb',
    '门迪文'                                                 => 'men',
    '阿乔利文'                                              => 'ach',
    '阿伊努文'                                              => 'ain',
    '阿劳坎文'                                              => 'arn',
    '阿卡德文'                                              => 'akk',
    '阿塞拜疆文'                                           => 'az',
    '阿姆哈拉文'                                           => 'am',
    '阿尔巴尼亚文'                                        => 'sq',
    '阿尔泰诸语言（其他）'                            => 'tut',
    '阿布哈西亚文'                                        => 'ab',
    '阿帕切文'                                              => 'apa',
    '阿弗里希利文'                                        => 'afh',
    '阿当梅文'                                              => 'ada',
    '阿拉伯文'                                              => 'ar',
    '阿拉帕霍文'                                           => 'arp',
    '阿拉瓦克文'                                           => 'arw',
    '阿拉米文'                                              => 'arc',
    '阿拉贡文'                                              => 'an',
    '阿斯图里亚思特文'                                  => 'ast',
    '阿法文'                                                 => 'aa',
    '阿瓦乔文'                                              => 'awa',
    '阿瓦尔文'                                              => 'av',
    '阿留申文'                                              => 'ale',
    '阿维斯塔文'                                           => 'ae',
    '阿肯文'                                                 => 'ak',
    '阿萨姆文'                                              => 'as',
    '阿萨帕斯坎语系'                                     => 'ath',
    '阿迪何文'                                              => 'ady',
    '隆达文'                                                 => 'lun',
    '雅库特文'                                              => 'sah',
    '雅浦文'                                                 => 'yap',
    '非洲撒哈拉沙漠边缘地带语言'                   => 'ssa',
    '韩文'                                                    => 'ko',
    '马其顿文'                                              => 'mk',
    '马加伊文'                                              => 'mag',
    '马尔加什文'                                           => 'mg',
    '马尔瓦利文'                                           => 'mwr',
    '马恩岛文'                                              => 'gv',
    '马拉地文'                                              => 'mr',
    '马来亚拉姆文'                                        => 'ml',
    '马来文'                                                 => 'ms',
    '马绍尔文'                                              => 'mh',
    '马耳他文'                                              => 'mt',
    '马诺博语系'                                           => 'mno',
    '马都拉文'                                              => 'mad',
    '马里文'                                                 => 'chm',
    '鲁巴加丹加文'                                        => 'lu',
    '鲁巴鲁瓦文'                                           => 'lua',
);

1;
