package Locales::DB::Language::yo;

# Auto generated from CLDR

$Locales::DB::Language::yo::VERSION = '0.07';

$Locales::DB::Language::yo::cldr_version = '2.0';

%Locales::DB::Language::yo::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Language\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ and\ \{1\}",
            'end'    => "\{0\}\,\ and\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => "\'",
        'alternate_quotation_start' => "\'",
        'quotation_end'             => "\'",
        'quotation_start'           => "\'"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list'  => ['other'],
        'category_rules' => {}
    },
    'posix' => {
        'nostr'  => "Bẹ́ẹ̀kọ́\:K",
        'yesstr' => "Bẹ́ẹ̀ni\ \:N"
    },
);

%Locales::DB::Language::yo::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhazian',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => "Èdè\ Afrikani",
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'Ainu',
    'ak'    => "Èdè\ Akani",
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => "Èdè\ Amariki",
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => "Èdè\ Arabiki",
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => "Ti\ Assam",
    'asa'   => 'Asu',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => "Èdè\ Azerbaijani",
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basaa',
    'bat'   => "Baltic\ Language",
    'be'    => "Èdè\ Belarusi",
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bez'   => 'Bena',
    'bg'    => "Èdè\ Bugaria",
    'bh'    => "Èdè\ Bihari",
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => "Èdè\ Bengali",
    'bnt'   => 'Bantu',
    'bo'    => 'Tibetan',
    'br'    => "Èdè\ Bretoni",
    'bra'   => 'Braj',
    'brx'   => 'Bodo',
    'bs'    => "Èdè\ Bosnia",
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => "Èdè\ Catala",
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'cgg'   => 'Chiga',
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => "Èdè\ seeki",
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => "Èdè\ Welshi",
    'da'    => "Èdè\ Ilẹ̀\ Denmark",
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'dav'   => 'Taita',
    'day'   => 'Dayak',
    'de'    => "Èdè\ Ilẹ̀\ Gemani",
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'Zarma',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ebu'   => 'Embu',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => "Èdè\ Giriki",
    'elx'   => 'Elamite',
    'en'    => "Èdè\ Gẹ̀ẹ́sì",
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Middle\ English",
    'eo'    => "Èdè\ Esperanto",
    'es'    => "Èdè\ Sipanisi",
    'es_es' => "Iberian\ Spanish",
    'et'    => "Èdè\ Estonia",
    'eu'    => "Èdè\ Baski",
    'ewo'   => 'Ewondo',
    'fa'    => "Èdè\ Pasia",
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => "Èdè\ Finisi",
    'fil'   => "Èdè\ Tagalogi",
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'Fijian',
    'fo'    => "Èdè\ Faroesi",
    'fon'   => 'Fon',
    'fr'    => "Èdè\ Faransé",
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => "Èdè\ Frisia",
    'ga'    => "Èdè\ Ireland",
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Èdè\ Gaelik\ ti\ Ilu\ Scotland",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => "Èdè\ Galicia",
    'gmh'   => "Middle\ High\ German",
    'gn'    => "Èdè\ Guarani",
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => "Èdè\ Gujarati",
    'guz'   => 'Gusii',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => "Èdè\ Hausa",
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => "Èdè\ Heberu",
    'hi'    => "Èdè\ Hindi",
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => "Èdè\ Kroatia",
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => "Èdè\ Hungaria",
    'hup'   => 'Hupa',
    'hy'    => "Èdè\ Ile\ Armenia",
    'hz'    => 'Herero',
    'ia'    => "Èdè\ pipo",
    'iba'   => 'Iban',
    'id'    => "Èdè\ Indonasia",
    'ie'    => "Iru\ Èdè",
    'ig'    => "Èdè\ Ibo",
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => "Èdè\ Icelandic",
    'it'    => "Èdè\ Italiani",
    'iu'    => 'Inuktitut',
    'ja'    => "Èdè\ Japanisi",
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => "Èdè\ Javanasi",
    'ka'    => "Èdè\ Georgia",
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakh',
    'kl'    => 'Kalaallisut',
    'kln'   => 'Kalenjin',
    'km'    => "Èdè\ kameri",
    'kmb'   => 'Kimbundu',
    'kn'    => "Èdè\ Kannada",
    'ko'    => "Èdè\ Koria",
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'Kurdish',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'Kirghiz',
    'la'    => "Èdè\ Latini",
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'Lingala',
    'lo'    => 'Lao',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => "Èdè\ Lithuania",
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'luy'   => 'Luyia',
    'lv'    => "Èdè\ Latvianu",
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasy',
    'mga'   => "Middle\ Irish",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => "Èdè\ Macedonia",
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'Malayalam',
    'mn'    => 'Mongolian',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => "Èdè\ marathi",
    'ms'    => "Èdè\ Malaya",
    'mt'    => "Èdè\ Malta",
    'mua'   => 'Mundang',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => "Èdè\ Bumiisi",
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'naq'   => 'Nama',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => "Èdè\ Nepali",
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => "Èdè\ Duki",
    'nl_be' => 'Flemish',
    'nmg'   => 'Kwasio',
    'nn'    => "Norwegian\ Nynorsk",
    'no'    => "Èdè\ Norway",
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nus'   => 'Nuer',
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => "Èdè\ Occitani",
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Oriya',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => "Èdè\ Punjabi",
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => "Èdè\ Ilẹ̀\ Polandi",
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'Pushto',
    'pt'    => "Èdè\ Pọtugi",
    'pt_br' => "Brazilian\ Portuguese",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => 'Romansh',
    'rn'    => 'Rundi',
    'ro'    => "Èdè\ Romania",
    'roa'   => "Romance\ Language",
    'rof'   => 'Rombo',
    'rom'   => 'Romany',
    'ru'    => "Èdè\ ̣Rọọsia",
    'rup'   => 'Aromanian',
    'rw'    => "Èdè\ Ruwanda",
    'rwk'   => 'Rwa',
    'sa'    => "Èdè\ awon\ ara\ Indo",
    'sad'   => 'Sandawe',
    'sah'   => 'Sakha',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => "Èdè\ Sindhi",
    'se'    => "Northern\ Sami",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "Èdè\ Serbo\-Croatiani",
    'shi'   => 'Tachelhit',
    'shn'   => 'Shan',
    'si'    => "Èdè\ Sinhalese",
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => "Èdè\ Slovaki",
    'sl'    => "Èdè\ Slovenia",
    'sla'   => "Slavic\ Language",
    'sm'    => 'Samoan',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => "Èdè\ ara\ Somalia",
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => "Èdè\ Albania",
    'sr'    => "Èdè\ Serbia",
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'ssy'   => 'Saho',
    'st'    => "Èdè\ Sesoto",
    'su'    => "Èdè\ Sudani",
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => "Èdè\ Suwidiisi",
    'sw'    => "Èdè\ Swahili",
    'swb'   => 'Comorian',
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => "Èdè\ Tamili",
    'tai'   => "Tai\ Language",
    'te'    => "Èdè\ Telugu",
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajik',
    'th'    => "Èdè\ Tai",
    'ti'    => "Èdè\ Tigrinya",
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => "Èdè\ Turkmen",
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => "Èdè\ Klingoni",
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => "Èdè\ Tọọkisi",
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Twi',
    'twq'   => 'Tasawaq',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurt',
    'ug'    => 'Uyghur',
    'uga'   => 'Ugaritic',
    'uk'    => "Èdè\ Ukania",
    'umb'   => 'Umbundu',
    'und'   => "Unknown\ Language",
    'ur'    => "Èdè\ Udu",
    'uz'    => "Èdè\ Uzbek",
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => "Èdè\ Jetinamu",
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'vun'   => 'Vunjo',
    'wa'    => 'Walloon',
    'wae'   => 'Walser',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => "Èdè\ Xhosa",
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yav'   => 'Yangben',
    'yi'    => "Èdè\ Yiddishi",
    'yo'    => "Èdè\ Yorùbá",
    'ypk'   => "Yupik\ Language",
    'yue'   => 'Cantonese',
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => "Èdè\ Mandari",
    'znd'   => 'Zande',
    'zu'    => "Èdè\ Ṣulu",
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::yo::name_to_code = (
    'abkhazian'                     => 'ab',
    'achinese'                      => 'ace',
    'acoli'                         => 'ach',
    'adangme'                       => 'ada',
    'adyghe'                        => 'ady',
    'afar'                          => 'aa',
    'afrihili'                      => 'afh',
    'afroasiaticlanguage'           => 'afa',
    'aghem'                         => 'agq',
    'ainu'                          => 'ain',
    'akkadian'                      => 'akk',
    'aleut'                         => 'ale',
    'algonquianlanguage'            => 'alg',
    'altaiclanguage'                => 'tut',
    'ancientegyptian'               => 'egy',
    'ancientgreek'                  => 'grc',
    'angika'                        => 'anp',
    'apachelanguage'                => 'apa',
    'aragonese'                     => 'an',
    'aramaic'                       => 'arc',
    'arapaho'                       => 'arp',
    'araucanian'                    => 'arn',
    'arawak'                        => 'arw',
    'aromanian'                     => 'rup',
    'artificiallanguage'            => 'art',
    'asturian'                      => 'ast',
    'asu'                           => 'asa',
    'athapascanlanguage'            => 'ath',
    'atsam'                         => 'cch',
    'australianenglish'             => 'en_au',
    'australianlanguage'            => 'aus',
    'austriangerman'                => 'de_at',
    'austronesianlanguage'          => 'map',
    'avaric'                        => 'av',
    'avestan'                       => 'ae',
    'awadhi'                        => 'awa',
    'aymara'                        => 'ay',
    'bafia'                         => 'ksf',
    'balinese'                      => 'ban',
    'balticlanguage'                => 'bat',
    'baluchi'                       => 'bal',
    'bambara'                       => 'bm',
    'bamilekelanguage'              => 'bai',
    'banda'                         => 'bad',
    'bantu'                         => 'bnt',
    'basaa'                         => 'bas',
    'bashkir'                       => 'ba',
    'batak'                         => 'btk',
    'beja'                          => 'bej',
    'bemba'                         => 'bem',
    'bena'                          => 'bez',
    'berber'                        => 'ber',
    'bhojpuri'                      => 'bho',
    'bikol'                         => 'bik',
    'bini'                          => 'bin',
    'bislama'                       => 'bi',
    'blin'                          => 'byn',
    'blissymbols'                   => 'zbl',
    'bodo'                          => 'brx',
    'braj'                          => 'bra',
    'brazilianportuguese'           => 'pt_br',
    'britishenglish'                => 'en_gb',
    'buginese'                      => 'bug',
    'buriat'                        => 'bua',
    'caddo'                         => 'cad',
    'canadianenglish'               => 'en_ca',
    'canadianfrench'                => 'fr_ca',
    'cantonese'                     => 'yue',
    'carib'                         => 'car',
    'caucasianlanguage'             => 'cau',
    'cayuga'                        => 'cay',
    'cebuano'                       => 'ceb',
    'celticlanguage'                => 'cel',
    'centralamericanindianlanguage' => 'cai',
    'centralmoroccotamazight'       => 'tzm',
    'chagatai'                      => 'chg',
    'chamiclanguage'                => 'cmc',
    'chamorro'                      => 'ch',
    'chechen'                       => 'ce',
    'cherokee'                      => 'chr',
    'cheyenne'                      => 'chy',
    'chibcha'                       => 'chb',
    'chiga'                         => 'cgg',
    'chinookjargon'                 => 'chn',
    'chipewyan'                     => 'chp',
    'choctaw'                       => 'cho',
    'churchslavic'                  => 'cu',
    'chuukese'                      => 'chk',
    'chuvash'                       => 'cv',
    'classicalnewari'               => 'nwc',
    'classicalsyriac'               => 'syc',
    'colognian'                     => 'ksh',
    'comorian'                      => 'swb',
    'congoswahili'                  => 'swc',
    'coptic'                        => 'cop',
    'cornish'                       => 'kw',
    'corsican'                      => 'co',
    'cree'                          => 'cr',
    'creek'                         => 'mus',
    'creoleorpidgin'                => 'crp',
    'crimeanturkish'                => 'crh',
    'cushiticlanguage'              => 'cus',
    'dakota'                        => 'dak',
    'dargwa'                        => 'dar',
    'dayak'                         => 'day',
    'delaware'                      => 'del',
    'dinka'                         => 'din',
    'divehi'                        => 'dv',
    'dogri'                         => 'doi',
    'dogrib'                        => 'dgr',
    'dravidianlanguage'             => 'dra',
    'duala'                         => 'dua',
    'dyula'                         => 'dyu',
    'dzongkha'                      => 'dz',
    'easternfrisian'                => 'frs',
    'efik'                          => 'efi',
    'ekajuk'                        => 'eka',
    'elamite'                       => 'elx',
    'embu'                          => 'ebu',
    'englishbasedcreoleorpidgin'    => 'cpe',
    'erzya'                         => 'myv',
    'ewe'                           => 'ee',
    'ewondo'                        => 'ewo',
    'fang'                          => 'fan',
    'fanti'                         => 'fat',
    'fijian'                        => 'fj',
    'finnougrianlanguage'           => 'fiu',
    'flemish'                       => 'nl_be',
    'fon'                           => 'fon',
    'frenchbasedcreoleorpidgin'     => 'cpf',
    'friulian'                      => 'fur',
    'fulah'                         => 'ff',
    'ga'                            => 'gaa',
    'ganda'                         => 'lg',
    'gayo'                          => 'gay',
    'gbaya'                         => 'gba',
    'geez'                          => 'gez',
    'germaniclanguage'              => 'gem',
    'gilbertese'                    => 'gil',
    'gondi'                         => 'gon',
    'gorontalo'                     => 'gor',
    'gothic'                        => 'got',
    'grebo'                         => 'grb',
    'gusii'                         => 'guz',
    "gwich\Ê\¼in"                 => 'gwi',
    'haida'                         => 'hai',
    'haitian'                       => 'ht',
    'hawaiian'                      => 'haw',
    'herero'                        => 'hz',
    'hiligaynon'                    => 'hil',
    'himachali'                     => 'him',
    'hirimotu'                      => 'ho',
    'hittite'                       => 'hit',
    'hmong'                         => 'hmn',
    'hupa'                          => 'hup',
    'iban'                          => 'iba',
    'iberianportuguese'             => 'pt_pt',
    'iberianspanish'                => 'es_es',
    'ido'                           => 'io',
    'ijo'                           => 'ijo',
    'iloko'                         => 'ilo',
    'inarisami'                     => 'smn',
    'indiclanguage'                 => 'inc',
    'indoeuropeanlanguage'          => 'ine',
    'ingush'                        => 'inh',
    'inuktitut'                     => 'iu',
    'inupiaq'                       => 'ik',
    'iranianlanguage'               => 'ira',
    'iroquoianlanguage'             => 'iro',
    'iruÈdè'                      => 'ie',
    'jju'                           => 'kaj',
    'jolafonyi'                     => 'dyo',
    'judeoarabic'                   => 'jrb',
    'judeopersian'                  => 'jpr',
    'kabardian'                     => 'kbd',
    'kabuverdianu'                  => 'kea',
    'kabyle'                        => 'kab',
    'kachin'                        => 'kac',
    'kalaallisut'                   => 'kl',
    'kalenjin'                      => 'kln',
    'kalmyk'                        => 'xal',
    'kamba'                         => 'kam',
    'kanuri'                        => 'kr',
    'karachaybalkar'                => 'krc',
    'karakalpak'                    => 'kaa',
    'karelian'                      => 'krl',
    'karen'                         => 'kar',
    'kashmiri'                      => 'ks',
    'kashubian'                     => 'csb',
    'kawi'                          => 'kaw',
    'kazakh'                        => 'kk',
    'khasi'                         => 'kha',
    'khoisanlanguage'               => 'khi',
    'khotanese'                     => 'kho',
    'kikuyu'                        => 'ki',
    'kimbundu'                      => 'kmb',
    'kirghiz'                       => 'ky',
    'komi'                          => 'kv',
    'kongo'                         => 'kg',
    'konkani'                       => 'kok',
    'koro'                          => 'kfo',
    'kosraean'                      => 'kos',
    'koyraborosenni'                => 'ses',
    'koyrachiini'                   => 'khq',
    'kpelle'                        => 'kpe',
    'kru'                           => 'kro',
    'kuanyama'                      => 'kj',
    'kumyk'                         => 'kum',
    'kurdish'                       => 'ku',
    'kurukh'                        => 'kru',
    'kutenai'                       => 'kut',
    'kwasio'                        => 'nmg',
    'ladino'                        => 'lad',
    'lahnda'                        => 'lah',
    'lamba'                         => 'lam',
    'langi'                         => 'lag',
    'lao'                           => 'lo',
    'lezghian'                      => 'lez',
    'limburgish'                    => 'li',
    'lingala'                       => 'ln',
    'lojban'                        => 'jbo',
    'lowersorbian'                  => 'dsb',
    'lowgerman'                     => 'nds',
    'lozi'                          => 'loz',
    'lubakatanga'                   => 'lu',
    'lubalulua'                     => 'lua',
    'luiseno'                       => 'lui',
    'lulesami'                      => 'smj',
    'lunda'                         => 'lun',
    'luo'                           => 'luo',
    'lushai'                        => 'lus',
    'luxembourgish'                 => 'lb',
    'luyia'                         => 'luy',
    'machame'                       => 'jmc',
    'madurese'                      => 'mad',
    'magahi'                        => 'mag',
    'maithili'                      => 'mai',
    'makasar'                       => 'mak',
    'makhuwameetto'                 => 'mgh',
    'makonde'                       => 'kde',
    'malagasy'                      => 'mg',
    'malayalam'                     => 'ml',
    'manchu'                        => 'mnc',
    'mandar'                        => 'mdr',
    'mandingo'                      => 'man',
    'manipuri'                      => 'mni',
    'manobolanguage'                => 'mno',
    'manx'                          => 'gv',
    'maori'                         => 'mi',
    'mari'                          => 'chm',
    'marshallese'                   => 'mh',
    'marwari'                       => 'mwr',
    'masai'                         => 'mas',
    'mayanlanguage'                 => 'myn',
    'mende'                         => 'men',
    'meru'                          => 'mer',
    'micmac'                        => 'mic',
    'middledutch'                   => 'dum',
    'middleenglish'                 => 'enm',
    'middlefrench'                  => 'frm',
    'middlehighgerman'              => 'gmh',
    'middleirish'                   => 'mga',
    'minangkabau'                   => 'min',
    'mirandese'                     => 'mwl',
    'miscellaneouslanguage'         => 'mis',
    'mohawk'                        => 'moh',
    'moksha'                        => 'mdf',
    'moldavian'                     => 'mo',
    'mongo'                         => 'lol',
    'mongolian'                     => 'mn',
    'monkhmerlanguage'              => 'mkh',
    'morisyen'                      => 'mfe',
    'mossi'                         => 'mos',
    'multiplelanguages'             => 'mul',
    'mundalanguage'                 => 'mun',
    'mundang'                       => 'mua',
    'nahuatl'                       => 'nah',
    'nama'                          => 'naq',
    'nauru'                         => 'na',
    'navajo'                        => 'nv',
    'ndonga'                        => 'ng',
    'neapolitan'                    => 'nap',
    'newari'                        => 'new',
    'nias'                          => 'nia',
    'nigerkordofanianlanguage'      => 'nic',
    'nilosaharanlanguage'           => 'ssa',
    'niuean'                        => 'niu',
    'nogai'                         => 'nog',
    'nolinguisticcontent'           => 'zxx',
    'northamericanindianlanguage'   => 'nai',
    'northernfrisian'               => 'frr',
    'northernsami'                  => 'se',
    'northernsotho'                 => 'nso',
    'northndebele'                  => 'nd',
    "norwegianbokm\Ã\¥l"          => 'nb',
    'norwegiannynorsk'              => 'nn',
    'nubianlanguage'                => 'nub',
    'nuer'                          => 'nus',
    'nyamwezi'                      => 'nym',
    'nyanja'                        => 'ny',
    'nyankole'                      => 'nyn',
    'nyasatonga'                    => 'tog',
    'nyoro'                         => 'nyo',
    'nzima'                         => 'nzi',
    "n\â\\ko"                  => 'nqo',
    'ojibwa'                        => 'oj',
    'oldenglish'                    => 'ang',
    'oldfrench'                     => 'fro',
    'oldhighgerman'                 => 'goh',
    'oldirish'                      => 'sga',
    'oldnorse'                      => 'non',
    'oldpersian'                    => 'peo',
    "oldproven\Ã\§al"             => 'pro',
    'oriya'                         => 'or',
    'oromo'                         => 'om',
    'osage'                         => 'osa',
    'ossetic'                       => 'os',
    'otomianlanguage'               => 'oto',
    'ottomanturkish'                => 'ota',
    'pahlavi'                       => 'pal',
    'palauan'                       => 'pau',
    'pali'                          => 'pi',
    'pampanga'                      => 'pam',
    'pangasinan'                    => 'pag',
    'papiamento'                    => 'pap',
    'papuanlanguage'                => 'paa',
    'philippinelanguage'            => 'phi',
    'phoenician'                    => 'phn',
    'pohnpeian'                     => 'pon',
    'portuguesebasedcreoleorpidgin' => 'cpp',
    'prakritlanguage'               => 'pra',
    'pushto'                        => 'ps',
    'quechua'                       => 'qu',
    'rajasthani'                    => 'raj',
    'rapanui'                       => 'rap',
    'rarotongan'                    => 'rar',
    'romancelanguage'               => 'roa',
    'romansh'                       => 'rm',
    'romany'                        => 'rom',
    'rombo'                         => 'rof',
    'rundi'                         => 'rn',
    'rwa'                           => 'rwk',
    'saho'                          => 'ssy',
    'sakha'                         => 'sah',
    'salishanlanguage'              => 'sal',
    'samaritanaramaic'              => 'sam',
    'samburu'                       => 'saq',
    'samilanguage'                  => 'smi',
    'samoan'                        => 'sm',
    'sandawe'                       => 'sad',
    'sango'                         => 'sg',
    'sangu'                         => 'sbp',
    'santali'                       => 'sat',
    'sardinian'                     => 'sc',
    'sasak'                         => 'sas',
    'scots'                         => 'sco',
    'selkup'                        => 'sel',
    'semiticlanguage'               => 'sem',
    'sena'                          => 'seh',
    'seneca'                        => 'see',
    'serer'                         => 'srr',
    'shambala'                      => 'ksb',
    'shan'                          => 'shn',
    'shona'                         => 'sn',
    'sichuanyi'                     => 'ii',
    'sicilian'                      => 'scn',
    'sidamo'                        => 'sid',
    'signlanguage'                  => 'sgn',
    'siksika'                       => 'bla',
    'sinotibetanlanguage'           => 'sit',
    'siouanlanguage'                => 'sio',
    'skoltsami'                     => 'sms',
    'slave'                         => 'den',
    'slaviclanguage'                => 'sla',
    'soga'                          => 'xog',
    'sogdien'                       => 'sog',
    'songhai'                       => 'son',
    'soninke'                       => 'snk',
    'sorbianlanguage'               => 'wen',
    'southamericanindianlanguage'   => 'sai',
    'southernaltai'                 => 'alt',
    'southernsami'                  => 'sma',
    'southndebele'                  => 'nr',
    'sranantongo'                   => 'srn',
    'sukuma'                        => 'suk',
    'sumerian'                      => 'sux',
    'susu'                          => 'sus',
    'swati'                         => 'ss',
    'swissfrench'                   => 'fr_ch',
    'swissgerman'                   => 'gsw',
    'swisshighgerman'               => 'de_ch',
    'syriac'                        => 'syr',
    'tachelhit'                     => 'shi',
    'tagalog'                       => 'tl',
    'tahitian'                      => 'ty',
    'tailanguage'                   => 'tai',
    'taita'                         => 'dav',
    'tajik'                         => 'tg',
    'tamashek'                      => 'tmh',
    'taroko'                        => 'trv',
    'tasawaq'                       => 'twq',
    'tatar'                         => 'tt',
    'tereno'                        => 'ter',
    'teso'                          => 'teo',
    'tetum'                         => 'tet',
    'tiassam'                       => 'as',
    'tibetan'                       => 'bo',
    'tigre'                         => 'tig',
    'timne'                         => 'tem',
    'tiv'                           => 'tiv',
    'tlingit'                       => 'tli',
    'tokelau'                       => 'tkl',
    'tokpisin'                      => 'tpi',
    'tonga'                         => 'to',
    'tsimshian'                     => 'tsi',
    'tsonga'                        => 'ts',
    'tswana'                        => 'tn',
    'tumbuka'                       => 'tum',
    'tupilanguage'                  => 'tup',
    'tuvalu'                        => 'tvl',
    'tuvinian'                      => 'tyv',
    'twi'                           => 'tw',
    'tyap'                          => 'kcg',
    "u\.s\.english"                 => 'en_us',
    'udmurt'                        => 'udm',
    'ugaritic'                      => 'uga',
    'umbundu'                       => 'umb',
    'unknownlanguage'               => 'und',
    'uppersorbian'                  => 'hsb',
    'uyghur'                        => 'ug',
    'vai'                           => 'vai',
    'venda'                         => 've',
    "volap\Ã\¼k"                  => 'vo',
    'votic'                         => 'vot',
    'vunjo'                         => 'vun',
    'wakashanlanguage'              => 'wak',
    'walamo'                        => 'wal',
    'walloon'                       => 'wa',
    'walser'                        => 'wae',
    'waray'                         => 'war',
    'washo'                         => 'was',
    'wolof'                         => 'wo',
    'yangben'                       => 'yav',
    'yao'                           => 'yao',
    'yapese'                        => 'yap',
    'yupiklanguage'                 => 'ypk',
    'zande'                         => 'znd',
    'zapotec'                       => 'zap',
    'zarma'                         => 'dje',
    'zaza'                          => 'zza',
    'zenaga'                        => 'zen',
    'zhuang'                        => 'za',
    'zuni'                          => 'zun',
    'Èdèafrikani'                 => 'af',
    'Èdèakani'                    => 'ak',
    'Èdèalbania'                  => 'sq',
    'Èdèamariki'                  => 'am',
    'Èdèarabiki'                  => 'ar',
    'Èdèarasomalia'               => 'so',
    'Èdèawonaraindo'              => 'sa',
    'Èdèazerbaijani'              => 'az',
    'Èdèbaski'                    => 'eu',
    'Èdèbelarusi'                 => 'be',
    'Èdèbengali'                  => 'bn',
    'Èdèbihari'                   => 'bh',
    'Èdèbosnia'                   => 'bs',
    'Èdèbretoni'                  => 'br',
    'Èdèbugaria'                  => 'bg',
    'Èdèbumiisi'                  => 'my',
    'Èdècatala'                   => 'ca',
    'Èdèduki'                     => 'nl',
    'Èdèesperanto'                => 'eo',
    'Èdèestonia'                  => 'et',
    'Èdèfaransé'                 => 'fr',
    'Èdèfaroesi'                  => 'fo',
    'Èdèfinisi'                   => 'fi',
    'Èdèfrisia'                   => 'fy',
    'Èdègaeliktiiluscotland'      => 'gd',
    'Èdègalicia'                  => 'gl',
    'Èdègeorgia'                  => 'ka',
    'Èdègiriki'                   => 'el',
    'Èdèguarani'                  => 'gn',
    'Èdègujarati'                 => 'gu',
    'Èdègẹ̀ẹ́sì'           => 'en',
    'Èdèhausa'                    => 'ha',
    'Èdèheberu'                   => 'he',
    'Èdèhindi'                    => 'hi',
    'Èdèhungaria'                 => 'hu',
    'Èdèibo'                      => 'ig',
    'Èdèicelandic'                => 'is',
    'Èdèilearmenia'               => 'hy',
    'Èdèilẹ̀denmark'           => 'da',
    'Èdèilẹ̀gemani'            => 'de',
    'Èdèilẹ̀polandi'           => 'pl',
    'Èdèindonasia'                => 'id',
    'Èdèireland'                  => 'ga',
    'Èdèitaliani'                 => 'it',
    'Èdèjapanisi'                 => 'ja',
    'Èdèjavanasi'                 => 'jv',
    'Èdèjetinamu'                 => 'vi',
    'Èdèkameri'                   => 'km',
    'Èdèkannada'                  => 'kn',
    'Èdèklingoni'                 => 'tlh',
    'Èdèkoria'                    => 'ko',
    'Èdèkroatia'                  => 'hr',
    'Èdèlatini'                   => 'la',
    'Èdèlatvianu'                 => 'lv',
    'Èdèlithuania'                => 'lt',
    'Èdèmacedonia'                => 'mk',
    'Èdèmalaya'                   => 'ms',
    'Èdèmalta'                    => 'mt',
    'Èdèmandari'                  => 'zh',
    'Èdèmarathi'                  => 'mr',
    'Èdènepali'                   => 'ne',
    'Èdènorway'                   => 'no',
    'Èdèoccitani'                 => 'oc',
    'Èdèpasia'                    => 'fa',
    'Èdèpipo'                     => 'ia',
    'Èdèpunjabi'                  => 'pa',
    'Èdèpọtugi'                 => 'pt',
    'Èdèromania'                  => 'ro',
    'Èdèruwanda'                  => 'rw',
    'Èdèseeki'                    => 'cs',
    'Èdèserbia'                   => 'sr',
    'Èdèserbocroatiani'           => 'sh',
    'Èdèsesoto'                   => 'st',
    'Èdèsindhi'                   => 'sd',
    'Èdèsinhalese'                => 'si',
    'Èdèsipanisi'                 => 'es',
    'Èdèslovaki'                  => 'sk',
    'Èdèslovenia'                 => 'sl',
    'Èdèsudani'                   => 'su',
    'Èdèsuwidiisi'                => 'sv',
    'Èdèswahili'                  => 'sw',
    'Èdètagalogi'                 => 'fil',
    'Èdètai'                      => 'th',
    'Èdètamili'                   => 'ta',
    'Èdètelugu'                   => 'te',
    'Èdètigrinya'                 => 'ti',
    'Èdèturkmen'                  => 'tk',
    'Èdètọọkisi'              => 'tr',
    'Èdèudu'                      => 'ur',
    'Èdèukania'                   => 'uk',
    'Èdèuzbek'                    => 'uz',
    'Èdèwelshi'                   => 'cy',
    'Èdèxhosa'                    => 'xh',
    'Èdèyiddishi'                 => 'yi',
    'Èdèyorùbá'                 => 'yo',
    'Èdẹ̀rọọsia'             => 'ru',
    'ÈdèṢulu'                   => 'zu',
);

1;
