package Locales::DB::Language::sv;

# Auto generated from CLDR

$Locales::DB::Language::sv::VERSION = '0.07';

$Locales::DB::Language::sv::cldr_version = '2.0';

%Locales::DB::Language::sv::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => ' ',
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}\.\.\.",
            'initial' => "…\ \{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "språk\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ och\ \{1\}",
            'end'    => "\{0\}\ och\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "område\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '’',
        'quotation_end'             => '”',
        'quotation_start'           => '”'
    },
    'fallback'    => ["nn\ nb\ da\ en"],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => { 'one' => "sub\ \{\ return\ \'one\'\ if\ \(\ \(\(\ \$_\[0\]\ \=\=\ 1\)\)\)\;\ return\;\}\;" }
    },
    'posix' => {
        'nostr'  => "nej\:n",
        'yesstr' => "ja\:j"
    },
);

%Locales::DB::Language::sv::code_to_name = (
    'aa'    => 'afar',
    'ab'    => 'abchaziska',
    'ace'   => 'acehnesiska',
    'ach'   => 'acholi',
    'ada'   => 'adangme',
    'ady'   => 'adygeiska',
    'ae'    => 'avestiska',
    'af'    => 'afrikaans',
    'afa'   => "afroasiatiskt\ språk",
    'afh'   => 'afrihili',
    'agq'   => 'aghem',
    'ain'   => 'ainu',
    'ak'    => 'akan',
    'akk'   => 'akkadiska',
    'ale'   => 'aleutiska',
    'alg'   => "algonkinskt\ språk",
    'alt'   => 'sydaltaiska',
    'am'    => 'amhariska',
    'an'    => 'aragonesiska',
    'ang'   => 'fornengelska',
    'anp'   => 'angika',
    'apa'   => 'apachespråk',
    'ar'    => 'arabiska',
    'arc'   => 'arameiska',
    'arn'   => 'araukanska',
    'arp'   => 'arapaho',
    'art'   => "konstgjort\ språk",
    'arw'   => 'arawakiska',
    'as'    => 'assamesiska',
    'asa'   => 'asu',
    'ast'   => 'asturiska',
    'ath'   => "athapaskiskt\ språk",
    'aus'   => "australiskt\ språk",
    'av'    => 'avariska',
    'awa'   => 'awadhi',
    'ay'    => 'aymara',
    'az'    => 'azerbajdzjanska',
    'ba'    => 'basjkiriska',
    'bad'   => 'bandaspråk',
    'bai'   => 'bamilekespråk',
    'bal'   => 'baluchiska',
    'ban'   => 'balinesiska',
    'bas'   => 'basa',
    'bat'   => "baltiskt\ språk",
    'be'    => 'vitryska',
    'bej'   => 'beyja',
    'bem'   => 'bemba',
    'ber'   => 'berberspråk',
    'bez'   => 'bena',
    'bg'    => 'bulgariska',
    'bh'    => 'bihari',
    'bho'   => 'bhojpuri',
    'bi'    => 'bislama',
    'bik'   => 'bikol',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengali',
    'bnt'   => 'bantuspråk',
    'bo'    => 'tibetanska',
    'br'    => 'bretonska',
    'bra'   => 'braj',
    'brx'   => 'bodo',
    'bs'    => 'bosniska',
    'btk'   => 'batak',
    'bua'   => 'burjätiska',
    'bug'   => 'buginesiska',
    'byn'   => 'blin',
    'ca'    => 'katalanska',
    'cad'   => 'caddo',
    'cai'   => "centralamerikanskt\ indianspråk",
    'car'   => 'karibiska',
    'cau'   => "kaukasiskt\ språk",
    'cay'   => 'Cayuga',
    'cch'   => 'atsam',
    'ce'    => 'tjetjenska',
    'ceb'   => 'cebuano',
    'cel'   => "keltiskt\ språk",
    'cgg'   => 'Chiga',
    'ch'    => 'chamorro',
    'chb'   => 'chibcha',
    'chg'   => 'chagatai',
    'chk'   => 'chuukesiska',
    'chm'   => 'mari',
    'chn'   => 'chinook',
    'cho'   => 'choctaw',
    'chp'   => 'chipewyan',
    'chr'   => 'cherokesiska',
    'chy'   => 'cheyenne',
    'cmc'   => 'chamispråk',
    'co'    => 'korsikanska',
    'cop'   => 'koptiska',
    'cpe'   => "engelskbaserat\ kreol\-\ eller\ pidginspråk",
    'cpf'   => "franskbaserat\ kreol\-\ eller\ pidginspråk",
    'cpp'   => "portugisiskbaserat\ kreol\-\ eller\ pidginspråk",
    'cr'    => 'cree',
    'crh'   => 'krimtatariska',
    'crp'   => "kreol\-\ eller\ pidginspråk",
    'cs'    => 'tjeckiska',
    'csb'   => 'kasjubiska',
    'cu'    => 'kyrkslaviska',
    'cus'   => "kusjitiskt\ språk",
    'cv'    => 'tjuvasjiska',
    'cy'    => 'walesiska',
    'da'    => 'danska',
    'dak'   => 'dakota',
    'dar'   => 'darginska',
    'dav'   => 'Taita',
    'day'   => 'dajakiska',
    'de'    => 'tyska',
    'de_at' => "österrikisk\ tyska",
    'de_ch' => "schweizisk\ högtyska",
    'del'   => 'delaware',
    'den'   => 'slavej',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'dje'   => 'zarma',
    'doi'   => 'dogri',
    'dra'   => "dravidiskt\ språk",
    'dsb'   => 'lågsorbiska',
    'dua'   => 'duala',
    'dum'   => 'medelnederländska',
    'dv'    => 'divehi',
    'dyo'   => "jola\-fonyi",
    'dyu'   => 'dyula',
    'dz'    => 'bhutanesiska',
    'ebu'   => 'embu',
    'ee'    => 'ewe',
    'efi'   => 'efik',
    'egy'   => 'fornegyptiska',
    'eka'   => 'ekajuk',
    'el'    => 'grekiska',
    'elx'   => 'elamitiska',
    'en'    => 'engelska',
    'en_au' => "australisk\ engelska",
    'en_ca' => "kanadensisk\ engelska",
    'en_gb' => "brittisk\ engelska",
    'en_us' => "amerikansk\ engelska",
    'enm'   => 'medelengelska',
    'eo'    => 'esperanto',
    'es'    => 'spanska',
    'es_es' => "europeisk\ spanska",
    'et'    => 'estniska',
    'eu'    => 'baskiska',
    'ewo'   => 'ewondo',
    'fa'    => 'persiska',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'fulani',
    'fi'    => 'finska',
    'fil'   => 'filippinska',
    'fiu'   => "finskugriskt\ språk",
    'fj'    => 'fidjianska',
    'fo'    => 'färöiska',
    'fon'   => 'fonspråket',
    'fr'    => 'franska',
    'fr_ca' => "kanadensisk\ franska",
    'fr_ch' => "schweizisk\ franska",
    'frm'   => 'medelfranska',
    'fro'   => 'fornfranska',
    'frr'   => 'nordfrisiska',
    'frs'   => 'östfrisiska',
    'fur'   => 'friulianska',
    'fy'    => 'västfrisiska',
    'ga'    => 'iriska',
    'gaa'   => 'gã',
    'gay'   => 'gayo',
    'gba'   => 'gbaya',
    'gd'    => 'höglandsskotska',
    'gem'   => "germanskt\ språk",
    'gez'   => 'etiopiska',
    'gil'   => 'gilbertiska',
    'gl'    => 'galiciska',
    'gmh'   => 'medelhögtyska',
    'gn'    => 'guaraní',
    'goh'   => 'fornhögtyska',
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gotiska',
    'grb'   => 'grebo',
    'grc'   => 'forngrekiska',
    'gsw'   => 'schweizertyska',
    'gu'    => 'gujarati',
    'guz'   => 'Gusii',
    'gv'    => 'manx',
    'gwi'   => 'gwichin',
    'ha'    => 'haussa',
    'hai'   => 'haida',
    'haw'   => 'hawaiiska',
    'he'    => 'hebreiska',
    'hi'    => 'hindi',
    'hil'   => 'hiligaynon',
    'him'   => 'himachali',
    'hit'   => 'hettitiska',
    'hmn'   => 'hmongspråk',
    'ho'    => 'hirimotu',
    'hr'    => 'kroatiska',
    'hsb'   => 'högsorbiska',
    'ht'    => 'haitiska',
    'hu'    => 'ungerska',
    'hup'   => 'hupa',
    'hy'    => 'armeniska',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'ibanska',
    'id'    => 'indonesiska',
    'ie'    => 'interlingue',
    'ig'    => 'ibo',
    'ii'    => "szezuan\ i",
    'ijo'   => 'ijospråket',
    'ik'    => 'inupiak',
    'ilo'   => 'iloko',
    'inc'   => "indiskt\ språk",
    'ine'   => "indoeuropeiskt\ språk",
    'inh'   => 'ingusjiska',
    'io'    => 'ido',
    'ira'   => "iranskt\ språk",
    'iro'   => "irokesiskt\ språk",
    'is'    => 'isländska',
    'it'    => 'italienska',
    'iu'    => 'inuktitut',
    'ja'    => 'japanska',
    'jbo'   => 'lojban',
    'jmc'   => 'Machame',
    'jpr'   => "judisk\ persiska",
    'jrb'   => "judisk\ arabiska",
    'jv'    => 'javanesiska',
    'ka'    => 'georgiska',
    'kaa'   => 'karakalpakiska',
    'kab'   => 'kabyliska',
    'kac'   => 'kachin',
    'kaj'   => 'jju',
    'kam'   => 'kamba',
    'kar'   => 'karenska',
    'kaw'   => 'kawi',
    'kbd'   => 'kabardinska',
    'kcg'   => 'tyap',
    'kde'   => 'Makonde',
    'kea'   => 'kapverdiska',
    'kfo'   => 'koro',
    'kg'    => 'kikongo',
    'kha'   => 'khasi',
    'khi'   => 'khoisanspråk',
    'kho'   => 'khotanesiska',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'kikuyu',
    'kj'    => 'kuanyama',
    'kk'    => 'kazakiska',
    'kl'    => 'grönländska',
    'kln'   => 'Kalenjin',
    'km'    => 'kambodjanska',
    'kmb'   => 'kimbundu',
    'kn'    => 'kannada',
    'ko'    => 'koreanska',
    'kok'   => 'konkani',
    'kos'   => 'kosreanska',
    'kpe'   => 'kpelle',
    'kr'    => 'kanuri',
    'krc'   => "karachay\-balkar",
    'krl'   => 'karelska',
    'kro'   => 'kru',
    'kru'   => 'kurukh',
    'ks'    => 'kashmiriska',
    'ksb'   => 'Shambala',
    'ksf'   => 'bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'kurdiska',
    'kum'   => 'kumykiska',
    'kut'   => 'kutenaj',
    'kv'    => 'kome',
    'kw'    => 'korniska',
    'ky'    => 'kirgisiska',
    'la'    => 'latin',
    'lad'   => 'ladino',
    'lag'   => 'Langi',
    'lah'   => 'lahnda',
    'lam'   => 'lamba',
    'lb'    => 'luxemburgiska',
    'lez'   => 'lezghien',
    'lg'    => 'luganda',
    'li'    => 'limburgiska',
    'ln'    => 'lingala',
    'lo'    => 'laotiska',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'litauiska',
    'lu'    => "luba\-katanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luiseño',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lushai',
    'luy'   => 'luhya',
    'lv'    => 'lettiska',
    'mad'   => 'maduresiska',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'makasar',
    'man'   => 'mande',
    'map'   => "austronesiskt\ språk",
    'mas'   => 'massajiska',
    'mdf'   => 'moksja',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'malagassiska',
    'mga'   => 'medeliriska',
    'mgh'   => "makhuwa\-meetto",
    'mh'    => 'marshalliska',
    'mi'    => 'maori',
    'mic'   => "mic\-mac",
    'min'   => 'minangkabau',
    'mis'   => "annat\ språk",
    'mk'    => 'makedonska',
    'mkh'   => "mon\-khmeriskt\ språk",
    'ml'    => 'malayalam',
    'mn'    => 'mongoliska',
    'mnc'   => 'manchuriska',
    'mni'   => 'manipuri',
    'mno'   => 'manobospråk',
    'mo'    => 'moldaviska',
    'moh'   => 'mohawk',
    'mos'   => 'mossi',
    'mr'    => 'marathi',
    'ms'    => 'malajiska',
    'mt'    => 'maltesiska',
    'mua'   => 'mundang',
    'mul'   => "flera\ språk",
    'mun'   => 'mundaspråk',
    'mus'   => 'muskogee',
    'mwl'   => 'mirandesiska',
    'mwr'   => 'marwari',
    'my'    => 'burmesiska',
    'myn'   => 'mayaspråk',
    'myv'   => 'erjya',
    'na'    => 'nauru',
    'nah'   => 'aztekiska',
    'nai'   => "nordamerikanskt\ indianspråk",
    'nap'   => 'napolitanska',
    'naq'   => 'Nama',
    'nb'    => "norskt\ bokmål",
    'nd'    => 'nordndebele',
    'nds'   => 'lågtyska',
    'ne'    => 'nepalesiska',
    'new'   => 'newariska',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => "Niger\-Kongospråk",
    'niu'   => 'niueanska',
    'nl'    => 'nederländska',
    'nl_be' => 'flamländska',
    'nmg'   => 'kwasio',
    'nn'    => 'nynorska',
    'no'    => 'norska',
    'nog'   => 'nogai',
    'non'   => 'fornnordiska',
    'nqo'   => "n\-kå",
    'nr'    => 'sydndebele',
    'nso'   => 'nordsotho',
    'nub'   => "nubiskt\ språk",
    'nus'   => 'nuer',
    'nv'    => 'navaho',
    'nwc'   => "klassisk\ newariska",
    'ny'    => 'nyanja',
    'nym'   => 'nyamwezi',
    'nyn'   => 'nyankole',
    'nyo'   => 'nyoro',
    'nzi'   => 'nzima',
    'oc'    => 'occitanska',
    'oj'    => 'odjibwa',
    'om'    => 'oromo',
    'or'    => 'oriya',
    'os'    => 'ossetiska',
    'osa'   => 'osage',
    'ota'   => 'ottomanska',
    'oto'   => 'otomispråk',
    'pa'    => 'punjabi',
    'paa'   => "papuanskt\ språk",
    'pag'   => 'pangasinan',
    'pal'   => 'medelpersiska',
    'pam'   => 'pampanga',
    'pap'   => 'papiamento',
    'pau'   => 'palau',
    'peo'   => 'fornpersiska',
    'phi'   => "filippinskt\ språk",
    'phn'   => 'feniciska',
    'pi'    => 'pali',
    'pl'    => 'polska',
    'pon'   => 'ponape',
    'pra'   => 'prakritspråk',
    'pro'   => 'fornprovensalska',
    'ps'    => 'pushto',
    'pt'    => 'portugisiska',
    'pt_br' => "brasiliansk\ portugisiska",
    'pt_pt' => "europeisk\ portugisiska",
    'qu'    => 'quechua',
    'raj'   => 'rajasthani',
    'rap'   => 'rapanui',
    'rar'   => 'rarotonganska',
    'rm'    => 'rätoromanska',
    'rn'    => 'rundi',
    'ro'    => 'rumänska',
    'roa'   => "romanskt\ språk",
    'rof'   => 'rombo',
    'rom'   => 'romani',
    'ru'    => 'ryska',
    'rup'   => 'arumänska',
    'rw'    => 'kinjarwanda',
    'rwk'   => 'rwa',
    'sa'    => 'sanskrit',
    'sad'   => 'sandawe',
    'sah'   => 'jakutiska',
    'sai'   => "sydamerikanskt\ indianspråk",
    'sal'   => "salikiskt\ språk",
    'sam'   => 'samaritanska',
    'saq'   => 'Samburu',
    'sas'   => 'sasak',
    'sat'   => 'santali',
    'sbp'   => 'sangu',
    'sc'    => 'sardiska',
    'scn'   => 'sicilianska',
    'sco'   => 'skotska',
    'sd'    => 'sindhi',
    'se'    => 'nordsamiska',
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'selkup',
    'sem'   => "semitiskt\ språk",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'sango',
    'sga'   => 'forniriska',
    'sgn'   => 'teckenspråk',
    'sh'    => 'serbokroatiska',
    'shi'   => 'Tachelhit',
    'shn'   => 'shan',
    'si'    => 'singalesiska',
    'sid'   => 'sidamo',
    'sio'   => 'siouxspråk',
    'sit'   => "sinotibetanskt\ språk",
    'sk'    => 'slovakiska',
    'sl'    => 'slovenska',
    'sla'   => "slaviskt\ språk",
    'sm'    => 'samoanska',
    'sma'   => 'sydsamiska',
    'smi'   => "samiskt\ språk",
    'smj'   => 'lulesamiska',
    'smn'   => 'enaresamiska',
    'sms'   => 'skoltsamiska',
    'sn'    => 'shona',
    'snk'   => 'soninke',
    'so'    => 'somaliska',
    'sog'   => 'sogdiska',
    'son'   => 'songhai',
    'sq'    => 'albanska',
    'sr'    => 'serbiska',
    'srn'   => "sranan\ tongo",
    'srr'   => 'serer',
    'ss'    => 'swati',
    'ssa'   => "nilosahariskt\ språk",
    'ssy'   => 'Saho',
    'st'    => 'sydsotho',
    'su'    => 'sundanesiska',
    'suk'   => 'sukuma',
    'sus'   => 'susu',
    'sux'   => 'sumeriska',
    'sv'    => 'svenska',
    'sw'    => 'swahili',
    'swb'   => 'shimaoré',
    'swc'   => "Congo\ Swahili",
    'syc'   => "klassisk\ syriska",
    'syr'   => 'syriska',
    'ta'    => 'tamil',
    'tai'   => 'thaispråk',
    'te'    => 'telugiska',
    'tem'   => 'temne',
    'teo'   => 'Teso',
    'ter'   => 'tereno',
    'tet'   => 'tetum',
    'tg'    => 'tadzjikiska',
    'th'    => 'thailändska',
    'ti'    => 'tigrinja',
    'tig'   => 'tigré',
    'tiv'   => 'tivi',
    'tk'    => 'turkmeniska',
    'tkl'   => 'tokelauiska',
    'tl'    => 'tagalog',
    'tlh'   => 'klingonska',
    'tli'   => 'tlingit',
    'tmh'   => 'tamashek',
    'tn'    => 'tswana',
    'to'    => 'tonganska',
    'tog'   => 'nyasatonganska',
    'tpi'   => "tok\ pisin",
    'tr'    => 'turkiska',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimshian',
    'tt'    => 'tatariska',
    'tum'   => 'tumbuka',
    'tup'   => 'tupíspråk',
    'tut'   => "altaiskt\ språk",
    'tvl'   => 'tuvaluanska',
    'tw'    => 'twi',
    'twq'   => 'tasawaq',
    'ty'    => 'tahitiska',
    'tyv'   => 'tuviniska',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'udmurtiska',
    'ug'    => 'uiguriska',
    'uga'   => 'ugaritiska',
    'uk'    => 'ukrainska',
    'umb'   => 'umbundu',
    'und'   => "obestämt\ språk",
    'ur'    => 'urdu',
    'uz'    => 'uzbekiska',
    'vai'   => 'vaj',
    've'    => 'venda',
    'vi'    => 'vietnamesiska',
    'vo'    => 'volapük',
    'vot'   => 'votiska',
    'vun'   => 'Vunjo',
    'wa'    => 'vallonska',
    'wae'   => 'walsertyska',
    'wak'   => "wakusjiskt\ språk",
    'wal'   => 'walamo',
    'war'   => 'waray',
    'was'   => 'washo',
    'wen'   => "sorbiskt\ språk",
    'wo'    => 'wolof',
    'xal'   => 'kalmuckiska',
    'xh'    => 'xhosa',
    'xog'   => 'Soga',
    'yao'   => 'kiyao',
    'yap'   => 'japetiska',
    'yav'   => 'yangben',
    'yi'    => 'jiddisch',
    'yo'    => 'yoruba',
    'ypk'   => 'eskimåspråk',
    'yue'   => 'kantonesiska',
    'za'    => 'zhuang',
    'zap'   => 'zapotek',
    'zbl'   => 'blissymboler',
    'zen'   => 'zenaga',
    'zh'    => 'kinesiska',
    'znd'   => 'zandé',
    'zu'    => 'zulu',
    'zun'   => 'zuni',
    'zxx'   => "inget\ språkligt\ innehåll",
    'zza'   => 'zazaiska',
);

%Locales::DB::Language::sv::name_to_code = (
    'abchaziska'                               => 'ab',
    'acehnesiska'                              => 'ace',
    'acholi'                                   => 'ach',
    'adangme'                                  => 'ada',
    'adygeiska'                                => 'ady',
    'afar'                                     => 'aa',
    'afrihili'                                 => 'afh',
    'afrikaans'                                => 'af',
    'afroasiatisktspråk'                      => 'afa',
    'aghem'                                    => 'agq',
    'ainu'                                     => 'ain',
    'akan'                                     => 'ak',
    'akkadiska'                                => 'akk',
    'albanska'                                 => 'sq',
    'aleutiska'                                => 'ale',
    'algonkinsktspråk'                        => 'alg',
    'altaisktspråk'                           => 'tut',
    'amerikanskengelska'                       => 'en_us',
    'amhariska'                                => 'am',
    'angika'                                   => 'anp',
    'annatspråk'                              => 'mis',
    'apachespråk'                             => 'apa',
    'arabiska'                                 => 'ar',
    'aragonesiska'                             => 'an',
    'arameiska'                                => 'arc',
    'arapaho'                                  => 'arp',
    'araukanska'                               => 'arn',
    'arawakiska'                               => 'arw',
    'armeniska'                                => 'hy',
    'arumänska'                               => 'rup',
    'assamesiska'                              => 'as',
    'asturiska'                                => 'ast',
    'asu'                                      => 'asa',
    'athapaskisktspråk'                       => 'ath',
    'atsam'                                    => 'cch',
    'australiskengelska'                       => 'en_au',
    'australisktspråk'                        => 'aus',
    'austronesisktspråk'                      => 'map',
    'avariska'                                 => 'av',
    'avestiska'                                => 'ae',
    'awadhi'                                   => 'awa',
    'aymara'                                   => 'ay',
    'azerbajdzjanska'                          => 'az',
    'aztekiska'                                => 'nah',
    'bafia'                                    => 'ksf',
    'balinesiska'                              => 'ban',
    'baltisktspråk'                           => 'bat',
    'baluchiska'                               => 'bal',
    'bambara'                                  => 'bm',
    'bamilekespråk'                           => 'bai',
    'bandaspråk'                              => 'bad',
    'bantuspråk'                              => 'bnt',
    'basa'                                     => 'bas',
    'basjkiriska'                              => 'ba',
    'baskiska'                                 => 'eu',
    'batak'                                    => 'btk',
    'bemba'                                    => 'bem',
    'bena'                                     => 'bez',
    'bengali'                                  => 'bn',
    'berberspråk'                             => 'ber',
    'beyja'                                    => 'bej',
    'bhojpuri'                                 => 'bho',
    'bhutanesiska'                             => 'dz',
    'bihari'                                   => 'bh',
    'bikol'                                    => 'bik',
    'bini'                                     => 'bin',
    'bislama'                                  => 'bi',
    'blin'                                     => 'byn',
    'blissymboler'                             => 'zbl',
    'bodo'                                     => 'brx',
    'bosniska'                                 => 'bs',
    'braj'                                     => 'bra',
    'brasilianskportugisiska'                  => 'pt_br',
    'bretonska'                                => 'br',
    'brittiskengelska'                         => 'en_gb',
    'buginesiska'                              => 'bug',
    'bulgariska'                               => 'bg',
    'burjätiska'                              => 'bua',
    'burmesiska'                               => 'my',
    'caddo'                                    => 'cad',
    'cayuga'                                   => 'cay',
    'cebuano'                                  => 'ceb',
    'centralamerikansktindianspråk'           => 'cai',
    'centralmoroccotamazight'                  => 'tzm',
    'chagatai'                                 => 'chg',
    'chamispråk'                              => 'cmc',
    'chamorro'                                 => 'ch',
    'cherokesiska'                             => 'chr',
    'cheyenne'                                 => 'chy',
    'chibcha'                                  => 'chb',
    'chiga'                                    => 'cgg',
    'chinook'                                  => 'chn',
    'chipewyan'                                => 'chp',
    'choctaw'                                  => 'cho',
    'chuukesiska'                              => 'chk',
    'colognian'                                => 'ksh',
    'congoswahili'                             => 'swc',
    'cree'                                     => 'cr',
    'dajakiska'                                => 'day',
    'dakota'                                   => 'dak',
    'danska'                                   => 'da',
    'darginska'                                => 'dar',
    'delaware'                                 => 'del',
    'dinka'                                    => 'din',
    'divehi'                                   => 'dv',
    'dogri'                                    => 'doi',
    'dogrib'                                   => 'dgr',
    'dravidisktspråk'                         => 'dra',
    'duala'                                    => 'dua',
    'dyula'                                    => 'dyu',
    'efik'                                     => 'efi',
    'ekajuk'                                   => 'eka',
    'elamitiska'                               => 'elx',
    'embu'                                     => 'ebu',
    'enaresamiska'                             => 'smn',
    'engelska'                                 => 'en',
    'engelskbaseratkreolellerpidginspråk'     => 'cpe',
    'erjya'                                    => 'myv',
    'eskimåspråk'                            => 'ypk',
    'esperanto'                                => 'eo',
    'estniska'                                 => 'et',
    'etiopiska'                                => 'gez',
    'europeiskportugisiska'                    => 'pt_pt',
    'europeiskspanska'                         => 'es_es',
    'ewe'                                      => 'ee',
    'ewondo'                                   => 'ewo',
    'fang'                                     => 'fan',
    'fanti'                                    => 'fat',
    'feniciska'                                => 'phn',
    'fidjianska'                               => 'fj',
    'filippinska'                              => 'fil',
    'filippinsktspråk'                        => 'phi',
    'finska'                                   => 'fi',
    'finskugrisktspråk'                       => 'fiu',
    'flamländska'                             => 'nl_be',
    'fleraspråk'                              => 'mul',
    'fonspråket'                              => 'fon',
    'fornegyptiska'                            => 'egy',
    'fornengelska'                             => 'ang',
    'fornfranska'                              => 'fro',
    'forngrekiska'                             => 'grc',
    'fornhögtyska'                            => 'goh',
    'forniriska'                               => 'sga',
    'fornnordiska'                             => 'non',
    'fornpersiska'                             => 'peo',
    'fornprovensalska'                         => 'pro',
    'franska'                                  => 'fr',
    'franskbaseratkreolellerpidginspråk'      => 'cpf',
    'friulianska'                              => 'fur',
    'fulani'                                   => 'ff',
    'färöiska'                               => 'fo',
    'galiciska'                                => 'gl',
    'gayo'                                     => 'gay',
    'gbaya'                                    => 'gba',
    'georgiska'                                => 'ka',
    'germansktspråk'                          => 'gem',
    'gilbertiska'                              => 'gil',
    'gondi'                                    => 'gon',
    'gorontalo'                                => 'gor',
    'gotiska'                                  => 'got',
    'grebo'                                    => 'grb',
    'grekiska'                                 => 'el',
    'grönländska'                            => 'kl',
    'guaraní'                                 => 'gn',
    'gujarati'                                 => 'gu',
    'gusii'                                    => 'guz',
    'gwichin'                                  => 'gwi',
    'gã'                                      => 'gaa',
    'haida'                                    => 'hai',
    'haitiska'                                 => 'ht',
    'haussa'                                   => 'ha',
    'hawaiiska'                                => 'haw',
    'hebreiska'                                => 'he',
    'herero'                                   => 'hz',
    'hettitiska'                               => 'hit',
    'hiligaynon'                               => 'hil',
    'himachali'                                => 'him',
    'hindi'                                    => 'hi',
    'hirimotu'                                 => 'ho',
    'hmongspråk'                              => 'hmn',
    'hupa'                                     => 'hup',
    'höglandsskotska'                         => 'gd',
    'högsorbiska'                             => 'hsb',
    'ibanska'                                  => 'iba',
    'ibo'                                      => 'ig',
    'ido'                                      => 'io',
    'ijospråket'                              => 'ijo',
    'iloko'                                    => 'ilo',
    'indisktspråk'                            => 'inc',
    'indoeuropeisktspråk'                     => 'ine',
    'indonesiska'                              => 'id',
    'ingetspråkligtinnehåll'                 => 'zxx',
    'ingusjiska'                               => 'inh',
    'interlingua'                              => 'ia',
    'interlingue'                              => 'ie',
    'inuktitut'                                => 'iu',
    'inupiak'                                  => 'ik',
    'iransktspråk'                            => 'ira',
    'iriska'                                   => 'ga',
    'irokesisktspråk'                         => 'iro',
    'isländska'                               => 'is',
    'italienska'                               => 'it',
    'jakutiska'                                => 'sah',
    'japanska'                                 => 'ja',
    'japetiska'                                => 'yap',
    'javanesiska'                              => 'jv',
    'jiddisch'                                 => 'yi',
    'jju'                                      => 'kaj',
    'jolafonyi'                                => 'dyo',
    'judiskarabiska'                           => 'jrb',
    'judiskpersiska'                           => 'jpr',
    'kabardinska'                              => 'kbd',
    'kabyliska'                                => 'kab',
    'kachin'                                   => 'kac',
    'kalenjin'                                 => 'kln',
    'kalmuckiska'                              => 'xal',
    'kamba'                                    => 'kam',
    'kambodjanska'                             => 'km',
    'kanadensiskengelska'                      => 'en_ca',
    'kanadensiskfranska'                       => 'fr_ca',
    'kannada'                                  => 'kn',
    'kantonesiska'                             => 'yue',
    'kanuri'                                   => 'kr',
    'kapverdiska'                              => 'kea',
    'karachaybalkar'                           => 'krc',
    'karakalpakiska'                           => 'kaa',
    'karelska'                                 => 'krl',
    'karenska'                                 => 'kar',
    'karibiska'                                => 'car',
    'kashmiriska'                              => 'ks',
    'kasjubiska'                               => 'csb',
    'katalanska'                               => 'ca',
    'kaukasisktspråk'                         => 'cau',
    'kawi'                                     => 'kaw',
    'kazakiska'                                => 'kk',
    'keltisktspråk'                           => 'cel',
    'khasi'                                    => 'kha',
    'khoisanspråk'                            => 'khi',
    'khotanesiska'                             => 'kho',
    'kikongo'                                  => 'kg',
    'kikuyu'                                   => 'ki',
    'kimbundu'                                 => 'kmb',
    'kinesiska'                                => 'zh',
    'kinjarwanda'                              => 'rw',
    'kirgisiska'                               => 'ky',
    'kiyao'                                    => 'yao',
    'klassisknewariska'                        => 'nwc',
    'klassisksyriska'                          => 'syc',
    'klingonska'                               => 'tlh',
    'kome'                                     => 'kv',
    'konkani'                                  => 'kok',
    'konstgjortspråk'                         => 'art',
    'koptiska'                                 => 'cop',
    'koreanska'                                => 'ko',
    'korniska'                                 => 'kw',
    'koro'                                     => 'kfo',
    'korsikanska'                              => 'co',
    'kosreanska'                               => 'kos',
    'koyraborosenni'                           => 'ses',
    'koyrachiini'                              => 'khq',
    'kpelle'                                   => 'kpe',
    'kreolellerpidginspråk'                   => 'crp',
    'krimtatariska'                            => 'crh',
    'kroatiska'                                => 'hr',
    'kru'                                      => 'kro',
    'kuanyama'                                 => 'kj',
    'kumykiska'                                => 'kum',
    'kurdiska'                                 => 'ku',
    'kurukh'                                   => 'kru',
    'kusjitisktspråk'                         => 'cus',
    'kutenaj'                                  => 'kut',
    'kwasio'                                   => 'nmg',
    'kyrkslaviska'                             => 'cu',
    'ladino'                                   => 'lad',
    'lahnda'                                   => 'lah',
    'lamba'                                    => 'lam',
    'langi'                                    => 'lag',
    'laotiska'                                 => 'lo',
    'latin'                                    => 'la',
    'lettiska'                                 => 'lv',
    'lezghien'                                 => 'lez',
    'limburgiska'                              => 'li',
    'lingala'                                  => 'ln',
    'litauiska'                                => 'lt',
    'lojban'                                   => 'jbo',
    'lozi'                                     => 'loz',
    'lubakatanga'                              => 'lu',
    'lubalulua'                                => 'lua',
    'luganda'                                  => 'lg',
    'luhya'                                    => 'luy',
    'luiseño'                                 => 'lui',
    'lulesamiska'                              => 'smj',
    'lunda'                                    => 'lun',
    'luo'                                      => 'luo',
    'lushai'                                   => 'lus',
    'luxemburgiska'                            => 'lb',
    'lågsorbiska'                             => 'dsb',
    'lågtyska'                                => 'nds',
    'machame'                                  => 'jmc',
    'maduresiska'                              => 'mad',
    'magahi'                                   => 'mag',
    'maithili'                                 => 'mai',
    'makasar'                                  => 'mak',
    'makedonska'                               => 'mk',
    'makhuwameetto'                            => 'mgh',
    'makonde'                                  => 'kde',
    'malagassiska'                             => 'mg',
    'malajiska'                                => 'ms',
    'malayalam'                                => 'ml',
    'maltesiska'                               => 'mt',
    'manchuriska'                              => 'mnc',
    'mandar'                                   => 'mdr',
    'mande'                                    => 'man',
    'manipuri'                                 => 'mni',
    'manobospråk'                             => 'mno',
    'manx'                                     => 'gv',
    'maori'                                    => 'mi',
    'marathi'                                  => 'mr',
    'mari'                                     => 'chm',
    'marshalliska'                             => 'mh',
    'marwari'                                  => 'mwr',
    'massajiska'                               => 'mas',
    'mayaspråk'                               => 'myn',
    'medelengelska'                            => 'enm',
    'medelfranska'                             => 'frm',
    'medelhögtyska'                           => 'gmh',
    'medeliriska'                              => 'mga',
    'medelnederländska'                       => 'dum',
    'medelpersiska'                            => 'pal',
    'mende'                                    => 'men',
    'meru'                                     => 'mer',
    'micmac'                                   => 'mic',
    'minangkabau'                              => 'min',
    'mirandesiska'                             => 'mwl',
    'mohawk'                                   => 'moh',
    'moksja'                                   => 'mdf',
    'moldaviska'                               => 'mo',
    'mongo'                                    => 'lol',
    'mongoliska'                               => 'mn',
    'monkhmerisktspråk'                       => 'mkh',
    'morisyen'                                 => 'mfe',
    'mossi'                                    => 'mos',
    'mundang'                                  => 'mua',
    'mundaspråk'                              => 'mun',
    'muskogee'                                 => 'mus',
    'nama'                                     => 'naq',
    'napolitanska'                             => 'nap',
    'nauru'                                    => 'na',
    'navaho'                                   => 'nv',
    'ndonga'                                   => 'ng',
    'nederländska'                            => 'nl',
    'nepalesiska'                              => 'ne',
    'newariska'                                => 'new',
    'nias'                                     => 'nia',
    'nigerkongospråk'                         => 'nic',
    'nilosaharisktspråk'                      => 'ssa',
    'niueanska'                                => 'niu',
    'nkå'                                     => 'nqo',
    'nogai'                                    => 'nog',
    'nordamerikansktindianspråk'              => 'nai',
    'nordfrisiska'                             => 'frr',
    'nordndebele'                              => 'nd',
    'nordsamiska'                              => 'se',
    'nordsotho'                                => 'nso',
    'norska'                                   => 'no',
    'norsktbokmål'                            => 'nb',
    'nubisktspråk'                            => 'nub',
    'nuer'                                     => 'nus',
    'nyamwezi'                                 => 'nym',
    'nyanja'                                   => 'ny',
    'nyankole'                                 => 'nyn',
    'nyasatonganska'                           => 'tog',
    'nynorska'                                 => 'nn',
    'nyoro'                                    => 'nyo',
    'nzima'                                    => 'nzi',
    'obestämtspråk'                          => 'und',
    'occitanska'                               => 'oc',
    'odjibwa'                                  => 'oj',
    'oriya'                                    => 'or',
    'oromo'                                    => 'om',
    'osage'                                    => 'osa',
    'ossetiska'                                => 'os',
    'otomispråk'                              => 'oto',
    'ottomanska'                               => 'ota',
    'palau'                                    => 'pau',
    'pali'                                     => 'pi',
    'pampanga'                                 => 'pam',
    'pangasinan'                               => 'pag',
    'papiamento'                               => 'pap',
    'papuansktspråk'                          => 'paa',
    'persiska'                                 => 'fa',
    'polska'                                   => 'pl',
    'ponape'                                   => 'pon',
    'portugisiska'                             => 'pt',
    'portugisiskbaseratkreolellerpidginspråk' => 'cpp',
    'prakritspråk'                            => 'pra',
    'punjabi'                                  => 'pa',
    'pushto'                                   => 'ps',
    'quechua'                                  => 'qu',
    'rajasthani'                               => 'raj',
    'rapanui'                                  => 'rap',
    'rarotonganska'                            => 'rar',
    'romani'                                   => 'rom',
    'romansktspråk'                           => 'roa',
    'rombo'                                    => 'rof',
    'rumänska'                                => 'ro',
    'rundi'                                    => 'rn',
    'rwa'                                      => 'rwk',
    'ryska'                                    => 'ru',
    'rätoromanska'                            => 'rm',
    'saho'                                     => 'ssy',
    'salikisktspråk'                          => 'sal',
    'samaritanska'                             => 'sam',
    'samburu'                                  => 'saq',
    'samisktspråk'                            => 'smi',
    'samoanska'                                => 'sm',
    'sandawe'                                  => 'sad',
    'sango'                                    => 'sg',
    'sangu'                                    => 'sbp',
    'sanskrit'                                 => 'sa',
    'santali'                                  => 'sat',
    'sardiska'                                 => 'sc',
    'sasak'                                    => 'sas',
    'schweizertyska'                           => 'gsw',
    'schweiziskfranska'                        => 'fr_ch',
    'schweiziskhögtyska'                      => 'de_ch',
    'selkup'                                   => 'sel',
    'semitisktspråk'                          => 'sem',
    'sena'                                     => 'seh',
    'seneca'                                   => 'see',
    'serbiska'                                 => 'sr',
    'serbokroatiska'                           => 'sh',
    'serer'                                    => 'srr',
    'shambala'                                 => 'ksb',
    'shan'                                     => 'shn',
    'shimaoré'                                => 'swb',
    'shona'                                    => 'sn',
    'sicilianska'                              => 'scn',
    'sidamo'                                   => 'sid',
    'siksika'                                  => 'bla',
    'sindhi'                                   => 'sd',
    'singalesiska'                             => 'si',
    'sinotibetansktspråk'                     => 'sit',
    'siouxspråk'                              => 'sio',
    'skoltsamiska'                             => 'sms',
    'skotska'                                  => 'sco',
    'slavej'                                   => 'den',
    'slavisktspråk'                           => 'sla',
    'slovakiska'                               => 'sk',
    'slovenska'                                => 'sl',
    'soga'                                     => 'xog',
    'sogdiska'                                 => 'sog',
    'somaliska'                                => 'so',
    'songhai'                                  => 'son',
    'soninke'                                  => 'snk',
    'sorbisktspråk'                           => 'wen',
    'spanska'                                  => 'es',
    'sranantongo'                              => 'srn',
    'sukuma'                                   => 'suk',
    'sumeriska'                                => 'sux',
    'sundanesiska'                             => 'su',
    'susu'                                     => 'sus',
    'svenska'                                  => 'sv',
    'swahili'                                  => 'sw',
    'swati'                                    => 'ss',
    'sydaltaiska'                              => 'alt',
    'sydamerikansktindianspråk'               => 'sai',
    'sydndebele'                               => 'nr',
    'sydsamiska'                               => 'sma',
    'sydsotho'                                 => 'st',
    'syriska'                                  => 'syr',
    'szezuani'                                 => 'ii',
    'tachelhit'                                => 'shi',
    'tadzjikiska'                              => 'tg',
    'tagalog'                                  => 'tl',
    'tahitiska'                                => 'ty',
    'taita'                                    => 'dav',
    'tamashek'                                 => 'tmh',
    'tamil'                                    => 'ta',
    'taroko'                                   => 'trv',
    'tasawaq'                                  => 'twq',
    'tatariska'                                => 'tt',
    'teckenspråk'                             => 'sgn',
    'telugiska'                                => 'te',
    'temne'                                    => 'tem',
    'tereno'                                   => 'ter',
    'teso'                                     => 'teo',
    'tetum'                                    => 'tet',
    'thailändska'                             => 'th',
    'thaispråk'                               => 'tai',
    'tibetanska'                               => 'bo',
    'tigrinja'                                 => 'ti',
    'tigré'                                   => 'tig',
    'tivi'                                     => 'tiv',
    'tjeckiska'                                => 'cs',
    'tjetjenska'                               => 'ce',
    'tjuvasjiska'                              => 'cv',
    'tlingit'                                  => 'tli',
    'tokelauiska'                              => 'tkl',
    'tokpisin'                                 => 'tpi',
    'tonganska'                                => 'to',
    'tsimshian'                                => 'tsi',
    'tsonga'                                   => 'ts',
    'tswana'                                   => 'tn',
    'tumbuka'                                  => 'tum',
    'tupíspråk'                              => 'tup',
    'turkiska'                                 => 'tr',
    'turkmeniska'                              => 'tk',
    'tuvaluanska'                              => 'tvl',
    'tuviniska'                                => 'tyv',
    'twi'                                      => 'tw',
    'tyap'                                     => 'kcg',
    'tyska'                                    => 'de',
    'udmurtiska'                               => 'udm',
    'ugaritiska'                               => 'uga',
    'uiguriska'                                => 'ug',
    'ukrainska'                                => 'uk',
    'umbundu'                                  => 'umb',
    'ungerska'                                 => 'hu',
    'urdu'                                     => 'ur',
    'uzbekiska'                                => 'uz',
    'vaj'                                      => 'vai',
    'vallonska'                                => 'wa',
    'venda'                                    => 've',
    'vietnamesiska'                            => 'vi',
    'vitryska'                                 => 'be',
    'volapük'                                 => 'vo',
    'votiska'                                  => 'vot',
    'vunjo'                                    => 'vun',
    'västfrisiska'                            => 'fy',
    'wakusjisktspråk'                         => 'wak',
    'walamo'                                   => 'wal',
    'walesiska'                                => 'cy',
    'walsertyska'                              => 'wae',
    'waray'                                    => 'war',
    'washo'                                    => 'was',
    'wolof'                                    => 'wo',
    'xhosa'                                    => 'xh',
    'yangben'                                  => 'yav',
    'yoruba'                                   => 'yo',
    'zandé'                                   => 'znd',
    'zapotek'                                  => 'zap',
    'zarma'                                    => 'dje',
    'zazaiska'                                 => 'zza',
    'zenaga'                                   => 'zen',
    'zhuang'                                   => 'za',
    'zulu'                                     => 'zu',
    'zuni'                                     => 'zun',
    'österrikisktyska'                        => 'de_at',
    'östfrisiska'                             => 'frs',
);

1;
