package Locales::DB::Language::pl;

# Auto generated from CLDR

$Locales::DB::Language::pl::VERSION = '0.01';

$Locales::DB::Language::pl::cldr_version = '1.7.1';

%Locales::DB::Language::pl::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Język\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "nie\:n",
        'yesstr' => "tak\:t"
    },
);

%Locales::DB::Language::pl::code_to_name = (
    'aa'    => 'afar',
    'ab'    => 'abchaski',
    'ace'   => 'aceh',
    'ach'   => 'aczoli',
    'ada'   => 'adangme',
    'ady'   => 'adygejski',
    'ae'    => 'awestyjski',
    'af'    => 'afrikaans',
    'afa'   => "afro\-azjatycki",
    'afh'   => 'afrihili',
    'ain'   => 'ajnu',
    'ak'    => 'akan',
    'akk'   => 'akadyjski',
    'ale'   => 'aleucki',
    'alg'   => "języki\ algonkin",
    'alt'   => 'południowoałtajski',
    'am'    => 'amharski',
    'an'    => 'aragoński',
    'ang'   => 'staroangielski',
    'anp'   => 'angika',
    'apa'   => "język\ Apaczów",
    'ar'    => 'arabski',
    'arc'   => 'aramejski',
    'arn'   => 'araukański',
    'arp'   => 'arapaho',
    'art'   => 'sztuczny',
    'arw'   => 'arawak',
    'as'    => 'asamski',
    'ast'   => 'asturyjski',
    'ath'   => "język\ Atapasków",
    'aus'   => "język\ australijski",
    'av'    => 'awarski',
    'awa'   => 'awadhi',
    'ay'    => 'ajmara',
    'az'    => 'azerski',
    'ba'    => 'baszkirski',
    'bad'   => "język\ banda",
    'bai'   => "język\ bamileke",
    'bal'   => 'beludżi',
    'ban'   => 'balijski',
    'bas'   => 'basa',
    'bat'   => 'bałtycki',
    'be'    => 'białoruski',
    'bej'   => 'bedża',
    'bem'   => 'bemba',
    'ber'   => 'berberski',
    'bg'    => 'bułgarski',
    'bh'    => 'biharski',
    'bho'   => 'bhodźpuri',
    'bi'    => 'Bislama',
    'bik'   => 'bikol',
    'bin'   => 'bini',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengalski',
    'bnt'   => 'bantu',
    'bo'    => 'tybetański',
    'br'    => 'bretoński',
    'bra'   => 'bradź',
    'bs'    => 'bośniacki',
    'btk'   => 'batak',
    'bua'   => 'buriacki',
    'bug'   => 'bugiński',
    'byn'   => 'blin',
    'ca'    => 'kataloński',
    'cad'   => 'kaddo',
    'cai'   => "język\ Indian\ środkowoamerykańskich",
    'car'   => 'karibi',
    'cau'   => 'kaukaski',
    'cch'   => 'atsam',
    'ce'    => 'czeczeński',
    'ceb'   => 'cebuano',
    'cel'   => 'celtycki',
    'ch'    => 'chamorro',
    'chb'   => 'czibcza',
    'chg'   => 'czagatajski',
    'chk'   => 'truk',
    'chm'   => 'maryjski',
    'chn'   => "żargon\ Chinook",
    'cho'   => 'choctaw',
    'chp'   => 'chipewyan',
    'chr'   => 'czirokezki',
    'chy'   => "język\ Czejenów",
    'cmc'   => 'czam',
    'co'    => 'korsykański',
    'cop'   => 'koptyjski',
    'cpe'   => "angielski\ kreolski\ lub\ pidżin",
    'cpf'   => "francuski\ kreolski\ lub\ pidżin",
    'cpp'   => "portugalski\ kreolski\ lub\ pidżin",
    'cr'    => 'kri',
    'crh'   => "krymski\ turecki",
    'crp'   => "kreolski\ lub\ pidżin",
    'cs'    => 'czeski',
    'csb'   => 'kaszubski',
    'cu'    => "staro\-cerkiewno\-słowiański",
    'cus'   => 'kuszycki',
    'cv'    => 'czuwaski',
    'cy'    => 'walijski',
    'da'    => 'duński',
    'dak'   => 'dakota',
    'dar'   => 'dargwijski',
    'day'   => 'dajak',
    'de'    => 'niemiecki',
    'de_at' => "austriacki\ niemiecki",
    'de_ch' => "wysokoniemiecki\ \(Szwajcaria\)",
    'del'   => 'delaware',
    'den'   => 'slave',
    'dgr'   => 'dogrib',
    'din'   => 'dinka',
    'doi'   => 'dogri',
    'dra'   => 'drawidyjski',
    'dsb'   => 'dolnołużycki',
    'dua'   => 'duala',
    'dum'   => "średniowieczny\ niderlandzki",
    'dv'    => 'malediwski',
    'dyu'   => 'dyula',
    'dz'    => 'dzongkha',
    'ee'    => 'ewe',
    'efi'   => 'efik',
    'egy'   => "starożytny\ egipski",
    'eka'   => 'ekajuk',
    'el'    => 'grecki',
    'elx'   => 'elamicki',
    'en'    => 'angielski',
    'en_au' => "Australian\ English",
    'en_ca' => "kanadyjski\ angielski",
    'en_gb' => "brytyjski\ angielski",
    'en_us' => "angielski\ \(USA\)",
    'enm'   => 'średnioangielski',
    'eo'    => 'esperanto',
    'es'    => 'hiszpański',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'estoński',
    'eu'    => 'baskijski',
    'ewo'   => 'ewondo',
    'fa'    => 'perski',
    'fan'   => 'fang',
    'fat'   => 'fanti',
    'ff'    => 'fulani',
    'fi'    => 'fiński',
    'fil'   => 'filipino',
    'fiu'   => 'ugrofiński',
    'fj'    => 'fidżijski',
    'fo'    => 'farerski',
    'fon'   => 'fon',
    'fr'    => 'francuski',
    'fr_ca' => "kanadyjski\ francuski",
    'fr_ch' => "Swiss\ French",
    'frm'   => 'średniofrancuski',
    'fro'   => 'starofrancuski',
    'frr'   => 'północnofryzyjski',
    'frs'   => "fryzyjski\ wschodni",
    'fur'   => 'friulijski',
    'fy'    => 'fryzyjski',
    'ga'    => 'irlandzki',
    'gaa'   => 'ga',
    'gay'   => 'gayo',
    'gba'   => 'gbaya',
    'gd'    => "szkocki\ gaelicki",
    'gem'   => 'germański',
    'gez'   => 'gyyz',
    'gil'   => 'gilbertański',
    'gl'    => 'galisyjski',
    'gmh'   => "średnio\-wysoko\-niemiecki",
    'gn'    => 'guarani',
    'goh'   => "staro\-wysoko\-niemiecki",
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gocki',
    'grb'   => 'grebo',
    'grc'   => 'starogrecki',
    'gsw'   => "szwajcarski\ niemiecki",
    'gu'    => 'gudźaracki',
    'gv'    => 'manx',
    'gwi'   => 'Gwichʼin',
    'ha'    => 'hausa',
    'hai'   => 'haida',
    'haw'   => 'hawajski',
    'he'    => 'hebrajski',
    'hi'    => 'hindi',
    'hil'   => 'hiligajnon',
    'him'   => 'himachali',
    'hit'   => 'hetycki',
    'hmn'   => 'hmongijski',
    'ho'    => "hiri\ motu",
    'hr'    => 'chorwacki',
    'hsb'   => 'górnołużycki',
    'ht'    => 'haitański',
    'hu'    => 'węgierski',
    'hup'   => 'hupa',
    'hy'    => 'ormiański',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'ibanag',
    'id'    => 'indonezyjski',
    'ie'    => 'interlingue',
    'ig'    => 'igbo',
    'ii'    => 'syczuański',
    'ijo'   => 'ijo',
    'ik'    => 'inupiak',
    'ilo'   => 'ilokano',
    'inc'   => 'indoaryjski',
    'ine'   => 'indoeuropejski',
    'inh'   => 'inguski',
    'io'    => 'ido',
    'ira'   => 'irański',
    'iro'   => 'irokeski',
    'is'    => 'islandzki',
    'it'    => 'włoski',
    'iu'    => 'inuktitut',
    'ja'    => 'japoński',
    'jbo'   => 'lojban',
    'jpr'   => 'judeoperski',
    'jrb'   => 'judeoarabski',
    'jv'    => 'jawajski',
    'ka'    => 'gruziński',
    'kaa'   => 'karakałpacki',
    'kab'   => 'kabylski',
    'kac'   => 'kaczin',
    'kaj'   => 'jju',
    'kam'   => 'kamba',
    'kar'   => 'kareński',
    'kaw'   => 'kawi',
    'kbd'   => 'kabardyjski',
    'kcg'   => 'tyap',
    'kfo'   => 'koro',
    'kg'    => 'kongo',
    'kha'   => 'khasi',
    'khi'   => 'khoisan',
    'kho'   => 'chotański',
    'ki'    => 'kikuju',
    'kj'    => 'kwanyama',
    'kk'    => 'kazachski',
    'kl'    => 'grenlandzki',
    'km'    => 'khmerski',
    'kmb'   => 'kimbundu',
    'kn'    => 'kannada',
    'ko'    => 'koreański',
    'kok'   => 'konkani',
    'kos'   => 'kosrae',
    'kpe'   => 'kpelle',
    'kr'    => 'kanuri',
    'krc'   => "karaczajsko\-bałkarski",
    'krl'   => 'karelski',
    'kro'   => 'kru',
    'kru'   => 'kurukh',
    'ks'    => 'kaszmirski',
    'ku'    => 'kurdyjski',
    'kum'   => 'kumycki',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'kornijski',
    'ky'    => 'kirgiski',
    'la'    => 'łaciński',
    'lad'   => 'ladyński',
    'lah'   => 'lahnda',
    'lam'   => 'lamba',
    'lb'    => 'luksemburski',
    'lez'   => 'lezgijski',
    'lg'    => 'ganda',
    'li'    => 'limburgijski',
    'ln'    => 'lingala',
    'lo'    => 'laotański',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'litewski',
    'lu'    => "luba\-katanga",
    'lua'   => "luba\-lulua",
    'lui'   => 'luiseno',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lushai',
    'lv'    => 'łotewski',
    'mad'   => 'madurajski',
    'mag'   => 'magahi',
    'mai'   => 'maithili',
    'mak'   => 'makasar',
    'man'   => 'mandingo',
    'map'   => 'austronezyjski',
    'mas'   => 'masajski',
    'mdf'   => 'moksha',
    'mdr'   => 'mandar',
    'men'   => 'mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'malgaski',
    'mga'   => 'średnioirlandzki',
    'mh'    => 'marshall',
    'mi'    => 'maoryjski',
    'mic'   => 'micmac',
    'min'   => 'minangkabu',
    'mis'   => "inny\ język",
    'mk'    => 'macedoński',
    'mkh'   => "mon\-khmer",
    'ml'    => 'malajalam',
    'mn'    => 'mongolski',
    'mnc'   => 'manchu',
    'mni'   => 'manipuryjski',
    'mno'   => 'manobo',
    'mo'    => 'mołdawski',
    'moh'   => 'mohawk',
    'mos'   => 'mossi',
    'mr'    => 'marathi',
    'ms'    => 'malajski',
    'mt'    => 'maltański',
    'mul'   => "wiele\ języków",
    'mun'   => 'mundajski',
    'mus'   => 'creek',
    'mwl'   => 'mirandese',
    'mwr'   => 'marwari',
    'my'    => 'birmański',
    'myn'   => "język\ Majów",
    'myv'   => 'erzya',
    'na'    => 'nauru',
    'nah'   => 'nahuatl',
    'nai'   => "język\ Indian\ północnoamerykańskich",
    'nap'   => 'neapolitański',
    'nb'    => "norweski\ Bokmål",
    'nd'    => "ndebele\ północny",
    'nds'   => 'dolnosaksoński',
    'ne'    => 'nepalski',
    'new'   => 'newarski',
    'ng'    => 'ndonga',
    'nia'   => 'nias',
    'nic'   => 'nigrokordofański',
    'niu'   => 'niue',
    'nl'    => 'niderlandzki',
    'nl_be' => "flamandzki\ \(Belgia\)",
    'nn'    => "norweski\ Nynorsk",
    'no'    => 'norweski',
    'nog'   => 'nogajski',
    'non'   => 'staronordyjski',
    'nqo'   => 'n’ko',
    'nr'    => "ndebele\ południowy",
    'nso'   => "sotho\ północny",
    'nub'   => 'nubijski',
    'nv'    => 'nawaho',
    'nwc'   => "newarski\ klasyczny",
    'ny'    => 'njandża',
    'nym'   => 'niamwezi',
    'nyn'   => 'nyankole',
    'nyo'   => 'nyoro',
    'nzi'   => 'nzema',
    'oc'    => 'prowansalski',
    'oj'    => 'odżibwa',
    'om'    => 'oromski',
    'or'    => 'orija',
    'os'    => 'osetyjski',
    'osa'   => 'osage',
    'ota'   => "osmańsko\-turecki",
    'oto'   => 'otomi',
    'pa'    => 'pendżabski',
    'paa'   => 'papuaski',
    'pag'   => 'pangasino',
    'pal'   => 'pahlavi',
    'pam'   => 'pampango',
    'pap'   => 'papiamento',
    'pau'   => 'palau',
    'peo'   => 'staroperski',
    'phi'   => 'filipiński',
    'phn'   => 'fenicki',
    'pi'    => 'palijski',
    'pl'    => 'polski',
    'pon'   => 'ponpejski',
    'pra'   => 'prakryty',
    'pro'   => 'staroprowansalski',
    'ps'    => 'paszto',
    'pt'    => 'portugalski',
    'pt_br' => "brazylyjski\ portugalski",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'keczua',
    'raj'   => 'radźasthani',
    'rap'   => 'rapanui',
    'rar'   => 'rarotonga',
    'rm'    => 'retoromański',
    'rn'    => 'rundi',
    'ro'    => 'rumuński',
    'roa'   => 'romański',
    'rom'   => 'cygański',
    'ru'    => 'rosyjski',
    'rup'   => 'arumuński',
    'rw'    => "kinya\-ruanda",
    'sa'    => 'sanskryt',
    'sad'   => 'sandawe',
    'sah'   => 'jakucki',
    'sai'   => "język\ Indian\ południowoamerykańskich",
    'sal'   => 'salisz',
    'sam'   => "samarytański\ aramejski",
    'sas'   => 'sasak',
    'sat'   => 'santali',
    'sc'    => 'sardyński',
    'scn'   => 'sycylijski',
    'sco'   => 'szkocki',
    'sd'    => 'sindhi',
    'se'    => "lapoński\ północny",
    'sel'   => 'selkupski',
    'sem'   => 'semicki',
    'sg'    => 'sango',
    'sga'   => 'staroirlandzki',
    'sgn'   => 'migowy',
    'sh'    => "serbsko\-chorwacki",
    'shn'   => 'shan',
    'si'    => 'syngaleski',
    'sid'   => 'sidamo',
    'sio'   => 'siouański',
    'sit'   => "chińsko\-tybetański",
    'sk'    => 'słowacki',
    'sl'    => 'słoweński',
    'sla'   => 'słowiański',
    'sm'    => 'samoański',
    'sma'   => "lapoński\ południowy",
    'smi'   => 'lapoński',
    'smj'   => "lapoński\ Lule",
    'smn'   => "lapoński\ Inari",
    'sms'   => "lapoński\ Skolt",
    'sn'    => 'szona',
    'snk'   => 'soninke',
    'so'    => 'somalijski',
    'sog'   => 'sogdyjski',
    'son'   => 'songhaj',
    'sq'    => 'albański',
    'sr'    => 'serbski',
    'srn'   => "sranan\ tongo",
    'srr'   => 'serer',
    'ss'    => 'siswati',
    'ssa'   => 'nilosaharyjski',
    'st'    => "sotho\ południowy",
    'su'    => 'sundajski',
    'suk'   => 'sukuma',
    'sus'   => 'susu',
    'sux'   => 'sumeryjski',
    'sv'    => 'szwedzki',
    'sw'    => 'suahili',
    'syc'   => 'syriacki',
    'syr'   => 'syryjski',
    'ta'    => 'tamilski',
    'tai'   => 'tai',
    'te'    => 'telugu',
    'tem'   => 'temne',
    'ter'   => 'tereno',
    'tet'   => 'tetum',
    'tg'    => 'tadżycki',
    'th'    => 'tajski',
    'ti'    => 'tigrinia',
    'tig'   => 'tigre',
    'tiv'   => 'tiw',
    'tk'    => 'turkmeński',
    'tkl'   => 'tokelau',
    'tl'    => 'tagalski',
    'tlh'   => 'klingoński',
    'tli'   => 'tlingit',
    'tmh'   => 'tamaszek',
    'tn'    => 'setswana',
    'to'    => 'tonga',
    'tog'   => "tonga\ \(Niasa\)",
    'tpi'   => "tok\ pisin",
    'tr'    => 'turecki',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tsimshian',
    'tt'    => 'tatarski',
    'tum'   => 'tumbuka',
    'tup'   => 'tupi',
    'tut'   => 'ałtajski',
    'tvl'   => 'tuvalu',
    'tw'    => 'twi',
    'ty'    => 'tahitański',
    'tyv'   => 'tuwiński',
    'udm'   => 'udmurcki',
    'ug'    => 'ujgurski',
    'uga'   => 'ugarycki',
    'uk'    => 'ukraiński',
    'umb'   => 'umbundu',
    'und'   => "nieznany\ lub\ niepoprawny\ język",
    'ur'    => 'urdu',
    'uz'    => 'uzbecki',
    'vai'   => 'wai',
    've'    => 'venda',
    'vi'    => 'wietnamski',
    'vo'    => 'volapuk',
    'vot'   => 'wotiacki',
    'wa'    => 'waloński',
    'wak'   => 'wakasz',
    'wal'   => 'walamo',
    'war'   => 'waraj',
    'was'   => 'washo',
    'wen'   => 'łużycki',
    'wo'    => 'wolof',
    'xal'   => 'kałmucki',
    'xh'    => 'khosa',
    'yao'   => 'yao',
    'yap'   => 'japski',
    'yi'    => 'jidysz',
    'yo'    => 'joruba',
    'ypk'   => 'jupik',
    'za'    => 'czuang',
    'zap'   => 'zapotecki',
    'zbl'   => 'bliss',
    'zen'   => 'zenaga',
    'zh'    => 'chiński',
    'znd'   => 'azande',
    'zu'    => 'zulu',
    'zun'   => 'zuni',
    'zxx'   => "brak\ treści\ o\ charakterze\ lingwistycznym",
    'zza'   => 'zazaki',
);

%Locales::DB::Language::pl::name_to_code = (
    'abchaski'                              => 'ab',
    'aceh'                                  => 'ace',
    'aczoli'                                => 'ach',
    'adangme'                               => 'ada',
    'adygejski'                             => 'ady',
    'afar'                                  => 'aa',
    'afrihili'                              => 'afh',
    'afrikaans'                             => 'af',
    'afroazjatycki'                         => 'afa',
    'ajmara'                                => 'ay',
    'ajnu'                                  => 'ain',
    'akadyjski'                             => 'akk',
    'akan'                                  => 'ak',
    'albański'                             => 'sq',
    'aleucki'                               => 'ale',
    'amharski'                              => 'am',
    'angielski'                             => 'en',
    'angielskikreolskilubpidżin'           => 'cpe',
    'angielskiusa'                          => 'en_us',
    'angika'                                => 'anp',
    'arabski'                               => 'ar',
    'aragoński'                            => 'an',
    'aramejski'                             => 'arc',
    'arapaho'                               => 'arp',
    'araukański'                           => 'arn',
    'arawak'                                => 'arw',
    'arumuński'                            => 'rup',
    'asamski'                               => 'as',
    'asturyjski'                            => 'ast',
    'atsam'                                 => 'cch',
    'australianenglish'                     => 'en_au',
    'austriackiniemiecki'                   => 'de_at',
    'austronezyjski'                        => 'map',
    'awadhi'                                => 'awa',
    'awarski'                               => 'av',
    'awestyjski'                            => 'ae',
    'azande'                                => 'znd',
    'azerski'                               => 'az',
    'ałtajski'                             => 'tut',
    'balijski'                              => 'ban',
    'bambara'                               => 'bm',
    'bantu'                                 => 'bnt',
    'basa'                                  => 'bas',
    'baskijski'                             => 'eu',
    'baszkirski'                            => 'ba',
    'batak'                                 => 'btk',
    'bałtycki'                             => 'bat',
    'bedża'                                => 'bej',
    'beludżi'                              => 'bal',
    'bemba'                                 => 'bem',
    'bengalski'                             => 'bn',
    'berberski'                             => 'ber',
    'bhodźpuri'                            => 'bho',
    'białoruski'                           => 'be',
    'biharski'                              => 'bh',
    'bikol'                                 => 'bik',
    'bini'                                  => 'bin',
    'birmański'                            => 'my',
    'bislama'                               => 'bi',
    'blin'                                  => 'byn',
    'bliss'                                 => 'zbl',
    'bośniacki'                            => 'bs',
    'bradź'                                => 'bra',
    'braktreściocharakterzelingwistycznym' => 'zxx',
    'brazylyjskiportugalski'                => 'pt_br',
    'bretoński'                            => 'br',
    'brytyjskiangielski'                    => 'en_gb',
    'bugiński'                             => 'bug',
    'buriacki'                              => 'bua',
    'bułgarski'                            => 'bg',
    'cebuano'                               => 'ceb',
    'celtycki'                              => 'cel',
    'chamorro'                              => 'ch',
    'chipewyan'                             => 'chp',
    'chiński'                              => 'zh',
    'chińskotybetański'                   => 'sit',
    'choctaw'                               => 'cho',
    'chorwacki'                             => 'hr',
    'chotański'                            => 'kho',
    'creek'                                 => 'mus',
    'cygański'                             => 'rom',
    'czagatajski'                           => 'chg',
    'czam'                                  => 'cmc',
    'czeczeński'                           => 'ce',
    'czeski'                                => 'cs',
    'czibcza'                               => 'chb',
    'czirokezki'                            => 'chr',
    'czuang'                                => 'za',
    'czuwaski'                              => 'cv',
    'dajak'                                 => 'day',
    'dakota'                                => 'dak',
    'dargwijski'                            => 'dar',
    'delaware'                              => 'del',
    'dinka'                                 => 'din',
    'dogri'                                 => 'doi',
    'dogrib'                                => 'dgr',
    'dolnosaksoński'                       => 'nds',
    'dolnołużycki'                        => 'dsb',
    'drawidyjski'                           => 'dra',
    'duala'                                 => 'dua',
    'duński'                               => 'da',
    'dyula'                                 => 'dyu',
    'dzongkha'                              => 'dz',
    'efik'                                  => 'efi',
    'ekajuk'                                => 'eka',
    'elamicki'                              => 'elx',
    'erzya'                                 => 'myv',
    'esperanto'                             => 'eo',
    'estoński'                             => 'et',
    'ewe'                                   => 'ee',
    'ewondo'                                => 'ewo',
    'fang'                                  => 'fan',
    'fanti'                                 => 'fat',
    'farerski'                              => 'fo',
    'fenicki'                               => 'phn',
    'fidżijski'                            => 'fj',
    'filipino'                              => 'fil',
    'filipiński'                           => 'phi',
    'fiński'                               => 'fi',
    'flamandzkibelgia'                      => 'nl_be',
    'fon'                                   => 'fon',
    'francuski'                             => 'fr',
    'francuskikreolskilubpidżin'           => 'cpf',
    'friulijski'                            => 'fur',
    'fryzyjski'                             => 'fy',
    'fryzyjskiwschodni'                     => 'frs',
    'fulani'                                => 'ff',
    'ga'                                    => 'gaa',
    'galisyjski'                            => 'gl',
    'ganda'                                 => 'lg',
    'gayo'                                  => 'gay',
    'gbaya'                                 => 'gba',
    'germański'                            => 'gem',
    'gilbertański'                         => 'gil',
    'gocki'                                 => 'got',
    'gondi'                                 => 'gon',
    'gorontalo'                             => 'gor',
    'grebo'                                 => 'grb',
    'grecki'                                => 'el',
    'grenlandzki'                           => 'kl',
    'gruziński'                            => 'ka',
    'guarani'                               => 'gn',
    'gudźaracki'                           => 'gu',
    'gwichʼin'                             => 'gwi',
    'gyyz'                                  => 'gez',
    'górnołużycki'                       => 'hsb',
    'haida'                                 => 'hai',
    'haitański'                            => 'ht',
    'hausa'                                 => 'ha',
    'hawajski'                              => 'haw',
    'hebrajski'                             => 'he',
    'herero'                                => 'hz',
    'hetycki'                               => 'hit',
    'hiligajnon'                            => 'hil',
    'himachali'                             => 'him',
    'hindi'                                 => 'hi',
    'hirimotu'                              => 'ho',
    'hiszpański'                           => 'es',
    'hmongijski'                            => 'hmn',
    'hupa'                                  => 'hup',
    'ibanag'                                => 'iba',
    'iberianportuguese'                     => 'pt_pt',
    'iberianspanish'                        => 'es_es',
    'ido'                                   => 'io',
    'igbo'                                  => 'ig',
    'ijo'                                   => 'ijo',
    'ilokano'                               => 'ilo',
    'indoaryjski'                           => 'inc',
    'indoeuropejski'                        => 'ine',
    'indonezyjski'                          => 'id',
    'inguski'                               => 'inh',
    'innyjęzyk'                            => 'mis',
    'interlingua'                           => 'ia',
    'interlingue'                           => 'ie',
    'inuktitut'                             => 'iu',
    'inupiak'                               => 'ik',
    'irański'                              => 'ira',
    'irlandzki'                             => 'ga',
    'irokeski'                              => 'iro',
    'islandzki'                             => 'is',
    'jakucki'                               => 'sah',
    'japoński'                             => 'ja',
    'japski'                                => 'yap',
    'jawajski'                              => 'jv',
    'jidysz'                                => 'yi',
    'jju'                                   => 'kaj',
    'joruba'                                => 'yo',
    'judeoarabski'                          => 'jrb',
    'judeoperski'                           => 'jpr',
    'jupik'                                 => 'ypk',
    'językapaczów'                        => 'apa',
    'językatapasków'                      => 'ath',
    'językaustralijski'                    => 'aus',
    'językbamileke'                        => 'bai',
    'językbanda'                           => 'bad',
    'językczejenów'                       => 'chy',
    'językialgonkin'                       => 'alg',
    'językindianpołudniowoamerykańskich' => 'sai',
    'językindianpółnocnoamerykańskich'  => 'nai',
    'językindianśrodkowoamerykańskich'   => 'cai',
    'językmajów'                          => 'myn',
    'kabardyjski'                           => 'kbd',
    'kabylski'                              => 'kab',
    'kaczin'                                => 'kac',
    'kaddo'                                 => 'cad',
    'kamba'                                 => 'kam',
    'kanadyjskiangielski'                   => 'en_ca',
    'kanadyjskifrancuski'                   => 'fr_ca',
    'kannada'                               => 'kn',
    'kanuri'                                => 'kr',
    'karaczajskobałkarski'                 => 'krc',
    'karakałpacki'                         => 'kaa',
    'karelski'                              => 'krl',
    'kareński'                             => 'kar',
    'karibi'                                => 'car',
    'kaszmirski'                            => 'ks',
    'kaszubski'                             => 'csb',
    'kataloński'                           => 'ca',
    'kaukaski'                              => 'cau',
    'kawi'                                  => 'kaw',
    'kazachski'                             => 'kk',
    'kałmucki'                             => 'xal',
    'keczua'                                => 'qu',
    'khasi'                                 => 'kha',
    'khmerski'                              => 'km',
    'khoisan'                               => 'khi',
    'khosa'                                 => 'xh',
    'kikuju'                                => 'ki',
    'kimbundu'                              => 'kmb',
    'kinyaruanda'                           => 'rw',
    'kirgiski'                              => 'ky',
    'klingoński'                           => 'tlh',
    'komi'                                  => 'kv',
    'kongo'                                 => 'kg',
    'konkani'                               => 'kok',
    'koptyjski'                             => 'cop',
    'koreański'                            => 'ko',
    'kornijski'                             => 'kw',
    'koro'                                  => 'kfo',
    'korsykański'                          => 'co',
    'kosrae'                                => 'kos',
    'kpelle'                                => 'kpe',
    'kreolskilubpidżin'                    => 'crp',
    'kri'                                   => 'cr',
    'kru'                                   => 'kro',
    'krymskiturecki'                        => 'crh',
    'kumycki'                               => 'kum',
    'kurdyjski'                             => 'ku',
    'kurukh'                                => 'kru',
    'kuszycki'                              => 'cus',
    'kutenai'                               => 'kut',
    'kwanyama'                              => 'kj',
    'ladyński'                             => 'lad',
    'lahnda'                                => 'lah',
    'lamba'                                 => 'lam',
    'laotański'                            => 'lo',
    'lapoński'                             => 'smi',
    'lapońskiinari'                        => 'smn',
    'lapońskilule'                         => 'smj',
    'lapońskipołudniowy'                  => 'sma',
    'lapońskipółnocny'                   => 'se',
    'lapońskiskolt'                        => 'sms',
    'lezgijski'                             => 'lez',
    'limburgijski'                          => 'li',
    'lingala'                               => 'ln',
    'litewski'                              => 'lt',
    'lojban'                                => 'jbo',
    'lozi'                                  => 'loz',
    'lubakatanga'                           => 'lu',
    'lubalulua'                             => 'lua',
    'luiseno'                               => 'lui',
    'luksemburski'                          => 'lb',
    'lunda'                                 => 'lun',
    'luo'                                   => 'luo',
    'lushai'                                => 'lus',
    'macedoński'                           => 'mk',
    'madurajski'                            => 'mad',
    'magahi'                                => 'mag',
    'maithili'                              => 'mai',
    'makasar'                               => 'mak',
    'malajalam'                             => 'ml',
    'malajski'                              => 'ms',
    'malediwski'                            => 'dv',
    'malgaski'                              => 'mg',
    'maltański'                            => 'mt',
    'manchu'                                => 'mnc',
    'mandar'                                => 'mdr',
    'mandingo'                              => 'man',
    'manipuryjski'                          => 'mni',
    'manobo'                                => 'mno',
    'manx'                                  => 'gv',
    'maoryjski'                             => 'mi',
    'marathi'                               => 'mr',
    'marshall'                              => 'mh',
    'marwari'                               => 'mwr',
    'maryjski'                              => 'chm',
    'masajski'                              => 'mas',
    'mende'                                 => 'men',
    'micmac'                                => 'mic',
    'migowy'                                => 'sgn',
    'minangkabu'                            => 'min',
    'mirandese'                             => 'mwl',
    'mohawk'                                => 'moh',
    'moksha'                                => 'mdf',
    'mongo'                                 => 'lol',
    'mongolski'                             => 'mn',
    'monkhmer'                              => 'mkh',
    'morisyen'                              => 'mfe',
    'mossi'                                 => 'mos',
    'mołdawski'                            => 'mo',
    'mundajski'                             => 'mun',
    'nahuatl'                               => 'nah',
    'nauru'                                 => 'na',
    'nawaho'                                => 'nv',
    'ndebelepołudniowy'                    => 'nr',
    'ndebelepółnocny'                     => 'nd',
    'ndonga'                                => 'ng',
    'neapolitański'                        => 'nap',
    'nepalski'                              => 'ne',
    'newarski'                              => 'new',
    'newarskiklasyczny'                     => 'nwc',
    'niamwezi'                              => 'nym',
    'nias'                                  => 'nia',
    'niderlandzki'                          => 'nl',
    'niemiecki'                             => 'de',
    'nieznanylubniepoprawnyjęzyk'          => 'und',
    'nigrokordofański'                     => 'nic',
    'nilosaharyjski'                        => 'ssa',
    'niue'                                  => 'niu',
    'njandża'                              => 'ny',
    'nogajski'                              => 'nog',
    'norweski'                              => 'no',
    'norweskibokmål'                       => 'nb',
    'norweskinynorsk'                       => 'nn',
    'nubijski'                              => 'nub',
    'nyankole'                              => 'nyn',
    'nyoro'                                 => 'nyo',
    'nzema'                                 => 'nzi',
    'n’ko'                                => 'nqo',
    'odżibwa'                              => 'oj',
    'orija'                                 => 'or',
    'ormiański'                            => 'hy',
    'oromski'                               => 'om',
    'osage'                                 => 'osa',
    'osetyjski'                             => 'os',
    'osmańskoturecki'                      => 'ota',
    'otomi'                                 => 'oto',
    'pahlavi'                               => 'pal',
    'palau'                                 => 'pau',
    'palijski'                              => 'pi',
    'pampango'                              => 'pam',
    'pangasino'                             => 'pag',
    'papiamento'                            => 'pap',
    'papuaski'                              => 'paa',
    'paszto'                                => 'ps',
    'pendżabski'                           => 'pa',
    'perski'                                => 'fa',
    'polski'                                => 'pl',
    'ponpejski'                             => 'pon',
    'portugalski'                           => 'pt',
    'portugalskikreolskilubpidżin'         => 'cpp',
    'południowoałtajski'                  => 'alt',
    'prakryty'                              => 'pra',
    'prowansalski'                          => 'oc',
    'północnofryzyjski'                   => 'frr',
    'radźasthani'                          => 'raj',
    'rapanui'                               => 'rap',
    'rarotonga'                             => 'rar',
    'retoromański'                         => 'rm',
    'romański'                             => 'roa',
    'rosyjski'                              => 'ru',
    'rumuński'                             => 'ro',
    'rundi'                                 => 'rn',
    'salisz'                                => 'sal',
    'samarytańskiaramejski'                => 'sam',
    'samoański'                            => 'sm',
    'sandawe'                               => 'sad',
    'sango'                                 => 'sg',
    'sanskryt'                              => 'sa',
    'santali'                               => 'sat',
    'sardyński'                            => 'sc',
    'sasak'                                 => 'sas',
    'selkupski'                             => 'sel',
    'semicki'                               => 'sem',
    'serbski'                               => 'sr',
    'serbskochorwacki'                      => 'sh',
    'serer'                                 => 'srr',
    'setswana'                              => 'tn',
    'shan'                                  => 'shn',
    'sidamo'                                => 'sid',
    'siksika'                               => 'bla',
    'sindhi'                                => 'sd',
    'siouański'                            => 'sio',
    'siswati'                               => 'ss',
    'slave'                                 => 'den',
    'sogdyjski'                             => 'sog',
    'somalijski'                            => 'so',
    'songhaj'                               => 'son',
    'soninke'                               => 'snk',
    'sothopołudniowy'                      => 'st',
    'sothopółnocny'                       => 'nso',
    'sranantongo'                           => 'srn',
    'staroangielski'                        => 'ang',
    'starocerkiewnosłowiański'            => 'cu',
    'starofrancuski'                        => 'fro',
    'starogrecki'                           => 'grc',
    'staroirlandzki'                        => 'sga',
    'staronordyjski'                        => 'non',
    'staroperski'                           => 'peo',
    'staroprowansalski'                     => 'pro',
    'starowysokoniemiecki'                  => 'goh',
    'starożytnyegipski'                    => 'egy',
    'suahili'                               => 'sw',
    'sukuma'                                => 'suk',
    'sumeryjski'                            => 'sux',
    'sundajski'                             => 'su',
    'susu'                                  => 'sus',
    'swissfrench'                           => 'fr_ch',
    'sycylijski'                            => 'scn',
    'syczuański'                           => 'ii',
    'syngaleski'                            => 'si',
    'syriacki'                              => 'syc',
    'syryjski'                              => 'syr',
    'szkocki'                               => 'sco',
    'szkockigaelicki'                       => 'gd',
    'szona'                                 => 'sn',
    'sztuczny'                              => 'art',
    'szwajcarskiniemiecki'                  => 'gsw',
    'szwedzki'                              => 'sv',
    'słowacki'                             => 'sk',
    'słoweński'                           => 'sl',
    'słowiański'                          => 'sla',
    'tadżycki'                             => 'tg',
    'tagalski'                              => 'tl',
    'tahitański'                           => 'ty',
    'tai'                                   => 'tai',
    'tajski'                                => 'th',
    'tamaszek'                              => 'tmh',
    'tamilski'                              => 'ta',
    'taroko'                                => 'trv',
    'tatarski'                              => 'tt',
    'telugu'                                => 'te',
    'temne'                                 => 'tem',
    'tereno'                                => 'ter',
    'tetum'                                 => 'tet',
    'tigre'                                 => 'tig',
    'tigrinia'                              => 'ti',
    'tiw'                                   => 'tiv',
    'tlingit'                               => 'tli',
    'tokelau'                               => 'tkl',
    'tokpisin'                              => 'tpi',
    'tonga'                                 => 'to',
    'tonganiasa'                            => 'tog',
    'truk'                                  => 'chk',
    'tsimshian'                             => 'tsi',
    'tsonga'                                => 'ts',
    'tumbuka'                               => 'tum',
    'tupi'                                  => 'tup',
    'turecki'                               => 'tr',
    'turkmeński'                           => 'tk',
    'tuvalu'                                => 'tvl',
    'tuwiński'                             => 'tyv',
    'twi'                                   => 'tw',
    'tyap'                                  => 'kcg',
    'tybetański'                           => 'bo',
    'udmurcki'                              => 'udm',
    'ugarycki'                              => 'uga',
    'ugrofiński'                           => 'fiu',
    'ujgurski'                              => 'ug',
    'ukraiński'                            => 'uk',
    'umbundu'                               => 'umb',
    'urdu'                                  => 'ur',
    'uzbecki'                               => 'uz',
    'venda'                                 => 've',
    'volapuk'                               => 'vo',
    'wai'                                   => 'vai',
    'wakasz'                                => 'wak',
    'walamo'                                => 'wal',
    'walijski'                              => 'cy',
    'waloński'                             => 'wa',
    'waraj'                                 => 'war',
    'washo'                                 => 'was',
    'wielejęzyków'                        => 'mul',
    'wietnamski'                            => 'vi',
    'wolof'                                 => 'wo',
    'wotiacki'                              => 'vot',
    'wysokoniemieckiszwajcaria'             => 'de_ch',
    'węgierski'                            => 'hu',
    'włoski'                               => 'it',
    'yao'                                   => 'yao',
    'zapotecki'                             => 'zap',
    'zazaki'                                => 'zza',
    'zenaga'                                => 'zen',
    'zulu'                                  => 'zu',
    'zuni'                                  => 'zun',
    'łaciński'                            => 'la',
    'łotewski'                             => 'lv',
    'łużycki'                             => 'wen',
    'średnioangielski'                     => 'enm',
    'średniofrancuski'                     => 'frm',
    'średnioirlandzki'                     => 'mga',
    'średniowiecznyniderlandzki'           => 'dum',
    'średniowysokoniemiecki'               => 'gmh',
    'żargonchinook'                        => 'chn',
);

1;
