no warnings;

################################################################################

sub handle_hotkey_focus {

	my ($r) = @_;
	
	<<EOJS
		if (window.event.keyCode == $$r{code} && window.event.altKey && window.event.ctrlKey) {
			document.form.$$r{data}.focus ();
			blockEvent ();
		}
EOJS

}

################################################################################

sub handle_hotkey_href {

	my ($r) = @_;
	
	my $ctrl = $r -> {ctrl} ? '' : '!';
	my $alt  = $r -> {alt}  ? '' : '!';
	
	my $condition = 
		$r -> {off}     ? '0' :
		$r -> {confirm} ? 'window.confirm(' . js_escape ($r -> {confirm}) . ')' : 
		'1';

	if ($r -> {href}) {
			
		return <<EOJS
			if (window.event.keyCode == $$r{code} && $alt window.event.altKey && $ctrl window.event.ctrlKey) {
				if ($condition) {
					nope ('$$r{href}&__from_table=1&salt=' + Math.random () + '&' + scrollable_rows [scrollable_table_row].id, '_self');
				}
				blockEvent ();
			}
EOJS

	}
	else {
		
		return <<EOJS
			if (window.event.keyCode == $$r{code} && $alt window.event.altKey && $ctrl window.event.ctrlKey) {
				if ($condition) {
					var a = document.getElementById ('$$r{data}');
					activate_link (a.href, a.target);
				}
				blockEvent ();
			}
EOJS
	}

}

################################################################################

sub draw_page {

	my ($page) = @_;
	
	$_REQUEST {lpt} ||= $_REQUEST {xls};
	$_REQUEST {__read_only} = 1 if ($_REQUEST {lpt});
		
	delete $_REQUEST {__response_sent};
	
	my $body = '';

	my ($selector, $renderrer);
	
	our @scan2names = ();
	
	our $scrollable_row_id = 0;

	unless ($_REQUEST {error}) {
	
		if ($_REQUEST {id}) {
			$selector  = 'get_item_of_' . $page -> {type};
			$renderrer = 'draw_item_of_' . $page -> {type};
		} 
		elsif ($_REQUEST {dbf}) {
			$selector  = 'select_' . $page -> {type};
			$renderrer = 'dbf_write_' . $page -> {type};
		} 
		else {
			$selector  = 'select_' . $page -> {type};
			$renderrer = 'draw_' . $page -> {type};
		}
		
		my $content;		
		
		eval {
			$content = call_for_role ($selector);
		};
		
		print STDERR $@ if $@;
		
		if ($conf -> {core_auto_edit} && $_REQUEST {id} && ref $content eq HASH && $content -> {fake} > 0) {
			$_REQUEST {__edit} = 1;
		}
				
		return '' if $_REQUEST {__response_sent};
		
		if ($_REQUEST {__popup}) {
			$_REQUEST {__read_only} = 1;
			$_REQUEST {__pack} = 1;
			$_REQUEST {__no_navigation} = 1;
		}

		our $prototype = <<EOX;
<?xml version="1.0" encoding="$$i18n{_charset}"?>
<!-- ?xml-stylesheet type="text/xsl" href="i/zanas-html.xsl"? -->
<page>
EOX


		eval {
			$body = call_for_role ($renderrer, $content);
		};

		if ($_REQUEST {__dump}) {
		
			$_REQUEST {__content_type} ||= 'text/plain; charset=' . $i18n -> {_charset};
			
			$prototype .= "</page>\n";
			
			$prototype =~ s{\&}{\&amp\;}gsm;
			
			return Dumper ({
				request => \%_REQUEST,
				user    => {
					id      => $_USER -> {id},
					role    => $_USER -> {role},
					id_role => $_USER -> {id_role},
				},
				
				content => $content,				
				
#				prototype => $prototype,
				
			});
		}
		
		if ($_REQUEST {__x}) {
		
			$_REQUEST {__content_type} ||= 'text/xml; charset=' . $i18n -> {_charset};
						
			return XML::Simple::XMLout ({
#				request => \%_REQUEST,
				content => $content,
			}, 
				RootName => 'data', 
				XMLDecl  => '<?xml version="1.0" encoding="windows-1251"?>',
			)
						
		}

		if ($_REQUEST {__d}) {
			$_REQUEST {__content_type} ||= 'text/plain; charset=' . $i18n -> {_charset};
			return Dumper ({data => $content});
		}
		
		if ($_REQUEST {__proto}) {
			$_REQUEST {__content_type} ||= 'text/xml; charset=' . $i18n -> {_charset};
			$prototype .= "</page>\n";
			$prototype =~ s{\&}{}gsm;
			return $prototype;
		}

		$_REQUEST {error} = $@ if $@;
		
	}

	if ($_REQUEST {error}) {
	
		my $focus = '';		
		my $field = '';
		if ($_REQUEST {error} =~ s{^\#(\w+)\#\:}{}) {
			$field = $1;
			$focus = <<EOJ;
				var e = window.parent.document.getElementsByName('$field'); 
				if (e && e[0]) {
					e[0].focus ();
				}				
EOJ
		}

		my $message = js_escape ($_REQUEST {error});
		
		
		if ($_REQUEST {__x}) {

			return XML::Simple::XMLout ({
				message => $_REQUEST {error},
				field   => $field,
			}, 
				RootName => 'error',
				XMLDecl  => '<?xml version="1.0" encoding="windows-1251"?>',
			);
			
		}
						
		if ($_REQUEST {__d}) {

			return Dumper ({error => {
				message => $_REQUEST {error},
				field   => $field,
			}});			
			
		}

		my $html = <<EOH;
			<html>
				<head></head>
				<body onLoad="
						$focus 
						history.go (-1); 
						alert($message);
						window.parent.document.body.style.cursor = 'normal';
					">
				</body>
			</html>				
EOH

		return $html;
		
	}
	
	if ($_REQUEST {dbf}) {
		return $body;
	}
	elsif ($_REQUEST {__only_form}) {

		$body =~ s{\\}{\\\\}gsm;
		$body =~ s{\"}{\\\"}gsm; #"
		$body =~ s{[\n\r\s]+}{ }gsm;

		return <<EOH;
		<body onLoad="main()">
			<script>
				function main () {
					window.parent.document.forms ['$_REQUEST{__only_form}'].elements ['_$_REQUEST{__only_field}'].outerHTML = "$body";
					window.parent.document.forms ['$_REQUEST{__only_form}'].elements ['_$_REQUEST{__only_field}'].focus ();
				}
			</script>
		</body>
EOH
	}
	elsif ($_REQUEST{lpt}) {
	
		$body =~ s{^.*?\<table[^\>]*lpt\=\"?(\d)\"?[^\>]*\>}{<table border=$1 cellspacing=0 cellpadding=5>}sm; #"
		$body =~ s{\<table[^\>]*lpt\=\"?(\d)\"?[^\>]*\>}{<table border=$1 cellspacing=0 cellpadding=5>}gsm; #"
		
		$_REQUEST{_xls_checksum} and $body =~ s{</table>}{<tr style="display:none"><td>$_REQUEST{_xls_checksum}</table>};
	
		$_REQUEST{xls} and $body =~ s{<td}{<td style="padding:5px"};

		$_REQUEST{_xml}	= "<xml>$_REQUEST{_xml}</xml>" if $_REQUEST{_xml};

		return <<EOH;
			<html xmlns:x="urn:schemas-microsoft-com:office/excel" xmlns:o="urn:schemas-microsoft-com:office:office">
				<head>
					<title>$$i18n{_page_title}</title>
					<meta http-equiv=Content-Type content="text/html; charset=$$i18n{_charset}">
					$_REQUEST{_xml}
					<style>
						TD {
							padding: 5px;
						}
					</style>
				</head>
				<body bgcolor=white leftMargin=0 topMargin=0 marginwidth="0" marginheight="0">
					$body
				</body>
			</html>
EOH

	}
	
	my $lpt = $body =~ s{<table[^\>]*lpt\=\"?1\"?[^\>]*\>}{\<table cellspacing\=1 cellpadding\=2 id='scrollable_table' width\=100\%\> <!--**-->}gsm; #"
	
	my $menu = draw_menu ($page -> {menu}, $page -> {highlighted_type}, {lpt => $lpt});
	
	$_REQUEST {__scrollable_table_row} ||= 0;
	
	my $meta_refresh = $_REQUEST {__meta_refresh} ? qq{<META HTTP-EQUIV=Refresh CONTENT="$_REQUEST{__meta_refresh}; URL=@{[create_url()]}&__no_focus=1">} : '';	
	
	my $auth_toolbar = $conf -> {core_no_auth_toolbar} ? '' : draw_auth_toolbar ({lpt => $lpt});

	my $root = $_REQUEST{__uri};
	
	my $request_package = ref $apr;
	my $mod_perl = $ENV {MOD_PERL};
	$mod_perl ||= 'NO mod_perl AT ALL';
	
	my $timeout = 1000 * (60 * $conf -> {session_timeout} - 1);
	
	$_REQUEST {__select_rows} += 0;
	
	my $static_salt = $Zanas_VERSION_NAME;
	$static_salt .= '_00000';
	if ($_REQUEST {sid}) {
		$static_salt .= $_REQUEST {sid};
	}
	else {
		$static_salt .= $$ . time ();
		$static_salt =~ s{\.}{}g;
	}
						
	return <<EOH;
		<html>		
			<head>
				<title>$$i18n{_page_title}</title>
								
				<meta name="Generator" content="Zanas ${Zanas::VERSION} / $$SQL_VERSION{string}; parameters are fetched with $request_package; gateway_interface is $ENV{GATEWAY_INTERFACE}; $mod_perl is in use">
				<meta http-equiv=Content-Type content="text/html; charset=$$i18n{_charset}">
				
				$meta_refresh
				
				<LINK href="${root}zanas_${static_salt}.css" type=text/css rel=STYLESHEET>
				@{[ map {<<EOJS} @{$_REQUEST{__include_css}} ]}
					<LINK href="/i/$_.css" type=text/css rel=STYLESHEET>
EOJS

					<script src="${root}navigation_${static_salt}.js">
					</script>
				@{[ map {<<EOCSS} @{$_REQUEST{__include_js}} ]}
					<script type="text/javascript" src="/i/${_}.js">
					</script>
EOCSS
			
				<script>
					var select_rows = $_REQUEST{__select_rows};
					var scrollable_table = null;
					var scrollable_table_row = 0;
					var scrollable_table_row_id = 0;
					var scrollable_table_row = 0;
					var scrollable_table_row_length = 0;
					var scrollable_table_row_cell_old_style = '';
					var is_dirty = false;					
					var scrollable_table_is_blocked = false;
					var q_is_focused = false;					
					var left_right_blocked = false;					
					var scrollable_rows = new Array();		
					var td2sr = new Array ();
					var td2sc = new Array ();
					var last_vert_menu = null;
					var last_main_menu = null;
					var ms_word = null;
					
					function td_on_click () {
						var uid = window.event.srcElement.uniqueID;
						var new_scrollable_table_row = td2sr [uid];
						var new_scrollable_table_row_cell = td2sc [uid];
						if (new_scrollable_table_row == null || new_scrollable_table_row_cell == null) return;
						scrollable_rows [scrollable_table_row].cells [scrollable_table_row_cell].className = scrollable_table_row_cell_old_style;
						scrollable_table_row = new_scrollable_table_row;
						scrollable_table_row_cell = new_scrollable_table_row_cell;
						scrollable_table_row_cell_old_style = scrollable_rows [scrollable_table_row].cells [scrollable_table_row_cell].className;
						scrollable_rows [scrollable_table_row].cells [scrollable_table_row_cell].className += ' row-cell-hilite';
						focus_on_first_input (scrollable_rows [scrollable_table_row].cells [scrollable_table_row_cell]);
						return false;
					}
					
					
					function body_on_load () {

						@{[ $_REQUEST{__no_focus} ? '' : 'window.focus ();' ]}

						@{[ $_REQUEST{sid} ? <<EOK : '' ]}
							keepaliveID = setTimeout ("open('$_REQUEST{__uri}?keepalive=$_REQUEST{sid}', 'invisible'); clearTimeout (keepaliveID)", $timeout);
EOK

						$_REQUEST{__doc_on_load}

						@{[ $_REQUEST {__pack} ? <<EOF : '']}
							var newWidth  = document.all ['bodyArea'].offsetWidth + 10;
							var newHeight = document.all ['bodyArea'].offsetHeight + 30;
							window.resizeTo (newWidth, newHeight);						
							window.moveTo ((screen.width - newWidth) / 2, (screen.height - newHeight) / 2);
EOF

						if (!document.body.getElementsByTagName) return;

						var tables = document.body.getElementsByTagName ('table');

						if (tables != null) {										
							for (var i = 0; i < tables.length; i++) {

								if (tables [i].id != 'scrollable_table') continue;

								var rows = tables [i].tBodies (0).rows;

								for (var j = 0; j < rows.length; j++) {
									scrollable_rows = scrollable_rows.concat (rows [j]);
								}
							}					
						}

						for (var i = 0; i < scrollable_rows.length; i++) {

							var cells = scrollable_rows [i].cells;
							for (var j = 0; j < cells.length; j++) {
								var scrollable_cell = cells [j];
								td2sr [scrollable_cell.uniqueID] = i;
								td2sc [scrollable_cell.uniqueID] = j;
								scrollable_cell.onclick = td_on_click;
								scrollable_cell.oncontextmenu = td_on_click;
							}
						}

						scrollable_table = document.getElementById ('scrollable_table');

						if (scrollable_table) {				

							scrollable_table = scrollable_table.tBodies (0);

							scrollable_table_row = $_REQUEST{__scrollable_table_row};
							scrollable_table_row_cell = 0;

							if (scrollable_rows.length > 0) {
								if (scrollable_table_row > scrollable_rows.length - 1) {
									scrollable_table_row = scrollable_rows.length - 1;
								}
								scrollable_table_row_cell_old_style = scrollable_rows [scrollable_table_row].cells [scrollable_table_row_cell].className;
								scrollable_rows [scrollable_table_row].cells [scrollable_table_row_cell].className += ' row-cell-hilite';
							}
							else {
								scrollable_table = null;
							}

						}

						var focused_inputs = document.getElementsByName ('$_REQUEST{__focused_input}');

						if (focused_inputs != null && focused_inputs.length > 0) {
							var focused_input = focused_inputs [0];
							focused_input.focus ();
							if (focused_input.type == 'radio') {
								focused_input.select ();
							}
						}
						else {	

							var forms = document.forms;
							if (forms != null) {

								var done = 0;

								for (var i = 0; i < forms.length; i++) {

									var elements = forms [i].elements;

									if (elements != null) {

										for (var j = 0; j < elements.length; j++) {

											var element = elements [j];

											if (element.tagName == 'INPUT' && element.name == 'q') {
												break;
											}

											if (
												   (element.tagName == 'INPUT'  && (element.type == 'text' || element.type == 'checkbox' || element.type == 'radio'))
												||  element.tagName == 'TEXTAREA') 
											{
												element.focus ();
												done = 1;
												break;
											}										

										}									

									}

									if (done) {
										break;
									}

								}

							}

						}

						@{[ $_REQUEST {__blur_all} ? <<EOF : '']}

						if (inputs != null) {										
							for (var i = 0; i < inputs.length; i++) {
								inputs [i].blur ();
							}					
						}

EOF

						$_REQUEST{__on_load}
					
					}
					
					
				</script>
				
			</head>
			<body 
				bgcolor=white 
				leftMargin=0 
				topMargin=0 
				marginwidth=0 
				marginheight=0 
				name="body" 
				id="body"
				scroll="auto"
				onload= "body_on_load (); try {StartClock ()} catch (e) {}"
				onbeforeunload="document.body.style.cursor = 'wait'"
				onunload=" try {KillClock ()} catch (e) {}"
				onmousemove="
					if (last_vert_menu && !hasMouse (last_vert_menu, event)) {
						last_vert_menu.style.display = 'none';
						last_vert_menu = null;
					}				
				"
				onkeydown="
				
					if (window.event.keyCode == 88 && window.event.altKey) {
						document.location.href = '$_REQUEST{__uri}?type=_logout&sid=$_REQUEST{sid}&salt=@{[rand]}';
						blockEvent ();
					}
					
					handle_basic_navigation_keys ();
					
					@{[ map {&{"handle_hotkey_$$_{type}"} ($_)} @scan2names ]}
					
				"						
			>
				
				@{[ $_REQUEST{__help_url} ? <<EOHELP : '' ]}
					<script for="body" event="onhelp">
						window.open ('$_REQUEST{__help_url}', '_blank', 'toolbar=no,resizable=yes');
						event.returnValue = false;
					</script>						
EOHELP
				
				
				
				<div id="bodyArea" _style='height:100%; padding:0px; margin:0px'>
					<iframe name=invisible src="${root}0.html" width=0 height=0 application="yes" style="display:none">
					</iframe>
					$auth_toolbar			
					$menu
					$body
				</div>
			</body>
		</html>
EOH
	
}

################################################################################

sub draw_input_cell {

	my ($data, $options) = @_;
	
	return draw_text_cell ($data, $options) if ($_REQUEST {__read_only} && !$data -> {edit}) || $data -> {read_only} || $data -> {off};

	$data -> {attributes} ||= {};
	$data -> {attributes} -> {class} ||= 'row-cell';
	my $attributes = dump_attributes ($data -> {attributes});	
	
	$data -> {size} ||= 30;
				
	my $txt = $data -> {label} || '';
	
	if ($data -> {picture}) {
		$txt = format_picture ($txt, $data -> {picture});
		$txt =~ s/^\s+//g; 
	}
	
			
	check_title ($data);

	if ($i -> {__n} == 0) {
		my $__header = $__headers -> [$__last_header_id ++];
		$prototype .= qq{\t\t\t<input type="checkbox" label="$__header" size="$$data{size}" />\n};
	}
		
	return qq {<td $$data{title} $attributes><nobr><input onFocus="q_is_focused = true; left_right_blocked = true;" onBlur="q_is_focused = false; left_right_blocked = false;" type="text" name="$$data{name}" value="$txt" maxlength="$$data{max_len}" size="$$data{size}"></nobr></td>};

}

################################################################################

sub draw_checkbox_cell {

	my ($data, $options) = @_;
	my $value = $data -> {value} || 1;

	if ($i -> {__n} == 0) {
		my $__header = $__headers -> [$__last_header_id ++];
		$prototype .= qq{\t\t\t<input type="checkbox" label="$__header" />\n};
	}
	
	my $checked = $data -> {checked} ? 'checked' : '';

	$data -> {attributes} ||= {};

	$data -> {attributes} -> {bgcolor} ||= $data    -> {bgcolor};
	$data -> {attributes} -> {bgcolor} ||= $options -> {bgcolor};

	$data -> {attributes} -> {class}   ||= 'row-cell';

	my $attributes = dump_attributes ($data -> {attributes});

	return qq {<td $attributes>&nbsp;} if $data -> {off};	

	check_title ($data);

	return qq {<td $$data{title} $attributes><input type=checkbox class="row-cell" name=$$data{name} $checked value='$value'></td>};
	
}

################################################################################

sub draw_radio_cell {

	my ($data) = @_;
	my $value = $data -> {value} || 1;

	if ($i -> {__n} == 0) {
		my $__header = $__headers -> [$__last_header_id ++];
		$prototype .= qq{\t\t\t<input type="radio" label="$__header" />\n};
	}
	
	my $checked = $data -> {checked} ? 'checked' : '';

	$data -> {attributes} ||= {};
	$data -> {attributes} -> {class} ||= 'row-cell';

	my $attributes = dump_attributes ($data -> {attributes});

	return qq {<td $attributes>&nbsp;} if $data -> {off};	

	check_title ($data);

	return qq {<td $$data{title} $attributes><input type=checkbox class="row-cell" name=$$data{name} $checked value='$value'></td>};
	
}

################################################################################

sub draw_tr {

	my ($options, @tds) = @_;
	
	return qq {<tr>@tds</tr>};

}

################################################################################

sub draw_one_cell_table {

	my ($options, $body) = @_;
	
	return <<EOH			
		<table cellspacing=0 cellpadding=0 width="100%">
				<form name=form action=$_REQUEST{__uri} method=post enctype=multipart/form-data target=invisible>
					<tr><td class=bgr8>$body
				</form>
		</table>
EOH

}

################################################################################

sub draw_table_header {

	my ($cell) = @_;
	
	@{$_REQUEST {__doc_tables}} > 0 or push @{$_REQUEST {__doc_tables}}, q{msword_line (' ???   :'); };
	
	my $no_empty_cells = $conf -> {core_hide_row_buttons} == 2 || $preconf -> {core_hide_row_buttons} == 2;
	
	if (ref $cell eq ARRAY) {
	
		my $marker = int ($cell);
	
		$_REQUEST {__doc_tables} [-1] .= qq{
			var list_start_$marker = ms_word.Selection.Start;
		};		

		my $line = join '', (map {draw_table_header ($_)} @$cell);
		
		$_REQUEST {__doc_tables} [-1] .= qq { 
			var list_end_$marker = ms_word.Selection.End;
			msword_line ('');
			ms_word.Selection.Start = list_start_$marker;
			ms_word.Selection.Range.ListFormat.ApplyBulletDefault ();
			ms_word.Selection.Start = list_end_$marker;
			ms_word.Selection.End = list_end_$marker;
		};

		return (ref $cell -> [0] eq ARRAY ? '' : '<tr>') . $line;
							
	}
	elsif (!ref $cell && ($cell || !$no_empty_cells)) {
	
		$_REQUEST {__doc_tables} [-1] .= qq { 
			msword_line ('$cell');
		};

		return "<th class='row-cell-header'>\&nbsp;$cell\&nbsp;</th>";
		
	}
	
	return '' if $cell -> {hidden};
	return '' if $cell -> {off} or (!$cell -> {label} && $no_empty_cells);
		
	$_REQUEST {__doc_tables} [-1] .= qq { 
		msword_line ('$$cell{label}');
	};

	check_title ($cell);
	
	if ($cell -> {href}) {
		check_href ($cell);
		$cell -> {label} = "<a class=lnk4 href=\"$$cell{href}\"><b>" . $cell -> {label} . "</b></a>";
	}	
	
	$cell -> {label} .= "\&nbsp;\&nbsp;<a class=lnk4 href=\"$$cell{href_asc}\"><b>\&uarr;</b></a>" if $cell -> {href_asc};
	$cell -> {label} .= "\&nbsp;\&nbsp;<a class=lnk4 href=\"$$cell{href_desc}\"><b>\&darr;</b></a>" if $cell -> {href_desc};
	$cell -> {colspan} ||= 1;
	$cell -> {rowspan} ||= 1;
	
	$cell -> {attributes} ||= {};
	$cell -> {attributes} -> {class} ||= 'row-cell-header';
	$cell -> {attributes} -> {colspan} ||= $cell -> {colspan};
	$cell -> {attributes} -> {rowspan} ||= $cell -> {rowspan};
	
	my $attributes = dump_attributes ($cell -> {attributes});
	
	return "<th $attributes $$cell{title}>\&nbsp;$$cell{label}\&nbsp;</th>";

}

################################################################################

sub draw_table {

	return '' if $_REQUEST {__only_form};

	my $headers = [];

	unless (ref $_[0] eq CODE or (ref $_[0] eq ARRAY and ref $_[0] -> [0] eq CODE)) {
		$headers = shift;
	}

	our $__headers = $headers; 
	our $__last_header_id = 0;

	my ($tr_callback, $list, $options) = @_;
	
	return '' if $options -> {off};
			
	my $trs = '';
	my $menus = '';
	
	if (ref $options -> {title} eq HASH) {
		my $title = '';
		unless ($_REQUEST {select}) {
			$options -> {title} -> {height} ||= 10;
			$title .= draw_hr (%{$options -> {title}});
			$title .= draw_window_title ($options -> {title}) if $options -> {title} -> {label};
		}
		$options -> {title} = $title;
	}

	$prototype .= qq{\t<table title="$__last_window_title">\n};
	
	my $ths = @$headers ? '<thead>' . draw_table_header ($headers) . '</thead>' : '';

	if (ref $options -> {top_toolbar} eq ARRAY) {			
		$options -> {top_toolbar} = draw_toolbar (@{ $options -> {top_toolbar} });
	}
	
	$prototype .= qq{\t\t<toolbar>\n};
	$prototype .= $__last_top_toolbar;
	$prototype .= qq{\t\t</toolbar>\n};
	$__last_top_toolbar = '';
	$prototype .= qq{\t\t<body>\n};

	if (ref $options -> {path} eq ARRAY) {
		$options -> {path} = draw_path ({}, $options -> {path});
	}

	if ($options -> {'..'} && !$_REQUEST{lpt}) {
	
		my $url = $_REQUEST {__path} -> [-1];
		if ($conf -> {core_auto_esc} > 0 && $_REQUEST {__last_query_string}) {
			$url = esc_href ();
		}
		
		$scrollable_row_id ++;
	
		$trs = <<EOH;
			<script for="body" event="onkeypress">
				if (window.event.keyCode == 27) {
					activate_link ('$url');
				}
			</script>
			<tr>
				@{[ draw_text_cell ({
					label => '..',
					href  => $url,
					no_select_href => 1,
					attributes => {
						colspan => 0 + @$headers,
					},
				})]}
			</tr>
EOH
	
	}
	
	my @tr_callbacks = ref $tr_callback eq ARRAY ? @$tr_callback : ($tr_callback);
	
	my $n = 0;
	foreach our $i (@$list) {
		$i -> {__n} = $n++;
		$trs .= '<thead>' if $n == @$list && !$i -> {id};
		foreach my $callback (@tr_callbacks) {
#			$trs .= '<tr style="position:relative;left:0px;top:0px;z-index:1;">';
			our $_FLAG_ADD_LAST_QUERY_STRING = 1;
			our @__types = ();
			my $tr = &$callback () or next;
			
			my $tr_id = {href => 'id=' . $i -> {id}};
			check_href ($tr_id);
			$tr_id -> {salt} =~ s{\&salt=[\d\.]+}{};
			
			undef $_FLAG_ADD_LAST_QUERY_STRING;
			
			my $oncontextmenu = '';
			if (@__types && $conf -> {core_hide_row_buttons} > -1 && !$_REQUEST {lpt}) {
				$menus .= draw_vert_menu ($i, \@__types);
				$oncontextmenu  = qq{ oncontextmenu="open_popup_menu('$i'); blockEvent ();"};
			}

			$trs .= "<tr id='$$tr_id{href}'";
			$trs .= $oncontextmenu;
			$trs .= '>';
			$trs .= $tr;
			$trs .= '</tr>';

			$scrollable_row_id ++;
			
		}
		$trs .= '</thead>' if $n == @$list && !$i -> {id};
	}
		
	$options -> {type}   ||= $_REQUEST{type};
	$options -> {action} ||= 'add';
	$options -> {name}   ||= 'form';
	
	my $hiddens = '';
	
	foreach my $key (keys %_REQUEST) {
		next if $key =~ /^_/ or $key =~/^(type|action|sid|__last_query_string)$/;
		$hiddens .= qq {<input type=hidden name=$key value="$_REQUEST{$key}">};
	}
		
	$prototype .= qq{\t\t</body>\n};

	$prototype .= $__last_centered_toolbar;	
	$__last_centered_toolbar = '';
	$prototype .= qq{\t</table>\n};
		
	$options -> {height}     ||= 10000;
	$options -> {min_height} ||= 200;
	
	$$options{toolbar} =~ s{^\s+}{}sm;
	$$options{toolbar} =~ s{\s+$}{}sm;

	my $html = <<EOH;
	
		$$options{title}
		$$options{path}
		$$options{top_toolbar}				
		
		<table cellspacing=0 cellpadding=0 width="100%">
		
			<tr>
		
				<form name=$$options{name} action=$_REQUEST{__uri} method=post enctype=multipart/form-data target=invisible>
					<input type=hidden name=type value=$$options{type}>
					<input type=hidden name=action value=$$options{action}>
					<input type=hidden name=sid value=$_REQUEST{sid}>
					<input type=hidden name=__last_query_string value="$_REQUEST{__last_last_query_string}">
					<input type=hidden name=__last_scrollable_table_row value="$_REQUEST{__last_scrollable_table_row}">
					$hiddens

					<td class=bgr8><div class="table-container" style="height: expression(actual_table_height(this,$$options{min_height},$$options{height},'$__last_centered_toolbar_id'));"><table cellspacing=1 cellpadding=0 width="100%" id="scrollable_table" lpt=$$options{lpt}>
							$ths
						<tbody>
							$trs
						</tbody></table></div>$$options{toolbar}</td></form></tr></table>
		$menus
		
EOH

	$__last_centered_toolbar_id = '';
		
	return $html;

}

################################################################################

sub draw_row_button {

	my ($options) = @_;	
	
	if ($options -> {off} || $_REQUEST {lpt}) {
	
		if ($conf -> {core_hide_row_buttons} == 2 || $preconf -> {core_hide_row_buttons} == 2) {
			return '';
		}
		else {
			return '<td class=bgr0 valign=top nowrap width="1%">&nbsp;</td>' if $options -> {off} || $_REQUEST {lpt};
		}
	
	}
	
	if ($i -> {__n} == 0) {
		my $__header = $__headers -> [$__last_header_id ++];
		$prototype .= qq{\t\t\t<button label="$$options{label}" icon="$$options{icon}" />\n};
	}

	check_href  ($options);

	if ($options -> {confirm}) {
		my $salt = rand;
		my $msg = js_escape ($options -> {confirm});
		$options -> {href} =~ s{\%}{\%25}gsm; 		# wrong, but MSIE uri_unescapes the 1st arg of window.open :-(
		$options -> {href} = qq [javascript:if (confirm ($msg)) {window.open('$$options{href}', '_self')}];
	} 
		
	if ($conf -> {core_show_icons} || $_REQUEST {__core_show_icons}) {	
		my $label = $options -> {label};
		$options -> {label} = qq|<img src="/i/buttons/$$options{icon}.gif" alt="$$options{label}" border=0 hspace=0 vspace=0 align=absmiddle>|;
		$options -> {label} .= "&nbsp;$label" if $options -> {force_label} || $conf -> {core_hide_row_buttons} > -1;
	}
	else {
		$options -> {label} = "\&nbsp;[$$options{label}]\&nbsp;";
	}

	check_title ($options);
	
	if (
		$conf -> {core_auto_esc} == 2 && 
		! (	
			$options -> {keep_esc} ||
			(!exists $options -> {keep_esc} && $options -> {icon} eq 'delete' && !$_REQUEST {id})
		)

	) {
		$options -> {href} =~ s{__last_query_string\=\d+}{__last_query_string\=$_REQUEST{__last_last_query_string}}gsm;
	}
	
	my $vert_line = {label => $options -> {label}, href => $options -> {href}};
	$vert_line -> {label} =~ s{[\[\]]}{}g;
	push @__types, $vert_line;
	
	if ($options -> {href} =~ /^java/) {
		$options -> {target} = '_self';
	}
	
	if ($conf -> {core_hide_row_buttons} == 1 || $preconf -> {core_hide_row_buttons} == 1) {
		return '<td class=bgr0 valign=top nowrap width="1%">&nbsp;</td>';
	}
	elsif ($conf -> {core_hide_row_buttons} == 2 || $preconf -> {core_hide_row_buttons} == 2) {
		return '';
	}
	else {
		return qq {<td $$options{title} class="row-button" valign=top nowrap width="1%"><a TABINDEX=-1 class="row-button" href="$$options{href}" target="$$options{target}">$$options{label}</a></td>};
	}

}

################################################################################

sub draw_row_buttons {

	my ($options, $buttons) = @_;

	return $options -> {off} ? 
		'<td class=bgr4 valign=top nowrap width="1%">&nbsp;</td>':
		(join '', map {draw_row_button ($_)} @$buttons);

}

################################################################################

sub draw_radio_cell {

	my ($options) = @_;
	my $value = $options -> {value} || 1;
	
	my $checked = $options -> {checked} ? 'checked' : '';

	$options -> {attributes} ||= {};
	$options -> {attributes} -> {class} ||= 'txt4';

	my $attributes = dump_attributes ($options -> {attributes});

	return qq {<td $attributes>&nbsp;} if $options -> {off};	

	check_title ($options);

	return qq {<td $$options{title} $attributes><input type=radio name=$$options{name} $checked value='$value'></td>};

}

################################################################################

sub draw_select_cell {

	my ($data, $options) = @_;

	return draw_text_cell ($data, $options) if ($_REQUEST {__read_only} && !$data -> {edit}) || $data -> {read_only} || $data -> {off};
	
	$data -> {attributes} ||= {};
	$data -> {attributes} -> {class} ||= 'txt4';

	my $attributes = dump_attributes ($data -> {attributes});
	return qq {<td $attributes>&nbsp;} if $data -> {off};	

	my $html = defined $data -> {empty} ? qq {<option value="0">$$data{empty}</option>\n} : '';

	$data -> {max_len} ||= $conf -> {max_len};

	foreach my $value (@{$data -> {values}}) {
		my $selected = ($value -> {id} eq $data -> {value}) ? 'selected' : '';
		my $label = trunc_string ($value -> {label}, $data -> {max_len});						
		my $id = $value -> {id};
		$value -> {id} =~ s{\"}{\&quot;}g;
		$html .= qq {<option value="$$value{id}" $selected>$label</option>\n}; #"
	}
	
	my $multiple = $data -> {rows} > 1 ? "multiple size=$$options{rows}" : '';

	return qq {<td $attributes><nobr><select name="$$data{name}" onChange="is_dirty=true; $$options{onChange}" onkeypress="typeAhead()" $multiple>$html</select></nobr></td>};
	
}

1;