################################################################################

sub handler {

	our $_PACKAGE = __PACKAGE__ . '::';
	our $r = shift;
	our $apr = Apache::Request -> new ($r);
	my $parms = $apr -> parms;
	
	require_fresh ($_PACKAGE . '::Config');

   	our $db  = DBI -> connect ($conf -> {'db_dsn'}, $conf -> {'db_user'}, $conf -> {'db_password'}, {RaiseError => 1});
   	
   	$conf -> {dbf_dsn} and our $dbf = DBI -> connect ($conf -> {dbf_dsn}, {RaiseError => 1});

	our %_REQUEST = %{$parms};

	my $action = $_REQUEST {action};
		
	our $_USER = get_user ();
	
	require_fresh ($_PACKAGE . '::Calendar');
	
	eval "our \$_CALENDAR = new ${_PACKAGE}Calendar (\\\%_REQUEST)";

	if (!$_USER and $_REQUEST {type} ne 'logon') {
	
		redirect ("/\?type=logon&_frame=$_REQUEST{_frame}");
		
	}
	else {
	
		my $user_agent = $r->header_in ('User-Agent');

		$_USER -> {drawer_name} = 
			$user_agent =~ /MSIE [56]/  ? 'MSIE_5':
			$user_agent =~ /Mozilla\/3/ ? 'Mozilla_3':
			$user_agent =~ /Mozilla\/5/ ? 'MSIE_5':
			'Unsupported';
		
		require_fresh ("${_PACKAGE}Content::menu");
		require_fresh ("${_PACKAGE}Content::page");

		$page = get_page ();
	
		require_fresh ("${_PACKAGE}Content::$$page{type}");
		require_fresh ("${_PACKAGE}Presentation::$$page{type}");

		if ($action) {
		
			my $sub_name = "validate_${action}_$$page{type}";		
			
			my $error_code = call_for_role ($sub_name);
			
			if ($error_code) {		
				my $error_message_template = $error_messages -> {"${action}_$$page{type}_${error_code}"};
				$_REQUEST {error} = interpolate ($error_message_template);
			}
			
			if ($_REQUEST {error}) {
				out_html ({}, draw_page ($page));
			}
			else {
			
				eval {	
					delete_fakes () if $action eq 'create';
					call_for_role ("do_${action}_$$page{type}"); 					
				};	
				
				if ($@) {
					$_REQUEST {error} = $@;
					out_html ({}, draw_page ($page));
				}
				else {						
					my $url = create_url (action => '');
					out_html ({}, qq {<body onLoad="window.open ('$url&salt=' + Math.random (), '_top')"></body>});
				}
				
			}

			log_action ($_USER -> {id}, $$page{type}, $action, $_REQUEST {error});

		}
		else {

			out_html ({}, draw_page ($page));

		}   

	}
   
   	$db -> disconnect;
	
	return OK;

}

################################################################################

sub out_html {

	my ($options, $html) = @_;
	
	if ($_REQUEST {dbf}) {
		redirect ("/$html");
	}
	
	if ($_REQUEST {xls}) {
		my $fn = 'i/xls/' . time . '.xls';
		open (O, ">$$conf{site_root}/$fn") or die "Can't write to $$conf{site_root}/$fn: $!";
		print O $html;
		close (O);
		redirect ("/$fn");
	}	
	else {
		$_REQUEST {__content_type} ||= 'text/html; charset=windows-1251';
		$r -> content_type ($_REQUEST {__content_type});
		$r -> send_http_header;
		print $html;
	}	

}

1;