#!/usr/bin/perl -w -I ../../lib

use 5.018;

use strict;

use Carp;

{ package Narwhal::Tone;
    use Moose;
    use Moose::Util::TypeConstraints;
    
    enum 'FM', [qw(pluck)];
    
    has 'fm' => (
        is => 'rw',
        isa => 'FM',
    );
    
    has 'note' => (
        is => 'rw',      
        isa => 'Str',
    );
    
    sub BUILD {
        my $self = shift;
        # set default synthesizer
        my @classparts = split(/::/,ref($self));
        $self->fm(lc($classparts[-1]));
    }
    
    sub soxi {
        return("");
    }
}

1;