package Settlers::Resource;
$Settlers::Resource::VERSION = '0.07';
use strict;
use warnings;

sub new
{
  my ($class, $quantity) = @_;
  $quantity ||= 0;
  die "quantity: $quantity must be an integer" unless $quantity =~ /^-?[0-9]+$/;
  return bless { quantity => $quantity }, $class;
}

sub quantity { $_[0]->{quantity} }
sub amount   { $_[0]->{quantity} }
sub name     { $_[0]->{name} }
sub code     { $_[0]->{code} }

# creates a new class with the amounts inverted - useful for balancing trades
sub invert
{
  my $class = ref $_[0];
  return $class->new( - $_[0]->amount );
}
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Settlers::Resource

=head1 VERSION

version 0.07

=head1 AUTHOR

David Farrell <dfarrell@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by David Farrell.

This is free software, licensed under:

  The (two-clause) FreeBSD License

=cut
