package Settlers::Asset::Settlement;
$Settlers::Asset::Settlement::VERSION = '0.07';
use strict;
use warnings;
use Settlers::Resource::Brick;
use Settlers::Resource::Grain;
use Settlers::Resource::Lumber;
use Settlers::Resource::Wool;

sub new
{
  my ($class, $location) = @_;

  die "$class new requires a location argument"
    unless $location && $location->isa('Settlers::Map::Intersection');

  return bless {
    location => $location,
    code     => 'S',
  }, $class;
}

sub code     { $_[0]->{code} }
sub location { $_[0]->{location} }

sub cost
{
  return [
    Settlers::Resource::Brick->new(-1),
    Settlers::Resource::Grain->new(-1),
    Settlers::Resource::Lumber->new(-1),
    Settlers::Resource::Wool->new(-1),
  ];
}
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Settlers::Asset::Settlement

=head1 VERSION

version 0.07

=head1 AUTHOR

David Farrell <dfarrell@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by David Farrell.

This is free software, licensed under:

  The (two-clause) FreeBSD License

=cut
