# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210204173825;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[0568]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[3-6]\\d{10}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[3-6]\\d{10}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15[0-25-9]\\d{8}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"498202", "Althegnenberg",
"492676", "Ulmen",
"496673", "Haunetal",
"49861", "Traunstein",
"4939826", "Blankensee\ bei\ Neustrelitz",
"492675", "Ediger\-Eller",
"492597", "Senden\ Westfalen",
"496107", "Kelsterbach",
"4934384", "Grossbothen",
"495641", "Warburg",
"492590", "Dülmen\-Buldern",
"4939751", "Penkun",
"495278", "Höxter\-Ovenhausen",
"499627", "Freudenberg\ Oberpfalz",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"499549", "Lisberg",
"4933633", "Spreenhagen",
"499393", "Rothenfels\ Unterfranken",
"498802", "Huglfing",
"496639", "Ottrau",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"494942", "Südbrookmerland",
"496246", "Eich\ Rheinhessen",
"492243", "Eitorf",
"497976", "Sulzbach\-Laufen",
"493475", "Lutherstadt\ Eisleben",
"498043", "Jachenau",
"499504", "Stadelhofen",
"496245", "Biblis",
"4939723", "Krien",
"497975", "Untergröningen",
"4933084", "Gutengermendorf",
"493583", "Zittau",
"499728", "Wülfershausen\ Unterfranken",
"494464", "Wittmund\-Carolinensiel",
"498809", "Wessobrunn",
"499182", "Velburg",
"499542", "Schesslitz",
"492843", "Rheinberg",
"495563", "Kreiensen",
"498725", "Wurmannsquick",
"49340", "Dessau\ Anh",
"493943", "Wernigerode",
"4939208", "Loitsche",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"493761", "Werdau\ Sachsen",
"495495", "Vörden\ Kreis\ Vechta",
"494435", "Grossenkneten",
"494104", "Aumühle\ bei\ Hamburg",
"497443", "Dornstetten",
"498726", "Schönau\ Niederbayern",
"4939607", "Kotelow",
"4933979", "Wusterhausen\ Dosse",
"497250", "Kraichtal",
"497175", "Leinzell",
"4933741", "Niedergörsdorf",
"497257", "Bruchsal\-Untergrombach",
"497176", "Spraitbach",
"4936206", "Grossfahner",
"497352", "Ochsenhausen",
"4938844", "Gülze",
"494142", "Steinkirchen\ Kreis\ Stade",
"4936254", "Friedrichswerth",
"492501", "Münster\-Hiltrup",
"498669", "Traunreut",
"496508", "Hetzerath\ Mosel",
"4938327", "Elmenhorst\ Vorpom",
"4938737", "Ganzlin",
"4936945", "Henneberg",
"497374", "Uttenweiler",
"494149", "Fredenbeck",
"494305", "Westensee",
"495027", "Linsburg",
"495556", "Lindau\ Harz",
"496467", "Hatzfeld\ Eder",
"4934922", "Mühlanger",
"496724", "Stromberg\ Hunsrück",
"495555", "Moringen\-Fredelsloh",
"494495", "Friesoythe\-Thüle",
"4938754", "Leussow\ bei\ Ludwigslust",
"495435", "Berge\ bei\ Quakenbrück",
"494496", "Friesoythe\-Markhausen",
"4934293", "Naunhof\ bei\ Grimma",
"497544", "Markdorf",
"497184", "Kaisersbach",
"495436", "Nortrup",
"4934261", "Kühren\ bei\ Wurzen",
"499163", "Dachsbach",
"498331", "Memmingen",
"495582", "Sankt\ Andreasberg",
"496131", "Mainz",
"495142", "Eschede",
"492351", "Lüdenscheid",
"4933336", "Passow\ Kreis\ Uckermark",
"492744", "Herdorf",
"4935053", "Glashütte\ Sachsen",
"497502", "Wolpertswende",
"493562", "Forst\ Lausitz",
"499681", "Windischeschenbach",
"498158", "Tutzing",
"496358", "Kriegsfeld",
"4935021", "Königstein\ Sächsische\ Schweiz",
"4939885", "Jakobshagen",
"493925", "Stassfurt",
"499956", "Eichendorf\-Aufhausen",
"493838", "Bergen\ auf\ Rügen",
"497425", "Trossingen",
"4934223", "Dommitzsch",
"4938873", "Carlow",
"499955", "Mamming",
"497426", "Gosheim",
"498743", "Geisenhausen",
"497385", "Gomadingen",
"495306", "Cremlingen",
"4936459", "Blankenhain\ Thüringen",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"495305", "Sickte",
"497386", "Hayingen",
"495149", "Wienhausen",
"4934322", "Rosswein",
"4933977", "Gumtow",
"494556", "Ahrensbök\-Gnissau",
"496692", "Neustadt\ Hessen",
"498025", "Miesbach",
"494641", "Süderbrarup",
"4936602", "Ronneburg\ Thüringen",
"496223", "Neckargemünd",
"492226", "Rheinbach",
"498026", "Hausham",
"498557", "Mauth",
"4938483", "Brüel",
"4939405", "Hötensleben",
"492225", "Meckenheim\ Rheinland",
"498550", "Philippsreut",
"498161", "Freising",
"492938", "Ense",
"496361", "Rockenhausen",
"499155", "Simmelsdorf",
"499270", "Creussen",
"49351", "Dresden",
"4939452", "Ilsenburg",
"492684", "Puderbach\ Westerwald",
"492825", "Uedem",
"499333", "Sommerhausen",
"499277", "Warmensteinach",
"499372", "Klingenberg\ am\ Main",
"4934920", "Kropstädt",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"492826", "Kranenburg\ Niederrhein",
"498683", "Tittmoning",
"499403", "Donaustauf",
"495942", "Uelsen",
"492368", "Oer\-Erkenschwick",
"499354", "Rieneck",
"4939933", "Vollrathsruhe",
"499963", "Konzell",
"499741", "Bad\ Brückenau",
"494563", "Scharbeutz\-Haffkrug",
"495904", "Lengerich\ Emsl",
"495464", "Alfhausen",
"496024", "Schöllkrippen",
"4937295", "Lugau\ Erzgebirge",
"4938458", "Zehna",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"499446", "Altmannstein",
"498320", "Missen\-Wilhams",
"496120", "Aarbergen",
"498327", "Rettenberg",
"4939396", "Neukirchen\ Altmark",
"496127", "Niedernhausen\ Taunus",
"499445", "Neustadt\ an\ der\ Donau",
"498222", "Burgau\ Schwaben",
"498822", "Oberammergau",
"49931", "Würzburg",
"493533", "Elsterwerda",
"499173", "Thalmässing",
"494608", "Handewitt",
"499132", "Herzogenaurach",
"499607", "Luhe\-Wildenau",
"493494", "Wolfen",
"499524", "Zeil\ am\ Main",
"4939779", "Eggesin",
"496682", "Tann\ Rhön",
"494251", "Hoya",
"4934632", "Mücheln\ Geiseltal",
"494707", "Langen\-Neuenwalde",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"494851", "Marne",
"4936738", "Königsee",
"494924", "Moormerland\-Oldersum",
"492694", "Wershofen",
"4937367", "Lengefeld\ Erzgebirge",
"499708", "Bad\ Bocklet",
"4936702", "Lauscha",
"4934207", "Zwochau",
"497721", "Villingen\ im\ Schwarzwald",
"4939008", "Kunrau",
"498706", "Vilsheim",
"4935952", "Grossröhrsdorf\ OL",
"4938827", "Kalkhorst",
"494124", "Glückstadt",
"499867", "Geslau",
"4934466", "Janisroda",
"498705", "Altfraunhofen",
"495452", "Mettingen\ Westfalen",
"4933877", "Nitzahn",
"499267", "Nordhalben",
"494539", "Westerau",
"492521", "Beckum",
"4936076", "Niederorschel",
"498171", "Wolfratshausen",
"496371", "Landstuhl",
"499260", "Wilhelmsthal\ Oberfranken",
"4935975", "Hohnstein",
"494268", "Bötersen",
"497395", "Ehingen\-Dächingen",
"4933923", "Flecken\ Zechlin",
"495731", "Bad\ Oeynhausen",
"495459", "Hörstel",
"496742", "Boppard",
"497194", "Spiegelberg",
"494486", "Edewecht\-Friedrichsfehn",
"499932", "Osterhofen",
"494791", "Osterholz\-Scharmbeck",
"499973", "Furth\ im\ Wald",
"494485", "Elsfleth\-Huntorf",
"4935246", "Ziegenhain\ Sachsen",
"492378", "Fröndenberg\-Langschede",
"499369", "Uettingen",
"494326", "Wankendorf",
"496704", "Langenlonsheim",
"495592", "Gleichen\-Bremke",
"495474", "Stemwede\-Dielingen",
"4935433", "Vetschau",
"494532", "Bargteheide",
"4935362", "Schönewalde\ bei\ Herzberg",
"499631", "Tirschenreuth",
"492722", "Attendorn",
"4938303", "Sellin\ Ostseebad",
"494452", "Zetel\-Neuenburg",
"496663", "Steinau\ an\ der\ Strasse",
"492666", "Freilingen\ Westerwald",
"4938373", "Katzow",
"4936845", "Gehlberg",
"492548", "Dülmen\-Rorup",
"497335", "Wiesensteig",
"494343", "Laboe",
"497153", "Plochingen",
"497522", "Wangen\ im\ Allgäu",
"497336", "Lonsee",
"497748", "Grafenhausen\ Hochschwarzwald",
"492947", "Anröchte",
"4939030", "Brunau",
"4938202", "Volkenshagen",
"4935263", "Gröditz\ bei\ Riesa",
"4933733", "Stülpe",
"498421", "Eichstätt\ Bayern",
"497966", "Unterschneidheim",
"493466", "Artern\ Unstrut",
"4933361", "Joachimsthal",
"495485", "Ladbergen",
"497965", "Ellwangen\-Röhlingen",
"494731", "Nordenham",
"497134", "Weinsberg",
"494474", "Garrel",
"495325", "Goslar\-Hahnenklee",
"498381", "Lindenberg\ im\ Allgäu",
"496181", "Hanau",
"495532", "Stadtoldendorf",
"496541", "Traben\-Trarbach",
"497529", "Waldburg\ Württemberg",
"4933836", "Butzow\ bei\ Brandenburg",
"495573", "Uslar\-Volpriehausen",
"495326", "Langelsheim",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"4934443", "Teuchern",
"498633", "Tüssling",
"497021", "Kirchheim\ unter\ Teck",
"492205", "Rösrath",
"496655", "Neuhof\ Kreis\ Fulda",
"496049", "Kefenrod",
"4939996", "Törpin",
"492206", "Overath",
"496203", "Ladenburg",
"492653", "Kaisersesch",
"4939777", "Borkenfriede",
"496656", "Ebersburg",
"493771", "Aue\ Sachsen",
"497934", "Weikersheim",
"499192", "Gräfenberg",
"496803", "Mandelbachtal\-Ommersheim",
"497165", "Göppingen\-Hohenstaufen",
"4937369", "Wolkenstein",
"495608", "Söhrewald",
"497166", "Adelberg",
"498679", "Burgkirchen\ an\ der\ Alz",
"499423", "Geiselhöring",
"495251", "Paderborn",
"496042", "Büdingen\ Hessen",
"4939926", "Grabowhöfe",
"492587", "Ennigerloh\-Westkirchen",
"495031", "Wunstorf",
"493304", "Velten",
"497953", "Blaufelden",
"497364", "Oberkochen",
"4939341", "Redekin",
"493847", "Sternberg",
"496477", "Greifenstein\-Nenderoth",
"495924", "Bad\ Bentheim\-Gildehaus",
"496004", "Lich\-Eberstadt",
"4936928", "Neuenhof\ Thüringen",
"492634", "Rengsdorf",
"499383", "Wiesentheid",
"499199", "Kunreuth",
"498654", "Freilassing",
"493342", "Neuenhagen\ bei\ Berlin",
"495707", "Petershagen\ Weser",
"495851", "Dahlenburg",
"498824", "Oberau\ Loisach",
"499406", "Mintraching",
"498685", "Kirchanschöring",
"498168", "Attenkirchen",
"492931", "Arnsberg",
"495621", "Bad\ Wildungen",
"499966", "Wiesenfelden",
"494929", "Ihlow\ Kreis\ Aurich",
"499134", "Neunkirchen\ am\ Brand",
"499405", "Bad\ Abbach",
"493574", "Lauchhammer",
"494271", "Sulingen",
"498686", "Petting",
"499965", "Sankt\ Englmar",
"4939953", "Schwinkendorf",
"494871", "Hohenwestedt",
"499647", "Kirchenthumbach",
"498224", "Offingen\ Donau",
"4936783", "Gehren\ Thüringen",
"499529", "Oberaurach",
"4939991", "Daberkow",
"498023", "Bayrischzell",
"497631", "Müllheim\ Baden",
"492692", "Kelberg",
"494922", "Borkum",
"4939888", "Lychen",
"496226", "Meckesheim",
"492223", "Königswinter",
"499522", "Eltmann",
"494747", "Beverstedt",
"4939921", "Ankershagen",
"499153", "Schnaittach",
"499335", "Aub\ Kreis\ Würzburg",
"492823", "Goch",
"496826", "Bexbach",
"494740", "Loxstedt\-Dedesdorf",
"492361", "Recklinghausen",
"4939346", "Tucheim",
"4933087", "Bredereiche",
"499748", "Motten",
"496684", "Hofbieber\-Schwarzbach",
"496825", "Illingen\ Saar",
"499336", "Bütthard",
"49209", "Gelsenkirchen",
"4939408", "Hadmersleben",
"493923", "Zerbst",
"497423", "Oberndorf\ am\ Neckar",
"4939604", "Wildberg\ bei\ Altentreptow",
"496138", "Mommenheim",
"498338", "Böhen",
"4934775", "Wippra",
"492358", "Meinerzhagen\-Valbert",
"499953", "Pilsting",
"498745", "Bodenkirchen",
"499364", "Zellingen",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"497383", "Münsingen\-Buttenhausen",
"4936454", "Magdala",
"4936257", "Luisenthal\ Thüringen",
"494553", "Geschendorf",
"494122", "Uetersen",
"4938847", "Boizenburg\ Elbe",
"495303", "Wendeburg",
"495454", "Hörstel\-Riesenbeck",
"4936464", "Wormstedt",
"494493", "Friesoythe\-Gehlenberg",
"4938759", "Tewswoos",
"495433", "Badbergen",
"495472", "Bad\ Essen",
"495594", "Bovenden\-Reyershausen",
"4938324", "Velgast",
"4933831", "Weseram",
"494534", "Steinburg\ Kreis\ Storman",
"4937298", "Oelsnitz\ Erzgebirge",
"496351", "Eisenberg\ Pfalz",
"498151", "Starnberg",
"497192", "Murrhardt",
"4933366", "Chorin",
"496744", "Oberwesel",
"499165", "Sugenheim",
"493831", "Stralsund",
"494129", "Haseldorf",
"499166", "Münchsteinach",
"492131", "Neuss",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"4936071", "Teistungen",
"4934493", "Gössnitz\ Thüringen",
"497524", "Bad\ Waldsee",
"4938757", "Neustadt\-Glewe",
"496198", "Eppstein",
"49203", "Duisburg",
"492508", "Drensteinfurt",
"494479", "Molbergen\-Peheim",
"492724", "Finnentrop\-Serkenrode",
"494303", "Schlesen",
"497139", "Neuenstadt\ am\ Kocher",
"494454", "Jade",
"4934461", "Nebra\ Unstrut",
"497708", "Geisingen\-Leipferdingen",
"495553", "Kalefeld",
"493946", "Quedlinburg",
"494472", "Lastrup",
"495534", "Eschershausen\ an\ der\ Lenne",
"498723", "Arnstorf",
"497446", "Lossburg",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"494433", "Dötlingen",
"497445", "Pfalzgrafenweiler",
"4934423", "Heuckewalde",
"492191", "Remscheid",
"495129", "Söhlde",
"497173", "Heubach",
"496501", "Konz",
"4933974", "Dessow",
"49731", "Ulm\ Donau",
"4936259", "Tabarz\ Thüringer\ Wald",
"4935241", "Lommatzsch",
"4933966", "Dranse",
"497132", "Neckarsulm",
"495271", "Höxter",
"497932", "Niederstetten\ Württemberg",
"498046", "Bad\ Heilbrunn",
"499194", "Ebermannstadt",
"492245", "Much",
"4939205", "Langenweddingen",
"492639", "Anhausen\ Kreis\ Neuwied",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"4939363", "Angern",
"498045", "Lenggries\-Fall",
"496243", "Monsheim",
"492246", "Lohmar\ Rheinland",
"4935692", "Kerkwitz",
"497973", "Obersontheim",
"494621", "Schleswig",
"492991", "Marsberg\-Bredelar",
"499087", "Marktoffingen",
"4939391", "Lückstedt",
"499080", "Harburg\ Schwaben",
"493585", "Löbau",
"496843", "Gersheim",
"496457", "Burgwald\ Eder",
"4939262", "Güsten\ Anh",
"4933089", "Himmelpfort",
"495648", "Brakel\-Gehrden",
"492845", "Neukirchen\-Vluyn",
"493586", "Neugersdorf\ Sachsen",
"495565", "Einbeck\-Wenzen",
"496675", "Breitenbach\ am\ Herzberg",
"496597", "Jünkerath",
"495922", "Bad\ Bentheim",
"49395", "Neubrandenburg",
"4936948", "Römhild",
"496002", "Ober\-Mörlen",
"492632", "Andernach",
"499721", "Schweinfurt",
"498652", "Berchtesgaden",
"493344", "Bad\ Freienwalde",
"492673", "Ellenz\-Poltersdorf",
"496676", "Hohenroda\ Hessen",
"497939", "Schrozberg\-Spielbach",
"497260", "Sinsheim\-Hilsbach",
"499396", "Urspringen\ bei\ Lohr",
"497267", "Gemmingen",
"496044", "Schotten\ Hessen",
"493302", "Hennigsdorf",
"4933653", "Ziltendorf",
"499395", "Triefenstein",
"497362", "Bopfingen",
"4939321", "Arneburg",
"497681", "Waldkirch\ Breisgau",
"4936848", "Wernshausen",
"498340", "Baisweil",
"4935930", "Seitschen",
"497955", "Wallhausen\ Württemberg",
"499426", "Oberschneiding",
"496580", "Zemmer",
"494469", "Wangerooge",
"496147", "Trebur",
"498347", "Friesenried",
"4939388", "Goldbeck\ Altm",
"496587", "Zerf",
"495601", "Schauenburg",
"498204", "Mickhausen",
"499385", "Kolitzheim",
"496634", "Gemünden\ Felda",
"499386", "Prosselsheim",
"494902", "Jemgum\-Ditzum",
"498635", "Pleiskirchen",
"492981", "Winterberg\ Westfalen",
"492203", "Cologne\-Porz",
"496206", "Lampertheim",
"492656", "Virneburg",
"494462", "Wittmund",
"496653", "Burghaun",
"499184", "Deining\ Oberpfalz",
"499544", "Baunach",
"498636", "Ampfing",
"496205", "Hockenheim",
"492655", "Weibern",
"498249", "Ettringen\ Wertach",
"495858", "Hitzacker\-Wietzetze",
"493596", "Neustadt\ in\ Sachsen",
"494944", "Wiesmoor",
"4937364", "Reitzenhain\ Erzgebirge",
"497163", "Ebersbach\ an\ der\ Fils",
"496805", "Kleinblittersdorf",
"495258", "Salzkotten",
"499090", "Rain\ Lech",
"493677", "Ilmenau\ Thüringen",
"499502", "Frensdorf",
"496806", "Heusweiler",
"499097", "Marxheim",
"492803", "Wesel\-Büderich",
"4939743", "Zerrenthin",
"495261", "Lemgo",
"495483", "Lienen",
"497741", "Tiengen\ Hochrhein",
"497354", "Erolzheim",
"4935792", "Ossling",
"497963", "Adelmannsfelden",
"4934204", "Schkeuditz",
"494144", "Himmelpforten",
"4938824", "Mallentin",
"497403", "Dunningen",
"4933331", "Casekow",
"499638", "Neualbenreuth",
"495323", "Clausthal\-Zellerfeld",
"493881", "Grevesmühlen",
"498664", "Chieming",
"494630", "Barderup",
"4933874", "Stechow\ Brandenburg",
"494637", "Sterup",
"492181", "Grevenbroich",
"495861", "Dannenberg\ Elbe",
"494102", "Ahrensburg",
"492541", "Coesfeld",
"496188", "Kahl\ am\ Main",
"498388", "Hergensweiler",
"496665", "Sinntal\-Altengronau",
"4935722", "Lauta\ bei\ Hoyerswerda",
"496722", "Rüdesheim\ am\ Rhein",
"49441", "Oldenburg",
"496666", "Freiensteinau",
"492663", "Westerburg\ Westerwald",
"497277", "Wörth\-Büchelberg",
"497333", "Laichingen",
"494109", "Tangstedt\ Bz\ Hamburg",
"499737", "Wartmannsroth",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"4933763", "Bestensee",
"4936925", "Marksuhl",
"494346", "Gettorf",
"4939050", "Bartensleben",
"497156", "Ditzingen",
"499976", "Rötz",
"4933931", "Rheinsberg\ Mark",
"4933746", "Werbig\ bei\ Jüterbog",
"495584", "Hattorf\ am\ Harz",
"498178", "Icking",
"492528", "Ennigerloh\-Enniger",
"495144", "Wathlingen",
"499975", "Waldmünchen\-Geigant",
"492742", "Wissen",
"497504", "Horgenzell",
"494483", "Ovelgönne\-Grossenmeer",
"4936201", "Walschleben",
"493564", "Schwarze\ Pumpe",
"494261", "Rotenburg\ Wümme",
"4938455", "Plaaz",
"497728", "Niedereschach",
"492927", "Neuengeseke",
"495102", "Laatzen",
"494861", "Tönning",
"494323", "Bornhöved",
"497542", "Tettnang",
"4935453", "Drahnsdorf",
"497182", "Welzheim",
"49541", "Osnabrück",
"4933843", "Niemegk",
"4935932", "Guttau",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"4934342", "Neukieritzsch",
"49208", "Oberhausen\ Rheinland",
"498703", "Essenbach",
"495346", "Liebenburg",
"497620", "Schopfheim\-Gersbach",
"497627", "Steinen\ Kreis\ Lörrach",
"4934243", "Bad\ Düben",
"4936735", "Probstzella",
"495345", "Baddeckenstedt",
"495109", "Ronnenberg",
"492371", "Iserlohn",
"497393", "Munderkingen",
"4937603", "Wildenfels",
"496029", "Mömbris",
"495909", "Wettrup",
"492682", "Hamm\ Sieg",
"4939774", "Mönkebude",
"499374", "Eschau",
"4934605", "Gröbers",
"4939005", "Kusey",
"497041", "Mühlacker",
"496694", "Neukirchen\ Knüll",
"499359", "Karlstadt\-Wiesenfeld",
"4934652", "Allstedt",
"4939052", "Erxleben\ bei\ Haldensleben",
"4939062", "Bebertal",
"493329", "Stahnsdorf",
"4939821", "Carpin",
"4939853", "Holzendorf\ bei\ Prenzlau",
"494858", "Sankt\ Margarethen\ Holstein",
"4939863", "Seehausen\ bei\ Prenzlau",
"499443", "Abensberg",
"495902", "Freren",
"492689", "Dierdorf",
"499857", "Schopfloch\ Mittelfranken",
"495462", "Ankum",
"499701", "Sandberg\ Unterfranken",
"496022", "Obernburg\ am\ Main",
"493322", "Falkensee",
"499257", "Zell\ Oberfranken",
"493535", "Herzberg\ Elster",
"499175", "Spalt",
"495944", "Hoogstede",
"499352", "Lohr\ am\ Main",
"494258", "Schwarme",
"499176", "Allersberg",
"4936606", "Kraftsdorf",
"4936458", "Bad\ Berka",
"499207", "Königsfeld\ Oberfranken",
"494208", "Grasberg",
"499302", "Rottendorf\ Unterfranken",
"493395", "Pritzwalk",
"4939456", "Altenbrak",
"493721", "Meinersdorf",
"498622", "Tacherting\-Peterskirchen",
"496095", "Bessenbach",
"4939608", "Staven",
"498293", "Welden\ bei\ Augsburg",
"498766", "Gammelsdorf",
"4939207", "Colbitz",
"4939404", "Ausleben",
"495952", "Sögel",
"497071", "Tübingen",
"496096", "Wiesen\ Unterfranken",
"499344", "Gerchsheim",
"498765", "Bruckberg\ Niederbayern",
"499439", "Neunburg\-Kemnath",
"492294", "Morsbach\ Sieg",
"499145", "Solnhofen",
"496764", "Rheinböllen",
"4937294", "Grünhainichen",
"496420", "Lahntal",
"495060", "Bodenburg",
"499146", "Markt\ Berolzheim",
"496427", "Cölbe\-Schönstadt",
"498094", "Steinhöring",
"495067", "Bockenem",
"4936200", "Elxleben\ bei\ Arnstadt",
"4938738", "Karow\ bei\ Lübz",
"496282", "Walldürn",
"496387", "Sankt\ Julian",
"4938328", "Miltzow",
"498547", "Osterhofen\-Gergweis",
"499473", "Kallmünz",
"498629", "Palling",
"4989", "Munich",
"4933233", "Ketzin",
"494545", "Seedorf\ Lauenburg",
"494185", "Marxen\ Auetal",
"497533", "Allensbach",
"494668", "Klanxbüll",
"497572", "Mengen\ Württemberg",
"4935753", "Grossräschen",
"495159", "Coppenbrügge\-Bisperode",
"494546", "Mustin\ Lauenburg",
"494186", "Buchholz\-Trelde",
"493994", "Malchin",
"492733", "Hilchenbach",
"496736", "Bechenheim",
"496348", "Offenbach\ an\ der\ Queich",
"495174", "Lahstedt",
"499946", "Hohenwarth\ bei\ Kötzing",
"496735", "Eppelsheim",
"4938755", "Eldena",
"4930", "Berlin",
"499945", "Arnbruck",
"498753", "Elsendorf\ Niederbayern",
"4933332", "Gartz\ Oder",
"492772", "Herborn\ Hessen",
"4939820", "Triepkendorf",
"494767", "Bremervörde\-Bevern",
"497579", "Schwenningen\ Baden",
"495523", "Bad\ Sachsa",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"498734", "Reisbach\ Niederbayern",
"495152", "Hessisch\ Oldendorf",
"492754", "Bad\ Laasphe\-Feudingen",
"4935874", "Bernstadt\ an\ der\ Eigen",
"495375", "Müden\ Aller",
"492779", "Greifenstein\-Beilstein",
"4934779", "Abberode",
"494384", "Selent",
"4939884", "Hassleben\ bei\ Prenzlau",
"497554", "Heiligenberg\ Baden",
"494159", "Basthorst",
"499831", "Gunzenhausen",
"495186", "Salzhemmendorf\-Wallensen",
"497434", "Winterlingen",
"492866", "Dorsten\-Rhade",
"4936373", "Buttstädt",
"4938845", "Kaarssen",
"495546", "Scheden",
"4936255", "Goldbach\ bei\ Gotha",
"492571", "Greven\ Westfalen",
"498121", "Markt\ Schwaben",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"492865", "Raesfeld",
"495185", "Duingen",
"495545", "Hedemünden",
"4933932", "Fehrbellin",
"498066", "Bad\ Feilnbach",
"492265", "Reichshof\-Eckenhagen",
"4935843", "Hirschfelde\ bei\ Zittau",
"494174", "Stelle\ Kreis\ Harburg",
"498065", "Tuntenhausen\-Schönau",
"499231", "Marktredwitz",
"492266", "Lindlar",
"497771", "Stockach",
"496263", "Neckargerach",
"4936202", "Neudietendorf",
"497240", "Pfinztal",
"4937383", "Lunzenau",
"497247", "Linkenheim\-Hochstetten",
"495424", "Bad\ Rothenfelde",
"495767", "Warmsen",
"494152", "Geesthacht",
"494523", "Malente",
"496578", "Salmtal",
"4936944", "Rentwertshausen",
"495384", "Seesen\-Gross\ Rhüden",
"4934926", "Pretzsch\ Elbe",
"4935931", "Königswartha",
"499923", "Teisnach",
"493364", "Eisenhüttenstadt",
"497304", "Blaustein\ Württemberg",
"4934341", "Geithain",
"497453", "Altensteig\ Württemberg",
"4934651", "Rossla",
"493335", "Finowfurt",
"493522", "Grossenhain\ Sachsen",
"496855", "Freisen",
"4939051", "Calvörde",
"495208", "Leopoldshöhe",
"499123", "Lauf\ an\ der\ Pegnitz",
"492440", "Nettersheim\-Tondorf",
"499552", "Burghaslach",
"4939061", "Weferlingen",
"492853", "Schermbeck",
"496856", "St\ Wendel\-Niederkirchen",
"4939822", "Kratzeburg",
"492447", "Dahlem\ bei\ Kall",
"499499", "Painten",
"494952", "Rhauderfehn",
"496256", "Lampertheim\-Hüttenfeld",
"492253", "Bad\ Münstereifel",
"496036", "Wölfersheim",
"4934385", "Mutzschen",
"498272", "Wertingen",
"492606", "Winningen\ Mosel",
"498377", "Unterthingau",
"498233", "Kissing",
"498053", "Bad\ Endorf",
"496255", "Lindenfels",
"498370", "Wiggensbach",
"495808", "Gerdau",
"492605", "Löf",
"496035", "Reichelsheim\ Wetterau",
"4933978", "Segeletz",
"498034", "Brannenburg",
"498254", "Altomünster",
"494974", "Neuharlingersiel",
"493529", "Heidenau\ Sachsen",
"4933085", "Seilershof",
"492054", "Essen\-Kettwig",
"493647", "Pössneck",
"492234", "Frechen",
"493966", "Cölpin",
"497906", "Braunsbach",
"497466", "Beuron",
"492834", "Straelen",
"493965", "Burow\ bei\ Altentreptow",
"4939209", "Wanzleben",
"497905", "Langenburg",
"499492", "Parsberg",
"499574", "Marktzeuln",
"495651", "Eschwege",
"494959", "Dollart",
"497465", "Emmingen\-Liptingen",
"499535", "Pfarrweisach",
"496873", "Nonnweiler",
"4935240", "Tauscha\ bei\ Grossenhain",
"49881", "Weilheim\ in\ Oberbayern",
"499227", "Neuenmarkt",
"499536", "Kirchlauter",
"4933878", "Nennhausen",
"499220", "Kasendorf\-Azendorf",
"495841", "Lüchow\ Wendland",
"4939992", "Görmin",
"496832", "Beckingen\-Reimsbach",
"492561", "Ahaus",
"499827", "Lichtenau\ Mittelfranken",
"492150", "Meerbusch\-Lank",
"492275", "Kerpen\-Buir",
"494936", "Grossheide",
"49201", "Essen",
"499482", "Wörth\ an\ der\ Donau",
"492157", "Nettetal\-Kaldenkirchen",
"499820", "Lehrberg",
"496052", "Bad\ Orb",
"495241", "Gütersloh",
"498076", "Pfaffing",
"496232", "Speyer",
"496337", "Grossbundenbach",
"498137", "Petershausen",
"497761", "Bad\ Säckingen",
"494935", "Juist",
"497943", "Schöntal\ Jagst",
"4934607", "Wettin",
"4938828", "Schönberg",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"4934208", "Löbnitz\ bei\ Delitzsch",
"494164", "Harsefeld",
"494828", "Lägerdorf",
"49821", "Augsburg",
"498075", "Amerang",
"4939007", "Tangeln",
"496074", "Rödermark",
"4939922", "Dambeck\ bei\ Röbel",
"496400", "Mücke",
"494365", "Heringsdorf\ Holstein",
"496407", "Rabenau\ Hessen",
"494366", "Grömitz\-Cismar",
"495777", "Diepenau\-Essern",
"496568", "Wolsfeld",
"496645", "Ulrichstein",
"496059", "Jossgrund",
"496239", "Bobenheim\-Roxheim",
"492643", "Altenahr",
"496646", "Grebenau",
"4939320", "Schinne",
"4936929", "Ruhla",
"498784", "Hohenthann",
"496551", "Prüm",
"498862", "Steingaden\ Oberbayern",
"497657", "Eisenbach\ Hochschwarzwald",
"498262", "Mittelneufnach",
"4938206", "Graal\-Müritz\ Seeheilbad",
"494334", "Bredenbek\ bei\ Rendsburg",
"4939384", "Arendsee\ Altmark",
"4938457", "Krakow\ am\ See",
"496167", "Modautal",
"498367", "Rosshaupten\ Forggensee",
"4936844", "Rohr\ Thüringen",
"495195", "Neuenkirchen\ bei\ Soltau",
"494964", "Rhede\ Ems",
"494353", "Ascheffel",
"497143", "Besigheim",
"4937368", "Deutschneudorf",
"494135", "Kirchgellersen",
"497583", "Bad\ Schussenried",
"498869", "Kinsau",
"494404", "Elsfleth",
"495196", "Wietzendorf",
"492957", "Wünnenberg\-Haaren",
"4936737", "Drognitz",
"4939390", "Iden",
"494136", "Scharnebeck",
"499078", "Mertingen",
"495503", "Nörten\-Hardenberg",
"498538", "Pocking\-Hartkirchen",
"496786", "Kempfeld",
"497476", "Bisingen",
"493976", "Torgelow\ bei\ Ueckermünde",
"494442", "Lohne\ Oldenburg",
"496785", "Herrstein",
"497475", "Burladingen",
"499564", "Bad\ Rodach",
"492558", "Horstmar",
"498269", "Unteregg\ bei\ Mindelheim",
"4933832", "Rogäsen",
"496301", "Otterbach\ Pfalz",
"4935974", "Hinterhermsdorf",
"49751", "Ravensburg",
"493737", "Rochlitz",
"4936739", "Rottenbach",
"497126", "Burladingen\-Melchingen",
"498458", "Gaimersheim",
"4934462", "Laucha\ Unstrut",
"4936764", "Neuhaus\-Schierschnitz",
"497125", "Bad\ Urach",
"4936072", "Weissenborn\-Lüderode",
"496752", "Kirn\ Nahe",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"494394", "Bokhorst",
"49271", "Siegen",
"493984", "Prenzlau",
"495136", "Burgdorf\ Kreis\ Hannover",
"497484", "Simmersfeld",
"494503", "Timmendorfer\ Strand",
"4936873", "Themar",
"496774", "Kaub",
"4936927", "Unterellen",
"495353", "Königslutter\ am\ Elm",
"4935242", "Nossen",
"495964", "Lähden",
"494195", "Hartenholm",
"495404", "Westerkappeln",
"495135", "Burgwedel\-Fuhrberg",
"4938459", "Laage",
"497324", "Herbrechtingen",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"499463", "Wald\ Oberpfalz",
"499281", "Hof\ Saale",
"492308", "Unna\-Hemmerde",
"495442", "Barnstorf\ Kreis\ Diepholz",
"499903", "Schöllnach",
"496431", "Limburg\ an\ der\ Lahn",
"498084", "Taufkirchen\ Vils",
"499103", "Cadolzburg",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"494841", "Husum\ Nordsee",
"495228", "Vlotho\-Exter",
"499677", "Oberviechtach\-Pullenried",
"497562", "Isny\ im\ Allgäu",
"4936483", "Ziegenrück",
"4933830", "Ziesar",
"495935", "Twist\-Schöninghsdorf",
"496397", "Leimen\ Pfalz",
"495828", "Himbergen",
"492625", "Ochtendung",
"495164", "Hodenhagen",
"492762", "Wenden\ Südsauerland",
"496292", "Seckach",
"495936", "Twist",
"492626", "Selters\ Westferwald",
"4939293", "Dreileben",
"496623", "Rotenburg\ an\ der\ Fulda",
"4935691", "Bärenklau\ NL",
"493544", "Luckau\ Brandenburg",
"494241", "Bassum",
"497569", "Isny\-Eisenbach",
"495366", "Jembke",
"493385", "Rathenow",
"494770", "Wischhafen",
"494777", "Cadenberge",
"499778", "Fladungen",
"495365", "Wolfsburg\-Neindorf",
"493386", "Premnitz",
"4939322", "Tangermünde",
"4939036", "Binde",
"4939223", "Theessen",
"4939009", "Badel",
"4934636", "Schafstädt",
"497838", "Nordrach",
"493425", "Wurzen",
"496086", "Grävenwiesbach",
"4934609", "Salzmünde",
"498283", "Neuburg\ an\ der\ Kammel",
"498461", "Beilngries",
"496085", "Waldsolms",
"493379", "Mahlow",
"499484", "Brennberg",
"496054", "Birstein",
"496234", "Mutterstadt",
"4936258", "Friemar",
"4938848", "Vellahn",
"4935696", "Briesnig",
"494162", "Jork",
"4939266", "Förderstedt",
"495201", "Halle\ Westfalen",
"499324", "Dettelbach",
"498642", "Übersee",
"493963", "Woldegk",
"493741", "Plauen",
"497903", "Mainhardt",
"496834", "Bous",
"497463", "Mühlheim\ an\ der\ Donau",
"4939204", "Niederndodeleben",
"4939407", "Seehausen\ Börde",
"494169", "Sauensiek",
"499126", "Eckental",
"496440", "Kölschhausen",
"492856", "Hamminkeln\-Brünen",
"4939031", "Dähre",
"496853", "Marpingen",
"496447", "Langgöns\-Niederkleen",
"49951", "Bamberg",
"493372", "Jüterbog",
"4937297", "Thum\ Sachsen",
"492855", "Voerde\ Niederrhein",
"495658", "Wehretal",
"498236", "Fischach",
"498056", "Eggstätt",
"492255", "Euskirchen\-Flamersheim",
"498649", "Schleching",
"493877", "Wittenberge",
"498055", "Halfing",
"496253", "Fürth\ Odenwald",
"492256", "Mechernich\-Satzvey",
"49491", "Leer\ Ostfriesland",
"496033", "Butzbach",
"492603", "Bad\ Ems",
"494230", "Verden\-Walle",
"499569", "Sesslach",
"494526", "Ascheberg\ Holstein",
"494237", "Bendingbostel",
"494332", "Hamdorf\ bei\ Rendsburg",
"499238", "Röslau",
"4933433", "Buckow\ Märkische\ Schweiz",
"492064", "Dinslaken",
"492977", "Schmallenberg\-Bödefeld",
"494525", "Ahrensbök",
"4936701", "Lichte",
"4936949", "Obermassfeld\-Grimmenthal",
"493681", "Suhl",
"4935951", "Neukirch\ Lausitz",
"498782", "Pfeffenhausen",
"499925", "Bayerisch\ Eisenstein",
"497456", "Haiterbach",
"496328", "Elmstein",
"494409", "Westerstede\-Ocholt",
"494830", "Süderhastedt",
"497455", "Dornhan",
"499926", "Frauenau",
"494837", "Neuenkirchen\ Dithmarschen",
"495661", "Melsungen",
"496571", "Wittlich",
"494339", "Christiansholm",
"496865", "Mettlach\-Orscholz",
"4935877", "Cunewalde",
"494444", "Goldenstedt",
"4933088", "Falkenthal",
"499562", "Sonnefeld",
"4934743", "Ermsleben",
"496866", "Perl\-Nennig",
"495183", "Lamspringe",
"492863", "Velen",
"495543", "Staufenberg\ Niedersachsen",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"4939887", "Gerswalde",
"494962", "Papenburg\-Aschendorf",
"492263", "Engelskirchen",
"496266", "Hassmersheim",
"494402", "Rastede",
"4933962", "Heiligengrabe",
"498063", "Feldkirchen\-Westerham",
"496265", "Billigheim\ Baden",
"496341", "Landau\ in\ der\ Pfalz",
"498141", "Fürstenfeldbruck",
"496754", "Martinstein",
"498581", "Waldkirchen\ Niederbayern",
"495332", "Schöppenstedt",
"494392", "Nortorf\ bei\ Neumünster",
"4936465", "Oberndorf\ bei\ Apolda",
"495525", "Walkenried",
"49511", "Hannover",
"494297", "Ottersberg\-Posthausen",
"497329", "Steinheim\ am\ Albuch",
"495373", "Hillerse\ Kreis\ Gifhorn",
"4938201", "Gelbensande",
"495237", "Augustdorf",
"4934774", "Röblingen\ am\ See",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"4935361", "Schlieben",
"494661", "Niebüll",
"495837", "Sprakensehl",
"4939605", "Gross\ Nemerow",
"4939889", "Boitzenburg",
"497322", "Giengen\ an\ der\ Brenz",
"494543", "Nusse",
"494183", "Jesteburg",
"4935323", "Sonnewalde",
"497220", "Forbach\-Hundsbach",
"495444", "Wagenfeld",
"495339", "Gielde",
"497227", "Lichtenau\ Baden",
"492735", "Neunkirchen\ Siegerl",
"497482", "Horb\-Dettingen",
"4938325", "Rolofshagen",
"498756", "Nandlstadt",
"496772", "Nastätten",
"4933362", "Liepe\ Kreis\ Barnim",
"4936947", "Jüchsen",
"492736", "Burbach\ Siegerl",
"495962", "Herzlake",
"496733", "Gau\-Odernheim",
"4938735", "Plau\ am\ See",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"499943", "Lam\ Oberpfalz",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"494757", "Wanna",
"499143", "Pappenheim\ Mittelfranken",
"492427", "Nideggen",
"495162", "Fallingbostel",
"492764", "Welschen\ Ennest",
"496294", "Krautheim\ Jagst",
"4936083", "Uder",
"493542", "Lübbenau\ Spreewald",
"498082", "Schwindegg",
"492387", "Drensteinfurt\-Walstedde",
"496894", "St\ Ingbert",
"4938758", "Dömitz",
"497564", "Bad\ Wurzach",
"493504", "Dippoldiswalde",
"4939243", "Nedlitz\ bei\ Zerbst",
"499657", "Waldthurn",
"496093", "Laufach",
"4939409", "Eilsleben",
"498295", "Altenmünster\ Schwaben",
"49591", "Lingen\ \(Ems\)",
"498296", "Villenbach",
"4939342", "Gladau",
"4939752", "Blumenhagen\ bei\ Strasburg",
"498624", "Obing",
"495821", "Bad\ Bevensen",
"495954", "Lorup",
"495363", "Wolfsburg\-Vorsfelde",
"499342", "Wertheim",
"494248", "Bassum\-Neubruchhausen",
"4934604", "Niemberg",
"4939056", "Klüden",
"494671", "Bredstedt",
"494848", "Rantrum",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"4939004", "Köckte\ bei\ Gardelegen",
"493423", "Eilenburg",
"499453", "Thalmassing",
"498285", "Burtenbach",
"4938783", "Dallmin",
"499847", "Ergersheim",
"4935020", "Struppen",
"4939775", "Ahlbeck\ bei\ Torgelow",
"496083", "Weilrod",
"495221", "Herford",
"499349", "Werbach\-Wenkheim",
"499434", "Bodenwöhr",
"499105", "Grosshabersdorf",
"497831", "Hausach",
"496284", "Mudau",
"498468", "Altmannstein\-Pondorf",
"499106", "Markt\ Erlbach",
"492292", "Windeck\ Sieg",
"496762", "Kastellaun",
"495933", "Lathen",
"492623", "Ransbach\-Baumbach",
"496626", "Wildeck\-Obersuhl",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"498507", "Neuburg\ am\ Inn",
"496625", "Niederaula",
"497231", "Pforzheim",
"498092", "Grafing\ bei\ München",
"497051", "Calw",
"495356", "Helmstedt\-Barmke",
"4933742", "Oehna\ Brandenburg",
"495172", "Ilsede",
"494505", "Stockelsdorf\-Curau",
"495355", "Frellstedt",
"494193", "Henstedt\-Ulzburg",
"494506", "Stockelsdorf\-Krumbeck",
"492774", "Dietzhölztal",
"499466", "Stamsried",
"4939387", "Havelberg",
"496308", "Olsbrücken",
"4936847", "Steinbach\-Hallenberg",
"499906", "Mariaposching",
"4938454", "Kritzkow",
"492431", "Erkelenz",
"492759", "Bad\ Berleburg\-Aue",
"497574", "Gammertingen",
"4934953", "Gräfenhainichen",
"499465", "Neukirchen\-Balbini",
"499905", "Bernried\ Niederbayern",
"4938464", "Bernitt",
"4935936", "Sohland\ Spree",
"4936734", "Leutenberg",
"494287", "Heeslingen\-Boitzen",
"4934921", "Kemberg",
"494382", "Wangels",
"499288", "Bad\ Steben",
"492301", "Holzwickede",
"496438", "Hünfelden",
"497552", "Pfullendorf",
"497123", "Metzingen\ Württemberg",
"498591", "Obernzell",
"4934346", "Narsdorf",
"493631", "Nordhausen\ Thüringen",
"498732", "Frontenhausen",
"495154", "Aerzen",
"498773", "Neufahrn\ in\ Niederbayern",
"492752", "Bad\ Laasphe",
"494422", "Sande\ Kreis\ Friesl",
"49671", "Bad\ Kreuznach",
"495193", "Schneverdingen",
"494355", "Rieseby",
"4934262", "Falkenhain\ bei\ Wurzen",
"4933875", "Rhinow",
"497145", "Markgröningen",
"497585", "Ostrach",
"497309", "Weissenhorn",
"4935823", "Ostritz",
"495506", "Adelebsen",
"494133", "Wittorf\ Kreis\ Lüneburg",
"494172", "Salzhausen",
"494356", "Gross\ Wittensee",
"497146", "Remseck\ am\ Neckar",
"495505", "Hardegsen",
"4935796", "Panschwitz\-Kuckau",
"497586", "Herbertingen",
"4934205", "Markranstädt",
"496558", "Büdesheim\ Eifel",
"497432", "Albstadt\-Tailfingen",
"4938825", "Klütz",
"496783", "Baumholder",
"495429", "Melle\-Wellingholzhausen",
"497473", "Mössingen",
"493973", "Pasewalk",
"4934363", "Cavertitz",
"4936924", "Mihla",
"4935726", "Gross\ Särchen",
"498531", "Pocking",
"495382", "Bad\ Gandersheim",
"494179", "Winsen\-Tönnhausen",
"493362", "Erkner",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"4935893", "Mücka",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"4934321", "Leisnig",
"492551", "Steinfurt\-Burgsteinfurt",
"4935022", "Bad\ Schandau",
"496062", "Erbach\ Odenwald",
"49345", "Halle\ Saale",
"495422", "Melle",
"4936849", "Kleinschmalkalden",
"493691", "Eisenach\ Thüringen",
"497751", "Waldshut",
"497344", "Blaubeuren",
"493860", "Raben\ Steinfeld",
"499071", "Dillingen\ an\ der\ Donau",
"494154", "Trittau",
"4939389", "Schollene",
"497807", "Neuried\ Ortenaukreis",
"4938234", "Born\ Darss",
"493867", "Lübstorf",
"494363", "Lensahn",
"494954", "Moormerland",
"4939451", "Wasserleben",
"495248", "Langenberg\ Kreis\ Gütersloh",
"498274", "Buttenwiesen",
"492839", "Straelen\-Herongen",
"494821", "Itzehoe",
"492407", "Herzogenrath\-Kohlscheid",
"494221", "Delmenhorst",
"4936601", "Hermsdorf\ Thüringen",
"492646", "Königsfeld\ Eifel",
"496643", "Herbstein",
"499554", "Untersteinbach\ Unterfranken",
"495671", "Hofgeismar",
"492568", "Heek",
"498039", "Rott\ am\ Inn",
"495848", "Trebel",
"498259", "Schiltberg",
"492645", "Vettelschoss",
"496875", "Nonnweiler\-Primstal",
"499533", "Untermerzbach",
"4937203", "Gersdorf\ bei\ Chemnitz",
"49331", "Potsdam",
"496561", "Bitburg",
"492832", "Kevelaer",
"492873", "Isselburg\-Werth",
"496876", "Weiskirchen\ Saar",
"4937365", "Sayda",
"497660", "St\ Peter\ Schwarzwald",
"499572", "Burgkunstadt",
"497667", "Breisach\ am\ Rhein",
"496276", "Hesseneck",
"492273", "Kerpen\-Horrem",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"492337", "Hagen\-Dahl",
"497946", "Bretzfeld",
"498252", "Schrobenhausen",
"492330", "Herdecke",
"494972", "Langeoog",
"494933", "Dornum\ Ostfriesland",
"496275", "Rothenberg\ Odenwald",
"496150", "Weiterstadt",
"4939423", "Wegeleben",
"497945", "Wüstenrot",
"492052", "Velbert\-Langenberg",
"496157", "Pfungstadt",
"493445", "Naumburg\ Saale",
"492232", "Brühl\ Rheinland",
"498073", "Gars\ am\ Inn",
"499285", "Kirchenlamitz",
"498453", "Reichertshofen\ Oberbayern",
"498847", "Obersöchering",
"492594", "Dülmen",
"492472", "Monschau",
"4933657", "Steinsdorf\ Brandenburg",
"496435", "Wallmerod",
"498304", "Wildpoldsried",
"496104", "Heusenstamm",
"499286", "Oberkotzau",
"499099", "Kaisheim",
"492433", "Hückelhoven",
"493679", "Neuhaus\ am\ Rennweg",
"496436", "Dornburg\ Hessen",
"494191", "Kaltenkirchen\ Holstein",
"496142", "Rüsselsheim",
"498342", "Marktoberdorf",
"496582", "Freudenburg",
"495131", "Garbsen",
"4939959", "Dargun",
"499624", "Ensdorf\ Oberpfalz",
"498247", "Bad\ Wörishofen",
"4939934", "Gross\ Plasten",
"493672", "Rudolstadt",
"495358", "Bahrdorf\-Mackendorf",
"498771", "Ergoldsbach",
"4937326", "Frauenstein\ Sachsen",
"499092", "Wemding",
"494508", "Krummesse",
"497066", "Bad\ Rappenau\-Bonfeld",
"494724", "Cuxhaven\-Lüdingworth",
"499468", "Zell\ Oberpfalz",
"496306", "Trippstadt",
"498106", "Vaterstetten",
"4933470", "Lietzen",
"492303", "Unna",
"499908", "Schöfweg",
"497121", "Reutlingen",
"498593", "Untergriesbach",
"492454", "Gangelt",
"498349", "Stötten\ am\ Auerberg",
"496589", "Kell\ am\ See",
"498434", "Rennertshofen",
"498105", "Gilching",
"496305", "Hochspeyer",
"4938484", "Ventschow",
"494467", "Wittmund\-Funnix",
"4938331", "Rakow\ Vorpom",
"498465", "Kipfenberg",
"495692", "Wolfhagen",
"499451", "Schierling",
"496081", "Usingen",
"497854", "Kehl\-Goldscheuer",
"494632", "Steinbergkirche",
"4939248", "Dobritz",
"495223", "Bünde",
"494107", "Siek\ Kreis\ Stormarn",
"498466", "Denkendorf\ Oberbayern",
"494673", "Joldelund",
"493421", "Torgau",
"4938721", "Ziegendorf",
"495361", "Wolfsburg",
"4938874", "Lützow",
"496628", "Oberaula",
"4938856", "Pritzier\ bei\ Hagenow",
"4934224", "Belgern\ Sachsen",
"493381", "Brandenburg\ an\ der\ Havel",
"495823", "Bienenbüttel",
"4933701", "Grossbeeren",
"497254", "Waghäusel",
"497034", "Ehningen",
"499773", "Unsleben",
"4938791", "Bad\ Wilsnack",
"4935755", "Ortrand",
"497053", "Bad\ Teinach\-Zavelstein",
"494245", "Neuenkirchen\ bei\ Bassum",
"497233", "Niefern\-Öschelbronn",
"4936640", "Remptendorf",
"494639", "Schafflund",
"497272", "Rülzheim",
"495931", "Meppen",
"4933235", "Friesack",
"494246", "Twistringen\-Heiligenloh",
"492621", "Lahnstein",
"499732", "Hammelburg",
"4935054", "Lauenstein\ Sachsen",
"496727", "Gensingen",
"4938753", "Wöbbelin",
"494846", "Hattstedt",
"4936962", "Vacha",
"4939086", "Jävenitz",
"4934294", "Rackwitz",
"4934497", "Langenleuba\-Niederhain",
"494845", "Ostenfeld\ Husum",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"497833", "Hornberg\ Schwarzwaldbahn",
"4935772", "Rietschen",
"496464", "Angelburg",
"495673", "Immenhausen\ Hessen",
"497629", "Tegernau\ Baden",
"492922", "Werl",
"4938422", "Neukloster",
"496641", "Lauterbach\ Hessen",
"494223", "Ganderkesee\-Bookholzberg",
"495632", "Willingen\ Upland",
"497948", "Öhringen\-Ohrnberg",
"492747", "Molzhain",
"493448", "Meuselwitz\ Thüringen",
"494823", "Wilster",
"494361", "Oldenburg\ in\ Holstein",
"4933472", "Golzow\ bei\ Seelow",
"494931", "Norden",
"497765", "Rickenbach\ Hotzenwald",
"498071", "Wasserburg\ am\ Inn",
"495246", "Verl",
"492271", "Bergheim\ Erft",
"4939481", "Hedersleben\ bei\ Aschersleben",
"497622", "Schopfheim",
"4936253", "Georgenthal\ Thüringer\ Wald",
"495245", "Herzebrock\-Clarholz",
"4936375", "Kindelbrück",
"4938843", "Bennin",
"492871", "Bocholt",
"492565", "Gronau\-Epe",
"495845", "Bergen\ Dumme",
"4935471", "Birkenhainchen",
"499531", "Ebern",
"496563", "Kyllburg",
"492566", "Legden",
"495846", "Gartow\ Niedersachsen",
"497471", "Hechingen",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"498554", "Schönberg\ Niederbayern",
"496781", "Idar\-Oberstein",
"499874", "Neuendettelsau",
"493971", "Anklam",
"4936642", "Harra",
"492534", "Münster\-Roxel",
"492680", "Mündersbach",
"497734", "Gailingen",
"495191", "Soltau",
"492129", "Haan\ Rheinland",
"4939724", "Klein\ Bünzow",
"492687", "Horhausen\ Westerwald",
"494131", "Lüneburg",
"499274", "Hollfeld",
"499350", "Eussenheim\-Hundsbach",
"493693", "Meiningen",
"497753", "Albbruck",
"499357", "Gräfendorf\ Bayern",
"499073", "Gundelfingen\ an\ der\ Donau",
"495508", "Gleichen\-Rittmarshausen",
"4937341", "Ehrenfriedersdorf",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"493327", "Werder\ Havel",
"494358", "Loose\ bei\ Eckernförde",
"499252", "Helmbrechts",
"497148", "Grossbottwar",
"4933438", "Altlandsberg",
"495907", "Geeste",
"496020", "Heigenbrücken",
"499852", "Feuchtwangen",
"492553", "Ochtrup",
"495467", "Voltlage",
"4939957", "Gielow",
"496556", "Pronsfeld",
"498572", "Tann\ Niederbayern",
"496027", "Stockstadt\ am\ Main",
"498533", "Rotthalmünster",
"495724", "Obernkirchen",
"496555", "Bleialf",
"4934383", "Trebsen\ Mulde",
"499642", "Kemnath\ Stadt",
"495663", "Spangenberg",
"494749", "Schiffdorf\-Geestenseth",
"496868", "Mettlach\-Tünsdorf",
"498324", "Hindelang",
"496124", "Bad\ Schwalbach",
"493683", "Schmalkalden",
"499604", "Wernberg\-Köblitz",
"496268", "Hüffenhardt",
"4939857", "Drense",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"494371", "Burg\ auf\ Fehmarn",
"499235", "Thierstein",
"498061", "Bad\ Aibling",
"4935828", "Reichenbach\ OL",
"496485", "Nentershausen\ Westerwald",
"497775", "Mühlingen",
"494528", "Schönwalde\ am\ Bungsberg",
"499236", "Nagel",
"499527", "Knetzgau",
"494742", "Dorum",
"4939971", "Gnoien",
"4939749", "Grambow\ bei\ Pasewalk",
"496486", "Katzenelnbogen",
"492261", "Gummersbach",
"496325", "Lambrecht\ Pfalz",
"494927", "Krummhörn\-Loquard",
"499836", "Gunzenhausen\-Cronheim",
"492575", "Greven\-Reckenfeld",
"492697", "Blankenheim\-Ahrhütte",
"494920", "Wirdum",
"495541", "Hann\.\ Münden",
"497458", "Ebhausen",
"496532", "Zeltingen\-Rachtig",
"495181", "Alfeld\ Leine",
"492861", "Borken\ Westfalen",
"492323", "Herne",
"499835", "Ehingen\ Mittelfranken",
"496326", "Deidesheim",
"496573", "Gillenfeld",
"494704", "Drangstedt",
"49851", "Passau",
"499928", "Kirchdorf\ im\ Wald",
"499128", "Feucht",
"4937208", "Auerswalde",
"493961", "Altentreptow",
"497461", "Tuttlingen",
"492858", "Hünxe",
"495655", "Wanfried",
"4937607", "Ebersbrunn\ Sachsen",
"494120", "Ellerhoop",
"495656", "Waldkappel",
"4934444", "Lützen",
"4936426", "Ottendorf\ bei\ Stadtroda",
"4936742", "Uhlstädt",
"4933394", "Blumberg\ Kreis\ Barnim",
"494127", "Westerhorn",
"495203", "Werther\ Westfalen",
"4935600", "Döbern\ NL",
"498238", "Gessertshausen",
"495803", "Rosche",
"4933847", "Görzke",
"499264", "Küps",
"4939428", "Pabstorf",
"4935206", "Kreischa\ bei\ Dresden",
"4933769", "Töpchin",
"494682", "Amrum",
"496031", "Friedberg\ Hessen",
"492601", "Nauort",
"496251", "Bensheim",
"495042", "Bad\ Münder\ am\ Deister",
"4935264", "Strehla",
"4933734", "Felgentreu",
"4938304", "Garz\ Rügen",
"498562", "Triftern",
"4938374", "Lassan\ bei\ Wolgast",
"4938356", "Behrenhoff",
"493331", "Angermünde",
"496707", "Windesheim",
"496851", "St\ Wendel",
"497084", "Schömberg\ bei\ Neuenbürg",
"492902", "Warstein",
"495127", "Harsum",
"494203", "Weyhe\ bei\ Bremen",
"492462", "Linnich",
"4935434", "Altdöbern",
"4933767", "Friedersdorf\ bei\ Berlin",
"4936875", "Straufhain\-Streufdorf",
"492944", "Rietberg\-Mastholte",
"4936021", "Schlotheim",
"499141", "Weissenburg\ in\ Bayern",
"494803", "Pahlen",
"49721", "Karlsruhe",
"493726", "Flöha",
"497130", "Löwenstein\ Württemberg",
"498761", "Moosburg\ an\ der\ Isar",
"493725", "Zschopau",
"4937609", "Wolkenburg\ Mulde",
"4933924", "Rägelin",
"495682", "Borken\ Hessen",
"4933849", "Wiesenburg\ Mark",
"493391", "Neuruppin",
"497644", "Kenzingen",
"49781", "Offenburg",
"494477", "Lastrup\-Hemmelte",
"4938788", "Gross\ Warnow",
"497269", "Sulzfeld\ Baden",
"4939747", "Züsedom",
"499082", "Oettingen\ in\ Bayern",
"49241", "Aachen",
"496452", "Battenberg\ Eder",
"494663", "Süderlügum",
"4937462", "Rothenkirchen\ Vogtland",
"495371", "Gifhorn",
"496599", "Weidenbach\ bei\ Gerolstein",
"498583", "Neureichenau",
"497937", "Dörzbach",
"4933601", "Podelzig",
"492738", "Netphen",
"4939225", "Altengrabow",
"498143", "Inning\ am\ Ammersee",
"496343", "Bad\ Bergzabern",
"497930", "Boxberg\ Baden",
"4933671", "Lieberose",
"493437", "Grimma",
"495742", "Preussisch\ Oldendorf",
"493307", "Zehdenick",
"496731", "Alzey",
"497367", "Aalen\-Ebnat",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"499089", "Bissingen\-Unterringingen",
"493844", "Schwaan",
"499941", "Kötzting",
"49361", "Erfurt",
"497262", "Eppingen",
"499295", "Töpen",
"495528", "Gieboldehausen",
"492584", "Warendorf\-Milte",
"495704", "Petershagen\-Friedewalde",
"498657", "Ramsau\ bei\ Berchtesgaden",
"4939859", "Fürstenwerder",
"498650", "Marktschellenberg",
"4939295", "Zuchau",
"492630", "Mülheim\-Kärlich",
"496474", "Villmar\-Aumenau",
"496592", "Daun",
"496007", "Rosbach\-Rodheim",
"492102", "Ratingen",
"494181", "Buchholz\ in\ der\ Nordheide",
"492637", "Weissenthurm",
"4935602", "Drebkau",
"494541", "Ratzeburg",
"499602", "Neustadt\ an\ der\ Waldnaab",
"493695", "Bad\ Salzungen",
"497755", "Weilheim\ Kreis\ Waldshut",
"49921", "Bayreuth",
"499075", "Glött",
"4933676", "Friedland\ bei\ Beeskow",
"4933654", "Fünfeichen",
"495198", "Schneverdingen\-Wintermoor",
"4933606", "Müllrose",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"499076", "Wittislingen",
"4933458", "Falkenberg\ Mark",
"499644", "Pressath",
"496788", "Sien",
"498536", "Kösslarn",
"497478", "Hirrlingen",
"492555", "Schöppingen",
"498535", "Haarbach",
"492556", "Metelen",
"496553", "Schönecken",
"498322", "Oberstdorf",
"496122", "Hofheim\-Wallau",
"49981", "Ansbach",
"4936378", "Ostramondra",
"4935386", "Prettin",
"496534", "Mülheim\ Mosel",
"494702", "Sandstedt",
"4934781", "Greifenhagen",
"4938220", "Wustrow\ Ostseebad",
"496129", "Schlangenbad",
"494351", "Eckernförde",
"4939364", "Dolle",
"494744", "Loxstedt",
"4933200", "Bergholz\-Rehbrücke",
"497581", "Saulgau",
"497141", "Ludwigsburg\ Württemberg",
"499360", "Thüngen",
"497941", "Öhringen",
"4934745", "Winningen\ Sachsen\-Anhalt",
"497763", "Murg",
"496271", "Eberbach\ Baden",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"499367", "Unterpleichfeld",
"493441", "Zeitz",
"499262", "Wallenfels",
"4936026", "Struth\ bei\ Mühlhausen",
"4936332", "Ellrich",
"496566", "Körperich",
"495457", "Hopsten\-Schale",
"492563", "Stadtlohn",
"495843", "Wustrow\ Wendland",
"496871", "Wadern",
"4934424", "Reuden\ bei\ Zeitz",
"496565", "Dudeldorf",
"496648", "Bad\ Salzschlirf",
"4933435", "Rehfelde",
"495675", "Trendelburg",
"498564", "Johanniskirchen",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"4935057", "Hermsdorf\ Erzgebirge",
"494537", "Sülfeld\ Holstein",
"499269", "Tettau\ Kreis\ Kronach",
"495676", "Liebenau\ Hessen",
"497082", "Neuenbürg\ Württemberg",
"4934494", "Ehrenhain",
"4934297", "Liebertwolkwitz",
"494938", "Hagermarsch",
"494684", "Langeness\ Hallig",
"494825", "Burg\ Dithmarschen",
"495044", "Springe\-Eldagsen",
"496747", "Emmelshausen",
"494826", "Hohenlockstedt",
"499937", "Oberpöring",
"499869", "Wettringen\ Mittelfranken",
"495368", "Parsau",
"499775", "Schönau\ an\ der\ Brend",
"4938222", "Semlow",
"492942", "Geseke",
"494243", "Twistringen",
"497055", "Neuweiler\ Kreis\ Calw",
"497235", "Unterreichenbach\ Kreis\ Calw",
"496621", "Bad\ Hersfeld",
"4936041", "Bad\ Tennstedt",
"499776", "Mellrichstadt",
"497520", "Bodnegg",
"497056", "Gechingen",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"497527", "Wolfegg",
"497236", "Keltern",
"4938733", "Karbow\-Vietlübbe",
"4933202", "Töplitz",
"492904", "Bestwig",
"492464", "Aldenhoven\ bei\ Jülich",
"497836", "Schiltach",
"499101", "Langenzenn",
"4936421", "Camburg",
"4934299", "Gaschwitz",
"494843", "Viöl",
"497835", "Zell\ am\ Harmersbach",
"4938323", "Prohn",
"498463", "Greding",
"4938351", "Mesekenhagen",
"498281", "Thannhausen\ Schwaben",
"495225", "Spenge",
"497642", "Endingen\ Kaiserstuhl",
"4936453", "Mellingen",
"4938292", "Kröpelin",
"495226", "Bruchmühlen\ Westfalen",
"4936463", "Gebstedt",
"4938393", "Binz\ Ostseebad",
"4935201", "Langebrück",
"495826", "Suderburg",
"4939603", "Burg\ Stargard",
"492628", "Rhens",
"495825", "Wieren",
"495684", "Frielendorf",
"497063", "Bad\ Wimpfen",
"495138", "Sehnde",
"496479", "Waldbrunn\ Westerwald",
"493636", "Greussen",
"499190", "Heroldsbach",
"4939245", "Loburg",
"499197", "Egloffstein",
"4937756", "Breitenbrunn\ Erzgebirge",
"493635", "Kölleda",
"498670", "Reischach\ Kreis\ Altötting",
"492305", "Castrop\-Rauxel",
"498677", "Burghausen\ Salzach",
"4939727", "Spantekow",
"499084", "Bissingen\ Schwaben",
"496303", "Enkenbach\-Alsenborn",
"492306", "Lünen",
"496454", "Lichtenfels\-Sachsenberg",
"499283", "Rehau",
"495702", "Petershagen\-Lahde",
"499461", "Roding",
"4933637", "Beerfelde",
"4936085", "Reinholterode",
"492436", "Wegberg\-Rödgen",
"496433", "Hadamar",
"4933238", "Senzke",
"497128", "Sonnenbühl",
"499901", "Hengersberg\ Bayern",
"4936784", "Stützerbach",
"498456", "Lenting",
"496472", "Weilmünster",
"496594", "Birresborn",
"492104", "Mettmann",
"492435", "Erkelenz\-Lövenich",
"495744", "Hüllhorst",
"495351", "Helmstedt",
"497264", "Bad\ Rappenau",
"4936330", "Grossberndten",
"496047", "Altenstadt\ Hessen",
"494501", "Kastorf\ Holstein",
"4939976", "Gross\ Bützin",
"492582", "Everswinkel",
"4939954", "Stavenhagen\ Reuterstadt",
"4936878", "Oberland",
"498807", "Diessen\ am\ Ammersee",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"498344", "Westendorf\ bei\ Kaufbeuren",
"495378", "Sassenburg\-Platendorf",
"499765", "Trappstadt",
"496584", "Wellen\ Mosel",
"498751", "Mainburg",
"499622", "Hirschau\ Oberpfalz",
"499766", "Grosswenkheim",
"499293", "Berg\ Oberfranken",
"496630", "Schwalmtal\-Storndorf",
"4939854", "Kleptow",
"492474", "Nideggen\-Schmidt",
"492592", "Selm",
"496637", "Feldatal",
"496102", "Neu\-Isenburg",
"498302", "Görisried",
"498207", "Affing",
"497531", "Konstanz",
"499187", "Altdorf\ bei\ Nürnberg",
"494722", "Cuxhaven\-Altenbruch",
"499547", "Zapfendorf",
"49641", "Giessen",
"499180", "Pyrbaum",
"494666", "Ladelund",
"492452", "Heinsberg\ Rheinland",
"498432", "Burgheim",
"494188", "Welle\ Nordheide",
"494665", "Emmelsbüll\-Horsbüll",
"498586", "Hauzenberg",
"496346", "Annweiler\ am\ Trifels",
"498146", "Moorenweis",
"4938785", "Berge\ bei\ Perleberg",
"4937346", "Geyer",
"499094", "Tagmersheim",
"499948", "Eschlkam",
"4939773", "Altwarp",
"498585", "Grainet",
"496109", "Frankfurt\-Bergen\-Enkheim",
"496345", "Albersweiler",
"498145", "Mammendorf",
"494947", "Aurich\-Ogenbargen",
"4937432", "Pausa\ Vogtland",
"495521", "Herzberg\ am\ Harz",
"492599", "Ascheberg\-Herbern",
"497073", "Ammerbuch",
"494140", "Estorf\ Kreis\ Stade",
"497357", "Attenweiler",
"4933397", "Wandlitz",
"4934244", "Mockrehna",
"4933929", "Gühlen\-Glienicke",
"499148", "Ettenstatt",
"493723", "Hohenstein\-Ernstthal",
"4937604", "Mosel",
"497252", "Bretten",
"498291", "Zusmarshausen",
"497032", "Herrenberg",
"498667", "Seeon\-Seebruck",
"4933844", "Brück\ Brandenburg",
"495694", "Diemelstadt",
"494634", "Husby",
"497852", "Willstätt",
"497259", "Östringen\-Odenheim",
"494205", "Ottersberg",
"4935267", "Diesbar\-Seusslitz",
"499471", "Burglengenfeld",
"4935439", "Zinnitz",
"495022", "Wietzen",
"494206", "Stuhr\-Heiligenrode",
"4935454", "Uckro",
"4935476", "Wittmannsdorf\-Bückchen",
"496462", "Gladenbach",
"4934955", "Gossa",
"494806", "Sarzbüttel",
"497274", "Germersheim",
"4939298", "Barby\ Elbe",
"4938307", "Poseritz",
"494805", "Schafstedt",
"4938377", "Zinnowitz",
"499734", "Burkardroth",
"4933055", "Kremmen",
"498051", "Prien\ am\ Chiemsee",
"4938851", "Zarrentin",
"4935895", "Klitten",
"498231", "Königsbrunn\ bei\ Augsburg",
"4933764", "Mittenwalde\ Mark",
"492251", "Euskirchen",
"495147", "Uetze\-Hänigsen",
"493968", "Schönbeck",
"4937430", "Eichigt",
"4938379", "Benz\ Usedom",
"492851", "Rees",
"4938309", "Trent",
"492924", "Möhnesee",
"4938726", "Spornitz",
"495634", "Waldeck\-Sachsenhausen",
"493745", "Falkenstein\ Vogtland",
"4933927", "Linum",
"495653", "Sontra",
"495206", "Bielefeld\-Jöllenbeck",
"4933873", "Grosswudicke",
"493338", "Bernau\ Brandenburg",
"496858", "Ottweiler\-Fürth",
"4935825", "Kodersdorf",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"495205", "Bielefeld\-Sennestadt",
"496258", "Gernsheim",
"492608", "Welschneudorf",
"495805", "Oetzen",
"4938796", "Viesecke",
"4934203", "Zwenkau",
"497624", "Grenzach\-Wyhlen",
"495806", "Barum\ bei\ Bad\ Bevensen",
"4938823", "Selmsdorf",
"4937363", "Zöblitz",
"499377", "Freudenberg\-Boxtal",
"499233", "Arzberg\ Oberfranken",
"492486", "Nettersheim",
"496483", "Selters\ Taunus",
"496261", "Mosbach\ Baden",
"497773", "Bodman\-Ludwigshafen",
"497732", "Radolfzell\ am\ Bodensee",
"492485", "Schleiden\-Dreiborn",
"4939744", "Rothenklempenow",
"499272", "Fichtelberg",
"4939425", "Dingelstedt\ am\ Huy",
"492573", "Nordwalde",
"496323", "Edenkoben",
"498123", "Moosinning",
"498552", "Grafenau\ Niederbayern",
"499872", "Heilsbronn",
"4936622", "Triebes",
"496697", "Willingshausen",
"496575", "Landscheid",
"492325", "Wanne\-Eickel",
"499833", "Heidenheim\ Mittelfranken",
"496861", "Merzig",
"492532", "Ostbevern",
"499854", "Wittelshofen",
"499279", "Mistelgau",
"497739", "Hilzingen",
"495665", "Guxhagen",
"497451", "Horb\ am\ Neckar",
"498574", "Wittibreut",
"493686", "Eisfeld",
"49375", "Zwickau",
"495722", "Bückeburg",
"499921", "Regen",
"493685", "Hildburghausen",
"495947", "Laar\ Vechte",
"4936692", "Bürgel",
"494521", "Eutin",
"4937321", "Frankenstein\ Sachsen",
"499254", "Gefrees",
"492268", "Kürten",
"499842", "Uffenheim",
"492543", "Billerbeck\ Westfalen",
"492183", "Rommerskirchen",
"498386", "Oberstaufen",
"496186", "Grosskrotzenburg",
"495863", "Zernien",
"495321", "Goslar",
"499204", "Plankenfels",
"4936646", "Tanna\ bei\ Schleiz",
"496545", "Blankenrath",
"493883", "Hagenow",
"498385", "Hergatz",
"496185", "Hammersbach\ Hessen",
"498509", "Ruderting",
"496668", "Birstein\-Lichenroth",
"494735", "Butjadingen\-Stollhamm",
"497961", "Ellwangen\ Jagst",
"499340", "Königheim\-Brehmen",
"497743", "Ühlingen\-Birkendorf",
"499804", "Aurach",
"498426", "Walting\ Kreis\ Eichstätt",
"4939080", "Kalbe\ Milde",
"493901", "Salzwedel",
"499347", "Wittighausen",
"493461", "Merseburg\ Saale",
"4939247", "Güterglück",
"494736", "Butjadingen\-Tossens",
"494348", "Schönkirchen",
"499242", "Gössweinstein",
"497158", "Neuhausen\ auf\ den\ Fildern",
"495481", "Lengerich\ Westfalen",
"495263", "Barntrup",
"498502", "Fürstenzell",
"495977", "Spelle",
"496424", "Ebsdorfergrund",
"492392", "Werdohl",
"4934498", "Rositz",
"495064", "Gross\ Düngen",
"492297", "Wildbergerhütte",
"497331", "Geislingen\ an\ der\ Steige",
"4937431", "Mehltheuer\ Vogtland",
"496384", "Konken",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"498544", "Eging\ am\ See",
"499636", "Plössberg",
"492661", "Bad\ Marienberg\ Westerwald",
"4936087", "Wüstheuterode",
"499635", "Bärnau",
"4938850", "Gammelin",
"499664", "Hahnbach",
"4936943", "Bettenhausen\ Thüringen",
"495855", "Nahrendorf",
"4937320", "Mulda\ Sachsen",
"498638", "Waldkraiburg",
"4938426", "Neuburg\-Steinhausen",
"4937384", "Wechselburg",
"494289", "Kirchtimke",
"495603", "Gudensberg",
"495036", "Neustadt\-Schneeren",
"4933454", "Wölsickendorf\/Wollenberg",
"4933476", "Neuhardenberg",
"495177", "Edemissen\-Abbensen",
"495035", "Gross\ Munzel",
"497683", "Simonswald",
"495255", "Altenbeken",
"4935327", "Priessen",
"4933439", "Fredersdorf\-Vogelsdorf",
"497958", "Rot\ Am\ See\-Brettheim",
"4935844", "Oybin\ Kurort",
"494882", "Lunden",
"492750", "Diedenshausen",
"492801", "Xanten",
"499428", "Kirchroth",
"494764", "Gnarrenburg\-Klenkendorf",
"497161", "Göppingen",
"497557", "Herdwangen\-Schönach",
"497026", "Lenningen",
"4936374", "Weissensee",
"492983", "Winterberg\-Siedlinghausen",
"4934901", "Rosslau\ Elbe",
"496651", "Rasdorf",
"494282", "Sittensen",
"497025", "Neuffen",
"494856", "Kronprinzenkoog",
"4939883", "Gross\ Dölln",
"493937", "Osterburg\ Altmark",
"493869", "Dümmer",
"494855", "Eddelak",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"494177", "Drage\ Elbe",
"4938852", "Wittenburg",
"497043", "Maulbronn",
"494255", "Martfeld",
"494256", "Hilgermissen",
"499178", "Abenberg\ Mittelfranken",
"494603", "Havetoft",
"49291", "Meschede",
"4935873", "Herrnhut",
"495764", "Steyerberg",
"4934295", "Krensitz",
"497802", "Oberkirch\ Baden",
"492162", "Viersen",
"495882", "Gorleben",
"497244", "Weingarten\ Baden",
"495427", "Melle\-Buer",
"4935329", "Dollenchen",
"4936966", "Kaltennordheim",
"499441", "Kelheim",
"497307", "Senden\ Iller",
"4933437", "Reichenberg\ bei\ Strausberg",
"4933234", "Wustermark",
"495282", "Schieder\-Schwalenberg",
"497844", "Rheinau",
"497300", "Roggenburg",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"4935754", "Klettwitz",
"49761", "Freiburg\ im\ Breisgau",
"497202", "Karlsbad",
"4939082", "Mieste",
"494321", "Neumünster",
"492339", "Sprockhövel\-Hasslinghausen",
"492444", "Schleiden\-Gemünd",
"496159", "Messel",
"4936621", "Elsterberg\ bei\ Plauen",
"494863", "Sankt\ Peter\-Ording",
"498374", "Dietmannsried",
"496174", "Königstein\ im\ Taunus",
"492962", "Olsberg",
"494796", "Teufelsmoor",
"494263", "Scheessel",
"4937293", "Eppendorf\ Sachsen",
"492402", "Stolberg\ Rheinland",
"494481", "Hatten\-Sandkrug",
"497669", "St\ Märgen",
"494795", "Garlstedt",
"49211", "Düsseldorf",
"499978", "Schönthal\ Oberpfalz",
"4936691", "Eisenberg\ Thüringen",
"496152", "Gross\-Gerau",
"493644", "Apolda",
"492237", "Kerpen\ Rheinland\-Türnich",
"492373", "Menden\ Sauerland",
"492526", "Sendenhorst",
"496523", "Holsthum",
"498176", "Egling\ bei\ Wolfratshausen",
"497391", "Ehingen\ Donau",
"4938485", "Dabel",
"4937322", "Brand\-Erbisdorf",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"492332", "Gevelsberg",
"49381", "Rostock",
"498257", "Inchenhofen",
"498250", "Hilgertshausen\-Tandern",
"496375", "Wallhalben",
"494977", "Blomberg\ Ostfriesland",
"492525", "Beckum\-Neubeckum",
"498443", "Hohenwart\ Paar",
"497726", "Bad\ Dürrheim",
"498857", "Benediktbeuern",
"4936653", "Lehesten\ Thüringer\ Wald",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"497725", "Königsfeld\ im\ Schwarzwald",
"492409", "Stolberg\-Gressenich",
"492837", "Weeze",
"495301", "Lehre\-Essenrode",
"4939224", "Büden",
"4939427", "Ströbeck",
"4933848", "Raben",
"498640", "Reit\ Im\ Winkl",
"4935200", "Arnsdorf\ bei\ Dresden",
"497381", "Münsingen",
"4938789", "Wolfshagen\ bei\ Perleberg",
"494551", "Bad\ Segeberg",
"498134", "Odelzhausen",
"496334", "Thaleischweiler\-Fröschen",
"495752", "Auetal\-Hattendorf",
"498405", "Stammham\ bei\ Ingolstadt",
"496449", "Ehringshausen\-Katzenfurt",
"494167", "Apensen",
"499951", "Landau\ an\ der\ Isar",
"498406", "Böhmfeld",
"499824", "Dietenhofen",
"493921", "Burg\ bei\ Magdeburg",
"4937608", "Waldenburg\ Sachsen",
"4937207", "Hainichen\ Sachsen",
"492154", "Willich",
"492355", "Schalksmühle",
"495774", "Wagenfeld\-Ströhen",
"492133", "Dormagen",
"496136", "Nieder\-Olm",
"498336", "Erkheim",
"498153", "Wessling",
"496353", "Freinsheim",
"496135", "Bodenheim\ Rhein",
"498335", "Fellheim",
"4939294", "Gross\ Rosenburg",
"496404", "Lich\ Hessen",
"49465", "Sylt",
"493377", "Zossen\ Brandenburg",
"4935606", "Briesen\ bei\ Cottbus",
"494491", "Friesoythe",
"495431", "Quakenbrück",
"4936484", "Knau\ bei\ Pössneck",
"4934782", "Mansfeld\ Südharz",
"496442", "Braunfels",
"4936331", "Ilfeld",
"4939858", "Bietikow",
"497654", "Löffingen",
"494832", "Meldorf",
"494873", "Aukrug",
"496228", "Schönau\ Odenwald",
"494337", "Jevenstedt",
"494273", "Kirchdorf\ bei\ Sulingen",
"499745", "Wildflecken",
"494330", "Emkendorf",
"498364", "Seeg",
"496164", "Reichelsheim\ Odenwald",
"4935435", "Gollmitz\ bei\ Calau",
"492972", "Schmallenberg",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"495292", "Lichtenau\-Atteln",
"492933", "Sundern\ Sauerland",
"499746", "Zeitlofs",
"499338", "Röttingen\ Unterfranken",
"495623", "Edertal",
"494232", "Langwedel\ Kreis\ Verden",
"499408", "Altenthann",
"498166", "Allershausen\ Oberbayern",
"492954", "Rüthen\-Oestereiden",
"492363", "Datteln",
"49234", "Bochum",
"499151", "Hersbruck",
"494967", "Rhauderfehn\-Burlage",
"494839", "Wöhrden\ Dithmarschen",
"498165", "Neufahrn\ bei\ Freising",
"492821", "Kleve\ Niederrhein",
"494407", "Wardenburg",
"497672", "St\ Blasien",
"4935973", "Stolpen",
"499567", "Sesslach\-Gemünda",
"494239", "Dörverden\-Westen",
"495086", "Celle\-Scheuen",
"499560", "Grub\ am\ Forst",
"494646", "Mohrkirch",
"4933925", "Wustrau\-Altfriesack",
"498021", "Waakirchen",
"495085", "Burgdorf\-Ehlershausen",
"497633", "Staufen\ im\ Breisgau",
"4935827", "Nieder\-Seifersdorf",
"4933201", "Gross\ Glienicke",
"495873", "Eimke",
"4936422", "Reinstädt\ Thüringen",
"494892", "Schenefeld\ Mittelholstein",
"496678", "Wildeck\-Hönebach",
"495832", "Hankensbüttel",
"496841", "Homburg\ Saar",
"4938221", "Marlow",
"4935829", "Gersdorf\ bei\ Görlitz",
"499398", "Birkenfeld\ bei\ Würzburg",
"493471", "Bernburg\ Saale",
"494292", "Ritterhude",
"497971", "Gaildorf",
"495232", "Lage\ Lippe",
"494623", "Böklund",
"4934445", "Stössen",
"492993", "Marsberg\-Canstein",
"496241", "Worms",
"495052", "Hermannsburg",
"4933395", "Zerpenschleuse",
"4936042", "Tonna",
"495337", "Kissenbrück",
"497229", "Iffezheim",
"495273", "Beverungen",
"4939748", "Viereck",
"495839", "Wittingen\-Ohrdorf",
"495074", "Rodewald",
"4935202", "Klingenberg\ Sachsen",
"495407", "Wallenhorst",
"4939383", "Sandau\ Elbe",
"4938305", "Gingst",
"493987", "Templin",
"492248", "Hennef\-Uckerath",
"4936843", "Benshausen",
"4938375", "Koserow",
"497822", "Ettenheim",
"492671", "Cochem",
"4938352", "Kemnitz\ bei\ Greifswald",
"4935265", "Glaubitz",
"495645", "Borgentreich\-Borgholz",
"497222", "Rastatt",
"497327", "Dischingen",
"493588", "Niesky",
"495646", "Willebadessen",
"499723", "Röthlein",
"495551", "Northeim",
"499674", "Schönsee",
"497448", "Seewald",
"492382", "Ahlen\ Westfalen",
"493629", "Stadtilm",
"4933768", "Prieros",
"494752", "Neuhaus\ Oste",
"499659", "Leuchtenberg",
"498194", "Vilgertshofen",
"496394", "Bundenthal",
"492422", "Kreuzau",
"495167", "Walsrode\-Westenholz",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"4938787", "Glöwen",
"496195", "Kelkheim\ Taunus",
"498395", "Tannheim\ Württemberg",
"492505", "Altenberge\ Westfalen",
"492389", "Werne",
"492193", "Dabringhausen",
"496196", "Bad\ Soden\ am\ Taunus",
"497171", "Schwäbisch\ Gmünd",
"496503", "Hermeskeil",
"492506", "Münster\-Wolbeck",
"494774", "Hechthausen",
"495491", "Damme\ Dümmer",
"499652", "Waidhaus",
"493765", "Reichenbach\ Vogtland",
"4937209", "Einsiedel\ bei\ Chemnitz",
"492429", "Hürtgenwald",
"497705", "Wolterdingen\ Schwarzw",
"494431", "Wildeshausen",
"497706", "Oberbaldingen",
"498721", "Eggenfelden",
"493622", "Waltershausen\ Thüringen",
"496332", "Zweibrücken",
"495754", "Extertal\-Bremke",
"495341", "Salzgitter",
"494488", "Westerstede",
"496525", "Irrel",
"492375", "Balve",
"496050", "Biebergemünd",
"499822", "Bechhofen\ an\ der\ Heide",
"49831", "Kempten\ Allgäu",
"4937752", "Eibenstock",
"49611", "Wiesbaden",
"4933981", "Putlitz",
"496057", "Flörsbachtal",
"492152", "Kempen",
"492523", "Wadersloh",
"499480", "Sünching",
"496373", "Schönenberg\-Kübelberg",
"496526", "Bollendorf",
"496237", "Maxdorf",
"494328", "Rickling",
"498445", "Gerolsbach",
"499222", "Presseck",
"496409", "Biebertal",
"4939244", "Steutz",
"496837", "Wallerfangen",
"497723", "Furtwangen\ im\ Schwarzwald",
"498446", "Pörnbach",
"492159", "Meerbusch\-Osterath",
"499829", "Flachslanden",
"498708", "Weihmichl\-Unterneuhausen",
"4939955", "Jürgenstorf",
"4936020", "Ebeleben",
"498139", "Röhrmoos",
"4934298", "Taucha\ bei\ Leipzig",
"496339", "Grosssteinhausen",
"494865", "Osterhever",
"496444", "Bischoffen",
"4936785", "Gräfinau\-Angstedt",
"493874", "Ludwigslust",
"499971", "Cham",
"494265", "Fintel",
"495772", "Espelkamp",
"492174", "Burscheid\ Rheinland",
"4935058", "Pretzschendorf",
"4939972", "Walkendorf",
"495733", "Vlotho",
"499229", "Mainleus",
"494793", "Hambergen",
"4936084", "Heuthen",
"494266", "Brockel",
"496402", "Hungen",
"498362", "Füssen",
"496162", "Reinheim\ Odenwald",
"4938226", "Dierhagen\ Ostseebad",
"492974", "Schmallenberg\-Fredeburg",
"495294", "Hövelhof\-Espeln",
"498267", "Dirlewang",
"499171", "Roth\ Mittelfranken",
"493531", "Finsterwalde",
"494234", "Dörverden",
"4933457", "Altreetz",
"498867", "Rottenbuch\ Oberbayern",
"4935324", "Crinitz",
"4933239", "Gross\ Behnitz",
"498860", "Bernbeuren",
"497652", "Hinterzarten",
"494834", "Büsum",
"4933206", "Fichtenwalde",
"4936741", "Bad\ Blankenburg",
"499448", "Hausen\ Niederbayern",
"497674", "Todtmoos",
"4934773", "Schwittersdorf",
"4938488", "Demen",
"498369", "Rückholz",
"4938296", "Rerik\ Ostseebad",
"494853", "Sankt\ Michaelisdonn",
"494447", "Vechta\-Langförden",
"492952", "Rüthen",
"494253", "Asendorf\ Kreis\ Diepholz",
"497045", "Oberderdingen",
"494606", "Wanderup",
"497046", "Zaberfeld",
"4936377", "Rastenberg",
"494605", "Medelby",
"493591", "Bautzen",
"494294", "Riede\ Kreis\ Verden",
"495234", "Horn\-Bad\ Meinberg",
"4934425", "Droyssig",
"495054", "Bergen\-Sülze",
"4936022", "Grossengottern",
"496757", "Becherbach\ bei\ Kirn",
"4939728", "Medow\ bei\ Anklam",
"4936379", "Holzengel",
"492651", "Mayen",
"493773", "Johanngeorgenstadt",
"4936336", "Klettenberg",
"496201", "Weinheim\ Bergstr",
"492985", "Winterberg\-Niedersfeld",
"498631", "Mühldorf\ am\ Inn",
"495834", "Wittingen\-Knesebeck",
"497023", "Weilheim\ an\ der\ Teck",
"495447", "Lembruch",
"495853", "Neu\ Darchau",
"497224", "Gernsbach",
"4934495", "Dobitschen",
"492208", "Niederkassel",
"499381", "Volkach",
"496658", "Poppenhausen\ Wasserkuppe",
"497951", "Crailsheim",
"495072", "Neustadt\-Mandelsloh",
"495605", "Kaufungen\ Hessen",
"499421", "Straubing",
"4933434", "Herzfelde\ bei\ Strausberg",
"4933237", "Paulinenaue",
"497685", "Gutach\-Bleibach",
"495033", "Wunstorf\-Grossenheidorn",
"495606", "Zierenberg",
"4933638", "Rüdersdorf\ bei\ Berlin",
"497824", "Schwanau",
"495253", "Bad\ Driburg",
"496297", "Ravenstein\ Baden",
"4933602", "Alt\ Zeschdorf",
"494754", "Bülkau",
"498192", "Schondorf\ am\ Ammersee",
"496392", "Hauenstein\ Pfalz",
"4933672", "Pfaffendorfb\ Beeskow",
"492424", "Vettweiss",
"497151", "Waiblingen",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"494779", "Freiburg\ Elbe",
"499672", "Neunburg\ vorm\ Wald",
"497567", "Leutkirch\-Friesenhofen",
"492384", "Welver",
"496897", "Sulzbach\ Saar",
"495328", "Altenau\ Harz",
"499633", "Mitterteich",
"496661", "Schlüchtern",
"499654", "Pleystein",
"495571", "Uslar",
"4939365", "Bellingen\ bei\ Stendal",
"492545", "Rosendahl\-Darfeld",
"493886", "Gadebusch",
"495865", "Gusborn",
"492546", "Coesfeld\-Lette",
"496543", "Büchenbeuren",
"4939203", "Barleben",
"493624", "Ohrdruf",
"498383", "Grünenbach\ Allgäu",
"496183", "Erlensee",
"4935601", "Peitz",
"494733", "Butjadingen\-Burhave",
"497745", "Jestetten",
"4937423", "Adorf\ Vogtland",
"495266", "Lemgo\-Kirchheide",
"497746", "Wutöschingen",
"498423", "Titting",
"494772", "Oberndorf\ Oste",
"495265", "Dörentrup",
"495957", "Lindern\ Oldenburg",
"492196", "Wermelskirchen",
"498393", "Holzgünz",
"499802", "Ansbach\-Katterbach",
"496506", "Welschbillig",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"492195", "Radevormwald",
"499244", "Betzenstein",
"496505", "Kordel",
"498549", "Vilshofen\-Pleinting",
"493763", "Glauchau",
"497703", "Bonndorf\ im\ Schwarzwald",
"499844", "Obernzenn",
"493941", "Halberstadt",
"4939745", "Hetzdorf\ bei\ Strasburg",
"497441", "Freudenstadt",
"499307", "Altertheim",
"4937204", "Lichtenstein\ Sachsen",
"4933398", "Werneuchen",
"496429", "Schweinsberg\ Hessen",
"499202", "Waischenfeld",
"495069", "Nordstemmen",
"494308", "Schwedeneck",
"4936626", "Auma",
"49961", "Weiden\ in\ der\ Oberpfalz",
"496382", "Lauterecken",
"498542", "Ortenburg",
"4938378", "Heringsdorf\ Seebad",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"4938308", "Göhren\ Rügen",
"498728", "Geratskirchen",
"496287", "Limbach\ Baden",
"498504", "Tittling",
"496422", "Kirchhain",
"492394", "Neuenrade\-Affeln",
"499209", "Emtmannsberg",
"496887", "Schmelz\ Saar",
"495062", "Holle\ bei\ Hildesheim",
"49471", "Bremerhaven",
"49906", "Donauwörth",
"4935268", "Stauchitz",
"499391", "Marktheidenfeld",
"492770", "Eschenburg",
"492777", "Breitscheid\ Hessen",
"4933702", "Wünsdorf",
"4938233", "Prerow\ Ostseebad",
"497577", "Veringenstadt",
"4938332", "Gross\ Bisdorf",
"4936923", "Treffurt",
"499662", "Vilseck",
"495643", "Borgentreich",
"497570", "Sigmaringen\-Gutenstein",
"494769", "Bremervörde\-Iselersheim",
"499726", "Euerbach",
"4935894", "Hähnichen",
"4933054", "Liebenwalde",
"4933765", "Märkisch\ Buchholz",
"496848", "Homburg\-Einöd",
"499725", "Poppenhausen\ Unterfranken",
"4938722", "Raduhn",
"495875", "Emmendorf",
"492678", "Büchel\ bei\ Cochem",
"495561", "Einbeck",
"492841", "Moers",
"4936961", "Bad\ Liebenstein",
"4934364", "Wermsdorf",
"4935771", "Bad\ Muskau",
"494284", "Selsingen",
"493581", "Görlitz",
"498041", "Bad\ Tölz",
"4938792", "Lenzen\ \(Elbe\)",
"495276", "Marienmünster",
"494625", "Jübek",
"494884", "Schwabstedt",
"495275", "Höxter\-Ottbergen",
"494762", "Kutenholz",
"494626", "Treia",
"492241", "Siegburg",
"495157", "Emmerthal\-Börry",
"492365", "Marl",
"496821", "Neunkirchen\ Saar",
"496363", "Niederkirchen",
"492366", "Herten\ Westfalen",
"4933845", "Borkheide",
"499331", "Ochsenfurt",
"497249", "Stutensee",
"4936733", "Kaulsdorf",
"4937605", "Hartenstein\ Sachsen",
"497636", "Münstertal\ Schwarzwald",
"497635", "Schliengen",
"496221", "Heidelberg",
"495769", "Steyerberg\-Voigtei",
"495083", "Hohne\ bei\ Celle",
"494643", "Gelting\ Angeln",
"494876", "Reher\ Holstein",
"497842", "Kappelrodeck",
"495284", "Schwalenberg",
"4938453", "Mistorf",
"492228", "Remagen\-Rolandseck",
"494875", "Stafstedt",
"498028", "Fischbachau",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"4935472", "Schlepzig",
"4934976", "Gröbzig",
"497204", "Malsch\-Völkersbach",
"494561", "Neustadt\ in\ Holstein",
"4934906", "Raguhn",
"494275", "Ehrenburg",
"499401", "Neutraubling",
"497347", "Dietenheim",
"497804", "Oppenau",
"495626", "Bad\ Zwesten",
"499961", "Mitterfels",
"497340", "Neenstetten",
"4935455", "Walddrehna",
"494276", "Borstel\ bei\ Sulingen",
"492935", "Sundern\-Hachen",
"498681", "Waging\ am\ See",
"499158", "Offenhausen\ Mittelfranken",
"492164", "Jüchen\-Otzenrath",
"4939482", "Gatersleben",
"497242", "Rheinstetten",
"492828", "Emmerich\-Elten",
"495625", "Naumburg\ Hessen",
"498372", "Obergünzburg",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"492353", "Halver",
"492964", "Brilon\-Alme",
"496356", "Carlsberg\ Pfalz",
"493836", "Wolgast",
"492404", "Alsdorf\ Rheinland",
"499161", "Neustadt\ an\ der\ Aisch",
"4939855", "Parmen\-Weggun",
"496355", "Albisheim\ Pfrimm",
"494957", "Detern",
"493928", "Schönebeck\ Elbe",
"497428", "Rosenfeld",
"494950", "Holtland",
"498333", "Babenhausen\ Schwaben",
"496133", "Oppenheim",
"495308", "Lehre",
"497388", "Pfronstetten",
"494558", "Todesfelde",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"4939003", "Jübar",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"4934673", "Heldrungen",
"497664", "Freiburg\-Tiengen",
"494498", "Saterland\-Ramsloh",
"4938784", "Kleinow\ Kreis\ Prignitz",
"498379", "Waltenhofen\-Oberdorf",
"495438", "Bakum\-Lüsche",
"498403", "Pförring",
"4938720", "Grebbin",
"496154", "Ober\-Ramstadt",
"498741", "Vilsbiburg",
"4937342", "Cranzahl",
"4937436", "Weischlitz",
"4933928", "Wildberg\ Brandenburg",
"492334", "Hagen\-Hohenlimburg",
"499683", "Friedenfels",
"492449", "Blankenheim\ Ahr",
"49571", "Minden\ Westfalen",
"497449", "Baiersbronn\-Obertal",
"497334", "Deggingen",
"4939489", "Strassberg\ Harz",
"4935243", "Weinböhla",
"493949", "Oschersleben\ Bode",
"4938727", "Mestlin",
"496421", "Marburg",
"49551", "Göttingen",
"4935436", "Laasow\ bei\ Calau",
"493628", "Arnstadt",
"495126", "Algermissen",
"496381", "Kusel",
"499658", "Georgenberg",
"498541", "Vilshofen\ Niederbayern",
"4935342", "Mühlberg\ Elbe",
"492664", "Rennerod",
"494475", "Molbergen",
"495324", "Vienenburg",
"492388", "Hamm\-Uentrop",
"499201", "Gesees",
"4934463", "Bad\ Kösen",
"4938797", "Karstädt\ Kreis\ Prignitz",
"498663", "Ruhpolding",
"497442", "Baiersbronn",
"494758", "Nordleda",
"493727", "Mittweida",
"495484", "Lienen\-Kattenvenne",
"497136", "Bad\ Friedrichshall",
"4937438", "Bad\ Brambach",
"4933926", "Herzberg\ Mark",
"492428", "Niederzier",
"497964", "Stödtlen",
"497353", "Schwendi",
"493904", "Haldensleben",
"497135", "Brackenheim",
"497404", "Epfendorf",
"493464", "Sangerhausen",
"494143", "Drochtersen",
"4934491", "Schmölln\ Thüringen",
"494943", "Grossefehn",
"4939323", "Schönhausen\ Elbe",
"494761", "Bremervörde",
"497935", "Schrozberg",
"493435", "Oschatz",
"492242", "Hennef\ Sieg",
"497164", "Boll\ Kreis\ Göppingen",
"498042", "Lenggries",
"497936", "Schrozberg\-Bartenstein",
"4937349", "Scheibenberg",
"492804", "Xanten\-Marienbaum",
"4937465", "Tannenbergsthal\ Vogtland",
"496654", "Gersfeld\ Rhön",
"492204", "Bensberg",
"499543", "Hirschaid",
"499183", "Burgthann",
"4939222", "Möser",
"495562", "Dassel\-Markoldendorf",
"497228", "Forbach",
"492842", "Kamp\-Lintfort",
"495925", "Wietmarschen",
"496672", "Eiterfeld",
"498203", "Grossaitingen",
"498656", "Anger",
"4936482", "Triptis",
"4934978", "Radegast\ Kreis\ Köthen",
"495838", "Gross\ Oesingen",
"492635", "Rheinbrohl",
"499661", "Sulzbach\-Rosenberg",
"495926", "Engden",
"4939393", "Werben\ Elbe",
"492636", "Burgbrohl",
"496633", "Homberg\ Ohm",
"4939292", "Biederitz",
"497366", "Abtsgmünd",
"493306", "Gransee",
"4939361", "Lüderitz",
"499392", "Faulbach\ Unterfranken",
"498803", "Peissenberg",
"497365", "Essingen\ Württemberg",
"4935605", "Komptendorf",
"494298", "Lilienthal",
"495238", "Nieheim\-Himmighausen",
"498682", "Laufen\ Salzach",
"493496", "Köthen\ Anhalt",
"496229", "Neckarsteinach",
"495761", "Stolzenau",
"495943", "Emlichheim",
"499402", "Regenstauf",
"4939923", "Priborn",
"499962", "Schwarzach\ Niederbayern",
"494562", "Grömitz",
"499339", "Ippesheim",
"499444", "Siegenburg",
"497841", "Achern",
"494926", "Krummhörn\-Greetsiel",
"499837", "Haundorf",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"4939993", "Hohenmocker",
"492696", "Nohn\ Eifel",
"496693", "Neuental",
"496222", "Wiesloch",
"499409", "Pielenhofen",
"4936781", "Grossbreitenbach",
"4936870", "Masserberg",
"496327", "Neustadt\-Lachen",
"494925", "Hinte",
"492695", "Insul",
"494838", "Tellingstedt",
"4939951", "Faulenrost",
"499525", "Königsberg\ in\ Bayern",
"499332", "Marktbreit",
"494238", "Neddenaverbergen",
"499526", "Riedbach",
"499373", "Amorbach",
"497777", "Sauldorf",
"49911", "Nuremberg",
"49991", "Deggendorf",
"493641", "Jena",
"497394", "Schelklingen",
"498742", "Velden\ Vils",
"4936628", "Zeulenroda",
"4933833", "Wollin\ bei\ Brandenburg",
"494125", "Seestermühe",
"4933396", "Klosterfelde",
"4936424", "Kahla\ Thüringen",
"4934446", "Grosskorbetha",
"4934722", "Preusslitz",
"495650", "Cornberg",
"49451", "Lübeck",
"494126", "Horst\ Holstein",
"498704", "Altdorf\-Pfettrach",
"495657", "Meissner",
"495476", "Ostercappeln\-Venne",
"49228", "Bonn",
"4938729", "Marnitz",
"496706", "Wallhausen\ Nahe",
"4939487", "Friedrichsbrunn",
"494324", "Brokstedt",
"4938306", "Samtens",
"495475", "Bohmte\-Hunteburg",
"492441", "Kall",
"4938354", "Wusterhusen",
"4938376", "Zirchow",
"497195", "Winnenden",
"499162", "Scheinfeld",
"495143", "Winsen\ Aller",
"4935266", "Heyda\ bei\ Riesa",
"495583", "Braunlage\-Hohegeiss",
"496171", "Oberursel\ Taunus",
"4935204", "Wilsdruff",
"493563", "Spremberg",
"497503", "Wilhelmsdorf\ Württemberg",
"494484", "Hude\-Wüsting",
"4935477", "Rietzneuendorf\-Friedrichshof",
"496743", "Bacharach",
"492338", "Breckerfeld",
"4937601", "Mülsen\ Skt\ Jacob",
"499933", "Wallersdorf",
"496401", "Grünberg\ Hessen",
"4933452", "Neulewin",
"492745", "Brachbach\ Sieg",
"4934241", "Jesewitz",
"499972", "Waldmünchen",
"495771", "Rahden\ Westfalen",
"4937382", "Geringswalde",
"4938425", "Kirchdorf\ Poel",
"496158", "Riedstadt",
"494494", "Bösel\ Oldenburg",
"495105", "Barsinghausen",
"495434", "Essen\ Oldenburg",
"497546", "Oberteuringen",
"495593", "Bovenden\-Lenglern",
"4933475", "Letschin",
"497668", "Ihringen",
"4933841", "Belzig",
"494533", "Reinfeld\ Holstein",
"497545", "Immenstaad\ am\ Bodensee",
"4935451", "Dahme\ Brandenburg",
"497384", "Schelklingen\-Hütten",
"494554", "Wahlstedt",
"499221", "Kulmbach",
"495840", "Schnackenburg",
"4936372", "Kleinneuhausen",
"495304", "Meine",
"492567", "Ahaus\-Alstätte",
"495453", "Recke",
"4936029", "Menteroda",
"4936203", "Vieselbach",
"495247", "Harsewinkel",
"492151", "Krefeld",
"497424", "Spaichingen",
"496331", "Pirmasens",
"498131", "Dachau",
"4935842", "Oderwitz",
"492408", "Aachen\-Kornelimünster",
"499363", "Arnstein\ Unterfranken",
"4933933", "Lindow\ Mark",
"499954", "Simbach\ Niederbayern",
"499154", "Pommelsbrunn",
"4933230", "Börnicke\ Kreis\ Havelland",
"492824", "Kalkar",
"4939726", "Ducherow",
"492685", "Flammersfeld",
"492951", "Büren",
"493868", "Rastow",
"492686", "Weyerbusch",
"4936645", "Mühltroff",
"496683", "Ehrenberg\ Rhön",
"497808", "Hohberg\ bei\ Offenburg",
"498024", "Holzkirchen",
"4939861", "Gramzow\ bei\ Prenzlau",
"499179", "Freystadt",
"4935389", "Holzdorf\ Elster",
"4936338", "Bleicherode",
"4939851", "Göritz\ bei\ Prenzlau",
"4937757", "Rittersgrün",
"492224", "Bad\ Honnef",
"495906", "Lünne",
"4939823", "Rechlin",
"496550", "Irrhausen",
"496026", "Grossostheim",
"496557", "Hallschlag",
"495466", "Merzen",
"498223", "Ichenhausen",
"495905", "Beesten",
"495465", "Neuenkirchen\ bei\ Bramsche",
"497651", "Titisee\-Neustadt",
"4939977", "Jördenstorf",
"4933609", "Brieskow\-Finkenheerd",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"498823", "Mittenwald",
"499172", "Georgensgmünd",
"4933679", "Wendisch\ Rietz",
"499356", "Burgsinn",
"493573", "Senftenberg",
"499133", "Baiersdorf\ Mittelfrankenanken",
"498361", "Nesselwang",
"496161", "Brensbach",
"4934692", "Alsleben\ Saale",
"499355", "Frammersbach",
"499422", "Bogen\ Niederbayern",
"498245", "Türkheim\ Wertach",
"496209", "Mörlenbach",
"4939741", "Jatznick",
"496043", "Nidda",
"4936370", "Grossenehrich",
"498246", "Waal",
"4938228", "Dettmannsdorf\-Kölzow",
"497952", "Gerabronn",
"495071", "Schwarmstedt",
"498639", "Neumarkt\-Sankt\ Veit",
"492045", "Bottrop\-Kirchhellen",
"498846", "Uffing\ am\ Staffelsee",
"499382", "Gerolzhofen",
"494288", "Horstedt\ Kreis\ Rotenburg",
"498845", "Bad\ Kohlgrub",
"492674", "Bad\ Bertrich",
"4933677", "Glienicke\ bei\ Beeskow",
"499287", "Selb",
"496809", "Grossrosseln",
"4933208", "Fahrland",
"496430", "Hahnstätten",
"4933607", "Briesen\ Mark",
"499280", "Selbitz\ Oberfranken",
"496307", "Schopp",
"493731", "Freiberg\ Sachsen",
"497959", "Frankenhardt",
"4938486", "Gustävel",
"494465", "Friedeburg\ Ostfriesland",
"496844", "Blieskastel\-Altheim",
"49661", "Fulda",
"499429", "Rain\ Niederbayern",
"494466", "Wittmund\-Ardorf",
"492652", "Mendig",
"496202", "Schwetzingen",
"4935387", "Seyda",
"499193", "Höchstadt\ an\ der\ Aisch",
"496802", "Völklingen\-Lauterbach",
"4937324", "Reinsberg\ Sachsen",
"499505", "Litzendorf",
"493592", "Kirschau",
"497974", "Bühlerzell",
"496244", "Westhofen\ Rheinhessenen",
"497174", "Mögglingen",
"494771", "Hemmoor",
"496669", "Neuhof\-Hauswurz",
"4938854", "Redefin",
"4938876", "Roggendorf",
"498724", "Massing",
"494106", "Quickborn\ Kreis\ Pinneberg",
"495533", "Bodenwerder",
"495572", "Bodenfelde",
"495494", "Holdorf\ Niedersachsen",
"497159", "Renningen",
"498467", "Kinding",
"494349", "Dänischenhagen",
"4936027", "Lengenfeld\ Unterm\ Stein",
"494434", "Colnrade",
"498460", "Berching\-Holnstein",
"494105", "Seevetal",
"4934296", "Groitzsch\ bei\ Pegau",
"492723", "Kirchhundem",
"4939084", "Lindstedt",
"496726", "Lorch\ Rheingau",
"494453", "Zetel",
"4935752", "Ruhland",
"494847", "Oster\-Ohrstedt",
"499848", "Simmershofen",
"496725", "Gau\-Algesheim",
"4933232", "Brieselang",
"495554", "Moringen",
"499671", "Oberviechtach",
"494342", "Preetz\ Kreis\ Plön",
"4936965", "Stadtlengsfeld",
"4933333", "Tantow",
"4935056", "Altenberg\ Sachsen",
"497376", "Langenenslingen",
"498191", "Landsberg\ am\ Lech",
"496391", "Dahn",
"497152", "Leonberg\ Württemberg",
"4935775", "Pechern",
"494240", "Syke\-Heiligenfelde",
"497375", "Obermarchtal",
"494247", "Affinghausen",
"496703", "Wöllstein\ Rheinhessen",
"4938724", "Siggelkow",
"494492", "Saterland",
"495432", "Löningen",
"4933052", "Leegebruch",
"4935892", "Horka\ OL",
"496441", "Wetzlar",
"495473", "Ostercappeln",
"497429", "Egesheim",
"4938334", "Grammendorf",
"492171", "Leverkusen\-Opladen",
"497193", "Sulzbach\ an\ der\ Murr",
"4933704", "Baruth\ Mark",
"495145", "Beedenbostel",
"495309", "Lehre\-Wendhausen",
"497506", "Wangen\-Leupolz",
"495585", "Herzberg\-Sieber",
"4934221", "Schildau\ Gneisenaustadt",
"494559", "Wensin",
"499974", "Traitsching",
"4938871", "Mühlen\ Eichsen",
"4938780", "Lanz\ Brandenburg",
"493871", "Parchim",
"495146", "Wietze",
"4935209", "Mohorn",
"497389", "Heroldstatt",
"495586", "Wieda",
"4933766", "Teupitz",
"4935023", "Bad\ Gottleuba",
"497505", "Fronreute",
"497422", "Schramberg",
"495751", "Rinteln",
"495439", "Bersenbrück",
"498378", "Buchenberg\ bei\ Kempten",
"4935822", "Hagenwerder",
"495344", "Lengede",
"4938794", "Cumlosen",
"495807", "Altenmedingen",
"494499", "Barssel",
"4934263", "Hohburg",
"499952", "Eichendorf",
"4934362", "Mügeln\ bei\ Oschatz",
"497382", "Römerstein",
"495207", "Schloss\ Holte\-Stukenbrock",
"494123", "Barmstedt",
"4934291", "Borsdorf",
"494552", "Leezen",
"495302", "Vechelde",
"492448", "Hellenthal\-Rescheid",
"496695", "Jesberg",
"492327", "Bochum\-Wattenscheid",
"498022", "Tegernsee",
"4937202", "Claussnitz\ bei\ Chemnitz",
"494923", "Krummhörn\-Pewsum",
"492693", "Antweiler",
"497671", "Todtnau",
"496696", "Gilserberg",
"492222", "Bornheim\ Rheinland",
"499152", "Hartenstein\ Mittelfranken",
"4939931", "Röbel\ Müritz",
"499376", "Collenberg",
"499523", "Hofheim\ in\ Unterfranken",
"492822", "Emmerich",
"4939746", "Krackow",
"4939422", "Badersleben",
"497248", "Marxzell",
"495768", "Petershagen\-Heimsen",
"499375", "Freudenberg\ Baden",
"4936625", "Langenwetzendorf",
"495946", "Georgsdorf",
"499174", "Hilpoltstein",
"494231", "Verden\ Aller",
"493493", "Bitterfeld",
"495945", "Wilsum",
"492971", "Schmallenberg\-Dorlar",
"498029", "Kreuth\ bei\ Tegernsee",
"4938481", "Witzin",
"4936695", "Söllmnitz",
"498205", "Dasing",
"495923", "Schüttorf",
"496249", "Guntersblum",
"499384", "Schwanfeld",
"4935820", "Zodel",
"492633", "Brohl\-Lützing",
"496636", "Romrod",
"496003", "Rosbach\ von\ der\ Höhe",
"4939856", "Beenz\ bei\ Prenzlau",
"492672", "Treis\-Karden",
"498206", "Egling\ an\ der\ Paar",
"497221", "Baden\-Baden",
"496635", "Kirtorf",
"499424", "Strasskirchen",
"498806", "Utting\ am\ Ammersee",
"494768", "Hipstedt",
"4939721", "Liepen\ bei\ Anklam",
"497821", "Lahr\ Schwarzwald",
"497363", "Lauchheim",
"497954", "Kirchberg\ an\ der\ Jagst",
"498805", "Hohenpeissenberg",
"496849", "Kirkel",
"493303", "Birkenwerder",
"496347", "Hochstadt\ Pfalz",
"494945", "Grossefehn\-Timmel",
"497933", "Creglingen",
"496340", "Wörth\-Schaidt",
"493433", "Borna\ Stadt",
"496804", "Mandelbachtal",
"4933631", "Bad\ Saarow\-Pieskow",
"494946", "Grossefehn\-Bagband",
"4937344", "Crottendorf\ Sachsen",
"493594", "Bischofswerda",
"4939753", "Strasburg",
"495231", "Detmold",
"497972", "Gschwend\ bei\ Gaildorf",
"496242", "Osthofen",
"495051", "Bergen\ Kreis\ Celle",
"498634", "Garching\ an\ der\ Alz",
"499546", "Burgebrach",
"499186", "Lauterhofen\ Oberpfalz",
"495831", "Wittingen",
"494667", "Dagebüll",
"4938782", "Reetz\ bei\ Perleberg",
"496842", "Blieskastel",
"499545", "Buttenheim",
"4937435", "Reuth\ bei\ Plauen",
"499185", "Mühlhausen\ Oberpfalz",
"492654", "Polch",
"496204", "Viernheim",
"494473", "Emstek",
"498666", "Teisendorf",
"498722", "Gangkofen",
"493621", "Gotha\ Thüringen",
"498548", "Vilshofen\-Sandbach",
"4933846", "Dippmannsdorf",
"499651", "Vohenstrauss",
"495574", "Oberweser",
"495492", "Steinfeld\ Oldenburg",
"498665", "Inzell",
"494432", "Dötlingen\-Brettorf",
"497356", "Schemmerhofen",
"497172", "Lorch\ Württemberg",
"494146", "Stade\-Bützfleth",
"4937606", "Lengenfeld\ Vogtland",
"497355", "Hochdorf\ Riss",
"4936427", "Dornburg\ Saale",
"495068", "Elze\ Leine",
"497133", "Lauffen\ am\ Neckar",
"4937468", "Treuen\ Vogtland",
"496428", "Stadtallendorf",
"494344", "Schönberg\ Holstein",
"494751", "Otterndorf",
"4939484", "Harzgerode",
"492421", "Düren",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"497154", "Kornwestheim",
"4934975", "Görzig\ Kreis\ Köthen",
"4934905", "Wörlitz",
"4933743", "Blönsdorf",
"499208", "Bindlach",
"492381", "Hamm\ Westfalen",
"4935207", "Moritzburg",
"494302", "Kirchbarkau",
"4935474", "Schönwalde\ bei\ Lübben",
"496664", "Sinntal\-Sterbfritz",
"4935456", "Terpt",
"4935608", "Gross\ Ossnig",
"495552", "Katlenburg",
"495123", "Schellerten",
"494207", "Oyten",
"4934441", "Hohenmölsen",
"492725", "Lennestadt\-Oedingen",
"497837", "Oberharmersbach",
"494455", "Jade\-Schweiburg",
"4939089", "Bismark\ Altmark",
"493909", "Klötze\ Altmark",
"4938225", "Trinwillershagen",
"496723", "Oestrich\-Winkel",
"4935322", "Doberlug\-Kirchhain",
"492662", "Hachenburg",
"494456", "Varel\-Altjührden",
"497332", "Lauterstein",
"497525", "Aulendorf",
"4933205", "Michendorf",
"494778", "Wingst",
"499777", "Ostheim\ von\ der\ Rhön",
"498501", "Thyrnau",
"4933363", "Altenhof\ Kreis\ Barnim",
"49711", "Stuttgart",
"492391", "Plettenberg",
"497373", "Zwiefalten",
"497237", "Neulingen\ Enzkreis",
"495329", "Schulenberg\ im\ Oberharz",
"4933731", "Trebbin",
"499241", "Pegnitz",
"495820", "Suhlendorf",
"495482", "Tecklenburg",
"496398", "Vorderweidenthal",
"495827", "Unterlüss",
"4938859", "Alt\ Zachun",
"497962", "Fichtenau",
"493902", "Diesdorf\ Altm",
"4938295", "Satow\ bei\ Bad\ Doberan",
"497402", "Fluorn\-Winzeln",
"493462", "Bad\ Dürrenberg",
"49335", "Frankfurt\ \(Oder\)",
"495322", "Bad\ Harzburg",
"495535", "Polle",
"493944", "Blankenburg\ Harz",
"499841", "Bad\ Windsheim",
"4938371", "Karlshagen",
"497444", "Alpirsbach",
"494103", "Wedel",
"495536", "Holzminden\-Neuhaus",
"4938301", "Putbus",
"49261", "Koblenz\ am\ Rhein",
"494903", "Wymeer",
"496652", "Hünfeld",
"494463", "Wangerland",
"494281", "Zeven",
"492202", "Bergisch\ Gladbach",
"492307", "Kamen",
"495564", "Dassel",
"4939242", "Prödel",
"492844", "Rheinberg\-Orsoy",
"4939343", "Jerichow",
"499195", "Adelsdorf\ Mittelfranken",
"4937754", "Zwönitz",
"492244", "Königswinter\-Oberpleis",
"497162", "Süssen",
"499503", "Oberhaid\ Oberfranken",
"492802", "Alpen",
"4937329", "Grosshartmannsdorf",
"494881", "Friedrichstadt",
"499196", "Wiesenttal",
"498243", "Fuchstal",
"4936082", "Ershausen",
"49341", "Leipzig",
"49791", "Schwäbisch\ Hall",
"4939956", "Neukalen",
"496045", "Gedern",
"496659", "Eichenzell",
"499394", "Esselbach",
"496046", "Ortenberg\ Hessen",
"492043", "Gladbeck",
"496674", "Friedewald\ Hessen",
"493346", "Seelow",
"498457", "Vohburg\ an\ der\ Donau",
"498450", "Ingolstadt\-Zuchering",
"4936968", "Rossdorf\ Rhön",
"498226", "Bibertal",
"498537", "Bad\ Füssing\-Aigen",
"4938428", "Hohenkirchen\ bei\ Wismar",
"494564", "Schashagen",
"495903", "Emsbüren",
"499442", "Riedenburg",
"498225", "Jettingen\-Scheppach",
"496023", "Alzenau\ in\ Unterfranken",
"495281", "Bad\ Pyrmont",
"492557", "Wettringen\ Kreis\ Steinfurt",
"498684", "Fridolfing",
"493576", "Weisswasser",
"498825", "Krün",
"4933656", "Bahro",
"4933674", "Trebatsch",
"4933478", "Gross\ Neuendorf",
"492161", "Mönchengladbach",
"4933604", "Lebus",
"499070", "Tapfheim",
"492958", "Büren\-Harth",
"499135", "Hessdorf\ Mittelfrankenanken",
"499404", "Nittendorf",
"499077", "Bachhagel",
"499964", "Stallwang",
"493861", "Plate",
"499353", "Karlstadt",
"4939366", "Kehnert",
"499334", "Giebelstadt",
"492683", "Asbach\ Westerwald",
"496824", "Ottweiler",
"498368", "Halblech",
"4937327", "Rechenberg\-Bienenmühle",
"496224", "Sandhausen\ Baden",
"4939831", "Feldberg",
"4935384", "Steinsdorf\ bei\ Jessen",
"4936648", "Dittersdorf\ bei\ Schleiz",
"494489", "Apen",
"495456", "Westerkappeln\-Velpe",
"496567", "Oberkail",
"4934426", "Kayna",
"4934742", "Sylda",
"493601", "Mühlhausen\ Thüringen",
"497661", "Kirchzarten",
"498702", "Wörth\ an\ der\ Isar",
"495455", "Tecklenburg\-Brochterbeck",
"492331", "Hagen\ Westfalen",
"4936335", "Grosswechsungen",
"496408", "Buseck",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"499366", "Geroldshausen\ Unterfranken",
"494329", "Langwedel\ Holstein",
"4936024", "Diedorf\ bei\ Mühlhausen",
"496151", "Darmstadt",
"498744", "Gerzen",
"497392", "Laupheim",
"499365", "Rimpar",
"496745", "Gondershausen",
"499164", "Langenfeld\ Mittelfranken",
"4933921", "Zechlinerhütte",
"499828", "Rügland",
"498709", "Eching\ Niederbayern",
"499935", "Stephansposching",
"4933432", "Müncheberg",
"492158", "Grefrath\ bei\ Krefeld",
"492743", "Daaden",
"4939087", "Jerchel\ Altmark",
"496746", "Pfalzfeld",
"492961", "Brilon",
"498138", "Schwabhausen\ bei\ Dachau",
"496338", "Hornbach\ Pfalz",
"4934496", "Nöbdenitz",
"494827", "Wacken",
"499936", "Wallerfing",
"494482", "Hatten",
"492401", "Baesweiler",
"495103", "Wennigsen\ Deister",
"494536", "Steinhorst\ Lauenburg",
"494322", "Bordesholm",
"499228", "Thurnau",
"495677", "Calden\-Westuffeln",
"494535", "Nahe",
"497183", "Rudersberg\ Württemberg",
"497543", "Kressbronn\ am\ Bodensee",
"495335", "Schladen",
"495153", "Salzhemmendorf",
"49355", "Cottbus",
"497268", "Bad\ Rappenau\-Obergimpern",
"495522", "Osterode\ am\ Harz",
"495336", "Semmenstedt",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"4936425", "Isserstedt",
"4936744", "Remda",
"498431", "Neuburg\ an\ der\ Donau",
"494721", "Cuxhaven",
"497124", "Trochtelfingen\ Hohenz",
"492451", "Geilenkirchen",
"492739", "Wilnsdorf",
"497325", "Sontheim\ an\ der\ Brenz",
"4935205", "Ottendorf\-Okrilla",
"499088", "Mönchsdeggingen",
"496458", "Rosenthal\ Hessen",
"497532", "Meersburg",
"492591", "Lüdinghausen",
"497326", "Neresheim",
"497573", "Stetten\ am\ kalten\ Markt",
"495529", "Rhumspringe",
"4938372", "Usedom",
"4935363", "Fermerswalde",
"496101", "Bad\ Vilbel",
"4938302", "Sagard",
"495647", "Lichtenau\-Kleinenberg",
"4938203", "Bad\ Doberan",
"495966", "Meppen\-Apeldorn",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"499621", "Amberg\ Oberpfalz",
"492732", "Kreuztal",
"496775", "Strüth\ Taunus",
"497485", "Empfingen",
"4938355", "Züssow",
"495406", "Belm",
"494194", "Sievershütten",
"4934977", "Quellendorf",
"495965", "Klein\ Berssen",
"492773", "Haiger",
"496776", "Dachsenhausen",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"498752", "Au\ in\ der\ Hallertau",
"4934907", "Jeber\-Bergfrieden",
"497486", "Horb\-Altheim",
"495934", "Haren\-Rütenbrock",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"495165", "Rethem\ Aller",
"4933708", "Rangsdorf",
"493546", "Lübben\ Spreewald",
"492624", "Höhr\-Grenzhausen",
"495166", "Walsrode\-Kirchboitzen",
"499433", "Nabburg",
"498085", "Sankt\ Wolfgang",
"496283", "Hardheim\ Odenwald",
"495021", "Nienburg\ Weser",
"4940", "Hamburg",
"4938728", "Domsühl",
"496461", "Biedenkopf",
"498086", "Buchbach\ Oberbayern",
"4939241", "Leitzkau",
"499472", "Hohenfels\ Oberpfalz",
"4933920", "Walsleben\ bei\ Neuruppin",
"4937437", "Bad\ Elster",
"497707", "Bräunlingen",
"499454", "Aufhausen\ Oberpfalz",
"496084", "Schmitten\ Taunus",
"497851", "Kehl",
"499303", "Eibelstadt",
"498623", "Kirchweidach",
"4936081", "Arenshausen",
"497251", "Bruchsal",
"497031", "Böblingen",
"498292", "Dinkelscherben",
"495364", "Velpke",
"495953", "Börger",
"496190", "Hattersheim\ am\ Main",
"492507", "Havixbeck",
"4938300", "Insel\ Hiddensee",
"492274", "Elsdorf\ Rheinland",
"492859", "Wesel\-Bislich",
"4938370", "Kröslin",
"4937439", "Jocketa",
"494166", "Ahlerstedt",
"499129", "Wendelstein",
"4937464", "Schöneck\ Vogtland",
"498407", "Grossmehring",
"494934", "Marienhafe",
"498074", "Schnaitsee",
"494165", "Hollenstedt\ Nordheide",
"499534", "Burgpreppach",
"498239", "Langenneufnach",
"4939226", "Hohenziatz",
"4939033", "Wallstawe",
"492874", "Isselburg",
"499493", "Beratzhausen",
"4934633", "Braunsbedra",
"4935604", "Krieschow",
"4935478", "Goyatz",
"496644", "Grebenhain",
"493523", "Coswig\ bei\ Dresden",
"499553", "Ebrach\ Oberfranken",
"499122", "Schwabach",
"49681", "Saarbrücken",
"4939832", "Wesenberg",
"493375", "Königs\ Wusterhausen",
"492852", "Hamminkeln",
"494953", "Bunde",
"498330", "Legau",
"496130", "Schwabenheim\ an\ der\ Selz",
"494364", "Dahme\ Kreis\ Ostholstein",
"49621", "Mannheim",
"498337", "Altenstadt\ Iller",
"4939296", "Welsleben",
"498273", "Nordendorf",
"4939488", "Güntersberge",
"492252", "Zülpich",
"492357", "Herscheid\ Westfalen",
"498052", "Aschau\ im\ Chiemgau",
"498232", "Schwabmünchen",
"4934785", "Sandersleben",
"494748", "Stubben\ bei\ Bremerhaven",
"494336", "Owschlag",
"497343", "Buch\ bei\ Illertissen",
"494335", "Hohn\ bei\ Rendsburg",
"496869", "Merzig\-Silwingen",
"494522", "Plön",
"499747", "Geroda\ Bayern",
"494153", "Lauenburg\ Elbe",
"496269", "Gundelsheim\ Württemberg",
"495721", "Stadthagen",
"4934909", "Aken\ Elbe",
"498785", "Rottenburg\-Oberroning",
"499922", "Zwiesel",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"4934741", "Frose",
"497452", "Nagold",
"499566", "Meeder",
"494529", "Süsel\-Bujendorf",
"497474", "Haigerloch",
"499565", "Untersiemau",
"4935953", "Burkau",
"499648", "Neustadt\ am\ Kulm",
"496784", "Weierbach",
"498551", "Freyung",
"4936703", "Gräfenthal",
"499871", "Windsbach",
"497459", "Nagold\-Hochdorf",
"494965", "Surwold",
"4933922", "Karwesee",
"498167", "Zolling",
"497731", "Singen\ Hohentwiel",
"495194", "Bispingen",
"494134", "Embsen\ Kreis\ Lüneburg",
"494405", "Edewecht",
"499271", "Thurnau\-Alladorf",
"494966", "Neubörger",
"499929", "Ruhmannsfelden",
"494406", "Berne",
"496262", "Aglasterhausen",
"4937348", "Oberwiesenthal\ Kurort",
"494352", "Damp",
"494176", "Marschacht",
"4933093", "Fürstenberg\ Havel",
"497582", "Bad\ Buchau",
"497142", "Bietigheim\-Bissingen",
"4936337", "Schiedungen",
"492264", "Marienheide",
"498064", "Au\ bei\ Bad\ Aibling",
"4934222", "Arzberg\ bei\ Torgau",
"494175", "Egestorf\ Nordheide",
"4938872", "Rehna",
"495502", "Dransfeld",
"494257", "Schweringen",
"493935", "Tangerhütte",
"494443", "Dinklage",
"497435", "Albstadt\-Laufen",
"494857", "Barlt",
"4933051", "Nassenheide",
"4938855", "Lübtheen",
"4935891", "Rothenburg\ OL",
"495544", "Reinhardshagen",
"492864", "Reken",
"495184", "Freden\ Leine",
"497436", "Messstetten\-Oberdigisheim",
"495509", "Rosdorf\ Kreis\ Göttingen",
"497306", "Vöhringen\ Iller",
"4935774", "Boxberg\ Sachsen",
"4934361", "Dahlen\ Sachsen",
"4935756", "Hosena",
"493366", "Beeskow",
"4934292", "Brandis\ bei\ Wurzen",
"498321", "Sonthofen",
"4936964", "Dermbach\ Rhön",
"497305", "Erbach\ Donau",
"4933209", "Caputh",
"4935052", "Kipsdorf\ Kurort",
"498263", "Breitenbrunn\ Schwaben",
"4939978", "Gross\ Roge",
"495425", "Borgholzhausen",
"4938229", "Bad\ Sülze",
"4939085", "Zichtau",
"495426", "Glandorf",
"496066", "Michelstadt\-Vielbrunn",
"4939932", "Malchow\ bei\ Waren",
"4939421", "Osterwieck",
"497628", "Efringen\-Kirchen",
"492604", "Nassau\ Lahn",
"496034", "Wöllstadt",
"496254", "Lautertal\ Odenwald",
"493334", "Eberswalde",
"497949", "Pfedelbach\-Untersteinbach",
"496854", "Oberthal\ Saar",
"497081", "Bad\ Wildbad",
"492642", "Remagen",
"4937325", "Niederbobritzsch",
"498856", "Penzberg",
"4938482", "Warin",
"497727", "Vöhrenbach",
"496872", "Losheim\ am\ See",
"492928", "Soest\-Ostönnen",
"499576", "Lichtenfels\-Isling",
"499323", "Iphofen",
"492835", "Issum",
"497720", "Schwenningen\ am\ Neckar",
"497904", "Ilshofen",
"4936603", "Weida",
"493964", "Bredenfelde\ bei\ Strasburg",
"499861", "Rothenburg\ ob\ der\ Tauber",
"492836", "Wachtendonk",
"499575", "Weismain",
"496833", "Rehlingen\-Siersburg",
"497464", "Talheim\ Kreis\ Tuttlingen",
"492520", "Wadersloh\-Diestedde",
"498170", "Strasslach\-Dingharting",
"499261", "Kronach",
"498035", "Raubling",
"498177", "Münsing\ Starnberger\ See",
"496233", "Frankenthal\ Pfalz",
"492527", "Lippetal\-Lippborg",
"494975", "Westerholt\ Ostfriesland",
"492236", "Wesseling\ Rheinland",
"496053", "Wächtersbach",
"492056", "Heiligenhaus",
"4939453", "Derenburg",
"497942", "Neuenstein\ Württemberg",
"498036", "Stephanskirchen\ Simssee",
"496272", "Hirschhorn\ Neckar",
"492235", "Erftstadt",
"494976", "Spiekeroog",
"498427", "Wellheim",
"496094", "Weibersbrunn",
"4936028", "Kammerforst\ Thüringen",
"4939722", "Sarnow\ bei\ Anklam",
"499738", "Rottershausen",
"499346", "Grünsfeld",
"494737", "Stadland\-Schwei",
"499345", "Külsheim\ Baden",
"498764", "Mauern\ Kreis\ Freising",
"498380", "Achberg",
"496629", "Schenklengsfeld",
"4969", "Frankfurt\ am\ Main",
"498387", "Weiler\-Simmerberg",
"496187", "Schöneck",
"4936644", "Hirschberg\ Saale",
"49941", "Regensburg",
"498282", "Krumbach\ Schwaben",
"493394", "Wittstock\ Dosse",
"497641", "Emmendingen",
"499637", "Falkenberg\ Oberpfalz",
"496893", "Saarbrücken\-Ensheim",
"499102", "Wilhermsdorf",
"4938781", "Mellen",
"494638", "Tarp",
"497563", "Kisslegg",
"499144", "Pleinfeld",
"492295", "Ruppichteroth",
"496765", "Gemünden\ Hunsrück",
"495976", "Salzbergen",
"4933632", "Hangelsberg",
"496293", "Schefflenz",
"496766", "Kisselbach",
"492296", "Reichshof\-Brüchermühle",
"492763", "Drolshagen\-Bleche",
"492941", "Lippstadt",
"495975", "Rheine\-Mesum",
"496622", "Bebra",
"498095", "Aying",
"4933608", "Jacobsdorf\ Mark",
"495250", "Delbrück\ Westfalen",
"495175", "Lehrte\-Arpke",
"4933474", "Neutrebbin",
"4933456", "Wriezen",
"495257", "Hövelhof",
"4933678", "Storkow\ Mark",
"495037", "Bad\ Rehburg",
"492581", "Warendorf",
"494502", "Lübeck\-Travemünde",
"4933207", "Gross\ Kreutz",
"495176", "Edemissen",
"496734", "Flonheim",
"495352", "Schöningen",
"493841", "Wismar",
"499944", "Miltach",
"496471", "Weilburg",
"494184", "Hanstedt\ Nordheide",
"4938227", "Lüdershagen\ bei\ Barth",
"493996", "Teterow",
"4938424", "Bobitz",
"494544", "Berkenthin",
"495850", "Neetze",
"4934923", "Cobbelsdorf",
"499462", "Falkenstein\ Oberpfalz",
"495857", "Bleckede\-Brackede",
"495443", "Lemförde",
"497556", "Uhldingen\-Mühlhofen",
"4935388", "Klöden",
"494385", "Hohenfelde\ bei\ Kiel",
"494509", "Gross\ Grönau",
"4936376", "Straussfurt",
"497555", "Deggenhausertal",
"496753", "Meisenheim",
"498735", "Gangkofen\-Kollbach",
"499469", "Roding\-Neubäu",
"494426", "Wangerland\-Horumersiel",
"4938297", "Moitin",
"492755", "Bad\ Berleburg\-Schwarzenau",
"496588", "Pluwig",
"494425", "Wangerland\-Hooksiel",
"498348", "Bidingen",
"495374", "Isenbüttel",
"4934343", "Regis\-Breitingen",
"499563", "Rödental",
"4935933", "Neschwitz",
"495542", "Witzenhausen",
"492862", "Südlohn",
"496531", "Bernkastel\-Kues",
"495182", "Gronau\ Leine",
"494354", "Fleckeby",
"494963", "Dörpen",
"494741", "Nordholz\ bei\ Bremerhaven",
"4937602", "Kirchberg\ Sachsen",
"494403", "Bad\ Zwischenahn",
"497584", "Altshausen",
"497144", "Marbach\ am\ Neckar",
"492262", "Wiehl",
"4933451", "Heckelberg",
"498062", "Bruckmühl\ Mangfall",
"492367", "Henrichenburg",
"4934242", "Hohenpriessnitz",
"495504", "Friedland\ Kreis\ Göttingen",
"4937381", "Penig",
"492360", "Haltern\-Lippramsdorf",
"497346", "Illerkirchberg",
"492937", "Arnsberg\-Oeventrop",
"497738", "Steisslingen",
"494372", "Westfehmarn",
"499278", "Weidenberg",
"494156", "Talkau",
"497345", "Langenau\ Württemberg",
"494333", "Erfde",
"494277", "Schwaförden",
"4935841", "Grossschönau\ Sachsen",
"4935475", "Straupitz",
"494155", "Büchen",
"49741", "Rottweil",
"4934956", "Zörbig",
"4935452", "Golssen",
"494877", "Hennstedt\ bei\ Itzehoe",
"498783", "Rohr\ in\ Niederbayern",
"492538", "Drensteinfurt\-Rinkerode",
"4934904", "Oranienbaum",
"49391", "Magdeburg",
"498558", "Hohenau\ Niederbayern",
"499641", "Grafenwöhr",
"4936371", "Schlossvippach",
"4939485", "Gernrode\ Harz",
"492269", "Kierspe\-Rönsahl",
"4939740", "Nechlin",
"493332", "Schwedt\/Oder",
"499556", "Geiselwind",
"49281", "Wesel",
"4939862", "Schmölln\ bei\ Prenzlau",
"493525", "Riesa",
"496852", "Nohfelden",
"4935609", "Drachhausen",
"499555", "Schlüsselfeld\-Aschbach",
"498561", "Pfarrkirchen\ Niederbayern",
"4939852", "Schönermark\ bei\ Prenzlau",
"492644", "Linz\ am\ Rhein",
"496357", "Standenbühl",
"498157", "Feldafing",
"494955", "Westoverledingen",
"496073", "Babenhausen\ Hessen",
"493969", "Siedenbollentin",
"494956", "Uplengen",
"49221", "Cologne",
"492602", "Montabaur",
"498276", "Baar\ Schwaben",
"496032", "Bad\ Nauheim",
"494681", "Wyk\ auf\ Föhr",
"492137", "Neuss\-Norf",
"496252", "Heppenheim\ Bergstrasse",
"495041", "Springe\ Deister",
"4937434", "Bobenneukirchen",
"497944", "Kupferzell",
"496274", "Waldbrunn\ Odenwald",
"494163", "Horneburg\ Niederelbe",
"4934691", "Könnern",
"496039", "Karben",
"496874", "Wadern\-Nunkirchen",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"4939053", "Süplingen",
"493962", "Penzlin\ bei\ Waren",
"4934653", "Rottleberode",
"499495", "Breitenbrunn\ Oberpfalz",
"497462", "Immendingen",
"4936428", "Stadtroda",
"4937467", "Klingenthal\ Sachsen",
"496468", "Dautphetal\-Mornshausen",
"495028", "Pennigsehl",
"499306", "Kist",
"4936624", "Teichwolframsdorf",
"498284", "Ziemetshausen",
"4937206", "Frankenberg\ Sachsen",
"499149", "Weissenburg\-Suffersheim",
"499305", "Estenfeld",
"496092", "Heimbuchenthal",
"496500", "Waldrach",
"4939742", "Brüssow\ bei\ Pasewalk",
"4939426", "Hessen",
"495956", "Rastdorf",
"495681", "Homberg\ Efze",
"496507", "Neumagen\-Dhron",
"495955", "Esterwegen",
"493661", "Greiz",
"498762", "Wartenberg\ Oberbayern",
"499142", "Treuchtlingen",
"4933989", "Sadenbeck",
"495163", "Fallingbostel\-Dorfmark",
"497258", "Oberderdingen\-Flehingen",
"4935607", "Jänschwalde",
"4936694", "Schkölen\ Thüringen",
"4935208", "Radeburg",
"496624", "Heringen\ Werra",
"499435", "Schwarzenfeld",
"499104", "Emskirchen",
"498083", "Isen",
"496285", "Walldürn\-Altheim",
"499436", "Nittenau",
"496286", "Walldürn\-Rippberg",
"4937600", "Neumark\ Sachsen",
"492461", "Jülich",
"499720", "Üchtelhausen",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"497576", "Krauchenwies",
"496591", "Gerolstein",
"497323", "Gerstetten",
"495379", "Sassenburg\-Grussendorf",
"494182", "Tostedt",
"499727", "Schonungen\-Marktsteinach",
"494542", "Mölln\ Lauenburg",
"497575", "Messkirch",
"499464", "Walderbach",
"4935723", "Bernsdorf\ OL",
"499904", "Lalling",
"49871", "Landshut",
"492776", "Bad\ Endbach\-Hartenrod",
"497261", "Sinsheim",
"496773", "Kamp\-Bornhofen",
"494504", "Ratekau",
"497483", "Horb\-Mühringen",
"495741", "Lübbecke",
"4938725", "Gross\ Godems",
"496732", "Wörrstadt",
"4933762", "Zeuthen",
"495963", "Bawinkel",
"495354", "Jerxheim",
"492775", "Driedorf",
"495403", "Bad\ Iburg",
"499942", "Viechtach",
"495277", "Höxter\-Fürstenau",
"499628", "Ursensollen",
"495333", "Dettum",
"495155", "Emmerthal",
"4935793", "Elstra",
"494393", "Boostedt",
"494189", "Undeloh",
"495156", "Coppenbrügge",
"494627", "Dörpstedt",
"495372", "Meinersen",
"4935826", "Königshain\ bei\ Görlitz",
"499081", "Nördlingen",
"4935751", "Welzow",
"496451", "Frankenberg\ Eder",
"492598", "Senden\-Ottmarsbocholt",
"4933231", "Pausin",
"496108", "Mühlheim\ am\ Main",
"496478", "Greifenstein\-Ulm",
"4934746", "Giersleben",
"495139", "Burgwedel",
"4934422", "Osterfeld",
"494383", "Grebin",
"4935341", "Bad\ Liebenwerda",
"497122", "St\ Johann\ Württemberg",
"4936334", "Wolkramshausen",
"4936025", "Körner",
"497553", "Salem\ Baden",
"496755", "Odernheim\ am\ Glan",
"498733", "Mengkofen",
"492588", "Harsewinkel\-Greffen",
"495524", "Bad\ Lauterberg\ im\ Harz",
"492753", "Erndtebrück",
"493671", "Saalfeld\ Saale",
"496756", "Winterbach\ Soonwald",
"4936871", "Bad\ Colberg\-Heldburg",
"498772", "Mallersdorf\-Pfaffenberg",
"499091", "Monheim\ Schwaben",
"494423", "Fedderwarden",
"495173", "Uetze",
"497129", "Lichtenstein\ Württemberg",
"4933436", "Prötzel",
"492734", "Freudenberg\ Westfalen",
"4936967", "Geisa",
"4933479", "Küstrin\-Kietz",
"49531", "Braunschweig",
"494192", "Bad\ Bramstedt",
"498341", "Kaufbeuren",
"495607", "Fuldatal",
"498754", "Volkenschwand",
"496581", "Saarburg",
"495132", "Lehrte",
"4934492", "Lucka",
"4938429", "Glasin",
"497534", "Reichenau\ Baden",
"495446", "Rehden",
"492471", "Roetgen\ Eifel",
"49202", "Wuppertal",
"495445", "Drebber",
"497566", "Argenbühl",
"4933675", "Tauche",
"4939221", "Möckern\ bei\ Magdeburg",
"499474", "Schmidmühlen",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"4933605", "Boossen",
"497271", "Wörth\ am\ Rhein",
"496296", "Ahorn\ Baden",
"496763", "Kirchberg\ Hunsrück",
"495932", "Haren\ Ems",
"492293", "Nümbrecht",
"4933652", "Neuzelle",
"492622", "Bendorf\ am\ Rhein",
"496295", "Rosenberg\ Baden",
"498093", "Glonn\ Kreis\ Ebersberg",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"4939291", "Calbe\ Saale",
"493382", "Lehnin",
"4935693", "Lauschütz",
"4939362", "Grieben\ bei\ Tangerhütte",
"4935385", "Annaburg",
"498294", "Horgau",
"497747", "Berau",
"492948", "Lippstadt\-Rebbeke",
"495362", "Wolfsburg\-Fallersleben",
"499343", "Lauda\-Königshofen",
"4936649", "Gefell\ bei\ Schleiz",
"4936481", "Neustadt\ an\ der\ Orla",
"499452", "Langquaid",
"495691", "Bad\ Arolsen",
"4939263", "Unseburg",
"495939", "Sustrum",
"494631", "Glücksburg\ Ostsee",
"496082", "Niederreifenberg",
"492547", "Rosendahl\-Osterwick",
"499532", "Maroldsweisach",
"499325", "Kleinlangheim",
"492833", "Kerken",
"496836", "Überherrn",
"4939246", "Lindau\ Anh",
"492872", "Rhede\ Westfalen",
"496835", "Beckingen",
"499326", "Markt\ Einersheim",
"499573", "Staffelstein\ Oberfranken",
"4937755", "Schönheide\ Erzgebirge",
"498253", "Pöttmes",
"492272", "Bedburg\ Erft",
"498033", "Oberaudorf",
"494973", "Wittmund\-Burhafe",
"496235", "Schifferstadt",
"497621", "Lörrach",
"496055", "Freigericht",
"4938858", "Lassahn",
"494932", "Norderney",
"496527", "Oberweis",
"496236", "Neuhofen\ Pfalz",
"492233", "Hürth\ Rheinland",
"498072", "Haag\ in\ Oberbayern",
"4936647", "Saalburg\ Thüringen",
"492377", "Wickede\ Ruhr",
"496056", "Bad\ Soden\-Salmünster",
"492053", "Velbert\-Neviges",
"499268", "Teuschnitz",
"4939952", "Grammentin",
"494362", "Heiligenhafen",
"492254", "Weilerswist",
"498054", "Breitbrunn\ am\ Chiemsee",
"494260", "Visselhövede\-Wittorf",
"498234", "Bobingen",
"494267", "Lauenbrück",
"492921", "Soest",
"4939088", "Letzlingen",
"496642", "Schlitz",
"495631", "Korbach",
"494939", "Baltrum",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"499868", "Schillingsfürst",
"4939975", "Thürkow",
"495383", "Lutter\ am\ Barenberge",
"494708", "Ringstedt",
"499924", "Bodenmais",
"493821", "Ribnitz\-Damgarten",
"4934721", "Nienburg\ Saale",
"497303", "Illertissen",
"494139", "Hohnstorf\ Elbe",
"4933477", "Trebnitz\ bei\ Müncheberg",
"499851", "Dinkelsbühl",
"497454", "Sulz\ am\ Neckar",
"4933204", "Beelitz\ Mark",
"498571", "Simbach\ am\ Inn",
"4936969", "Merkers",
"495199", "Schneverdingen\-Heber",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"498265", "Pfaffenhausen\ Schwaben",
"4935032", "Langenhennersdorf",
"499251", "Münchberg",
"495423", "Versmold",
"496789", "Heimbach\ Nahe",
"492066", "Duisburg\-Homberg",
"496063", "Bad\ König",
"498266", "Kirchheim\ in\ Schwaben",
"494524", "Scharbeutz\-Pönitz",
"4938427", "Blowatz",
"4938224", "Gresenhorst",
"492065", "Duisburg\-Rheinhausen",
"495192", "Munster",
"494132", "Amelinghausen",
"494607", "Janneby",
"499608", "Kohlberg\ Oberpfalz",
"494173", "Wulfsen",
"49431", "Kiel",
"4937328", "Grossschirma",
"496264", "Neudenau",
"493933", "Genthin",
"4938294", "Neubukow",
"496128", "Taunusstein",
"498328", "Balderschwang",
"494445", "Visbek\ Kreis\ Vechta",
"496864", "Mettlach",
"497433", "Balingen",
"497472", "Rottenburg\ am\ Neckar",
"496782", "Birkenfeld\ Nahe",
"494446", "Bakum\ Kreis\ Vechta",
"492945", "Lippstadt\-Benninghausen",
"4936842", "Oberhof\ Thüringen",
"499772", "Bischofsheim\ an\ der\ Rhön",
"4939382", "Kamern",
"498091", "Kirchseeon",
"495971", "Rheine",
"497232", "Königsbach\-Stein",
"4935365", "Falkenberg\ Elster",
"497052", "Bad\ Liebenzell",
"4935203", "Tharandt",
"497273", "Hagenbach\ Pfalz",
"497337", "Nellingen\ Alb",
"4939601", "Friedland",
"496761", "Simmern\ Hunsrück",
"492291", "Waldbröl",
"499733", "Münnerstadt",
"4938391", "Altenkirchen\ Rügen",
"4936461", "Bad\ Sulza",
"495829", "Wriedel",
"492667", "Stein\-Neukirch",
"4933747", "Marzahna",
"4938205", "Tessin\ bei\ Rostock",
"4936451", "Buttelstedt",
"497832", "Haslach\ im\ Kinzigtal",
"4938353", "Gützkow\ bei\ Greifswald",
"495693", "Volkmarsen",
"4933834", "Pritzerbe",
"4938321", "Martensdorf\ bei\ Stralsund",
"497645", "Freiamt",
"4936423", "Orlamünde",
"495222", "Bad\ Salzuflen",
"497568", "Bad\ Wurzach\-Hauerz",
"494633", "Satrup",
"496898", "Völklingen",
"494672", "Langenhorn",
"495327", "Bad\ Grund\ Harz",
"4938731", "Lübz",
"495320", "Torfhaus",
"497646", "Weisweil\ Breisgau",
"499779", "Nordheim\ von\ der\ Rhön",
"497839", "Schapbach",
"497967", "Jagstzell",
"496298", "Möckmühl",
"493907", "Gardelegen",
"4936043", "Kirchheilingen",
"499341", "Tauberbischofsheim",
"493724", "Burgstädt",
"49385", "Schwerin",
"495822", "Ebstorf",
"492751", "Bad\ Berleburg",
"494421", "Wilhelmshaven",
"499093", "Polsingen",
"493632", "Sondershausen",
"498459", "Manching",
"498731", "Dingolfing",
"492302", "Witten",
"4939994", "Metschow",
"494381", "Lütjenburg",
"497551", "Überlingen\ Bodensee",
"498592", "Wegscheid\ Niederbayern",
"495448", "Barver",
"496650", "Hosenfeld",
"496657", "Hofbieber",
"492207", "Kürten\-Dürscheid",
"492473", "Simmerath",
"496476", "Mengerskirchen",
"498452", "Geisenfeld",
"495705", "Petershagen\-Windheim",
"493991", "Waren\ Müritz",
"496475", "Weilmünster\-Wolfenhausen",
"495706", "Porta\ Westfalica",
"4935728", "Uhyst\ Spree",
"492432", "Wassenberg",
"492586", "Beelen",
"496583", "Palzem",
"498343", "Aitrang",
"496758", "Waldböckelheim",
"495171", "Peine",
"492309", "Waltrop",
"4939924", "Stuer",
"492585", "Warendorf\-Hoetmar",
"499294", "Regnitzlosau",
"499605", "Weiherhammer",
"499072", "Lauingen\ Donau",
"499253", "Weissenstadt",
"499606", "Pfreimd",
"496061", "Michelstadt",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"493361", "Fürstenwalde\ Spree",
"4934783", "Gerbstedt",
"499853", "Wilburgstetten",
"499447", "Essing",
"49651", "Trier",
"498573", "Ering",
"496126", "Idstein",
"498326", "Fischen\ im\ Allgäu",
"492552", "Steinfurt\-Borghorst",
"495381", "Seesen",
"498532", "Griesbach\ im\ Rottal",
"498325", "Oberstaufen\-Thalkirchdorf",
"4939394", "Hohenberg\-Krusemark",
"494706", "Schiffdorf",
"498868", "Schwabsoien",
"496324", "Hassloch",
"498124", "Forstern\ Oberbayern",
"4934348", "Frohburg",
"492574", "Saerbeck",
"494705", "Wremen",
"493931", "Stendal",
"499834", "Theilenhofen",
"497431", "Albstadt\-Ebingen",
"4935938", "Grosspostwitz\ OL",
"4936840", "Trusetal",
"4939324", "Kläden\ bei\ Stendal",
"494171", "Winsen\ Luhe",
"4939035", "Kuhfelde",
"499234", "Neusorg",
"497774", "Eigeltingen",
"496484", "Beselich",
"4934635", "Bad\ Lauchstädt",
"498268", "Tussenhausen",
"499266", "Mitwitz",
"4935955", "Pulsnitz",
"492051", "Velbert",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"499265", "Pressig",
"498031", "Rosenheim\ Oberbayern",
"498251", "Aichach",
"494971", "Esens",
"497623", "Rheinfelden\ Baden",
"4936074", "Worbis",
"499865", "Adelshofen\ Mittelfranken",
"498851", "Kochel\ am\ See",
"4936762", "Steinach\ Thüringen",
"4934464", "Freyburg\ Unstrut",
"499571", "Lichtenfels\ Bayern",
"498707", "Adlkofen",
"495654", "Herleshausen",
"494829", "Wewelsfleth",
"4934658", "Hayn\ Harz",
"4939058", "Uthmöden",
"492831", "Geldern",
"496562", "Speicher",
"494327", "Grossenaspe",
"495672", "Bad\ Karlshafen",
"496838", "Saarwellingen",
"494320", "Heidmühlen",
"4935027", "Weesenstein",
"492923", "Lippetal\-Herzfeld",
"495633", "Diemelsee",
"497085", "Enzklösterle",
"494222", "Ganderkesee",
"496569", "Bickendorf",
"494480", "Ovelgönne\-Strückhausen",
"494822", "Kellinghusen",
"4935244", "Krögis",
"494487", "Grossenkneten\-Huntlosen",
"4933971", "Kyritz\ Brandenburg",
"496238", "Dirmstein",
"496058", "Gründau",
"495209", "Gütersloh\-Friedrichsdorf",
"4933334", "Greiffenberg",
"4938821", "Lüdersdorf",
"495043", "Lauenau",
"494683", "Oldsum",
"496071", "Dieburg",
"4933369", "Oderberg",
"498563", "Bad\ Birnbach\ Rottal",
"4939083", "Messdorf",
"499498", "Laaber",
"493371", "Luckenwalde",
"4938756", "Grabow",
"494497", "Barssel\-Harkebrügge",
"495437", "Menslage",
"498641", "Grassau\ Kreis\ Traunstein",
"495307", "Braunschweig\-Wenden",
"4939882", "Gollin",
"495844", "Clenze",
"492564", "Vreden",
"495300", "Salzgitter\-Üfingen",
"49561", "Kassel",
"497387", "Hohenstein\ Württemberg",
"494550", "Bühnsdorf",
"495202", "Oerlinghausen",
"493528", "Radeberg",
"494557", "Blunk",
"4933967", "Freyenstein",
"497764", "Herrischried",
"4935872", "Neusalza\-Spremberg",
"495802", "Wrestedt",
"494161", "Buxtehude",
"494958", "Jemgum",
"497420", "Deisslingen",
"495244", "Rietberg",
"4938853", "Drönnewitz\ bei\ Hagenow",
"4934325", "Mochau\-Lüttewitz",
"497427", "Schömberg\ bei\ Balingen",
"497348", "Beimerstetten",
"4936940", "Oepfershausen",
"497736", "Tengen",
"4936605", "Bad\ Köstritz",
"499276", "Bischofsgrün",
"494158", "Roseburg",
"4939349", "Parey\ Elbe",
"499157", "Alfeld\ Mittelfranken",
"494743", "Langen\ bei\ Bremerhaven",
"497735", "Öhningen",
"494961", "Papenburg",
"4939402", "Völpke",
"4937323", "Lichtenberg\ Erzgebirge",
"499275", "Speichersdorf",
"492827", "Goch\-Hassum",
"494401", "Brake\ Unterweser",
"492482", "Hellenthal",
"498555", "Perlesreut",
"4939455", "Schierke",
"499561", "Coburg",
"499875", "Wolframs\-Eschenbach",
"492536", "Münster\-Albachten",
"492227", "Bornheim\-Merten",
"496533", "Morbach\ Hunsrück",
"498556", "Haidmühle",
"496572", "Manderscheid\ Eifel",
"4936652", "Wurzbach",
"498027", "Dietramszell",
"492535", "Sendenhorst\-Albersloh",
"499876", "Rohr\ Mittelfranken",
"498020", "Weyarn",
"495726", "Wiedensahl",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"495662", "Felsberg\ Hessen",
"495725", "Lindhorst\ bei\ Stadthagen",
"493682", "Zella\-Mehlis",
"496554", "Waxweiler",
"498781", "Rottenburg\ an\ der\ Laaber",
"494331", "Rendsburg",
"4937292", "Oederan",
"4937361", "Neuhausen\ Erzgebirge",
"495961", "Haselünne",
"499626", "Hohenburg",
"495743", "Espelkamp\-Gestringen",
"495401", "Georgsmarienhütte",
"499762", "Saal\ an\ der\ Saale",
"499625", "Kastl\ bei\ Amberg",
"4939771", "Ueckermünde",
"493981", "Neustrelitz",
"495158", "Hemeringen",
"497263", "Waibstadt",
"496771", "St\ Goarshausen",
"492595", "Olfen",
"4939824", "Hohenzieritz",
"492677", "Lutzerath",
"499284", "Schwarzenbach\ an\ der\ Saale",
"496349", "Billigheim\-Ingenheim",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"496434", "Bad\ Camberg",
"496105", "Mörfelden\-Walldorf",
"492596", "Nordkirchen",
"496593", "Hillesheim\ Eifel",
"497321", "Heidenheim\ an\ der\ Brenz",
"498306", "Ronsberg",
"496106", "Rodgau",
"492103", "Hilden",
"497578", "Wald\ Hohenz",
"494725", "Helgoland",
"492455", "Waldfeucht",
"498435", "Ehekirchen",
"496304", "Wolfstein\ Pfalz",
"498104", "Sauerlach",
"499083", "Möttingen",
"4933086", "Grieben\ Kreis\ Oberhavel",
"4939347", "Kade",
"492456", "Selfkant",
"496453", "Gemünden\ Wohra",
"494662", "Leck",
"497977", "Oberrot\ bei\ Gaildorf",
"492778", "Siegbach",
"496247", "Worms\-Pfeddersheim",
"496342", "Schweigen\-Rechtenbach",
"498142", "Olching",
"498582", "Röhrnbach",
"495331", "Wolfenbüttel",
"4936204", "Stotternheim",
"4933969", "Stepenitz",
"496888", "Lebach\-Steinbach",
"4936256", "Wechmar",
"493663", "Schleiz",
"497256", "Philippsburg",
"4935698", "Hornow",
"494209", "Schwanewede",
"49971", "Bad\ Kissingen",
"495683", "Wabern\ Hessen",
"497255", "Graben\-Neudorf",
"498464", "Dietfurt\ an\ der\ Altmühl",
"499438", "Fensterbach",
"498727", "Falkenberg\ Niederbayern",
"4939268", "Egeln",
"492903", "Meschede\-Freienohl",
"49461", "Flensburg",
"4933367", "Friedrichswalde\ Brandenburg",
"496466", "Dautphetal\-Friedensdorf",
"492463", "Titz",
"4939400", "Wefensleben",
"494202", "Achim\ bei\ Bremen",
"495026", "Steimbke",
"498081", "Dorfen\ Stadt",
"494307", "Raisdorf",
"496465", "Breidenbach\ bei\ Biedenkopf",
"495025", "Estorf\ Weser",
"494844", "Pellworm",
"4934925", "Bad\ Schmiedeberg",
"493541", "Calau",
"494244", "Harpstedt",
"498628", "Kienberg\ Oberbayern",
"495161", "Walsrode",
"494802", "Wrohm",
"498858", "Kochel\-Walchensee",
"4938462", "Baumgarten",
"495636", "Lichtenfels\-Goddelsheim",
"4935473", "Neu\ Lübbenau",
"4938452", "Lalendorf",
"492925", "Warstein\-Allagen",
"497083", "Bad\ Herrenalb",
"492838", "Sonsbeck",
"495635", "Vöhl",
"4939483", "Ballenstedt",
"4935249", "Basslitz",
"499977", "Arnschwang",
"4938841", "Neuhaus\ Elbe",
"492238", "Pulheim",
"492058", "Wülfrath",
"495849", "Waddeweitz",
"498258", "Sielenbach",
"498038", "Vogtareuth",
"4933744", "Hohenseefeld",
"497762", "Wehr\ Baden",
"4935935", "Kleinwelka",
"495347", "Burgdorf\ bei\ Salzgitter",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"497626", "Kandern",
"499263", "Ludwigsstadt",
"4933837", "Brielow",
"499481", "Pfatter",
"496051", "Gelnhausen",
"495242", "Rheda\-Wiedenbrück",
"4934345", "Bad\ Lausick",
"496231", "Hochdorf\-Assenheim",
"497625", "Zell\ im\ Wiesental",
"493744", "Auerbach\ Vogtland",
"495842", "Schnega",
"492562", "Gronau\ Westfalen",
"496831", "Saarlouis",
"4934638", "Zöschen",
"4939038", "Henningen",
"495204", "Steinhagen\ Westfalen",
"4936732", "Könitz",
"499321", "Kitzingen",
"4934381", "Colditz",
"497308", "Nersingen",
"494703", "Loxstedt\-Donnern",
"4939002", "Oebisfelde",
"496574", "Hasborn",
"4934672", "Rossleben",
"492324", "Hattingen\ Ruhr",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"494441", "Vechta",
"496559", "Leidenborn",
"4939055", "Hörsingen",
"4936920", "Grossenlupnitz",
"4939329", "Möringen",
"4939997", "Jarmen",
"4937343", "Jöhstadt",
"495428", "Melle\-Neuenkirchen",
"4939776", "Hintersee",
"496068", "Beerfelden",
"492484", "Mechernich\-Eiserfey",
"4939754", "Löcknitz\ Vorpom",
"499256", "Stammbach",
"499603", "Floss",
"494178", "Radbruch",
"499255", "Marktleugast",
"499170", "Schwanstetten",
"498261", "Mindelheim",
"499177", "Heideck",
"49771", "Donaueschingen",
"493537", "Jessen\ Elster",
"499855", "Dentlein\ am\ Forst",
"498861", "Schongau",
"495664", "Morschen",
"4939927", "Nossentiner\ Hütte",
"499856", "Dürrwangen",
"49251", "Münster",
"4939399", "Kleinau",
"496123", "Eltville\ am\ Rhein",
"498323", "Immenstadt\ im\ Allgäu",
"496552", "Olzheim",
"499282", "Naila",
"495703", "Hille",
"495441", "Diepholz",
"496432", "Diez",
"497558", "Illmensee",
"496473", "Leun",
"49841", "Ingolstadt\ Donau",
"4936730", "Sitzendorf",
"492758", "Bad\ Berleburg\-Girkhausen",
"497957", "Kressberg",
"497950", "Schnelldorf",
"496585", "Ralingen",
"4938208", "Kavelstorf",
"493843", "Güstrow",
"496145", "Flörsheim\ am\ Main",
"498345", "Stöttwang",
"4939397", "Geestgottberg",
"499764", "Höchheim",
"499427", "Leiblfing",
"4939929", "Jabel\ bei\ Waren",
"492583", "Sassenberg",
"496586", "Beuren\ Hochwald",
"499420", "Feldkirchen\ Niederbayern",
"496146", "Hochheim\ am\ Main",
"498346", "Pforzen",
"493675", "Sonneberg\ Thüringen",
"497062", "Beilstein\ Württemberg",
"4938450", "Tarnow\ bei\ Bützow",
"498144", "Grafrath",
"4937366", "Rübenau",
"496344", "Schwegenheim",
"498584", "Breitenberg\ Niederbayern",
"496439", "Holzappel",
"496751", "Bad\ Sobernheim",
"499289", "Schwarzenbach\ am\ Wald",
"492657", "Uersfeld",
"493998", "Demmin",
"496207", "Wald\-Michelbach",
"4939999", "Tutow",
"498637", "Lohkirchen",
"498102", "Höhenkirchen\-Siegertsbrunn",
"496302", "Winnweiler",
"4939327", "Klietz",
"498630", "Oberneukirchen",
"494664", "Neukirchen\ bei\ Niebüll",
"495695", "Twistetal",
"4933876", "Buschow",
"498462", "Berching",
"497643", "Herbolzheim\ Breisgau",
"4936077", "Grossbodungen",
"494635", "Sörup",
"4933839", "Wusterwitz",
"495696", "Bad\ Arolsen\-Landau",
"494249", "Bassum\-Nordwohlde",
"4938751", "Picher",
"4935795", "Königsbrück",
"494636", "Langballig",
"4934206", "Rötha",
"494849", "Hooge",
"495978", "Hörstel\-Dreierwalde",
"4938826", "Dassow",
"4934467", "Eckartsberga",
"4938793", "Dergenthin",
"4933703", "Sperenberg",
"4935725", "Wittichenau",
"492943", "Erwitte",
"4934600", "Ostrau\ Saalkreis",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"496291", "Adelsheim",
"4938232", "Zingst\ Ostseebad",
"492761", "Olpe\ Biggesee",
"4939000", "Beetzendorf",
"499736", "Oberthulba",
"499348", "Werbach\-Gamburg",
"494242", "Syke",
"494347", "Flintbek",
"497275", "Kandel",
"497150", "Korntal\-Münchingen",
"499735", "Massbach",
"4935024", "Stadt\ Wehlen",
"494340", "Achterwehr",
"497157", "Waldenbuch",
"498469", "Freystadt\-Burggriesbach",
"494804", "Nordhastedt",
"4938723", "Kladrum",
"497561", "Leutkirch\ im\ Allgäu",
"493501", "Pirna",
"494204", "Thedinghausen",
"496660", "Steinau\-Marjoss",
"4938333", "Horst\ bei\ Grimmen",
"4935247", "Zehren\ Sachsen",
"496667", "Steinau\-Ulmbach",
"4936922", "Gerstungen",
"494842", "Nordstrand",
"492905", "Bestwig\-Ramsbeck",
"492465", "Inden",
"499431", "Schwandorf",
"4933337", "Altkünkendorf",
"497834", "Wolfach",
"496281", "Buchen\ Odenwald",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"499774", "Oberelsbach",
"497234", "Tiefenbronn",
"496881", "Lebach",
"497054", "Wildberg\ Württemberg",
"495951", "Werlte",
"497072", "Gomaringen",
"4936023", "Horsmar",
"495686", "Schwarzenborn\ Knüll",
"4933964", "Fretzdorf",
"4936209", "Klettbach",
"493722", "Limbach\-Oberfrohna",
"498621", "Trostberg",
"497033", "Weil\ Der\ Stadt",
"495168", "Walsrode\-Stellichte",
"4933976", "Wutike",
"495685", "Knüllwald",
"497253", "Bad\ Schönborn",
"495824", "Bad\ Bodenteich",
"497440", "Bad\ Rippoldsau",
"493947", "Thale",
"497447", "Baiersbronn\-Schwarzenberg",
"495224", "Enger\ Westfalen",
"497853", "Kehl\-Bodersweier",
"494674", "Ockholm",
"492304", "Schwerte",
"4939202", "Gross\ Ammensleben",
"499086", "Fremdingen",
"494723", "Cuxhaven\-Altenwalde",
"492453", "Heinsberg\-Randerath",
"496456", "Haina\ Kloster",
"4935695", "Simmersdorf",
"498433", "Königsmoos",
"497328", "Königsbronn",
"499085", "Alerheim",
"496455", "Frankenau\ Hessen",
"4935383", "Elster\ Elbe",
"4939265", "Löderburg",
"493634", "Sömmerda",
"495151", "Hameln",
"492247", "Neunkirchen\-Seelscheid",
"4937422", "Markneukirchen",
"4933673", "Weichensdorf",
"499397", "Wertheim\-Dertingen",
"495745", "Stemwede\-Levern",
"4933603", "Falkenhagen\ bei\ Seelow",
"492771", "Dillenburg",
"497266", "Kirchardt",
"495746", "Rödinghausen",
"497265", "Angelbachtal",
"499292", "Konradsreuth",
"492593", "Ascheberg\ Westfalen",
"496596", "Üdersdorf",
"497571", "Sigmaringen",
"498454", "Karlshuld",
"496103", "Langen\ Hessen",
"498303", "Waltenhofen",
"4939829", "Blankenförde",
"496595", "Dockweiler",
"496677", "Neuenstein\ Hessen",
"496670", "Ludwigsau\ Hessen",
"4934928", "Seegrehna",
"492434", "Wegberg",
"499568", "Neustadt\ bei\ Coburg",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"492554", "Laer\ Kreis\ Steinfurt",
"495723", "Bad\ Nenndorf",
"498534", "Tettenweis",
"499646", "Freihung",
"497754", "Görwihl",
"499407", "Wenzenbach",
"494151", "Schwarzenbek",
"499074", "Höchstädt\ an\ der\ Donau",
"4939973", "Altkalen",
"494968", "Neulehe",
"498687", "Taching\-Tengling",
"4939827", "Schwarz\ bei\ Neustrelitz",
"494408", "Hude\ Oldenburg",
"496329", "Weidenthal\ Pfalz",
"4939344", "Güsen",
"494746", "Hagen\ bei\ Bremerhaven",
"494338", "Alt\ Duvenstedt",
"499232", "Wunsiedel",
"496827", "Eppelborn",
"496482", "Runkel",
"494745", "Bad\ Bederkesa",
"497733", "Engen\ Hegau",
"499337", "Gaukönigshofen",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"498553", "Spiegelau",
"498122", "Erding",
"4934328", "Hartha\ bei\ Döbeln",
"496322", "Bad\ Dürkheim",
"492572", "Emsdetten",
"496535", "Osann\-Monzel",
"499873", "Abenberg\-Wassermungenau",
"496220", "Wilhelmsfeld",
"499832", "Wassertrüdingen",
"492533", "Münster\-Nienberge",
"496227", "Walldorf\ Baden",
"496536", "Kleinich",
"493378", "Ludwigsfelde",
"499491", "Hemau",
"495652", "Bad\ Sooden\-Allendorf",
"4936207", "Plaue\ Thüringen",
"4936608", "Seelingstädt\ bei\ Gera",
"4934772", "Helbra",
"496564", "Neuerburg\ Eifel",
"496078", "Gross\-Umstadt",
"4939458", "Heudeber",
"4939606", "Glienke",
"495045", "Springe\-Bennigsen",
"494824", "Krempe",
"494168", "Neu\ Wulmstorf\-Elstorf",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"499167", "Oberscheinfeld",
"494951", "Weener",
"495659", "Ringgau",
"498271", "Meitingen",
"4939200", "Gommern",
"498565", "Dietersburg\-Baumgarten",
"495674", "Grebenstein",
"499551", "Burgwindheim",
"4938326", "Grimmen",
"4938736", "Goldberg",
"494224", "Gross\ Ippener",
"493521", "Meissen",
"494883", "Süderstapel",
"4934465", "Bad\ Bibra",
"496048", "Büdingen\-Eckartshausen",
"4936766", "Schalkau",
"497127", "Neckartenzlingen",
"4936075", "Dingelstädt\ Eichsfeld",
"493735", "Marienberg\ Sachsen",
"492982", "Medebach",
"495609", "Ahnatal",
"4935954", "Grossharthau",
"494283", "Tarmstedt",
"4935939", "Hochkirch",
"4935797", "Schwepnitz",
"494461", "Jever",
"4936704", "Steinheid",
"498841", "Murnau\ am\ Staffelsee",
"498678", "Marktl",
"495644", "Willebadessen\-Peckelsheim",
"49581", "Uelzen",
"4935245", "Burkhardswalde\-Munzig",
"49521", "Bielefeld",
"495130", "Wedemark",
"4935727", "Burghammer",
"492041", "Bottrop",
"495602", "Hessisch\ Lichtenau",
"495137", "Seelze",
"498241", "Buchloe",
"499198", "Heiligenstadt\ in\ Oberfranken",
"497682", "Elzach",
"498503", "Neuhaus\ am\ Inn",
"4939395", "Wanzer",
"492393", "Sundern\-Allendorf",
"496396", "Hinterweidenthal",
"498196", "Pürgen",
"497371", "Riedlingen\ Württemberg",
"4933748", "Treuenbrietzen",
"495937", "Geeste\-Gross\ Hesepe",
"492620", "Neuhäusel\ Westerwald",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"496395", "Münchweiler\ an\ der\ Rodalb",
"492627", "Braubach",
"4937421", "Oelsnitz\ Vogtland",
"496721", "Bingen\ am\ Rhein",
"4939201", "Wolmirstedt",
"4935603", "Burg\ Spreewald",
"499675", "Altendorf\ am\ Nabburg",
"499676", "Winklarn",
"499843", "Burgbernheim",
"497704", "Geisingen\ Baden",
"493764", "Meerane",
"494101", "Pinneberg",
"495862", "Hitzacker\ Elbe",
"492182", "Grevenbroich\-Kapellen",
"496087", "Waldems",
"492542", "Gescher",
"4939325", "Vinzelberg",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"4939034", "Fleetmark",
"494458", "Wiefelstede\-Spohle",
"4939059", "Wegenstedt",
"497742", "Klettgau",
"498394", "Lautrach",
"495367", "Rühen",
"494776", "Osten\-Altendorf",
"492504", "Telgte",
"4937463", "Bergen\ Vogtland",
"499243", "Pottenstein",
"494775", "Grossenwörden",
"497528", "Neukirch\ bei\ Tettnang",
"495262", "Extertal",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"498135", "Sulzemoos",
"496335", "Trulben",
"499826", "Weidenbach\ Mittelfranken",
"498404", "Oberdolling",
"496522", "Mettendorf",
"492372", "Hemer",
"492156", "Willich\-Anrath",
"4939995", "Nossendorf",
"499825", "Herrieden",
"492333", "Ennepetal",
"496336", "Dellfeld",
"498136", "Markt\ Indersdorf",
"499938", "Moos\ Niederbayern",
"498442", "Wolnzach",
"499225", "Stadtsteinach",
"497663", "Eichstetten",
"493603", "Bad\ Langensalza",
"494269", "Ahausen\-Kirchwalsede",
"4939925", "Wredenhagen",
"497541", "Friedrichshafen",
"495458", "Hopsten",
"497181", "Schorndorf\ Württemberg",
"492379", "Menden\-Asbeck",
"496647", "Herbstein\-Stockhausen",
"494862", "Garding",
"495101", "Pattensen",
"492963", "Brilon\-Messinghausen",
"492354", "Meinerzhagen",
"492741", "Betzdorf",
"496406", "Lollar",
"492403", "Eschweiler\ Rheinland",
"494262", "Visselhövede",
"495775", "Diepenau",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"494367", "Grossenbrode",
"4935028", "Krippen",
"498334", "Bad\ Grönenbach",
"496134", "Mainz\-Kastel",
"496405", "Laubach\ Hessen",
"495776", "Preussisch\ Ströhen",
"4939386", "Seehausen\ Altmark",
"4938204", "Broderstorf",
"493863", "Crivitz",
"499351", "Gemünden\ am\ Main",
"4936846", "Suhl\-Dietzhausen",
"49214", "Leverkusen",
"497803", "Gengenbach",
"499744", "Zeitlofs\-Detter",
"496165", "Breuberg",
"498365", "Wertach",
"493321", "Nauen\ Brandenburg",
"495883", "Lemgow",
"498366", "Oy\-Mittelberg",
"496166", "Fischbachtal",
"492163", "Schwalmtal\ Niederrhein",
"495901", "Fürstenau\ bei\ Bramsche",
"494609", "Eggebek",
"497655", "Feldberg\-Altglashütten",
"495461", "Bramsche\ Hase",
"496021", "Aschaffenburg",
"495283", "Lügde\-Rischenau",
"497656", "Schluchsee",
"497203", "Walzbachtal",
"4935364", "Lebusa",
"4934771", "Querfurt",
"497477", "Jungingen\ bei\ Hechingen",
"4936743", "Teichel",
"496787", "Niederbrombach",
"49481", "Heide\ Holstein",
"494644", "Karby",
"495084", "Hambühren",
"492955", "Büren\-Wewelsburg",
"493578", "Kamenz",
"4935937", "Prischwitz",
"497042", "Vaihingen\ an\ der\ Enz",
"4933835", "Golzow\ bei\ Brandenburg",
"496364", "Nussbach\ Pfalz",
"49421", "Bremen",
"495197", "Soltau\-Frielingen",
"492681", "Altenkirchen\ Westerwald",
"494137", "Barendorf",
"494602", "Freienwill",
"495190", "Soltau\-Emmingen",
"4934347", "Oelzschau\ bei\ Borna",
"492362", "Dorsten",
"498067", "Tuntenhausen",
"4936252", "Tambach\-Dietharz",
"495948", "Itterbeck",
"4938842", "Lüttenmark",
"494254", "Eystrup",
"499521", "Hassfurt",
"492267", "Wipperfürth",
"492691", "Adenau",
"494921", "Emden\ Stadt",
"4938461", "Bützow",
"497673", "Schönau\ im\ Schwarzwald",
"492867", "Heiden\ Kreis\ Borken",
"495187", "Delligsen",
"4936205", "Gräfenroda",
"4938451", "Hoppenrade\ bei\ Güstrow",
"494854", "Friedrichskoog",
"497632", "Badenweiler",
"494833", "Wesselburen",
"4938423", "Bad\ Kleinen",
"4934924", "Zahna",
"4936946", "Erbenhausen\ Thüringen",
"494872", "Hanerau\-Hademarschen",
"496698", "Schrecksbach",
"492369", "Dorsten\-Wulfen",
"4936731", "Unterloquitz",
"4933473", "Zechin",
"495765", "Raddestorf",
"499378", "Eichenbühl\-Riedern",
"494272", "Siedenburg",
"493491", "Lutherstadt\ Wittenberg",
"492973", "Eslohe\ Sauerland",
"497246", "Malsch\ Kreis\ Karlsruhe",
"492932", "Neheim\-Hüsten",
"495766", "Rehburg\-Loccum",
"495293", "Paderborn\-Dahl",
"494233", "Blender",
"49365", "Gera",
"495622", "Fritzlar",
"497245", "Durmersheim",
"496175", "Friedrichsdorf\ Taunus",
"498375", "Weitnau",
"492607", "Kobern\-Gondorf",
"492132", "Meerbusch\-Büderich",
"496257", "Seeheim\-Jugenheim",
"496352", "Kirchheimbolanden",
"498152", "Herrsching\ am\ Ammersee",
"4939825", "Wokuhl",
"495734", "Bergkirchen\ Westfalen",
"492173", "Langenfeld\ Rheinland",
"497191", "Backnang",
"498376", "Sulzberg\ Allgäu",
"49231", "Dortmund",
"494794", "Worpswede\-Ostersode",
"495471", "Bohmte",
"4934382", "Nerchau",
"492445", "Schleiden\ Eifel",
"493337", "Biesenthal\ Brandenburg",
"496701", "Sprendlingen\ Rheinhessen",
"4939001", "Apenburg",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"492446", "Heimbach\ Eifel",
"496443", "Ehringshausen\ Dill",
"496857", "Namborn",
"4934601", "Teutschenthal",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"493967", "Oertzenhof\ bei\ Strasburg",
"496359", "Grünstadt",
"4936643", "Thimmendorf",
"497467", "Neuhausen\ ob\ Eck",
"497724", "St\ Georgen\ im\ Schwarzwald",
"4933082", "Menz\ Kreis\ Oberhavel",
"494121", "Elmshorn",
"495753", "Auetal\-Bernsen",
"4938750", "Malliss",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"496374", "Weilerbach",
"492524", "Ennigerloh",
"495148", "Steinhorst\ Niedersachsen",
"499805", "Burgoberbach",
"4939267", "Schneidlingen",
"494734", "Stadland\-Seefeld",
"497131", "Heilbronn\ Neckar",
"498424", "Nassenfels",
"492192", "Hückeswagen",
"4939454", "Elbingerode\ Harz",
"4939406", "Harbke",
"496502", "Schweich",
"499206", "Mistelgau\-Obernsees",
"499653", "Eslarn",
"499205", "Vorbach",
"4936604", "Münchenbernsdorf",
"494471", "Cloppenburg",
"4935697", "Bagenz",
"496184", "Langenselbold",
"498384", "Röthenbach\ Allgäu",
"493623", "Friedrichroda",
"496544", "Rhaunen",
"498545", "Hofkirchen\ Bayern",
"496385", "Reichenbach\-Steegen",
"496509", "Büdlich",
"495121", "Hildesheim",
"499634", "Wiesau",
"498546", "Windorf\-Otterskirchen",
"492383", "Bönen",
"496386", "Altenkirchen\ Pfalz",
"497358", "Eberhardzell\-Füramoos",
"495065", "Sibbesse",
"496425", "Rauschenberg\ Hessen",
"494148", "Drochtersen\-Assel",
"499147", "Nennslingen",
"494753", "Balje",
"495066", "Sarstedt",
"4937296", "Stollberg\ Erzgebirge",
"492423", "Langerwehe",
"4933368", "Hohensaaten",
"496426", "Fronhausen",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"493301", "Oranienburg",
"496737", "Köngernheim",
"497361", "Aalen",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"494948", "Wiesmoor\-Marcardsmoor",
"495254", "Paderborn\-Schloss\ Neuhaus",
"497823", "Seelbach\ Schutter",
"495034", "Neustadt\-Hagen",
"499548", "Mühlhausen\ Mittelfranken",
"498651", "Bad\ Reichenhall",
"499188", "Postbauer\-Heng",
"499665", "Königstein\ Oberpfalz",
"4935773", "Schleife",
"497223", "Bühl\ Baden",
"495854", "Bleckede\-Barskamp",
"4933335", "Pinnow\ Kreis\ Uckermark",
"494180", "Königsmoor",
"4936963", "Dorndorf\ Rhön",
"499666", "Illschwang",
"495921", "Nordhorn",
"499722", "Werneck",
"494187", "Holm\-Seppensen",
"492631", "Neuwied",
"4938752", "Zierzow\ bei\ Ludwigslust",
"494547", "Gudow\ Lauenburg",
"4939886", "Milmersdorf",
"495872", "Stoetze",
"4934324", "Ostrau\ Sachsen",
"493774", "Schwarzenberg",
"496638", "Schwalmtal\-Renzendorf",
"498208", "Eurasburg\ bei\ Augsburg",
"494893", "Hohenaspe",
"497024", "Wendlingen\ am\ Neckar",
"4936921", "Wutha\-Farnroda",
"495833", "Brome",
"499729", "Grettstadt",
"494766", "Basdahl",
"494293", "Ottersberg\-Fischerhude",
"498808", "Pähl",
"4938231", "Barth",
"495053", "Fassberg\-Müden",
"492992", "Marsberg",
"494622", "Taarstedt",
"495377", "Ehra\-Lessien",
"495233", "Steinheim\ Westfalen",
"4939348", "Klitsche",
"4935876", "Weissenberg\ Sachsen",
"4933094", "Löwenberg",
"497931", "Bad\ Mergentheim",
"495272", "Brakel\ Westfalen",
"494765", "Ebersdorf\ bei\ Bremervörde",
"493431", "Döbeln",
"495908", "Wietmarschen\-Lohne",
"496028", "Sulzbach\ am\ Main",
"4933872", "Hohennauen",
"495468", "Bramsche\-Engter",
"4939998", "Loitz\ bei\ Demmin",
"497634", "Sulzburg",
"494852", "Brunsbüttel",
"492364", "Haltern\ Westfalen",
"492953", "Wünnenberg",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"4934202", "Delitzsch",
"495507", "Ebergötzen",
"496681", "Hilders",
"499358", "Gössenheim",
"494252", "Bruchhausen\-Vilsen",
"494357", "Sehestedt\ Eider",
"493328", "Teltow",
"497587", "Hosskirch",
"497147", "Sachsenheim\ Württemberg",
"499131", "Erlangen",
"494859", "Windbergen",
"494274", "Varrel\ bei\ Sulingen",
"493571", "Hoyerswerda",
"493865", "Holthusen",
"4938209", "Sanitz\ bei\ Rostock",
"498363", "Pfronten",
"496163", "Höchst\ im\ Odenwald",
"497805", "Appenweier",
"492166", "Mönchengladbach\-Rheydt",
"498821", "Garmisch\-Partenkirchen",
"492934", "Sundern\-Altenhellefeld",
"4939928", "Möllenhagen",
"493866", "Cambs",
"495624", "Bad\ Emstal",
"497806", "Bad\ Peterstal\-Griesbach",
"492165", "Jüchen",
"492688", "Kroppach",
"498221", "Günzburg",
"4939881", "Ringenwalde\ bei\ Templin",
"4935025", "Liebstadt",
"497653", "Lenzkirch",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"4935724", "Lohsa",
"4936926", "Creuzburg",
"494874", "Todenbüttel",
"495286", "Ottenstein\ Niedersachsen",
"498179", "Eurasburg\ an\ der\ Loisach",
"492529", "Oelde\-Stromberg",
"492647", "Kesseling",
"494531", "Bad\ Oldesloe",
"4936651", "Lobenstein",
"492405", "Würselen",
"495773", "Stemwede\-Wehdem",
"497729", "Tennenbronn",
"4936693", "Crossen\ an\ der\ Elster",
"495732", "Löhne",
"496741", "St\ Goar",
"4939401", "Neuwegersleben",
"496403", "Linden\ Hessen",
"492406", "Herzogenrath",
"493834", "Greifswald",
"499931", "Plattling",
"494792", "Worpswede",
"497947", "Forchtenberg",
"4939037", "Pretzier",
"492336", "Schwelm",
"498133", "Haimhausen\ Oberbayern",
"496333", "Waldfischbach\-Burgalben",
"497940", "Künzelsau",
"4934637", "Frankleben",
"493447", "Altenburg\ Thüringen",
"496155", "Griesheim\ Hessen",
"4937291", "Augustusburg",
"492335", "Wetter\ Ruhr",
"499823", "Leutershausen",
"4937362", "Seiffen\ Erzgebirge",
"496372", "Bruchmühlbach\-Miesau",
"492522", "Oelde",
"492153", "Nettetal\-Lobberich",
"499223", "Rugendorf",
"495451", "Ibbenbüren",
"4936623", "Berga\ Elster",
"497665", "March\ Breisgau",
"493605", "Leinefelde",
"4933838", "Päwesin",
"497722", "Triberg\ im\ Schwarzwald",
"495108", "Gehrden\ Han",
"497666", "Denzlingen",
"493606", "Heiligenstadt\ Heilbad",
"499845", "Oberdachstetten",
"496728", "Ober\-Hilbersheim",
"4934639", "Wallendorf\ Luppe",
"499846", "Ipsheim",
"4939054", "Flechtingen",
"4934606", "Teicha\ Sachsen\-Anhalt",
"498382", "Lindau\ Bodensee",
"495531", "Holzminden",
"496182", "Seligenstadt",
"4939039", "Bonese",
"496542", "Bullay",
"4939006", "Miesterhorst",
"4934654", "Stolberg\ Harz",
"499246", "Pegnitz\-Trockau",
"4937433", "Gutenfürst",
"494732", "Stadland\-Rodenkirchen",
"499639", "Mähring",
"498422", "Dollnstein",
"499245", "Obertrubach",
"4939772", "Rothemühl",
"494773", "Lamstedt",
"496504", "Thalfang",
"498389", "Weissensberg",
"4935248", "Schönfeld\ bei\ Grossenhain",
"498505", "Hutthurm",
"496620", "Philippsthal\ Werra",
"496627", "Nentershausen\ Hessen",
"492395", "Finnentrop\-Rönkhausen",
"498506", "Bad\ Höhenstadt",
"4933870", "Zollchow\ bei\ Rathenow",
"498193", "Geltendorf",
"496393", "Fischbach\ bei\ Dahn",
"494108", "Rosengarten\ Kreis\ Harburg",
"499673", "Tiefenbach\ Oberpfalz",
"499632", "Waldsassen",
"492721", "Lennestadt",
"499107", "Trautskirchen",
"494451", "Varel\ Jadebusen",
"493341", "Strausberg",
"4937360", "Olbernhau",
"499467", "Michelsneukirchen",
"4934973", "Osternienburg",
"4938466", "Jürgenshagen",
"495852", "Bleckede",
"4934903", "Coswig\ Anhalt",
"499907", "Zenting",
"4933745", "Petkus",
"4938207", "Stäbelow",
"4939398", "Gross\ Garz",
"499724", "Stadtlauringen",
"4938456", "Langhagen\ bei\ Güstrow",
"494468", "Friedeburg\-Reepsholt",
"49212", "Solingen",
"495073", "Neustadt\-Esperke",
"495357", "Grasleben",
"496041", "Glauburg",
"495252", "Bad\ Lippspringe",
"495032", "Neustadt\ am\ Rübenberge",
"494885", "Bergenhusen",
"492994", "Marsberg\-Westheim",
"494624", "Kropp",
"4939328", "Rochau",
"495274", "Nieheim",
"498248", "Lamerdingen",
"495859", "Thomasburg",
"499191", "Forchheim\ Oberfranken",
"495259", "Bad\ Driburg\-Neuenheerse",
"495874", "Soltendieck",
"4934344", "Kohren\-Sahlis",
"494286", "Gyhum",
"498671", "Altötting",
"493772", "Schneeberg\ Erzgebirge",
"493733", "Annaberg\-Buchholz",
"4936736", "Arnsgereuth",
"4935934", "Grossdubrau",
"494285", "Rhade\ bei\ Zeven",
"497022", "Nürtingen",
"4936941", "Wasungen",
"4938293", "Kühlungsborn\ Ostseebad",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"4936462", "Ossmannstedt",
"495836", "Wittingen\-Radenbeck",
"492984", "Hallenberg",
"4936452", "Berlstedt",
"4934776", "Rothenschirmbach",
"496008", "Echzell",
"492638", "Waldbreitbach",
"495835", "Wahrenholz",
"494295", "Emtinghausen",
"4936841", "Schleusingen",
"495055", "Fassberg",
"495235", "Blomberg\ Lippe",
"494763", "Gnarrenburg",
"494296", "Schwanewede\-Aschwarden",
"494941", "Aurich",
"495520", "Braunlage",
"4939602", "Kleeth",
"495056", "Winsen\-Meissendorf",
"495527", "Duderstadt",
"4938392", "Sassnitz",
"495236", "Blomberg\-Grossenmarpe",
"4934927", "Globig\-Bleddin",
"498801", "Seeshaupt",
"497826", "Schuttertal",
"495604", "Grossalmerode",
"497938", "Mulfingen\ Jagst",
"492737", "Netphen\-Deuz",
"497825", "Kippenheim",
"4938223", "Saal\ Vorpom",
"497684", "Glottertal",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"4938322", "Richtenberg",
"497225", "Gaggenau",
"496631", "Alsfeld",
"495642", "Warburg\-Scherfede",
"4938732", "Gallin\ bei\ Lübz",
"497226", "Bühl\-Sand",
"4933203", "Kleinmachnow",
"49371", "Chemnitz\ Sachsen",
"498543", "Aidenbach",
"496383", "Glan\-Münchweiler",
"4933970", "Neustadt\ Dosse",
"494478", "Cappeln\ Oldenburg",
"492509", "Nottuln\-Appelhülsen",
"492385", "Hamm\-Rhynern",
"494756", "Odisheim",
"495063", "Bad\ Salzdetfurth",
"497138", "Schwaigern",
"492426", "Nörvenich",
"496423", "Wetter\ Hessen",
"4933338", "Stolpe\/Oder",
"494755", "Ihlienworth",
"497709", "Wutach",
"492425", "Nideggen\-Embken",
"499803", "Colmberg",
"497744", "Stühlingen",
"498392", "Markt\ Rettenbach",
"496192", "Hofheim\ am\ Taunus",
"497351", "Biberach\ an\ der\ Riss",
"494141", "Stade",
"492502", "Nottuln",
"4939459", "Hasselfelde",
"495264", "Kalletal",
"498661", "Grabenstätt\ Chiemsee",
"497702", "Blumberg\ Baden",
"499655", "Tännesberg",
"493762", "Crimmitschau",
"495864", "Jameln",
"495128", "Hohenhameln",
"4939345", "Parchen",
"499203", "Neudrossenfeld",
"499656", "Moosbach\ bei\ Vohenstrauss",
"496139", "Budenheim",
"4939457", "Benneckenstein\ Harz",
"498444", "Schweitenkirchen",
"4939206", "Eichenbarleben",
"4939264", "Kroppenstedt",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"492359", "Kierspe",
"4936607", "Niederpöllnitz",
"4935694", "Gosda\ bei\ Klinge",
"495755", "Kalletal\-Varenholz",
"498402", "Münchsmünster",
"496524", "Rodershausen",
"492374", "Iserlohn\-Letmathe",
"4936208", "Ermstedt",
"493643", "Weimar\ Thüringen",
"499682", "Erbendorf",
"4938320", "Tribsees",
"49760", "Oberried\ Breisgau",
"498057", "Aschau\-Sachrang",
"492352", "Altena\ Westfalen",
"498237", "Aindling",
"498373", "Altusried",
"496173", "Kronberg\ im\ Taunus",
"4936450", "Kranichfeld",
"49811", "Hallbergmoos",
"49631", "Kaiserslautern",
"494264", "Sottrum\ Kreis\ Rotenburg",
"498230", "Gablingen",
"493561", "Guben",
"493876", "Perleberg",
"492175", "Leichlingen\ Rheinland",
"496132", "Ingelheim\ am\ Rhein",
"498332", "Ottobeuren",
"495141", "Celle",
"492257", "Reckerscheid",
"499127", "Rosstal\ Mittelfrankenanken",
"492850", "Rees\-Haldern",
"492443", "Mechernich",
"4939600", "Zwiedorf",
"496446", "Hohenahr",
"499120", "Leinburg",
"492857", "Rees\-Mehr",
"496445", "Schöffengrund",
"494128", "Kollmar",
"494864", "Oldenswort",
"494928", "Ihlow\-Riepe",
"497457", "Rottenburg\-Ergenzingen",
"494835", "Albersdorf\ Holstein",
"4936761", "Heubisch",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"499704", "Euerdorf",
"497843", "Renchen",
"499920", "Bischofsmais",
"499927", "Kirchberg\ Wald",
"494836", "Hennstedt\ Dithmarschen",
"4934929", "Straach",
"4935971", "Sebnitz",
"495941", "Neuenhaus\ Dinkel",
"495763", "Uchte",
"494527", "Bosau",
"494236", "Kirchlinteln",
"492975", "Schmallenberg\-Oberkirchen",
"499742", "Kalbach\ Rhön",
"495295", "Lichtenau\ Westfalen",
"499528", "Donnersdorf",
"494235", "Langwedel\-Etelsen",
"497243", "Ettlingen",
"499371", "Miltenberg",
"496267", "Fahrenbach\ Baden",
"497044", "Mönsheim",
"496362", "Alsenz",
"4933972", "Breddin",
"494604", "Grossenwiehe",
"4934327", "Waldheim\ Sachsen",
"497675", "Bernau\ Baden",
"497676", "Feldberg\ Schwarzwald",
"496691", "Schwalmstadt",
"499749", "Oberbach\ Unterfranken",
"4933965", "Herzsprung\ bei\ Wittstock",
"494642", "Kappeln\ Schlei",
"4936333", "Heringen\ Helme",
"495082", "Langlingen",
"496867", "Perl",};
$areanames{de} = {"4989", "München",
"4935753", "Großräschen",
"496321", "Neustadt\ an\ der\ Weinstraße",
"495384", "Seesen\-Groß\ Rhüden",
"493647", "Pößneck",
"4935240", "Tauscha\ bei\ Großenhain",
"498367", "Roßhaupten\ Forggensee",
"4936072", "Weißenborn\-Lüderode",
"4936949", "Obermaßfeld\-Grimmenthal",
"4938234", "Born\ Darß",
"4935726", "Groß\ Särchen",
"4935952", "Großröhrsdorf\ OL",
"496663", "Steinau\ an\ der\ Straße",
"498633", "Tüßling",
"4934493", "Gößnitz\ Thüringen",
"492203", "Köln\-Porz",
"494483", "Ovelgönne\-Großenmeer",
"499242", "Gößweinstein",
"499636", "Plößberg",
"495064", "Groß\ Düngen",
"4934901", "Roßlau\ Elbe",
"4939883", "Groß\ Dölln",
"492339", "Sprockhövel\-Haßlinghausen",
"4936484", "Knau\ bei\ Pößneck",
"499567", "Seßlach\-Gemünda",
"4934445", "Stößen",
"4939934", "Groß\ Plasten",
"499141", "Weißenburg\ in\ Bayern",
"498536", "Kößlarn",
"494684", "Langeneß\ Hallig",
"4939976", "Groß\ Bützin",
"498807", "Dießen\ am\ Ammersee",
"498170", "Straßlach\-Dingharting",
"494509", "Groß\ Grönau",
"4935841", "Großschönau\ Sachsen",
"496252", "Heppenheim\ Bergstraße",
"49221", "Köln",
"49911", "Nürnberg",
"497355", "Hochdorf\ Riß",
"495827", "Unterlüß",
"497162", "Süßen",
"499135", "Heßdorf\ Mittelfrankenanken",
"496364", "Nußbach\ Pfalz",
"495053", "Faßberg\-Müden",
"4935248", "Schönfeld\ bei\ Großenhain",
"499656", "Moosbach\ bei\ Vohenstrauß",
"497351", "Biberach\ an\ der\ Riß",
"4935938", "Großpostwitz\ OL",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"494497", "Barßel\-Harkebrügge",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;