/*
 * $Id: dl.c 21224 2007-09-12 18:42:55Z paultcochrane $
 * Copyright (C) 2004-2006, The Perl Foundation.
 */

/*
** Parrot_dlopen()
*/

void *
Parrot_dlopen(const char *filename)
{
    return LoadLibrary(filename);
}


/*
** Parrot_dlerror()
*/

const char *
Parrot_dlerror(void)
{
    return NULL;
}


/*
** Parrot_dlsym()
*/

void *
Parrot_dlsym(void *handle, const char *symbol)
{
    return (void *)(ptrcast_t)GetProcAddress(handle, symbol);
}


/*
** Parrot_dlclose()
*/

int
Parrot_dlclose(void *handle)
{
    return FreeLibrary(handle)? 0: 1;
}


/*
 * Local variables:
 *   c-file-style: "parrot"
 * End:
 * vim: expandtab shiftwidth=4:
 */

