# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl 1.t'

#########################

# change 'tests => 1' to 'tests => last_test_to_print';

use Test::More tests => 50;
BEGIN { use_ok('Lingua::PT::Ords2Nums') };

#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

is(ord2num('primeiro'),1);
is(ord2num('segundo'),2);
is(ord2num('terceiro'),3);
is(ord2num('quarto'),4);
is(ord2num('quinto'),5);
is(ord2num('sexto'),6);
is(ord2num('stimo'),7);
is(ord2num('oitavo'),8);
is(ord2num('nono'),9);

is(ord2num('dcimo'),10);
is(ord2num('dcimo primeiro'),11);

is(ord2num('trigsimo'),30);
is(ord2num('trigsimo terceiro'),33);
is(ord2num('septuagsimo'),70);

is(ord2num('centsimo primeiro'),101);
is(ord2num('centsimo quinquagsimo'),150);
is(ord2num('centsimo nonagsimo nono'),199);
is(ord2num('ducentsimo nonagsimo nono'),299);
is(ord2num('tricentsimo primeiro'),301);
is(ord2num('quadrigentsimo vigsimo primeiro'),421);
is(ord2num('quingentsimo vigsimo'),520);
is(ord2num('seiscentsimo vigsimo segundo'),622);
is(ord2num('septigentsimo'),700);
is(ord2num('octigentsimo quinquagsimo quinto'),855);
is(ord2num('nongentsimo octogsimo oitavo'),988);

is(ord2num('milsimo'),1000);
is(ord2num('dez milsimos'),10000);
is(ord2num('onze milsimos'),11000);
is(ord2num('dez milsimos nonagsimo'),10090);
is(ord2num('cem milsimos'),100000);
is(ord2num('trezentos milsimos'),300000);
is(ord2num('trezentos e vinte e um milsimos nongentsimo octogsimo stimo'),321987);
is(ord2num('quatrocentos e quarenta e quatro milsimos quadrigentsimo quadragsimo quarto'),444444);
is(ord2num('novecentos e oitenta e sete milsimos seiscentsimo quinquagsimo quarto'),987654);

is(ord2num('milionsimo'),1000000);
is(ord2num('milionsimo primeiro'),1000001);
is(ord2num('milionsimo milsimo primeiro'),1001001);
is(ord2num('dois milionsimos'),2000000);
is(ord2num('novecentos e noventa e nove milionsimos novecentos e noventa e nove milsimos nongentsimo nonagsimo nono'),999999999);

is(ord2num('bilionsimo'),1000000000);
is(ord2num('bilionsimo primeiro'),1000000001);
is(ord2num('dois bilionsimos'),2000000000);
is(ord2num('dois bilionsimos dois milsimos'),2000002000);
is(ord2num('trs bilionsimos dois milionsimos milsimo'),3002001000);
is(ord2num('trs bilionsimos dois milionsimos milsimo nono'),3002001009);
is(ord2num('nove bilionsimos noventa milionsimos novecentos e nove milsimos nonagsimo'),9090909090);
is(ord2num('oito bilionsimos oitocentos e oito milionsimos oitenta milsimos octigentsimo oitavo'),8808080808);
is(ord2num('sete bilionsimos seiscentos e cinquenta e quatro milionsimos trezentos e vinte e um milsimos nongentsimo octogsimo stimo'),7654321987);
is(ord2num('novecentos e noventa e nove bilionsimos novecentos e noventa e nove milionsimos novecentos e noventa e nove milsimos nongentsimo nonagsimo nono'),999999999999);
