package PDK::Firewall::Element::AddressGroup::Netscreen;

#------------------------------------------------------------------------------
# 加载扩展模块
#------------------------------------------------------------------------------
use Moose;
use namespace::autoclean;

#------------------------------------------------------------------------------
# 引用 PDK::Firewall::Element::AddressGroup::Role 角色
#------------------------------------------------------------------------------
with 'PDK::Firewall::Element::AddressGroup::Role';

#------------------------------------------------------------------------------
# 设定 Netscreen 防火墙属性
#------------------------------------------------------------------------------
has '+zone' => (required => 1);

#------------------------------------------------------------------------------
# 自行实现地址组对象签名
#------------------------------------------------------------------------------
sub _buildSign {
  my $self = shift;
  return $self->createSign($self->zone, $self->addrGroupName);
}

__PACKAGE__->meta->make_immutable;
1;
