package Firewall::Policy::Designer::Role;

#------------------------------------------------------------------------------
# 加载扩展模块方法属性
#------------------------------------------------------------------------------
use Moose::Role;
use namespace::autoclean;

#------------------------------------------------------------------------------
# 继承 Firewall::DBI::Role 方法属性 | 抽象数据库的读写能力
#------------------------------------------------------------------------------
has dbi => (is => 'ro', does => 'Firewall::DBI::Role', required => 1,);

#------------------------------------------------------------------------------
# report 继承防火墙报告对象相关属性和方法
#------------------------------------------------------------------------------
has searcherReportFwInfo => (is => 'ro', isa => 'Firewall::Policy::Searcher::Report::FwInfo', required => 1,);

#------------------------------------------------------------------------------
# commandText 策略设计命令行数组对象
#------------------------------------------------------------------------------
has commandText =>
  (is => 'ro', isa => 'ArrayRef[Str]', default => sub { [] }, traits => ['Array'], handles => {addCommands => 'push'});

#------------------------------------------------------------------------------
# createNat 新建地址转换：包括静态地址转换和动态地址转换
#------------------------------------------------------------------------------
sub createNat {
  my ($self, $param, $type) = @_;
  my $dyNatInfo = {};
  for my $natInfo (values %{$param}) {
    if ($natInfo->{natInfo}->{natType} eq 'static') {
      $self->createStaticNat($natInfo);
    }
    else {
      $dyNatInfo->{$type}{$natInfo->{natInfo}}{$natInfo->{realIp}} = $natInfo;
    }
  }
  if (scalar(values %{$dyNatInfo}) != 0) {
    $self->createDyNat($dyNatInfo);
  }
}

#------------------------------------------------------------------------------
# checkAndCreateAddrOrSrvOrNat | 生成源目地址、服务端口及地址转换对象
#------------------------------------------------------------------------------
sub checkAndCreateAddrOrSrvOrNat {
  my ($self, $param) = @_;
  my $mappings;

  # 遍历 params：包括 natSrc、natDst、src、dst和srv
  # 元编程 createSrc, createDst, createSrv
  for my $element (keys %{$param}) {
    if ($element eq 'natSrc' || $element eq 'natDst') {
      $mappings->{$element} = $self->createNat($param->{$element}, $element);
    }
    elsif ($element =~ /src|dst|srv/i) {
      for my $addrOrSrv (keys %{$param->{$element}}) {
        if (!defined $param->{$element}{$addrOrSrv}) {
          my $func = "create" . ucfirst $element;
          push @{$mappings->{$element}}, $self->$func($addrOrSrv);
        }
        else {
          push @{$mappings->{$element}}, $param->{$element}{$addrOrSrv}[0];
        }
      }
    }
  }

  # 返回计算结果
  return $mappings;
}

#------------------------------------------------------------------------------
# design 防火墙策略设计入口函数:
#------------------------------------------------------------------------------
sub design {
  my $self = shift;

  # 防火墙策略查询报告输出的状态
  my $type = $self->{searcherReportFwInfo}{type};

  # 边界条件处理
  if ($type eq 'new') {
    $self->createRule;
  }
  elsif ($type eq 'modify') {
    $self->modifyRule;
  }
  elsif ($type eq 'ignore') {
    my $action = $self->{report}{action}{new};
    if (defined $action) {
      for my $act (keys %{$action}) {
        if ($act eq 'natSrc' or $act eq 'natDst') {
          $self->createNat($action->{$act}, $act);
        }
      }
    }
  }
  else {
    confess __PACKAGE__ . "ERROR: report->type 异常";
  }

  # 策略修正
  return join("\n", @{$self->commandText});
}

#------------------------------------------------------------------------------
# 继承 Firewall::Policy::Designer::Role 必须实现的方法属性
#------------------------------------------------------------------------------
requires 'createRule';
requires 'modifyRule';
requires 'createStaticNat';
requires 'createDyNat';

requires 'createSrc';
requires 'createDst';
requires 'createSrv';

1;
