use strict;
use warnings;

use ExtUtils::MakeMaker 6.48;

my %config = (
    NAME             => 'Test::Approximate',
    AUTHOR           => 'Brian Greenfield <briang@cpan.org>',
    VERSION_FROM     => 'lib/Test/Approximate.pm',
    ABSTRACT_FROM    => 'lib/Test/Approximate.pm',
    LICENSE          => 'perl_5',
    PL_FILES         => {},
    MIN_PERL_VERSION => '5.008009',
    CONFIGURE_REQUIRES => {
        'ExtUtils::MakeMaker' => '6.48',
    },
    BUILD_REQUIRES => {
        'Exporter' => 0,
    },
    TEST_REQUIRES => {
        'strict'          => 0,
        'Test2::API '     => 1.302182,
        'Test::Exception' => 0,
        'Test::More'      => 0.88, # done_testing
        'warnings'        => 0,
    },
    PREREQ_PM => {
        'Carp'       => 0,
        'constant'   => 0,
        'parent'     => 0,
        'strict'     => 0,
        'Test2::API' => 1.302182,
        'warnings'   => 0,
    },
    dist  => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean => { FILES => 'Test-Approximate-*' },
);

my $github= 'github.com/briang/p5-test-approximate';
my %meta_config = (
    META_MERGE => {
        'meta-spec' => { version => 2 },
        resources => {
            bugtracker => {
                web => "https://$github/issues",
            },
            homepage => "https://$github",
            repository => {
                type => 'git',
                url => "git://$github",
                web => "https://$github",
            },
        },
    },
);

sub MY::postamble {
    return <<'MAKE_FRAG';
.PHONY: alltests authortests trial

trial: dist
	mv $(DISTVNAME).tar$(SUFFIX) $(DISTVNAME)-TRIAL.tar$(SUFFIX)

authortests:
	prove -l xt

alltests:
	prove -l t xt
MAKE_FRAG
}

WriteMakefile(%config, %meta_config);
