#!/usr/bin/perl

=pod

=head1 NAME

validate.pl - W3C validate markup from Display.pm

=head1 SYNOPSIS

Given a working installation and configuration file:

    ./validate.pl

=head1 DESCRIPTION

These tests are aimed at a working installation with several files in place,
and require Test::HTML::W3C as well as Test::Simple. For the time being, I'm
using "valid W3C HTML" as a proxy for "not broken", and a number of larger
pages as a proxy for their component features.

=head1 SEE ALSO

Test::HTML::W3C.

=cut

use strict;
use warnings;

use Test::HTML::W3C 'show_detail';
use Test::Simple tests => 5;

use WRT;

# TESTS

# configuration

    our (%WRT_CONF);
    ok (do("conf.pl"), "configuration on conf.pl");

    my $w = WRT->new(%WRT_CONF);
    $w->http_header(0);

# starting markup validation

    render('2006', '2006 validates.');
    render('2006/7', '2006/7 validates.');
    render('2007/7/14', '2007/7/14 validates.');
    render('all', 'all validates.');
    render('new', 'new validates.');

# END OF TESTS

# Utility routines.

sub render {
  my ($page, $msg) = @_;

  is_valid_markup (
    $w->display($page),
    $msg
  ) or diag_html();

  sleep 1;

}

