use strict;
use warnings;
use t::Util;
use Test::More;
use WWW::Gazetteer::HeavensAbove;

plan skip_all => 'WWW::Gazetteer::HeavensAbove is now obsolete';

plan 'skip_all' => 'Internet connection required to run this test'
   if ! web_ok();

plan tests => 3;

my $g = WWW::Gazetteer::HeavensAbove->new( retry => 10 );

my @cities;
my @towns;
my $callback = sub {
    for(@_) {
        $_->{latitude} += 1;
        push @towns, $_;
    }
};

# move both Paris!
@cities = $g->find( 'Paris', 'FR', $callback );

ok( @cities == 0, 'Data processed: nothing remains' );
my @tests = (
    {
        'iso'        => 'FR',
        'latitude'   => '46.633',
        'regionname' => 'region',
        'region'     => 'Rhne-Alpes',
        'elevation'  => '508',
        'longitude'  => '5.733',
        'name'       => 'Paris'
    },
    {
        'iso'        => 'FR',
        'latitude'   => '49.867',
        'regionname' => 'region',
        'region'     => 'le-de-France',
        'elevation'  => '34',
        'longitude'  => '2.333',
        'name'       => 'Paris'
    }
);

is_deeply( $towns[$_], $tests[$_], $tests[$_]{name} ) for 0 .. 1;
