Text::Lossy
===========

This is a Perl 5 module which implements lossy text compression.
Specifically, it implements the "lossy" part to transform any text to a
form which is better compressible by standard entropy-based compression
algorithms.

Several different lossy text filters are supplied.

Is this a joke?
---------------

No, it's serious. Well, ok, partially serious – I can't really see this
being used "in production", but it does what it says on the wrapper.
Every available filter preserves at least some of the readability and
comprehensibility of the text.

But the text stays the same length!
-----------------------------------

This module only supplies the entropy reduction via lossy transformation
of the text. This text is meant to be further processed by a lossless
compression, e.g. gzip, 7zip or similar.


INSTALLATION
------------

To install this module, run the following commands:

	perl Makefile.PL
	make
	make test
	make install

SUPPORT AND DOCUMENTATION
-------------------------

After installing, you can find documentation for this module with the
perldoc command.

    perldoc Text::Lossy

You can also look for information at:

    RT, CPAN's request tracker (report bugs here)
        http://rt.cpan.org/NoAuth/Bugs.html?Dist=Text-Lossy

    AnnoCPAN, Annotated CPAN documentation
        http://annocpan.org/dist/Text-Lossy

    CPAN Ratings
        http://cpanratings.perl.org/d/Text-Lossy

    Search CPAN
        http://search.cpan.org/dist/Text-Lossy/


LICENSE AND COPYRIGHT
---------------------

Copyright (C) 2012 Ben Deutsch

This program is free software; you can redistribute it and/or modify it
under the terms of either: the GNU General Public License as published
by the Free Software Foundation; or the Artistic License.

See http://dev.perl.org/licenses/ for more information.

