/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Attr;
import com.gargoylesoftware.htmlunit.javascript.host.BoxObject;
import com.gargoylesoftware.htmlunit.javascript.host.DOMImplementation;
import com.gargoylesoftware.htmlunit.javascript.host.DocumentFragment;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.EventNode;
import com.gargoylesoftware.htmlunit.javascript.host.Location;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.XPathNSResolver;
import com.gargoylesoftware.htmlunit.javascript.host.XPathResult;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.xml.XmlUtil;
import java.io.IOException;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DocumentType;

public class Document
extends EventNode {
    private static final long serialVersionUID = 3700830050839613384L;
    private static final Log LOG = LogFactory.getLog(Document.class);
    private Window window_;
    private DOMImplementation implementation_;
    private String designMode_;

    public void setWindow(Window window) {
        this.window_ = window;
    }

    public Location jsxGet_location() {
        return this.window_.jsxGet_location();
    }

    public void jsxSet_location(String location) throws IOException {
        this.window_.jsxSet_location(location);
    }

    public String jsxGet_referrer() {
        String referrer = this.getPage().getWebResponse().getRequestSettings().getAdditionalHeaders().get("Referer");
        if (referrer == null) {
            return "";
        }
        return referrer;
    }

    public Element jsxGet_documentElement() {
        DomElement documentElement = this.getPage().getDocumentElement();
        if (documentElement == null) {
            return null;
        }
        return (Element)this.getScriptableFor(documentElement);
    }

    public SimpleScriptable jsxGet_doctype() {
        DocumentType documentType = this.getPage().getDoctype();
        if (documentType == null) {
            return null;
        }
        return this.getScriptableFor(documentType);
    }

    public String jsxGet_designMode() {
        if (this.designMode_ == null) {
            this.designMode_ = this.getBrowserVersion().isIE() ? (this.getWindow().getWebWindow() instanceof FrameWindow ? "Inherit" : "Off") : "off";
        }
        return this.designMode_;
    }

    public void jsxSet_designMode(String mode) {
        boolean ie = this.getBrowserVersion().isIE();
        if (ie) {
            if (!("on".equalsIgnoreCase(mode) || "off".equalsIgnoreCase(mode) || "inherit".equalsIgnoreCase(mode))) {
                throw Context.reportRuntimeError((String)("Invalid document.designMode value '" + mode + "'."));
            }
            if (!(this.getWindow().getWebWindow() instanceof FrameWindow)) {
                return;
            }
            if ("on".equalsIgnoreCase(mode)) {
                this.designMode_ = "On";
            } else if ("off".equalsIgnoreCase(mode)) {
                this.designMode_ = "Off";
            } else if ("inherit".equalsIgnoreCase(mode)) {
                this.designMode_ = "Inherit";
            }
        } else if ("on".equalsIgnoreCase(mode)) {
            this.designMode_ = "on";
            SgmlPage page = this.getPage();
            if (page instanceof HtmlPage) {
                HtmlPage htmlPage = (HtmlPage)page;
                DomNode child = htmlPage.getBody().getFirstChild();
                htmlPage.getSelection().setStart(child, 0);
                htmlPage.getSelection().collapse(true);
            }
        } else if ("off".equalsIgnoreCase(mode)) {
            this.designMode_ = "off";
        }
    }

    protected SgmlPage getPage() {
        return (SgmlPage)this.getDomNodeOrDie();
    }

    public Object jsxGet_defaultView() {
        return this.getWindow();
    }

    public Object jsxFunction_createDocumentFragment() {
        DomDocumentFragment fragment = this.getDomNodeOrDie().getPage().createDomDocumentFragment();
        DocumentFragment node = new DocumentFragment();
        node.setParentScope(this.getParentScope());
        node.setPrototype(this.getPrototype(node.getClass()));
        node.setDomNode(fragment);
        return this.getScriptableFor(fragment);
    }

    public Attr jsxFunction_createAttribute(String attributeName) {
        DomAttr attr = new DomAttr(this.getPage(), null, attributeName, null);
        return (Attr)attr.getScriptObject();
    }

    public BoxObject jsxFunction_getBoxObjectFor(HTMLElement element) {
        return element.getBoxObject();
    }

    public Object jsxFunction_importNode(Node importedNode, boolean deep) {
        return importedNode.getDomNodeOrDie().cloneNode(deep).getScriptObject();
    }

    public DOMImplementation jsxGet_implementation() {
        if (this.implementation_ == null) {
            this.implementation_ = new DOMImplementation();
            this.implementation_.setParentScope(this.getWindow());
            this.implementation_.setPrototype(this.getPrototype(this.implementation_.getClass()));
        }
        return this.implementation_;
    }

    public void jsxFunction_captureEvents(String type) {
    }

    public XPathNSResolver jsxFunction_createNSResolver(Node nodeResolver) {
        XPathNSResolver resolver = new XPathNSResolver();
        resolver.setElement(nodeResolver);
        resolver.setParentScope(this.getWindow());
        resolver.setPrototype(this.getPrototype(resolver.getClass()));
        return resolver;
    }

    public Object jsxFunction_createTextNode(String newData) {
        Object result = NOT_FOUND;
        try {
            DomText domNode = new DomText(this.getDomNodeOrDie().getPage(), newData);
            SimpleScriptable jsElement = this.getScriptableFor(domNode);
            if (jsElement == NOT_FOUND) {
                LOG.debug((Object)("createTextNode(" + newData + ") cannot return a result as there isn't a JavaScript object for the DOM node " + domNode.getClass().getName()));
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException elementNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public Object jsxFunction_createComment(String comment) {
        DomComment domNode = new DomComment(this.getDomNodeOrDie().getPage(), comment);
        return this.getScriptableFor(domNode);
    }

    public XPathResult jsxFunction_evaluate(String expression, Node contextNode, Object resolver, int type, Object result) {
        XPathResult xPathResult = (XPathResult)result;
        if (xPathResult == null) {
            xPathResult = new XPathResult();
            xPathResult.setParentScope(this.getParentScope());
            xPathResult.setPrototype(this.getPrototype(xPathResult.getClass()));
        }
        xPathResult.init(contextNode.getDomNodeOrDie().getByXPath(expression), type);
        return xPathResult;
    }

    public Object jsxFunction_createElement(String tagName) {
        Object result = NOT_FOUND;
        try {
            BrowserVersion browserVersion = this.getBrowserVersion();
            if (tagName.startsWith("<") && tagName.endsWith(">") && browserVersion.isFirefox() && !(tagName = tagName.substring(1, tagName.length() - 1)).matches("\\w+")) {
                LOG.error((Object)"Unexpected exception occurred while parsing HTML snippet");
                throw Context.reportRuntimeError((String)("Unexpected exception occurred while parsing HTML snippet: " + tagName));
            }
            SgmlPage page = this.getPage();
            org.w3c.dom.Element element = page.createElement(tagName);
            SimpleScriptable jsElement = this.getScriptableFor(element);
            if (jsElement == NOT_FOUND) {
                LOG.debug((Object)("createElement(" + tagName + ") cannot return a result as there isn't a JavaScript object for the element " + element.getClass().getName()));
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException elementNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public Object jsxFunction_createElementNS(String namespaceURI, String qualifiedName) {
        org.w3c.dom.Element element = this.getBrowserVersion().isFirefox() && "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul".equals(namespaceURI) ? new HtmlDivision(namespaceURI, qualifiedName, this.getPage(), null) : ("http://www.w3.org/1999/xhtml".equals(namespaceURI) ? this.getPage().createElementNS(namespaceURI, qualifiedName) : new DomElement(namespaceURI, qualifiedName, this.getPage(), null));
        return this.getScriptableFor(element);
    }

    public HTMLCollection jsxFunction_getElementsByTagName(String tagName) {
        HTMLCollection collection = new HTMLCollection(this);
        String exp = tagName.equals("*") ? "//*" : "//*[lower-case(local-name()) = '" + tagName.toLowerCase() + "']";
        collection.init(this.getDomNodeOrDie(), exp);
        return collection;
    }

    public Object jsxFunction_getElementsByTagNameNS(Object namespaceURI, String localName) {
        String xpath;
        DomNode domNode = this.getDomNodeOrDie();
        HTMLCollection collection = new HTMLCollection(this);
        if (namespaceURI == null || namespaceURI.equals("*")) {
            xpath = ".//*[local-name()='" + localName + "']";
        } else {
            String prefix = XmlUtil.lookupPrefix((DomElement)domNode, Context.toString((Object)namespaceURI));
            xpath = ".//" + prefix + ':' + localName;
        }
        collection.init(domNode, xpath);
        return collection;
    }
}

