/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLElement;
import java.io.IOException;
import java.util.List;
import org.mozilla.javascript.Scriptable;

public class HTMLFormElement
extends HTMLElement {
    private static final long serialVersionUID = -1860993922147246513L;
    private HTMLCollection elements_;

    public final void jsConstructor() {
    }

    public void setHtmlElement(HtmlElement htmlElement) {
        super.setHtmlElement(htmlElement);
        HtmlForm htmlForm = this.getHtmlForm();
        htmlForm.setScriptObject(this);
    }

    public String jsxGet_name() {
        return this.getHtmlForm().getNameAttribute();
    }

    public void jsxSet_name(String name) {
        WebAssert.notNull("name", name);
        this.getHtmlForm().setNameAttribute(name);
    }

    public HTMLCollection jsxGet_elements() {
        if (this.elements_ == null) {
            final HtmlForm htmlForm = this.getHtmlForm();
            this.elements_ = new HTMLCollection(this){
                private static final long serialVersionUID = -2554743215194459203L;

                @Override
                protected List<Object> computeElements() {
                    List<Object> response = super.computeElements();
                    response.addAll(htmlForm.getLostChildren());
                    return response;
                }
            };
            String xpath = ".//*[(name() = 'input' or name() = 'button' or name() = 'select' or name() = 'textarea')]";
            this.elements_.init(htmlForm, ".//*[(name() = 'input' or name() = 'button' or name() = 'select' or name() = 'textarea')]");
        }
        return this.elements_;
    }

    public int jsxGet_length() {
        int all = this.jsxGet_elements().jsxGet_length();
        int images = this.getHtmlForm().getElementsByAttribute("input", "type", "image").size();
        return all - images;
    }

    public String jsxGet_action() {
        return this.getHtmlForm().getActionAttribute();
    }

    public void jsxSet_action(String action) {
        WebAssert.notNull("action", action);
        this.getHtmlForm().setActionAttribute(action);
    }

    public String jsxGet_method() {
        return this.getHtmlForm().getMethodAttribute();
    }

    public void jsxSet_method(String method) {
        WebAssert.notNull("method", method);
        this.getHtmlForm().setMethodAttribute(method);
    }

    public String jsxGet_target() {
        return this.getHtmlForm().getTargetAttribute();
    }

    public Object jsxGet_onsubmit() {
        return this.getEventHandlerProp("onsubmit");
    }

    public void jsxSet_onsubmit(Object onsubmit) {
        this.setEventHandlerProp("onsubmit", onsubmit);
    }

    public void jsxSet_target(String target) {
        WebAssert.notNull("target", target);
        this.getHtmlForm().setTargetAttribute(target);
    }

    public String jsxGet_encoding() {
        return this.getHtmlForm().getEnctypeAttribute();
    }

    public void jsxSet_encoding(String encoding) {
        WebAssert.notNull("encoding", encoding);
        this.getHtmlForm().setEnctypeAttribute(encoding);
    }

    private HtmlForm getHtmlForm() {
        return (HtmlForm)this.getHtmlElementOrDie();
    }

    public void jsxFunction_submit() throws IOException {
        this.getHtmlForm().submit(null);
    }

    public void jsxFunction_reset() {
        this.getHtmlForm().reset();
    }

    protected Object getWithPreemption(String name) {
        HtmlForm form = this.getHtmlForm();
        SgmlPage page = form.getPage();
        if (page instanceof HtmlPage) {
            List<HtmlElement> elements = ((HtmlPage)page).getElementsByIdAndOrName(name);
            if (elements.isEmpty()) {
                return NOT_FOUND;
            }
            if (elements.size() == 1) {
                HtmlElement element = elements.get(0);
                String tagName = element.getTagName();
                String type = element.getAttribute("type").toLowerCase();
                if ("input".equals(tagName) && !"image".equals(type) || "button".equals(tagName) || "select".equals(tagName) || "textarea".equals(tagName) || "img".equals(tagName)) {
                    if (form.isAncestorOf(element) || form.getLostChildren().contains(element)) {
                        return this.getScriptableFor(element);
                    }
                } else {
                    return NOT_FOUND;
                }
            }
        }
        HTMLCollection collection = new HTMLCollection(this);
        String xpath = ".//*[(@name = '" + name + "' or @id = '" + name + "')" + " and ((name() = 'input' and translate(@type, 'IMAGE', 'image') != 'image') or name() = 'button'" + " or name() = 'select' or name() = 'textarea')]";
        collection.init(form, xpath);
        int length = collection.jsxGet_length();
        if (length == 0) {
            collection = new HTMLCollection(this);
            String xpath2 = ".//*[(@name = '" + name + "' or @id = '" + name + "')" + " and name() = 'img']";
            collection.init(form, xpath2);
        }
        Object result = collection;
        length = collection.jsxGet_length();
        if (length == 0) {
            result = NOT_FOUND;
        } else if (length == 1) {
            result = collection.get(0, (Scriptable)collection);
        }
        return result;
    }

    public Object get(int index, Scriptable start) {
        if (this.getDomNodeOrNull() == null) {
            return NOT_FOUND;
        }
        return this.jsxGet_elements().get(index, (Scriptable)((HTMLFormElement)start).jsxGet_elements());
    }
}

