=begin comment

Aspose.3D Cloud API Reference

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: 3.0

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package AsposeThreeDCloud::ThreeDCloudApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use AsposeThreeDCloud::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'AsposeThreeDCloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = AsposeThreeDCloud::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# copy_file
#
# Copy file
# 
# @param string $src_path Source file path e.g. &#39;/folder/file.ext&#39; (required)
# @param string $dest_path Destination file path (required)
# @param string $src_storage_name Source storage name (optional)
# @param string $dest_storage_name Destination storage name (optional)
# @param string $version_id File version ID to copy (optional)
{
    my $params = {
    'src_path' => {
        data_type => 'string',
        description => 'Source file path e.g. &#39;/folder/file.ext&#39;',
        required => '1',
    },
    'dest_path' => {
        data_type => 'string',
        description => 'Destination file path',
        required => '1',
    },
    'src_storage_name' => {
        data_type => 'string',
        description => 'Source storage name',
        required => '0',
    },
    'dest_storage_name' => {
        data_type => 'string',
        description => 'Destination storage name',
        required => '0',
    },
    'version_id' => {
        data_type => 'string',
        description => 'File version ID to copy',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'copy_file' } = { 
    	summary => 'Copy file',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub copy_file {
    my ($self, %args) = @_;

    # verify the required parameter 'src_path' is set
    unless (exists $args{'src_path'}) {
      croak("Missing the required parameter 'src_path' when calling copy_file");
    }

    # verify the required parameter 'dest_path' is set
    unless (exists $args{'dest_path'}) {
      croak("Missing the required parameter 'dest_path' when calling copy_file");
    }

    # parse inputs
    my $_resource_path = '/3d/storage/file/copy/{srcPath}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'dest_path'}) {
        $query_params->{'destPath'} = $self->{api_client}->to_query_value($args{'dest_path'});
    }

    # query params
    if ( exists $args{'src_storage_name'}) {
        $query_params->{'srcStorageName'} = $self->{api_client}->to_query_value($args{'src_storage_name'});
    }

    # query params
    if ( exists $args{'dest_storage_name'}) {
        $query_params->{'destStorageName'} = $self->{api_client}->to_query_value($args{'dest_storage_name'});
    }

    # query params
    if ( exists $args{'version_id'}) {
        $query_params->{'versionId'} = $self->{api_client}->to_query_value($args{'version_id'});
    }

    # path params
    if ( exists $args{'src_path'}) {
        my $_base_variable = "{" . "srcPath" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'src_path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# copy_folder
#
# Copy folder
# 
# @param string $src_path Source folder path e.g. &#39;/src&#39; (required)
# @param string $dest_path Destination folder path e.g. &#39;/dst&#39; (required)
# @param string $src_storage_name Source storage name (optional)
# @param string $dest_storage_name Destination storage name (optional)
{
    my $params = {
    'src_path' => {
        data_type => 'string',
        description => 'Source folder path e.g. &#39;/src&#39;',
        required => '1',
    },
    'dest_path' => {
        data_type => 'string',
        description => 'Destination folder path e.g. &#39;/dst&#39;',
        required => '1',
    },
    'src_storage_name' => {
        data_type => 'string',
        description => 'Source storage name',
        required => '0',
    },
    'dest_storage_name' => {
        data_type => 'string',
        description => 'Destination storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'copy_folder' } = { 
    	summary => 'Copy folder',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub copy_folder {
    my ($self, %args) = @_;

    # verify the required parameter 'src_path' is set
    unless (exists $args{'src_path'}) {
      croak("Missing the required parameter 'src_path' when calling copy_folder");
    }

    # verify the required parameter 'dest_path' is set
    unless (exists $args{'dest_path'}) {
      croak("Missing the required parameter 'dest_path' when calling copy_folder");
    }

    # parse inputs
    my $_resource_path = '/3d/storage/folder/copy/{srcPath}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'dest_path'}) {
        $query_params->{'destPath'} = $self->{api_client}->to_query_value($args{'dest_path'});
    }

    # query params
    if ( exists $args{'src_storage_name'}) {
        $query_params->{'srcStorageName'} = $self->{api_client}->to_query_value($args{'src_storage_name'});
    }

    # query params
    if ( exists $args{'dest_storage_name'}) {
        $query_params->{'destStorageName'} = $self->{api_client}->to_query_value($args{'dest_storage_name'});
    }

    # path params
    if ( exists $args{'src_path'}) {
        my $_base_variable = "{" . "srcPath" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'src_path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# create_folder
#
# Create the folder
# 
# @param string $path Folder path to create e.g. &#39;folder_1/folder_2/&#39; (required)
# @param string $storage_name Storage name (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'Folder path to create e.g. &#39;folder_1/folder_2/&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'create_folder' } = { 
    	summary => 'Create the folder',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub create_folder {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'}) {
      croak("Missing the required parameter 'path' when calling create_folder");
    }

    # parse inputs
    my $_resource_path = '/3d/storage/folder/{path}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# delete_file
#
# Delete file
# 
# @param string $path File path e.g. &#39;/folder/file.ext&#39; (required)
# @param string $storage_name Storage name (optional)
# @param string $version_id File version ID to delete (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'File path e.g. &#39;/folder/file.ext&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    'version_id' => {
        data_type => 'string',
        description => 'File version ID to delete',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_file' } = { 
    	summary => 'Delete file',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub delete_file {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'}) {
      croak("Missing the required parameter 'path' when calling delete_file");
    }

    # parse inputs
    my $_resource_path = '/3d/storage/file/{path}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # query params
    if ( exists $args{'version_id'}) {
        $query_params->{'versionId'} = $self->{api_client}->to_query_value($args{'version_id'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# delete_folder
#
# Delete folder
# 
# @param string $path Folder path e.g. &#39;/folder&#39; (required)
# @param string $storage_name Storage name (optional)
# @param boolean $recursive Enable to delete folders, subfolders and files (optional, default to false)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'Folder path e.g. &#39;/folder&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    'recursive' => {
        data_type => 'boolean',
        description => 'Enable to delete folders, subfolders and files',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_folder' } = { 
    	summary => 'Delete folder',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub delete_folder {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'}) {
      croak("Missing the required parameter 'path' when calling delete_folder");
    }

    # parse inputs
    my $_resource_path = '/3d/storage/folder/{path}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # query params
    if ( exists $args{'recursive'}) {
        $query_params->{'recursive'} = $self->{api_client}->to_query_value($args{'recursive'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# delete_nodes
#
# Delete nodes from scene,nodes are addressed by Object Addressing Path
# 
# @param string $name The name of the source file. (required)
# @param string $objectaddressingpath The object addressing path. (required)
# @param string $folder The folder of the source file. (optional)
# @param string $storage The storage type (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The name of the source file.',
        required => '1',
    },
    'objectaddressingpath' => {
        data_type => 'string',
        description => 'The object addressing path.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The folder of the source file.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'The storage type',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'delete_nodes' } = { 
    	summary => 'Delete nodes from scene,nodes are addressed by Object Addressing Path',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub delete_nodes {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling delete_nodes");
    }

    # verify the required parameter 'objectaddressingpath' is set
    unless (exists $args{'objectaddressingpath'}) {
      croak("Missing the required parameter 'objectaddressingpath' when calling delete_nodes");
    }

    # parse inputs
    my $_resource_path = '/3d/nodes';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'name'}) {
        $query_params->{'name'} = $self->{api_client}->to_query_value($args{'name'});
    }

    # query params
    if ( exists $args{'objectaddressingpath'}) {
        $query_params->{'objectaddressingpath'} = $self->{api_client}->to_query_value($args{'objectaddressingpath'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# download_file
#
# Download file
# 
# @param string $path File path e.g. &#39;/folder/file.ext&#39; (required)
# @param string $storage_name Storage name (optional)
# @param string $version_id File version ID to download (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'File path e.g. &#39;/folder/file.ext&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    'version_id' => {
        data_type => 'string',
        description => 'File version ID to download',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'download_file' } = { 
    	summary => 'Download file',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub download_file {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'}) {
      croak("Missing the required parameter 'path' when calling download_file");
    }

    # parse inputs
    my $_resource_path = '/3d/storage/file/{path}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # query params
    if ( exists $args{'version_id'}) {
        $query_params->{'versionId'} = $self->{api_client}->to_query_value($args{'version_id'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# get_disc_usage
#
# Get disc usage
# 
# @param string $storage_name Storage name (optional)
{
    my $params = {
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_disc_usage' } = { 
    	summary => 'Get disc usage',
        params => $params,
        returns => 'DiscUsage',
        };
}
# @return DiscUsage
#
sub get_disc_usage {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/3d/storage/disc';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('DiscUsage', $response);
    return $_response_object;
}

#
# get_file_versions
#
# Get file versions
# 
# @param string $path File path e.g. &#39;/file.ext&#39; (required)
# @param string $storage_name Storage name (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'File path e.g. &#39;/file.ext&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_file_versions' } = { 
    	summary => 'Get file versions',
        params => $params,
        returns => 'FileVersions',
        };
}
# @return FileVersions
#
sub get_file_versions {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'}) {
      croak("Missing the required parameter 'path' when calling get_file_versions");
    }

    # parse inputs
    my $_resource_path = '/3d/storage/version/{path}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FileVersions', $response);
    return $_response_object;
}

#
# get_files_list
#
# Get all files and folders within a folder
# 
# @param string $path Folder path e.g. &#39;/folder&#39; (required)
# @param string $storage_name Storage name (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'Folder path e.g. &#39;/folder&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_files_list' } = { 
    	summary => 'Get all files and folders within a folder',
        params => $params,
        returns => 'FilesList',
        };
}
# @return FilesList
#
sub get_files_list {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'}) {
      croak("Missing the required parameter 'path' when calling get_files_list");
    }

    # parse inputs
    my $_resource_path = '/3d/storage/folder/{path}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FilesList', $response);
    return $_response_object;
}

#
# move_file
#
# Move file
# 
# @param string $src_path Source file path e.g. &#39;/src.ext&#39; (required)
# @param string $dest_path Destination file path e.g. &#39;/dest.ext&#39; (required)
# @param string $src_storage_name Source storage name (optional)
# @param string $dest_storage_name Destination storage name (optional)
# @param string $version_id File version ID to move (optional)
{
    my $params = {
    'src_path' => {
        data_type => 'string',
        description => 'Source file path e.g. &#39;/src.ext&#39;',
        required => '1',
    },
    'dest_path' => {
        data_type => 'string',
        description => 'Destination file path e.g. &#39;/dest.ext&#39;',
        required => '1',
    },
    'src_storage_name' => {
        data_type => 'string',
        description => 'Source storage name',
        required => '0',
    },
    'dest_storage_name' => {
        data_type => 'string',
        description => 'Destination storage name',
        required => '0',
    },
    'version_id' => {
        data_type => 'string',
        description => 'File version ID to move',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'move_file' } = { 
    	summary => 'Move file',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub move_file {
    my ($self, %args) = @_;

    # verify the required parameter 'src_path' is set
    unless (exists $args{'src_path'}) {
      croak("Missing the required parameter 'src_path' when calling move_file");
    }

    # verify the required parameter 'dest_path' is set
    unless (exists $args{'dest_path'}) {
      croak("Missing the required parameter 'dest_path' when calling move_file");
    }

    # parse inputs
    my $_resource_path = '/3d/storage/file/move/{srcPath}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'dest_path'}) {
        $query_params->{'destPath'} = $self->{api_client}->to_query_value($args{'dest_path'});
    }

    # query params
    if ( exists $args{'src_storage_name'}) {
        $query_params->{'srcStorageName'} = $self->{api_client}->to_query_value($args{'src_storage_name'});
    }

    # query params
    if ( exists $args{'dest_storage_name'}) {
        $query_params->{'destStorageName'} = $self->{api_client}->to_query_value($args{'dest_storage_name'});
    }

    # query params
    if ( exists $args{'version_id'}) {
        $query_params->{'versionId'} = $self->{api_client}->to_query_value($args{'version_id'});
    }

    # path params
    if ( exists $args{'src_path'}) {
        my $_base_variable = "{" . "srcPath" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'src_path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# move_folder
#
# Move folder
# 
# @param string $src_path Folder path to move e.g. &#39;/folder&#39; (required)
# @param string $dest_path Destination folder path to move to e.g &#39;/dst&#39; (required)
# @param string $src_storage_name Source storage name (optional)
# @param string $dest_storage_name Destination storage name (optional)
{
    my $params = {
    'src_path' => {
        data_type => 'string',
        description => 'Folder path to move e.g. &#39;/folder&#39;',
        required => '1',
    },
    'dest_path' => {
        data_type => 'string',
        description => 'Destination folder path to move to e.g &#39;/dst&#39;',
        required => '1',
    },
    'src_storage_name' => {
        data_type => 'string',
        description => 'Source storage name',
        required => '0',
    },
    'dest_storage_name' => {
        data_type => 'string',
        description => 'Destination storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'move_folder' } = { 
    	summary => 'Move folder',
        params => $params,
        returns => undef,
        };
}
# @return void
#
sub move_folder {
    my ($self, %args) = @_;

    # verify the required parameter 'src_path' is set
    unless (exists $args{'src_path'}) {
      croak("Missing the required parameter 'src_path' when calling move_folder");
    }

    # verify the required parameter 'dest_path' is set
    unless (exists $args{'dest_path'}) {
      croak("Missing the required parameter 'dest_path' when calling move_folder");
    }

    # parse inputs
    my $_resource_path = '/3d/storage/folder/move/{srcPath}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'dest_path'}) {
        $query_params->{'destPath'} = $self->{api_client}->to_query_value($args{'dest_path'});
    }

    # query params
    if ( exists $args{'src_storage_name'}) {
        $query_params->{'srcStorageName'} = $self->{api_client}->to_query_value($args{'src_storage_name'});
    }

    # query params
    if ( exists $args{'dest_storage_name'}) {
        $query_params->{'destStorageName'} = $self->{api_client}->to_query_value($args{'dest_storage_name'});
    }

    # path params
    if ( exists $args{'src_path'}) {
        my $_base_variable = "{" . "srcPath" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'src_path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    return;
}

#
# o_auth_post
#
# Get Access token
# 
# @param string $grant_type Grant Type (required)
# @param string $client_id App SID (required)
# @param string $client_secret App Key (required)
{
    my $params = {
    'grant_type' => {
        data_type => 'string',
        description => 'Grant Type',
        required => '1',
    },
    'client_id' => {
        data_type => 'string',
        description => 'App SID',
        required => '1',
    },
    'client_secret' => {
        data_type => 'string',
        description => 'App Key',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'o_auth_post' } = { 
    	summary => 'Get Access token',
        params => $params,
        returns => 'AccessTokenResponse',
        };
}
# @return AccessTokenResponse
#
sub o_auth_post {
    my ($self, %args) = @_;

    # verify the required parameter 'grant_type' is set
    unless (exists $args{'grant_type'}) {
      croak("Missing the required parameter 'grant_type' when calling o_auth_post");
    }

    # verify the required parameter 'client_id' is set
    unless (exists $args{'client_id'}) {
      croak("Missing the required parameter 'client_id' when calling o_auth_post");
    }

    # verify the required parameter 'client_secret' is set
    unless (exists $args{'client_secret'}) {
      croak("Missing the required parameter 'client_secret' when calling o_auth_post");
    }

    # parse inputs
    my $_resource_path = '/connect/token';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/x-www-form-urlencoded');

    # form params
    if ( exists $args{'grant_type'} ) {
                $form_params->{'grant_type'} = $self->{api_client}->to_form_value($args{'grant_type'});
    }
    
    # form params
    if ( exists $args{'client_id'} ) {
                $form_params->{'client_id'} = $self->{api_client}->to_form_value($args{'client_id'});
    }
    
    # form params
    if ( exists $args{'client_secret'} ) {
                $form_params->{'client_secret'} = $self->{api_client}->to_form_value($args{'client_secret'});
    }
    
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('AccessTokenResponse', $response);
    return $_response_object;
}

#
# object_exists
#
# Check if file or folder exists
# 
# @param string $path File or folder path e.g. &#39;/file.ext&#39; or &#39;/folder&#39; (required)
# @param string $storage_name Storage name (optional)
# @param string $version_id File version ID (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'File or folder path e.g. &#39;/file.ext&#39; or &#39;/folder&#39;',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    'version_id' => {
        data_type => 'string',
        description => 'File version ID',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'object_exists' } = { 
    	summary => 'Check if file or folder exists',
        params => $params,
        returns => 'ObjectExist',
        };
}
# @return ObjectExist
#
sub object_exists {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'}) {
      croak("Missing the required parameter 'path' when calling object_exists");
    }

    # parse inputs
    my $_resource_path = '/3d/storage/exist/{path}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # query params
    if ( exists $args{'version_id'}) {
        $query_params->{'versionId'} = $self->{api_client}->to_query_value($args{'version_id'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ObjectExist', $response);
    return $_response_object;
}

#
# post_convert_by_format
#
# Convert file on server to other formats with fileformat parameter             
# 
# @param string $name The name of the source file. (required)
# @param string $newformat The format of the new file. (required)
# @param string $newfilename The name of the new file. (required)
# @param string $folder The folder of the source file. (optional)
# @param boolean $is_overwrite Overwrite the source file? true or false. (optional, default to false)
# @param string $storage The storage type. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The name of the source file.',
        required => '1',
    },
    'newformat' => {
        data_type => 'string',
        description => 'The format of the new file.',
        required => '1',
    },
    'newfilename' => {
        data_type => 'string',
        description => 'The name of the new file.',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The folder of the source file.',
        required => '0',
    },
    'is_overwrite' => {
        data_type => 'boolean',
        description => 'Overwrite the source file? true or false.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'The storage type.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_convert_by_format' } = { 
    	summary => 'Convert file on server to other formats with fileformat parameter             ',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_convert_by_format {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_convert_by_format");
    }

    # verify the required parameter 'newformat' is set
    unless (exists $args{'newformat'}) {
      croak("Missing the required parameter 'newformat' when calling post_convert_by_format");
    }

    # verify the required parameter 'newfilename' is set
    unless (exists $args{'newfilename'}) {
      croak("Missing the required parameter 'newfilename' when calling post_convert_by_format");
    }

    # parse inputs
    my $_resource_path = '/3d/saveas/newformat';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'name'}) {
        $query_params->{'name'} = $self->{api_client}->to_query_value($args{'name'});
    }

    # query params
    if ( exists $args{'newformat'}) {
        $query_params->{'newformat'} = $self->{api_client}->to_query_value($args{'newformat'});
    }

    # query params
    if ( exists $args{'newfilename'}) {
        $query_params->{'newfilename'} = $self->{api_client}->to_query_value($args{'newfilename'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'is_overwrite'}) {
        $query_params->{'IsOverwrite'} = $self->{api_client}->to_query_value($args{'is_overwrite'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_convert_by_opt
#
# Convert file on server to other formats with saveOption parameter             
# 
# @param string $name The name of the source file. (required)
# @param SaveOptions $save_options The saveOptions to save the file (required)
# @param string $newfilename The name of the new file (required)
# @param string $folder The folder of the source file (optional)
# @param boolean $is_overwrite Overwrite the source file? true or false (optional, default to false)
# @param string $storage The storage type (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The name of the source file.',
        required => '1',
    },
    'save_options' => {
        data_type => 'SaveOptions',
        description => 'The saveOptions to save the file',
        required => '1',
    },
    'newfilename' => {
        data_type => 'string',
        description => 'The name of the new file',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The folder of the source file',
        required => '0',
    },
    'is_overwrite' => {
        data_type => 'boolean',
        description => 'Overwrite the source file? true or false',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'The storage type',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_convert_by_opt' } = { 
    	summary => 'Convert file on server to other formats with saveOption parameter             ',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_convert_by_opt {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_convert_by_opt");
    }

    # verify the required parameter 'save_options' is set
    unless (exists $args{'save_options'}) {
      croak("Missing the required parameter 'save_options' when calling post_convert_by_opt");
    }

    # verify the required parameter 'newfilename' is set
    unless (exists $args{'newfilename'}) {
      croak("Missing the required parameter 'newfilename' when calling post_convert_by_opt");
    }

    # parse inputs
    my $_resource_path = '/3d/saveas/saveoption';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'name'}) {
        $query_params->{'name'} = $self->{api_client}->to_query_value($args{'name'});
    }

    # query params
    if ( exists $args{'newfilename'}) {
        $query_params->{'newfilename'} = $self->{api_client}->to_query_value($args{'newfilename'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'is_overwrite'}) {
        $query_params->{'IsOverwrite'} = $self->{api_client}->to_query_value($args{'is_overwrite'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    my $_body_data;
    # body params
    if ( exists $args{'save_options'}) {
        $_body_data = $args{'save_options'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_create
#
# Create new file with specified format.             
# 
# @param string $format The format of the new file. (required)
{
    my $params = {
    'format' => {
        data_type => 'string',
        description => 'The format of the new file.',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_create' } = { 
    	summary => 'Create new file with specified format.             ',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_create {
    my ($self, %args) = @_;

    # verify the required parameter 'format' is set
    unless (exists $args{'format'}) {
      croak("Missing the required parameter 'format' when calling post_create");
    }

    # parse inputs
    my $_resource_path = '/3d/new';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('multipart/form-data');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'format'}) {
        $query_params->{'format'} = $self->{api_client}->to_query_value($args{'format'});
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_model
#
# Parametric Modeling, Create a Entity with size and located in ...
# 
# @param string $name The name of the source file. (required)
# @param ModelData $modeldata ModelData struct. (required)
# @param string $newformat new format of the source file. (optional)
# @param string $folder The folder of the source file. (optional)
# @param string $storage The storage type (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The name of the source file.',
        required => '1',
    },
    'modeldata' => {
        data_type => 'ModelData',
        description => 'ModelData struct.',
        required => '1',
    },
    'newformat' => {
        data_type => 'string',
        description => 'new format of the source file.',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The folder of the source file.',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'The storage type',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_model' } = { 
    	summary => 'Parametric Modeling, Create a Entity with size and located in ...',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_model {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_model");
    }

    # verify the required parameter 'modeldata' is set
    unless (exists $args{'modeldata'}) {
      croak("Missing the required parameter 'modeldata' when calling post_model");
    }

    # parse inputs
    my $_resource_path = '/3d/root';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'name'}) {
        $query_params->{'name'} = $self->{api_client}->to_query_value($args{'name'});
    }

    # query params
    if ( exists $args{'newformat'}) {
        $query_params->{'newformat'} = $self->{api_client}->to_query_value($args{'newformat'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    my $_body_data;
    # body params
    if ( exists $args{'modeldata'}) {
        $_body_data = $args{'modeldata'};
    }

    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_pdf_raw_data
#
# Extract raw data(without any modification) from a password protected PDF file             
# 
# @param string $name The PDF file&#39;s mame (required)
# @param string $multifileprefix The file name for generated raw date (required)
# @param string $password The password to open the PDF (optional)
# @param string $folder The folder for source file (optional)
# @param string $storage The storage type (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The PDF file&#39;s mame',
        required => '1',
    },
    'multifileprefix' => {
        data_type => 'string',
        description => 'The file name for generated raw date',
        required => '1',
    },
    'password' => {
        data_type => 'string',
        description => 'The password to open the PDF',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The folder for source file',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'The storage type',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_pdf_raw_data' } = { 
    	summary => 'Extract raw data(without any modification) from a password protected PDF file             ',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_pdf_raw_data {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_pdf_raw_data");
    }

    # verify the required parameter 'multifileprefix' is set
    unless (exists $args{'multifileprefix'}) {
      croak("Missing the required parameter 'multifileprefix' when calling post_pdf_raw_data");
    }

    # parse inputs
    my $_resource_path = '/3d/extract/rawdata';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'name'}) {
        $query_params->{'name'} = $self->{api_client}->to_query_value($args{'name'});
    }

    # query params
    if ( exists $args{'multifileprefix'}) {
        $query_params->{'multifileprefix'} = $self->{api_client}->to_query_value($args{'multifileprefix'});
    }

    # query params
    if ( exists $args{'password'}) {
        $query_params->{'password'} = $self->{api_client}->to_query_value($args{'password'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_save_as_part
#
# Convert part of the file into different format
# 
# @param string $name The name of the source file (required)
# @param string $objectaddressingpath The object addressing path (required)
# @param string $newformat The format of the new file (required)
# @param string $newfilename The name of the new file (required)
# @param string $folder The folder of the source file (optional)
# @param boolean $is_overwrite Overwrite the source file? true or false (optional, default to false)
# @param string $storage The storage type (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The name of the source file',
        required => '1',
    },
    'objectaddressingpath' => {
        data_type => 'string',
        description => 'The object addressing path',
        required => '1',
    },
    'newformat' => {
        data_type => 'string',
        description => 'The format of the new file',
        required => '1',
    },
    'newfilename' => {
        data_type => 'string',
        description => 'The name of the new file',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The folder of the source file',
        required => '0',
    },
    'is_overwrite' => {
        data_type => 'boolean',
        description => 'Overwrite the source file? true or false',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'The storage type',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_save_as_part' } = { 
    	summary => 'Convert part of the file into different format',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_save_as_part {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_save_as_part");
    }

    # verify the required parameter 'objectaddressingpath' is set
    unless (exists $args{'objectaddressingpath'}) {
      croak("Missing the required parameter 'objectaddressingpath' when calling post_save_as_part");
    }

    # verify the required parameter 'newformat' is set
    unless (exists $args{'newformat'}) {
      croak("Missing the required parameter 'newformat' when calling post_save_as_part");
    }

    # verify the required parameter 'newfilename' is set
    unless (exists $args{'newfilename'}) {
      croak("Missing the required parameter 'newfilename' when calling post_save_as_part");
    }

    # parse inputs
    my $_resource_path = '/3d/saveas/part';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'name'}) {
        $query_params->{'name'} = $self->{api_client}->to_query_value($args{'name'});
    }

    # query params
    if ( exists $args{'objectaddressingpath'}) {
        $query_params->{'objectaddressingpath'} = $self->{api_client}->to_query_value($args{'objectaddressingpath'});
    }

    # query params
    if ( exists $args{'newformat'}) {
        $query_params->{'newformat'} = $self->{api_client}->to_query_value($args{'newformat'});
    }

    # query params
    if ( exists $args{'newfilename'}) {
        $query_params->{'newfilename'} = $self->{api_client}->to_query_value($args{'newfilename'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'is_overwrite'}) {
        $query_params->{'IsOverwrite'} = $self->{api_client}->to_query_value($args{'is_overwrite'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_scene_to_file
#
# Extract and save in different format             
# 
# @param string $name The PDF file&#39;s mame (required)
# @param string $multifileprefix The file name for extracted scene (required)
# @param string $newformat The format of new file (optional)
# @param string $password The password to open the PDF (optional)
# @param string $folder The folder for source file (optional)
# @param string $storage The storage type (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The PDF file&#39;s mame',
        required => '1',
    },
    'multifileprefix' => {
        data_type => 'string',
        description => 'The file name for extracted scene',
        required => '1',
    },
    'newformat' => {
        data_type => 'string',
        description => 'The format of new file',
        required => '0',
    },
    'password' => {
        data_type => 'string',
        description => 'The password to open the PDF',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => 'The folder for source file',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'The storage type',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_scene_to_file' } = { 
    	summary => 'Extract and save in different format             ',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_scene_to_file {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_scene_to_file");
    }

    # verify the required parameter 'multifileprefix' is set
    unless (exists $args{'multifileprefix'}) {
      croak("Missing the required parameter 'multifileprefix' when calling post_scene_to_file");
    }

    # parse inputs
    my $_resource_path = '/3d/extract/scene';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'name'}) {
        $query_params->{'name'} = $self->{api_client}->to_query_value($args{'name'});
    }

    # query params
    if ( exists $args{'multifileprefix'}) {
        $query_params->{'multifileprefix'} = $self->{api_client}->to_query_value($args{'multifileprefix'});
    }

    # query params
    if ( exists $args{'newformat'}) {
        $query_params->{'newformat'} = $self->{api_client}->to_query_value($args{'newformat'});
    }

    # query params
    if ( exists $args{'password'}) {
        $query_params->{'password'} = $self->{api_client}->to_query_value($args{'password'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_triangulate_new
#
# Triangulate whole file and save to the different file
# 
# @param string $name The file&#39;s mame (required)
# @param string $newfilename The new file&#39;s mame (required)
# @param string $newformat The new file&#39;s format (required)
# @param string $folder The folder for source file (optional)
# @param string $storage The storage type (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The file&#39;s mame',
        required => '1',
    },
    'newfilename' => {
        data_type => 'string',
        description => 'The new file&#39;s mame',
        required => '1',
    },
    'newformat' => {
        data_type => 'string',
        description => 'The new file&#39;s format',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The folder for source file',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'The storage type',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_triangulate_new' } = { 
    	summary => 'Triangulate whole file and save to the different file',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_triangulate_new {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_triangulate_new");
    }

    # verify the required parameter 'newfilename' is set
    unless (exists $args{'newfilename'}) {
      croak("Missing the required parameter 'newfilename' when calling post_triangulate_new");
    }

    # verify the required parameter 'newformat' is set
    unless (exists $args{'newformat'}) {
      croak("Missing the required parameter 'newformat' when calling post_triangulate_new");
    }

    # parse inputs
    my $_resource_path = '/3d/triangulate/new';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'name'}) {
        $query_params->{'name'} = $self->{api_client}->to_query_value($args{'name'});
    }

    # query params
    if ( exists $args{'newfilename'}) {
        $query_params->{'newfilename'} = $self->{api_client}->to_query_value($args{'newfilename'});
    }

    # query params
    if ( exists $args{'newformat'}) {
        $query_params->{'newformat'} = $self->{api_client}->to_query_value($args{'newformat'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# post_triangulate_original
#
# Triangulate whole file and save to original file
# 
# @param string $name The file&#39;s mame (required)
# @param string $folder The folder for source file (optional)
# @param string $storage The storage type (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => 'The file&#39;s mame',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => 'The folder for source file',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'The storage type',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'post_triangulate_original' } = { 
    	summary => 'Triangulate whole file and save to original file',
        params => $params,
        returns => 'File',
        };
}
# @return File
#
sub post_triangulate_original {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling post_triangulate_original");
    }

    # parse inputs
    my $_resource_path = '/3d/triangulate/original';

    my $_method = 'POST';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'name'}) {
        $query_params->{'name'} = $self->{api_client}->to_query_value($args{'name'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('File', $response);
    return $_response_object;
}

#
# storage_exists
#
# Check if storage exists
# 
# @param string $storage_name Storage name (required)
{
    my $params = {
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'storage_exists' } = { 
    	summary => 'Check if storage exists',
        params => $params,
        returns => 'StorageExist',
        };
}
# @return StorageExist
#
sub storage_exists {
    my ($self, %args) = @_;

    # verify the required parameter 'storage_name' is set
    unless (exists $args{'storage_name'}) {
      croak("Missing the required parameter 'storage_name' when calling storage_exists");
    }

    # parse inputs
    my $_resource_path = '/3d/storage/{storageName}/exist';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # path params
    if ( exists $args{'storage_name'}) {
        my $_base_variable = "{" . "storageName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'storage_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('StorageExist', $response);
    return $_response_object;
}

#
# upload_file
#
# Upload file
# 
# @param string $path Path where to upload including filename and extension e.g. /file.ext or /Folder 1/file.ext             If the content is multipart and path does not contains the file name it tries to get them from filename parameter             from Content-Disposition header.              (required)
# @param File $file File to upload (required)
# @param string $storage_name Storage name (optional)
{
    my $params = {
    'path' => {
        data_type => 'string',
        description => 'Path where to upload including filename and extension e.g. /file.ext or /Folder 1/file.ext             If the content is multipart and path does not contains the file name it tries to get them from filename parameter             from Content-Disposition header.             ',
        required => '1',
    },
    'file' => {
        data_type => 'File',
        description => 'File to upload',
        required => '1',
    },
    'storage_name' => {
        data_type => 'string',
        description => 'Storage name',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'upload_file' } = { 
    	summary => 'Upload file',
        params => $params,
        returns => 'FilesUploadResult',
        };
}
# @return FilesUploadResult
#
sub upload_file {
    my ($self, %args) = @_;

    # verify the required parameter 'path' is set
    unless (exists $args{'path'}) {
      croak("Missing the required parameter 'path' when calling upload_file");
    }

    # verify the required parameter 'file' is set
    unless (exists $args{'file'}) {
      croak("Missing the required parameter 'file' when calling upload_file");
    }

    # parse inputs
    my $_resource_path = '/3d/storage/file/{path}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if ( exists $args{'storage_name'}) {
        $query_params->{'storageName'} = $self->{api_client}->to_query_value($args{'storage_name'});
    }

    # path params
    if ( exists $args{'path'}) {
        my $_base_variable = "{" . "path" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'path'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # form params
    if ( exists $args{'file'} ) {
        $form_params->{'File'} = [] unless defined $form_params->{'File'};
        push @{$form_params->{'File'}}, $args{'file'};
            }
    
    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(JWT )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('FilesUploadResult', $response);
    return $_response_object;
}

1;
