#  Makefile.PL for WebMod::Err
#
package WebDyne::Err;


#  Compiler Pragma
#
use strict qw(vars);


#  External Modules
#
use ExtUtils::MakeMaker;



#  All done, init finished
#
#------------------------------------------------------------------------------


#  Create the Makefile
#
WriteMakefile(

    NAME				   =>  __PACKAGE__,
    VERSION_FROM			   =>  'VERSION.pm',
    PM					   =>  {
	'Err.pm'			   =>  '$(INST_LIBDIR)/Err.pm',
	'VERSION.pm'			   =>  '$(INST_LIBDIR)/Err/VERSION.pm',
	'Constant.pm'			   =>  '$(INST_LIBDIR)/Err/Constant.pm',
	'LICENSE'			   =>  '$(INST_LIBDIR)/Err/LICENSE',
	'error.psp'			   =>  '$(INST_LIBDIR)/Err/error.psp'
    },

    'dist'				   =>  {
	COMPRESS			   =>  'gzip -9f',
	SUFFIX				   =>  '.gz'
    },

    'depend'				   =>  {
	Makefile			   =>  '$(VERSION_FROM)'
    },

    'macro'				 =>  {
        COPYRIGHT			 =>  'Copyright (c) 2003 Andrew Speer, All rights reserved',
    	LICENSE				 =>  'GPL: GNU General Public License',
    	statl				 =>  'g',
    },

    ($] >= 5.005 ?
      (#ABSTRACT_FROM 			 => 'Err.pm',
       AUTHOR     			 => 'Andrew Speer <andrew.speer@isolutions.com.au>') : ()
    ),

);

